# Python Trending Weekly #32 (2023-12-23)

Welcome to the Python Trending Weekly, a weekly newsletter about Python, AI and general programming techniques, with the majority links in English and a small portion in Chinese. 

The [original version](https://pythoncat.top/posts/2023-12-23-weekly) of the weekly was written in Chinese. What you are reading here is mostly translated by LLMs. 

**Substack Channel** : [Click to subscribe](https://pythoncat.substack.com/s/python-trending-weekly) 

## 🦄Articles & Tutorials

1. [How many CPUs can actually be used in parallel programs?](https://pythonspeed.com/articles/cpu-thread-pool-size/)

In CPU-intensive tasks, the size of the thread/process pool is usually set according to the number of CPU cores. But how do you determine how many CPUs are actually best to use? What are physical and logical CPUs? How do you test how many CPUs are appropriate to set?

2. [Where Do Your Python Packages Go?](https://frostming.com/2019/03-13/where-do-your-packages-go/)

Python beginners often encounter package-related issues, one of the main reasons being that they are not clear about how Python finds packages. This article introduces the order in which Python searches for packages, how it installs packages, the role of virtual environments, and how the way a script is run affects the search path.

3. [Removing C API functions from CPython](https://vstinner.github.io/remove-c-api-funcs-313.html)

Victor Stinner, a prolific core developer, removed over 300 private C API functions in Python 3.13 alpha 1, received some negative feedback, and restored 50 of them in alpha 2. The post documents what he did and the feedback he got from the community.

4. [Python Gotcha: The Problem with Copying Lists](https://andrewwegner.com/python-gotcha-list-copy.html)

How do you create a copy of a mutable object like a list? For one-dimensional lists, the article introduces three methods; however, for two-dimensional lists, the issue of shallow copy versus deep copy arises, and **copy.deepcopy()** must be used. (Note: The author's "**Python Gotcha** " series of short articles introduces some usage considerations for Python.)

5. [Best Practices for asyncio Task Cancellation](https://superfastpython.com/asyncio-task-cancellation-best-practices/)

Asyncio tasks can be canceled manually or automatically. This article introduces six best practices and provides corresponding examples.

6. [Configuration in Python applications: no magic, just necessary practice](https://robertrode.com/2023/10/02/configuration-in-python-applications-no-magic-just-necessary-practice.html)

How can we store mutable or sensitive parameters in a configuration file? We can use files like ini, json, toml, yaml, or environment variables. When should we initialize the configuration? How can we modify the configuration during tests? This article shares some usage tips.

7. [Fine-tuning Flask, Django, and FastAPI applications in Python](https://tonybaloney.github.io/posts/fine-tuning-wsgi-and-asgi-applications.html)

This article introduces some best practices for configuring your web server (involving Gunicorn, Uvicorn, and Hypercorn). It covers the differences between the ASGI and WSGI standards, how to set the number of workers and threads, how to use tools like Locust for testing, and which approach to use for different web frameworks.

8. [Why Do Python, Go, and Rust Not Support the Ternary Operator?](https://pythoncat.top/posts/2023-04-03-condition)

Python does not support the ternary operator, but it has a very special **conditional selection syntax**. Why is it designed this way? The article sorts out the tortuous syntax design story of Python, and at the same time introduces the coincidental practices of Go and Rust, which makes people think about what is better syntax design in programming languages?

9. [The Key to the `key` Parameter in Python](https://www.thepythoncodingstack.com/p/the-key-to-the-key-parameter-in-python)

You may have seen the `key` parameter in the `sorted()` and `list.sort()` functions, but it is also available in many other functions, such as `max()` and `min()`. This article explains how to use the `key` parameter in these functions.

10. [Eliminating Mutating Methods from Python Data Classes](https://rednafi.com/python/dataclasses_and_methods/)

In Python, you can use the `@dataclass` decorator to define data classes, which automatically add magic methods like `__init__`, `__repr__`, and `__eq__`, reducing the amount of code you need to write. The author recommends defining immutable data classes and avoiding mutating their attributes like you would with a regular class. If you need to use methods like `__repr__` in a regular class, it is better to implement them manually.

🎁 Python Trending Weekly 🎁 organizes its content into seasons, with every 30 issues forming a season. The highlights from the first season have been compiled for your convenience. You can access them online [here](https://pythoncat.top/posts/2023-12-11-weekly) (Chinese).

## 🐿️Projects & Resources

1. [Feedi: Build Your Own Personalized News Aggregator](https://github.com/facundoolano/feedi)

Do you want to have a personalized content reader? It supports parsing RSS feeds, fetching Mastodon messages, reading bookmarks, local article reading and previewing, and sending to Kindle. (Appendix: Why and how the author developed this project [Reclaiming the Web with a Personal Reader](https://olano.dev/2023-12-12-reclaiming-the-web-with-a-personal-reader/))

![Image of Feedi's interface](https://img.pythoncat.top/feedi.png)

2. [generative-ai-python: Develop Gemini and PaLM applications with Google AI SDK](https://github.com/google/generative-ai-python)

Google's generative AI development toolkit to quickly build AI applications on top of the Gemini and PaLM large models. Supports text generation, multi-turn dialogue, embeddings, and more.

3. [python-guide-for-javascript-engineers: Open-source e-book "Python Guide for JavaScript Engineers"](https://github.com/luckrnx09/python-guide-for-javascript-engineers)

An open-source e-book based on [abook](https://github.com/luckrnx09/abook) that covers everything from Python environment installation to project development. It helps JavaScript engineers quickly master the Python language by comparing and contrasting JavaScript and Python in numerous examples. (Contributed by @[luckrnx09](https://github.com/luckrnx09))

4. [sqlmap: SQL injection and penetration testing tool](https://github.com/sqlmapproject/sqlmap)

It can automatically detect and exploit SQL injection flaws and take over database servers. It features a powerful detection engine, database fingerprinting, data retrieval from the database, accessing the underlying file system and executing commands on the operating system. (star 29.4K)

5. [TikTokDownloader: TikTok and Douyin Data Collection Tool](https://github.com/JoeanAmier/TikTokDownloader)

A data collection tool based on the Requests module with comprehensive functions! Supports command line mode, Web UI mode, and interface invocation mode. (1.5K stars) (Note: In the 25th issue, the author's Xiaohongshu collection tool XHS_Downloader was shared)

6. [Osprey: Fine-tuning Pixel Understanding through Visual Guidance](https://github.com/CircleRadon/Osprey)

This is a project that amazed me with its demo effect! Just look at the demo image below:

![Visual understanding of the content in Along the River During the Qingming Festival](https://img.pythoncat.top/Osprey.gif)

7. [django-cast: A blog/podcast project based on Django and Wagtail](https://github.com/ephes/django-cast)

Quickly build your personal blog and podcast website with Django, using Wagtail as a CMS to easily manage your posts and podcast episodes. Supports podcast and video playback, comments and spam filtering, and customizable site themes.

8. [Qexo: Fast, Powerful and Beautiful Hexo Editor](https://github.com/Qexo/Qexo)

Hexo blog backend management, custom image upload, online page management, open API, one-click update, quick access to friendly links. (star 1.2K)

9. [project-based-learning: A curated list of project-based tutorials](https://github.com/practical-tutorials/project-based-learning)

A resource-rich project with a huge number of stars, divided into different programming languages and technical fields, collecting many tutorials on practical projects. (142K stars)

10. [Amphion: A toolbox for audio, music, and speech generation](https://github.com/open-mmlab/Amphion)

Its goal is to provide a platform to study converting arbitrary inputs to audio. It supports TTS text-to-speech, SVC singing voice conversion, TTA text-to-audio, and widely used neural vocoders. (2.2K stars)

## 🐢Podcasts & Videos

1. [PyConChina 2023 Speech Videos](https://space.bilibili.com/474764697/video)

Some videos from this year's PyConChina event have been released and are available to watch on Bilibili.

![List of videos from PyConChina 2023](https://img.pythoncat.top/2023-12-23_pyconchina.png)

2. [Episode #184: PyCoder's Weekly's 2023 Year in Review](https://realpython.com/podcasts/rpp/184/)

PyCoder's Weekly is a weekly podcast that I've been following for a long time. This episode is a year-in-review episode where they discuss topics such as the top 5 clicked links, some of the biggest news stories of the year, major themes and trends of the year, and cool projects, among other things.

3. [Requests vs Httpx vs Aiohttp: Which One Should You Choose?](https://www.youtube.com/watch?v=OPyoXx0yA0I)

This video compares using requests, httpx, and aiohttp, discussing topics such as using asynchronous requests.

## 🐼Subscribe Welcome

- [Blog](https://pythoncat.top): Explore my independent blog where you can find a collection of original/translated technical articles over the years, along with some reflections since 2009.
- [Newsletter](https://pythoncat.substack.com/s/python-trending-weekly): Subscribe to my channel on Substack for a curated newsletter delivered straight to your inbox, keeping you updated on current affairs.
- [Github](https://github.com/chinesehuazhou/python-weekly): Access the Markdown source files of this weekly digest on Github and feel free to use them for anything you have in mind!
- [Telegram](https://t.me/pythontrendingweekly): Beyond notifications for the weekly digest, I consider it an "extra edition," providing additional, more diverse information.
- [Twitter](https://twitter.com/chinesehuazhou): Follow me on Twitter where my feed is filled with numerous accounts of developers and organizations in the Python community.