# Python Trending Weekly #31 (2023-12-16)

Welcome to the Python Trending Weekly, a weekly newsletter about Python, AI and general programming techniques, with the majority links in English and a small portion in Chinese. 

The [original version](https://pythoncat.top/posts/2023-12-16-weekly) of the weekly was written in Chinese. What you are reading here is mostly translated by LLMs. 

**Substack Channel** : [Click to subscribe](https://pythoncat.substack.com/s/python-trending-weekly) 

## 🦄Articles & Tutorials

1. [PEP-738: Adding Android as a Tier 3 Supported Platform](https://pep-previews--3586.org.readthedocs.build/pep-0738/#)

In issue 24 of the Weekly, we shared [PEP-730: CPython providing official support for iOS](https://peps.python.org/pep-0730/). This PEP-738 turns the target to the Android system. Both PEPs are currently in draft status, but Android uses the Linux kernel, so maybe this PEP has a greater chance of being adopted? (Appendix: [Python on Mobile: State of the Union](https://pyfound.blogspot.com/2023/05/the-python-language-summit-2023-python.html) at the Python Language Summit this year)

2. [Marker: A Deep Dive into the Source Code of the AI-Powered PDF Layout Detection Engine](https://journal.hexmos.com/marker-pdf-document-ai/)

In just two weeks, the PDF-to-Markdown tool **Marker**, which was featured in issue 29, has nearly reached 5K stars. This article explains how it works, describing its six stages and the tools it relies on (PyMuPDF, OCRMyPDF, Tesseract, etc.).

![How Marker Works](https://img.pythoncat.top/2023-12-15-marker.png)

3. [Real-world match/case](https://nedbatchelder.com/blog/202312/realworld_matchcase.html)

Python 3.10 introduced the **match-case** pattern matching syntax. Have you used it in your projects? This article presents a use case: processing complex JSON data returned by a GitHub bot. It shows how match-case simplifies the code compared to traditional approaches.

4. [Pytest Daemon: 10x Local Test Iteration Speed](https://discord.com/blog/pytest-daemon-10x-local-test-iteration-speed)

Discord's official blog post shares their story of improving a test from 20 seconds to 2 seconds! The trick is to use "**pytest daemon**" and hot reloading, which ensures that a process is ready when you need to run tests, eliminating the overhead of preparing it on the fly. The post also mentions an open-source project [pytest-hot-reloading](https://github.com/JamesHutchison/pytest-hot-reloading/) that achieves the same goal.

5. [Android AI App in 88 Lines of Python Code](https://vra.github.io/2023/10/14/android-ai-app-in-88-lines-of-python-code/)

It sounds like a difficult task to develop a demo of SDXL text-to-image on a mobile phone, but this article claims it can be done with only 88 lines of Python code! The technologies used are Beeware and LeptonAI. We have mentioned Beeware many times in our weekly (for example, the two PEPs mentioned above are closely related to it), and LeptonAI is an entrepreneurial project of the well-known AI expert @jiayangqing.

6. [You Don't Need This in Python](https://www.bitecode.dev/p/you-dont-need-this-in-python)

The author points out some common Python redundancies/mistakes, including `# -*- coding: utf-8 -*-` , `range(len(xx))` , keeping track of loop positions, using index() to check for containment, and separate getters and setters. The first one about encoding is indeed very common, and it also reminds me of another one that is often used unconsciously: `if __name__ == '__main__'` . (See also: [Why I Don't Recommend Writing a So-Called main Function?](https://pythoncat.top/posts/2020-06-03-main))

7. [Why “if TYPE_CHECKING”?](https://vickiboykis.com/2023/12/11/why-if-type_checking/)

The purpose of `if TYPE_CHECKING` is to enable conditional importing of modules. A basic example is shown below:

```Python
from typing import TYPE_CHECKING

if TYPE_CHECKING:
    from collections.abc import Sequence

def func(value: Sequence[int]) -> None:
    pass
```

When would you want to do this? The article explains the need for this pattern, and the short answer is: to balance the trade-off between type checking enforced by mypy and type checking at runtime, especially in the presence of many circular dependencies.

8. [Comparison of SQLALchemy and Django ORM](https://st4lk.github.io/en/blog/2023/12/09/sqlalchemy-vs-django-orm/)

Both are object-relational mapping (ORM) frameworks for relational databases. The author introduces some differences and correct usage of the two from the perspective of switching from Django ORM to SQLAlchemy, avoiding making mistakes when using them.

9. [Python \_\_init\_\_.py Best Practices](https://coderslegacy.com/python-init-py-best-practices/)

`__init__.py` is a special file in Python. Why do we need such a file? What is its role? How to customize this file? What are some usage tips and best practices? This article provides a detailed tutorial.

10. [Mojo: The Point of View of a Researcher Using Python](https://augierpi.gricad-pages.univ-grenoble-alpes.fr/mojo-the-point-of-view-of-a-researcher-using-python.html)

A systematic analysis of Mojo. The author's research questions are: What is Mojo? What will be its future? Is Mojo useful for general scientific computing (not only AI)? When will it be really usable? What is still missing? The author does not agree with the popular saying "**Mojo==Python++**", but rather studies it as a novel static language.

11. [Simple HTTP Status Codes in Python](https://www.b-list.org/weblog/2023/dec/04/python-http-status-codes/)

Don't use numeric literals for HTTP request status codes in your code. This is considered a "magic number" and is bad practice. Frameworks like Django, Starlette, and Litestar provide enums, but the recommended way is to use the `http.HTTPStatus` from the standard library. Additionally, starting with Python 3.12, you can use `HTTPStatus.is_success` to check for 2xx status codes. (Note: This article is part of the author's daily "Advent of Code" series, which contains various programming tips. [Read more on the blog](https://www.b-list.org/weblog/))

12. [CPython Development Practice: Implementing the None-aware Operators ?. and ??](https://juejin.cn/post/7310101543776829440)

[PEP-505 None-aware operators](https://peps.python.org/pep-0505/) is a deferred proposal to simplify conditional handling when checking for `None`. The article introduces the three None-aware operators in the PEP and provides a simple implementation. It also mentions two dissenting comments on the proposal, and I would like to add my own: let's not add it, keep it Deferred!

13. [Code is Run More than Read](https://olano.dev/2023-11-30-code-is-run-more-than-read/)

"**Code is read more than written**" is a fundamental principle in programming, reminding developers to focus on code readability and maintainability. The author refines it to "maintainer > author". However, coding is just a means to an end, which is to provide service to users, so it's "user > dev". And the ultimate goal is to create business value, so the initial conclusion is "biz > user > ops > dev". Is this conclusion correct? The author considers/weighs the importance of each factor and lists several relationships. The final concise conclusion is: user > ops > dev, biz > ops > dev, biz ≈ user.

🎁 Python Trending Weekly 🎁 organizes its content into seasons, with every 30 issues forming a season. The highlights from the first season have been compiled for your convenience. You can access them online [here](https://pythoncat.top/posts/2023-12-11-weekly) (Chinese).

## 🐿️Projects & Resources

1. [magic-animate: Temporally Coherent Person Animation with Diffusion Models](https://github.com/magic-research/magic-animate)

Jointly released by National University of Singapore and ByteDance, it generates a person's motion video with a portrait and an action figure. (star 7.8K)

2. [phpy: An Ecosystem Connecting Python and PHP](https://github.com/swoole/phpy)

It allows you to use Python functions and libraries in PHP, or PHP packages in Python. The implementation principle is to create both `ZendVM` and `CPython VM` in the process, and use `C` functions to call each other directly in the process stack space. Currently, Python multithreading and asynchronous IO features are not supported.

3. [insanely-fast-whisper: Whisper at Insane Speed](https://github.com/Vaibhavs10/insanely-fast-whisper)

An audio transcription tool based on OpenAI's Whisper Large v3, which transcribes 150 minutes of audio in just 98 seconds. (4.2k stars) (Also: [faster-whisper: Faster Whisper transcription with CTranslate2](https://github.com/SYSTRAN/faster-whisper), 6.2k stars)

4. [coffee: Use AI to boost your UI building and iteration speed by 10x](https://github.com/Coframe/coffee)

This is a very creative project. By introducing its components into the front-end project and describing the effect you want to achieve in natural language, it will help generate the implementation code.

![Screenshot of usage in the demo video](https://img.pythoncat.top/2023-12-16_coffee.png)

5. [FastUI: Build Better UIs Faster](https://github.com/pydantic/FastUI)

Pydantic's web interface development framework that lets you build responsive web applications with React without writing a single line of JavaScript. (2.7k stars)

6. [mistral-src: Reference implementation of the Mistral AI 7B v0.1 model](https://github.com/mistralai/mistral-src)

Mistral AI 7B performed exceptionally well, coming close to the performance of the Llama 70B version in terms of evaluation scores. This project is officially open-sourced for rapid deployment and usage of the model. (5.4K stars)

7. [netchecks: A tool to check network conditions](https://github.com/hardbyte/netchecks)

A tool to test if network conditions meet expectations. It supports validating DNS and HTTP connections, allows configuring assertion conditions, and supports custom validation content.

8. [Pearl: Meta's Reinforcement Learning AI Agent Library](https://github.com/facebookresearch/Pearl)

Open-sourced by Meta's Applied Reinforcement Learning team, it features a modular design and offers a unique set of capabilities for production settings, including dynamic action spaces, offline learning, intelligent neural exploration, safe decision-making, hindsight experience replay, and data augmentation. (1.4k stars)

![Pearl's architecture diagram](https://img.pythoncat.top/agent_interface.png)

9. [gpt-fast: Simple and Efficient PyTorch Native Transformer Text Generation](https://github.com/pytorch-labs/gpt-fast)

A PyTorch showcase project that implements simple and efficient text generation with less than 1000 lines of Python code. (4.1k stars)

10. [The-Grand-Complete-Data-Science-Materials: Videos and Materials for Data Science](https://github.com/krishnaik06/The-Grand-Complete-Data-Science-Materials)

A resource repository containing a huge list of videos on topics like data analysis, data science, machine learning, generative AI, and more. (4.2k stars)

11. [awesome-LLMs-In-China: Large Language Models in China](https://github.com/wgwang/awesome-LLMs-In-China)

A comprehensive list of large language models in China, including information on institutions, sources, and categories, with a current count of 189 domestic large models. (2.6k stars)

12. [msgspec: High-performance serialization and validation library](https://github.com/jcrist/msgspec)

A high-performance serialization and validation library that supports formats such as JSON, MessagePack, YAML, and TOML. (1.5k stars)

![Image of performance comparison between msgspec, pydantic, cattrs, and marshmallow](https://img.pythoncat.top/bench-validation.svg)

## 🐢Podcasts & Videos

1. [Announcing Hidden Figures of Python: A PyPodcats Show](https://pyfound.blogspot.com/2023/12/announcing-hidden-figures-of-python-pypodcats.html)

The goal of the “Hidden Figures of Python” podcast is to amplify the voices of underrepresented groups in the Python community. The first episode features four women hosts discussing the origins of the podcast and analyzing the lack of female guests on top Python podcasts.

2. [Talk Python To Me #442: Ultra-High-Speed Message Parsing with msgspec](https://talkpython.fm/episodes/show/442/ultra-high-speed-message-parsing-with-msgspec)

This episode of the podcast features Jim Crist-Harif, the creator of msgspec, which was discussed earlier.

3. [DjangoCon US 2023 Video Playlist (60 videos)](https://www.youtube.com/playlist?list=PL2NFhrDSOxgX41jqYSi0HmO9Wsf6WDSmf)

DjangoCon US is an annual conference focused on the Django web framework, and the videos from this year's conference are now available.

![DjangoCon US Video Playlist](https://img.pythoncat.top/2023-12-16_djangocon.png)

## 🐼Subscribe Welcome

- [Blog](https://pythoncat.top): Explore my independent blog where you can find a collection of original/translated technical articles over the years, along with some reflections since 2009.
- [Newsletter](https://pythoncat.substack.com/s/python-trending-weekly): Subscribe to my channel on Substack for a curated newsletter delivered straight to your inbox, keeping you updated on current affairs.
- [Github](https://github.com/chinesehuazhou/python-weekly): Access the Markdown source files of this weekly digest on Github and feel free to use them for anything you have in mind!
- [Telegram](https://t.me/pythontrendingweekly): Beyond notifications for the weekly digest, I consider it an "extra edition," providing additional, more diverse information.
- [Twitter](https://twitter.com/chinesehuazhou): Follow me on Twitter where my feed is filled with numerous accounts of developers and organizations in the Python community.