# Python Trending Weekly #30 (2023-12-09)

Welcome to the Python Trending Weekly, a weekly newsletter about Python, AI and general programming techniques, with the majority links in English and a small portion in Chinese. 

The [original version](https://pythoncat.top/posts/2023-12-09-weekly) of the weekly  was written in Chinese. What you are reading here is mostly translated by LLMs. 

**Substack Channel** : [Click to subscribe](https://pythoncat.substack.com/s/python-trending-weekly) 

## 🦄Articles & Tutorials

1. [Python Africa: An Open Letter to the Python Software Foundation](https://pythonafrica.blogspot.com/2023/12/an-open-letter-to-python-software_5.html)

An open letter to the PSF from Python community organizers in over a dozen African countries. The letter was prompted by the PSF's delayed disbursement of a $9,000 grant to Africa's first DjangoCon, and it highlights other issues within the PSF, including racism, lack of attention to marginalized groups, and non-compliance with local laws. (As an aside, the PSF gave 1% of its grants to Asia in 2022, compared to 16% to Africa...)

2. [Django 5.0 Released!](https://docs.djangoproject.com/en/5.0/releases/5.0)

Django 5.0 was released this week, and it only supports Python 3.10 and later. Key new features: The new `Field.db_default` parameter allows you to set a default value that is calculated by the database; `GeneratedField` allows you to create columns that are generated by the database; Field groups and field group templates have been introduced, which simplify the rendering of related elements for form fields. (Bonus: [Video](https://www.youtube.com/watch?v=lPl5Q5gv9G8) introducing new features in Django)

![Defining a default value for a database field](https://img.pythoncat.top/2023-12-08_django.png)

3. [56 Lines of Python Code to Implement a Flex/Lex](https://www.skywind.me/blog/archives/2761)

Lex/Flex can be used to generate lexical analyzers that process lexical structures in source code. The author implemented a general rule-based lexical analyzer by modifying a program in the official Python documentation, which can be used to handle simple lexical analysis requirements.

4. [How to Use Dependency Injection in FastAPI the Right Way](https://so1n.me/2023/12/07/how-to-use-dependency-injection-in-fastapi/)

This article points out two wrong ways people use dependency injection in FastAPI and introduces how to implement dependency injection in FastAPI using `python-dependency-injector`.

5. [Why You Should Not Overuse List Comprehensions in Python](https://www.kdnuggets.com/why-you-should-not-overuse-list-comprehensions-in-python)

Using list comprehensions appropriately can make your code more concise and elegant, but overusing them will severely impair the readability of your code. The author provides three examples, each implemented with list comprehensions and a conventional approach, allowing readers to appreciate how easy-to-understand code is superior to fancy showmanship.

6. [Untyped Python: The Python That Was](https://lucumr.pocoo.org/2023/12/1/the-python-that-was/)

In his latest post, Armin Ronacher, the creator of Flask, discusses the topic of types in Python. The central thesis is that Python's dynamic typing is an advantage due to its inherent philosophy, which clashes with typing. Typing has its merits, but it also comes with a cost. The author reminisces about the Python of the past.

7. [Add Full-Text Search to Your Django Project with django-watson](https://idiomaticprogrammers.com/post/django-watson-full-text-search-guide)

A very detailed tutorial on adding full-text search capabilities to your Django project using [django-watson](https://github.com/etianen/django-watson) and PostgreSQL. The library supports searching across multiple models and sorting by relevance. (star 1.2K)

8. [Celery Fanout Pattern Explained](https://www.better-simple.com/django/2023/12/06/fanout-pattern-explained/)

The Celery fanout pattern is a task distribution pattern where a single task triggers multiple child tasks to be executed in parallel. The author introduces a practical use case of this pattern, arguing that it is a good way to implement dynamic workflows in task signatures.

9. [7 Alternatives to Python Asyncio](https://superfastpython.com/asyncio-alternatives/)

Asyncio is Python's standard library for asynchronous programming, but it's not your only option. This article introduces and compares seven alternatives, including older libraries like Tornado, Twisted, and Gevent, as well as newer ones like Curio, Trio, AnyIO, and UVloop.

10. [Inside CPython: What Happens When You Do a+b?](https://codeconfessions.substack.com/p/cpython-dynamic-dispatch-internals)

A deep dive into the inner workings of CPython's dynamic dispatch mechanism. Dynamic dispatch is the process of determining which method or function to call at runtime (rather than at compile time). Something as simple as a+b can have multiple combinations of types, and the actual computation can be quite different.

11. [How to Display an Animated GIF with Python](https://www.blog.pythonlibrary.org/2023/12/05/viewing-an-animated-gif-with-python/)

GIF is an image format that supports animation without audio. Are there any Python libraries that can display animated GIFs programmatically? This article introduces three approaches using tkinter, PySimpleGUI, and Jupyter Notebook.

12. [Building a Simple REPL in Python](https://bernsteinbear.com//blog/simple-python-repl/)

REPL (Read-Eval-Print Loop) is an interactive environment for a programming language. Python's standard library includes a code module that provides the functionality to implement a REPL. This article demonstrates how to build a simple REPL by incrementally introducing requirements.

🎁 Python Trending Weekly 🎁 organizes its content into seasons, with every 30 issues forming a season. The highlights from the first season have been compiled for your convenience. You can access them online [here](https://pythoncat.top/posts/2023-12-11-weekly) (Chinese).

## 🐿️Projects & Resources

1. [Self-operating computer: Enabling multimodal models to operate computers](https://github.com/OthersideAI/self-operating-computer)

This is one of the hottest recent projects based on GPT-4v. It allows large language models to view screen content, operate the mouse and keyboard to achieve specific goals, just like humans. The current challenge is that GPT-4v has a high error rate in mouse click location. (5.1k stars)

2. [marko: A highly extensible markdown parser](https://github.com/frostming/marko)

A Markdown parser that focuses on extending the developer experience, following the CommonMark spec v0.30 spec. Speed is not its strength, but it makes it easy to inspect the AST, implement your own elements and renderers. (Submitted by @frostming)

3. [WeChatMsg: Export WeChat Chat History as HTML/Word/CSV Document](https://github.com/LC044/WeChatMsg)

This project, created by a college student, has been trending on WeChat Moments this week. It allows users to export their WeChat chat history and generate an annual chat report. Its slogan, "My data, my choice," resonates with many users. The exported data can be used to train personal AI! (12.5K stars)

![Image of a page from the annual chat report](https://img.pythoncat.top/image-20230520235409112.png)

4. [PyWxDump: Get WeChat account information, export chat records](https://github.com/xaoyaoo/PyWxDump)

This is a dependency of the previous project, which can decrypt the database, view and export chat records, and support multi-user information acquisition in the WeChat multi-open scenario. (star 1.6K) (PS. I always feel that these two projects will be targeted by WeChat, what do you think?)

5. [mlx: An Array Framework for Apple Silicon](https://github.com/ml-explore/mlx)

A machine learning array framework for Apple silicon with a Python API similar to Numpy. (7.2k stars)

6. [DSAlgo: Collection of Interview Questions on Data Structures and Algorithms](https://github.com/SamirPaulb/DSAlgo)

A curated repo of awesome data structures and algorithms questions, solved in Python. It also contains a collection of interview questions from big companies and study notes for computer science. (star 1.7K)

7. [Python Online Compiler Website](https://pythononlinecompiler.com/)

An online version of the Python interpreter in a web browser, supporting Python versions 2.7, 3.3-3.10, and pre-installed with most commonly used libraries, including Turtle, Tkinter, Pygame, Numpy, Matplotlib, Pandas, Scipy, etc.

![Draw a Small Alarm Clock Online](https://img.pythoncat.top/2023-12-09_compiler.png)

8. [aio-libs: 65 Libraries/Projects Based on Asyncio](https://github.com/aio-libs)

It collects libraries related to asynchronous IO in the Python community, including aiohttp, aiopg, aiomysql, yarl, aiokafka, and more.

9. [kolo: Visualize Django app execution](https://github.com/kolofordjango/kolo)

A VSCode extension that features frame visualization, beautiful flame graphs, shows the line of code that executed a SQL query, allows jumping directly to the exception location, and more.

![kolo feature introduction](https://img.pythoncat.top/2023-12-09-kolo.png)

10. [dnsteal: DNS exfiltration tool that sends files over DNS requests](https://github.com/m57/dnsteal)

A tiny tool with only 200+ lines of code that fakes a DNS server to exfiltrate files hidden in DNS requests. It supports multiple files, Gzip compression, custom subdomain information, and more. (1.6k stars)

11. [github-trends: Beautify your GitHub profile with customizable cards](https://github.com/avgupta456/github-trends)

Generate contribution calendars, lines of code analysis, contribution graphs in various dimensions, and more for your GitHub profile. Easily embed dynamic badges in your profile page. (6.4k stars)

12. [Depix: Recover information from pixelated screenshots](https://github.com/spipm/Depix)

Think pixelating a screenshot makes it secure? Think again! This library recovers plaintext information from images with high accuracy. The repository includes an explanation of the technique and a note on its limitations. (24.7k stars)

![Recovering text information example](https://img.pythoncat.top/Recovering_prototype_latest.png)

## 🐼Subscribe Welcome

- [Blog](https://pythoncat.top): Explore my independent blog where you can find a collection of original/translated technical articles over the years, along with some reflections since 2009.
- [Newsletter](https://pythoncat.substack.com/s/python-trending-weekly): Subscribe to my channel on Substack for a curated newsletter delivered straight to your inbox, keeping you updated on current affairs.
- [Github](https://github.com/chinesehuazhou/python-weekly): Access the Markdown source files of this weekly digest on Github and feel free to use them for anything you have in mind!
- [Telegram](https://t.me/pythontrendingweekly): Beyond notifications for the weekly digest, I consider it an "extra edition," providing additional, more diverse information.
- [Twitter](https://twitter.com/chinesehuazhou): Follow me on Twitter where my feed is filled with numerous accounts of developers and organizations in the Python community.