# Python Trending Weekly #29 (2023-12-02)

Welcome to the Python Trending Weekly, a weekly newsletter about Python, AI and general programming techniques, with the majority links in English and a small portion in Chinese. 

The [original version](https://pythoncat.top/posts/2023-12-02-weekly) of the weekly  was written in Chinese. What you are reading here is mostly translated by LLMs. 

**Substack Channel** : [Click to subscribe](https://pythoncat.substack.com/s/python-trending-weekly) 

## 🦄Articles & Tutorials

1. [Rust std fs slower than Python! Really!?](https://mp.weixin.qq.com/s/m-IBomxu88DlNcEyOgyOew)

A long article begins with a strange question: a program written in Rust is slower than Python!? In the process of locating the root cause, the author repeatedly obtained the result that the Rust solution was slower than Python, and even the C version code was slower than Python! Going deeper and deeper, using various positioning methods, it was finally discovered that it was a problem with the AMD CPU kernel!

2. [Which Python timestamp function is the fastest?](https://www.dataroc.ca/blog/most-performant-timestamp-functions-python)

What are the functions for getting timestamps in Python? How do they perform? The article took 7 functions for performance measurement and found that time.time() is the fastest. After the article was published, it caused some controversy, so the author wrote a second article, comparing Win10, WSL2, and Ubuntu20, and also added a comparison of Python 3.10 and 3.12. (Attached: [The second article on performance comparison](https://www.dataroc.ca/blog/most-performant-timestamp-functions-python-2))

![Time taken for 500,000 calls](https://img.pythoncat.top/2023-12-01_time.png)

3. [Python Is Easy, Go Is Simple, But Simple != Easy](https://preslav.me/2023/11/27/python-is-easy-golang-is-simple-simple-is-not-easy/)

Python is easy to learn and use because it leaves a lot of the complex work to the interpreter, which makes it suitable for prototyping and rapid application development. Go is also simple, but it has more rules than Python and is more performant. The author suggests playing to the strengths of both.

4. [Unlocking C-level performance in df.apply with Numba](https://labs.quansight.org/blog/unlocking-c-level-performance-in-df-apply)

In Pandas 2.2.0, DataFrame.apply can specify a new numba engine to achieve parallelized operations. The article introduces the working principle of this engine, the application scenarios it supports and what it cannot do, and provides data for multiple performance tests.

5. [A Random List of Flask Maintainer To-Dos](https://davidism.com/maintainer-notes/)

The author, one of the maintainers of Flask, listed a to-do list for Flask contributors to work on. Most of us don't have experience maintaining open-source projects, so we may not be able to imagine the huge amount of non-coding stuff that maintainers have to do. (BTW: Flask lost its position as the second most starred web framework this week, being surpassed by FastAPI.)

6. [Running Python Concurrency with Subinterpreters](https://tonybaloney.github.io/posts/sub-interpreter-web-workers.html)

Python 3.12 exposed an API for subinterpreters. What can you do with it? How does it compare to threads and processes, and what are the performance implications? What happens when you try to use it for web development? The author experimented with a development version of Python 3.13, and the results were a mixed bag of surprises and crashes. Here's hoping for a truly GIL-less Python next year!

![Growth of workload and execution time](https://img.pythoncat.top/2023-12-01_sub.png)

7. [New Open Source vs. Old Open Source](https://dev.to/taipy/new-open-source-vs-old-open-source-33k7)

The article selects 10 well-known libraries in the Python community and provides their corresponding alternative libraries. The most uncontroversial one is probably Ruff replacing Pylint, and others include: Taipy/Streamlit, Polars/Pandas, Dask/PySpark, PyTorch/TensorFlow, etc.

8. [Using Polars in a Pandas World](https://pythonspeed.com/articles/polars-pandas-interopability/)

Polars is a faster, more memory-efficient, and easier-to-use data processing library that can serve as a drop-in replacement for Pandas. But how can you integrate it with third-party libraries that you rely on? This article shows you several approaches to achieve a seamless transition from Pandas to Polars.

9. [What are Python's soft keywords?](https://mathspp.com/blog/til/pythons-soft-keywords)

Soft keywords are keywords that can be reassigned. The author wanted to use regular expressions to find all soft keywords from Python's latest grammar file. It turned out that only the following two lines of code are needed to do the trick (the following is the result of Python 3.12, i.e. there are 4 soft keywords now):

```python
>>> import keyword
>>> keyword.softkwlist
['_', 'case', 'match', 'type']
```

10. [Building a Robot Dad with Python](https://blog.untrod.com/2023/11/robot-dad.html)

To deal with his kid's questions, the author built a "robot dad". He used Eleven Labs for voice cloning, Picovoice for wake word detection, and finally called the ChatGPT API to get answers.

11. [How (and How Not) to Design REST APIs](https://github.com/stickfigure/blog/wiki/How-to-(and-how-not-to)-design-REST-APIs)

The article lists more than ten best practice rules for REST APIs, explaining what the rules mean and how to implement them. In addition, the author made fun of several widely used APIs from companies as counterexamples of the rules.

12. [How to Debug Asyncio Programs?](https://superfastpython.com/debug-asyncio/)

The article introduces several ways to debug Asyncio code, including enabling its debug log, running the event loop in debug mode, customizing debug information, etc. (P.S. Its sister article How to Profile Asyncio Programs analyzes slow programs and hot functions.)

🎁 Python Trending Weekly 🎁 organizes its content into seasons, with every 30 issues forming a season. The highlights from the first season have been compiled for your convenience. You can access them online [here](https://pythoncat.top/posts/2023-12-11-weekly) (Chinese).

## 🐿️Projects & Resources

1. [marker: Efficiently convert PDF/EPUB/MOBI to Markdown](https://github.com/VikParuchuri/marker)

Supports converting multiple file formats to Markdown, can remove headers/footers, convert equations to LaTeX, format code blocks and tables, and also supports multiple languages. (Star 2.3K) (Attached: The effect of converting the entire PDF version of "Think Python" [after conversion](https://github.com/VikParuchuri/marker/blob/master/data/examples/marker/thinkpython.md))

![Comparison with Nougat in speed and accuracy](https://img.pythoncat.top/2023-12-02_maker.png)

2. [awesome-django-performance: Curated list of resources for profiling and optimizing Django projects](https://github.com/st3v3nmw/awesome-django-performance)

This project curates a list of libraries, tools, articles, and books, primarily focused on profiling, database, caching, serialization, task processing, and monitoring.

3. [datamodel-code-generator: Convert JSON/YAML to Pydantic models](https://github.com/koxudaxi/datamodel-code-generator)

A data model code generator that supports multiple input types (OpenAPI, JSON, YAML, CSV, Python dictionaries, GraphQL) and outputs Pydantic, dataclass, TypeDict, and other types. (2k stars)

4. [fastapi-code-generator: Create FastAPI applications with OpenAPI files](https://github.com/koxudaxi/fastapi-code-generator)

It uses datamodel-code-generator to generate Pydantic models and quickly generates a FastAPI project based on an OpenAPI formatted interface file. It supports custom templates and allows passing custom variables to custom templates.

5. [kanban-python: A kanban application in your terminal](https://github.com/Zaloog/kanban-python)

A kanban application implemented in a command-line window, featuring pretty tables, separation of configuration and data, automatic task creation, and task tracking.

![Example of the kanban application](https://img.pythoncat.top/2023-12-2-kanban.png)

6. [saq: Simple Async Queue](https://github.com/tobymao/saq)

A simple and high-performance task queue framework based on Asyncio and Redis. It provides a simple UI to view task queues, status, and execution details.

7. [pyqtgraph: Data Visualization and GUI Tools for Scientific/Engineering Applications](https://github.com/pyqtgraph/pyqtgraph)

A high-performance graphics library using Numpy for numerical operations and Qt's GraphicsView framework for 2D display and OpenGL for 3D display. (3.5K stars)

8. [Toga: Native Python, Native OS GUI Toolkit](https://github.com/beeware/toga)

A GUI toolkit for building cross-platform desktop applications. Supports macOS, Windows, Linux (GTK), Android, iOS, and single-page web apps. (3.9k stars)

9. [autometrics-py: A function-level metrics monitoring tool](https://github.com/autometrics-dev/autometrics-py)

It provides a decorator to monitor metrics like request rate, error rate, and latency for functions, helping you identify and debug issues in your code. It supports querying and analyzing with Prometheus, out-of-the-box Grafana dashboards, custom alerting, and has a low runtime overhead.

10. [compiled: Compiled variants of Python standard library](https://github.com/pycompiled/compiled)

Some standard libraries in Python are implemented in pure Python, which can be a performance bottleneck. This project compiles type-checked standard libraries with mypyc to C code, resulting in 2-4x speedups over the original versions. Currently, tomllib and difflib are done, with asyncio, urllib, zipfile, argparse, and uuid planned.

11. [transpyler-gpt: A GPT-powered Python transpiler to make code run on older versions](https://github.com/frostming/transpyler-gpt)

It leverages GPT to transpile higher version Python code to Python versions for target environments, enabling backward-compatible execution. For example, it can transpile match-case code from Python 3.10+ to if-else code that can run on lower Python versions.

12. [clone-voice: A voice cloning tool with a web interface](https://github.com/jianchang512/clone-voice)

Supports 4 languages: Chinese, English, Japanese, and Korean, and can record audio from a microphone online. It supports text-to-speech and voice changing. (1.3k stars)

![](https://img.pythoncat.top/2023-12-02_voice.png)

## 🐢Podcasts & Videos

1. [Talk Python To Me #439: Pixi a fast package manager](https://talkpython.fm/episodes/show/439/pixi-a-fast-package-manager)

Pixi is a Conda-based package manager written in Rust.

2. [Mouse Vs Python #23: The Ruff Formatter with Charlie Marsh](https://www.blog.pythonlibrary.org/2023/11/27/episode-23-the-ruff-formatter-with-charlie-marsh/)

Ruff is a Python linter+formatter written in Rust, and it's the fastest at both.

## 🥂Discussion & Questions

1. [What's the coolest thing you've done with Python?](https://www.reddit.com/r/Python/comments/17upt2f/whats_the_coolest_things_youve_done_with_python/)

A popular discussion thread on Reddit with nearly 700 comments that will take a while to get through...

2. [Syntactic Sugar to Encourage Use of Named Arguments](https://discuss.python.org/t/syntactic-sugar-to-encourage-use-of-named-arguments/36217)

Named arguments in functions improve readability, but can also make code verbose and repetitive. The author proposes a syntactic sugar to simplify the writing of variable assignments, which has received support from several core developers.

## 🐼Subscribe Welcome

- [Blog](https://pythoncat.top): Explore my independent blog where you can find a collection of original/translated technical articles over the years, along with some reflections since 2009.
- [Newsletter](https://pythoncat.substack.com/s/python-trending-weekly): Subscribe to my channel on Substack for a curated newsletter delivered straight to your inbox, keeping you updated on current affairs.
- [Github](https://github.com/chinesehuazhou/python-weekly): Access the Markdown source files of this weekly digest on Github and feel free to use them for anything you have in mind!
- [Telegram](https://t.me/pythontrendingweekly): Beyond notifications for the weekly digest, I consider it an "extra edition," providing additional, more diverse information.
- [Twitter](https://twitter.com/chinesehuazhou): Follow me on Twitter where my feed is filled with numerous accounts of developers and organizations in the Python community.