# Python Trending Weekly #28 (2023-11-25)

Welcome to the Python Trending Weekly, a weekly newsletter about Python, AI and general programming techniques, with the majority links in English and a small portion in Chinese. 

The [original version](https://pythoncat.top/posts/2023-11-25-weekly) of the weekly  was written in Chinese. What you are reading here is mostly translated by LLMs. 

**Substack Channel** : [Click to subscribe](https://pythoncat.substack.com/s/python-trending-weekly) 

## 🦄Articles & Tutorials

1. [Four Kinds of Optimization](https://tratt.net/laurie/blog/2023/four_kinds_of_optimisation.html)

A highly recommended article. The body of the article introduces four approaches to optimization: using better algorithms, using better data structures, using a lower-level programming language, and accepting less precise solutions. The beginning and end of the article put forward some lessons: we tend to be overly optimistic about performance optimization problems, we may sacrifice correctness for performance, we should not make premature and complex optimizations, and the breadth of optimization is more important than the depth of optimization.

2. [Two Thread Pools, and Why Do We Need Them?](https://pythonspeed.com/articles/two-thread-pools/)

Due to the GIL limitation, when using thread pools in Python, we need to be aware of whether the workload is CPU-bound or IO-bound, which leads to different choices on the number of threads and the target of the thread pool.

3. [It's Time for a Change: datetime.utcnow() Is Now Deprecated](https://blog.miguelgrinberg.com/post/it-s-time-for-a-change-datetime-utcnow-is-now-deprecated)

The `utcnow()` and `utcfromtimestamp()` methods of `datetime.datetime` are marked as "deprecated" in Python 3.12 and will be removed in a future version. The article discusses their drawbacks and explains why they are being deprecated. The replacements are `datetime.now()` and `datetime.fromtimestamp()` respectively.

4. [Deploying Python Web Applications](https://www.biaodianfu.com/python-web-server-deployment.html)

This article introduces how to deploy Flask applications using different solutions such as Nginx+Gunicorn+Supervisor, Nginx+uWSGI+Supervisor, Waitress, and Meinheld, and analyzes their advantages and disadvantages.

5. [Python GIL's Changing "Guarantees"](https://stefan-marr.de/2023/11/python-global-interpreter-lock/)

This article introduces the implementation details of the CPython Global Interpreter Lock and the changes between Python 3.9 and the current 3.13 development version. One big difference is that in 3.9 and earlier, the GIL is released when executing many bytecodes, while in 3.13, only a small number of bytecodes are checked to see if the GIL is released.

6. [Django Dependency Management with pip-compile and pip-tools](https://learndjango.com/tutorials/django-dependency-management-pip-compile-and-pip-t)

There are many options for dependency management in Python, and this article introduces the combination of pip-compile and pip-tools.

7. [Types of Errors in Python Apps](https://threeofwands.com/the-types-of-errors-in-python-apps/)

The author categorizes bugs in programs into four types: type errors and linting errors, import-time exceptions, runtime exceptions, and silent errors. The strategy for handling them is to reduce the occurrence of later types of errors by transforming them into earlier types of errors.

8. [How Many Python Core Devs Use Type Hints?](https://blog.orsinium.dev/posts/py/core-devs-typing/)

Type hints are gaining popularity in Python, but how prevalent are they among core developers? The author analyzed the data and found that, of all core developers, about 53% have recent open-source contributions, and of those, 39% use type hints. Of those who joined the team in the last 3 years, 76% use type hints.

9. [Trying to Convert a Flask Project to Quart Using Python's ast Module](https://juejin.cn/post/7304706387645071395)

The author wanted to use asynchronous iterators returned by OpenAI, so he refactored his Flask project, which didn't support asynchronous operations, to Quart, which does. However, manually modifying the code would have been too time-consuming, so he came up with the idea of using AST parsing to modify the code and improve the efficiency of the project conversion.

10. [A Visual Explanation of Python's NumPy Library](https://solothought.com/tutorial/python-numpy/)

The article uses a lot of intuitive graphics to illustrate the distribution of NumPy data and the process of data transformation, making it easy to understand NumPy data manipulation.

11. [Composition vs Inheritance: I Beg to Differ](https://coady.github.io/posts/composition-vs-inheritance.html)

The traditional view is that composition is better than inheritance, but the author argues that Python doesn't support composition very well, and that using composition dogmatically can lead to problems. Therefore, the author provides a simple implementation approach.

12. [Choosing the Right Data Dashboard Tool: The Unique Strengths of Streamlit and Shiny](https://python-bloggers.com/2023/10/choosing-the-right-data-dashboard-tool-the-unique-strengths-of-streamlit-and-shiny/)

In an era where data drives critical decision-making, interactive dashboards have become indispensable tools in industries such as business and scientific research. Streamlit and Shiny (including RShiny and PyShiny) are powerful frameworks, and this article introduces their respective advantages.

🎁**Python Trending Weekly**🎁 I will share a lot of content that is not included in the weekly issue on [Telegram Channel](https://t.me/pythontrendingweekly). There are currently 1200+ students following. Welcome to join us!

🎁 Python Trending Weekly 🎁 organizes its content into seasons, with every 30 issues forming a season. The highlights from the first season have been compiled for your convenience. You can access them online [here](https://pythoncat.top/posts/2023-12-11-weekly) (Chinese).

## 🐿️Projects & Resources

1. [screenshot-to-code: Generate HTML/Tailwind/JS code from a screenshot](https://github.com/abi/screenshot-to-code)

A new project that's blowing up, it uses GPT-4 Vision to generate code and DALL-E 3 to generate a similar looking UI to the screenshot. You can even input a URL to clone a website in real time! (19.4k stars)

2. [sqlalchemy_data_model_visualizer: Convert SQLAlchemy data models into beautiful SVG diagrams](https://github.com/Dicklesworthstone/sqlalchemy_data_model_visualizer)

Generate high-quality visualizations of SQLAlchemy ORM models, using Graphviz to render each model as a directed graph, making it easier to understand the relationships between tables in your database.

![A directed graph of database tables](https://img.pythoncat.top/2023-11-25_sql.png)

3. [aiconfig: A configuration-driven AI application development framework](https://github.com/lastmile-ai/aiconfig)

It reduces complexity by separating prompts, model parameters, and model-related logic from application code. The SDK is model-agnostic and extensible to any generative AI model.

4. [PyNest: A framework built on FastAPI, following the modular architecture of NestJS](https://github.com/PythonNest/PyNest)

It allows you to easily build scalable and maintainable APIs, with support for dependency injection, type annotations, decorators, and code generation.

5. [StyleTTS2: A Near-Human Text-to-Speech Library](https://github.com/yl4579/StyleTTS2)

It achieves human-level TTS synthesis by leveraging style diffusion and adversarial training with a large-scale speech language model (SLM). (star 2.7K)

6. [pyjokes: A One-Liner Joke Generating Service for Programmers](https://github.com/pyjokes/pyjokes)

Once installed, simply call pyjoke from the command line or add it to your .bashrc file to get a joke every time you open your terminal.

7. [gTTS: Interact with Google's Text-to-Speech API](https://github.com/pndurette/gTTS)

This library calls Google Translate's Text-to-Speech API, providing customizable sentence tokenizers specific to a language, and customizable text preprocessors. (2K stars)

8. [chatfairy: A minimalist web chat room powered by Flask](https://github.com/yuxiaoy1/chatfairy)

A minimalist chat room application with both front-end and back-end code in a single file of only 115 lines. It uses SSE for back-end message pushing, does not rely on WebSockets, and supports user authentication, multi-user chat, online/offline notifications, and route protection. (Submitted by @yuxiaoy1)

![Chat demo](https://img.pythoncat.top/2023-11-25_chatfairy.png)

9. [streamlit-shadcn-ui: Use shadcn-ui components in Streamlit](https://github.com/ObservedObserver/streamlit-shadcn-ui)

Streamlit's component selection is relatively limited, and the style is relatively old. This project introduces the popular shadcn component library in the front end to Streamlit, making the UI more beautiful.

10. [video-subtitle-remover: Use AI to remove hard subtitles/watermarks from images/videos](https://github.com/YaoFANGUK/video-subtitle-remover)

It can remove hard subtitles in videos without loss of resolution, generate files after removing subtitles, and use AI to fill the original subtitle area; it supports custom subtitle positions and supports automatic removal of all text in the entire video.

11. [flowty-realtime-lcm-canvas: Sketch-to-image demo using LCM and gradio library](https://github.com/flowtyone/flowty-realtime-lcm-canvas)

Turn your sketch drawings into vivid images in real time. You can change the model ID in the UI to use different models. (1.5K stars)

12. [pyephem: Scientific-grade astronomy computations library](https://github.com/brandon-rhodes/pyephem)

Perform high-precision astronomical computations, used to find the positions of planets, comets, or asteroids, determine the location of a particular celestial body, calculate the dates of the Moon's phases, convert between astronomical coordinate systems, determine the dates of the vernal and autumnal equinoxes, and more.

This article was first published at: [https://pythoncat.top/posts/2023-11-25-weekly](https://pythoncat.top/posts/2023-11-25-weekly)

## 🐼Subscribe Welcome

- [Blog](https://pythoncat.top): Explore my independent blog where you can find a collection of original/translated technical articles over the years, along with some reflections since 2009.
- [Newsletter](https://pythoncat.substack.com/s/python-trending-weekly): Subscribe to my channel on Substack for a curated newsletter delivered straight to your inbox, keeping you updated on current affairs.
- [Github](https://github.com/chinesehuazhou/python-weekly): Access the Markdown source files of this weekly digest on Github and feel free to use them for anything you have in mind!
- [Telegram](https://t.me/pythontrendingweekly): Beyond notifications for the weekly digest, I consider it an "extra edition," providing additional, more diverse information.
- [Twitter](https://twitter.com/chinesehuazhou): Follow me on Twitter where my feed is filled with numerous accounts of developers and organizations in the Python community.