# Python Trending Weekly #27 (2023-11-18)

Welcome to the Python Trending Weekly, a weekly newsletter about Python, AI and general programming techniques, with the majority links in English and a small portion in Chinese. 

The [original version](https://pythoncat.top/posts/2023-11-18-weekly) of the weekly  was written in Chinese. What you are reading here is mostly translated by LLMs. 

**Substack Channel** : [Click to subscribe](https://pythoncat.substack.com/s/python-trending-weekly) 

## 🦄Articles & Tutorials

1. [Python Errors as Values: Comparing Usage Patterns in Go and Rust](https://www.inngest.com/blog/python-errors-as-values)

The article compares two approaches to error handling: raising exceptions and returning errors as values, and it shows how to implement error-as-value semantics in Python, with reference to Go and Rust. (Appendix 1: [Error Handling Styles](https://frostming.com/error-handling/) analyzes the advantages and disadvantages of the two styles and their appropriate usage scenarios; Appendix 2: [Four Error Handling Approaches in Programming Languages](https://pythoncat.top/posts/2023-05-08-error) compares different approaches from the perspectives of syntax, code readability, evolution, and runtime efficiency.)

2. [Debugging CSRF Failure/403 Forbidden Error in Django](https://www.better-simple.com/django/2023/11/04/debugging-csrf-error-in-production/)

A common error when deploying a Django application is `403 Forbidden` , which is usually caused by a CSRF error. This article introduces seven reasons that lead to this error and provides a detailed explanation of their verification logic by interpreting the Django source code.

3. [An Honest Review of Python Environments and Packaging Tools](https://alpopkes.com/posts/python/packaging_tools/)

There are so many virtual environments and packaging tools in Python! But how do you choose the right ones for your needs? The author provides a comprehensive review of 10+ tools across 5 categories, hoping to reduce the confusion for users. (Bonus: The author has two talks on this topic, [PyCon DE 2023](https://www.youtube.com/watch?v=MsJjzVIVs6M) and [EuroPython 2023](https://www.youtube.com/watch?v=3-drZY3u5vo).)

![Categorization of Python Environments and Packaging Tools](https://img.pythoncat.top/venn_diagram.png)

4. [Let's Create a Python Debugger Together - Part 1](https://mostlynerdless.de/blog/2023/09/20/lets-create-a-python-debugger-together-part-1/)

Have you ever wondered how a code debugger works? What happens when you set a breakpoint and the program hits it? Debuggers are one of the most important tools in a programmer's daily arsenal, yet few people know how they are implemented. This is a series of tutorials, with 5 posts so far. It's worth noting that the author is using the new Python 3.12 PEP-669 feature.

5. [Lifting the Veil on Python 3.12: What's New in the Python World?](https://blog.jetbrains.com/pycharm/2023/11/python-3-12/)

Python 3.12 was released a month and a half ago, have you started to try it out? This comprehensive article focuses on interpreting several new PEPs, giving you a clearer understanding of this version.

6. [Hash Tables in Python](https://stackabuse.com/hash-tables-in-python/)

Python's dictionary is a "hash table", which provides an efficient and flexible method for storing and retrieving data. The article introduces this data structure and how it works, and explores how to implement a hash table in Python and resolve hash collisions. This is a series of articles, and the author also wrote guides for data structures such as heaps, queues, stacks, and arrays.

7. [Running Untrusted Python Code](https://healeycodes.com/running-untrusted-python-code)

The author wanted to implement a simplified and less secure sandbox. The article introduces how it works and the solutions to some key problems, namely separate process + `seccomp` + `setrlimit`. (Also: [How to safely run Python code uploaded by others?](https://www.kingname.info/2023/11/11/python-run-other-code/) This article's solution is to build an image using Docker's Python SDK and execute the code in Docker.)

8. [Understanding the Linux cp Command and Implementing It in Python](https://muhammadraza.me/2023/linux-cp/)

This article delves into the inner workings of the `cp` command in Linux and then implements a basic version of it in Python. It showcases the power and simplicity that high-level programming languages provide.

9. [Beginners Should Use Django, Not Flask](https://www.bitecode.dev/p/beginners-should-use-django-not-flask)

The author believes that although Flask is simple and easy to use, it may cause beginners to overlook the complexity of web development. Django is comprehensive and has a mature ecosystem, which is more suitable for beginners to learn and improve productivity.

10. [PEP-733: Evaluating the Python Public C API](https://peps.python.org/pep-0733/)

An informational PEP to share information about the C API, including the purpose of defining the C API, stakeholders and their use cases and requirements, the advantages of the C API, and nine pain points of the C API.

11. [Let's Build a Silly JSON Parser](https://arunmani.in/articles/silly-json-parser/)

For the fun of programming, the author defined a set of JSON-like syntax rules, and then used Python to implement the extraction and parsing of different contents one by one, and developed a parser.

12. [How Big Should a Programming Language Be?](https://tratt.net/laurie/blog/2023/how_big_should_a_programming_language_be.html)

In the author's eyes, Python 1.5 is the last version he can fully understand, and the later versions make the language bigger and bigger. When designing a language, how to weigh the pros and cons of adding new features? The author suggests learning from the example of the C language and keeping the language in a "minimal evolution" mode.

🎁**PyCon China 2023**🎁This year's domestic PyCon will be held in Beijing, Shanghai, Chengdu, Hangzhou, Chongqing, Shenzhen, and Guangzhou in December. Tickets are now available at a 30% discount: [Details](https://mp.weixin.qq.com/s/lfrFoIiNuUYzgXPklQPLmg)

🎁 Python Trending Weekly 🎁 organizes its content into seasons, with every 30 issues forming a season. The highlights from the first season have been compiled for your convenience. You can access them online [here](https://pythoncat.top/posts/2023-12-11-weekly) (Chinese).

## 🐿️Projects & Resources

1. [CogVLM: A Multimodal Pre-trained Model](https://github.com/THUDM/CogVLM)

A powerful open-sourced visual-language model (VLM), CogVLM-17B has 10 billion visual parameters and 7 billion language parameters, featuring high performance and ranking top in multiple cross-modal benchmarks. (star 2.1K)

![CogVLM's Scores on Benchmarks](https://img.pythoncat.top/metrics-min.png)

2. [movis: A library for generating and editing videos](https://github.com/rezoo/movis)

This library allows you to generate various types of videos using Python code, including but not limited to demo videos, motion graphics, shader art coding, and gameplay walkthroughs. It supports video editing, audio clipping, layer transitions, and adding special effects.

3. [mirror: Real-time Q&A based on camera feed](https://github.com/cocktailpeanut/mirror)

This is a web app that streams your camera feed to an AI, which analyzes the content and answers your questions in real time. It's 100% local and private, with a web UI built using [gradio](https://www.gradio.app/) and a multimodal AI model called [Bakllava](https://huggingface.co/SkunkworksAI/BakLLaVA-1).

4. [vimGPT: Browse the web using GPT-4V and Vimium](https://github.com/ishan0102/vimGPT)

**Vimium** is a Chrome extension that lets you navigate the web using only your keyboard. With it, you can browse the web using only the visual capabilities of GPT-4V, without sending the browser DOM to the large model. (1.8k stars)

![Browse the web using GPT-4V and Vimium](https://img.pythoncat.top/2023-11-18_vimGPT.png)

5. [twitter_user_tweet_crawler: Crawl User Tweets without Calling Twitter API](https://github.com/kaixinol/twitter_user_tweet_crawler)

This tool uses Selenium to simulate browser operations, which allows you to crawl user tweets and save static resources locally, without the need to call the Twitter API. (Submitted by @kaixinol)

6. [RSS-OPML-to-Markdown: Convert OPML files to a readable Markdown format](https://github.com/AboutRSS/RSS-OPML-to-Markdown)

People often share their exported OPML files of RSS subscriptions, but they are hard to read and not suitable to import directly into your reader. This project outputs a Markdown table with an overview of your RSS feeds and some statistics, which makes it easy for you to subscribe to the ones you want. (Submission by @AboutRSS)

7. [MyHeyGen: Video Translation Tool](https://github.com/AIFSH/MyHeyGen)

A civilian video translation tool, audio translation, translation proofreading, video lip synthesis full process solution.

8. [awesome-python-repo-stats: Statistics about the projects in the "awesome-python" list](https://github.com/emanuelef/awesome-python-repo-stats)

[awesome-python](https://github.com/vinta/awesome-python) is a super popular project with 187K stars, collecting a large number of frameworks, libraries, software, and resources. This project is a statistical analysis of its included content, updated daily, and the statistical table can be viewed online.

9. [outlines: Guided Text Generation](https://github.com/outlines-dev/outlines)

A library for neural text generation, which can be seen as an alternative to the `generate` method in the transformers library. (3.3K stars)

10. [marimo: The Next Generation Python Notebook](https://github.com/marimo-team/marimo)

A brand-new notebook project where each notebook can be shared as an interactive web application to explore data, run experiments, build tools, and deploy applications.

![marimo usage demo](https://img.pythoncat.top/2023-11-18_marimo.png)

11. [Finance: 150+ Quantitative Finance Python Programs](https://github.com/shashankvemuri/Finance)

A collection of resources to help you collect, manipulate, and analyze stock market data. (1.2K stars)

12. [tacticalrmm: A Remote Monitoring and Management Tool](https://github.com/amidaware/tacticalrmm)

A remote monitoring and management tool built with Django, Vue, and Go. It features remote desktop control, remote file transfer, remote command and script execution, log viewing, alert management, and automation support, similar to Teamviewer. (2.3K stars)

## 🐢Podcasts & Videos

1. [CPython's JIT Compiler](https://www.youtube.com/watch?v=HxSHIpEQRjs)

Guido shared this video on X this week, in which the author presents their plans to develop a JIT compiler for Python 3.13! (Also see the [transcript of the talk](https://github.com/brandtbucher/brandtbucher/blob/master/2023/10/10/a_jit_compiler_for_cpython.pdf).)

2. [Episode 21 of The Python Show: Sanic - The Async Python Web Framework](https://www.blog.pythonlibrary.org/2023/11/10/episode-21-sanic-the-async-python-web-framework/)

Sanic is an asynchronous Python web framework that is fast to build and run. This episode features one of Sanic's maintainers and covers topics including web framework comparisons, message specifications, and [Mayim](https://github.com/ahopkins/mayim) (a unidirectional ORM).

This article was first published at: [https://pythoncat.top/posts/2023-11-18-weekly](https://pythoncat.top/posts/2023-11-18-weekly)

## 🐼Subscribe Welcome

- [Blog](https://pythoncat.top): Explore my independent blog where you can find a collection of original/translated technical articles over the years, along with some reflections since 2009.
- [Newsletter](https://pythoncat.substack.com/s/python-trending-weekly): Subscribe to my channel on Substack for a curated newsletter delivered straight to your inbox, keeping you updated on current affairs.
- [Github](https://github.com/chinesehuazhou/python-weekly): Access the Markdown source files of this weekly digest on Github and feel free to use them for anything you have in mind!
- [Telegram](https://t.me/pythontrendingweekly): Beyond notifications for the weekly digest, I consider it an "extra edition," providing additional, more diverse information.
- [Twitter](https://twitter.com/chinesehuazhou): Follow me on Twitter where my feed is filled with numerous accounts of developers and organizations in the Python community.