# Python Trending Weekly #26 (2023-11-11)

Welcome to the Python Trending Weekly, a weekly newsletter about Python, AI and general programming techniques, with the majority links in English and a small portion in Chinese. 

The [original version](https://pythoncat.top/posts/2023-11-11-weekly) of the weekly  was written in Chinese. What you are reading here is mostly translated by LLMs. 

**Substack Channel** : [Click to subscribe](https://pythoncat.substack.com/s/python-trending-weekly) 

## 🦄Articles & Tutorials

1. [Kenneth Reitz: Belated Apology and Progress on requests 3](https://kennethreitz.org/essays/why-im-not-collaborating-with-kenneth-reitz)

In 2019, there was a bit of a kerfuffle over the funding of requests 3, and then it seemed to go quiet. Now the author has posted an apology, and it looks like the project is back on! The post lists some of the things that have been done so far, including typing all of the public interfaces, refactoring all of the namespaces, and making it async compatible. (See also: the funding kerfuffle: [Why I'm not collaborating with Kenneth Reitz](https://vorpus.org/blog/why-im-not-collaborating-with-kenneth-reitz/))

2. [grequests: Making Asynchronous HTTP Requests](https://coderslegacy.com/python-grequests-making-asynchronous-http-requests/)

Built on top of the `gevent` library, `grequests` allows you to make multiple requests concurrently, harnessing the power of asynchronous programming. This introductory tutorial covers its basic usage along with a tip to enhance performance.

3. [Developing a Python Compiler and Interpreter](https://mathspp.com/blog/tag:bpci)

This is a series of blog posts, currently at 6 posts, that aims to explore and investigate the concepts and algorithms required to implement a programming language like Python, covering topics such as lexers, parsers, compilers, and interpreters.

4. [Build an AI Tool to Summarize Books Instantly with Python + ChatGPT](https://levelup.gitconnected.com/build-an-ai-tool-to-summarize-books-instantly-828680c1ceb4)

A tutorial to build a book summarization tool using Python, Langchain, and OpenAI embeddings. The author also published an [online demo](https://gptsummarizer.streamlit.app/) using Streamlit.

![AI Summarizes Books](https://img.pythoncat.top/2023-11-10_book.png)

5. [Database Generated Columns: Django & SQLite](https://www.paulox.net/2023/11/07/database-generated-columns-part-1-django-and-sqlite/)

`GeneratedField` is a new feature in the upcoming Django 5.0 that leverages the database's ability to automatically compute the value of a data column. The author, a Django contributor, tested various scenarios of using this new feature in SQLite. (P.S. The article also introduces some other [new goodies in Django 5.0](https://fly.io/django-beats/new-goodies-in-django-50/).)

6. [You Can Do These Things with Python's bisect Module](https://martinheinz.dev/blog/106)

The `bisect` module only has two functions, but it can do a lot of things. The article introduces: binary search, prefix search, finding consecutive equal values in a list, finding the closest key in a dictionary, sorting custom objects, searching by dictionary key.

7. [Why Building SciPy for Python 3.12 on Windows Is a Minor Miracle](https://labs.quansight.org/blog/building-scipy-with-flang)

Whenever Python releases a new version, maintainers of third-party libraries scramble to make their packages compatible. It's not easy. The author describes the daunting challenges they faced, which are really just the Python community's long-standing packaging problems. Fortunately, the maintainers found a workable solution.

8. [Web Scraping and Parsing Experiment with AI (HTML Parsing with GPT-4)](https://serpapi.com/blog/web-scraping-and-parsing-experiment-with-ai-openai/)

OpenAI has released a new model, but how capable is it? What are the advantages and disadvantages of using GPT-4 for web scraping? The article experiments with scraping a well-structured website, scraping Google organic search results, scraping Google SERP, and scraping Google MAPS results.

9. [Django vs Flask: Which Is the Best Python Web Framework?](https://blog.jetbrains.com/pycharm/2023/11/django-vs-flask-which-is-the-best-python-web-framework/)

Which one should you choose between the two most popular web frameworks in the Python world? This is an in-depth and lengthy article that compares them in detail in terms of templating system, URL dispatcher, database support, authentication and authorization, testing, software architecture, learning curve, and more. There is no better one, only the one that suits you better.

![Web Frameworks Usage Share](https://img.pythoncat.top/web-frameworks.png)

10. [The Right Way to Install Python on Mac](https://marvelousmlops.substack.com/p/the-right-way-to-install-python-on)

How do you install Python on your new M2 MacBook? In this hands-on tutorial, the author suggests using **Pyenv + pyenv-virtualenv**.

11. [Simple Android Data Analytics App in Python](https://www.techbeamers.com/simple-android-data-analytics-app-in-python/)

This tutorial guides you to build an Android data analytics app that logs and displays the time you spend on your screen throughout the day. It uses `kivy` as the GUI framework and `Pandas` for data analysis.

12. [Improving the Python API of Numpy in Preparation for Version 2.0](https://labs.quansight.org/blog/numpy-python-api-cleanup)

NEP-52 is an enhancement proposal for Numpy that aims to identify, refactor, and deprecate outdated, duplicated, and unused Python APIs in Numpy. This work is in preparation for a smooth transition to Numpy 2.0. The author shares the challenges and some of the achievements he has made in this effort.

🎁**Python Developers Survey**🎁 The official 7th annual survey to understand the state of the Python developer community. Take a few minutes to fill out the survey: [Survey Link](https://survey.alchemer.com/s3/7554174/python-developers-survey-2023)

🎁 Python Trending Weekly 🎁 organizes its content into seasons, with every 30 issues forming a season. The highlights from the first season have been compiled for your convenience. You can access them online [here](https://pythoncat.top/posts/2023-12-11-weekly) (Chinese).

## 🐿️Projects & Resources

1. [pyvideotrans: Video language translation and dubbing](https://github.com/jianchang512/pyvideotrans)

A video translation tool that can translate a video from one language to another and dub it. (star 1.4K)

2. [pyink: Google's fork of Black, a code formatter](https://github.com/google/pyink)

A fork of Black designed to address issues that arise from having thousands of engineers working in a monorepo at Google.

3. [sqlmodel: SQL Database for Python](https://github.com/tiangolo/sqlmodel)

An SQL database from the creator of FastAPI, combining the power of SQLAlchemy and Pydantic with a focus on simplicity, compatibility, and robustness. (11.2k stars)

4. [Wagtail: A Django Content Management System](https://github.com/wagtail/wagtail)

Wagtail is a Django-based CMS (Content Management System) that focuses on user experience. In the previous issue, we shared an article titled "[Why Is the Django Admin Ugly?](https://www.coderedcorp.com/blog/why-is-the-django-admin-ugly/)." Wagtail is the best recommendation for end users. (16.2k stars)

![Wagtail's beautiful interface design](https://img.pythoncat.top/2023-11-09-wagtail.png)

5. [NBA-Machine-Learning-Sports-Betting: NBA Game Predictions Using Machine Learning](https://github.com/kyleskom/NBA-Machine-Learning-Sports-Betting)

A machine learning AI to predict the outcome of NBA games. Includes team data from the 2007-08 season to the current season.

6. [Python_EBook_Free: Python E-books and Resources](https://github.com/FarhaKousar1601/Python_EBook_Free)

This repository archives a collection of Python e-books and learning resources, all in PDF format.

7. [pathway: A high-throughput and low-latency real-time data processing framework](https://github.com/pathwaycom/pathway)

A data processing framework that combines batch, streaming, and real-time APIs of LLM programs, which can interact with various data sources (e.g., Kafka, CSV files, SQL/noSQL databases, and REST APIs).

8. [Prefect: A workflow orchestration tool for building data pipelines](https://github.com/PrefectHQ/prefect)

It is an orchestrator for data-intensive workflows that turns Python functions into observable and composable units of work. It supports features such as automatic retries, distributed execution, scheduling, caching, and has a powerful dashboard for monitoring. (13.2k stars)

![Prefect's dashboard](https://img.pythoncat.top/cloud-dashboard.png)

9. [VideoCrafter: High-Quality Video Generation Model](https://github.com/AILab-CVC/VideoCrafter)

A video generation and editing tool that supports high-definition video. It currently includes two models: text-to-video and image-to-video. (3K stars)

10. [42 Developer Resources to Kickstart Your Coding Journey](https://madza.hashnode.dev/42-developer-resources-to-kickstart-your-coding-journey)

This article compiles a list of essential resources, courses and tutorials, coding games, books, podcasts, YouTube channels, best practices, and more.

11. [networkx: Python Package for Network Analysis](https://github.com/networkx/networkx)

Used for the creation, manipulation, and study of the structure, dynamics, and functions of complex networks. It is designed for the analysis of complex networks. (13.4K stars)

12. [PythonFrameworks: A Collection of Python Frameworks](https://github.com/jgu-bytes/PythonFrameworks)

This project collects various frameworks in Python, including web frameworks, API frameworks, CMS, ML&DL&AI, task/message queues, parallel & distributed computing, workflow & pipelines, DevOps, web scraping, GUI&TUI, and more. An [online website](https://pythonframeworks.com/) is also provided.

![A subset of web frameworks](https://img.pythoncat.top/2023-11-10_framework.png)

## 🐢Podcasts & Videos

1. [core.py: A New Python Podcast](https://podcasters.spotify.com/pod/show/corepy)

Hosted by Python core developers Pablo Galindo and Łukasz Langa, the podcast has already released two episodes: [Core Sprint in Brno & Python 3.13.0 alpha 1](https://podcasters.spotify.com/pod/show/corepy/episodes/Episode-1---Core-Sprint-in-Brno--Python-3-13-0-alpha-1-e2apebk) and [PEP-703: Removing the GIL](https://podcasters.spotify.com/pod/show/corepy/episodes/Episode-2---PEP-703-Removing-the-GIL-e2b8egi)

2. [Why Static Typing Is Making a Come back](https://www.youtube.com/watch?v=Tml94je2edk)

Dynamically typed programming languages like Python, Ruby, PHP, and JavaScript, which emerged in the 1990s, are embracing static typing (mypy, Sorbet, Hack, and TypeScript), and relatively new languages like Go, Kotlin, Dart, and Rust are statically typed. Why is static typing making a comeback? What does this mean for the future?

3. Two podcast episodes with the author of *Boost Your Git DX*

After the release of his new book *Boost Your Git DX*, [Adam Johnson](https://twitter.com/AdamChainz) was featured on two podcast episodes: [Real Python Podcast #179](https://realpython.com/podcasts/rpp/179/) and [Pybites #139](https://pybit.es/articles/maximizing-your-dx-with-adam-johnson/).

## 🐼Subscribe Welcome

- [Blog](https://pythoncat.top): Explore my independent blog where you can find a collection of original/translated technical articles over the years, along with some reflections since 2009.
- [Newsletter](https://pythoncat.substack.com/s/python-trending-weekly): Subscribe to my channel on Substack for a curated newsletter delivered straight to your inbox, keeping you updated on current affairs.
- [Github](https://github.com/chinesehuazhou/python-weekly): Access the Markdown source files of this weekly digest on Github and feel free to use them for anything you have in mind!
- [Telegram](https://t.me/pythontrendingweekly): Beyond notifications for the weekly digest, I consider it an "extra edition," providing additional, more diverse information.
- [Twitter](https://twitter.com/chinesehuazhou): Follow me on Twitter where my feed is filled with numerous accounts of developers and organizations in the Python community.