# Python Trending Weekly #25 (2023-11-04)

Welcome to the Python Trending Weekly, a weekly newsletter about Python, AI and general programming techniques, with the majority links in English and a small portion in Chinese. 

The [original version](https://pythoncat.top/posts/2023-11-04-weekly) of the weekly  was written in Chinese. What you are reading here is mostly translated by LLMs. 

**Substack Channel** : [Click to subscribe](https://pythoncat.substack.com/s/python-trending-weekly) 

## 🦄Articles & Tutorials

1. [Ruff: A Blazing Fast, Black-Compatible Python Formatter](https://astral.sh/blog/the-ruff-formatter)

I introduced Ruff, the fastest code analysis tool, in April this year, and found that it is not limited to the positioning of Linter, but also provides some Formatter functions. Now, it has released a major update and officially become the fastest Python code formatter, which is more than 30 times faster than **Black** and 100 times faster than **YAPF**!

![Performance without cache, formatting about 250,000 lines of code](https://img.pythoncat.top/2023-11-04_ruff.png)

2. [When Should You Upgrade to Python 3.12?](https://pythonspeed.com/articles/upgrade-python-3.12/)

Python 3.12 is out, and you are eager to upgrade. Is now the best time to make the jump to 3.12? The article suggests that you wait until December for the 3.12.1 bug-fix release because the new version has these issues: incompatible packages, missing binary packages, and every major release has a bunch of issues that need to be fixed.

3. [Python 3.12: An Epic Release That Went Under the Radar](https://www.manjusaka.blog/posts/2023/10/29/the-most-important-thing-in-python-3-12/)

The author believes that Python 3.12 is more significant to Python than 3.5's "async/await" and 3.6's "Type Hint"! The author mainly analyzes three aspects of improvement: observability brought by PEP-669, performance improvement brought by PEP-684 for non-GIL, and the new C API in PEP-697 that ensures compatibility across versions.

4. [Do Not Use requirements.txt Anymore](https://quanttype.net/posts/2023-10-31-do-not-use-requirements.txt.html)

The author provides two suggestions: do not use pip and `requirements.txt` to manage Python dependencies, and recommends using Poetry instead. The main problems with pip are the lack of a lockfile and the hassle of manually managing virtual environments. In addition to Poetry, the author also mentions Hatch and PDM.

5. [Why Is the Django Admin Interface So Ugly?](https://www.coderedcorp.com/blog/why-is-the-django-admin-ugly/)

Django provides a default admin interface, Django Admin, whose UI hasn't changed in many years and looks outdated. Why don't Django maintainers improve it? The author found out its history and the reasons for such design by interviewing several maintainers. The main point is that Django Admin is for internal administrators and shouldn't be exposed to end users.

![Django Admin Interface](https://img.pythoncat.top/2023-11-04_django_admin.png)

6. [My User Experience Porting Off setup.py](https://gregoryszorc.com/blog/2023/10/30/my-user-experience-porting-off-setup.py/)

A long article by the author of PyOxidizer, who encountered an issue where `python setup.py` in CI failed with setuptools import errors when using Python 3.12 for another library. The author went through a complex and time-consuming process to find a solution, highlighting the confusing state of Python's packaging ecosystem.

7. [Boost Your Coding Efficiency with Ptpython](https://realpython.com/ptpython-shell/)

Ptpython is a feature-rich and user-friendly Python REPL, and this is a very detailed tutorial on how to use it. The highlighted features include history, input validation, autocompletion, automatic indentation handling, customizing the interactive shell, embedding ptpython in scripts, and more.

8. [100% Test Coverage Is Not Enough: Property-Based Testing in Python](https://blog.robertroskam.com/p/100-test-coverage-is-not-enough)

While test coverage is important, it is not a silver bullet. This article demonstrates the shortcomings of test coverage with examples and briefly introduces how to do property-based testing with Hypothesis.

9. [Writing an ASGI Web Framework from Scratch in Python](https://www.cnblogs.com/hanabi-cnblogs/p/17792740.html)

Is it difficult to write an asynchronous ASGI web framework from scratch? What knowledge do you need to know, what functions do you need to implement, and what problems do you need to think about? This step-by-step tutorial is a great learning material, allowing you to understand web framework design, asynchronous programming, functional encapsulation, and project management.

![The lifecycle of a request](https://img.pythoncat.top/20231026181957.png)

10. [How to Hide Plaintext Passwords in Python Logs?](https://www.cnblogs.com/frankming/p/17762591.html)

It is a security requirement not to print plaintext passwords in logs, but there are too many possible scenarios where passwords may be printed. How can plaintext passwords be hidden efficiently? This article introduces two implementation schemes based on the **logging** module: a custom filter and a custom formatter, which use specific rules to filter plaintext passwords.

11. [From Chaos to Cohesion: Building Your Own Monorepo](https://monadical.com/posts/from-chaos-to-cohesion.html)

A monorepo is a code repository that stores all projects, possibly containing different languages and frameworks. This means that its dependency management and CI/CD are different from those of ordinary code repositories. This article introduces how to use GitHub Actions as a CI/CD tool to build a simple Python monorepo.

12. [Python Is a Compiled Language](https://eddieantonio.ca/blog/2023/10/25/python-is-a-compiled-language/)

We are used to calling Python an interpreted language because it interprets and executes code line by line at runtime. Many people also know that Python actually has a compilation process, and the interpreter compiles before executing. However, the author does not stop there. Through Socratic dialogue and several rounds of experiments, he leads readers to rethink "interpretation" and "compilation": they are false dichotomies that limit the possibilities of programming languages. Python is both an interpreted and a compiled language!

🎁 Python Trending Weekly 🎁 organizes its content into seasons, with every 30 issues forming a season. The highlights from the first season have been compiled for your convenience. You can access them online [here](https://pythoncat.top/posts/2023-12-11-weekly) (Chinese).

## 🐿️Projects & Resources

1. [ccxt: Cryptocurrency trading API with support for 100+ exchanges](https://github.com/ccxt/ccxt)

A JavaScript/Python/PHP/C# library for cryptocurrency trading with support for many Bitcoin/Ethereum/Altcoin exchange markets and merchant APIs. (star 29.5K)

2. [uDjango: A Django microproject in a single file](https://github.com/pauloxnet/uDjango)

This project is a demo project for DjangoCon US 2023, showing a minimal Django application in a single file with less than 10 lines of code.

3. [esmerald: Highly Scalable, High-Performance Web Framework](https://github.com/dymmond/esmerald)

A ready-to-use web framework built on top of Starlette and Pydantic for building modern scalable API applications, supporting both synchronous and asynchronous, providing features like DAO, ORM, ODM, dependency injection, permission management, etc.

![](https://img.pythoncat.top/2023-11-04_esmerald.png)

4. [Python-Type-Challenges: Learn Python Type Hints Through Online Challenges](https://github.com/laike9m/Python-Type-Challenges)

An interesting project that includes a series of challenges from beginner to advanced levels, allowing you to practice using type hints online.

5. [Mify: Microservice Infrastructure, Code Generation Tool](https://github.com/mify-io/mify)

Generates OpenAPI http server, built-in Prometheus metrics, provides structured logging, supports multiple language code generation.

6. [de4py: Python Reverse Engineering Toolkit](https://github.com/Fadi002/de4py)

A state-of-the-art Python deobfuscator designed for malware analysts and reverse engineers, featuring a beautiful UI and a bunch of advanced features.

7. [public-apis: A collective list of public APIs for developers](https://github.com/public-apis-dev/public-apis)

A very, very extensive list of public APIs, covering pretty much everything under the sun. (2k stars)

8. [FunASR: End-to-End Speech Recognition Toolkit](https://github.com/alibaba-damo-academy/FunASR)

FunASR is an open-source speech recognition toolkit developed by Alibaba DAMO Academy. It provides a range of functionalities, including automatic speech recognition (ASR), voice activity detection (VAD), punctuation restoration, language modeling, speaker verification, speaker separation, and multi-party conversation speech recognition. (1.2K stars)

9. [XHS_Downloader: A Tool for Downloading Xiaohongshu Images and Videos](https://github.com/JoeanAmier/XHS_Downloader)

Supports downloading Xiaohongshu images and videos in batches, with a mechanism for ensuring the integrity of the downloaded files.

![Image of XHS_Downloader](https://img.pythoncat.top/2023-11-04-xhs.png)

10. [RSS-GPT: Generate Summaries for Your RSS Feeds Using ChatGPT](https://github.com/yinan-c/RSS-GPT)

Uses a simple Python script, automated with GitHub workflow, to call the OpenAI API to generate summaries for RSS feeds, then pushes the newly generated RSS feed to GitHub Pages. Easy and quick to set up, no server required.

11. [codespell: A Tool for Checking Code for Common Misspellings](https://github.com/codespell-project/codespell)

Checks source code for misspelled words, supports multiple running modes, can specify ignored words and files, and can be used for pre-commit. (1.5K stars)

12. [codeshell: A Large-Scale Code Model Foundation in Multiple Languages](https://github.com/WisdomShell/codeshell)

With 7 billion parameters, trained on 500 billion tokens, and a context window length of 8192, CodeShell achieves state-of-the-art performance on authoritative code evaluation benchmarks. (1.2K stars)

## 🐼Subscribe Welcome

- [Blog](https://pythoncat.top): Explore my independent blog where you can find a collection of original/translated technical articles over the years, along with some reflections since 2009.
- [Newsletter](https://pythoncat.substack.com/s/python-trending-weekly): Subscribe to my channel on Substack for a curated newsletter delivered straight to your inbox, keeping you updated on current affairs.
- [Github](https://github.com/chinesehuazhou/python-weekly): Access the Markdown source files of this weekly digest on Github and feel free to use them for anything you have in mind!
- [Telegram](https://t.me/pythontrendingweekly): Beyond notifications for the weekly digest, I consider it an "extra edition," providing additional, more diverse information.
- [Twitter](https://twitter.com/chinesehuazhou): Follow me on Twitter where my feed is filled with numerous accounts of developers and organizations in the Python community.