# Python Trending Weekly #24 (2023-10-29)

Welcome to the Python Trending Weekly, a weekly newsletter about Python, AI and general programming techniques, with the majority links in English and a small portion in Chinese. 

The [original version](https://pythoncat.top/posts/2023-10-29-weekly) of the weekly  was written in Chinese. What you are reading here is mostly translated by LLMs. 

**Substack Channel** : [Click to subscribe](https://pythoncat.substack.com/s/python-trending-weekly) 

## 🦄Articles & Tutorials

1. [PEP-703 Progress on a No-GIL CPython](https://lwn.net/Articles/947138/)

PEP-703 is a proposal that came out of the no-GIL project, and this week, the Python Steering Council announced that they had accepted it! This article was written a couple of weeks before the announcement, and it summarizes the technical thinking and progress that had happened up to that point. (See also: [PEP-703 discussion](https://discuss.python.org/t/pep-703-making-the-global-interpreter-lock-optional/22606/123).)

2. [PEP-730 CPython Provides Official Support for iOS](https://peps.python.org/pep-0730/)

This is a new proposal that suggests CPython provide Tier 3 support for the iOS operating system. If the proposal is accepted, Python will have a wider range of uses. [BeeWare](https://beeware.org/) and [Kivy](https://kivy.org/) are Python app development frameworks that support iOS, demonstrating the feasibility of the technology.

3. [The Next Step in Django Development: Advanced Features to Consider](https://www.pythoncentral.io/the-next-step-in-django-development-advanced-features-to-consider/)

This article explores integrating advanced features into your Django application, such as implementing a WYSIWYG editor, user authentication and authorization, real-time communication features, asynchronous tasks, integrating Elasticsearch for full-text search, and test automation and continuous integration.

4. [Developing an Asynchronous Task Queue in Python](https://testdriven.io/blog/developing-an-asynchronous-task-queue-in-python/)

Introduces a simple task queue implemented using multiprocessing.Pool, multiprocessing.Queue, and Redis, which enables basic task scheduling and processing.

5. [Flask, Its Ecosystem, and Backwards Compatibility](https://pgjones.dev/blog/flask-ecosystem-compatibility-2023/)

Last week's newsletter featured a rant about how Flask's backwards compatibility is bad (see below), and this is a response from one of Flask's maintainers.

6. [Continuing the discussion about Flask](https://blog.miguelgrinberg.com/post/some-more-to-talk-about-flask)

This is a follow-up to last week's [We have to talk about Flask](https://blog.miguelgrinberg.com/post/we-have-to-talk-about-flask), where the author received some positive and negative feedback and continues the conversation, mainly rebutting some points.

7. [Introducing rip - A fast and minimal pip implementation](https://prefix.dev/blog/introducing_rip)

rip is a PyPI package parsing and installation library written in Rust, or a pip written in Rust. It attempts to build a solid bridge between Conda and PyPI, and the article introduces some of the work it does to overcome the main differences between the two (metadata extraction, Wheel file metadata, dependency specification).

8. [Speeding Up Data Analysis by 180,000x with Rust](https://willcrichton.net/notes/k-corrset/)

How can you use Rust to implement critical code to improve the performance of a Python program? The article optimizes the implementation of the k-CorrSet problem in several ways, resulting in a significant speed improvement.

9. [What is a lambda expression?](https://www.pythonmorsels.com/lambda-expressions/)

What is a lambda expression and a lambda function? How does a lambda function differ from other functions in Python? What are its limitations, when should you avoid using it, and where is it commonly used?

10. [DIY a Video Translation and Dubbing Tool, Not Quite There Yet](https://juejin.cn/post/7293420609088798731)

Video translation is the process of taking a video in its original language and displaying it with subtitles and dubbing in another language. This article is a low-cost attempt, with the following tech stack: speech recognition using the openai-whisper offline model, text translation using the Google API, and text-to-speech using Microsoft Edge TTS.

11. [Mastering Integration Testing with FastAPI](https://alex-jacobs.com/posts/fastapitests/)

Integration testing is the practice of testing a group of code units as a whole. This article introduces methods for integration testing with FastAPI, including how to mock authentication, how to mock external APIs, how to mock MongoDB interactions, and how to mock AWS S3.

12. [Tool for Converting Python Code to LATEX Formulas](https://www.biaodianfu.com/latexify-python.html)

latexify_py is a Google open-source Python package that can compile Python source code snippets into corresponding LaTeX expressions. This article introduces how to use it, including how to convert Python functions to formulas, Latexify parameter settings, and Latexify pseudocode generation.

🎁 Python Trending Weekly 🎁 organizes its content into seasons, with every 30 issues forming a season. The highlights from the first season have been compiled for your convenience. You can access them online [here](https://pythoncat.top/posts/2023-12-11-weekly) (Chinese).

## 🐿️Projects & Resources

1. [Celery: Distributed Task Queue](https://github.com/celery/celery)

A mature task queue library in Python, supporting message brokers like RabbitMQ and Redis, and it's easy to integrate with mainstream web frameworks. (22.4k stars)

2. [rq: A Simple Job Queue](https://github.com/rq/rq)

RQ (Redis Queue) is a simple job queue based on Redis, which is easy to use and supports features like queuing, scheduling, and retries. (9.2k stars)

3. [huey: Lightweight task queue](https://github.com/coleifer/huey)

A simple, lightweight task queue library supporting Redis, SQLite, file system and in-memory storage, and supporting multi-process, multi-thread or Greenlet task execution models. (4.7K stars)

4. [rip: Rapid Install and Packaging of Python Packages (Rust implementation of pip)](https://github.com/prefix-dev/rip)

A pip implementation in Rust, supporting downloading, parsing, and installing PyPI packages, with support for wheels (partially) and planned support for sdist files.

5. [Selenium-python-helium: Web automation library that makes Selenium even better](https://github.com/mherrmann/selenium-python-helium)

Selenium is one of the best libraries for web automation, and Helium is a wrapper around it that makes web automation even easier. In addition to a high-level API, it simplifies web driver management, supports interaction with elements in nested iFrames, supports implicit waits, and supports explicit waits. (3.6k stars)

6. [rendercv: Create PDF Resumes from YAML/JSON](https://github.com/sinaatalay/rendercv)

It supports parsing YAML and JSON resume files, creating a latex file, and then rendering it to PDF. Currently, there is only one theme available.

7. [latexify_py: Generate LaTeX expressions with Python code](https://github.com/google/latexify_py)

Compile Python source or AST to LaTeX, enabling pretty printing of compiled functions with IPython. (6.5k stars)

8. [localpilot: Github Copilot on Mac](https://github.com/danielgross/localpilot)

A programming assistant that runs locally on your Macbook, with very easy setup and usage. (2.6k stars)

9. [annoy: Approximate Nearest Neighbors in C++/Python](https://github.com/spotify/annoy)

For searching points in a space that are close to a given query point, the major difference from other similar libraries is that it can use a static file as an index, which enables sharing the index across processes. It is used by Spotify for music recommendations. (12.1k stars)

10. [voyager: Approximate Nearest Neighbor Search Library for Python and Java](https://github.com/spotify/voyager)

Performs fast approximate nearest neighbor search on a collection of vectors in memory. Also from Spotify, it handles billions of queries per day, serving a large user base. It has a higher recall rate than annoy.

11. [Test-Agent: China's First Large Model Tool for the Testing Industry](https://github.com/codefuse-ai/Test-Agent)

It aims to build an "intelligent agent" in the field of testing, integrating large models and engineering technology in the field of quality, and promoting the upgrading of quality technology generations. The TestGPT-7B model, which is open source, is based on CodeLlama-7B.

12. [waymax: A JAX-based Simulator for Autonomous Driving Research](https://github.com/waymo-research/waymax)

Waymo is an autonomous driving company under Google, and Waymax is its open-source, lightweight, multi-agent, JAX-based autonomous driving simulator that can be easily distributed and deployed on hardware accelerators such as GPUs and TPUs.

## 🐢Podcasts & Videos

1. [Code Generation in Python: Dismantling Jinja](https://www.youtube.com/watch?v=jXlR0Icvvh8)

A 2012 talk by Armin Ronacher, the lead author of Jinja, where he explains the design of Jinja's compiler infrastructure, why it was designed that way, and how it evolved over different versions. (Slides: [here](https://speakerdeck.com/mitsuhiko/code-generation-in-python-dismantling-jinja))

2. [Let's Talk About Templates](https://www.youtube.com/watch?v=rHmljD-oZrY)

Armin Ronacher's 2014 talk compares Jinja and Django's templating, analyzing the historical reasons for their very different designs. (Slides: [speakerdeck.com/mitsuhiko/lets-talk-about-templates](https://speakerdeck.com/mitsuhiko/lets-talk-about-templates))

3. [JupyterCon 2023 Videos 86](https://www.youtube.com/playlist?list=PL_1BH3ug7n1Ih_Yy2TmM7MZ2zogSLZvzE)

JupyterCon is an annual event focused on Jupyter applications and tools, covering topics such as data science, machine learning, scientific computing, data visualization, education, and research.

## 🐼Subscribe Welcome

- [Blog](https://pythoncat.top): Explore my independent blog where you can find a collection of original/translated technical articles over the years, along with some reflections since 2009.
- [Newsletter](https://pythoncat.substack.com/s/python-trending-weekly): Subscribe to my channel on Substack for a curated newsletter delivered straight to your inbox, keeping you updated on current affairs.
- [Github](https://github.com/chinesehuazhou/python-weekly): Access the Markdown source files of this weekly digest on Github and feel free to use them for anything you have in mind!
- [Telegram](https://t.me/pythontrendingweekly): Beyond notifications for the weekly digest, I consider it an "extra edition," providing additional, more diverse information.
- [Twitter](https://twitter.com/chinesehuazhou): Follow me on Twitter where my feed is filled with numerous accounts of developers and organizations in the Python community.