# Python Trending Weekly #23 (2023-10-22)

Welcome to the Python Trending Weekly, a weekly newsletter about Python, AI and general programming techniques, with the majority links in English and a small portion in Chinese. 

The [original version](https://pythoncat.top/posts/2023-10-22-weekly) of the weekly  was written in Chinese. What you are reading here is mostly translated by LLMs. 

**Substack Channel** : [Click to subscribe](https://pythoncat.substack.com/s/python-trending-weekly) 

## 🦄Articles & Tutorials

1. [20 Exciting Python Project Ideas](https://dev.to/praise002/20-exciting-python-project-ideas-3la9)

People often ask: Are there any simple and easy-to-use Python projects to recommend? You may want to read this article, which introduces 20 small project ideas. In addition, the original author has implemented many projects, and the source code can be obtained from the [repository address](https://github.com/praise002/20-python-project) in the article.

2. [Python 3.11 vs Python 3.12 Performance Testing](https://en.lewoniewski.info/2023/python-3-11-vs-python-3-12-performance-testing/)

The article provides detailed figures for a total of 91 benchmarks run on different machines equipped with AMD Ryzen 7000 series and 13th Gen Intel Core processors.

3. [When I met Guido van Rossum](https://blog.adarshd.dev/posts/when-i-met-guido-van-rossum/)

The author gave a talk titled "Metaprogramming with Metaclasses in Python" at Pycascades this year and met Guido, where they discussed some topics on using Python and how to become a CPython core developer.

4. [Learn by Reading Code: Design Decisions in the Python Standard Library](https://death.andgravity.com/stdlib)

One way for programmers to improve their skills is to read a lot of good code, and the Python standard library is a great place to start. But with so much to choose from, where should you start? The author of this article recommends these: **statistics, pathlib, dataclasses, graphlib**.

5. [Accepting Payments with Stripe, Vue.js, and Flask](https://testdriven.io/blog/accepting-payments-with-stripe-vuejs-and-flask/)

Chinese people are not willing to pay for content, so most independent developers who choose to go overseas to make money will choose to use a Stripe account. This tutorial uses Stripe to implement the payment function of the website. The front-end and back-end technology stacks are Vue and Flask.

6. [Three Ways to Call Rust from Python](https://blog.frankel.ch/rust-from-python/)

Introduces three ways to call Rust from Python: HTTP, IPC (inter-process communication), and FFI (foreign function interface).

7. [How to Develop Middleware for FastAPI?](https://semaphoreci.com/blog/custom-middleware-fastapi)

FastAPI comes with a number of built-in middleware, but you might also need to tailor your own. The article introduces the principle of FastAPI middleware and the built-in middleware, then implements custom middleware based on functions and classes, and provides best practice suggestions and corresponding test cases.

8. [Passwordless Authentication Options in Django](https://www.honeybadger.io/blog/options-for-passwordless-authentication-in-django/)

This article introduces three passwordless authentication methods: email-based authentication, authentication using OAuth, and authentication using magic links; it also introduces their advantages, limitations, and precautions for use.

9. [4 Tools to Improve Your Python Development Workflow Before Shipping Your Project](https://thetechbuffet.substack.com/p/improve-python-development-workflow)

What tools can simplify your development workflow and help you follow industry best practices for building quality software? This article shares four useful tools: **Poetry, Pre-commit hooks, Makefiles, and python-dotenv**.

10. [We Have to Talk About Flask](https://blog.miguelgrinberg.com/post/we-have-to-talk-about-flask)

Flask recently released version 3.0, and Werkzeug also released version 3.0, but it introduced backward-incompatible changes! The author complains about Flask's recurring problem with incompatible versions, providing examples and analyzing the reasons. He urges the Flask core developers to avoid gratuitous refactoring and to think twice before making changes. (This article is written by the author of the book "Flask Web Development".)

11. [Removing Watermarks from Images and Videos Using ProPainter](https://juejin.cn/post/7288998044020326415)

This article introduces the use of the ProPainter framework to solve the problem of removing watermarks from videos. It introduces a novel approach of dual-domain propagation and an efficient mask-guided video transformer, which enhance the performance of video restoration while maintaining computational efficiency and reducing costs.

12. [Python Now Works in Google Sheets](https://thenewstack.io/python-comes-to-google-sheets/)

In August, Microsoft enabled Python support in Excel, and now a company called Neptyne has launched a product that brings Python functionality to Google Sheets. This article provides an overview of its features.

🎁 Python Trending Weekly 🎁 organizes its content into seasons, with every 30 issues forming a season. The highlights from the first season have been compiled for your convenience. You can access them online [here](https://pythoncat.top/posts/2023-12-11-weekly) (Chinese).

## 🐿️Projects & Resources

1. [A Python Quiz Website](http://python.jpglomot.com/#/questions)

A simple website with nearly a hundred multiple-choice questions, mostly related to Python's basic syntax. Come and test how much you've learned!

2. [CardStock: A Cross-Platform GUI Building Tool](https://github.com/benjie-git/CardStock)

It provides an editor similar to a drawing program for building graphical user interfaces, supporting elements such as text, graphics, images, buttons, input boxes, and web views; it provides a code editor that can add event-driven Python code.

3. [python-package-template: Standardized Python package template](https://github.com/Undertone0809/python-package-template)

It has built-in unit tests, code checking, formatting, package management, pre-commit configuration, Github Actions and many other convenient tools, which can be used to manage Python projects conveniently. (Contributed by @Undertone0809)

4. [Pipeless: A Computer Vision Framework](https://github.com/pipeless-ai/pipeless)

Easily build and deploy applications that can analyze and act on video streams in real time, without having to build and maintain a multimedia pipeline. Supports plugins, such as using Kafka to process events in real time, using YOLOv8 models, and more.

5. [RealtimeSTT: A Powerful, Efficient, and Low-Latency Speech-to-Text Library](https://github.com/KoljaB/RealtimeSTT)

It features advanced voice activity detection, wake word activation, and real-time transcription. The tech stack used includes: voice activity detection (**WebRTCVAD, SileroVAD**), speech-to-text (**Faster Whisper**), wake word detection (**Porcupine**).

6. [Chrome-GPT: Controllable AutoGPT Proxy for Chrome](https://github.com/richardyc/Chrome-GPT)

It leverages Langchain and Selenium to empower the AutoGPT proxy with the ability to control a Chrome session. It supports interactively scrolling, clicking, and typing text on web pages, which makes it possible to navigate and manipulate web content. (1.4k stars)

7. [ZenNotes: Windows Notepad with Translation and TTS Support](https://github.com/rohankishore/ZenNotes)

A minimalistic Windows notepad application with translation, TTS, and Markdown support, built using [PyQt-Fluent-Widgets](https://github.com/zhiyiYo/PyQt-Fluent-Widgets).

8. [kr8s: A client library for Kubernetes](https://github.com/kr8s-org/kr8s)

A simple and extensible Python client library for k8s, which should feel familiar if you've used **kubectl**.

9. [swirl-search: AI-powered search across multiple data sources](https://github.com/swirlai/swirl-search)

Search across multiple content sources and return AI-ranked results. Supports connections to databases (SQL, NoSQL, Google BigQuery), public data (Google, Arxiv), and enterprise data sources (Microsoft 365, Jira, Miro, and more).

10. [sentry: Error tracking and performance monitoring platform for developers](https://github.com/getsentry/sentry)

A powerful error tracking and performance monitoring platform that also supports features like scheduled job monitoring, code coverage, session replay, alerting, security policies, and more. Supports 100+ platforms and frameworks and 30+ programming languages. (35.4k stars)

11. [15 Python mini projects](https://github.com/zhiwehu/100_plus_Python_Projects_Challenge)

This repository contains a collection of small Python projects and their implementation code, similar to the first share of this issue. (1k stars)

12. [ssh-audit: SSH server and client security audits](https://github.com/jtesta/ssh-audit)

Audit the configuration of SSH servers and clients. Supports SSH1 and SSH2 protocols, Linux and Windows, and identifies security vulnerabilities, insecure keys, insecure algorithms, and provides security recommendations. Also has an [online version](https://www.ssh-audit.com/). (2.6k stars)

## 🐢Podcasts & Videos

1. [Copenhagen 2023 Django Day talk videos](https://www.youtube.com/playlist?list=PLEpW1LzVyQWgtT_i_IlUmx2FSP2jHcroX)

Django Day is an event dedicated to the Django framework and the Django community, and there are currently 11 videos in the playlist.

2. [Talk Python To Me #434: Building Mobile Apps Backed with Python](https://talkpython.fm/episodes/show/434/building-mobile-apps-backed-with-python)

Can Python be used to develop mobile apps? Is it possible to do end-to-end mobile app development with Python? This episode of the podcast features a conversation with a couple of mobile app developers about these topics.

## 🐼Subscribe Welcome

- [Blog](https://pythoncat.top): Explore my independent blog where you can find a collection of original/translated technical articles over the years, along with some reflections since 2009.
- [Newsletter](https://pythoncat.substack.com/s/python-trending-weekly): Subscribe to my channel on Substack for a curated newsletter delivered straight to your inbox, keeping you updated on current affairs.
- [Github](https://github.com/chinesehuazhou/python-weekly): Access the Markdown source files of this weekly digest on Github and feel free to use them for anything you have in mind!
- [Telegram](https://t.me/pythontrendingweekly): Beyond notifications for the weekly digest, I consider it an "extra edition," providing additional, more diverse information.
- [Twitter](https://twitter.com/chinesehuazhou): Follow me on Twitter where my feed is filled with numerous accounts of developers and organizations in the Python community.