# Python Trending Weekly #22 (2023-10-12)

Welcome to the Python Trending Weekly, a weekly newsletter about Python, AI and general programming techniques, with the majority links in English and a small portion in Chinese. 

The [original version](https://pythoncat.top/posts/2023-10-12-weekly) of the weekly  was written in Chinese. What you are reading here is mostly translated by LLMs. 

**Substack Channel** : [Click to subscribe](https://pythoncat.substack.com/s/python-trending-weekly) 

## 🦄Articles & Tutorials

1. [Python 3.12.0 Version Released](https://www.python.org/downloads/release/python-3120/)

Python's latest major version, 3.12, has been released! It includes many new features and optimizations, and several articles in this issue of the Weekly cover them. (Also see: [A Closer Look at Python 3.12's New Features](https://realpython.com/python312-new-features/))

2. [A Quick Look at Python 3.12: Subinterpreters](https://realpython.com/python312-subinterpreters/)

What are Python subinterpreters? What does PEP-684 in version 3.12 do? What changes might we see in version 3.13?

3. [The perf Feature in Python 3.12](https://www.manjusaka.blog/posts/2023/10/05/the-perf-feature-python-312/)

This article introduces the basic knowledge of Python stack frames, the implementation of trace and perf before 3.12, and the implementation of the new Linux native perf introduced in 3.12.

4. [Python 3.12 Quick Look: Static Typing Improvements](https://realpython.com/python312-typing/)

Version 3.12 brings several adjustments and improvements: type variables to annotate generic classes and functions, new syntax for type variables, use of the new @override decorator for model inheritance, and more precise annotation of \*\*kwargs with TypedDict.

5. [Dependency Injection in FastAPI: Building Maintainable and High-Performance Web Applications](https://juejin.cn/post/7283461184514572349)

Dependency injection is a powerful design pattern. How can we use dependency injection in FastAPI to build maintainable and high-performance web applications? The content includes: dependency injection for managing configuration, dependency injection for database access and ORM, advanced dependency injection techniques, testing dependency injection, dependency injection for performance optimization and caching, security and dependency injection, etc.

6. [A Deep Dive into the Python Virtual Machine: How Closures Are Implemented Under the Hood](https://juejin.cn/post/7286670786563244090)

This article introduces the usage examples and principles of closures, and mainly discusses how function closures are implemented at the virtual machine level.

7. [Exploring the Pexpect Library: A Deep Dive into the expect_list Method](https://juejin.cn/post/7287418444647677986)

[Pexpect](https://github.com/pexpect/pexpect) is a library for automating interactive applications such as ssh, ftp, passwd, telnet, and more, with 2.4K stars on Github. This article introduces the usage of its expect_list method.

8. [Introducing textual-plotext, a library for plotting in the terminal](https://textual.textualize.io/blog/2023/10/04/announcing-textual-plotext/)

This blog post introduces the textual-plotext library, which allows you to plot using [Plotext](https://github.com/piccolomo/plotext) in the terminal.

9. [Python Asyncio Series: 5 Articles](https://bbc.github.io/cloudfit-public-docs/)

A series of blog posts from the BBC R&D Cloudfit team, the Asyncio series has been updated with 5 articles covering fundamental concepts and patterns, asynchronous context managers and iterators, library support, and mixing async and sync code.

10. [Profiling Python and Ruby with eBPF](https://www.polarsignals.com/blog/posts/2023/10/04/profiling-python-and-ruby-with-ebpf)

Using eBPF to read abstract stack data from memory structures, enabling stack traces and analysis of code execution.

11. [Python 3.12: Changes That Didn't Make the Headlines](https://www.bitecode.dev/p/python-312-what-didnt-make-the-headlines)

The article covers less-publicized changes in version 3.12: improvements to the pathlib library, a better debugging experience, slice objects are now hashable, the surprise appearance of math.sumprod(), and a new command-line interface.

12. [Python 3.12.0 from a Supply Chain Security Perspective](https://sethmlarson.dev/security-developer-in-residence-weekly-report-13)

What is the release process for Python versions? What are some areas for improvement in the way versions are built? The article also covers using a Software Bill of Materials (SBOM) to track the subcomponents of a software distribution and how they change between versions.

🎁 Python Trending Weekly 🎁 organizes its content into seasons, with every 30 issues forming a season. The highlights from the first season have been compiled for your convenience. You can access them online [here](https://pythoncat.top/posts/2023-12-11-weekly) (Chinese).

## 🐿️Projects & Resources

1. [mwmbl: Open-source, non-profit search engine written in Python](https://github.com/mwmbl/mwmbl)

A non-profit, ad-free, and free search engine that focuses on usability and speed. It's currently a proof of concept and has a small index of pages. (1K stars)

2. [dataherald: Natural Language to SQL Engine](https://github.com/Dataherald/dataherald)

Enterprise Q&A over structured data, allowing to set up an API to answer questions in plain English.

3. [dspy: A Framework for Programming with Foundation Models](https://github.com/stanfordnlp/dspy)

A framework for solving high-level tasks with language models (LMs) and retrieval models (RMs). It unifies techniques for prompting and fine-tuning LMs, as well as methods for inference, self-improvement, and augmentation with retrieval and tools. (3.5k stars)

4. [TTS: Text-to-Speech Deep Learning Toolkit](https://github.com/coqui-ai/TTS)

A library for state-of-the-art text-to-speech generation, with pretrained models in 1100 languages, and the ability to train new models and fine-tune existing ones for any language. (20.3k stars)

5. [rustworkx: High-performance Python graphics library implemented in Rust](https://github.com/Qiskit/rustworkx)

A general-purpose Python graphics library written in Rust, featuring high performance and safety.

6. [faststream: Build asynchronous services that interact with event streams](https://github.com/airtai/faststream)

A framework for building asynchronous services that interact with event streams like Apache Kafka, RabbitMQ, and NATS, simplifying the process of writing producers and consumers for message queues.

7. [aiohttp: Asynchronous HTTP Client/Server Framework](https://github.com/aio-libs/aiohttp)

A popular asynchronous HTTP framework, whose main features include: support for HTTP protocol on both client and server sides, Websocket out of the box, support for middleware and pluggable routing. (14k stars)

8. [panther: A High-Performance Python Web Framework](https://github.com/AliRn76/Panther)

A web framework based on Python 3.11, featuring an Object-Document-Mapper (ODM) for document-oriented databases, Websocket support, a caching API, built-in authentication and authorization classes, customizable middleware, visual API monitoring, and more.

9. [Qiskit: An Open-Source SDK for Quantum Computing](https://github.com/Qiskit/qiskit)

Could quantum computers be as easy to use as a laptop? That's the goal of the [Qiskit](https://qiskit.org/documentation/) project. This repository is the core component of Qiskit, containing the building blocks for creating and manipulating quantum circuits, operators, and primitives. (3.9k stars)

10. [Vizro: A Toolkit for Building Modular Data Visualization Apps](https://github.com/mckinsey/vizro)

Create sophisticated dashboards with just a few lines of configuration, leveraging libraries like Plotly and Dash for rendering. Configuration can be written in multiple formats, including Pydantic models, JSON, YAML, or Python dictionaries. (1.5k stars)

11. [NumPy-ML: Machine Learning with NumPy](https://github.com/ddbourgin/numpy-ml)

This is a collection of machine learning models, algorithms, and utilities, written exclusively using NumPy and the Python standard library. (14k stars)

12. [PdfPlumber: A PDF Parsing Library](https://github.com/jsvine/pdfplumber)

Extract detailed information about every text character, rectangle, and line in a PDF, with support for table extraction and visual debugging. (4.6k stars)

## 🐢Podcasts & Videos

1. [Mojo Programming Language Tutorial for Beginners](https://www.youtube.com/watch?v=5Sm9IVMet9c)

A Mojo tutorial video from FreeCodeCamp with close to 100k views.

2. [Python 3.12: What's New and What You Need to Know](https://www.youtube.com/watch?v=udHmeAmOlbI)

This video explores the exciting new features and improvements in Python 3.12, as well as some elements that will be removed in the upcoming release.

## 🐼Subscribe Welcome

- [Blog](https://pythoncat.top): Explore my independent blog where you can find a collection of original/translated technical articles over the years, along with some reflections since 2009.
- [Newsletter](https://pythoncat.substack.com/s/python-trending-weekly): Subscribe to my channel on Substack for a curated newsletter delivered straight to your inbox, keeping you updated on current affairs.
- [Github](https://github.com/chinesehuazhou/python-weekly): Access the Markdown source files of this weekly digest on Github and feel free to use them for anything you have in mind!
- [Telegram](https://t.me/pythontrendingweekly): Beyond notifications for the weekly digest, I consider it an "extra edition," providing additional, more diverse information.
- [Twitter](https://twitter.com/chinesehuazhou): Follow me on Twitter where my feed is filled with numerous accounts of developers and organizations in the Python community.