# Python Trending Weekly #21 (2023-09-23)

Welcome to the Python Trending Weekly, a weekly newsletter about Python, AI and general programming techniques, with the majority links in English and a small portion in Chinese. 

The [original version](https://pythoncat.top/posts/2023-09-23-weekly) of the weekly  was written in Chinese. What you are reading here is mostly translated by LLMs. 

**Substack Channel** : [Click to subscribe](https://pythoncat.substack.com/s/python-trending-weekly) 

## 🦄Articles & Tutorials

1. [Optimizing Python Code Speed on a Single Core](https://pythonspeed.com/articles/optimizing-dithering/)

The article uses the Floyd-Steinberg dithering algorithm as an example to demonstrate various techniques to improve code performance, reducing the execution time from 2339 microseconds down to 554 microseconds. Some of the concepts covered include instruction-level parallelism (ILP), branch prediction, single instruction multiple data (SIMD), and memory hierarchy.

2. [Learning About Code Metrics in Python with Radon](https://www.blog.pythonlibrary.org/2023/09/20/learning-about-code-metrics-in-python-with-radon/)

A basic introductory tutorial on how to use Radon to measure the complexity of Python code, i.e., calculate metrics such as cyclomatic complexity, and introduces the use of related commands.

3. [Python (mostly) is syntactic sugar](https://lwn.net/Articles/942767/)

Brett Cannon wrote a series of blog posts about "syntactic sugar", which analyzed more than 80 syntactic sugar features. The article introduces some of them based on his PyCon talk and blog posts.

4. [Welcome to the New SymPy](https://oscarbenjamin.github.io/blog/czi/post1.html)

SymPy is a library for symbolic computation, which can handle problems in areas such as algebra, calculus, and discrete mathematics. This is a series of posts about major changes coming to it. The post describes the current speed problems with SymPy, the work being done to speed it up, and plans for future speed improvements. (See also: [Part 2 of the series: Polynomial Evaluation in SymPy](https://oscarbenjamin.github.io/blog/czi/post2.html))

5. [Use import-linter to Make Your Python Project Architecture Cleaner](https://www.piglei.com/articles/use-import-linter-to-lint-proj-arch/)

In terms of dependency governance, [import-linter](https://github.com/seddonym/import-linter) is a very useful tool. It allows us to express the implicit complex dependencies within a project explicitly through a configuration file by providing various types of "contracts". This article introduces its basic usage and six tips for fixing dependencies.

6. [How CPython Uses Bloom Filters for String Manipulation](https://codeconfessions.substack.com/p/cpython-bloom-filter-usage)

CPython uses Bloom filters for string manipulation, such as in the `splitlines()` and `strip()` functions. The article explains how these functions are implemented. It also discusses how a typical Bloom filter works and how CPython implements Bloom filters (in less than 50 lines of C code).

7. [UUIDs in Python](https://medium.com/@m____b____/uuids-with-python-b133cead1b4c)

This article introduces several methods of the `uuid` library: `uuid1()` generates a UUID using the system MAC address and a timestamp; `uuid4()` generates a completely random UUID; `uuid3()` and `uuid5()` generate UUIDs based on a constant namespace and a variable name, with the former using the MD5 algorithm and the latter using the SHA-1 algorithm.

8. [Why Are There So Many Python Dataframes?](https://ponder.io/why-are-there-so-many-python-dataframes/)

Why are there so many dataframe libraries, such as Pandas, Polars, Dask, and PySpark? The author argues that the main reason is its four role models: spreadsheet, relational database, 2D array/matrix, and object, and a series of problems derived from them.

9. [Simulating the Monty Hall Problem in Python](https://www.dataschool.io/python-probability-simulation/)

The Monty Hall problem, also known as the three-door problem, is a probability puzzle that challenges intuitive reasoning. The article uses Python to simulate the problem to see how many times it takes to win a prize.

10. [6 Cool Things You Can Do with the Functools Module](https://pybit.es/articles/6-cool-things-you-can-do-with-the-functools-module/)

The article introduces six use cases for the functools standard library: @cache for caching, @total_ordering to save you from writing the rich comparison methods, partial() for freezing arguments, @singledispatch for generic functions, @wraps for decorators, and reduce() function.

11. [A Deep Dive into pytest.main(): Unraveling the Core Functionality of the Python Testing Framework](https://juejin.cn/post/7281491804736831542)

`pytest.main` is a handy function in the Pytest framework for running test suites from the command line or programmatically. The article explores its usage and some common use cases.

12. [7 Best Python Authentication Libraries You Should Use in Your Next Project](https://python.plainenglish.io/7-best-python-authentication-libraries-you-should-use-in-your-next-project-c07b668d5348)

Introduces seven great authentication libraries: **Authlib, Pyjwt, Flask-login, Django-allauth, ItsDangerous, Python Social Auth, Flask-security**. (Also available in [Chinese translation](https://juejin.cn/post/7281150086351732751).)

🎁 Python Trending Weekly 🎁 organizes its content into seasons, with every 30 issues forming a season. The highlights from the first season have been compiled for your convenience. You can access them online [here](https://pythoncat.top/posts/2023-12-11-weekly) (Chinese).

## 🐿️Projects & Resources

1. [Radon: Various Metrics for Python Code](https://github.com/rubik/radon)

A Python code metrics analyzer that can calculate cyclomatic complexity, raw metrics, Halstead metrics, and maintainability index, which can be used for CI integration and with Jupyter Notebook. (1.5K stars)

2. [agents: Open-source framework for autonomous language agents](https://github.com/aiwaves-cn/agents)

Autonomous Language Agents refer to intelligent agent systems that can independently perform natural language processing tasks. This library supports functions such as long-term and short-term memory, tool usage, web navigation, multi-agent communication, human-computer interaction, and symbolic control. (star 2.6K)

![](https://img.pythoncat.top/agents-cover.png)

3. [quasiqueue: A multiprocessing library](https://github.com/tedivm/quasiqueue)

A library for Python multiprocessing that makes it easy to manage long-running multiprocess jobs. It handles process creation and cleanup, signal management, interprocess communication, and other hassles of dealing with multiple processes.

4. [pygraft: Configurable Schema and Knowledge Graph Generation](https://github.com/nicolas-hbt/pygraft)

Generates realistic schemas and knowledge graphs given user-specified parameters, ensuring logical consistency via a DL reasoner (HermiT).

5. [toml-bench: Which toml library to use in Python?](https://github.com/pwwang/toml-bench)

This repository mainly compares several toml libraries, including **toml, tomli/tomli_w, tomlkit, pytomlpp, rtoml, and qtoml**, from multiple dimensions, examining their behaviors and performance when processing data.

6. [SyncDreamer: Generating Multi-View Consistent Images from a Single-View Image](https://github.com/liuyuan-pal/SyncDreamer)

Given an image, segment the foreground object using Paint3D, and generate images from multiple views through inference.

7. [nanosam: SAM Models Running Real-Time with NVIDIA TensorRT](https://github.com/NVIDIA-AI-IOT/nanosam)

Segment Anything (SAM) is a task in computer vision to segment any object in an image or video, extracting sub-regions or objects with semantic or visual characteristics.

8. [logparser: A machine learning toolkit for log parsing](https://github.com/logpai/logparser)

A Chinese open-source project. It can automatically extract structured key information from unstructured log information. (1.2k stars)

9. [llama2.mojo: Pure Mojo version of Llama 2](https://github.com/tairov/llama2.mojo)

The author ported the Python version of llama2.py to Mojo, which improved the performance by nearly 250 times. (1.1k stars)

10. [bisheng: An open LLM DevOps platform](https://github.com/dataelement/bisheng)

A leading open-source large model application development platform, named after Bi Sheng, the inventor of movable type printing in China. It can be used to build various large model applications, such as analysis report generation, knowledge base Q&A, dialogue, and feature extraction.

## 🐢Podcasts & Videos

1. [146 Videos from EuroPython 2023](https://www.youtube.com/playlist?list=PL8uoeex94UhFcwvAfWHybD7SfNgIUBRo-)

Videos of the talks from this year's EuroPython event.

2. [Real Python Podcast #172: Measuring Python Performance with Scalene](https://realpython.com/podcasts/rpp/172/)

**Scalene** is a high-performance CPU, GPU, and memory profiler that can profile code down to the individual function or line of code level and compare time spent in Python and C code. The podcast guest is a professor at the University of Massachusetts who developed Scalene with students in his lab.

## 🐼Subscribe Welcome

- [Blog](https://pythoncat.top): Explore my independent blog where you can find a collection of original/translated technical articles over the years, along with some reflections since 2009.
- [Newsletter](https://pythoncat.substack.com/s/python-trending-weekly): Subscribe to my channel on Substack for a curated newsletter delivered straight to your inbox, keeping you updated on current affairs.
- [Github](https://github.com/chinesehuazhou/python-weekly): Access the Markdown source files of this weekly digest on Github and feel free to use them for anything you have in mind!
- [Telegram](https://t.me/pythontrendingweekly): Beyond notifications for the weekly digest, I consider it an "extra edition," providing additional, more diverse information.
- [Twitter](https://twitter.com/chinesehuazhou): Follow me on Twitter where my feed is filled with numerous accounts of developers and organizations in the Python community.