# Python Trending Weekly #20 (2023-09-16)

Welcome to the Python Trending Weekly, a weekly newsletter about Python, AI and general programming techniques, with the majority links in English and a small portion in Chinese. 

The [original version](https://pythoncat.top/posts/2023-09-16-weekly) of the weekly  was written in Chinese. What you are reading here is mostly translated by LLMs. 

**Substack Channel** : [Click to subscribe](https://pythoncat.substack.com/s/python-trending-weekly) 

## 🦄Articles & Tutorials

1. [Three Ways to Benchmark Python Code](https://superfastpython.com/benchmark-python-code/)

This article introduces several methods for benchmarking Python using the standard library: time, timeit, cProfile, and profile. It provides detailed instructions on how to use these tools and how to interpret the test data.

2. [Ditch Poetry and PDM, Switch to Hatch](https://andrich.me/2023/08/switching-to-hatch/)

The author "fell in love" with Hatch and started using it in his projects. The article introduces some of the highlights he likes about Hatch: environment isolation, command scripts, an alternative to **Tox**, optional dependencies, and more. (See also: [Python Task Automation Tool Tox Tutorial](https://pythoncat.top/posts/2020-01-06-tox))

3. [What's wrong with TOML?](https://hitchdev.com/strictyaml/why-not/toml/)

TOML is an "improved" INI file and is the recommended configuration file format for Python. The article mentions that even the author of TOML thinks it's a terrible format! The article points out its problems: it's very verbose, the hierarchy is hard to infer from the syntax alone, it's unnecessarily complex like YAML, and it has a type system.

4. [Playing with Genetic Algorithms in Python](https://joseprupi.github.io/misc/2023/08/19/playing_with_genetic_algorithms_in_python.html)

Genetic Algorithm is an optimization algorithm inspired by the theory of biological evolution, used to solve complex search and optimization problems. The article demonstrates the usage of this algorithm with Python.

5. [Type Hinting in Modern Python: The Protocol Class](https://codebeez.nl/blogs/type-hinting-in-modern-python-the-protocol-class/)

The Protocol class was introduced in Python 3.8 to specify which methods a class should implement, similar to an Interface in Java. Using a Protocol allows for some static type checking while still maintaining Python's dynamic typing.

6. [Tornado's Coroutine Scheduling Principle](https://dev.to/caipi/tornado-de-xie-cheng-diao-du-yuan-li-2h34)

Tornado is a high-performance web framework. This article analyzes its source code, mainly to figure out: where does the state of `yield` go, what exactly is the "right time" to resume execution, and how exactly is execution resumed?

7. [Visualizing the CPython Release Process](https://sethmlarson.dev/security-developer-in-residence-weekly-report-9)

Based on PEP-101, this article combs through the CPython release process, draws a detailed flowchart, and provides explanations for key steps.

![CPython Build and Release Process](https://img.pythoncat.top/2023-09-16_cpython.png)

8. [How to Use PyObjC with Apple's Vision Framework for Text Recognition](https://yasoob.me/posts/how-to-use-vision-framework-via-pyobjc/)

Apple's Vision framework provides a set of pretrained models and APIs to quickly add image analysis and computer vision capabilities to your apps. PyObjC enables Python to interact with Objective-C. This article combines them to develop a text processing project.

9. [Regex Catastrophic Backtracking in Python](https://krishnanchandra.com/posts/regex-catastrophic-backtracking/)

The author used py-spy to locate a CPU 100% usage issue, found the culprit regular expression, and then explored catastrophic backtracking, its solutions, and suggested a better way to write it for performance.

10. [Building a Database Search App with Django and HTMX](https://www.photondesigner.com/articles/database-search-django-htmx)

A detailed Django project tutorial that implements a full-stack project. The article includes a video tutorial by the author.

11. [Asynchronous SQLAlchemy and Multiple Databases](https://python-bloggers.com/2023/09/asynchronous-sqlalchemy-and-multiple-databases/)

Utilizing asyncio and the SQLAlchemy library, the article explores how to efficiently connect to and manage multiple databases, achieving a scalable and resilient architecture. Two implementation approaches are presented.

12. [Python Fire: Generate Command-Line Interfaces Automatically](https://juejin.cn/post/7278246015193464847)

Fire is a library for generating CLIs, open-sourced by Google with 25K stars on Github. This article introduces its usage, including general commands, composite commands, chained commands, complex commands, and more.

13. [My Favorite Python Tricks for Solving LeetCode Problems](https://www.jjinux.com/2022/08/python-my-favorite-python-tricks-for.html)

The article introduces some Python tricks, from beginner to advanced levels, mostly related to data structures, which are useful when solving LeetCode problems.

14. [Why Does Python Code Run Faster in a Function?](https://stackabuse.com/why-does-python-code-run-faster-in-a-function/)

Python code is executed either in a function or in a global module. Which one is faster? Why is it faster in a function? How does Python code work under the hood? How to test and optimize the performance of Python functions?

🎁 Python Trending Weekly 🎁 organizes its content into seasons, with every 30 issues forming a season. The highlights from the first season have been compiled for your convenience. You can access them online [here](https://pythoncat.top/posts/2023-12-11-weekly) (Chinese).

## 🐿️Projects & Resources

1. [hatch: A fancy extensible Python project manager](https://github.com/pypa/hatch)

A Python project manager with a standardized build system, powerful environment management, easy deployment to PyPI, version management, a responsive CLI, and is about 2-3x faster than similar tools like pipenv and poetry. (4.4k stars)

2. [keep: Open-source alerting management and automation execution platform](https://github.com/keephq/keep)

Integrate all alerts into a single management platform and orchestrate workflows to automate end-to-end processes. Supports docking with various data collection platforms, databases, office software, etc., and visualizes the orchestration of alert processing workflows. (star 2.2K)

3. [PyPI Data Website: Explore PyPI's Data](https://py-code.org/stats)

An amazing website! It contains various statistics, line charts, and pie charts about PyPI, such as the total number of files, the total size, and the popularity trends of some features.

![Image of PyPI Data Statistics](https://img.pythoncat.top/2023-09-15_pypi-data.png)

4. [strictyaml: A type-safe YAML parser and validator](https://github.com/crdoconnor/strictyaml)

A restricted subset of YAML that parses and rejects ugly, unreadable, and insecure YAML features, with strict tag validation and a natural type system. An alternative to pyyaml, ruamel.yaml, and poyo, with clear and helpful error messages. (1.3k stars)

5. [facefusion: A More Advanced Face Swapping Tool](https://github.com/facefusion/facefusion)

The latest open-source face swapping library, with a rapidly growing number of stars! (6.9K stars)

6. [pyflyby: A Productivity Toolkit for Python](https://github.com/deshaw/pyflyby)

A collection of small tools, including py for the command line, autoimport for IPython, adding missing imports, removing unused imports, formatting imports, printing the imports for a set of files, renaming imports, and more.

7. [Instagraph: Convert text content or URLs into visual knowledge graphs](https://github.com/yoheinakajima/instagraph)

Instagraph extracts entities from complex information and generates a graph of their relationships. It uses GPT-3.5 and Flask to generate colorful and user-friendly legends. It's also responsive, so it can be used on any device.

8. [textual-web: Run TUIs and terminals in the browser](https://github.com/Textualize/textual-web)

Publish apps developed with **Textual** to the web, allowing them to be used as command-line terminals in the browser. This is a very interesting project.

9. [ziggy-pydust: Build Python extensions in Zig](https://github.com/fulcrum-so/ziggy-pydust)

A development framework to package Python extension modules written in Zig, including a Pytest plugin to discover and run Zig tests. Poetry integration makes it easy to build wheels and publish. Supports the buffer protocol, enabling zero-copy for faster Numpy computations.

10. [MFTCoder: Multi-task Fine-tuning Code Large Model](https://github.com/codefuse-ai/MFTCoder)

An open-source multi-task code-large-language-model project, including model, data, and training for code-large-language-models. Achieved **74.4%** open-source SOTA on HumanEval Benchmarks Python Pass@1, surpassing GPT-4.

## 🐼Subscribe Welcome

- [Blog](https://pythoncat.top): Explore my independent blog where you can find a collection of original/translated technical articles over the years, along with some reflections since 2009.
- [Newsletter](https://pythoncat.substack.com/s/python-trending-weekly): Subscribe to my channel on Substack for a curated newsletter delivered straight to your inbox, keeping you updated on current affairs.
- [Github](https://github.com/chinesehuazhou/python-weekly): Access the Markdown source files of this weekly digest on Github and feel free to use them for anything you have in mind!
- [Telegram](https://t.me/pythontrendingweekly): Beyond notifications for the weekly digest, I consider it an "extra edition," providing additional, more diverse information.
- [Twitter](https://twitter.com/chinesehuazhou): Follow me on Twitter where my feed is filled with numerous accounts of developers and organizations in the Python community.