# Python Trending Weekly #19 (2023-09-09)

Welcome to the Python Trending Weekly, a weekly newsletter about Python, AI and general programming techniques, with the majority links in English and a small portion in Chinese. 

The [original version](https://pythoncat.top/posts/2023-09-09-weekly) of the weekly  was written in Chinese. What you are reading here is mostly translated by LLMs. 

**Substack Channel** : [Click to subscribe](https://pythoncat.substack.com/s/python-trending-weekly) 

## 🦄Articles & Tutorials

1. [Mojo🔥 is finally available for download!](https://www.modular.com/blog/mojo-its-finally-here)

Mojo, the “high-performance Python++” language released this year, just released its Linux installer this week, following its $100 million funding announcement in Trending Weekly issue #17. In addition to compiler functionality, it also offers some IDE tooling (terminal shell, VS Code extension, Jupyter kernel), although debugging is not yet supported and there are no Mac or Windows builds available.

2. [What Can We Learn from PEP-703?](https://www.cnblogs.com/apocelipes/p/17679741.html)

PEP-703 is a proposal for the no-gil project, which we have introduced many times. The author discusses some topics in this PEP, such as minimizing reliance on atomic reference counting, lazy reference counting, gc will no longer be generational, object locks, etc. From this, we can see the trade-offs that the Python community makes in terms of performance and compatibility.

3. [Writing a C Compiler in 500 Lines of Python](https://vgel.me/posts/c500/)

How many lines of Python code does it take to implement a C compiler? This article introduces the architecture of the compiler, the code parsing and generation process, and attempts to implement a simple C compiler in 500 lines of code.

4. [An Intro to Protocol Buffers with Python](https://www.blog.pythonlibrary.org/2023/08/30/an-intro-to-protocol-buffers-with-python)

Protocol buffers are a language-neutral data serialization format, similar to Python's pickle format. This article introduces how to create and compile protocol buffer files with Python and communicate with other languages that support the protocol.

5. [How to Create a Beautiful Polar Histogram with Python and Matplotlib](https://dev.to/oscarleo/how-to-create-a-beautiful-polar-histogram-with-python-and-matplotlib-400l)

A polar histogram is a type of chart used to visualize and analyze the distribution of data. It divides the data into sectors, with the length or area of each sector representing the frequency or quantity of data within that angular range. This article explains how to create a polar histogram in Python.

6. [Bloom Filter Diagram and Python Implementation](https://codeconfessions.substack.com/p/bloom-filters-and-beyond)

Bloom Filter is a data structure that can be used to quickly determine whether an element is in a set. Use cases include: deduplication, caching and fast lookups, preventing cache penetration, and filtering spam. The article introduces what it is, how it works, Python implementation, how to tune Bloom Filter, etc.

7. [Heap Data Structure in Python: Min and Max Heap Implementation](https://favtutor.com/blogs/heap-in-python)

Heap is an essential data structure that is often used for fast access to extreme values, heapsort, scheduling and task allocation, graph algorithms, data compression and encoding, etc. The article introduces its basic concepts, how to implement a max heap and a min heap in Python, and the differences between them.

8. [Beginner's Guide to Python Containers](https://developers.redhat.com/articles/2023/09/05/beginners-guide-python-containers)

Containers are a lightweight virtualization technology that enable efficient packaging and deployment of Python applications. This tutorial from Red Hat shows you how to build, run, and manage Python containers using **Podman**.

9. [A Practical Guide to Python Packaging in 2023](https://robamu.github.io/posts/packaging-python-in-2023/)

This article summarizes some of the best practices that are currently applicable when managing Python packages, such as using pyproject.toml, using setuptools as a distribution and build tool, writing documentation with Sphinx + reStructuredText + sphinx-rtd-theme, listing version changes with CHANGELOG, and using black and flake8, among others.

10. [Tracking Down a Python Application Memory Leak](https://juejin.cn/post/7274626136328536116)

The author uses Airflow as a task scheduler, and after going live, the Scheduler memory OOM issue appears every once in a while. This article provides a detailed account of the process of locating and analyzing the problem. Three tools are introduced: **objgraph, pympler, tracemalloc**.

11. [Introducing flake8-logging](https://adamj.eu/tech/2023/09/07/introducing-flake8-logging/)

The author believes that the standard library `logging` is relatively difficult to use, and that necessary logs are often missing when a program errors out, so the flake8-logging plugin was developed. It has 12 rules, and this article introduces 3 of them: instantiating a logger using logging.getLogger(), using exception() when handling exceptions, and avoiding pre-formatting log messages.

12. [Falcon 180B is Now Officially Released on Hugging Face Hub](https://segmentfault.com/a/1190000044189692)

As the largest open-source large model to date, Falcon has 180B parameters and was trained on the TII RefinedWeb dataset with 35 trillion tokens, making it the longest single-segment pre-training among current open-source models. The article introduces its advantages and how to get started with it.

🎁 Python Trending Weekly 🎁 organizes its content into seasons, with every 30 issues forming a season. The highlights from the first season have been compiled for your convenience. You can access them online [here](https://pythoncat.top/posts/2023-12-11-weekly) (Chinese).

## 🐿️Projects & Resources

1. [pkuseg-python: A multi-domain Chinese word segmentation tool, more accurate than jieba](https://github.com/lancopku/PKUSeg-python)

Unlike other general Chinese word segmentation tools, it supports multi-domain word segmentation, has a higher word segmentation accuracy, supports user-trained models, and supports part-of-speech tagging. The accuracy exceeds the two Chinese word segmentation tools **jieba and THULAC**. (6.2K stars)

2. [pysentation: Display presentations in your CLI](https://github.com/mimseyedi/pysentation)

Create and display presentations in your command-line terminal, with support for titles, colors, themes, zooming, explanations, keyboard shortcuts, and more.

3. [compress: A fast input tool based on your personal corpus](https://github.com/eschluntz/compress)

After importing your personal corpus, you can type long content with abbreviations. It uses **Autokey** to implement keyboard shortcuts for Linux. (star 1.3K)

4. [textbase: A simple framework for building AI chatbots](https://github.com/cofactoryai/textbase)

A framework for building chatbots using NLP and ML, making it easy to develop and deploy web applications. Plans to integrate SMS, native integration of large language models (Claude, Llama). (1.2k stars)

5. [reader: A Python-based feed reader library](https://github.com/lemon24/reader)

A feature-rich feed reader that supports fetching, storing, and managing Atom, RSS, and JSON feeds; marking articles as read or starred; filtering feeds and articles; full-text search; user activity statistics; and plugins.

6. [Baichuan2: Baichuan 53B Large Model Online Dialogue Platform](https://github.com/baichuan-inc/Baichuan2)

Baichuan Intelligence launched a new generation of open-source large language models, trained with 2.6 trillion tokens of high-quality corpora. The model was extensively tested on authoritative Chinese-English and multilingual datasets in six domains: general, law, medical, mathematics, code, and multilingual translation.

7. [svcs: A flexible Python service locator](https://github.com/hynek/svcs/)

A dependency injection container for Python that provides a mechanism to register factories for types/interfaces, enforcing that instances of these types are acquired via automatic cleanup and health checks. Use dependency injection and service location to achieve inversion of control, eliminating a lot of repetitive boilerplate code.

8. [gpt_academic: A practical interactive interface for ChatGPT/GLM](https://github.com/binary-husky/gpt_academic)

GPT Academic is optimized for academic use, especially for reading, polishing, and writing papers. It features a modular design, supports custom shortcut buttons and function plug-ins, and supports project analysis and self-translation functions for Python and C++. It also supports PDF/LaTex paper translation and summarization, and can query multiple LLM models in parallel, including local models such as chatglm2. It is compatible with Wenxin Yanyi, moss, llama2, rwkv, claude2, Tongyi Qianwen, Shusheng, Xunfei Xinghuo, and others. (41K stars)

## 🐼Subscribe Welcome

- [Blog](https://pythoncat.top): Explore my independent blog where you can find a collection of original/translated technical articles over the years, along with some reflections since 2009.
- [Newsletter](https://pythoncat.substack.com/s/python-trending-weekly): Subscribe to my channel on Substack for a curated newsletter delivered straight to your inbox, keeping you updated on current affairs.
- [Github](https://github.com/chinesehuazhou/python-weekly): Access the Markdown source files of this weekly digest on Github and feel free to use them for anything you have in mind!
- [Telegram](https://t.me/pythontrendingweekly): Beyond notifications for the weekly digest, I consider it an "extra edition," providing additional, more diverse information.
- [Twitter](https://twitter.com/chinesehuazhou): Follow me on Twitter where my feed is filled with numerous accounts of developers and organizations in the Python community.