# Python Trending Weekly #18 (2023-09-02)

Welcome to the Python Trending Weekly, a weekly newsletter about Python, AI and general programming techniques, with the majority links in English and a small portion in Chinese. 

The [original version](https://pythoncat.top/posts/2023-09-02-weekly) of the weekly  was written in Chinese. What you are reading here is mostly translated by LLMs. 

**Substack Channel** : [Click to subscribe](https://pythoncat.substack.com/s/python-trending-weekly) 

## 🦄Articles & Tutorials

1. [A Flask Learning Guide in a Series of Articles](https://testdriven.io/guides/flask-deep-dive)

Dive deep into Flask's internals, core features, and functionalities, covering topics such as application and request context, Werkzeug, sessions, security (CSRF protection), testing, and async in version 2.0.

2. [Table Recognition and Extraction from PDFs with PyMuPDF](https://artifex.com/blog/table-recognition-extraction-from-pdfs-pymupdf-python)

Table recognition and manipulation in PDF documents can be a challenging task. The latest version of PyMuPDF, 1.23.0, brings the ability to extract tables from PDF! The extracted content can be easily handed over to pandas for further processing and can be exported to Excel and CSV formats.

3. [Understanding Immortal Objects in Python 3.12](https://codeconfessions.substack.com/p/understanding-immortal-objects-in)

Issue [16](https://pythoncat.top/posts/2023-08-19-weekly) shared the story of Instagram introducing immortal objects in Python 3.12, while the article shared here analyzes the interpreter source code in depth, answering the following questions for us: Why introduce immortal objects? What impact does it have on performance? How is it implemented (such as None objects and small integers), and how is it compatible with old versions of the interface?

4. [Ten Ways to Use Underscores in Python](https://mathspp.com/blog/pydonts/usages-of-underscore)

Do you know what underscores can be used for in Python? This article introduces: usage in REPL, four ways to use it as a prefix or suffix to variable names, two ways to use it as an assignment "receiver", its use in the new match-case syntax, using it as an alias for a frequently called function, and adding readability to large numbers.

5. [Python Asyncio: A Detailed Explanation of Network Programming Methods](https://so1n.me/2023/08/29/python_asyncio_lib_network/)

Asyncio not only provides a simple `Socket` interface, but also provides `Protocol` & `Transport` interfaces and a more advanced `Stream` interface based on it, which greatly reduces the psychological burden of developers in network programming. This article mainly introduces the simple usage of these interfaces and the corresponding principle analysis.

6. [Streamlit Cheatsheet for Beginners](https://dev.to/codemaker2015/streamlit-cheatsheet-for-beginners-706)

Streamlit is a framework for creating and deploying web applications, widely used in the field of machine learning and data science. This tutorial introduces its installation and the usage of commonly used components.

7. [How to Use Tailwind CSS and SQLAlchemy in a FastAPI App](https://ezzeddin.hashnode.dev/fastapi-tailwind-sqlalchemy)

FastAPI is a lightweight framework that often requires the integration of other components to work with. This article shows how to combine FastAPI with the Jinja2 templating engine, Tailwind CSS, and **SQLAlchemy** to create a useful development scaffold.

8. [How Not to Sort in Python](https://www.bitecode.dev/p/how-not-to-sort-in-python)

This article introduces the usage of Python heap sort/priority queue, binary search, and ordered containers. They have better time complexity or applicable scenarios and are more worthwhile solutions than brute-force search and brute-force sort.

9. [Send Verification Email with Django](https://delighto.hashnode.dev/send-verification-email-django)

It's common to receive a verification email after signing up for an account, which needs to be clicked within a certain time frame to complete the registration. This tutorial shows you how to implement this feature using Django, serving as a concise and complete hands-on project.

10. [Exploring Global Diversity: Pyetho — A Python Library for Language and Country Insights](https://medium.com/@i18nsolutionspy/exploring-global-diversity-pyetho-python-library-for-language-and-country-insights-4a688958ea83)

The article introduces the basic usage of the [Pyetho](https://github.com/i18nsolutionspy/Pyetho) library, which primarily contains information about countries and their languages worldwide, following ISO standards. It covers 195 countries, and from what I checked, China has 285 languages. Aside from basic country and language information, other functionalities include: finding the number of speakers for a language, finding which countries a language is spoken in, finding the language family of a language, finding all language families, and more.

11. [Polars: Blazing Fast DataFrame Library](https://realpython.com/polars-python/)

Polars is a newcomer in the data analysis field, written in Rust for blazing-fast performance. This is a comprehensive tutorial covering its DataFrame, expressions and context, lazy API (LazyFrame), integration with external data sources, integration with Numpy and pandas, and more.

12. [Deep Dive into Data Structures and Algorithms: C++, Swift, Python, Java, C#, JavaScript](https://dev.to/khaledhosseini/data-structures-and-algorithms-for-multi-language-programmers-c-swift-python-java-c-javascript-alp)

Warning: long read ahead! The article explores implementations of common data structures across various programming languages, visualizing the concepts with neat animations and diagrams. It mainly covers linear data structures, such as arrays, dynamic arrays, linked lists, circular linked lists, stacks, queues, hash tables, sets, and more. Data structures naturally go hand in hand with algorithms and their time complexities, which are also discussed in the article.

🎁 Python Trending Weekly 🎁 organizes its content into seasons, with every 30 issues forming a season. The highlights from the first season have been compiled for your convenience. You can access them online [here](https://pythoncat.top/posts/2023-12-11-weekly) (Chinese).

## 🐿️Projects & Resources

1. [fastapi-users: FastAPI user management library out of the box](https://github.com/fastapi-users/fastapi-users)

Add user registration and authentication module for FastAPI, with features like: extensible user models, registration/login/password reset/email verification, OAuth2 login flows, customizable database backends, support for multiple authentication methods, and more. (3.3K stars)

2. [upiano: A piano in your command line](https://github.com/eliasdorneles/upiano)

What's it like to play the piano in the command line?! After installing this library, you can play the piano with your mouse and keyboard.

3. [hrequests: An alternative to the requests library](https://github.com/daijro/hrequests)

A simpler, more configurable, and feature-rich library than the requests library, it uses gevent to achieve high-performance concurrency, supports HTTP/2, JSON serialization is 10 times faster than the standard library, the code uses type hints, and it is 100% thread-safe.

4. [wisdomInterrogatory: Wisdom Sea-Recorded Questions Legal Large Model](https://github.com/zhihaiLLM/wisdomInterrogatory)

A legal large model jointly designed by Zhejiang University, Alibaba DAMO Academy, and Huayuan Computing, with the goal of "promoting legal popularization and improving judicial efficiency". The model base is Baichuan-7B, and the pre-training data includes legal documents, judicial cases, and legal Q&A data, totaling 40G.

![](https://img.pythoncat.top/2023-09-02-wisdomInterrogatory.png)

5. [awesome-systematic-trading: A curated list of resources for systematic trading](https://github.com/edarchimbaud/awesome-systematic-trading)

Systematic trading/quantitative trading is a strategy for automating trading decisions according to a set of rules and algorithms. This repository contains a collection of resources: libraries, software, strategies, books, blogs, papers, videos, and more. (1.1k stars)

6. [Qwen-VL: The Official Repository of Alibaba Tongyi Qianwen-VL Model](https://github.com/QwenLM/Qwen-VL)

**Qwen-VL** is a large-scale vision-language model developed by Alibaba Cloud, which can take images, texts, and bounding boxes as input, and output texts and bounding boxes. It supports multiple languages and multi-image interleaved dialogue. Evaluation results show that Qwen-VL significantly outperforms current SOTA Generalist Models on multiple VL tasks.

7. [h2ogpt: Q&A for Private Documents + Images](https://github.com/h2oai/h2ogpt)

Query and summarize your documents, or chat with a locally private GPT LLM. Supports most document types, LLaMa2, Falcon, Vicuna, AutoGPTQ, LORA, and more. Supports Linux, Docker, MAC, and Windows. (7.2k stars)

8. [Refact: Open-source coding assistant with auto-completion, code refactoring, code analysis](https://github.com/smallcloudai/refact)

An open-source alternative to Copilot that can be self-hosted or used as a cloud service. It supports open-source models such as starcoder, starchat, llama2, wizardlm, and provides features like code completion, refactoring, explanation, analysis, optimization, and bug fixing.

9. [dify: Build Your Own AI Apps](https://github.com/langgenius/dify)

dify, short for Do It For You, is an easy-to-use LLMOps platform that enables you to quickly build your own AI applications. Core capabilities: supports mainstream large language models (including Xunfei Xinghuo, Wenxin Yuyan, and Tongyi Qianwen) via Langchain, visual Prompt orchestration, dataset addition, plugin support, and data annotation and improvement. (8K stars)

10. [dara: Easily Build Interactive Web Apps](https://github.com/causalens/dara)

A low-code development framework similar to Plotly Dash, Streamlit, and Shiny, enabling rapid creation of dashboard applications. The backend is powered by FastAPI, while the frontend is a React-based UI.

![dara app creation example](https://img.pythoncat.top/2023-09-02_dara.png)

## 🐼Subscribe Welcome

- [Blog](https://pythoncat.top): Explore my independent blog where you can find a collection of original/translated technical articles over the years, along with some reflections since 2009.
- [Newsletter](https://pythoncat.substack.com/s/python-trending-weekly): Subscribe to my channel on Substack for a curated newsletter delivered straight to your inbox, keeping you updated on current affairs.
- [Github](https://github.com/chinesehuazhou/python-weekly): Access the Markdown source files of this weekly digest on Github and feel free to use them for anything you have in mind!
- [Telegram](https://t.me/pythontrendingweekly): Beyond notifications for the weekly digest, I consider it an "extra edition," providing additional, more diverse information.
- [Twitter](https://twitter.com/chinesehuazhou): Follow me on Twitter where my feed is filled with numerous accounts of developers and organizations in the Python community.