# Python Trending Weekly #17 (2023-08-26)

Welcome to the Python Trending Weekly, a weekly newsletter about Python, AI and general programming techniques, with the majority links in English and a small portion in Chinese. 

The [original version](https://pythoncat.top/posts/2023-08-26-weekly) of the weekly  was written in Chinese. What you are reading here is mostly translated by LLMs. 

**Substack Channel** : [Click to subscribe](https://pythoncat.substack.com/s/python-trending-weekly) 

## 🦄Articles & Tutorials

1. [Excel Finally Supports Python!](https://techcommunity.microsoft.com/t5/microsoft-365-blog/introducing-python-in-excel-the-best-of-both-worlds-for-data/ba-p/3905482)

The big news this week! Microsoft brings Python to Excel, enabling the use of Python's powerful data analysis, statistical modeling, and data visualization libraries (**such as pandas, statsmodels, Matplotlib, and seaborn**) within Excel. Guido tweeted that he was involved in this project.

2. [How to Use FastAPI with aiohttp for SSE Response Development?](https://juejin.cn/post/7269969188391600128)

Server-Sent Events (SSE) enables the server to generate content and return data to the client. This article introduces how FastAPI uses SSE to return data and uses **requests and aiohttp** to obtain and display interface data.

3. [Containerized PDF Summarizer with FastAPI and Hamilton](https://blog.dagworks.io/p/containerized-pdf-summarizer-with)

This article introduces a PDF file summarization tool developed using FastAPI, Hamilton, Streamlit, and ChatGPT. It covers the project's design concept, architecture, and programming implementation. The following figure shows the effect diagram:

![Effect diagram of PDF summarization tool](https://img.pythoncat.top/2023-08-26_pdf.png)

4. [Abandon Python for Mojo? Real-World Experience from a Tencent Engineer](https://juejin.cn/post/7270363281117102099)

Mojo is a new language released by the creator of **LLVM**, which is fully compatible with Python syntax. This article provides a hands-on experience with Mojo programming, discussing some of its syntax, features, and current issues in comparison with Python.

5. [How Mojo Gets a 35,000x Speedup Over Python (Part 1)](https://www.modular.com/blog/how-mojo-gets-a-35-000x-speedup-over-python-part-1)

Mojo is 35,000x faster than Python at generating the Mandelbrot set. This post explains why the Mandelbrot benchmark was chosen and what optimizations the Mojo language makes to achieve such high performance. (P.S. Mojo's company **Modular** announced a \$100 million funding round this week, bringing its total funding to \$130 million!)

6. [What Learning APL Taught Me About Python](https://mathspp.com/blog/what-learning-apl-taught-me-about-python)

APL is a highly symbolic programming language developed in the 1960s. After learning this language, the author deepened his understanding of Python programming. The author was inspired by a simple line of code, which contains elements of elegant Python programming such as built-in functions, Boolean values, data-driven programming, and list comprehensions. (See also: [You Can Also Deepen Your Understanding of Python from These 27 Programming Languages](https://pythoncat.top/posts/2021-12-13-languages))

7. [Deep Dive into Jupyter's Kernel Architecture](https://www.romaglushko.com/blog/jupyter-kernel-architecture/)

Jupyter Notebooks are incredibly powerful, but how do they do it? This post analyzes the kernel architecture of Jupyter along with some interesting implementation details, including the workflow of code execution, code parsing and execution, autocompletion, code inspection, debugging, virtual inputs, clients and gateways, etc. The author promises to analyze **Jupyter Server, JupyterLab, JupyterHub, Jupyter Enterprise Gateway** and other projects in the future.

![Jupyter Kernel Architecture](https://img.pythoncat.top/jupyter-kernel-overview.png)

8. [Fixit 2: Meta’s Next-Generation Autofixing Linter](https://engineering.fb.com/2023/08/07/developer-tools/fixit-2-linter-meta/)

Meta’s open-source linter tool [Fixit](https://github.com/Instagram/Fixit) has released version 2.0, which supports autofixing issues and allows users to customize lint rules. This post discusses the problems Meta faced while using Flake8, why they decided to develop Fixit, and why they rebuilt it into a new version, Fixit 2.

9. [Building a Code Image Generator with Python](https://realpython.com/python-code-image-generator/)

A super detailed full-stack tutorial involving technologies like **Flask, Jinja, Playwright, Pygments, and Javascript** to build a code-to-image generator, which allows you to style and generate beautiful images of code snippets.

10. [apipkg Tutorial: Enhanced Lazy Loading in Python](https://coderslegacy.com/apipkg-tutorial-enhanced-lazy-loading-in-python/)

In issue #16 of the weekly, we shared an article about lazy loading with importlib . This article introduces apipkg , which also achieves the same effect but with a slightly different approach. You can learn by comparing the two.

11. [When asyncio, twisted, tornado, and gevent walk into a bar...](https://www.bitecode.dev/p/asyncio-twisted-tornado-gevent-walk)

When it comes to Python concurrency, you can't avoid the libraries mentioned in the title. The article introduces and compares these libraries, discussing their designs and usage. So, which async library should you use?

12. [The State of Standardized Lockfiles for Python (August 2023)](https://snarky.ca/state-of-standardized-lock-files-for-python-august-2023/)

The author wants to provide a standardized dependency lockfile for Python. They initiated [PEP-665](https://peps.python.org/pep-0665/) in 2021, but it was rejected due to the lack of support for sdist . The author is now doing some proof-of-concept work, planned in 5 steps, and has reached step 3. (Also: a new PEP was opened this month, [PEP-725 – Specifying External Dependencies in pyproject.toml](https://peps.python.org/pep-0725/).)

13. [Python: Just Write SQL](https://joaodlf.com/python-just-write-sql)

The author dislikes using ORMs when programming in Go, so they wanted to try writing SQL directly in Python without using an ORM. The main issue with this return to tradition is that it mixes database operations with business logic, but it's not impossible.

14. [How to Compare Incompatible Types in Python](https://stackabuse.com/incompatible-type-comparisons-in-python/)

A very detailed and fundamental tutorial exploring what a `TypeError` means, why it occurs, and how to fix it. The article is extremely thorough, covering over 20 error-prone scenarios, some of which are beginner mistakes, but some are programming nuances that even experienced developers might overlook.

15. [Create Your Own Diff Tool Using Python](https://florian-dahlitz.de/articles/create-your-own-diff-tool-using-python)

There are many version control and diff tools available, but can we build a simple one using Python? The article uses **difflib, argparse, and HtmlDiff** to build a file comparison tool in both a command-line and an HTML web page version.

16. [My Favorite Prime Number Generator](https://eli.thegreenplace.net/2023/my-favorite-prime-number-generator/)

The Sieve of Eratosthenes is an algorithm for generating prime numbers. The author provides a Python implementation, but the code's performance and memory usage are major concerns. So the author made some optimizations and improvements, and finally gives an optimized version with detailed comments.

🎁 Python Trending Weekly 🎁 organizes its content into seasons, with every 30 issues forming a season. The highlights from the first season have been compiled for your convenience. You can access them online [here](https://pythoncat.top/posts/2023-12-11-weekly) (Chinese).

## 🐿️Projects & Resources

1. [codellama: Meta's newly open-sourced code generation model](https://github.com/facebookresearch/codellama)

This week's hottest open-source project! **Code Llama**, based on **Llama 2**, is free for commercial use, and it's foreseeable that there will be a large number of programming tools in the near future! Currently supported languages include Python, C++, Java, PHP, Typescript/Javascript, C#, and Bash. It's worth mentioning that it contains a special version of "**Code Llama – Python**", fine-tuned on 100B tokens! (4K stars)

2. [seamless_communication: A Foundation Model for State-of-the-Art Speech and Text Translation](https://github.com/facebookresearch/seamless_communication)

**SeamlessM4T** is also an open-sourced project from Meta, which aims to provide high-quality translation for people speaking different languages to communicate easily via speech and text. It supports speech input in 101 languages, text input and output in 96 languages, and speech output in 35 languages. (3.7K stars)

3. [Torchscale: Infrastructure for (M)LLMs](https://github.com/microsoft/torchscale)

A PyTorch library from Microsoft that enables developers to scale up Transformers efficiently, focusing on improving modeling capabilities and versatility while enhancing training stability and efficiency. (2.4K stars)

4. [fastapi-best-practices: Best practices for FastAPI](https://github.com/zhanymkanov/fastapi-best-practices)

This GitHub project is a long article that collects more than 20 best practices for FastAPI, including topics such as project structure, data validation, decoupling and reusing dependencies, following REST, documentation, linters, and more. (4.5K stars)

5. [yappi: Yet another Python Profiler, supports multi-threading, asyncio and gevent](https://github.com/sumerc/yappi)

Yappi is one of the default performance profilers in PyCharm. It is written in C, supports multi-threading, asyncio and gevent, and can show wall time and CPU time. (star 1.2K)

6. [funNLP: Almost the Most Comprehensive Chinese NLP Resource Library](https://github.com/fighting41love/funNLP)

A very rich resource library, containing a large amount of NLP/AI content. (55.7K stars)

7. [prettymapp: Create beautiful maps in web applications](https://github.com/chrieke/prettymapp)

This is a web application and Python package that generates beautiful map artworks from **OpenStreetMap** data. It's based on another 10K-starred project [prettymaps](https://github.com/marceloprates/prettymaps) , and it mainly simplifies the configuration, reduces the code complexity, and develops the web application using streamlit. (1.7K stars)

![Beautiful map](https://img.pythoncat.top/2023-08-26-barcelona.png)

8. [pycparser: A complete C99 parser in pure Python](https://github.com/eliben/pycparser)

A C language parser written in Python that can be easily integrated into programs that need to parse C source code. Its main use is in the **cffi** library, where it is used to parse declarations of C functions and types. (3K stars)

9. [quivr: Generative AI for Your Second Brain](https://github.com/StanGirard/quivr)

Store and retrieve unstructured information with generative AI, think of it as an AI-powered Obsidian. It can handle various file formats like text, images, code, audio, and video. It relies on ChatGPT, Docker, and Supabase, and only supports Ubuntu 22+ as the operating system. (21.7k stars)

10. [KeymouseGo: Mouse and Keyboard Recorder and Automation Like KeySpirit](https://github.com/taojy123/KeymouseGo)

A Chinese project that records users' mouse and keyboard operations and automatically executes the previously recorded operations by triggering a button. The number of executions can be set. It can be understood as a simplified and lightweight version of **KeySpirit**. Supports Windows, Linux, and Mac systems. (4.3k stars)

11. [ahkunwrapped: Integrate AutoHotkey, Automate with Python](https://github.com/CodeOptimist/ahkunwrapped)

**AutoHotkey** is an automation scripting language and utility for creating hotkeys, macros, and automation tasks in Windows, such as simulating keystrokes and mouse actions, window management, clipboard manipulation, automating form filling, and more. This project wraps the AutoHotkey API, allowing you to bridge it with Python and extend AutoHotkey's capabilities.

12. [100+ AI/Machine Learning/Deep Learning/Computer Vision/NLP Projects with Code](https://github.com/ashishpatel26/500-AI-Machine-learning-Deep-learning-Computer-vision-NLP-Projects-with-code)

This repository collects a lot of learning resources, many of which are also aggregation projects, which means that the actual number of projects and materials included is in the tens of thousands. (13.2k stars)

13. [trafilatura: A tool for extracting text from the Web](https://github.com/adbar/trafilatura)

A Python package and command-line tool that processes textual information from the web and converts it into various commonly used formats. It includes web scraping capabilities, HTML parsing, web content extraction, and more. (1.9k stars)

## 🐢Podcasts & Videos

1. [84 Videos from PyCon Australia 2023](https://m.youtube.com/playlist?list=PLs4CJRBY5F1KwxIxbTmhN9jX4hBtE-OKJ)

Video recordings of the talks given at this year's PyCon in Australia. There are 84 videos published so far.

![](https://img.pythoncat.top/2023-08-25_pycon_au.png)

2. [23 Videos from PyCon Israel 2023](https://www.youtube.com/playlist?list=PLnOlTVPC-yFwhpiyjsC0V_98pqRbtwNgh)

Videos from the talks at this year's PyCon in Israel. There are 23 videos published so far.

![](https://img.pythoncat.top/2023-08-25_pycon_israel.png)

3. [44 Videos from SciPy Talk 2023](https://www.youtube.com/playlist?list=PL1PbeFStIOoOd01KhBeba-byU5E5dJ716)

SciPy Talk is an annual conference on scientific computing, typically covering topics such as data analysis, machine learning, artificial intelligence, scientific visualization, and more. There are currently 44 videos available.

![](https://img.pythoncat.top/2023-08-25_scipy2023.png)

## 🥂Discussion & Questions

1. [If you only know Python, how to build the front end of a web application?](https://www.reddit.com/r/Python/comments/15z1amc/how_to_build_the_front_end_of_a_web_app_if_you/)

When developing alone and wanting to quickly implement a full-stack SaaS application that supports user authentication, subscriptions, payment, and other business functions, how should the front end be selected? This Reddit post may provide you with some ideas/methods.

2. Three Popular Discussions About Python Backend on V2EX

The three most popular posts under the Python node recently: [How to Improve Yourself as a Python Backend Developer?](https://www.v2ex.com/t/962899), [Why Are There So Few Python Web Backends in China?](https://www.v2ex.com/t/965956), and [How Does Python Backend Compare to Java or Go?](https://www.v2ex.com/t/966460) From an employment perspective, Python backend is indeed less popular in China, and this is not limited to backend development; other areas also seem to be "cooling down" (except for AI-related fields). One of the original ideas behind Python Trending Weekly was to "steal fire" from Europe and America and inject vitality into the Python community in China. Hopefully, there will be fewer pessimistic sentiments in the forum in the future, such as the desire to abandon xx and find a new path.

## 🐼Subscribe Welcome

- [Blog](https://pythoncat.top): Explore my independent blog where you can find a collection of original/translated technical articles over the years, along with some reflections since 2009.
- [Newsletter](https://pythoncat.substack.com/s/python-trending-weekly): Subscribe to my channel on Substack for a curated newsletter delivered straight to your inbox, keeping you updated on current affairs.
- [Github](https://github.com/chinesehuazhou/python-weekly): Access the Markdown source files of this weekly digest on Github and feel free to use them for anything you have in mind!
- [Telegram](https://t.me/pythontrendingweekly): Beyond notifications for the weekly digest, I consider it an "extra edition," providing additional, more diverse information.
- [Twitter](https://twitter.com/chinesehuazhou): Follow me on Twitter where my feed is filled with numerous accounts of developers and organizations in the Python community.