# Python Trending Weekly #16 (2023-08-19)

Welcome to the Python Trending Weekly, a weekly newsletter about Python, AI and general programming techniques, with the majority links in English and a small portion in Chinese. 

The [original version](https://pythoncat.top/posts/2023-08-19-weekly) of the weekly  was written in Chinese. What you are reading here is mostly translated by LLMs. 

**Substack Channel** : [Click to subscribe](https://pythoncat.substack.com/s/python-trending-weekly) 

## 🦄Articles & Tutorials

1. [Does Elegance Matter When Writing Code?](https://mathspp.com/blog/pydonts/does-elegance-matter)

The author emphasizes the importance of using Python's core features to write idiomatic, expressive, and elegant code, arguing that elegance is not an optional luxury.

2. [Python Asyncio in Practice: How to Prevent Cache Penetration Under High Concurrency](https://so1n.me/2023/08/14/python_asyncio_concunrrency_result_share/)

This article introduces how to write a language-level tool for preventing cache penetration based on the characteristics of `Asyncio.Future`—`Share`, and introduces its usage and processing methods under high concurrency.

3. [Efficiently Handling Scheduled Tasks: Delving into the Nuances of the APScheduler Library in Python](https://juejin.cn/post/7266663176980185144)

APScheduler is a robust library for handling scheduled tasks. This comprehensive article delves into the intricacies of the library, covering topics such as creating scheduled jobs, job triggers, job stores, concurrent execution, blocking and non-blocking schedulers, error handling, executing jobs immediately, scheduler persistence, job listeners, and removing scheduled jobs.

4. [CPython Development Practice: Modifying the lambda Function](https://juejin.cn/post/7266037480750071848)

This article attempts to modify Python's lambda function into an arrow function in the style of Javascript. When compiling CPython, the abstract syntax tree is reconstructed by modifying the `.asdl` file, the syntax analysis file is modified, and the syntax analyzer is regenerated using **pegen**.

5. [How Does CPython Implement Reference Counting?](https://codeconfessions.substack.com/p/cpython-reference-counting-internals)

Are you curious about the underlying workings and internal structures of CPython? This article delves into the source code to explain how CPython implements reference counting and memory management. It covers the mechanics of reference counting, explains key data structures, explores the execution of bytecode instructions, and discusses the limitations of reference counting.

6. [Python Lazy Loading with Importlib](https://coderslegacy.com/python-lazy-loading-with-importlib/)

Lazy loading refers to importing modules when they are needed, rather than when the program starts. Its advantages include reduced startup time, lower memory consumption, improved performance, optimized resource utilization, and runtime loading. This article introduces the usage of `importlib` to achieve lazy loading.

7. [End-to-End Testing with Python and Playwright](https://sixfeetup.com/blog/end-to-end-testing-python-playwright)

End-to-end testing involves testing an application's entire user flow from start to finish, potentially uncovering issues that unit and integration tests may miss. This is a comprehensive introductory tutorial covering the usage of **Playwright**.

8. [The nogil and Faster CPython projects](https://lwn.net/Articles/939981/)

Although the Python official has announced that it will accept **PEP-703**, the final version may have to wait until version 3.17, five years later. Since 2021, the nogil and Faster CPython projects have continued to attract attention. This article reviews their development over the past two years, some key issues handling schemes and important progress, and recent responses from the community and large companies. (Attached: [Python's first workshop on nogil](https://pythoncat.top/posts/2021-11-14-GIL), [Faster CPython project debuts](https://pythoncat.top/posts/2021-05-16-Guido))

9. [Immortal Objects for Python: A Deep Dive](https://engineering.fb.com/2023/08/15/developer-tools/immortal-objects-for-python-instagram-meta/)

Instagram contributed [PEP-683](https://peps.python.org/pep-0683/) (Immortal Objects with Fixed Reference Counting) to Python 3.12, which bypasses reference counting checks and is a key building block for multicore Python parallelism. The article tells the story of how Instagram encountered memory usage issues, introduced immortal objects to solve the problem, and eventually contributed it to CPython.

![Increasing shared memory, reducing private memory and copy-on-write](https://img.pythoncat.top/2023-08-19_immortal.png)

10. [Why You Should Avoid Using "import *" in Python](https://pybit.es/articles/why-you-should-avoid-import-in-python/)

A file in Python is a module, which has its own namespace. When using "import *", it leads to "**namespace pollution**"! The article points out the correct way to follow the PEP-8 style, and also suggests that `__all__` should be used to define the variable names that can be exported in the module.

11. [Let's End Python's Dependency Hell](https://prefix.dev/blog/launching_pixi)

[pixi](https://github.com/prefix-dev/pixi) is a newly released Python package manager written in Rust. This article is from its official blog, mainly introducing why this project was developed, what features it provides, and its basic execution process. The project is currently based on the Conda ecosystem and does not support PyPI yet.

12. [JWT Authentication using Django Rest Framework](https://pythonguides.com/jwt-authentication-using-django-rest-framework/)

A very detailed tutorial that introduces what JWT is and how it works, and demonstrates the whole process of implementing JWT authentication with DRF.

13. [Speed Up Your Django App: 7 Tips for Faster Database Queries](https://johnnymetz.com/posts/slow-django-database-queries/)

Database queries are one of the major factors that affect the performance of web applications. This article introduces 7 tips to improve performance: set a timeout for query execution, use `assertNumQueries` to test the number of queries, use `nplusone` to catch N+1 queries, use `django-zen-queries` to catch N+1 queries, avoid making new queries on prefetched objects, use `defer()` to prevent fetching large unused fields, and avoid using `distinct()` on large fields.

14. [Weird Python "Features" That Might Surprise You](https://martinheinz.dev/blog/103)

Sometimes we see some strange phenomena in programming languages. They may be some very unpopular "features", or they may be mistaken for bugs or cause bugs due to misunderstanding. The author introduces several of his small discoveries.

15. [How Khan Academy Rewrote Their Python Backend in Go](https://blog.quastor.org/p/khan-academy-rewrote-backend)

Khan Academy used Python as its main language for 10 years, but around 2020, it completely switched to Go. This article introduces why and how it refactored the entire Python 2 backend to Go services. The article cites a series of summary blogs from Khan Academy, which can be used for further reading.

16. [Why Static Languages Suffer from Complexity](https://hirrolot.github.io/posts/why-static-languages-suffer-from-complexity.html#the-unfortunate-consequences-of-being-static)

This is a long article about how programming languages should be designed! The author points out that modern programming languages have the problem of "**static-dynamic polymorphism**", and proposes that an ideal programming language should have both static and dynamic features. The article analyzes the practices of two languages, **Idris** and **Zig**, and points out their limitations. Finally, it proposes that programming languages should be rethought.

If you find the weekly valuable, please express your appreciation and support Python Cat~~

![](https://img.pythoncat.top/support_pythoncat.png)

🎁 Python Trending Weekly 🎁 organizes its content into seasons, with every 30 issues forming a season. The highlights from the first season have been compiled for your convenience. You can access them online [here](https://pythoncat.top/posts/2023-12-11-weekly) (Chinese).

## 🐿️Projects & Resources

1. [pixi: A Conda-based package manager written in Rust](https://github.com/prefix-dev/pixi)

A package manager based on the Conda ecosystem, supporting all operating systems, supporting Conda packages in multiple languages, having a Cargo-like command-line interface, and written entirely in Rust. It supports installing packages on a per-project basis, as well as installing them globally, similar to **pipx** and **condax**.

![Demonstration of pixi usage](https://img.pythoncat.top/pixi.png)

2. [briefcase: Convert Python projects into standalone apps](https://github.com/beeware/briefcase)

Supports packaging as Mac, Windows, Linux, Android and iPhone apps, as well as static web sites with PyScript as the client. (2K stars)

3. [facechain: A deep learning toolkit for generating digital avatars](https://github.com/modelscope/facechain)

Last week's trending project, which can generate a digital avatar of an individual with only three photos. It utilizes the text-to-image capabilities of Stable Diffusion, and during training, users can select various LoRA models of different styles. It also supports adding personalized prompts to achieve cosplay effects. (3.2K stars)

4. [ModelScope: Making the Model-as-a-Service Concept a Reality](https://github.com/modelscope/modelscope)

Model-as-a-Service (MaaS) brings together the most advanced machine learning models from the AI community and simplifies the process of using AI models in real-world applications. It features 700+ models covering natural language processing, computer vision, speech, multimodal, and more. (3.6k stars)

5. [Viberary: A Semantic Book Search Engine](https://github.com/veekaybee/viberary)

Instead of searching for books based on conventional criteria like genre and title, Viberary allows users to search for relevant books using query prompts. It leverages the [Two-Tower Semantic Retrieval Model](https://blog.reachsumit.com/posts/2023/03/two-tower-model/), trains data locally using DuckDB, performs retrieval using the Redis Search module, and presents results through a Flask API and a Bootstrap frontend.

![Book search processing flow](https://img.pythoncat.top/tactical_app.png)

6. [Polar: Helping open source maintainers get better funding](https://github.com/polarsource/polar)

It provides a platform for open source maintainers to easily set up, run, and promote supporter-driven value-added and subscription services, helping developers earn revenue from their open source projects. The project has received $1.8 million in seed funding.

7. [youre-the-os: A game where you play as an operating system!](https://github.com/plbrault/youre-the-os)

A really fun game! You play as an operating system, managing processes, memory, and I/O events. Don't let processes idle for too long, or it's game over! The project depends on Python 3.11 and **pipenv**, or you can [play it online](https://plbrault.github.io/youre-the-os/). (1k stars)

![Screenshot of gameplay](https://img.pythoncat.top/in_game_screenshot.png)

8. [learndb-py: LearnDB by implementing a database from scratch](https://github.com/spandanb/learndb-py)

This project implements a relational database from scratch, inspired by the **sqlite** database. Key features: supports rich sql, uses `lark` to build a custom lexer and parser, supports user and proxy modes of connection, implements a BTree for data storage.

9. [mpire: A multiprocessing library faster than the standard library](https://github.com/sybrenjansen/mpire)

Faster and more feature-rich than other multiprocessing libraries: combines the advantages of shared objects with copy-on-write from `multiprocessing.Pool` , has extensive state management features, implements progress bars using tqdm, supports viewing progress in a dashboard, and more. (1.5k stars)

10. [diaphora: A diff tool for binary files](https://github.com/joxeankoret/diaphora)

How do you compare the differences between two versions of a software? What matching techniques are involved when comparing binary software differences? This project claims to be the most powerful software diff tool out there! (3.1k stars)

![Screenshot of iOS 9.3.5 fixing a kernel vulnerability](https://img.pythoncat.top/diaphora.png)

11. [beartype: A near real-time static type checker](https://github.com/beartype/beartype)

A near real-time (NRT) pure-Python runtime type checker that brings Rust and C++'s zero-cost object types to the dynamically-typed world of Python. It selectively augments Python's duck typing with static typing while preserving the former's benefits by default. As the project documentation states, "You can quack like a duck and roar like a bear at the same time!" (2k stars)

12. [cs_books: Computer science books recommended by AzatAI](https://github.com/AzatAI/cs_books)

This repository contains 200+ computer science books, for educational purposes only!

## 🐢Podcasts & Videos

1. [Beyond PEP-8 -- Best Practices for Beautiful, Understandable Code](https://www.youtube.com/watch?v=wf-BqAjZb8M)

This video from PyCon 2015 shows how to write elegant Python code. It has 8200+ likes on YouTube. The speaker, Raymond Hettinger, contributed to many well-known Python features, such as the enumerate() function, generator expressions, OrderedDict(), conditional expressions, and set objects.

2. [5 Steps to Turn "Barely Working" Code into Pythonic](https://www.youtube.com/watch?v=spi0N_PNznE)

Writing working code shouldn't be the end goal, it's just the beginning! This video uses magic methods like \_\_getitem\_\_, \_\_len\_\_, \_\_enter\_\_, and \_\_exit\_\_ to refactor hard-to-maintain code into something Pythonic. The author calls this an 8-minute summary of a previous talk.

## 🐼Subscribe Welcome

- [Blog](https://pythoncat.top): Explore my independent blog where you can find a collection of original/translated technical articles over the years, along with some reflections since 2009.
- [Newsletter](https://pythoncat.substack.com/s/python-trending-weekly): Subscribe to my channel on Substack for a curated newsletter delivered straight to your inbox, keeping you updated on current affairs.
- [Github](https://github.com/chinesehuazhou/python-weekly): Access the Markdown source files of this weekly digest on Github and feel free to use them for anything you have in mind!
- [Telegram](https://t.me/pythontrendingweekly): Beyond notifications for the weekly digest, I consider it an "extra edition," providing additional, more diverse information.
- [Twitter](https://twitter.com/chinesehuazhou): Follow me on Twitter where my feed is filled with numerous accounts of developers and organizations in the Python community.