# Python Trending Weekly #15 (2023-08-12)

Welcome to the Python Trending Weekly, a weekly newsletter about Python, AI and general programming techniques, with the majority links in English and a small portion in Chinese. 

The [original version](https://pythoncat.top/posts/2023-08-12-weekly) of the weekly was written in Chinese. What you are reading here is mostly translated by LLMs. 

**Substack Channel** : [Click to subscribe](https://pythoncat.substack.com/s/python-trending-weekly) 

## 🦄Articles & Tutorials

1. [How to Profile the Performance of Asynchronous Requests in FastAPI](https://blog.balthazar-rouberol.com/how-to-profile-a-fastapi-asynchronous-request)

**cProfile**, a function call-based profiling tool, is not effective in profiling the execution time of asynchronous operations. This article introduces [pyinstrument](https://github.com/joerick/pyinstrument), a profiling library, combined with the **FastAPI.middleware** decorator, and uses [speedscope](https://github.com/jlfwong/speedscope) to visualize the time consumption of FastAPI programs.

![Performance Profiling of FastAPI Programs](https://img.pythoncat.top/2023-08-12_pyinstrument.png)

2. [Leveraging Background Tasks in FastAPI: Enhancing Performance and Responsiveness](https://noplacelikelocalhost.medium.com/leveraging-background-tasks-in-fastapi-enhancing-performance-and-responsiveness-6e4ad64c7d16)

Introduces FastAPI's BackgroundTasks, which allow you to create background tasks to handle long-running tasks without blocking the main process.

3. [Creating Histograms with Python](https://compucademy.net/creating-histograms-with-python/)

A histogram, also known as a bar chart, is a graphical representation that organizes and displays the distribution of data. It provides insights into the data's central tendency, spread, and outliers. This article explores how to create histograms using various Python libraries, including Matplotlib, Plotly, Seaborn, Numpy, and Pandas. It covers different histogram styles and customizations, handling outliers, and analyzing time-series data.

4. [Mypy 1.5 Released](https://mypy-lang.blogspot.com/2023/08/mypy-15-released.html)

Mypy is a static type checker for Python. The major features of version 1.5 include: dropping support for Python 3.7, more flexible TypedDict creation and updates, documentation links that show error codes, experimental improvements to type inference in generic functions, partial support for Python 3.12, and more.

5. [What happens when you run a Python "Hello World" script on Linux?](https://jvns.ca/blog/2023/08/03/behind--hello-world/)

You write `print("hello world")` in a `.py` file, and then execute it from the command line. What happens behind the scenes? The article uses tools like `readelf`, `strace`, `ldd`, `debugfs`, `/proc`, `ltrace`, `dd`, and `stat` to explain in detail the process of executing the script. It mainly involves operating system related content, rather than the CPython interpreter. (P.S. The article also references the recently popular [Putting the "You" in CPU](https://cpu.land/), which introduces how computers run programs. Highly recommended!)

6. [Learn PostScript by Contrasting It with Python](https://kenschutte.com/postscript-vs-python)

PostScript is a page description language in the electronic publishing and desktop publishing domains, widely used in printers, publishing, and graphics devices. The article translates a piece of PostScript code directly into Python code, which can help you quickly understand the syntax of this language.

7. [Casual Performance Optimization in Python](https://www.nathom.dev/blog/casual_performance_optimization_python/)

The author's code took 950 milliseconds in Rust, but 70 seconds in Python! How could this be tolerated! After changing the generator to a for loop, there was only a slight speedup. After some optimizations using Numpy and multiprocessing, we finally saw some significant improvements. A comparison of different code solutions, Python's underlying working principles, memory usage efficiency issues, and differences in language features.

8. [Creating a Context Manager in Python](https://www.pythonmorsels.com/creating-a-context-manager/)

How do you create your own context manager in Python? A context manager is an object that can be used in a `with` block to perform some actions on entry and exit. This article explores the details of implementing a context manager.

9. [A simple module to swap ints in the Python interpreter](https://kenschutte.com/python-swap-ints)

An interesting article. After importing a module, 8 and 9 can be swapped, i.e. `print(8)` will print 9. The article shows how to write a simple module in C, introduces the implementation of the integer object pool in CPython, and achieves a simple number tampering effect by modifying the references of two integers.

10. [Why Python is terrible…](https://josvisser.substack.com/p/why-python-is-terrible)

An article that throws cold water on Python, the main point of view is that Python is not suitable for developing large applications. The criticisms include dynamic and duck typing, performance issues, code maintenance and refactoring difficulties.

11. [Best practices for error handling in Python](https://pybit.es/articles/python-errors-should-not-pass-silently/)

The Zen of Python says "Errors should never pass silently", emphasizing that errors should be faced head-on and handled transparently. The article points out some bad error handling practices and provides programming suggestions such as checking errors early and handling failures quickly.

12. [Build GPT-powered chatbots around enterprise data with Python](https://www.pythongasm.com/build-gpt-powered-chatbots-around-enterprise-data-with-python)

This tutorial introduces the complete process of building a GPT chatbot in an enterprise, including data indexing, query retrieval, LLM integration, API development using FastAPI, and deployment with uvicorn.

13. [Python cocktail: Mix context managers and iterators in equal measure](https://www.bitecode.dev/p/python-cocktail-mix-a-context-manager)

The **tenacity** library provides a way to implement retry mechanisms using a combination of iterators and context managers. This article demonstrates how to achieve the same functionality with custom iterators and context managers, allowing you to gain a deeper understanding of these two useful features.

14. [The power of indexing: Boosting data wrangling efficiency with Pandas](https://stackabuse.com/the-power-of-indexing-boosting-data-wrangling-efficiency-with-pandas/)

Pandas is widely used for data processing, and this article introduces how to efficiently utilize indexing techniques to improve its data wrangling speed and efficiency. It introduces various indexing techniques, such as integer-based indexing, Boolean indexing, setting new indices and resetting old ones, and sorting indices.

15. [Killing the ProcessPoolExecutor](https://www.tinybird.co/blog-posts/killing-the-processpoolexecutor)

Python is not suitable for handling CPU-intensive tasks. The project in the article originally used a process pool to circumvent the GIL issue, and later used threads, C++ extensions, and more refined GIL control to reduce memory usage by 50%, CPU usage by about 20%, threads and processes by about 70%, and I/O traffic by 100%.

🎁 Python Trending Weekly 🎁 organizes its content into seasons, with every 30 issues forming a season. The highlights from the first season have been compiled for your convenience. You can access them online [here](https://pythoncat.top/posts/2023-12-11-weekly) (Chinese).

## 🐿️Projects & Resources

1. [pyinstrument: A Call Stack Profiler for Python](https://github.com/joerick/pyinstrument)

A lightweight, non-intrusive Python code profiling library that supports profiling asynchronous tasks and event loop code, and can generate profiling reports in multiple formats, including text, HTML, and flame graphs. (5.5K stars)

2. [viztracer: Low-overhead logging/debugging/profiling tool that visualizes Python code execution](https://github.com/gaogaotiantian/viztracer)

An open-source logging/debugging/profiling tool developed by Chinese developers. It supports threads, multi-processing, sub-processing, and asynchronous operations. It also supports flame graphs, remote connections, virtual debugging, and has a powerful front end that can smoothly render GB-level stack information. (3.5K stars)

![Visual interface](https://img.pythoncat.top/viztracer.png)

3. [tenacity: Python Retries Library](https://github.com/jd/tenacity)

Provides a simple and flexible way to implement reliable retry mechanisms, supporting features like specifying the number of retries, the interval between retries, a callback function for retries, and retrying based on different error conditions, reducing the hassle of manually handling errors and exceptions. (star 5.1K)

4. [litestar: A lightweight, flexible and extensible ASGI API framework](https://github.com/litestar-org/litestar)

A high-performance ASGI API framework, which was initially developed based on [Starlette](https://github.com/encode/starlette) and named as **Starlite**, but since version 2.0, it has completely removed the dependency on Starlette and renamed to litestar. Core features: class-based controllers, dependency injection, layered middleware, plugin system, OpenAPI 3.1, built-in Trio, and more. (star 2.5K)

5. [Make-It-3D: Creating High-Fidelity 3D Models from a Single Image](https://github.com/junshutang/Make-It-3D)

Segment objects from images, creating high-fidelity 3D geometry that can be rotated 360 degrees. (1.2k stars)

6. [Color-diffusion: Diffusion Model for Colorizing Black and White Images](https://github.com/ErwannMillon/Color-diffusion)

Colorize black and white images using a diffusion model, implemented in the LAB color space, a 3-channel alternative to the RGB color space.

7. [DevOpsGPT: AI-Driven Automated Software Development System](https://github.com/kuafuai/DevOpsGPT)

By combining LLM with DevOps tools, natural language requirements are transformed into working software. There is no need for tedious requirement documentation writing and communication, which shortens development and delivery time and accelerates software deployment and iteration. (star 1.2K)

![Flowchart of Automated Requirement Development](https://img.pythoncat.top/intro-flow-en.png)

8. [ILibCST: A concrete syntax tree parsing and serialization library for Python](https://github.com/Instagram/LibCST)

A concrete syntax tree (CST) is a data structure that is generated after the lexical analysis and parsing stages, and can be used to analyze the structure of code, perform semantic analysis, refactor optimizations, and generate code. (1.2k stars)

9. [hypothesis: Powerful, flexible, and easy to use library for property-based testing](https://github.com/HypothesisWorks/hypothesis)

Property-based testing is a software testing method in which test cases are generated and checked against a given property or specification. Traditional unit tests require you to provide specific test cases, whereas property-based testing generates a large number of test data randomly. (star 6.8K)

## 🐢Podcasts & Videos

1. [Python People Podcast](https://pythonpeople.fm/)

This is a new podcast that has been online for a month, interviewing a prominent contributor to the Python community every week. Guests interviewed so far include Michael Kennedy (host of Talk Python to Me and Python Bytes), Paul Everitt (developer advocate at JetBrains and PyCharm), Brett Cannon (Python core developer), Barry Warsaw (Python core developer, very early member), and Bob Belderbos (host of Pybites).

![](https://img.pythoncat.top/2023-08-12_python_people.png)

2. [Talk Python To Me #426: What's New in PyScript (August 2023)](https://talkpython.fm/episodes/show/426/whats-new-in-pyscript-august-2023)

PyScript enables Python to run in the browser. This episode covers the latest developments.

3. [Stack Overflow Blog #597: Understanding SRE (Ep. 597)](https://stackoverflow.blog/2023/08/08/understanding-sre-ep-597/)

What is Site Reliability Engineering (SRE), and how does it relate to DevOps? How can you balance SRE principles with organizational structure? What impact will generative AI have on SRE?

4. [Stack Overflow Blog #593: How the Python Team Is Adapting the Language for an AI Future (Ep. 593)](https://stackoverflow.blog/2023/07/25/how-the-python-team-is-adapting-the-language-for-an-ai-future-ep-593/)

The podcast features Python core developer and steering council member Pablo Galindo Salgado, discussing how to balance consistency and new features in language design, why it's important to gather community feedback on new releases, and why he's focused on making Python faster.

## 🐼Subscribe Welcome

- [Blog](https://pythoncat.top): Explore my independent blog where you can find a collection of original/translated technical articles over the years, along with some reflections since 2009.
- [Newsletter](https://pythoncat.substack.com/s/python-trending-weekly): Subscribe to my channel on Substack for a curated newsletter delivered straight to your inbox, keeping you updated on current affairs.
- [Github](https://github.com/chinesehuazhou/python-weekly): Access the Markdown source files of this weekly digest on Github and feel free to use them for anything you have in mind!
- [Telegram](https://t.me/pythontrendingweekly): Beyond notifications for the weekly digest, I consider it an "extra edition," providing additional, more diverse information.
- [Twitter](https://twitter.com/chinesehuazhou): Follow me on Twitter where my feed is filled with numerous accounts of developers and organizations in the Python community.