# Python Trending Weekly #14 (2023-08-05)

Welcome to the Python Trending Weekly, a weekly newsletter about Python, AI and general programming techniques, with the majority links in English and a small portion in Chinese. 

The [original version](https://pythoncat.top/posts/2023-08-05-weekly) of the weekly  was written in Chinese. What you are reading here is mostly translated by LLMs. 

**Substack Channel** : [Click to subscribe](https://pythoncat.substack.com/s/python-trending-weekly) 

## 🦄Articles & Tutorials

1. [LPython: A Novel, Fast, Retargetable Python Compiler](https://lpython.org/blog/2023/07/lpython-novel-fast-retargetable-python-compiler/)

A newly released Python compiler (currently in alpha) that aims to provide high-performance Python. It compiles Python code with type hints to optimized machine code, supports both ahead-of-time (AOT) and just-in-time (JIT) compilation, allows interoperability with CPython, and supports multiple backends such as LLVM, C, C++, WASM, Julia, and x86.

2. [Cython 3.0.0 documentation](https://cython.readthedocs.io/en/latest/src/changes.html)

Cython is a programming language designed to make writing C extensions for Python as easy as possible. It has recently jumped from version 0.29.x directly to 3.0.0, bringing a wealth of bug fixes and new features. This changelog is extensive. (Also, here is [a detailed explanation of the changes in Cython 3.0 over the past five years](https://mp.weixin.qq.com/s/CcC1QEojybyRpzUUiJxdAw), summarizing several major changes in this version.)

3. [Coefficient of Variation in Python with Pandas and NumPy](https://www.marsja.se/coefficient-of-variation-in-python-with-pandas-numpy/)

The coefficient of variation (CoV) is a statistical measure that assesses the relative variability or dispersion of a dataset in relation to its mean. The article introduces the formula, interpretation, significance, and practical applications of the coefficient of variation, as well as how to calculate it using Pandas and NumPy.

4. [Generative AI in Jupyter](https://blog.jupyter.org/generative-ai-in-jupyter-3f7174824862)

Jupyter Notebook now supports AI capabilities, which are currently available for free. This tutorial from the official blog guides users on how to use Jupyter AI to complete various tasks in a chat interface. It supports large language models from AI21, Anthropic, AWS, Cohere, HuggingFace Hub, and OpenAI.

5. [Structured Pattern Matching in Python](https://www.tartley.com/posts/structured-pattern-matching-in-python/)

Have you used Python 3.10's pattern matching syntax? This article explores the elements of this syntax (basic structure, demonstration of each pattern), and ponders whether the pattern matching syntax is really necessary to replace `elif`.

6. [Using Rich's Inspect to Interrogate Python Objects](https://textual.textualize.io/blog/2023/07/27/using-rich-inspect-to-interrogate-python-objects/)

Rich is a library for rich text and pretty styles in the terminal (featured in this issue's "Projects & Resources"), and this post introduces its inspect() function, which lets you explore a Python object's attributes and available API.

![Inspecting a file object's attributes and methods](https://img.pythoncat.top/2023-08-05_rich_inspect.png)

7. [Quirks of Python Package Versioning](https://sethmlarson.dev/pep-440)

An obscure topic discussing Python package version numbers. I never knew there were 6 components to a Python package version! The bulk of the article is an introduction to and explanation of [PEP-440 (Version Identification and Dependency Specification)](https://peps.python.org/pep-0440/), with a final section on version naming rules for Wheel packages.

8. [Patterns for Concurrent File I/O Programming](https://superfastpython.com/file-io-concurrent-patterns/)

What are the techniques to improve the performance of file I/O operations using concurrent programming? The article introduces four patterns (single-threaded, thread pool/process pool, batching tasks, thread pool in process pool) and discusses how to choose a more suitable pattern.

9. [How to Read Python Code Efficiently?](https://mostlypython.substack.com/p/reading-code?nthPub=581)

Reading code is an essential skill for all programmers. But how can we read and understand someone else's code efficiently? This article introduces some reading strategies and techniques, which can also help us write more readable and understandable code from the reader's perspective.

10. [How to Call Java Code in Python Using JPype and Pyjnius?](https://www.askpython.com/python/examples/call-java-using-python)

Java and Python have their own advantages. How can we combine them? This article introduces how to call Java using **JPype** and **Pyjnius**, and points out the challenges and limitations of the implementation.

11. [How to Call JavaScript Code in Python?](https://dev.to/willp/call-javascript-code-in-python-551a)

The article introduces the usage of the [PythonMonkey](https://github.com/Distributive-Network/PythonMonkey) library, which enables loading and running JavaScript code in Python, as well as using WASM in Python. (With other articles by the author: [Executing Rust in Python Using WebAssembly](https://medium.com/@willkantorpringle/executing-rust-in-python-using-webassembly-d361eb5583da), [Calling C Function from Python Using WebAssembly](https://medium.com/@willkantorpringle/calling-c-function-from-python-using-webassembly-63a305248951)

12. [Building a ChatGPT TUI Application with Textual](https://chaoticengineer.hashnode.dev/textual-and-chatgpt)

There are several contents related to [Textual](https://github.com/Textualize/textual) in this issue of the weekly! Compared with the graphical user interface (GUI), the text user interface (TUI) is more responsive, has lower system requirements, and is easier to automate. This article builds a ChatGPT dialog tool using Textual.

![Chatting with ChatGPT in the terminal](https://img.pythoncat.top/2023-08-05_tui.png)

13. [Getting Started with Vector Databases in Python](https://code.dblock.org/2023/06/16/getting-started-with-vector-dbs-in-python.html)

How to use the currently popular vector databases in Python? This article introduces indexing and searching vector data using more than 10 databases, including ClickHouse, OpenSearch, pgVector, Pinecone, Redis, and so on.

14. [How Does CPython Compilation Work?](https://dev.to/cwprogram/a-tour-of-cpython-compilation-cd5)

CPython is the official interpreter implementation of Python. This long article introduces its compilation process, including syntax parsing, abstract syntax tree, bytecode, pyc parsing, and other contents.

15. [Introducing the New Open Source Python Debugger pdbp (Pdb+)](https://dev.to/mintzworld/the-new-pdbp-pdb-python-debugger-2blc)

The author points out the shortcomings of Python's built-in **pdb** and other debuggers (such as **ipdb, pdbpp**), introduces the fixes and improvements made by pdbp he developed, and provides a simple introduction. This library has few dependencies and is powerful. It is worth a try.

![](https://img.pythoncat.top/support_pythoncat.png)

🎁 Python Trending Weekly 🎁 organizes its content into seasons, with every 30 issues forming a season. The highlights from the first season have been compiled for your convenience. You can access them online [here](https://pythoncat.top/posts/2023-12-11-weekly) (Chinese).

## 🐿️Projects & Resources

1. [PyFlo: A Fascinating Python Learning Website](https://pyflo.net/) 

This website is amazing, and I highly recommend checking it out! The homepage features a learning roadmap that illustrates various learning paths and content categories. It also includes several programming project challenges. Clicking on each node takes you to the corresponding content page. (It would be interesting to develop a similar website for Chinese readers.)

![Part of the roadmap](https://img.pythoncat.top/2023-08-05_pyflo.png)

2. [Pandas Tutor: A Website to Visualize Pandas Execution](https://pandastutor.com/)

You may already know [Python Tutor](https://pythontutor.com/), an educational tool that provides an online interactive Python programming environment. The Pandas Tutor introduced here is a similar website that allows you to write Pandas code in a browser and visualize how the data is being transformed. (An article by two authors introduces their work of [porting Pandas Tutor to Pyodide](https://blog.pyodide.org/posts/pandastutor/) to facilitate teaching data science at scale.)

![Visualizing the data processing](https://img.pythoncat.top/2023-08-04_pandastutor.png)

3. [ploomber-sql: End-to-end applications with SQL and Jupyter](https://ploomber-sql.readthedocs.io/en/latest/index.html)

This is a tutorial hosted on Read The Docs that introduces how to use SQL and Jupyter for data analysis, covering chapters on working with databases, advanced querying techniques, data visualization (**seaborn, plotly, ggplot**), project packaging, deployment, and monitoring. It is part of the open-source project [ploomber](https://github.com/ploomber/ploomber) (3.1K stars), which is a project for building data pipelines fast.

4. [memray: A memory profiler for Python](https://github.com/bloomberg/memray)

This is a sister project of **pystack**, which was introduced in [issue #12](https://pythoncat.top/posts/2023-07-22-weekly) of the weekly. It can track memory allocations in Python code, C/C++ extension modules, and the Python interpreter itself. It supports native mode and live-view mode, and can generate multiple types of reports. It provides a Pytest plugin [pytest-memray](https://github.com/bloomberg/pytest-memray) that allows you to view memory reports after running a test suite. (11k stars)

5. [textual-paint: MS Paint in your terminal](https://github.com/1j01/textual-paint)

**MS Paint** is a simple image editing software developed by Microsoft. This project is a TUI image editor in the style of MS Paint, supporting opening and saving images in the terminal, all the tools in MS Paint, a color palette, brush preview, and more.

6. [rich: Rich Text and Beautiful Styling for Terminals](https://github.com/Textualize/rich)

Rich is a Python library that allows you to create beautiful and informative text in your terminal. It can be used to create tables, progress bars, Markdown, syntax highlighting, and stack traces. (44.2K stars) The image below shows some of its features:

![Image of Rich's features](https://img.pythoncat.top/2023-08-05-rich.png)

7. [json-lineage: A tool for parsing large JSON files](https://github.com/Salaah01/json-lineage)

This is a JSON parsing library developed in Rust that addresses the pain point of large files not being able to be loaded into memory. It solves the memory consumption problem by converting JSON to JSONL format. Tests show that when processing a 500MB file, the Python standard library uses 2GB of memory, while this library only needs 1.5MB, and the speed difference is very small.

8. [PythonMonkey: A JavaScript Engine Embedded in the Python VM](https://github.com/Distributive-Network/PythonMonkey)

PythonMonkey, which has been mentioned before, embeds Mozilla's SpiderMonkey JavaScript engine into the Python virtual machine, using the Python engine to provide a JS host environment. The goals of this project include calling JavaScript libraries in Python and calling Python libraries in JavaScript. If the ecosystems of these two languages can be effectively connected, the future is immeasurable!

9. [cuDF: GPU Data Frame Library](https://github.com/rapidsai/cudf)

cuDF is a GPU DataFrame library for loading, joining, aggregating, filtering, and otherwise manipulating data, built on the **Apache Arrow** columnar in-memory format. It provides a pandas-like API, without the need to know the details of CUDA programming. (5.8K stars)

10. [distill-sd: Smaller and Faster Stable Diffusion](https://github.com/segmind/distill-sd)

A smaller version of Stable Diffusion made through "knowledge distillation", which can generate images with comparable quality to SD while being much faster and having a smaller footprint.

11. [HQTrack: High-Quality Tracking of Anything in Videos](https://github.com/jiawen-zhu/HQTrack)

A framework for high-performance tracking and segmentation of objects in videos, consisting of a Video Multi-Object Segmentor (VMOS) and a Mask Refiner (MR), which can track multiple objects simultaneously and output accurate object masks.

12. [awesome-mlops: A Curated List of Great MLOps Tools](https://github.com/kelvins/awesome-mlops)

An awesome list of curated MLOps tools, including a wide variety of projects/tools, as well as resources such as articles, books, events, podcasts, and websites.

## 🐢Podcasts & Videos

1. [Talk Python To Me #425: Memray, the Endgame Python Memory Profiler](https://talkpython.fm/episodes/show/425/memray-the-endgame-python-memory-profiler)

This episode of the "Projects & Resources" segment features Memray, and the podcast invites two guests to talk about the project in depth.

## 🐼Subscribe Welcome

- [Blog](https://pythoncat.top): Explore my independent blog where you can find a collection of original/translated technical articles over the years, along with some reflections since 2009.
- [Newsletter](https://pythoncat.substack.com/s/python-trending-weekly): Subscribe to my channel on Substack for a curated newsletter delivered straight to your inbox, keeping you updated on current affairs.
- [Github](https://github.com/chinesehuazhou/python-weekly): Access the Markdown source files of this weekly digest on Github and feel free to use them for anything you have in mind!
- [Telegram](https://t.me/pythontrendingweekly): Beyond notifications for the weekly digest, I consider it an "extra edition," providing additional, more diverse information.
- [Twitter](https://twitter.com/chinesehuazhou): Follow me on Twitter where my feed is filled with numerous accounts of developers and organizations in the Python community.