# Python Trending Weekly #13 (2023-07-29)

Welcome to the 13th issue of Python Trending Weekly, a weekly newsletter about Python, AI and general programming techniques. The [original version](https://pythoncat.top/posts/2023-07-29-weekly) of the weekly publication was written in Chinese, and what you are reading here is the English version translated by ChatGPT.

Most of the content shared here is in English, with a small portion in Chinese, which is indicated in the title. It took a lot of courage for me to publish this weekly publication, originally intended for Chinese readers, to the English-speaking world. Your feedback is welcome, and I appreciate your [subscription](https://pythoncat.substack.com/s/python-trending-weekly) and support!

**Telegram Channel** : [https://t.me/pythontrendingweekly](https://t.me/pythontrendingweekly)

## 🦄Articles & Tutorials

1、[Announcing Jupyter Notebook 7](https://blog.jupyter.org/announcing-jupyter-notebook-7-8d6d66126dcf) 

Major update of Jupyter Notebook, highlights include real-time collaboration, interactive debugging, directory, themes and dark mode, internationalization, improved accessibility, compact view on mobile devices.

2、[Exploring Weak References and Basic Type Support in Python](https://juejin.cn/post/7258881840823615544) (Chinese)

Python's basic types Int, List, Dict, Tuple, Str do not support weak references, while Object, Type, Set and other types do support weak references, why is this the case? The article gives its own analysis.

3、[Introduction and Python Implementation of Distributed Locks](http://so1n.me/2023/07/23/distributed_lock_lntroduction_and_lmplementation/) (Chinese)

When should distributed locks be used? How to implement distributed locks with py-redis, what is the process of locking and unlocking? What are the points to note about the lock timeout, how to implement WatchDog to automatically renew the lock?

4、[Unleashing the Power of PyScript: Running Python Code in HTML](https://scofield.hashnode.dev/unlocking-the-power-of-pyscript-a-guide-to-running-python-code-in-your-html) 

An introductory tutorial on PyScript, introducing installation, basic knowledge, usage with Flask and advanced features.

5、[Faster File I/O Through Concurrency](https://superfastpython.com/faster-file-io-with-concurrency/) 

What is file I/O, why is it much slower than main memory I/O? What factors does the speed of file I/O depend on? What methods are there to improve file I/O performance?

6、[How to Write Impeccably Clean Python Code?](https://dev.to/atkumar/how-to-write-impeccably-clean-code-that-will-save-your-sanity-4np9) 

The article introduces some best programming practices, covering code structure, pre-commit, type hints, docstrings, lint, Pydantic, spell check, testing and other aspects.

7、[Python Logging: Comparing the 6 Most Popular Libraries](https://betterstack.com/community/guides/logging/best-python-logging-libraries/) 

The article provides a detailed comparison of the currently most popular 6 logging frameworks: **logging, loguru, structlog, Eliot, logbook and picologging**. The most recommended are undoubtedly the first two, the others are for interest.

8、[Using cProfile to Analyze Module-Level Code](https://adamj.eu/tech/2023/07/23/python-profile-section-cprofile/) 

How to use **cProfile** to perform performance analysis on Python code? The article briefly introduces its usage, and gives two advanced usage methods: context manager and decorator.

9、[Mastering Functional Programming in Python](https://www.codium.ai/blog/mastering-functional-programming-in-python/) 

The article introduces the advantages of functional programming, Python's support for functional programming, best practices and errors to avoid when writing Python programs.

10、[Python 3.12 Preview: More Intuitive and Consistent f-string](https://realpython.com/python312-f-strings/) 

What limitations does f-string have before Python 3.12? What changes will the upcoming 3.12 version bring? New feature preview: embedded expressions can reuse quotes, f-string allows the use of backslashes, comments can be written in multi-line expressions, arbitrary levels of f-string nesting, optimized f-string error prompts...

11、[Creating Awaitable Constructors with AsyncMixin](https://dev.to/akarshan/asynchronous-python-magic-how-to-create-awaitable-constructors-with-asyncmixin-18j5) 

Introduces how to use a mixin named `AsyncMixin` to create asynchronous constructors in Python.

12、[Finding and Fixing Insecure Direct Object References in Python](https://snyk.io/blog/insecure-direct-object-references-python/) 

Insecure Direct Object References (IDOR) is a security vulnerability, the article introduces the harm of this vulnerability, how to identify and fix IDOR vulnerabilities.

13、[Overcoming Performance Bottlenecks with Asynchronous Python: A Deep Dive into CPU-Intensive Code](https://medium.com/@DorIndivo/overcoming-performance-bottlenecks-with-async-python-a-deep-dive-into-cpu-bound-code-b604a400255a) 

The author introduces how to identify and optimize CPU-intensive code in feature storage to improve the performance of the core model. What is event loop delay, how to monitor the time consumed by asynchronous code?

14、[PEP-720 Cross-Compiling Python Packages](https://peps.python.org/pep-0720/) 

Cross-compiling refers to compiling programs for another architecture on one computer. This PEP attempts to reveal the challenges of cross-compiling and improve upon them.

15、[PEP-722 Dependency Specification for Single-File Scripts](https://pep-previews--3210.org.readthedocs.build/pep-0722/) 

There are many solutions for recording and managing third-party libraries in projects. But how to manage third-party library dependencies for single files? This PEP proposes a very simple specification format.

🎁**Python Trend Weekly**🎁 has been published for free for 13 issues, visit the link below to view all content: [https://pythoncat.top/tags/weekly](https://pythoncat.top/tags/weekly) 

## 🐿️Projects & Resources

1、[Resume-Matcher: Compare resumes with job descriptions, ranked by scoring](https://github.com/srbhr/Resume-Matcher) 

An AI-based resume matcher that scores resumes based on the keywords in the job description. It uses Qdrant (an efficient vector similarity search tool) to measure the match between the resume and the job description.

2、[awesome-python-htmx: Selected content for web development using htmx in Python](https://github.com/PyHAT-stack/awesome-python-htmx) 

PyHAT aims to promote htmx+ASGI+TailwindCSS in Python, this project lists some introductory resources, tutorials, design theories, peripheral ecosystems, etc.

3、[CodeGeeX2: A more powerful multi-language code generation model](https://github.com/THUDM/CodeGeeX2) (Chinese)

Based on the ChatGLM2-6B pedestal language model, it achieves a Pass@1 pass rate of 35.9% in Python, surpassing the larger StarCoder-15B. CodeGeeX plugin supports VS Code, IntelliJ IDEA, PyCharm, GoLand, WebStorm, Android Studio and other IDEs. (star 1K)

![AI programming assistant](https://img.pythoncat.top/codegeex_demo.png)

4、[Chinese-Llama-2-7b: The first downloadable and runnable Chinese LLaMA2 model](https://github.com/LinkSoul-AI/Chinese-Llama-2-7b) (Chinese)

Open source and commercially available **Chinese version of the Llama2 model and Chinese-English SFT dataset**, compatible with all optimizations for the original *llama-2-chat* model. (star 1K)

5、[docker-llama2-chat: LLaMA2 (official / Chinese version / INT4 / llama2.cpp)](https://github.com/soulteary/docker-llama2-chat) (Chinese)

A Chinese open source project, three steps to get started with LLaMA2, the author has written a series of tutorial blogs.

6、[taipy: Transforming data and AI algorithms into complete web applications](https://github.com/Avaiga/taipy) 

A full-stack project that quickly builds web applications from data and AI.

![Front and back end schematic](https://img.pythoncat.top/2023-07-29_taipy.png)

7、[pyrasite: Injecting code into a running Python process](https://github.com/lmacken/pyrasite) 

Allows injecting custom code into a running Python process to achieve dynamic debugging, modifying variable values, cracking encryption, analyzing runtime behavior, etc. Supports various injection methods, including injecting into the Python interpreter, injecting into specific functions, injecting into specific threads, etc. (star 2.7K)

8、[python-manhole: Debugging running Python programs](https://github.com/ionelmc/python-manhole) 

Provides interactive debugging and monitoring functions in running Python processes, using Python's "ptrace" mechanism, by injecting code into the target process, it can be connected via SSH or telnet protocols for remote interaction. Compatible with gevent and eventlet, with some restrictions.

9、[vscode-python: Setting up a Python development environment with VScode and Docker](https://github.com/RamiKrispin/vscode-python) 

A very comprehensive tutorial project, guiding how to run Python on Docker, set up development environment and container extensions, testing and deployment, etc.

![Development workflow with VScode and Docker](https://img.pythoncat.top/docker-architecture.png)

10、[webdriver_manager: Webdriver manager for Python](https://github.com/SergeyPirogov/webdriver_manager) 

When using frameworks like **Selenium** and **Playwright**, you need to manage various browser drivers. This project simplifies the management and usage of browser drivers.

11、[lets-plot: Open source plotting library for statistical data](https://github.com/JetBrains/lets-plot) 

An open-source plotting library by **JetBrains**, it can create beautiful, interactive statistical charts and data visualizations. It provides a **ggplot2**-like plotting API for Python and Kotlin developers. (star 1.1K)

12、[pdfarranger: Merge or split PDF documents in a graphical interface, support rotation, cropping and rearrangement](https://github.com/pdfarranger/pdfarranger) 

A small python-gtk program that edits PDF documents in an intuitive way. Its backend is based on [pikepdf](https://github.com/pikepdf/pikepdf), which is a library for reading and writing PDF files. (star 2.3K)

![pdfarranger interface](https://img.pythoncat.top/pdfarranger.png)

## 🥂Discussion & Question

1、[Steering Council Notice about PEP-703 (Making the Global Interpreter Lock Optional in CPython)](https://discuss.python.org/t/a-steering-council-notice-about-pep-703-making-the-global-interpreter-lock-optional-in-cpython/30474?s=35) 

In the 11th issue of the newsletter, we shared "If PEP-703 is adopted, Meta will invest manpower to support", now there is progress, the steering committee plans to accept PEP-703! This post lists several basic principles and a three-stage development plan. Backward compatibility is the top priority, this will not be Python 4.

## 🐱Sponsor & Support

If you find the weekly valuable, feel free to [appreciate](https://img.pythoncat.top/wechat_code.png) or [buy me coffee](https://www.buymeacoffee.com/pythoncat) to support!

If you like the weekly, please share it with others who need it, so that more people can benefit from it～

## 🐼Subscribe Welcome

[WeChat](https://img.pythoncat.top/python_cat.jpg)| [Blog](https://pythoncat.top)| [Email](https://pythoncat.substack.com) | [Github](https://github.com/chinesehuazhou/python-weekly) | [Telegram](https://t.me/pythontrendingweekly) | [Twitter](https://twitter.com/chinesehuazhou)



