# Python Trending Weekly #12

Welcome to the 12th issue of Python Trending Weekly, a weekly newsletter about Python, AI and general programming techniques. The [original version](https://pythoncat.top/posts/2023-07-22-weekly) of the weekly publication was written in Chinese, and what you are reading here is the English version translated by ChatGPT.

Most of the content shared here is in English, with a small portion in Chinese, which is indicated in the title. It took a lot of courage for me to publish this weekly publication, originally intended for Chinese readers, to the English-speaking world. Your feedback is welcome, and I appreciate your [subscription](https://pythoncat.substack.com/s/python-trending-weekly) and support!

## 🦄 Articles & Tutorials

1、 [Debugging Crashes and Deadlocks in Python using PyStack](https://martinheinz.dev/blog/101) 

Introduces a powerful tool called **PyStack** that can solve difficult debugging problems such as deadlocks, program hangs, segmentation faults, and debugging Python and C/C++ mixed applications. It supports two debugging methods: attaching to a running process or analyzing core dump files of a crashed process.

2、 [FastAPI Project Template](https://bitestreams.com/blog/fastapi_template/) 

A comprehensive FastAPI project template with CI/CD, Docker, PostgreSQL, Makefile, unit/integration testing, linting, and type checking.

3、 [Python FastAPI Microservices with Polylith](https://davidvujic.blogspot.com/2023/07/python-fastapi-microservices-with-polylith.html) 

**Polylith** is a software architecture framework that decomposes a system into testable and reusable independent units. The author combines FastAPI with the Polylith architecture to develop a project template.

4、 [Python Logging Module: Practical Applications and Best Practices](https://juejin.cn/post/7257321872425058359) (Chinese)

Provides a detailed analysis of the **logging** module, covering basic introduction, practical applications, and best practices. It explains how to efficiently use it for logging and how to avoid common pitfalls.

5、 [Benchmarking Python and Rust Async Web Server Performance](https://codesolid.com/benchmarking-python-and-rust-async-web-server-performance/) 

The article uses JMeter to separately test the Rust Axum framework and the Python Blacksheep framework. Can you guess the outcome of the tests?

6、 [dinov2_retrieval: An Image Retrieval Application Based on DINOv2](http://vra.github.io/2023/07/14/dinov2-retrieval/) (Chinese)

Meta has released the **DINOv2** visual pre-training model, which accurately understands the semantic information in images. This article develops a Python tool using it to retrieve the most similar images in a test dataset.

![Bicycles and Tricycles](https://img.pythoncat.top/2023-07-21_dinov2.png)

7、 [CLI Tools Hidden in the Python Standard Library](https://til.simonwillison.net/python/stdlib-cli-tools) 

What useful small tools are there in the Python standard library that can be invoked directly with `python -m xxx`? This article uses **ripgrep** to find dozens of modules and focuses on introducing `http.server`, `base64`, `asyncio`, `tokenize`, `ast`, `json.tool`, `random`, and other tools.

8、 [How to Use TailwindCSS in a Python Project?](https://www.abdulmumin.com/how-to-use-tailwindcss-in-any-python-project) 

Tailwind is a CSS framework that has been popular in frontend development in recent years. How can it be applied to Python web projects? The article mainly introduces the `tailwindpie` library and demonstrates how to use it in a Flask project to achieve automatic installation and configuration of TailwindCSS.

9、 [Practical Guide to Metaprogramming in Python](https://dev.to/karishmashukla/a-practical-guide-to-metaprogramming-in-python-691) 

Introduces several mechanisms of metaprogramming in Python: decorators, metaclasses, function and class decorators, dynamic code generation, as well as keywords and built-in functions commonly used in metaprogramming.

10、 [How Does CPython Print Stack Traces?](https://blog.stealthrocket.tech/how-cpython-prints-stack-traces/) 

A hardcore long article that explains how CPython represents the call stack of a program and how it resolves bytecode addresses to source code line numbers. The article analyzes the internal mechanisms of CPython and provides useful information for CPython performance analysis and debugging.

![Analysis of a Hello World program](https://img.pythoncat.top/2023-07-22-cpython.png)

11、 [Pathlib for Path Operations](https://switowski.com/blog/pathlib/) 

Pathlib is a library for directory-related operations in Python, and it should be the most user-friendly one. The article provides a detailed introduction to its common usage, compares it with other commonly used tools, and performs performance analysis for some scenarios.

12、 [Software Architectures of Stack Overflow, Shopify, and Levels.fyi](https://newsletter.techworld-with-milan.com/p/stack-overflow-architecture) 

The article discusses the software architectures of three major websites.

13、 [10 Tips for Writing Clean Python Code](https://dev.to/alexomeyer/10-must-know-patterns-for-writing-clean-code-with-python-56bf) 

The readability and maintainability of code cannot be emphasized enough! This article introduces some basic principles that reflect the programming literacy of programmers.

14、 [Meta Developer Tools: A Programming System Supporting Large-Scale Collaboration](https://engineering.fb.com/2023/06/27/developer-tools/meta-developer-tools-open-source/) 

What developer tools do thousands of Meta developers use to support large-scale collaboration? The article introduces several open-source tools ([Sapling](https://engineering.fb.com/2022/11/15/open-source/sapling-source-control-scalable/) version control, [Buck2](https://engineering.fb.com/2023/04/06/open-source/buck2-open-source-large-scale-build-system/) build system, [Infer](https://fbinfer.com/)/[RacerD](https://engineering.fb.com/2017/10/19/android/open-sourcing-racerd-fast-static-race-detection-at-scale/)/[Jest](https://jestjs.io/) testing and static analysis), and Meta's official blog also has an article introducing the developer workflow [Meta Developer Workflow: Exploring Tools Used to Code](https://developers.facebook.com/blog/post/2022/11/15/meta-developers-workflow-exploring-tools-used-to-code/).

## 🐿️Projects & Resources

1、[Which Python projects on GitHub are worth recommending for learning?](https://www.reddit.com/r/Python/comments/111y9o2/python_projects_with_best_practices_on_github/) 

Which projects on Github have applied best practices and have a strong and good architecture? This is a post on Reddit, you can go and see what everyone recommends.

2、[python-cheatsheet: Python Quick Reference Guide](https://github.com/gto76/python-cheatsheet) 

A very comprehensive Python manual, in addition to the Github repository, there are also online websites and PDF versions. (star 33K)

![Contents of the cheatsheet](https://img.pythoncat.top/2023-07-22_cheatsheet.png)

3、[pandora: Pandora, a ChatGPT that lets you breathe smoothly](https://github.com/pengzhile/pandora) (Chinese)

A project open-sourced by Chinese developers, it implements the main operations of the web version of ChatGPT, which can solve many pain points of accessing ChatGPT in China. (star 18.6K)

4、[py4web: Database-driven Web development framework](https://github.com/web2py/py4web) 

This framework can quickly develop database-driven Web applications. It is based on the popular full-stack framework [web2py](https://github.com/web2py/web2py), but it is 10-20 times faster than the latter.

![Main panel of py4web](https://img.pythoncat.top/dashboard_main.png)

5、[FastAPI-Vue-Admin: Agile development framework based on FastAPI+Vue](https://www.oschina.net/p/fastapi-vue-admin) (Chinese)

An agile development framework carefully crafted based on FastAPI, Vue2.x, ElementUI, MySQL, etc., implementing a pluggable component-based development method. A Chinese work (paid), with comprehensive Chinese support.

![Project preview](https://img.pythoncat.top/2023-07-22_fastapi-vue-admin.png)

6、[ChatALL: Chat with ChatGPT, Bing Chat, Bard, Alpaca, Claude, Xunfei Starfire, Wenxin Yiyi, etc. at the same time](https://github.com/sunner/ChatALL) (Chinese)

The project, known in Chinese as "Qi Dao", allows for simultaneous chat with multiple AIs to obtain the best answer. (star 8.2K)

![Page when in use](https://img.pythoncat.top/chatall.png)

7、[vectordb: A Python vector database](https://github.com/jina-ai/vectordb) 

A vector database developed in pure Python, supporting CURD and powerful extensibility (sharding and replication). It uses [DocArray](https://github.com/docarray/docarray) as the engine to drive vector search logic, and uses [Jina](https://github.com/jina-ai/jina) to ensure efficient and scalable indexing services.

8、[python-sortedcontainers: Ordered container types (ordered lists, ordered dictionaries, and ordered sets)](https://github.com/grantjenks/python-sortedcontainers) 

An ordered container library implemented in pure Python, providing ordered versions of lists, sets, and dictionaries, with API compatibility, and often faster than C implementations. The user guide provides several performance comparison reports, and the data is impressive. (star 3K)

![Performance comparison of dictionary element reading](https://img.pythoncat.top/2023-07-22_sorteddict.png)

9、[quart: An asynchronous Python Web framework](https://github.com/pallets/quart) 

This is an asynchronous version of the Flask framework, supporting the quick transformation of Flask projects into asynchronous support. (star 2K)

10、[ShortGPT: An AI framework for automatically generating short video content](https://github.com/RayVentura/ShortGPT) 

A powerful automated content generation framework that simplifies video creation, material acquisition, subtitle generation, voiceover synthesis, and editing tasks. (star 1.4K)

![Workflow diagram](https://img.pythoncat.top/shortGPT.png)

## 🐢Podcasts & Videos

1、[Snake Catcher Says Ep 41: Chat with Penguin about CPython optimization and the work of the compiler group in big companies](https://pythonhunter.org/episodes/ep41) (Chinese)

The guest of this podcast has appeared in the 7th issue of our weekly, he added [return constant instruction to CPython](https://github.com/python/cpython/issues/101632), the program talked about his work on CPython and the situation of doing compiler development in Tencent.

2、[The Python Show 07 - Interview with the author of Robyn Web framework](https://www.pythonshow.com/p/07-the-robyn-python-web-framework#details) 

**Robyn** is a lightweight, high-performance Python Web framework developed in Rust. This podcast discussed topics related to Robyn.

3、[80 videos of the 2023 Python Web Conference](https://www.youtube.com/playlist?list=PLt4L3V8wVnF4GJb8dekLGTNx44FNIFwdv) 

The Python Web Conference (Python Web Conf) held its 5th edition this year, and related video materials were released last week, covering topics such as artificial intelligence/machine learning, big data, CI/CD, Serverless, security, containers, etc.

![PWC2023 Program List](https://img.pythoncat.top/2023-07-22_webconf.png)

4、[About AI content: 6 YouTube channels recommended](https://thecreatorsai.com/p/what-to-watch-about-ai-6-youtube) 

Want to understand AI? Want to watch videos related to ChatGPT? Want to discover the latest trendy AI tools? Here are 6 YouTube channels recommended.

5、[Drop Your Weapon 013｜I don't want to work either, I just want to find a shore](https://www.xiaoyuzhoufm.com/episode/64b4f4c5d0844ea812ce31e9) (Chinese)

This is my favorite podcast I heard this week! This episode discussed topics related to employment and life choices. (If you are a college entrance examination graduate, you can listen to the 11th special issue of the college entrance examination [9 years after becoming the top scholar, I am still having nightmares about the college entrance examination](https://www.xiaoyuzhoufm.com/episode/647c8bb653a5e5ea14dbffad))

## 🐱Sponsor & Support

If you find the weekly valuable, feel free to [appreciate](https://img.pythoncat.top/wechat_code.png) or [buy me coffee](https://www.buymeacoffee.com/pythoncat) to support!

If you like the weekly, please share it with others who need it, so that more people can benefit from it～

## 🐼Subscribe Welcome

[WeChat](https://img.pythoncat.top/python_cat.jpg)| [Blog](https://pythoncat.top)| [Email](https://pythoncat.substack.com) | [Github](https://github.com/chinesehuazhou/python-weekly) | [Telegram](https://t.me/pythontrendingweekly) | [Twitter](https://twitter.com/chinesehuazhou)



