# Python Trending Weekly #11 (2023-07-15)

Welcome to the Python Trending Weekly, a weekly newsletter about Python, AI and general programming techniques, with the majority links in English and a small portion in Chinese. 

The [original version](https://pythoncat.top/posts/2023-07-15-weekly) of the weekly  was written in Chinese. What you are reading here is mostly translated by LLMs. 

**Substack Channel** : [Click to subscribe](https://pythoncat.substack.com/s/python-trending-weekly) 

## 🦄Articles & Tutorials

1. [Run Python Code with Golang and Docker](https://soulteary.com/2023/05/21/run-python-code-with-golang-and-docker.html)

How can we use Golang to run Python code? What are the usage limitations regarding Python versions and hardware? This article uses Docker to solve the problem of environmental dependencies and successfully runs Python code with Golang using the open-source project **cpy3**. It has a sequel, [Implement Python Computing Services with Golang and Docker](https://soulteary.com/2023/05/22/using-golang-and-docker-to-implement-python-computing-services.html), which encapsulates ordinary Python software packages as high-performance services that can be called via **gRPC**.

2. [The Answer Is in the Code: The Double Meaning of “Fulfill Requirements”](https://www.piglei.com/articles/the-answer-is-in-the-code-fulfill-requirements/)

Many programmers tend to overlook one thing: the time spent reading code is much longer than the time spent writing it! This means that **code readability** is very important, so when we “fulfill requirements”, in addition to considering the user's functional requirements, we should also pay more attention to how to write readable code.

3. [Relieving Your Python Packaging Pain](https://www.bitecode.dev/p/relieving-your-python-packaging-pain) (EN)

@NoHeartPen Contribution: After reading the [吐槽](https://www.v2ex.com/t/938669#reply88) about conda in the first issue, I started to pay attention to this problem, but I haven't found a relatively systematic summary. After reading this article, I finally had a general idea (this article not only wrote "how to do it", but also wrote "why", which made me change my bad habit of not building a virtual environment and give up tossing conda). In addition, I attach the translated version [How to Relieve the Pain of Python Packaging](https://blog.csdn.net/csdnnews/article/details/131546123).

4. [CuPy: Dispatch NumPy Arrays to Run on GPU](https://www.cnblogs.com/traditional/p/17536459.html)

Travis Oliphant, the creator of NumPy, once said that if NumPy had GPU support at that time, there would be no deep learning frameworks like Tensorflow and Torch. [CuPy](https://github.com/cupy/cupy) is a NumPy-compatible library with GPU support (7K stars). This article introduces its installation and the basics of arrays.

5. [Python Source Code Analysis: Deep Dive into CPython Objects](https://segmentfault.com/a/1190000044006618)

Why is it said that everything in Python is an object? Why is Python much slower than other statically typed languages? This article starts with the CPython object constructor and introduces the underlying data structure of CPython, the process of object creation, and the implementation of dynamic typing.

6. [Build an API Service with Flask + Flask RESTful Quickly](https://juejin.cn/post/7252976055093592120)

A long article about building an API application with Flask + Flask RESTful, using the **Flask-SQLAlchemy** extension to implement ORM operations on a MySQL database, implementing registration, login, and logout interfaces based on JWT authentication, solving cross-origin issues, and deploying the application with Docker.

7. [Django Request and Response in Detail: A Deep Dive into the Core Mechanism of Web Http Interaction](https://segmentfault.com/a/1190000043988232)

This article explores request and response handling in Django, covering the basics, the lifecycle, and detailed explanations of the HttpRequest and HttpResponse objects. It also discusses Django views and request and response handling, as well as considerations for security and asynchronous handling. Finally, it compares and contrasts Django with other frameworks such as Flask and FastAPI in terms of request and response handling.

8. [When Plans Go Astray: My Unsuccessful Journey of Migrating a Large Django Project to Mypy](https://dev.to/derlin/when-plans-go-astray-my-unsuccessful-journey-of-migrating-a-large-django-project-to-mypy-3l23) (English)

The author encountered many issues when adding Mypy type checking to a production project: many libraries don't provide pyi types, TypedDict has limited use, Optional types require many assertions, mixin classes need to implement protocols, and Django models don't support generics. In short, adding type checking to a legacy project is painful and is best considered from the beginning.

9. [How to Use Notion API in Python?](https://www.python-engineer.com/posts/notion-api-python/) (Eng)

Notion is a powerful knowledge management software, this tutorial teaches you how to use Python to operate Notion's database: create integration, create pages in the database, query databases and pages, update pages, delete pages.

10. [The Easiest Way to Speed Up Python with Rust](https://pythonspeed.com/articles/easiest-rust-python/) (Eng)

How to package Rust code as an extension that can be used by Python? maturin and setuptools-rust are two mainstream ways. However, when prototyping, the packaging and integration process is still quite troublesome. This article introduces a new library rustimport, which can directly import Rust code from Python! The article introduces how to use it, the most common performance mistakes for Rust beginners, and some pitfalls when using rustimport.

11. [How Python Parses Whitespace? ](https://jayconrod.com/posts/101/how-python-parses-white-space) (Eng)

Python's newlines and indentation are fundamental parts of its program structure. What role does whitespace play in Python's syntactic parsing, and how does the lexer handle newlines and indentation? What are the advantages and disadvantages of Python's whitespace? How does Python parse the code and generate the abstract syntax tree?

12. [How to Remove Duplicate Values from a Python Dictionary?](https://pythonguides.com/remove-duplicate-values-from-a-python-dictionary/) (Eng)

Introduces 7 methods to remove duplicate values from a Python dictionary: using for loop, using dictionary comprehension, using setdefault() method, using values() and set() methods, using collections.defaultdict(), using list comprehension, using dict.fromkeys() and values().

13. [How to Profile Python Code for Performance Bottlenecks?](https://realpython.com/python-profiling/) (Eng)

When should you profile your project for performance optimization? What should you focus on before tuning the performance, and what tools should you use? This article introduces tools like time, timeit, cProfile, Pyinstrument, perf and some performance optimization skills.

14. [3 Cool Python Libraries That Will Save You Time and Effort](https://samuel-vidovich.medium.com/3-cool-python-libraries-that-will-save-you-time-and-effort-27fcdc6762d5) (Eng)

Introduces 3 very useful libraries: JMESPath (star 1.9k) can easily query elements in Json, inflection can easily process strings (such as batch modifying camel case variable names to snake case naming), more-itertools is similar to the standard library itertools, providing many methods to operate iterable objects (star 3.1k).

15. [How to Organize a Very Large Python Monorepo with Almost 30k Files? ](https://blog.europython.eu/kraken-technologies-how-we-organize-our-very-large-pythonmonolith/)(Eng)

Have you ever seen a Python monorepo with nearly 30k files (excluding tests)? 400 developers around the world are working on it together, how to avoid chaos? The author introduces the practice of hierarchical management of the code warehouse, the architecture and tools used (import-linter), and some difficulties overcome.

🎁 Python Trending Weekly 🎁 organizes its content into seasons, with every 30 issues forming a season. The highlights from the first season have been compiled for your convenience. You can access them online [here](https://pythoncat.top/posts/2023-12-11-weekly) (Chinese).

## 🐿️Projects & Resources

1. [threads-net: Reverse-engineering Threads' Python API](https://github.com/dmytrostriletskyi/threads-net) (EN)

Threads continues to be one of the hottest topics in tech this week with the new release of this project that reverse-engineers its API, allowing you to use Python to interact with many of Threads' features.

2. [engblogs: Summarizing Tech Company Blogs with AI and Deploying as a Website](https://github.com/ishan0102/engblogs) (EN)

This project uses RSS to fetch blogs from tech companies like AWS, Apple, DeepMind, Google, Meta, Stripe, etc., calls gpt-3.5 to generate summaries, stores the data in supabase, and hosts a Next.js [website](https://www.engblogs.dev/) on Vercel.

![Flowchart diagram of the project](https://img.pythoncat.top/engblogs.png)

3. [django-unicorn: A responsive component framework for full-stack Django](https://github.com/adamghill/django-unicorn) (EN)

Adds modern, responsive component functionality to Django templates without the need for a Javascript framework. Supports a wide range of features including form validation, redirects, loading states, partial updates, scroll triggers, messaging, Javascript integration, and more.

4. [imarkdown: Lightweight Markdown image link converter](https://github.com/Undertone0809/imarkdown)

It can batch convert image links from local to image server, image server to local, and image server to image server. (Submitted by @Zeeland)

[Image of imarkdown execution process](https://img.pythoncat.top/imarkdown.png)

5. [Pangu-Weather: The Official Implementation of Pangu Weather](https://github.com/198808xc/Pangu-Weather) (English)

Can AI improve the accuracy of weather forecasting? Pangu-Weather is a 3D high-resolution model that forecasts global weather rapidly and accurately. This repository provides resources including pseudocode, pre-trained models, inference code, and more.

6. [PULSE: A Large-Scale Chinese Biomedical Language Model](https://github.com/openmedlab/PULSE)

Fine-tuned with 4 million instructions in the Chinese medical and general domains, it supports various natural language processing tasks in the medical field, including health education, medical examination questions, report interpretation, medical record structuring, and simulated diagnosis and treatment. Based on this large model, there are already many applications, such as **XrayPULSE**, an application combined with X-ray image models:

![Diagnostic and Consulting X-ray Images](https://img.pythoncat.top/XrayPULSE.jpg)

7. [creosote: Identify unused dependencies in virtual environments](https://github.com/fredrikaverpil/creosote) (Eng)

Scan virtual environments for unused dependencies, supporting Poetry, Pipenv, PDM, `requirements.txt` files, and PEP-621 `pyproject.toml` files.

8. [MediaGPT: A Large Language Model for Chinese Self-Media](https://github.com/IMOSR/MediaGPT)

A large language model for self-media creation, live broadcasting, and operation, which can understand the core concepts and strategies of Douyin operation, short video creation, massive Qianchuan delivery, live broadcasting operation, etc., and supports content creation, platform operation, advertising delivery, etc.

9. [MetaGPT: Given a Single Line of Requirement, It Returns PRD, Design, Tasks, and Code](https://github.com/geekan/MetaGPT) (Eng)

A meta-programming framework that assigns different roles (e.g., product manager/architect/project manager/engineer) to GPT, enabling them to collaborate and complete complex software development tasks. With just a single line of requirement, it can generate user stories/competitive analysis/requirements/data structures/APIs/documentation, etc. (3.7k stars)

10. [khoj: An AI Personal Assistant for Your Digital Brain](https://github.com/khoj-ai/khoj) (Eng)

An AI assistant that builds on your personal Markdown notes, PDF files, Github code repos, and photos, enabling search and chat, and can be interacted with via multiple interfaces including browser, Emacs, Obsidian, and mobile.

11. [aider: A Command-Line AI Coding Assistant](https://github.com/paul-gauthier/aider) (Eng)

A command-line chat tool that lets GPT create new projects or modify code in existing git repos. It can easily commit, compare, and revert changes with no manual copy/pasting. (2.3k stars)

12. [visprog: Train-Free Compositional Visual Reasoning with Visual Programming](https://github.com/allenai/visprog) (Eng)

The official implementation of a CVPR 2023 best paper, enabling: natural language question answering and reasoning over image content, object labeling in images, natural language image editing, and more.

## 🐢Podcasts & Videos

1. [Talk Python To Me Podcast #421 Python at Netflix](https://talkpython.fm/episodes/show/421/python-at-netflix) (English)

Python is used extensively at Netflix, for use cases such as CDN, demand forecasting and resiliency, security, machine learning, and more. This podcast episode discusses Netflix's experience with Python. Also shared is an older blog post from their official blog that got 8k likes, titled "[Python at Netflix](https://netflixtechblog.com/python-at-netflix-bba45dae649e)".

2. [Python Bytes #343 So Much Pydantic!](https://pythonbytes.fm/episodes/show/343/so-much-pydantic) (English)

This episode covers a lot of topics, but two of them are about Pydantic: the release of version 2 and an [awesome-pydantic](https://github.com/Kludex/awesome-pydantic) list of open source projects using Pydantic.

## 🥂Discussion & Questions

1. [What are some tips for saving Graphics Memory in Pytorch?](https://www.zhihu.com/question/274635237)

A question on Zhihu, with many highly upvoted answers in the front row, each showing their own unique skills!

2. [If PEP-703 Gets Accepted, Meta Will Contribute Engineering Resources](https://discuss.python.org/t/a-fast-free-threading-python/27903/99) (Eng)

PEP-703 has been one of the most anticipated proposals in the Python community this year (I [covered it earlier this year](https://pythoncat.top/posts/2023-02-20-GIL)!). Last month, Guido mentioned on the forum that it would be great if they could get backing from a tech company like Meta. Well, good news everyone, Meta stepped up last week and pledged engineering resources. The news has been met with much discussion on platforms like Twitter and Hacker News (see [HN thread](https://news.ycombinator.com/item?id=36643670)).

## 🐼Subscribe Welcome

- [Blog](https://pythoncat.top): Explore my independent blog where you can find a collection of original/translated technical articles over the years, along with some reflections since 2009.
- [Newsletter](https://pythoncat.substack.com/s/python-trending-weekly): Subscribe to my channel on Substack for a curated newsletter delivered straight to your inbox, keeping you updated on current affairs.
- [Github](https://github.com/chinesehuazhou/python-weekly): Access the Markdown source files of this weekly digest on Github and feel free to use them for anything you have in mind!
- [Telegram](https://t.me/pythontrendingweekly): Beyond notifications for the weekly digest, I consider it an "extra edition," providing additional, more diverse information.
- [Twitter](https://twitter.com/chinesehuazhou): Follow me on Twitter where my feed is filled with numerous accounts of developers and organizations in the Python community.