# Python Trending Weekly #10 (2023-07-08)

Welcome to the Python Trending Weekly, a weekly newsletter about Python, AI and general programming techniques, with the majority links in English and a small portion in Chinese. 

The [original version](https://pythoncat.top/posts/2023-07-08-weekly) of the weekly  was written in Chinese. What you are reading here is mostly translated by LLMs. 

**Substack Channel** : [Click to subscribe](https://pythoncat.substack.com/s/python-trending-weekly) 

## 🦄Articles & Tutorials

1. [Let's Talk About Python and Golang's Garbage Collection](https://www.yance.wiki/gc_go_py)

What are the common garbage collection algorithms, and what are their advantages and disadvantages? What does Python's garbage collection mechanism consist of, and how does it solve the memory leak problem? What is Golang's garbage collection mechanism like, and how does it solve the memory leak problem?

2. [A Tale of Debugging the Competitive](https://albexl.substack.com/p/a-tale-of-debugging-the-competitive)

Competitive programming involves solving a series of problems within a time limit. This article introduces a method for debugging during competitive programming. In addition to improving performance, the method also provides insights for real-world software development.

3. [Python 3.12 Preview: Support for the Linux perf Profiler](https://realpython.com/python312-perf-profiler/)

Python 3.12 is set to be released in October of this year, and one of the biggest changes is support for the Linux `perf` profiler. This article covers what the Linux perf profiler is, what benefits perf can bring to Python, how to use perf in Python 3.12, how to analyze performance data, visualizing performance data, and more.

![Performance profiling data displayed in a desktop application.](https://img.pythoncat.top/2023-07-08_perf.png)

4. [CPython Hiring a Full-Time Engineer](https://lukasz.langa.pl/40b601fc-2b24-4629-91d9-3b32c58365c6/) (EN)

Łukasz Langa, the PSF's first full-time developer (sponsored by Meta), has announced that they are hiring a "deputy" engineer (sponsored by Bloomberg)! This comes just two weeks after the PSF announced [its first full-time security developer](https://pyfound.blogspot.com/2023/06/announcing-our-new-security-developer.html) (sponsored by OpenSSF). We are so grateful to our generous sponsors!

5. [PEP 563 and PEP 649](https://lukasz.langa.pl/61df599c-d9d8-4938-868b-36b67fdb4448/) (EN)

PEP-563 is about lazy evaluation of annotations, PEP-649 is about lazy evaluation of annotations using descriptors. This 2021 article by Łukasz Langa, the author of PEP-563, introduces and compares these two PEPs. They are both in Accepted state, however PEP-563 which was planned for 3.10 was [indefinitely postponed](https://docs.python.org/3/whatsnew/3.11.html#pep-563-may-not-be-the-future), so it seems it needs more attention? (submitted by @Plutonium)

6. [Python Design Patterns: Cookbook Recipes for Clean and Reusable Code (Observer)](https://ritwikmath.hashnode.dev/python-design-patterns-cookbook-recipes-for-clean-and-reusable-code-observer)

Design patterns are often used when building complex software. This article introduces the observer design pattern, its use cases, and provides Python code examples. It also draws some comparisons with event-driven architecture (EDA).

7. [You Don't Need \_\_all\_\_](https://jamesturk.net/posts/you-dont-need-all/)

This article introduces three ways to import modules in Python and the usage of \_\_all\_\_. It focuses on introducing an alternative approach to \_\_all\_\_, which is to directly import the desired names in the \_\_init\_\_.py file.

8. [Building a Toy Programming Language in Python](https://blog.miguelgrinberg.com/post/building-a-toy-programming-language-in-python)

How to implement a programming language in Python? This is a series of tutorials, the first one implements a very basic programming language that can execute print statements, and the second one extends it to support variables and mathematical expressions. It covers topics like lexical analysis, parsing, code generation and execution.

9. [Using Python's collections.Counter to Count Occurrences](https://www.pythonmorsels.com/using-counter/) (Eng)

Counter is one of the most useful data structures in Python. This article introduces some very useful operations: getting the N most common elements, adding elements to the Counter, removing elements, removing negative counts, performing arithmetic operations on Counters, and passing Counter to generator expressions.

10. [Speed Up Your Python Code with Numba Vectorize](https://coderslegacy.com/python-code-with-numba-vectorize/) (Eng)

Numba is a popular tool for improving the performance of Python code. This article introduces its important feature Vectorize, including its internal principles and how it takes advantage of the power of Single Instruction Multiple Data (SIMD) operations. It demonstrates its usage with code examples in 5 scenarios.

11. [Paul Graham: How to Do Great Work?](https://emmmme.com/greatwork) (Eng)

Paul Graham, the author of Hackers & Painters, recently published an article titled "[How to Do Great Work?](http://paulgraham.com/greatwork.html)". The key point in one sentence: doing great work requires curiosity, hard work, and finding the right kind of work for you. The article is long, with several key questions: What is the key to doing great work? How do you find the right kind of work for you? How do you stay curious? What are the standards for great work? Why bother doing great work?

12. [Paul Graham: How to Work Hard?](https://emmmme.com/workhard) (Eng)

Translated from Paul Graham's 2021 article "[How to Work Hard?](http://paulgraham.com/hwh.html)", this article can be read in conjunction with the previous one.

13. [Django June 2023: Tips and Discussions](https://www.pythonmorsels.com/django-june-2023/) (Eng)

This is a monthly aggregation of Django-related tips, resources, articles, and more.

🎁 Python Trending Weekly 🎁 organizes its content into seasons, with every 30 issues forming a season. The highlights from the first season have been compiled for your convenience. You can access them online [here](https://pythoncat.top/posts/2023-12-11-weekly) (Chinese).

## 🐿️Projects & Resources

1. [cinder: Meta's performance-oriented fork of CPython](https://github.com/facebookincubator/cinder) (Eng)

This week's big news: Meta launched Threads, its Twitter competitor, which has already surpassed 30 million sign-ups in just two days. Its backend is powered by Cinder, a high-performance fork of Python 3.10 that includes a number of performance optimizations, including a bytecode inlining cache, pre-evaluation of coroutines, just-in-time (JIT) compilation of each method once, and an experimental bytecode compiler. (star 2.6K)

2. [vlite: A Simple Vector Database Made with NumPy](https://github.com/sdan/vlite) (English)

A fast, lightweight, and simple vector database written in less than 200 lines of code.

![Comparison of processing effects of different databases](https://img.pythoncat.top/250959288-fc36481c-f1f6-4973-8461-6aef3a04486d.png)

3. [gpt-migrate: Migrate codebases from one framework or language to another](https://github.com/0xpayne/gpt-migrate) (Eng)

It's not hard to use GPT to translate a small amount of code from one programming language to another. However, migrating an entire codebase's language/framework sounds like a daunting task! This project aims to do that with GPT-4, and it currently works well with "simple" languages like Python and Javascript. (5.4k stars)

4. [FastDepends: A dependency injection framework extracted from FastAPI, supporting both async and sync mode](https://github.com/lancetnik/FastDepends) (Eng)

This is a dependency injection framework refactored from FastAPI after removing all HTTP logic.

5. [Data-Copilot: Bridging Billions of Data and Humans with Autonomous Workflow](https://github.com/zwq2018/Data-Copilot)

This is an LLM-based system that connects to the Chinese financial market and currently has access to Chinese stocks, funds, economic and financial data, and real-time news.

![Autonomous Query and Prediction Data](https://img.pythoncat.top/demo1.png)

6. [awesome-read-the-docs: Curated list of awesome project documentation](https://github.com/readthedocs-examples/awesome-read-the-docs) (EN)

`Read the Docs` is an open-source platform for building and publishing documentation (you must have seen docs generated by its Sphinx or MkDocs), and this repo collects documentation of open source projects so you can learn how they built their cool docs.

7. [DisCo: Generating Realistic Human Dances from Instructions](https://github.com/Wangt-CN/DisCo) (English)

This is a general-purpose human dance generation toolkit that can generate human dance images and videos from reference images and poses.

![](https://img.pythoncat.top/2023-07-08_disco.png)

8. [Dr. Mark Shannon's PhD Thesis: Building High-Performance Virtual Machines for Dynamic Languages](https://theses.gla.ac.uk/2975/1/2011shannonphd.pdf) (English)

Mark Shannon is known to many for the "[Shannon Plan](https://pythoncat.top/posts/2021-05-16-Guido)". Here we share his PhD thesis (downloadable PDF) from the University of Glasgow in 2011, describing an approach to building virtual machines for dynamic languages and explaining how to design a virtual machine toolkit around an abstract machine.

9. [blind_watermark: Image blind watermarking, watermark extraction without the original image](https://github.com/guofei9987/blind_watermark)

Blind Watermark is a digital watermarking technique that can embed watermarks into data without the need for the original image or text. This project is a frequency-domain-based digital blind watermark that can effectively extract watermarks under various attacks. (3.6k stars)

10. [VisCPM: A Series of Chinese-English Bilingual Multimodal Large Models Based on CPM Foundation Model](https://github.com/OpenBMB/VisCPM)

This is an open-source series of multimodal large models that support Chinese-English bilingual multimodal dialogue capabilities (VisCPM-Chat model) and text-to-image generation capabilities (VisCPM-Paint model). It is trained based on the hundred-billion-parameter language large model CPM-Bee (10B) (introduced in [Weekly Issue 7](https://pythoncat.top/posts/2023-06-17-weekly7)), and integrates a visual encoder (Q-Former) and a visual decoder (Diffusion-UNet) to support the input and output of visual signals.

![](https://img.pythoncat.top/model_zh.png)

11. [polars-cookbook: Tutorial for Python polars library](https://github.com/escobar-west/polars-cookbook) (English)

polars is a Python library written in Rust for data analysis. This repository contains a 9-chapter tutorial on how to use it.

12. [ML System Design: 200 Case Studies](https://www.evidentlyai.com/ml-system-design) (English)

How do companies like Netflix, Airbnb, and Doordash apply machine learning to improve their products and processes? This website compiles 200 case studies from 64 companies, providing insights into real-world use cases of machine learning and how to design machine learning systems.

![Image of 2023-07-08_ML.png](https://img.pythoncat.top/2023-07-08_ML.png)

## 🥂Discussion & Questions

1. [Ask HN: Good books about the history of technology?](https://news.ycombinator.com/item?id=36581241) (English)

A question on Hacker News asking for recommendations for good books about the history of technology.

2. [Ask HN: What are the most valuable computer science books?](https://news.ycombinator.com/item?id=36560950) (English)

Also a question on HN, what CS books do you recommend on topics like programming languages, symbolic logic, algorithms, operating systems, etc.?

## 🐼Subscribe Welcome

- [Blog](https://pythoncat.top): Explore my independent blog where you can find a collection of original/translated technical articles over the years, along with some reflections since 2009.
- [Newsletter](https://pythoncat.substack.com/s/python-trending-weekly): Subscribe to my channel on Substack for a curated newsletter delivered straight to your inbox, keeping you updated on current affairs.
- [Github](https://github.com/chinesehuazhou/python-weekly): Access the Markdown source files of this weekly digest on Github and feel free to use them for anything you have in mind!
- [Telegram](https://t.me/pythontrendingweekly): Beyond notifications for the weekly digest, I consider it an "extra edition," providing additional, more diverse information.
- [Twitter](https://twitter.com/chinesehuazhou): Follow me on Twitter where my feed is filled with numerous accounts of developers and organizations in the Python community.