# Python Trending Weekly #9 (2023-07-01)

Welcome to the Python Trending Weekly, a weekly newsletter about Python, AI and general programming techniques, with the majority links in English and a small portion in Chinese. 

The [original version](https://pythoncat.top/posts/2023-07-01-weekly) of the weekly was written in Chinese. What you are reading here is mostly translated by LLMs. 

**Substack Channel** : [Click to subscribe](https://pythoncat.substack.com/s/python-trending-weekly) 

## 🦄Articles & Tutorials

1. [LangChain + Streamlit + Llama: A Comprehensive Guide to Deploying Open-Source Large Language Models Locally](https://ai.plainenglish.io/%EF%B8%8F-langchain-streamlit-llama-bringing-conversational-ai-to-your-local-machine-a1736252b172)

A step-by-step guide to setting up a document-based question-answering assistant using LangChain and Facebook's open-source LLaMA large language model, along with a user-friendly interface built with Streamlit. (Also available in [Chinese](https://segmentfault.com/a/1190000043935266).)

![](https://img.pythoncat.top/2023-06-30_llm.png)

2. [How much memory does a Python Asyncio coroutine take?](http://so1n.me/2023/05/29/python_asyncio_lib_overhead/)

The article's test result is about 2Kb. In addition, the article also tested the following questions: How many bare coroutines can be created per second? How many coroutines can be processed per second? How much improvement can be achieved in creating and processing coroutine tasks after using `uvloop`?

3. [How to Execute Multiple Coroutines with asyncio.Runner](https://superfastpython.com/asyncio-runner/)

asyncio.Runner is a new feature in Python 3.11 that allows you to execute multiple coroutines in the same event loop. The article covers how to run multiple coroutines using asyncio.run(), how to run multiple coroutines using the wrapper method, and how to use the asyncio.Runner class to execute coroutines in the same event loop in an adaptive or even conditional manner.

4. [Concurrency without Locks](https://hakibenita.com/django-concurrency)

In concurrent programming, it is common to use locks, but it is important to avoid overusing them. This article explores how to achieve concurrency with minimal reliance on locks, using the example of generating short links. The main idea is to "ask for forgiveness" instead of "checking in advance" and to use features provided by the PostgreSQL database.

5. [Contributing to CPython Diary (3) How CPython Works](https://zhuanlan.zhihu.com/p/639119164)

This article introduces how CPython runs Python code. The main processes are: lexical analysis, syntax analysis, compilation to bytecode, and execution of bytecode.

6. [Python JIT Compilers - Just-In-Time Compilation](https://coderslegacy.com/python-jit-compilers/) (EN)

This article explores the concept of JIT compilation and its benefits, and provides an in-depth analysis of the advantages and disadvantages of popular Python JIT compilers (such as PyPy, Numba, and Cython). It also presents best practices and guidelines for using JIT compilers in Python.

7. [What are CPython, Pypy, MicroPython, Jython, etc.?](https://www.bitecode.dev/p/whats-the-deal-with-cpython-pypy)

When we say Python, we usually mean the official implementation CPython, but there are many other "Pythons", such as Pypy, Jython, MicroPython, Brython, RustPython, etc. There are also many things that look like new "Pythons", such as Nuitka, WinPython, Psycho, Pyjion, etc. This article explains the concepts and tools involved.

![](https://img.pythoncat.top/2023-07-01_python.jpeg)

8. [Python APScheduler: Experience the Power of AsyncIOScheduler](https://coderslegacy.com/python-apscheduler-asyncioscheduler/) (Eng)

APScheduler is a scheduling and automation task tool. Its AsyncIOScheduler supports scheduling asynchronous functions and coroutines. The article introduces its functions, advantages, and how to optimize asynchronous task scheduling requirements.

9. [Avoiding Technical Debt When Generating Code](https://sourcery.ai/blog/chatgpt-maintainable-code/)

GPT and other large language models can generate code quickly and in large quantities, but this can also lead to a lot of messy code. The article explores several ways to improve the code generated by these tools and integrate it into projects, including adopting an expert persona, providing examples, following best practices, adhering to standards and clear guidelines, and placing the code in the right place.

10. [When NumPy Is Slow](https://pythonspeed.com/articles/numpy-is-slow/)

How can you improve NumPy performance without considering parallelization? NumPy has three inherent bottlenecks: eager execution, generic compiled code, and high memory usage due to vectorization. To address these bottlenecks, the article presents four solutions: hand-optimizing the code, using JAX for just-in-time compilation, using Numba for just-in-time compilation, and using ahead-of-time compilation.

11. [Numba Tutorial: Accelerate Python Code with JIT Compilation](https://coderslegacy.com/python-numba-tutorial/)

Numba is a specialized just-in-time compiler that eliminates the overhead of interpretation by compiling Python code to efficient machine code, thereby improving performance. The article covers Numba's features, internals, key usage, and common gotchas.

12. [Automating Python Code Quality Improvements](https://blog.fidelramos.net/software/python-code-quality)

How can you improve code quality with less time and effort? The article introduces several tools for improving code quality (flake8, Black, isort, mypy, bandit, etc.) and ways to automate these tools using IDEs, CI, and pre-commit.

13. [Enhancing Data Analysis with PandasAI](https://cognibits.hashnode.dev/enhancing-data-analysis-with-pandasai)

PandasAI is a recently trending library that integrates AI conversational capabilities with Pandas, simplifying data manipulation. The article covers how to perform complex queries and visualize charts with PandasAI and introduces a dozen of its handy functions.

14. [Best Practices for Writing Unit Tests](https://www.codium.ai/blog/best-practices-for-writing-unit-tests/)

The benefits of unit testing are well-known, yet writing unit tests is one of the most disliked tasks for developers. The article lists 10 best practices for writing unit tests, explains the steps for writing unit tests manually, and finally introduces a method for automating test writing using Codium.AI.

15. [How Netflix Safely Migrated to GraphQL](https://netflixtechblog.com/migrating-netflix-to-graphql-safely-8e1e4d4f1e72)

A blog post from Netflix, introducing three testing strategies used during the safe migration of their mobile app from Falcor to GraphQL: A/B testing, Replay testing, and Sticky Canaries. A/B testing was used to assess the impact of the new feature on customers, Replay testing was used to verify the correctness of the migration, and Sticky Canaries were used to verify performance and business metrics.

🎁 Python Trending Weekly 🎁 organizes its content into seasons, with every 30 issues forming a season. The highlights from the first season have been compiled for your convenience. You can access them online [here](https://pythoncat.top/posts/2023-12-11-weekly) (Chinese).

## 🐿️Projects & Resources

1. [PyGWalker: Convert pandas DataFrames to Tableau-style Visualizations](https://github.com/Kanaries/pygwalker)

A visual exploratory data analysis tool that runs in a Jupyter Notebook environment, generating an interactive graphical user interface with a single command, allowing for data exploration via drag-and-drop fields, similar to Tableau/PowerBI. (6.5k stars)

![Image of PyGWalker](https://img.pythoncat.top/pygwalker2.png)

2. [jnumpy: Rapidly write Python C extensions in Julia](https://github.com/Suzhou-Tongyuan/jnumpy) (Eng)

Write high-performance C extensions for Python in Julia, with a speedup of about 200x. (Submitted by @xgdgsc)

3. [jupyter-ai: Generative AI extension for JupyterLab](https://github.com/jupyterlab/jupyter-ai) (Eng)

The official generative AI extension for JupyterLab, which mainly provides: `%%ai` directive, native chat UI page, and support for large language models across platforms (AI21, Anthropic, Cohere, Hugging Face, OpenAI, SageMaker, etc.).

4. [broadcast-service: A Powerful Python Publisher-Subscriber Framework](https://github.com/Undertone0809/broadcast-service)

A publisher-subscriber framework that supports synchronous and asynchronous scheduling, timed tasks, topic management, publisher-subscriber callbacks, and more. (Submitted by @Zeeland)

5. [cushy-storage: A disk-cached ORM framework](https://github.com/Undertone0809/cushy-storage)

A disk-cached ORM framework that enables CRUD operations on basic and custom data types via ORM, supporting multiple serialization operations and data compression methods. (Submitted by @Zeeland)

6. [Giskard: A Testing Framework Dedicated to ML Models](https://github.com/Giskard-AI/giskard) (Eng)

How to test machine learning models, what issues to cover, and how to implement the tests? This framework scans for dozens of vulnerabilities (performance bias, data leakage, lack of robustness, spurious correlations, overconfidence, underconfidence, ethical issues, etc.) and generates domain-specific test suites based on the findings. (1K stars)

![](https://img.pythoncat.top/giskard.png)

7. [DragGAN: Interactive Image Editing Based on Points](https://github.com/XingangPan/DragGAN) (English)

This week's hottest project, which can generate new images you want by dragging points on the image, is amazing! (star 28K)

![](https://img.pythoncat.top/DragGAN.gif)

8. [plumbum: Never write shell scripts again](https://github.com/tomerfiliba/plumbum) (Eng)

In addition to a shell-like syntax and convenient shortcuts, this library provides local and remote command execution (via SSH), local and remote file system paths, easy directory and environment manipulation, and a programmable CLI toolkit. (2.6k stars)

9. [threestudio: A Unified Framework for Generating 3D Content](https://github.com/threestudio-project/threestudio) (Eng)

Supports creating 3D content with text prompts, single images, and a small number of camera images. Supports a variety of models, such as ProlificDreamer, DreamFusion, Magic3D, Score Jacobian Chaining, and more. (1.8k stars)

10. [rembg: A Tool to Remove Image Backgrounds](https://github.com/danielgatis/rembg) (Eng)

Supports removing the background of an image with multiple usage methods (CLI, library, Docker) and a variety of powerful features. (10.5k stars)

![](https://img.pythoncat.top/2023-07-01_rembg.png)

## 🐼Subscribe Welcome

- [Blog](https://pythoncat.top): Explore my independent blog where you can find a collection of original/translated technical articles over the years, along with some reflections since 2009.
- [Newsletter](https://pythoncat.substack.com/s/python-trending-weekly): Subscribe to my channel on Substack for a curated newsletter delivered straight to your inbox, keeping you updated on current affairs.
- [Github](https://github.com/chinesehuazhou/python-weekly): Access the Markdown source files of this weekly digest on Github and feel free to use them for anything you have in mind!
- [Telegram](https://t.me/pythontrendingweekly): Beyond notifications for the weekly digest, I consider it an "extra edition," providing additional, more diverse information.
- [Twitter](https://twitter.com/chinesehuazhou): Follow me on Twitter where my feed is filled with numerous accounts of developers and organizations in the Python community.