# Python Trending Weekly #8 (2023-06-24)

Welcome to the Python Trending Weekly, a weekly newsletter about Python, AI and general programming techniques, with the majority links in English and a small portion in Chinese. 

The [original version](https://pythoncat.top/posts/2023-06-24-weekly) of the weekly  was written in Chinese. What you are reading here is mostly translated by LLMs. 

**Substack Channel** : [Click to subscribe](https://pythoncat.substack.com/s/python-trending-weekly) 

## 🦄Articles & Tutorials

1. [Python 3.13 Release Plan](https://github.com/faster-cpython/ideas/blob/main/3.13/README.md) (EN)

The Faster CPython project (aka Project Shannon) has a new plan for the 3.13 release, with a performance goal of reducing the interpreter's time by 50%. It covers three major efforts: a tier 2 optimizer, enabling subinterpreters (PEP-554), and memory management.

2. [Why Numpy Parallelism Matters?](https://superfastpython.com/why-numpy-parallelism/)

NumPy is one of the most important libraries for scientific computing and data analysis, and parallelism is a key technique to improve its performance. This article introduces five scenarios and methods to achieve NumPy parallelism: loading/saving NumPy array data, efficiently computing mathematical functions, efficiently initializing arrays, performing element-wise mathematical operations on arrays in parallel, and efficiently sharing NumPy array data across processes.

3. [Make Python 100x Faster with Less Than 100 Lines of Rust](https://ohadravid.github.io/posts/2023-03-rusty-python/) (Eng)

The article describes how a Python library with performance issues was rewritten in Rust and optimized in three rounds, resulting in a 100x performance improvement. The py-spy library was used to generate flame graphs, which helped identify the bottlenecks in the code and served as the basis for optimization. The difference between the flame graphs before and after optimization is significant.

![py-spy flame graph](https://img.pythoncat.top/2023-06-23_rust.png)

4. [Porting Python Projects to Rust](https://www.jelmer.uk/port-py-to-rust.html) (EN)

The article points out some problems with the "port-in-one-go" approach, and proposes an "iterative porting" approach, and gives a code example.

5. [Designing Pythonic Library APIs](https://benhoyt.com/writings/python-api-design/)

How do you design a Pythonic API? What are some of the design approaches and principles? The article provides a very detailed introduction in terms of code structure, variable naming, error handling, version control, type annotations, and more. The article is long and concludes with 18 takeaways.

6. [Typed Python Compilation](https://bernsteinbear.com/blog/typed-python/)

Python now supports type hints, so is it possible to compile Python code to native code for better performance? While type hints can provide some performance improvements, the dynamic and flexible nature of Python makes static analysis and compilation very difficult. As a result, there is currently no way to compile Python code to native code for performance gains.

7. [Pytest Fixtures Are Magic!](https://www.revsys.com/tidbits/pytest-fixtures-are-magic/)

Fixtures are a mechanism for setting up and tearing down resources before and after tests, separating test data and test code. This article introduces the basic usage of fixtures in pytest, and how to use them with Django projects.

8. [Inside Python Dict](https://just-taking-a-ride.com/inside_python_dict/chapter1.html)

This is a series of articles that help you explore the implementation of Python dictionaries with visual debugging. This article introduces how to implement a dictionary with a hash table and how to resolve hash collisions.

![Visualization of searching in a list](https://img.pythoncat.top/2023-06-24_dict.png)

9. [Flask vs Django: Selecting the Perfect Python Web Framework](https://djangocentral.com/flask-vs-django-selecting-the-perfect-python-web-framework/) (Eng)

This article provides an in-depth comparison of Flask and Django, two of the most popular Python web frameworks. It covers their key features, advantages and disadvantages, popular plugins, and use cases, helping readers make an informed choice.

10. [Why Not Tell People to Simply Use pyenv, poetry, anaconda](https://www.bitecode.dev/p/why-not-tell-people-to-simply-use) (Eng)

The article aims to introduce a basic Python packaging workflow that minimizes dependencies and requirements and solves packaging problems for most users. It lists common packaging problems and provides solutions, while also pointing out the drawbacks of popular packaging tools like homebrew, pyenv, anaconda, and poetry.

11. [Asyncio in PyScript](https://jeff.glass/post/pyscript-asyncio/) (Eng)

This article explores writing concurrent code in PyScript/Pyodide using `async/await/asyncio`. It also introduces the implementation of Pyodide.Webloop, which enables `async/await` to work with the browser event loop.

12. [The Problem with Threads and How to Fix It](https://glyph.twistedmatrix.com/2014/02/unyielding.html) (Eng)

In contrast to the three articles in the first segment of [last week's issue](https://pythoncat.top/posts/2023-06-17-weekly7) that favor implicit async, a reader suggested presenting viewpoints that support explicit async. This article argues that threads make local reasoning difficult, which is one of the most important things in software development. Therefore, instead of using threads, one should use asynchronous programming models such as callbacks, promises, and coroutines. It also mentions the risks of using implicit coroutines, as they can lead to the same problems as threads. (Submitted by @Plutonium)

🎁 Python Trending Weekly 🎁 organizes its content into seasons, with every 30 issues forming a season. The highlights from the first season have been compiled for your convenience. You can access them online [here](https://pythoncat.top/posts/2023-12-11-weekly) (Chinese).

## 🐿️Projects & Resources

1. [PyQt-Fluent-Widgets: A Fluent Design style widget library based on PyQt5](https://github.com/zhiyiYo/PyQt-Fluent-Widgets/blob/master/docs/README_zh.md)

There are few open-source and aesthetically pleasing PyQt/PySide widget libraries, so the author wrote this Fluent Design style widget library based on the WinUI3 design draft. It supports seamless switching between light and dark themes and custom theme colors, and is compatible with PyQt5/PyQt6/PySide2/PySide6. It can be used with QtDesigner to quickly design beautiful interfaces. (From @shokokawaii)

![](https://img.pythoncat.top/Interface.jpg)

2. [pyvibe: Generate Stylized HTML Pages with Python](https://github.com/pycob/pyvibe)

PyVibe is a Python library for creating web pages, allowing Python developers to quickly build front-end pages and simplify UI development. PyVibe returns an HTML string that can be used for static pages, Flask functions, and Pyodide dynamic client-side rendering.

![Example of PyVibe generating a heading and text](https://img.pythoncat.top/social.png)

3. [pynecone: A Pure Python Web Framework](https://github.com/pynecone-io/pynecone) (Eng)

Pynecone was released in December 2022 and has gained 9K stars, making it quite popular. It is a full-stack framework for building and deploying web applications. It provides 50+ built-in components, supports creating complex layouts, and allows you to style them using the full power of CSS.

![Pynecone documentation and demo projects](https://img.pythoncat.top/2023-06-24_pynecone.png)

4. [pytudes: bite-sized Python programming exercises](https://github.com/norvig/pytudes) (Eng)

This repository contains a collection of small and challenging coding problems, including Advent of Code puzzles, The Riddler puzzles, word puzzles, probability puzzles, and more. It even has a Sudoku solver in Python and a Lisp interpreter, among other things.

5. [recognize-anything: Recognize Anything Model and Tag2Text Model](https://github.com/xinyu1205/recognize-anything)

Recognize Anything Model is an image tagging model that can recognize any common categories with high accuracy; Tag2Text is a tag-guided visual language model that can support captioning, retrieval, and tagging. This project is the code implementation of these two models.

![Comparison of object tagging capabilities of different models](https://img.pythoncat.top/tagging_results.jpg)

6. [ask-multiple-pdfs: Langchain program that supports chatting with multiple PDFs](https://github.com/alejandro-ao/ask-multiple-pdfs) (EN)

Allows to talk to multiple PDF files at the same time using natural language. The project uses streamlit to display the user interface in a web browser.

![Schematic diagram of the implementation](https://img.pythoncat.top/PDF-LangChain.jpg)

7. [DeepKE: An Open Toolkit for Knowledge Extraction and Knowledge Graph Construction](https://github.com/zjunlp/DeepKE) (EN)

DeepKE is a knowledge extraction toolkit for knowledge graph construction, supporting entity, relation, and attribute extraction in cnSchema, low-resource, document-level, and multimodal scenarios. Three main functions: named entity recognition, relation extraction, and attribute extraction. The project provides detailed documentation, tutorials, and online demos.

![Framework of the model](https://img.pythoncat.top/architectures.png)

8. [awesome-DevOps: A curated list of DevOps platforms, tools, practices, and resources](https://github.com/wmariuss/awesome-devops) (Eng)

A collection of awesome lists about all things DevOps, including platforms, automation, CI/CD, code management, web servers, databases, monitoring tools, gateways, chaos engineering, and more.

## 🥂Discussion & Questions

1. [Hacker News: Our Plan for Python 3.13](https://news.ycombinator.com/item?id=36339777) (Eng)

A hot discussion about the development plan for Python 3.13. As expected, most of the comments are about GIL, both for and against.

2. [What are some elegant codebases in your favorite programming language?](https://news.ycombinator.com/item?id=36370684) (Eng)

This was also an HN thread that sparked discussions about programming languages themselves as well as some great projects in different programming language ecosystems. Interestingly, three comments about Python all recommended the `pytudes` project that we shared earlier!

## 🐼Subscribe Welcome

- [Blog](https://pythoncat.top): Explore my independent blog where you can find a collection of original/translated technical articles over the years, along with some reflections since 2009.
- [Newsletter](https://pythoncat.substack.com/s/python-trending-weekly): Subscribe to my channel on Substack for a curated newsletter delivered straight to your inbox, keeping you updated on current affairs.
- [Github](https://github.com/chinesehuazhou/python-weekly): Access the Markdown source files of this weekly digest on Github and feel free to use them for anything you have in mind!
- [Telegram](https://t.me/pythontrendingweekly): Beyond notifications for the weekly digest, I consider it an "extra edition," providing additional, more diverse information.
- [Twitter](https://twitter.com/chinesehuazhou): Follow me on Twitter where my feed is filled with numerous accounts of developers and organizations in the Python community.