# Python Trending Weekly #7 (2023-06-17)

Welcome to the Python Trending Weekly, a weekly newsletter about Python, AI and general programming techniques, with the majority links in English and a small portion in Chinese. 

The [original version](https://pythoncat.top/posts/2023-06-17-weekly) of the weekly  was written in Chinese. What you are reading here is mostly translated by LLMs. 

**Substack Channel** : [Click to subscribe](https://pythoncat.substack.com/s/python-trending-weekly) 

## 🦄Articles & Tutorials

1. [AsyncIO](https://charlesleifer.com/blog/asyncio) (English)

The author of the article dislikes the asyncio library, believing that the design using `async` and `await` is very bad, it is incompatible with most libraries, and it does not meet some of the standards of the "Zen of Python". The author's recommended solution is gevent, mentioning its advantages. In addition, the author also recommends two related articles: Flask author Armin Ronacher's [I don't understand Python's Asyncio](https://lucumr.pocoo.org/2016/10/30/i-dont-understand-asyncio), and SQLAlchemy author Mike Bayer's [Asynchronous Python and Databases](https://techspot.zzzeek.org/2015/02/15/asynchronous-python-and-databases/).

2. [What the Heck is Gevent?](https://eng.lyft.com/what-the-heck-is-gevent-4e87db98a8)

Gevent is a cooperative multitasking Python framework based on coroutines, using monkey patching to patch all code. This post is the first in a series introducing the basic implementation details of gevent, followed by [Gevent Correctness](https://eng.lyft.com/gevent-part-2-correctness-22e3b7998382) and [Gevent Performance](https://eng.lyft.com/gevent-part-3-performance-e64303fa102b).

3. [Getting Started with ReactPy](https://www.kdnuggets.com/2023/06/getting-started-reactpy.html) (EN)

ReactPy, which was recommended in the last issue of the newsletter, has recently become very popular. It supports writing React-style front-end applications in Python. Here is a simple getting started tutorial. In addition, we recommend that interested students read the [official documentation](https://reactpy.dev/docs/guides/getting-started/index.html).

![ReactPy Hello World Program](https://img.pythoncat.top/2023-06-16_reactpy.png)

4. [Some Thoughts on Circular Dependency and Global Contexts in Python Business Frameworks](https://qin.news/python-circular-dependency-and-global-contexts)

How can we solve the circular dependency problem in Python simply and elegantly? The author examined the context management schemes of mainstream API frameworks (Django, Flask, FastAPI), and then introduced the scheme adopted by his own framework: borrowing the concept of object ownership in the Ray community, a simple ownership dictionary is implemented on a coroutine.

5. [Practical Dependency Tracking for Python Function Calls](https://amakelov.github.io/blog/deps)

Tracking the code and data accessed during a Python function call can be useful for operations like drawing dependency graphs, debugging and profiling performance, and invalidating caches. This article explores one possible implementation, including a minimal working implementation in fewer than 100 lines of code. The author is a PhD in Computer Science from MIT.

6. [Python 3.x From Basics to Practice - Typing Type Hints](https://juejin.cn/post/7244033665209073725)

This is an introductory tutorial that introduces the basic and advanced usage of the Python Typing module through concise examples.

7. [An Intro to wxPython](https://www.pythonpapers.com/p/an-intro-to-wxpython)

wxPython is a cross-platform GUI framework based on the wxWidgets library, which was released in 1998. It has evolved to version 4.x, and this article provides a detailed introduction to its latest features.

![wxPython hello world program](https://img.pythoncat.top/2023-06-15_wxpython.png)

8. [A Guide to Using Python Decorators](https://juejin.cn/post/7241943960083546171)

This is a very serious article that introduces the basic concepts and advanced usage of decorators. The example section introduces several commonly used decorators in Django (`@login_required`, `@permission_required`, `@csrf_exempt`, `@cache_page`).

9. [7 Ways to Share Numpy Arrays Between Processes](https://superfastpython.com/numpy-share-array-processes)

One of the trickiest things in multiprocessing is sharing data. This post introduces 7 ways to share Numpy arrays: passing arguments, using global variables, using the Queue, using the Pipe, using RawArray based on ctypes, using SharedMemory from Python 3.8, and using the manager from multiprocessing. This is a systematic and long article, which also cites some related articles by the author. It is highly recommended.

10. [Tools for Working with Time-Series Analysis in Python](https://www.timescale.com/blog/tools-for-working-with-time-series-analysis-in-python)

Time-series data refers to data collected at different points in time. This article introduces tools for analyzing time-series data in Python, including commonly used NumPy, pandas, and Matplotlib, as well as Tsfresh, Sktime, AutoTS, Prophet, Timescale, etc.

![Image of Time-series data analysis tools in Python](https://img.pythoncat.top/2023-06-15_time-series.png)

11. [How to Handle Missing Data Quickly](https://neuronize.dev/learn-handling-missing-data-in-10-minutes)

In the field of data analysis and machine learning, it is necessary to ensure the integrity and accuracy of the dataset as much as possible. Therefore, handling missing values is an essential link. This article first introduces the causes and patterns of missing data (missing completely at random, missing at random, and missing not at random), and then introduces common methods for handling missing values: deletion, filling, and interpolation.

12. [Cython vs CPython: Comparing the Speed Differences](https://coderslegacy.com/cython-vs-cpython-comparing-speed)

This article compares the performance of Cython and CPython using 10 different benchmarks, covering a variety of scenarios and edge cases, including Fibonacci sequence, Fibonacci sequence (iterative), matrix multiplication, prime number generation, string concatenation, calculating mean, calculating mean (unoptimized), arithmetic operations, file operations, linear search, and bubble sort. Guess what the final conclusion is?

13. [Streaming with FastAPI](https://www.vidavolta.io/streaming-with-fastapi)

Server-Sent Events is a one-way HTTP-based communication protocol that allows a server to push data to clients in real time. This article explains how to implement streaming JSON events using FastAPI. This article is from the "FastAPI Pro Series". The other two articles are about [how to use dynamic configuration](https://www.vidavolta.io/dynamically-configure-python-apps-fastapi) and [how to secure your API with API keys](https://www.vidavolta.io/fastapi-api-keys).

![Image of SSE diagram](https://img.pythoncat.top/2023-06-17_sse.png)

14. [20 FastAPI Middleware Interview Questions](https://techwasti.com/fastapi-interview-questions-on-middleware)

Middleware is a mechanism in FastAPI that allows you to intercept and modify HTTP requests and responses before they reach the route handlers. This article contains 20 interview questions related to middleware, authentication, and authorization.

15. [CPython Adds RETURN\_CONST Instruction](https://github.com/python/cpython/issues/101632)

Last week's newsletter sparked a discussion on "the number of Chinese Python contributors". @yihong0618 shared this contribution to CPython by @penguin-wwy on Twitter. The author found that LOAD\_CONST + RETURN\_VALUE appears frequently in the pystats documentation, so he submitted a new RETURN\_CONST instruction. This contribution resulted in a performance improvement of about 10% in the Python 3.12 benchmark.

🎁 Python Trending Weekly 🎁 organizes its content into seasons, with every 30 issues forming a season. The highlights from the first season have been compiled for your convenience. You can access them online [here](https://pythoncat.top/posts/2023-12-11-weekly) (Chinese).

## 🐿️Projects & Resources

1. [argcomplete: Command-line autocompletion library](https://github.com/kislyuk/argcomplete) (EN)

When using Python commands or command-line tools, one pain point is the lack of autocompletion. After using argcomplete, you can press the tab key to automatically complete. It needs to be used with the argparse module, and currently supports two shells: bash and zsh.

2. [Lawyer LLaMA: Chinese Law LLaMA](https://github.com/AndrewZhe/lawyer-llama)

This is a large language model that has systematically learned the Chinese legal knowledge system and can correctly understand legal concepts in common areas such as civil law, criminal law, administrative law, and procedural law. It can provide basic legal advice covering areas such as marriage, loans, maritime law, and criminal law.

3. [CPM-Bee: A 100-Billion-Parameter Chinese-English Bilingual Foundation Large Model](https://github.com/OpenBMB/CPM-Bee)

This is a fully open-source, commercially available 100-billion-parameter Chinese-English foundation model, which adopts the Transformer autoregressive architecture and is pre-trained on a trillion-scale high-quality corpus. On the Zero-CLUE evaluation benchmark in Chinese, it significantly outperforms other models and ranks first among Chinese large models.

![](https://img.pythoncat.top/2023-06-17-BMB.png)

4. [TigerBot: Multilingual Multitask LLM](https://github.com/TigerResearch/TigerBot)

TigerBot is also a large language model open-sourced by a domestic team. According to the automatic evaluation on public NLP datasets in the OpenAI InstructGPT paper, TigerBot-7B achieves 96% of the comprehensive performance of the OpenAI model of the same size.

5. [BingAI-Client: New Bing without Limits](https://github.com/xbzstudio/BingAI-Client)

New Bing is integrated with ChatGPT, but it's not easy to use in China! This project's client is based on Angular, and the server is based on FastAPI and [EdgeGPT](https://github.com/acheong08/EdgeGPT). After deploying it locally, you can start using the client by running the server program. (Another recommended project is [go-proxy-bingai](https://github.com/adams549659584/go-proxy-bingai), which is a New Bing demo site built with Vue3 and Go. It's available in China and doesn't require login.)

6. [tabby: A self-hosted AI coding assistant](https://github.com/TabbyML/tabby) (English)

This is an open-source/on-premises alternative to GitHub Copilot that doesn't require a DBMS or cloud service, has a web UI, and supports consumer-grade GPUs.

![Demonstration of tabby's effects](https://img.pythoncat.top/2023-06-17-tabby.gif)

7. [pyboke: A minimalist static blog generator](https://github.com/ahui2016/pyboke)

A static blog generator with minimalist features, minimalist code, four built-in themes, and support for generating RSS. The project is based on Python 3.10 and mainly uses libraries such as arrow, click, jinja2, and mistune.

8. [gpt-engineer](https://github.com/AntonOsika/gpt-engineer) (English)

This is an AI engineer based on ChatGPT4. All you need to do is tell it what you need, and it will ask a few questions and then generate the entire project code. The provided demo video is amazing!

![gpt-engineer effect demonstration](https://img.pythoncat.top/2023-06-17-engineer.gif)

9. [audiocraft: Audio Processing and Generation Library](https://github.com/facebookresearch/audiocraft) (Eng)

This is an open-source PyTorch library from FaceBook, featuring state-of-the-art EnCodec audio compressor/tokenizer, including the MusicGen text-to-music model, trained on an internal dataset of 10K high-quality music tracks, as well as music data from ShutterStock and Pond5.

10. [PythonGUI Tutorial Website](https://www.pythonguis.com) (Eng)

There are many libraries for developing GUIs in Python, in addition to the aforementioned wxPython, such as Tkinter, PyQt, PySide, Kivy, and more. This website provides a wealth of learning resources related to GUIs.

11. [CPython Implementation Principle](https://hai-shi.gitbook.io/cpython-internals)

This is an online e-book created with GitBook, translated from Microsoft Independent Researcher Anthony Shaw's "CPython Internals".

![](https://img.pythoncat.top/2023-06-16_cpython.png)

## 🐢Podcasts & Videos

1. [pybites: The Importance of Refactoring](https://pybit.es/articles/importance-of-refactoring)

This podcast episode is all about refactoring.

2. [Three Seemingly Identical Lists, But They Take Up Different Amounts of Memory Space?](https://b23.tv/cw3Ai8V)

There are three lists that look exactly the same: [0]*3, [0,0,0], and [0 for _ in range(3)], but the memory calculated using sys.getsizeof() is completely different. Why is this? This Bilibili video analyzes the bytecode and CPython interpreter source code to provide a very hardcore analysis of the root cause. It's worth watching!

3. [asyncio: Understanding and Getting Started, Don't Understand Coroutines? Just Watch This Video](https://b23.tv/2XeGXwI)

This echoes the title and the first content of this issue. asyncio is still the most mainstream asynchronous programming library, and it has gradually matured in recent years. It is necessary to learn it in depth. This is a Bilibili video, suitable for getting started and deepening understanding.

## 🐼Subscribe Welcome

- [Blog](https://pythoncat.top): Explore my independent blog where you can find a collection of original/translated technical articles over the years, along with some reflections since 2009.
- [Newsletter](https://pythoncat.substack.com/s/python-trending-weekly): Subscribe to my channel on Substack for a curated newsletter delivered straight to your inbox, keeping you updated on current affairs.
- [Github](https://github.com/chinesehuazhou/python-weekly): Access the Markdown source files of this weekly digest on Github and feel free to use them for anything you have in mind!
- [Telegram](https://t.me/pythontrendingweekly): Beyond notifications for the weekly digest, I consider it an "extra edition," providing additional, more diverse information.
- [Twitter](https://twitter.com/chinesehuazhou): Follow me on Twitter where my feed is filled with numerous accounts of developers and organizations in the Python community.