# Python Trending Weekly #6 (2023-06-10)

Welcome to the Python Trending Weekly, a weekly newsletter about Python, AI and general programming techniques, with the majority links in English and a small portion in Chinese. 

The [original version](https://pythoncat.top/posts/2023-06-10-weekly) of the weekly  was written in Chinese. What you are reading here is mostly translated by LLMs. 

**Substack Channel** : [Click to subscribe](https://pythoncat.substack.com/s/python-trending-weekly) 

## 🦄Articles & Tutorials

1. [CPython Contributions Diary: What's New in Python 3.12](https://zhuanlan.zhihu.com/p/634654153)

This article was written by my friend @Sun Mengyue. It introduces several major updates in Python 3.12 that he was deeply involved in, such as PEP-701 finalizing the syntax of f-strings, PEP-688 exposing the Python Buffer Protocol to the Python interface, and PEP-695 type parameter syntax. In addition, in his previous article [CPython Contributions Diary](https://zhuanlan.zhihu.com/p/623602662), he introduced relevant knowledge about contributing to open source communities, such as tips for submitting PRs and tips for submitting/resolving Issues. (Do you also want to contribute code to Python? Please refer to: [Python Developer’s Guide](https://devguide.python.org/).)

2. [67 AI Tools You Should Know About](https://topbook.cc/overview?selectedArticle=1975)

This article introduces 67 popular tools, including large language models, search engines, office tools, content generation, mental health, and prompt learning. It also includes a mind map below:

![Mind map of 67 AI tools](https://img.pythoncat.top/e758891909852b4088d3a6db47a6607ca)

3. [I Bought a Python Book Rated 9.6 on Douban, and Found an Error Every 5 Pages?!](https://juejin.cn/post/7240248679515963451)

The article found 30 representative errors in a Python introductory book and gave them a "ridiculousness" score. The author critically read that book, and likewise, readers should critically read this article, because it doesn't always get it right either. (Submitted by @TheFry)

4. [Sketch of a Post-ORM](https://borretti.me/article/sketch-post-orm)

We usually use pure SQL or ORM frameworks to operate databases. The author compares these two schemes, points out their many shortcomings, and then proposes a new technical idea. The author introduces his ideas from 8 aspects, including migration priority, declarative migration, cross-language transplantation, better SQL, and so on. The author also demonstrates a workflow and Python code examples.

5. [The Right Way to Run Shell Commands in Python](https://martinheinz.dev/blog/98) (English)

The author first introduces some commonly used libraries for Python to interact with the operating system, such as pathlib, tempfile, shutil, os, subprocess, etc., and finally introduces the usage of the [sh](https://github.com/amoffat/sh) library, which he recommends the most. The methods of this library are very friendly to those who are familiar with shell commands.

6. [How to Upgrade Your Flask Application Using Async](https://www.vidavolta.io/how-to-upgrade-your-flask-application-using-async/)

This article uses Locust for load testing and gives a simple demonstration of how performance metrics change when a synchronous Flask application is modified to be asynchronous.

![](https://img.pythoncat.top/data-src-image-8d0d9165-c86c-4de9-8c32-6ff0a23793cb.png)

7. [Proposing a Struct Syntax for Python](https://snarky.ca/proposing-a-struct-syntax/) (English)

Core developer Brett Cannon shares his thoughts on a blog post proposing the addition of a `struct` keyword to make it easier to create data classes, similar to struct syntax in C, Rust, and Go. The post covers his goals and how the keyword would be implemented, and is currently in the feedback-gathering stage, with the possibility of becoming a PEP in the future.

8. [What is the relationship between class attributes and instance attributes?](https://juejin.cn/post/7240380161555234876)

From the series "Mastering Python from 1 to ∞", which already includes 17 articles. The author refers to the analysis methods and conclusions of "Python Source Code Analysis" to deeply explore the source code of the Python interpreter and explain the implementation principles of important features of Python.

9. [39 Top Python Frameworks to Look for in 2023](https://dev.to/lambdatest/39-top-python-frameworks-to-look-for-in-2023-3hdb) (Eng)

The article lists and introduces 39 Python frameworks for development and testing. It is a long article with comprehensive coverage.

10. Content deleted.
11. [Getting Started with Kivy: A GUI Development Library](https://www.pythonguis.com/tutorials/getting-started-kivy/) (Eng)

This is a tutorial for beginners. Kivy is a library for developing graphical user interfaces. It supports cross-platform desktop development and also allows for creating multi-touch applications for mobile devices.

12. [Understanding CPUs Can Help Speed Up Your Numba and NumPy Code](https://pythonspeed.com/articles/speeding-up-numba/) (Eng)

Numba, a just-in-time compiler, is often used to speed up NumPy or reduce its memory usage. This article optimizes code for the characteristics of modern CPUs, reducing the runtime of a program that removes noise from images from 48 ms to 2 ms.

13. [When Python Bytecode Bites Back: Who Checks the Contents of Compiled Python Files? ](https://www.reversinglabs.com/blog/when-python-bytecode-bites-back-who-checks-the-contents-of-compiled-python-files) (Eng)

ReversingLabs researchers discovered a novel attack against PyPI that uses compiled Python code to evade detection—possibly the first attack to leverage PYC files for direct execution.

![Extracted information from pyc file](https://img.pythoncat.top/Who-checks-the-contents-of-compiled-python-files-Figure-9.png)

14. [How GPT Works: A Minimal GPT in 200 Lines of Python](http://arthurchiao.art/blog/gpt-as-a-finite-state-markov-chain-zh/) (Eng)

This is a translated article originally written by Andrej Karpathy, a founding member of OpenAI. The article uses PyTorch to implement a minimal GPT, providing readers with an intuitive understanding of its inner workings.

15. [Two Transformers from Scratch in 600 Lines of Python (Text Classification + Text Generation)](http://arthurchiao.art/blog/transformers-from-scratch-zh/) (Eng)

This is also a translated article originally written by an assistant professor at Vrije Universiteit Amsterdam. The original article was written in 2019, before large language models became as popular as they are today. At the end of the article, the author expresses hope that transformers will expand to other domains due to their strong generalizability.

🎁 Python Trending Weekly 🎁 organizes its content into seasons, with every 30 issues forming a season. The highlights from the first season have been compiled for your convenience. You can access them online [here](https://pythoncat.top/posts/2023-12-11-weekly) (Chinese).

## 🐿️Projects & Resources

1. [neodb: Tag What You Like](https://github.com/neodb-social/neodb)

NeoDB is an open-source project written in Django, and it is a federated universe of tagged books, movies, music, and games. It can be simply understood as a Web3 open-source and uncensored Douban, but it supports much more content than Douban. (I found this library in @laike9m's blog. And thank him very much for recommending this weekly magazine on Twitter!!)

![](https://img.pythoncat.top/2023-06-10_neodb.png)

2. [JupyterLab 4.0 Is Here](https://blog.jupyter.org/jupyterlab-4-0-is-here-388d05e03442) (English)

JupyterLab 4.0's major new features include: faster performance, an upgraded text editor, a new extension manager, UI improvements, and more.

3. [pystack](https://github.com/bloomberg/pystack)

pstack is a command-line tool commonly used on Linux systems to display the function call stack of a process, which can be used to diagnose problems such as process deadlocks and performance bottlenecks. pystack is a Python implementation of the pstack library. Notably, it can also show whether a thread holds, waits for, or is releasing the GIL.

4. [GPYTHON: Your Dedicated Python Learning Assistant](https://gpython.aibang.run/)

This is an online Python learning platform powered by ChatGPT. It features an AI assistant and an online code execution module, allowing you to modify example code, run it with one click, and debug it with one click. (Submitted by @Stanaaa)

![](https://img.pythoncat.top/2023-06-09_gpython.png)

5. [M3E Model](https://huggingface.co/moka-ai/m3e-base)

M3E is a Chinese open-source embedding model trained on a dataset of tens of millions (2200w+) of Chinese sentence pairs, outperforming the openai-ada-002 model on text classification and retrieval tasks. (Submitted by @Yuxin Wang)

6. [reactpy: React for Python](https://github.com/reactive-python/reactpy) (English)

ReactPy is a library for building user interfaces in Python, without using Javascript. Its API is similar to the components in ReactJS, making it accessible to people without web development experience.

7. [domain-admin: Domain and SSL Certificate Monitoring Platform](https://github.com/mouday/domain-admin)

A domain and SSL certificate monitoring platform implemented with Python and Vue3.js. Its core function is to send automatic email reminders when certificates are about to expire.

![Domain-Admin Architecture](https://img.pythoncat.top/domain-admin-process.png)

8. [EasySpider: A Visual Web Scraping Software](https://github.com/NaiboWang/EasySpider)

EasySpider is a visual web scraping software that allows users to select the content they want to crawl on a webpage and complete the design and execution of the crawler by following the instructions in the prompt box. It also supports command-line execution, which can be easily embedded into other systems. This project originated from the author's master's thesis at Zhejiang University and has been granted a national invention patent. Relevant information can be found in the repository.

9. [text-to-video-synthesis-colab: A Text-to-Video Generation Model](https://github.com/camenduru/text-to-video-synthesis-colab) (English)

An open-source text-to-video generation model with approximately 1.7 billion parameters and English inputs. The released demo videos are quite impressive.

![Some text-to-video generation results](https://img.pythoncat.top/2023-06-10_16-23-19.png)

10. [segment-geospatial: Segmenting Geospatial Data with SAM](https://github.com/opengeos/segment-geospatial) (English)

SAM, short for "Segment Anything Model," is a very useful and advanced model in computer vision for applications that require accurate recognition and segmentation of arbitrary objects. This project uses it to segment geospatial data.

11. [traceback_with_variables: Print Variables in Python Tracebacks](https://github.com/andy-landy/traceback_with_variables) (English)

This project adds variables to Python tracebacks. It makes it easier to debug the cause of exceptions by logging or printing colorful variable context information and showing the values of variables in each frame of the stack trace.

![Comparison of error stack information](https://img.pythoncat.top/color_schemes.png)

## 🐢Podcasts & Videos

1. [When you use Python 3.12, you may run my code!](https://github.com/neodb-social/neodb)

The video is from B station @码农高天. Since March, he has merged 20 PRs into Python 3.12. This video introduces his contributions in detail, including improving the pdb documentation, fixing several bugs, and introducing the convenience variable feature. (After the author's first PR was merged, he recorded an episode of [I fixed a bug in Python! From today on, I can be considered a Python developer?](https://b23.tv/7zZFshm))

2. [PyCon US 2023 - YouTube](https://www.youtube.com/playlist?list=PL2Uw4_HvXqvY2zhJ9AMUa_Z6dtMGF3gtb) (English)

The videos of this year's PyCon US event are available now, with a total of 142 videos! PyCon is one of the largest global Python developer conferences, hosted by the PSF, and the "Python Language Summit" is usually held during PyCon. For this year's summit topics, please refer to "[Python Trending Weekly #4: Python 2023 Language Summit](https://pythoncat.top/posts/2023-05-31-weekly4)".

![PyCon US Video List](https://img.pythoncat.top/2023-06-10_pycon.png)

3. [PyCascades - 2023 Videos](https://www.youtube.com/@PyCascades/videos) (EN)

The videos from the 2023 PyCascades event were released last month, with about 20 videos. PyCascades is a conference focused on the Python programming language, usually held once a year in North America. It is similar to PyCon, but is organized independently by volunteers and is smaller in scale.

## 🐼Subscribe Welcome

- [Blog](https://pythoncat.top): Explore my independent blog where you can find a collection of original/translated technical articles over the years, along with some reflections since 2009.
- [Newsletter](https://pythoncat.substack.com/s/python-trending-weekly): Subscribe to my channel on Substack for a curated newsletter delivered straight to your inbox, keeping you updated on current affairs.
- [Github](https://github.com/chinesehuazhou/python-weekly): Access the Markdown source files of this weekly digest on Github and feel free to use them for anything you have in mind!
- [Telegram](https://t.me/pythontrendingweekly): Beyond notifications for the weekly digest, I consider it an "extra edition," providing additional, more diverse information.
- [Twitter](https://twitter.com/chinesehuazhou): Follow me on Twitter where my feed is filled with numerous accounts of developers and organizations in the Python community.