# Python Trending Weekly #5 (2023-06-03)

Welcome to the Python Trending Weekly, a weekly newsletter about Python, AI and general programming techniques, with the majority links in English and a small portion in Chinese. 

The [original version](https://pythoncat.top/posts/2023-06-03-weekly) of the weekly  was written in Chinese. What you are reading here is mostly translated by LLMs. 

**Substack Channel** : [Click to subscribe](https://pythoncat.substack.com/s/python-trending-weekly) 

## 🦄Articles & Tutorials

1. [How Much Memory Does It Take to Run a Million Concurrent Tasks?](https://pkolaczk.github.io/memory-consumption-of-async/) (English)

The article tests the memory consumption of popular programming languages (Rust, Go, Java, C#, Python, Node.js, and Elixir) by running 1, 10K, 100K, and 1 million tasks, respectively. The ranking of these languages changes significantly as the number of tasks increases, which surprised me.

![Memory usage for 1 million tasks](https://img.pythoncat.top/2023-06-02-100K.png)

2. [Use These Methods to Make Your Python Concurrent Tasks Perform Better](https://towardsdatascience.com/use-these-methods-to-make-your-python-concurrent-tasks-perform-better-b693b7a633e1) (English)

What are the best practices when using asyncio? This article introduces the asyncio.gather, asyncio.as_completed, and asyncio.wait APIs, as well as the new asyncio.TaskGroup feature introduced in Python 3.11. (Also an [incomplete translation](https://juejin.cn/post/7237424021768011834).)

3. The original recommended article was a patchwork and not original, and has been deleted.

4. [The Ultimate Guide to Python Multithreading](https://programmingeeksclub.com/ultimate-python-multithreading-guide) (English)

This is also a long article that introduces all aspects of Python multithreading. It is really an ultimate guide.

5. [How Programming Languages Implement Concurrency: Concurrency Models](https://www.bmpi.dev/dev/deep-in-program-language/how-to-implement-concurrency/concurrency-model/)

This is another long article that introduces common concurrency models and how different programming languages implement them. Its companion article is "[How Programming Languages Implement Concurrency: Operating System Scheduling](https://www.bmpi.dev/dev/deep-in-program-language/how-to-implement-concurrency/os-scheduling/)", both of which are richly illustrated and informative.

![Concurrency Models](https://img.pythoncat.top/2023-06-02_concurrency.png)

6. [9 Survival Rules for Tencent Programmers](https://segmentfault.com/a/1190000043833549)

The author shares his years of experience in code design, architecture design, and work thinking, such as the DRY principle, the SOLID principle, highly available design, how to "be lazy" in every possible way, and so on. (The article mentions the principles of object-oriented programming. Here, I would like to recommend another Tencent programmer's [Python Craftsman](https://github.com/piglei/one-python-craftsman) series, chapters 12-14.)

7. [A First Look at Python 3.12! PEP 701 -- Formalizing f-string Syntax](https://juejin.cn/post/7238274120881422392)

F-strings are one of Python's most useful features, but they also have a number of limitations. The upcoming 3.12 release will formalize the syntax for f-strings, as detailed in [PEP-701](https://peps.python.org/pep-0701/). This article provides a visual demonstration of how this change will affect the lexical analysis (lexing) of code.

8. [Five things to love about the new UI in PyCharm](https://blog.jetbrains.com/pycharm/2023/05/five-things-to-love-about-the-new-ui/) (English)

Have you tried the new UI in PyCharm yet? This official tutorial introduces how to use the new UI and its highlights.

9. [PEP-594 Has Been Implemented: Python 3.13 Removes 20 Stdlib Modules](https://discuss.python.org/t/pep-594-has-been-implemented-python-3-13-removes-20-stdlib-modules/27124) (English)

Python 3.12's official release is still months away, but 3.13 is already here, eagerly removing 20 standard library modules. Notably, the 2to3 project and the lib2to3 module will also be removed.

10. [Grasshopper: An Open-Source Python Library for Load Testing](https://innovation.alteryx.com/introducing-grasshopper-an-open-source-python-library-for-load-testing/)(English)

Locust is the most popular distributed load testing library for Python, and the article introduces [Grasshopper](https://github.com/alteryx/locust-grasshopper), a new open-source performance testing library based on Locust and Pytest that is more comprehensive.

![Image of Grafana dashboard showing Grasshopper and InfluxDB metrics](https://img.pythoncat.top/Screenshot-at-Apr-28-13-09-21.png)

11. [Python Decorators: Enhance Your Code with Wrapping Wizardry](https://hackthedeveloper.com/python-decorator/) (English)

Python decorators are powerful tools for enhancing the behavior and flexibility of your code. The article covers everything from the basics to advanced topics, making it a great learning resource.

12. Three Hands-On Project Tutorials:

- [How to Make a Telegram Bot with Python](https://swiftuser.hashnode.dev/how-to-telegram-bot-with-python) (English): Build a Telegram bot, with the tutorial using Tornado as the backend and deploying the project on Render.
- [Implement DNS in a Weekend with Python](https://implement-dns.wizardzines.com/index.html) (English): The tutorial guides you through implementing a DNS resolver with a total codebase of only about 200 lines, but the author provides a wealth of learning resources and code explanations that you'll definitely learn a lot from. Plus, there are 7 practice problems at the end of the tutorial to further develop the functionality of the DNS resolver. (Julia Evans is a treasure, check out her [blog](https://jvns.ca/), [website](https://wizardzines.com/), [pandas-cookbook](https://github.com/jvns/pandas-cookbook), and more, highly recommended!!!)
- [Build Your Own Git with Python](https://www.leshenko.net/p/ugit/) (English): I'm giving this project full marks! The tutorial website is uniquely and coolly designed, starting with a minimum viable product and gradually adding code, guiding you step-by-step through implementing various Git features. Each chapter uses Git's diff to show you exactly what code has been added or removed, which is very conscientious and I doubt you'll find a second one like it on the whole internet!

![Image of Building Your Own Git](https://img.pythoncat.top/2023-06-02_ugit.png)

🎁 Python Trending Weekly 🎁 organizes its content into seasons, with every 30 issues forming a season. The highlights from the first season have been compiled for your convenience. You can access them online [here](https://pythoncat.top/posts/2023-12-11-weekly) (Chinese).

## 🐿️Projects & Resources

1. [frogmouth: A tool for browsing Markdown in your terminal](https://github.com/Textualize/frogmouth) (English)

frogmouth can open md files from local or URL, and it features a browser-like navigation bar, history, bookmarks, and table of contents.

2. [Python GUI for Image Segmentation with Meta AI's SAM](https://github.com/dibrale/samist) (English)

A Python desktop application that provides a graphical user interface for Meta's AI model SAM, which can extract objects from photos.

3. [GirlfriendGPT: Your AI Companion](https://github.com/EniasCailliau/GirlfriendGPT) (English)

Do you have a girlfriend? This starter project uses ChatGPT to build an AI companion, complete with a personalized personality, voice, and selfie!

4. [Python Evolution.pptx](https://www.slideshare.net/Manjusaka1/python-pptx-258083055)

A PPT presentation of a technical sharing session that introduces the optimizations in Python 3.7-3.11 in terms of performance, type experience, and developer experience.

![Python Interpreter Optimization](https://img.pythoncat.top/2023-06-02_python_road.png)

5. [soundstorm-pytorch: SoundStorm implementation in Pytorch](https://github.com/lucidrains/soundstorm-pytorch) (English)

SoundStorm is an efficient non-autoregressive parallel audio generation model newly proposed by Google Deepmind. soundstorm-pytorch is a Pytorch implementation of this model.

6. [asynq: Python's Asynchronous Programming Library](https://github.com/quora/asynq)

asynq is an asynchronous programming library developed by Quora, which focuses on batching requests to external services. For storage services like memcache and redis, it is much faster to make a single request to fetch multiple keys than to make multiple requests to fetch one key at a time.

7. [Propan: Powerful and easy-to-use Python async web framework](https://github.com/Lancetnik/Propan) (English)

An async framework based on pydantic, fastapi, and pytest, which simplifies the code integration of MQ and provides a useful development toolkit. It is characterized by the design based on Messaging Architecture, so it is also a declarative MQ framework.

8. [talkGPT4All: A Voice Chatbot Based on GPT4All](https://vra.github.io/2023/05/27/talkgpt4all-2-0/)

It uses OpenAI's Whisper model to convert the user's input speech to text, then calls GPT4All's language model to get the response text, and finally uses a text-to-speech (TTS) program to read the response text aloud.

9. [lightly: A Python Library for Self-Supervised Learning of Images](https://github.com/lightly-ai/lightly) (English)

This is a computer vision framework for self-supervised learning, written in a PyTorch-like style and supporting distributed training with PyTorch Lightning.

![Image of an overview of related concepts](https://img.pythoncat.top/lightly_overview.png)

## 🐢Podcasts & Videos

1. [Indie Hackers: Hard to Make Money as an Indie Developer? You Need the Right Build Strategy](https://www.xiaoyuzhoufm.com/episode/647456af6752b5f9de6bd99c)

Explored the **build in public** strategy most commonly used by indie developers overseas. I resonated with this episode a lot and plan to share some of this week's data, the creative process of the weekly, my personal knowledge input, and creative system soon.

2. [Beyond the Code: Leaving Microsoft, Life Is About Experience? The Meaning of Reading, Active and Passive Life](https://www.xiaoyuzhoufm.com/episode/646af4a66752b5f9dec561c6)

This is a newly launched casual talk show podcast for programmers. The topics are casual, but there are often touching segments. The first episode is shared here, and it has been updated to the third episode. The guest of the third episode is Evan You, the author of Vue!

3. [Changelog #526: Git with your friends](https://changelog.com/podcast/526) (English)

This podcast talks about some Git tools, such as Git-Heat-Map, Git-Sim, git-bug, GitUI, etc. Since two of the tools are written in Python, they also talk about the topic of installing Python dependencies. Brett Cannon wrote a [blog post in response](https://snarky.ca/in-response-to-the-changelog-526/) to the hosts' incorrect usage, mainly introducing pipx, .pyz files, and the proper use of system package managers.

4. [#418: How to Keep a Secret in Python Apps](https://talkpython.fm/episodes/show/418/how-to-keep-a-secret-in-python-apps) (English)

This episode of "Talk Python To Me" explores how to handle sensitive information that your application needs to use, and also talks about password management solutions for everyday personal use. Coincidentally, I also saw an article this week called "[2023-21: My 1Password Key Management Practices](https://xuanwo.io/reports/2023-21/)", which gives a systematic introduction to password management, SSH/Shell integration, CI/CD applications, and more.

5. [Andrew Ng's Three New Generative AI Courses](https://www.deeplearning.ai/short-courses/?continueFlag=40c2724537472cbb3553ce1582e0db80) (in English)

Build systems with OpenAI's ChatGPT API, develop LLM applications with LangChain, and learn how diffusion models work.

6. [Three MIT courses on Python](https://twitter.com/python_spaces/status/1663976856578822144)

Free MIT courses: Introduction to Computer Science and Programming in Python, Classical Machine Learning, Deep Learning.

## 🐼Subscribe Welcome

- [Blog](https://pythoncat.top): Explore my independent blog where you can find a collection of original/translated technical articles over the years, along with some reflections since 2009.
- [Newsletter](https://pythoncat.substack.com/s/python-trending-weekly): Subscribe to my channel on Substack for a curated newsletter delivered straight to your inbox, keeping you updated on current affairs.
- [Github](https://github.com/chinesehuazhou/python-weekly): Access the Markdown source files of this weekly digest on Github and feel free to use them for anything you have in mind!
- [Telegram](https://t.me/pythontrendingweekly): Beyond notifications for the weekly digest, I consider it an "extra edition," providing additional, more diverse information.
- [Twitter](https://twitter.com/chinesehuazhou): Follow me on Twitter where my feed is filled with numerous accounts of developers and organizations in the Python community.