# Python Trending Weekly #4 (2023-05-31)

Welcome to the Python Trending Weekly, a weekly newsletter about Python, AI and general programming techniques, with the majority links in English and a small portion in Chinese. 

The [original version](https://pythoncat.top/posts/2023-05-31-weekly) of the weekly  was written in Chinese. What you are reading here is mostly translated by LLMs. 

**Substack Channel** : [Click to subscribe](https://pythoncat.substack.com/s/python-trending-weekly) 

## 🦄Articles & Tutorials

1. [Three Talks on the C API](https://pyfound.blogspot.com/2023/05/the-python-language-summit-2023-three.html)

These are three talks about the C API. First, Mark Shannon and Guido van Rossum mentioned that the current C API is not friendly to third-party extensions, often breaking their functionality when upgrading versions. The conclusion of the talk is to collect a list of problems with the C API and then work out a solution.

Another talk was about HPy, a new API for writing Python extension modules. It aims to address some of the limitations and problems of the CPython C API. One of its advantages is that the extension modules written with it can run on different Python implementations, such as CPython and PyPy. However, the speaker's idea of having it officially recommended was not supported, partly because it is not mature enough and more importantly because, as Guido commented, the top-down approach does not work. HPy seems to be a pretty good solution to overcome the problems with the C API, but it is too early to say if it will replace the C API.

2. [Making the Global Interpreter Lock Optional](https://pyfound.blogspot.com/2023/05/the-python-language-summit-2023-making.html)

We have introduced the nogil project many times, such as an article shared in the second issue of the weekly. At this summit, Sam Gross, the author of nogil, introduced the progress made in the past year, provided satisfactory data on the performance of nogil, and also proposed a clearer roadmap. What everyone is most worried about is still the problem of compiling it into two distributions and the resulting debugging difficulties. (We discussed it in an [article](https://mp.weixin.qq.com/s/HHSjv0ZlAjq0ZvLHMI-W9g) in February)

3. [Towards Native Profiling for Python](https://pyfound.blogspot.com/2023/05/the-python-language-summit-2023-towards.html)

Joannah Nanjekye's talk introduced Scalene, a sampling-based Python profiler that can differentiate machine code from Python code in the report. Python extensions written in C, C++, or Rust are compiled to machine code, making them difficult to profile through sampling. Scalene solves some technical challenges and is among the most popular profiling tools for Python. The speaker tentatively proposed integrating Scalene's achievements into the standard library `cProfile` but received no response. Finally, the library was also compared to the `perf` profiler introduced in Python 3.12.

![Sample-based Profiling](https://img.pythoncat.top/Nanjekye%20slide%20screenshot.png)

4. [What is the stdlib for?](https://pyfound.blogspot.com/2023/05/the-python-language-summit-2023-what-is.html)

The question posed by Brett Cannon was essentially: What role should the standard library play? In the early days of Python, the language prided itself on being "batteries included," with an extensive standard library. However, with the rise of third-party libraries and the ease of installing them via PyPI, many of the standard library modules are no longer as valuable. The consensus among the summit attendees was that the standard library should focus on helping users write better Python code. This means that the ongoing "stdlib slimming" efforts will continue, while new additions to the standard library in the future will be more judiciously considered.

5. [Pattern Matching, \_\_match\_\_, and View Patterns](https://pyfound.blogspot.com/2023/05/the-python-language-summit-2023-pattern.html)

Pattern matching syntax was a major feature in 3.10, but Sullivan argued that its capabilities are rather limited and thus proposed further directions for pattern matching. Attendees widely agreed that the pattern matching syntax should be enhanced, however, there is no consensus on whether a new magic method \_\_match\_\_ should be introduced or if another approach should be taken. The article includes many code samples and references on pattern matching, readers who are interested in this topic can check it out.

6. [Python on Mobile: State of the Union](https://pyfound.blogspot.com/2023/05/the-python-language-summit-2023-python.html)

Russell Keith-Magee introduced BeeWare, which aims to make it easy to run Python on mobile platforms such as Android and iOS. The project is backed by Anaconda, and the speaker appealed for "Tier-3" support from CPython. The talk covered support for CI test suites on mobile platforms, what value sys.platform should have on mobile, and how CPython binary artifacts should be published for mobile platforms. Python on mobile is something to watch!

7. [Burnout is Real](https://pyfound.blogspot.com/2023/05/the-python-language-summit-2023-burnout.html)

At the summit, Guido talked about open source burnout, strategies for dealing with burnout, and how to avoid burnout. In many cases, open source contributors work for the love of it. However, large open source projects often involve complex scenarios, trivial discussions, diverse interpersonal collaborations, and frequently conflicting viewpoints or ideas, all of which can easily lead to fatigue and burnout. (P.S. If you follow tech news, you will have seen the recent uproar in the Rust community over a core developer feud. The development of open source communities is a major challenge. Fortunately, this summit reflects that the Python community is developing healthily.)

![](https://img.pythoncat.top/2023-05-31.png)

8. [Lightning Talks](https://pyfound.blogspot.com/2023/05/the-python-language-summit-2023.html)

Three short lightning talks were presented, on the topics of: Let's support LLVM-BOLT as an official feature, Mechanism for implementing lazy import in Python, and Making modules callable (PEP-713 has been proposed).

These were all very interesting topics that were discussed at the summit this year.

Quite a few of these have already seen some progress (the event did happen a month ago after all), while some will likely take a longer time to land (looking at you, nogil and Python on phones).

As a bonus, here are two articles about the progress of the Fast CPython project: [Faster CPython at PyCon, part one](https://lwn.net/Articles/930705) 、[Faster CPython at PyCon, part two](https://lwn.net/Articles/931197/). Python 3.11 has already seen quite a few performance improvements, and future versions promise even more.

🎁 Python Trending Weekly 🎁 organizes its content into seasons, with every 30 issues forming a season. The highlights from the first season have been compiled for your convenience. You can access them online [here](https://pythoncat.top/posts/2023-12-11-weekly) (Chinese).

## 🐼Subscribe Welcome

- [Blog](https://pythoncat.top): Explore my independent blog where you can find a collection of original/translated technical articles over the years, along with some reflections since 2009.
- [Newsletter](https://pythoncat.substack.com/s/python-trending-weekly): Subscribe to my channel on Substack for a curated newsletter delivered straight to your inbox, keeping you updated on current affairs.
- [Github](https://github.com/chinesehuazhou/python-weekly): Access the Markdown source files of this weekly digest on Github and feel free to use them for anything you have in mind!
- [Telegram](https://t.me/pythontrendingweekly): Beyond notifications for the weekly digest, I consider it an "extra edition," providing additional, more diverse information.
- [Twitter](https://twitter.com/chinesehuazhou): Follow me on Twitter where my feed is filled with numerous accounts of developers and organizations in the Python community.