# Python Trending Weekly #3 (2023-05-27)

Welcome to the Python Trending Weekly, a weekly newsletter about Python, AI and general programming techniques, with the majority links in English and a small portion in Chinese. 

The [original version](https://pythoncat.top/posts/2023-05-27-weekly) of the weekly  was written in Chinese. What you are reading here is mostly translated by LLMs. 

**Substack Channel** : [Click to subscribe](https://pythoncat.substack.com/s/python-trending-weekly) 

## 🦄Articles & Tutorials

1. [Mastering Key Concepts of Object-Oriented Programming in Python: Classes and Objects](https://segmentfault.com/a/1190000043822529)

Introduces the concepts of classes and objects, demonstrating how classes and objects work in Python with examples, including defining, instantiating, and inheriting. This article is part of the "Python Panorama" series, which has been updated to seven articles so far.

2. [umongo + motor: The Best Combination for Building High-Performance MongoDB Applications](https://juejin.cn/post/7232977661207085117)

This article introduces how to integrate umongo and motor in Tornado to interact with MongoDB in an asynchronous and non-blocking manner. It is part of the "Tornado Concurrent Programming Series", which currently has six articles.

3. [Build a ChatGPT PDF Knowledge Base with LangChain](https://juejin.cn/post/7234821431804002365)

This article demonstrates how to build a local PDF knowledge base using LangChain and ChatGPT. It uses pdfplumber to process PDF files and streamlit to draw the UI interface. The workflow of building and using the knowledge base is shown in the following figure:

![Knowledge Base Workflow](https://img.pythoncat.top/2023-05-27_langchain.png)

4. [Does Python Really Execute Bytecode with a Switch?](https://laike9m.com/blog/python-zhen-de-shi-kao-yi-ge-switch-lai-zhi-xing-zi-jie-ma-de-ma,138)

A common belief is that CPython has a big **switch** that jumps to different case branches to execute bytecode based on different opcodes. This article questions that and concludes that bytecode execution doesn't rely on a switch as long as Python is built with computed goto (like on Mac and Linux), which has been the default since Python 3.2.

5. [SQLite's Renaissance](https://www.bmpi.dev/dev/renaissance-sqlite)

The opening of the article shocked me: "The SQLite source code is 150k lines, yet its tests and scripts are 90 million lines"! The article introduces SQLite's architecture and several open-source projects based on it, such as Litefs, sql.js, absurd-sql, postlite, sqlite3vfshttp, etc. It answers why SQLite has so many innovative projects in so many fields.

6. [Eighty Lines of Code to Implement the Open-Source Midjourney and Stable Diffusion “Spell” Drawing Tool](https://soulteary.com/2023/04/05/eighty-lines-of-code-to-implement-the-open-source-midjourney-and-stable-diffusion-spell-drawing-tool.html#Currently-in-Preview)

With Docker and about 80 lines of Python code, a Prompt tool similar to Midjourney's official image parsing feature Describe is implemented. Two versions of the tool are provided, supporting CPU and GPU inference.

7. [Writing Python Like It's Rust](https://kobzol.github.io/rust/python/2023/05/20/writing-python-like-its-rust.html) (English)

The article shares some programming habits learned from Rust: using type hints, using data classes instead of tuples or dictionaries, using algebraic data types, using "newtype", using constructors, using mutexes, etc. In general, these are not "personal preference" programming styles, but programming experiences that can actually improve the robustness and maintainability of the code.

8. [A Series of Flask Tips](https://www.patricksoftwareblog.com/flask_tips.html)

The Flask Tips column has shared 58 tips for using Flask. In his latest post, [My Favorite Python Packages for Flask](https://www.patricksoftwareblog.com/my_favorite_python_packages_for_flask.html), the author introduces 10 commonly used libraries, including APIFairy, Frozen-Flask, and Flask-SQLAlchemy.

9. [Many Problems with Celery](https://steve.dignam.xyz/2023/05/20/many-problems-with-celery/)

Celery is a distributed task queue library for asynchronous processing and scheduling of tasks. However, it has a number of "gotchas" that can trip up users. This article lists 15 of them, serving as a guide to avoid potential pitfalls. Unfortunately, not all issues have solutions. For example, its API is not very Pythonic and it lacks type checking. In these cases, users must "live with it".

10. [Using Golang Packages in Python with Gopy](https://last9.io/blog/using-golang-package-in-python-using-gopy/)

The author faced a need for statically validating PromQL queries, but there was no Python library available. This article demonstrates how to use Gopy to compile Go code into a wheel file. It also highlights several considerations, such as error handling, OS compatibility issues, and debugging and testing challenges.

[Image of Workflow of using Go packages in Python]

11. [Best File Format for Pandas](https://pythonspeed.com/articles/best-file-format-for-pandas/)

Before using Pandas, data needs to be loaded. It supports a wide variety of data formats, but which one is the most suitable? This article provides three criteria for evaluation (type support, disk format, and read/write speed) and tests three data file types (CSV, JSON, and Parquet). What do you think the conclusion is?

12. A Series of PyPI News/Articles

PyPI launched its official blog in March and recently announced a $144k sponsorship from AWS in early May to fund a new security engineer position. Coincidentally, this week has seen a flurry of security-related developments.

- On May 21, after a week of being plagued by malware, PyPI [temporarily suspended](https://status.python.org/incidents/qy2t9mjjcc7g) new user registrations and project uploads. [An article](https://programmingeeksclub.com/pypi-security-threats-implications-python-community) mentioned a related news story, suggesting that the malware may have taken advantage of the ChatGPT hype to hijack cryptocurrency transactions by stealing clipboard content.
- On May 23, PyPI [announced the removal of PGP signatures](https://blog.pypi.org/posts/2023-05-23-removing-pgp/) because only 36% of signatures uploaded in the past three years were valid. Removing this feature will help reduce maintenance costs. [An article](https://blog.yossarian.net/2023/05/21/PGP-signatures-on-PyPI-worse-than-useless) analyzed the poor state of PGP on PyPI with extensive data and graphs.
- On May 24, PyPI published [a blog post](https://blog.pypi.org/posts/2023-05-24-pypi-was-subpoenaed) disclosing that the PSF had received three subpoenas from the US Department of Justice requesting PyPI user data. Following legal advice, they provided the data requested by the DOJ and have made the subpoena details public.
- On May 25, PyPI released [Securing PyPI Accounts with Two-Factor Authentication](https://blog.pypi.org/posts/2023-05-25-securing-pypi-with-2fa), announcing that all accounts on PyPI will be required to enable two-factor authentication (2FA) by the end of 2023 to improve account security.
- On May 26, PyPI published [Reducing Stored IP Data on PyPI](https://blog.pypi.org/posts/2023-05-26-reducing-stored-ip-data), detailing the team's efforts to avoid storing user IP addresses, aiming to both protect user privacy and facilitate better operational management.

🎁 Python Trending Weekly 🎁 organizes its content into seasons, with every 30 issues forming a season. The highlights from the first season have been compiled for your convenience. You can access them online [here](https://pythoncat.top/posts/2023-12-11-weekly) (Chinese).

## 🐿️Projects & Resources

1. [CyberWaifu: A Chatbot with LLM and TTS](https://github.com/Syan-Lin/CyberWaifu)

The LLM framework uses LangChain, and the QQ bot deployment uses go-cqhttp. TTS supports vits and edge-tts, and the language models support ChatGPT and Claude.

2. [FastGPT: A Knowledge Base Platform Based on OpenAI](https://github.com/c121914yu/FastGPT)

Tech Stack: NextJs + TS + ChakraUI + Mongo + Postgres. It supports private deployment and can be experienced online.

3. [Jesth: A more human-friendly data serialization format](https://github.com/pyrustic/jesth) (English)

The documentation compares this new format to TOML, YAML, and JSON and shows in detail how to use it in Python.

4. [trogon: A friendly user interface for CLI programs](https://github.com/Textualize/trogon)

Command line programs are inherently non-graphical, which can be intimidating to users. This project generates a beautiful interface that can be used to edit and run commands.

![A friendly user interface](https://img.pythoncat.top/2023-05-27_cli.png)

5. [ipyflow: a reactive Python kernel for Jupyter notebooks](https://github.com/ipyflow/ipyflow) (English)

It allows tracking dataflow relationships between symbols and cells during interactive sessions. Features include: showing execution hints, supporting reactive execution, syntax extensions, integration with ipywidgets, and more.

6. [solara: A pure-Python, React-like framework](https://github.com/widgetti/solara)

solara lets you create ipywidget-based applications with Reacton (a pure Python implementation of React). It can be used in a Jupyter Notebook or as a standalone web application in frameworks like FastAPI.

7. [Python 3.12.0b1 Released](https://pythoninsider.blogspot.com/2023/05/python-3120-beta-1-released.html)

The final version of 3.12 is scheduled to be released on October 2. Currently, the beta 1 version has been released, which means no new features will be added. Overall, this version is more concise (many functions, classes, and methods have been removed), and there are many optimizations in terms of performance. It is worth mentioning that although this version introduces PEP-684 (an independent GIL for each sub-interpreter), it will not be truly usable until PEP-554 (multiple interpreters in the standard library) is implemented in version 3.13.

8. [Comparing Programming Idioms in Python and Rust](https://programming-idioms.org/cheatsheet/Python/Rust)

This is an interesting website that compares the differences in over 300 idioms across different programming languages, which can help you learn more efficiently. Here we compare Python and Rust, and there are 30 languages available to choose from on the website's homepage.

![Comparison of Idioms in Python and Rust](https://img.pythoncat.top/2023-05-27_idioms.png)

## 🐢Podcasts & Videos

1. [Introduction to Programming with Python](https://www.edx.org/course/cs50s-introduction-to-programming-with-python) (English)

An introductory course to computer science and programming fundamentals, as well as how to program in Python, from Harvard University's computer science department. Currently, 500,000 people have participated in the course.

2. [10 Best Django Plugins Recommended](https://pybit.es/articles/django-plugin-recommendations-by-antonio-mele-top-10-picks-for-web-development/) (English)

In this video, the author of the book *Django by Example* recommends 10 Django plugins, such as Django Debug Toolbar, Django REST Framework, Django Channels, and so on.

## 🥂Discussion & Questions

1. [Windows to Finally Support tar, 7-zip, rar, gz, and More?](https://tech.slashdot.org/story/23/05/23/1940217/28-years-later-windows-finally-supports-rar-files)

According to an anonymous tip, Windows is set to gain support for rar and other formats by leveraging the open-source project libarchive. Can this be true?

2. [The Best Language for Building APIs — TS/JS vs. Python](https://www.reddit.com/r/Python/comments/13nfyir/best_language_for_building_apis_tsjs_vs_py/)

Which of these two languages offers a better API development experience in terms of maintainability, elegance, flexibility, and development speed?

## 🐼Subscribe Welcome

- [Blog](https://pythoncat.top): Explore my independent blog where you can find a collection of original/translated technical articles over the years, along with some reflections since 2009.
- [Newsletter](https://pythoncat.substack.com/s/python-trending-weekly): Subscribe to my channel on Substack for a curated newsletter delivered straight to your inbox, keeping you updated on current affairs.
- [Github](https://github.com/chinesehuazhou/python-weekly): Access the Markdown source files of this weekly digest on Github and feel free to use them for anything you have in mind!
- [Telegram](https://t.me/pythontrendingweekly): Beyond notifications for the weekly digest, I consider it an "extra edition," providing additional, more diverse information.
- [Twitter](https://twitter.com/chinesehuazhou): Follow me on Twitter where my feed is filled with numerous accounts of developers and organizations in the Python community.