# Python Trending Weekly #2 (2023-05-20)

Welcome to the Python Trending Weekly, a weekly newsletter about Python, AI and general programming techniques, with the majority links in English and a small portion in Chinese. 

The [original version](https://pythoncat.top/posts/2023-05-20-weekly) of the weekly  was written in Chinese. What you are reading here is mostly translated by LLMs. 

**Substack Channel** : [Click to subscribe](https://pythoncat.substack.com/s/python-trending-weekly) 

## 🦄Articles & Tutorials

1. [Functional Programming with Python Decorators](http://coolshell.cn/articles/11265.html)

This article introduces the implementation principles of decorators, parameterized decorators, multiple decorators, class decorators, and several typical examples. The article was published in 2014, and the code used is still Python 2. The reason for sharing this article is that it is the only article on the topic of Python written by [haoel](https://coolshell.cn/haoel), and it is written in great detail.

2. [Some Advanced Usages of asyncio](https://www.cnblogs.com/traditional/p/17403428.html)

From our old friend @**古明地觉**'s new series, *asyncio Series*, which has been serialized 14 times in half a month. I really want to ask him how he manages to be so productive and high-quality at the same time?! The article answers: how to design an API that can receive both coroutines and regular Python functions, how to force the event loop to iterate, how to pass state between tasks without passing parameters...

3. [Nginx+uWSGI Deploy Django and Load Balancing Operation](https://segmentfault.com/a/1190000043790186)

This article introduces the configuration of uWSGI and Nginx to implement reverse proxy and load balancing for Django services. It is part of the ongoing "Django Series", which currently consists of 44 articles and can be used as a reference material for systematic learning of Django.

4. [Rye: An Experimental Python Package Manager](http://vra.github.io/2023/05/17/rye-intro/)

Python currently has a plethora of package managers, and there are many issues with Conda and the package managers of the operating systems (two articles in the first issue of this weekly are related to this). Armin Ronacher, the author of Flask, has developed rye in Rust, drawing on the experience of Rust package management, in an attempt to provide a standardized solution. This article introduces the installation and usage of rye.

5. [PyInstaller: Package Your Python Code into a Standalone Application](https://juejin.cn/post/7232571353123487802)

PyInstaller can package Python programs into a single executable file, and it supports multiple platforms including Windows, Mac, and Linux. This is a simple and clear tutorial. In addition to the basic introduction, it also introduces the advantages and disadvantages of two packaging methods and five common problems after packaging, which is rare.

6. [How to Achieve True Multithreading in Python](https://martinheinz.dev/blog/97) (English)

Python 3.12 is about to introduce the "Per-Interpreter GIL (PEP-684)" feature, which will allow Python to achieve true parallelism. While the code is already in the alpha stage, it is currently only accessible via the C-API. The article demonstrates an example of subinterpreters using CPython's `test` module.

7. [GIL vs. nogil: Boost I/O Performance 10x With One-Line Change](https://www.backblaze.com/blog/python-gil-vs-nogil-boost-i-o-performance-10x-with-one-line-change/) (English)

The [nogil project](https://pythoncat.top/posts/2021-11-14-GIL) is another attempt to achieve true multi-threading. This article tests and finds that CPython 3.9-nogil is 2.5x and 10x faster than unmodified CPython 3.9 in single-file and multi-file cases, respectively. The latest progress of the nogil project is the formation of a formal PEP-703, which is [here](https://pythoncat.top/posts/2023-02-20-GIL).

![](https://img.pythoncat.top/2023-05-18_gil.png)

8. [How to Create a Passphrase Generator in PyCharm?](https://blog.jetbrains.com/pycharm/2023/05/create-passphrase-generator-in-pycharm/) (in English)

This tutorial from PyCharm official blog guides you to create a project, import packages, build a CLI app with Typer library, run and debug the code, create and edit run configurations in PyCharm, which is suitable for beginners to practice. Also, [PyCharm 2023.1.2](https://blog.jetbrains.com/pycharm/2023/05/pycharm-2023-1-2-is-out) has just been released, go and try it out!

9. [Python Metaclass Tutorial with Examples](https://coderslegacy.com/python-metaclass-tutorial/)

In Python, everything is an object, including **classes**. Metaclasses are a powerful feature in Python that allow you to create classes dynamically at runtime (in essence, creating a `type` object). The article explores the basics of metaclasses, along with more advanced features and examples.

10. [What Happens When You Open a Terminal and Enter "ls"?](https://www.warp.dev/blog/what-happens-when-you-open-a-terminal-and-enter-ls)

There's a common interview question: "What happens when you type google.com into a browser?" It's become so common that everyone has an answer or two, but what about something we use all the time: the terminal? What happens when you type a command into the terminal? This article covers the history of the terminal, the startup process, and how commands are parsed and executed.

🎁 Python Trending Weekly 🎁 organizes its content into seasons, with every 30 issues forming a season. The highlights from the first season have been compiled for your convenience. You can access them online [here](https://pythoncat.top/posts/2023-12-11-weekly) (Chinese).

## 🐿️Projects & Resources

1. [WingetUI: A Better Package Manager UI](https://github.com/marticliment/WingetUI) (English)

This project aims to create an intuitive GUI for the most popular CLI package managers in Win 10-11, such as Winget, Scoop, and Chocolatey. It supports features like installing, updating, and uninstalling packages, queuing installations, notifications, dark mode, importing/exporting, and more.

2. [pandas-ai: Pandas with AI capabilities](https://github.com/gventuri/pandas-ai) (English)

Pandas is arguably the most popular data analysis and manipulation tool out there, so what if we could use it with the power of generative AI? Well, it seems we can! The pandasai project allows you to interact with Pandas data objects using natural language, simplifying many common Pandas operations.

3. [promptulate: A Powerful LLM Prompt Layer Framework](https://github.com/Undertone0809/promptulate)

A LLM Prompt Layer framework specifically designed for Prompt Engineers, supporting continuous dialogue, role presets, dialogue storage, tool extensions, and more. It can be used out of the box without a proxy. With promptulate, you can easily build your own GPT applications.

4. [MicroPython: Python for microcontrollers and embedded systems](https://github.com/micropython/micropython/releases/tag/v1.20.0) (English)

MicroPython has a new release, version 1.20, which introduces a new lightweight package manager, reduces code size, and adds support for many new boards. Also, [this article](https://lwn.net/Articles/931051) from LWN covers the release and mentions the possibility of Anaconda replacing the Pyodide runtime with MicroPython for PyScript in Q2.

5. [DB-GPT: A Database-backed GPT Experiment](https://github.com/csunny/DB-GPT)

Interact with large-scale GPT models locally, on your own data and in your own environment, with zero data leakage risk, 100% privacy, and 100% security.  The large model runtime environment is built on FastChat, and provides a foundation large language model as vicuna, and provides private knowledge base question answering capabilities through LangChain, and supports plug-in mode, natively supporting the Auto-GPT plug-in in the design.

![](https://img.pythoncat.top/DB-GPT.png)

## 🐢Podcasts & Videos

1. [Ep 40. Rust and PyO3: Make Python Great Again](https://pythonhunter.org/episodes/ep40)

The long-awaited return of the "Snake Charmer" podcast! The guest of this episode is the maintainer of the PyO3 project, who is also the author of wechatpy. The Rust and PyO3 projects can amplify the advantages of Python and transform the application ecosystem of Python. We have recommended the fastest code analysis tool [Ruff](https://pythoncat.top/posts/2023-04-09-ruff), and the new package management tool [rye](https://github.com/mitsuhiko/rye) developed by the author of Flask, which are both products of the combination of Rust and Python. (Aside: I saw the three anchors of the Snake Charmer post on Twitter/Weibo to mourn Zuo Er Duo Hao Zi, I didn't expect him to have so many connections with the Python circle. R.I.P)

2. [Talk Python to Me #415: Future of Pydantic and FastAPI](https://talkpython.fm/episodes/show/415/future-of-pydantic-and-fastapi) (English)

Pydantic 2.0 rewrote its core and top-level code in Rust, which will have a positive impact on libraries built on top of it, such as FastAPI. The podcast interviews Samuel Colvin of Pydantic and Sebastián Ramírez of FastAPI, so it's very topical!

3. [Revisit Fluent Python with Author Luciano Ramalho](https://www.thoughtworks.com/insights/podcasts/technology-podcasts/fluent-python-revisited)

Last month, I recommended the newly released second edition of Fluent Python in Chinese (link). Here are two additional relevant resources. This podcast from ThoughtWorks is an interview conducted before the release of the second edition of Fluent Python, covering topics such as Python's evolution, comparisons with other languages, and changes in the new book. Additionally, they recorded [an episode on "The Future of Python"](https://www.thoughtworks.com/insights/podcasts/technology-podcasts/future-python) in 2020 while the new book was being written. Full transcripts are available for both podcasts.

4. [7 Most Common Distributed System Patterns](https://youtu.be/nH4qjmP2KEE) (English)

A short and educational video that introduces 7 common distributed system patterns: Ambassador, Circuit Breaker, CQRS, Event Sourcing, Leader Election, Publisher/Subscriber, and Sharding. The animations and graphics in the video are very intuitive and engaging, making it a pleasure to watch.

![](https://img.pythoncat.top/2023-05-20_pattern.png)

## 🥂Discussion & Questions

1. [What apps, hardware, or services improve your life/work experience as a programmer?](https://www.v2ex.com/t/940584)

A post on V2ex, people seem to be very talkative about this topic. The apps I would like to recommend the most are Feedly and Substack, used to read RSS and newsletters. Feedly helps a lot in collecting materials for this weekly! (Wish: With readers' rewards, I can use the AI function of Feedly Pro+!)

2. [Should rye exist?](https://github.com/mitsuhiko/rye/discussions/6) (English)

We mentioned rye earlier, so why did mitsuhiko create it? What problems did he want to solve, and what kind of tool did he want to build? What will be the official Python support for package management? This question on Github has caused a wide discussion.

3. [How did you start your career as a programmer?](https://www.v2ex.com/t/940195)

A V2ex thread where the original poster shared his story from studying to the first few years of employment, and many people shared their experiences in the comments. How did you start your journey as a programmer?

## 🐼Subscribe Welcome

- [Blog](https://pythoncat.top): Explore my independent blog where you can find a collection of original/translated technical articles over the years, along with some reflections since 2009.
- [Newsletter](https://pythoncat.substack.com/s/python-trending-weekly): Subscribe to my channel on Substack for a curated newsletter delivered straight to your inbox, keeping you updated on current affairs.
- [Github](https://github.com/chinesehuazhou/python-weekly): Access the Markdown source files of this weekly digest on Github and feel free to use them for anything you have in mind!
- [Telegram](https://t.me/pythontrendingweekly): Beyond notifications for the weekly digest, I consider it an "extra edition," providing additional, more diverse information.
- [Twitter](https://twitter.com/chinesehuazhou): Follow me on Twitter where my feed is filled with numerous accounts of developers and organizations in the Python community.