# Python Trending Weekly #1 (2023-05-13)

Welcome to the Python Trending Weekly, a weekly newsletter about Python, AI and general programming techniques, with the majority links in English and a small portion in Chinese. 

The [original version](https://pythoncat.top/posts/2023-05-13-weekly) of the weekly  was written in Chinese. What you are reading here is mostly translated by LLMs. 

**Substack Channel** : [Click to subscribe](https://pythoncat.substack.com/s/python-trending-weekly) 

## 🦄Articles & Tutorials

1. [Error Handling Patterns in Programming Languages](https://pythoncat.top/posts/2023-05-08-error)

This article discusses four common ways of handling errors in programming: returning error codes (C, Go), exceptions (Java, C#, Python, C++), callback functions (JavaScript), and result objects (Haskell, Rust, Kotlin). Each approach is analyzed, with their advantages and disadvantages, and things to keep in mind when using them.

2. [A Deep Dive into the Python Virtual Machine: The Implementation Principle of Descriptors and Source Code Analysis](https://github.com/Chang-LeHung/dive-into-cpython/blob/master/obsy/03decriptor.md)

This article introduces the implementation principle of descriptors, analyzes the bytecode instructions related to descriptors in the CPython source code, and uses Python code to explain the execution logic of descriptors. The article is from the "A Deep Dive into the Python Virtual Machine" series on Github, which already contains 20+ articles.

3. [AI Sun Yanzi Model Application Practice](https://v3u.cn/a_id_310)

Recently, AI Sun Yanzi has become very popular! Based on Python3.10 and open-source libraries such as so-vits-svc (an expressive voice synthesis model), Spleeter (separation of vocals and accompaniment), and FFMPEG (merging of voice and accompaniment), this article demonstrates step-by-step how to make AI Sun Yanzi sing songs. (P.S. Due to concerns about copyright infringement risks, the so-vits-svc project has been archived.)

4. [Write a Python Package in C](https://juejin.cn/post/7229485914219642941)

The article introduces the C language API related features of Python and finally implements a C extension module that imitates the official `datetime`. The article comes from the first article of the `Python C Language API Series Tutorial`, which has been updated with two articles so far.

5. [Python Toolbox Series of Articles](https://www.cnblogs.com/shanxihualu/p/17391082.html)

This is a series of articles, which currently contains 31 articles. The latest introduced tools are related to databases: Neo4j (a NoSQL graph database, operated with Py2neo), PostgreSQL (a relational database, operated with Psycopg2), MongoDB, Access, ClickHouse, Redis, etc.

6. [PEP-713: Callable Modules](https://peps.python.org/pep-0713) (English)

A new proposal by Łukasz Langa to allow defining a \_\_call\_\_ object in a module's global namespace to make the module directly callable, where the \_\_call\_\_ object can be a standard function or any callable object. The proposal is currently in draft status and has not been accepted.

7. [“Externally managed environments”: When PEP-668 Affects pip](https://pythonspeed.com/articles/externally-managed-environment-pep-668)

You may encounter the “externally managed environment” error when using pip install on a newer Linux system. The reason: Linux distributions pre-install certain Python packages, and pip install may cause conflicts with system packages. Solutions: Use virtual environments for development; Don’t use system Python in Docker; Use pipx if you need the latest tools. Python package management is painful and unlikely to improve anytime soon.

8. [Bevy v2.0: A Dependency Injection Framework for Python](https://blog.zech.codes/bevy-v2) (English)

Bevy v2.0 is a powerful dependency injection framework that helps simplify the management of Python applications. The article introduces three methods to resolve dependencies: global variables, parameter passing, and dependency injection. Bevy v2.0 employs techniques including parameter injection, property injection, repositories, and dependency constructor.

🎁 Python Trending Weekly 🎁 organizes its content into seasons, with every 30 issues forming a season. The highlights from the first season have been compiled for your convenience. You can access them online [here](https://pythoncat.top/posts/2023-12-11-weekly) (Chinese).

## 🐿️Projects & Resources

1. [Digital Life Server](https://github.com/zixiiu/Digital_Life_Server)

A Python project of a "living" voice assistant, which supports communication with the front end, speech recognition, chatGPT access, and voice synthesis. The front end can render character animation, record and play audio.

2. [A Simple and Easy-to-Use Voice Conversion (Vocoder) Framework Based on VITS](https://github.com/RVC-Project/Retrieval-based-Voice-Conversion-WebUI)

Features: Eliminate voice leakage by using top1 retrieval to replace input source features with training set features; fast training speed even on relatively poor graphics cards; achieves good results even when trained on a small amount of data (recommended to collect at least 10 minutes of low-noise speech data); timbre can be changed via model fusion (with the ckpt-merge option in the ckpt handling tab); simple and easy-to-use web interface; can call the UVR5 model to quickly separate vocals and accompaniment.

3. [Ebook Translator (Calibre Plugin)](https://github.com/bookfere/Ebook-Translator-Calibre-Plugin)

A Calibre plugin that can translate an ebook into a specified language (original text and translated text are in parallel). It supports multiple translation engines, including Google Translate, ChatGPT, and DeepL. It supports all ebook formats supported by Calibre (48 input formats, 20 output formats). It supports batch translation, supports cache resume, and provides a lot of custom settings.

4. [Cross-platform, Ultra-lightweight Embedded Python Engine](https://github.com/pikasTech/PikaPython/blob/master/README_zh.md)

A completely rewritten, ultra-lightweight Python engine, zero-dependency, zero-configuration, can run on platforms with Flash ≤ 64KB, RAM ≤ 4KB, easy to deploy and expand, with a large number of Chinese documentation and video materials.

## 🐢Podcasts & Videos

1. [Indie Hacker: Big Factory Programmers Build "Small Businesses", More Calmly Responding to Layoff Wave](https://www.xiaoyuzhoufm.com/episode/6446499294d78eb3f74a01d8)

"Every hacker, every developer, every programmer, deserves to have a small business of their own". This podcast has released several episodes on the topic of independent developers, which will inspire us as programmers in terms of technology, products, and entrepreneurship.

2. [Talk Python To Me #414: A Stroll Down Startup Lane](https://talkpython.fm/episodes/show/414/a-stroll-down-startup-lane) (English)

At PyCon in April, there was a dedicated area for showcasing new Python startups called Startup Row. This episode is a recording of 5-10 minute chats with the founders of those companies, and is available in both podcast and video formats.

3. [PythonBytes #335: Should You Get Your Mojo On?](https://pythonbytes.fm/episodes/show/335/should-you-get-your-mojo-on) (English)

Mojo is a new AI programming language from the creator of LLVM and Swift that claims to be 35,000 times faster than Python. Mojo supports many of Python’s core features, including async/await, error handling, variable-length arguments, and more, but it’s still very early-stage and lacks a number of features, like classes!

4. [ChatGPT Prompts for Engineers | How to Write Prompts that Work - Andrew Ng](https://www.bilibili.com/video/BV14M4y147yH) (in English)

Andrew Ng, in partnership with OpenAI, has launched a ChatGPT prompts course for developers. This is the link on Bilibili, with bilingual subtitles.

## 🥂Discussion & Questions

1. [How to Learn Python Systematically?](https://www.zhihu.com/question/29138020)

A popular question on Zhihu, which has attracted 74k followers and 1200+ answers.

2. [[Rant] Why Conda Sucks! How to Manage Python Environments Gracefully?](https://www.v2ex.com/t/938669#reply88)

A V2EX post complaining about encountering various issues when using Conda, including not being able to find commands after installation, dependency installation getting stuck, and affecting system updates.

3. [Allow comprehension syntax in loop header of for loop](https://discuss.python.org/t/allow-comprehension-syntax-in-loop-header-of-for-loop/25864) (English)

This post proposes an idea: to allow Python's for loop to support the comprehension syntax "for i in x if i % 2 == 0:".

## 🐼Subscribe Welcome

- [Blog](https://pythoncat.top): Explore my independent blog where you can find a collection of original/translated technical articles over the years, along with some reflections since 2009.
- [Newsletter](https://pythoncat.substack.com/s/python-trending-weekly): Subscribe to my channel on Substack for a curated newsletter delivered straight to your inbox, keeping you updated on current affairs.
- [Github](https://github.com/chinesehuazhou/python-weekly): Access the Markdown source files of this weekly digest on Github and feel free to use them for anything you have in mind!
- [Telegram](https://t.me/pythontrendingweekly): Beyond notifications for the weekly digest, I consider it an "extra edition," providing additional, more diverse information.
- [Twitter](https://twitter.com/chinesehuazhou): Follow me on Twitter where my feed is filled with numerous accounts of developers and organizations in the Python community.