![](https://img.pythoncat.top/python-weekly-season-cover-1.png)



## 序言

这是一个信息过载的时代，也是一个信息匮乏的时代。

关于 Python，它是常年高居编程语言排行榜的最流行语言，在国外发展得如火如荼，开发者、项目、文章、播客等相关信息如海如潮，但是形成鲜明对比的是，它在国内的就业形势一片黯淡，开发者数量与知识社区常年都是萎靡不振（除了培训机构的广告满天飞）。

国内 Python 社区与西方主流社区存在着巨大的信息差，为了弥补这一信息差距，我创办了“**Python潮流周刊**”。这是一个专为国内 Python 开发者量身打造的资讯平台，为你挑选最值得分享的文章、教程、开源项目、软件工具、播客和视频、热门话题等丰富内容。

人们常说，阅读的内容将塑造你成为什么样的人。但问题是怎样才能接触到最优质的阅读材料呢？与其碰运气般被动等待信息流的推荐，不如订阅一个靠谱的信息源。

**我希望周刊能成为你高质量的信息筛选器，成为你开阔视野的一扇明窗。**

我们的目标是打破知识信息差，为国内的 Python 社区注入活力，愿景是帮助所有读者精进 Python 技术，拓宽职业发展道路。

周刊创办初期是免费开源的，首发于[个人博客](https://pythoncat.top)和 [Github](https://github.com/chinesehuazhou/python-weekly) 上，从第 47 期开始转为付费模式，如果你想了解付费专栏，想知道为什么我会转为付费专栏，欢迎阅读[这篇博文](https://pythoncat.top/posts/2024-05-06-information-gap) 。

周刊的长期目标依然是免费公开，现在的计划是付费期数在其第 50 期后免费，例如收费专栏的第 50 期将在第 100 期时全文免费公开。

周刊每 30 期作为一季，我觉得这是一个很有意义的时间节点，不太短也不漫长，很适合作一个小小的总结。

你现在看到的正是《**Python潮流周刊·第1季**》，包含第 1 ~ 30 期的精华内容。

关于第 1 季，首先给大家公开一些数据吧（统计于第 1 季完结时）。

本季时间从 2023.05.13 到 2023.12.09，共 **210 天**。曾有 1 期是加更，以及停更过 2 周，没想到时间正正好就是 7*30=210 天，太巧了！

本季周刊共分享了：

- 文章/教程：414 篇
- 项目/资源：306 个
- 播客/视频：59 则（有不少是视频列表）
- 热门讨论：19 个
- 赠书：5 本

![](./img/python-weekly-season-1-pie.png)

![](./img/python-weekly-season-1-bar.png)

实际的数目远不止这些，因为周刊在分享时会提及一些相关材料和补充附录，这些内容也很多，早期周刊统计时包含它们，但后来都不纳入计数了。

我在多个平台上发布了周刊，阅读量更加不好统计，因此这里只公布公众号里的数据吧：**公众号共获得 6.9 万阅读，去除最高和最低后，平均阅读量为 2100。**

**总共获得 840+ 赞同数，130+ 在看数。平均每篇点赞数接近 30，这数据在技术号里我感觉挺可以自豪的！**

阅读量排名前十的分别是：

![](./img/2023-12-09_top10.png)

公众号里是在文章最底部才可以点赞，因此点赞数可以很好体现读者对内容的赞许程度。点赞比例（点赞数/阅读量）最高的前十期是：

![](./img/2023-12-11_reads.png)

另外比较有参考意义的是博客里的阅读量，大致能看到的数据在 1000-2000 之间。

第 1 季周刊是完全免费的，曾得到过很多小伙伴的赞赏，我仔细计算了来自周刊的微信赞赏金额共有 **879.74 元**！

非常感谢小伙伴们的鼎力支持，你们的心意我都收下了！ 

另外，我还非常开心的是破天荒收到了 2 笔美元的赞赏，很有纪念意义：

![值得纪念的美元赞赏](./img/2023-12-09_buymecoffe.png)

为了方便老读者们回看及检索，也为了方便新关注的读者从第一季内容中寻宝，我把全部 30 期周刊的正文汇总成了[一篇博客](https://pythoncat.top/posts/2023-12-11-weekly)，共 **6.2 万字**！

在第 1 季完结时，我曾制作了一份 PDF 版本。现在，第 2 季周刊马上要完结了，我抽空将第 1 季内容重新整理，制作成了你正在阅读的这本电子书。

将来，这本小册子很有可能还会继续更新，如果你想获取最新版本，请在公众号“**Python猫**”里发送“**W30**”，获取下载链接（有 PDF、Epub 和 Markdown 版本）。

![Python猫公众号](./img/python_cat.jpg)

最后，如果你喜欢本周刊，欢迎付费订阅支持！

付费订阅入口，目前只支持三种方式：

1、[小报童](https://xiaobot.net/p/python_weekly) （需要使用微信登录，可微信和邮箱接收更新）

2、[爱发电](https://afdian.com/a/python_weekly) （支持邮箱登录）

3、[FlowUs](https://flowus.cn/pythoncat/share/1e0b2dc6-fc44-4be9-895b-d87795299b77?code=MX4369) （支持手机号、邮箱和微信登录）



----豌豆花下猫，写于 2024.07.07

PS. 2024.07.21前订阅我的小报童专栏，请先领取[一张优惠券](https://xiaobot.net/coupon/363a23b8-9acc-4a75-aa73-bd6bbd4a572d) ，可享八折优惠。

## 1 如何系统地自学Python？ 

[博客原文](https://pythoncat.top/posts/2023-05-13-weekly1) | 发布时间：2023-05-13

### 🦄文章&教程

1、[编程语言的错误处理模式](https://pythoncat.top/posts/2023-05-08-error)

文章讨论了编程中处理错误的四种常见方法：返回错误代码（C、Go）、异常（Java、C＃、Python、C++）、回调函数（JavaScript）和 Result 对象（Haskell、Rust、Kotlin）。对每种方法进行了分析，介绍了它们的优缺点以及使用时需要注意的地方。

2、[深入理解 Python 虚拟机：描述器实现原理与源码分析](https://github.com/Chang-LeHung/dive-into-cpython/blob/master/obsy/03decriptor.md)

文章介绍了描述器的实现原理，分析了 CPython 源码中描述器相关的字节码指令，并使用 Python 代码解释了描述器的执行逻辑。文章出自 Github 上的《深入理解 Python 虚拟机系列》，该系列已含 20+ 文章。

3、[人工智能 AI 孙燕姿模型应用实践](https://v3u.cn/a_id_310)

最近 AI 孙燕姿太火了！文章基于 Python3.10 和开源库 so-vits-svc（高表现力的语音合成模型）、Spleeter（人声和伴奏分离）和 FFMPEG（声音与伴奏合并），手把手演示了让 AI 孙燕姿演唱歌曲。（PS.由于担心侵权风险，so-vits-svc 项目已经归档了）

4、[用 C 语言写一个 Python 包](https://juejin.cn/post/7229485914219642941)

文章介绍了 Python 的 C 语言 API 相关特性，最后实现了一个模仿官方 `datetime` 的 C 扩展模块。文章出自《Python 之 C 语言 API 系列教程》的第一篇，该系列目前已更新两篇。

5、[Python 工具箱系列文章](https://www.cnblogs.com/shanxihualu/p/17391082.html)

这是一个系列文章，目前包含 31 篇文章，最近介绍的几个工具是数据库相关的：Neo4j（一个 NoSQL 图数据库，使用 Py2neo 操作）、PostgreSQL（一个关系型数据库，使用 Psycopg2 操作）、MongoDB、Access、ClickHouse、Redis 等。

6、[PEP-713：可调用的模块](https://peps.python.org/pep-0713)（英文）

Łukasz Langa 发起的新提案，提议支持在模块的全局命名空间中定义一个\_\_call\_\_对象以使模块可直接调用，\_\_call\_\_对象可以是一个标准函数或任意可调用对象。提案目前是草稿状态，未采纳。

7、[“Externally managed environments”：当 PEP-668 影响了 pip](https://pythonspeed.com/articles/externally-managed-environment-pep-668)（英文）

在较新 Linux 系统上使用 pip install 时可能遇到“externally managed environment”错误。原因：Linux 发行版已预装某些 Python 包，pip install 可能导致系统包冲突。解决方法：开发时用虚拟环境；Docker 里不用系统 Python；需最新工具时用 pipx。Python 包管理较为痛苦，短时间内难以改善。

8、[Bevy v2.0：Python 的依赖注入框架](https://blog.zech.codes/bevy-v2)（英文）

Bevy v2.0 是一个强大的依赖注入框架，可以帮助简化 Python 应用程序的管理。文章介绍了三种解决依赖关系的方法：全局变量、参数传递和依赖注入。Bevy v2.0 使用的方法包括参数注入、属性注入、仓库和依赖构造函数等。

### 🐿️项目&资源

最近几个月，乘着人工智能的东风，Github 上天天都被 AI 相关的项目屠榜，相信读者们已经从各种渠道看到过那些知名的以 Python 为主的开源项目了。因此，为了不撞车，本周刊主要收录一些小而美的项目。本期以中文开发者的项目为主。

1、[「数字生命」的服务端](https://github.com/zixiiu/Digital_Life_Server)

一个“有生命的”语音助手 Python 项目，支持与前端通信、语音识别、chatGPT 接入和语音合成。前端部分可渲染人物动画、录音和播放声音。

2、[一个基于VITS的简单易用的语音转换（变声器）框架](https://github.com/RVC-Project/Retrieval-based-Voice-Conversion-WebUI)

具有以下特点：使用 top1 检索替换输入源特征为训练集特征来杜绝音色泄漏；即便在相对较差的显卡上也能快速训练；使用少量数据进行训练也能得到较好结果（推荐至少收集 10 分钟低底噪语音数据）；可以通过模型融合来改变音色（借助 ckpt 处理选项卡中的 ckpt-merge）；简单易用的网页界面；可调用 UVR5 模型来快速分离人声和伴奏。

3、[电子书翻译器（Calibre 插件）](https://github.com/bookfere/Ebook-Translator-Calibre-Plugin)

一个可以将电子书翻译成指定语言（原文译文对照）的 Calibre 插件。支持多种翻译引擎，包括 Google 翻译、ChatGPT 以及 DeepL。支持所有 Calibre 所支持的电子书格式（输入格式 48 种，输出格式 20 种）。支持批量翻译、支持缓存续译、提供大量自定义设置。

4、[跨平台的超轻量级嵌入式 Python 引擎](https://github.com/pikasTech/PikaPython/blob/master/README_zh.md)

一个完全重写的超轻量级 Python 引擎，零依赖，零配置，可以在 Flash ≤ 64KB，RAM≤ 4KB 的平台下运行，极易部署和扩展，具有大量的中文文档和视频资料。

### 🐢播客&视频

1、[硬地骇客：大厂程序员构建 “小生意”，更加从容应对裁员潮](https://www.xiaoyuzhoufm.com/episode/6446499294d78eb3f74a01d8)

"每一位 hacker，每一位开发者，每一位程序员，都值得拥有一个属于自己的小生意”。这档播客已发布了几期关于独立开发者的话题，对作为程序员的我们，在技术、产品、创业等方面会有所启发。

2、[Talk Python To Me #414：漫步创业之路](https://talkpython.fm/episodes/show/414/a-stroll-down-startup-lane)（英文）

在 4 月的 PyCon 上，有一个专门展示新型 Python 创业公司的展台，叫做 Startup Row。在这期节目中，主播与这些公司的创始人分别聊了 5-10 分钟，这期节目同时包含了播客和视频。

3、[PythonBytes #335：应该开始用 mojo 了么？](https://pythonbytes.fm/episodes/show/335/should-you-get-your-mojo-on)（英文）

Mojo 是 LLVM 及 Swift 之父新开发的 AI 编程语言，号称比 Python 快 35000 倍。Mojo 已支持 Python 的许多核心特性，包括 async/await、错误处理、可变参数等等，但是它仍然处于早期阶段，缺少许多功能，比如还不支持类！

4、[ChatGPT提示工程师｜AI大神吴恩达教你写提示词](https://www.bilibili.com/video/BV14M4y147yH)（英文）

鼎鼎大名的吴恩达联合 OpenAI，推出了一个面向开发者的 ChatGPT 提示词课程。这是 B 站上的链接，配有双语字幕。

### 🥂讨论&问题

1、[如何系统地自学Python？](https://www.zhihu.com/question/29138020)

知乎上的一个热门问题，已有 7.4 万人关注和 1200+ 回答。

2、[[吐槽] conda 真是太难用了！ 如何优雅地管理 Python 环境？](https://www.v2ex.com/t/938669#reply88)

v2ex 上的一个帖子，吐槽使用 Conda 遇到了各种问题，包括安装后找不到命令、安装依赖卡住不动、影响系统更新等等。

3、[允许在 for 循环的循环头中使用推导式语法](https://discuss.python.org/t/allow-comprehension-syntax-in-loop-header-of-for-loop/25864)（英文）

这个帖子提出了一个想法：让 Python 的 for 循环支持推导式语法“for i in x if i % 2 == 0:”。

## 2 Rust 让 Python 再次伟大 

[博客原文](https://pythoncat.top/posts/2023-05-20-weekly2) | 发布时间：2023-05-20

### 🦄文章&教程

1、[Python修饰器的函数式编程](http://coolshell.cn/articles/11265.html)

介绍了装饰器的实现原理、带参装饰器、多装饰器、类装饰器和几个典型的示例。文章发布于 2014 年，代码用的还是 Python 2。之所以分享这篇文章，因为它是[左耳朵耗子](https://coolshell.cn/haoel)唯一以 Python 为话题的文章，而且写得详细到位。

2、[asyncio 的一些高级用法](https://www.cnblogs.com/traditional/p/17403428.html)

出自我们的老朋友@**古明地觉** 的新系列《asyncio 系列》，半个月内已连载 14 篇。真想问问他是如何做到如此高产又高质量的？！文章回答了：如何设计既能接收协程又能接收普通 Python 函数的 API，如何强制事件循环的迭代，如何在不传递参数的情况下在任务之间传递状态……

3、[Nginx+uWSGI 部署 Django 以及负载均衡操作](https://segmentfault.com/a/1190000043790186)

介绍了 uWSGI 和 Nginx 的配置，实现对 Django 服务的反向代理及负载均衡。该文出自仍在连载的《Django 系列》，目前该系列包含 44 篇文章，能作为系统学习 Django 的参考材料。

4、[Rye:一个实验性质的Python包管理系统](http://vra.github.io/2023/05/17/rye-intro/)

Python 目前的包管理工具多得让人眼花缭乱，而 Conda 和操作系统的包管理器也存在诸多问题（本周刊第一期就有两则相关内容）。Flask 作者 Armin Ronacher 用 Rust 开发的 rye，借鉴了 Rust 包管理的经验，试图提供一个标准化的解决方案。这篇文章介绍了 rye 的安装及使用。

5、[PyInstaller：将你的Python代码打包成独立应用程序](https://juejin.cn/post/7232571353123487802)

PyInstaller 可将 Python 程序打包为一个可执行文件，支持多个平台如 Windows、Mac 和 Linux。这是一篇简单清晰的使用教程，除了基础介绍外，难得的是它还介绍了两种打包方式的优缺点，以及打包后常见的 5 个问题。

6、[如何在 Python 中实现真正的多线程](https://martinheinz.dev/blog/97)（英文）

Python 3.12 即将推出“Per-Interpreter GIL（PEP-684）”特性，它允许 Python 实现真正的并行处理。代码虽然已在 alpha 版本中，但目前只能通过 C-API 使用。文章使用 CPython 的`test` 模块演示了子解释器的示例。

7、[GIL vs. nogil: 改动一行代码，提升十倍 I/O 性能](https://www.backblaze.com/blog/python-gil-vs-nogil-boost-i-o-performance-10x-with-one-line-change/)（英文）

[nogil 项目](https://pythoncat.top/posts/2021-11-14-GIL)是另一个试图实现真正多线程的方案，这篇文章测试发现 CPython 3.9-nogil 在单文件和多文件的情况下，比未修改的 CPython 3.9 分别快 2.5 倍和 10 倍。nogil 项目最新的进展是形成了正式的 PEP-703，相关介绍[在此](https://pythoncat.top/posts/2023-02-20-GIL)。

![](./img/2023-05-18_gil.png)

8、[如何在 PyCharm 中创建一个密码生成器？](https://blog.jetbrains.com/pycharm/2023/05/create-passphrase-generator-in-pycharm/)（英文）

PyCharm 官方推出的文章教程，指导在 PyCharm 中创建项目、导入包、使用 Typer 库创建 CLI 应用、运行和调试代码、创建和编辑运行配置，适合于新人学习练手。另外，[PyCharm 2023.1.2](https://blog.jetbrains.com/pycharm/2023/05/pycharm-2023-1-2-is-out) 版本刚刚发布，可以去尝鲜！

9、[Python 元类教程（带示例）](https://coderslegacy.com/python-metaclass-tutorial/)（英文）

在 Python 中，一切都是对象，包括**类**。元类是 Python 的一项强大功能，允许你在运行时动态地创建类（实际是创建一个`type` 类型的对象）。文章探讨元类的基础知识，以及更高级的功能和示例。

10、[当在终端输入“ls”后会发生什么？](https://www.warp.dev/blog/what-happens-when-you-open-a-terminal-and-enter-ls)（英文）

有一道很常见的面试题：“当在浏览器输入 google.com 后会发生什么？”由于见得多了，每个人都能回答个一二，但是，经常跟终端打交道的我们，能否回答这个问题呢：当在终端输入命令后会发生什么？文章主要介绍了终端的历史、启动过程、命令的解析和执行过程。

### 🐿️项目&资源

1、[WingetUI：更好用的包管理器 UI](https://github.com/marticliment/WingetUI)（英文）

该项目的目标是为 Win 10-11 中最常见的 CLI 包管理器（如 Winget、Scoop 和 Chocolatey）创建一个直观的 GUI。已支持软件包的安装、更新和卸载、排队安装、消息通知、黑暗模式、导入/导出等功能。

2、[pandas-ai：支持 AI 功能的 Pandas](https://github.com/gventuri/pandas-ai)（英文）

Pandas 无疑是目前最流行的数据分析和处理工具，当它结合了生成式 AI 的能力后，会不会更好用呢？答案似乎是的！pandasai 项目支持用文字的方式操作 Pandas 的数据对象，可简化很多 Pandas 库的操作。

3、[promptulate：一个强大的 LLM Prompt Layer 框架](https://github.com/Undertone0809/promptulate)

一个专为 Prompt Engineer 设计的 LLM Prompt Layer 框架，支持连续对话、角色预设、对话存储、工具扩展等功能，可以无需代理直接访问，开箱即用。 通过 promptulate，你可以轻松构建起属于自己的 GPT 应用程序。

4、[MicroPython：面向微控制器和嵌入式系统的 Python](https://github.com/micropython/micropython/releases/tag/v1.20.0)（英文）

MicroPython 新发布了 1.20 版本，引入了一个新的轻量级包管理器，减小了代码大小，并增加了对许多新板的支持。另外，LWN 的[这篇文章](https://lwn.net/Articles/931051)对此版本做了介绍，文章还提到 Anaconda 有可能在 Q2 将 PyScript 的运行时从 Pyodide 替换为 MicroPython。

5、[DB-GPT：以数据库为基础的 GPT 实验项目](https://github.com/csunny/DB-GPT)

使用本地化的 GPT 大模型与你的数据和环境交互，无数据泄露风险，100% 私密，100% 安全。基于 FastChat 构建大模型运行环境，并提供 vicuna 作为基础的大语言模型，通过 LangChain 提供私域知识库问答能力，支持插件模式，在设计上原生支持 Auto-GPT 插件。

![](./img/DB-GPT.png)

### 🐢播客&视频

1、[Ep 40. Rust 和 PyO3：让 Python 再次伟大](https://pythonhunter.org/episodes/ep40)

断更许久的《捕蛇者说》播客回归了！本期的嘉宾是 PyO3 项目的维护者，他的另一个身份是 wechatpy 的作者。Rust 和 PyO3 项目能放大 Python 的优势，并能改造 Python 的应用生态。我们曾推荐过性能最快的代码分析工具 [Ruff](https://pythoncat.top/posts/2023-04-09-ruff)，另外 Flask 作者新开发的包管理工具 [rye](https://github.com/mitsuhiko/rye)，它们都是 Rust 与 Python 结合的产物。（题外话：看到了捕蛇者说的三位主播发推/发博缅怀左耳朵耗子，想不到他对 Python 圈子有这么多渊源。R.I.P）

2、[Talk Python to Me #415: Future of Pydantic and FastAPI](https://talkpython.fm/episodes/show/415/future-of-pydantic-and-fastapi)（英文）

Pydantic 2.0 使用 Rust 重写了核心及顶层的代码，将对构建在其之上的库产生积极的影响，比如 FastAPI。播客邀请了 Pydantic 的 Samuel Colvin 以及 FastAPI 的 Sebastián Ramírez 一起采访，话题度很新！

3、[再访《流畅的 Python》作者 Luciano Ramalho](https://www.thoughtworks.com/insights/podcasts/technology-podcasts/fluent-python-revisited)（英文）

我在上个月推荐过新上市的《流畅的 Python》中文第二版（[链接](https://pythoncat.top/posts/2023-04-28-fluent)），这里补充两则相关材料。这期播客来自 thoughtworks，是在《Fluent Python》英文第二版上市前的访谈，介绍了关于 Python 发展、不同语言的对比、新书的变化等。另外，他们还在 2020 年新书写作期间录了[一期“The future of Python”](https://www.thoughtworks.com/insights/podcasts/technology-podcasts/future-python)，两期播客都有完整的文字稿。

4、[最常用的七种分布式系统模式](https://youtu.be/nH4qjmP2KEE)（英文）

一则简短的科普视频，介绍了七种分布式系统模式：Ambassador、Circuit Breaker、CQRS、Event Sourcing、Leader Election、Publisher/Subscriber、Sharding。视频中的动画和图例都非常直观和舒适，让人赏心悦目。

![](./img/2023-05-20_pattern.png)

### 🥂讨论&问题

1、[作为程序员，有什么提升生活/工作体验的 App、硬件、服务？](https://www.v2ex.com/t/940584)

V2ex 上的一个帖子，大家对这样的话题似乎很有发言欲。我在此最想推荐的 APP 是 Feedly 和 Substack，用于阅读 RSS 和 Newsletter。Feedly 对本周刊的素材采集帮助极大！（心愿：依靠读者的打赏，让我用上 Feedly Pro+ 的 AI 功能！）

2、[rye 应该存在么？](https://github.com/mitsuhiko/rye/discussions/6)（英文）

前文已提到过 rye，那么，mitsuhiko 是出于什么考虑而开发了它呢？它想解决什么样的问题，想打造出一款什么样的工具呢？Python 官方对包管理会有什么发展支持呢？Github 上的这个问题引起了广泛的讨论。

3、[你是怎样开始程序员职业生涯的？](https://www.v2ex.com/t/940195)

V2ex 上的帖子，楼主分享了自己从读书到就业前几年的故事，评论区有不少人分享了自己的经历。你是如何开始自己的程序员之路的呢？

## 3 PyPI 的安全问题 

[博客原文](https://pythoncat.top/posts/2023-05-27-weekly3) | 发布时间：2023-05-27

### 🦄文章&教程


1、[掌握Python面向对象编程的关键：类与对象](https://segmentfault.com/a/1190000043822529)

介绍类和对象概念，通过示例展示 Python 中的类和对象如何工作，包括定义、实例化和继承等。文章出自《Python全景系列》，目前已更新七篇。

2、[umongo + motor: 构建高效 MongoDB 应用的最佳组合](https://juejin.cn/post/7232977661207085117)

介绍如何在 Tornado 中集成 umongo 和 motor，实现用异步非阻塞的方式与 MongoDB 进行交互。文章出自《tornado 并发编程系列》，目前已更新六篇。

3、[徒手使用 LangChain 搭建一个 ChatGPT PDF 知识库](https://juejin.cn/post/7234821431804002365)

演示了如何使用 langchain 和 ChatGPT 搭建一个本地的 PDF 知识库，文中使用了 pdfplumber 处理 PDF 文件、使用 streamlit 绘制 UI 界面。知识库搭建和使用流程图如下：

![知识库的工作流](./img/2023-05-27_langchain.png)

4、[Python 真的是靠一个 switch 来执行字节码的吗？](https://laike9m.com/blog/python-zhen-de-shi-kao-yi-ge-switch-lai-zhi-xing-zi-jie-ma-de-ma,138)

一个流行的观点说：CPython 有一个大**switch**，会根据不同的 opcode 跳到相应的 case 分支去执行字节码。文章提出了质疑，最后的结论是：只要 Python 启用了 computed goto （比如在 Mac 和 Linux 上），字节码的执行就不依赖 switch。而这个功能在 Python 3.2 中就已是默认开启的。

5、[SQLite 的文艺复兴](https://www.bmpi.dev/dev/renaissance-sqlite)

文章的开头把我震惊了：“SQLite 源码有 15 多万行，但测试代码和脚本竟有九千多万行”！文章介绍了 SQLite 的架构，以及多个基于它的开源项目，如 Litefs、sql.js、absurd-sql、postlite、sqlite3vfshttp 等等，回答了为什么 SQLite 能在如此多领域有创新的项目出现？

6、[八十行代码实现开源的 Midjourney、Stable Diffusion “咒语”作图工具](https://soulteary.com/2023/04/05/eighty-lines-of-code-to-implement-the-open-source-midjourney-and-stable-diffusion-spell-drawing-tool.html#%E5%86%99%E5%9C%A8%E5%89%8D%E9%9D%A2)

通过 Docker 和 80 行左右的 Python 代码，实现一款类似 Midjourney 官方图片解析功能 Describe 的 Prompt 工具。提供了两个版本的工具，分别支持 CPU 和 GPU 推理使用。

7、[像写 Rust 一样写 Python](https://kobzol.github.io/rust/python/2023/05/20/writing-python-like-its-rust.html)（英文）

分享了从 Rust 中学到的一些编程习惯：使用类型提示、使用数据类代替元组或字典、使用代数数据类型、使用“newtype”、使用构造函数、使用互斥锁等。总体而言，它们并不是那些“个人喜好式”的编程风格，而是切实能提升代码健壮性和可维护性的编程经验。

8、[一系列的 Flask 小贴士](https://www.patricksoftwareblog.com/flask_tips.html)（英文）

这个《Flask Tips》栏目已分享了 58 个使用 Flask 的小知识，另外其作者在最新的博文《[我开发 Flask 程序时最喜欢用的库](https://www.patricksoftwareblog.com/my_favorite_python_packages_for_flask.html)》中，介绍了 APIFairy、Frozen-Flask、Flask-SQLAlchemy 等 10 个常用的库。

9、[Celery 的诸多问题](https://steve.dignam.xyz/2023/05/20/many-problems-with-celery/)（英文）

Celery 是一个分布式任务队列库，用于实现异步处理和定时任务等功能。但它有很多“问题”，这篇文章一口气列出了 15 个，是一份避坑指南。不过，并非所有问题都有解决方案，比如说它 API 接口不够 Pythonic、没有类型检查等，这些就只能“Live with it”了……

10、[Python 借助 Gopy 库实现调用 Go 包](https://last9.io/blog/using-golang-package-in-python-using-gopy/)（英文）

作者遇到一个静态验证 PromQL 查询的需求，但没有可用的 Python 库。文章介绍了使用  Gopy 将 Go 代码编译成 wheel 文件的方法，另外也提醒几个注意事项，比如对错误的处理、操作系统的兼容性问题、调试和测试的问题。

![在Python中使用Go包的流程](./img/2023-05-27_gopy.png)

11、[最适用于 Pandas 的文件格式](https://pythonspeed.com/articles/best-file-format-for-pandas/)（英文）

使用 Pandas 前需要加载数据，它支持非常多种数据格式，但哪种才最合适呢？文中给出了三个衡量标准（类型支持、磁盘格式、读写速率），并测试了三种数据文件（CSV、JSON 和 Parquet），你猜最后的结论是什么呢？

12、关于 PyPI 的一系列新闻/文章（英文）

PyPI 在 3 月上线了官方博客，5 月初刚宣布获得了 AWS 的 14.4 万美元赞助，用于开设一个新的安全工程师职位。巧的是本周密集出现了几件与安全相关的事情。

- 5.21，PyPI 在连续一周受到恶意软件的侵扰后，[临时暂停](https://status.python.org/incidents/qy2t9mjjcc7g)了新用户的注册及新项目的上传。（这有[一篇文章](https://programmingeeksclub.com/pypi-security-threats-implications-python-community)，提到一则有相关性的新闻，这些恶意软件可能是趁 ChatGPT 的热点，通过窃取剪贴板内容从而劫持加密货币交易）
- 5.23，PyPI [宣布移除 PGP 签名](https://blog.pypi.org/posts/2023-05-23-removing-pgp/)，因为近三年上传的签名仅有 36% 为有效的，移除这项功能有利于降低维护成本。（这有[一篇文章](https://blog.yossarian.net/2023/05/21/PGP-signatures-on-PyPI-worse-than-useless)，使用大量数据和统计图分析了 PyPI 上糟糕的 PGP 情况）
- 5.24，PyPI 发了[一篇博客](https://blog.pypi.org/posts/2023-05-24-pypi-was-subpoenaed)，披露 PSF 收到了美国司法部的三张要求提供 PyPI 用户数据的传票，在律师的建议下，他们提供了司法部索要的数据，并公开了传票的相关细节。
- 5.25，PyPI 发布《[通过双因素身份验证保护 PyPI 帐户](https://blog.pypi.org/posts/2023-05-25-securing-pypi-with-2fa)》，宣布在 2023 年底前，PyPI 上的帐户都必须启用双重验证（2FA），以此提升账户的安全性。
- 5.26，PyPI 发布《[减少 PyPI 中存储的 IP 数据](https://blog.pypi.org/posts/2023-05-26-reducing-stored-ip-data)》，介绍了团队出于不存储用户 IP 的目的而做的一些事情，试图既要保护用户的隐私，又能更好地运维管理。

### 🐿️项目&资源

1、[CyberWaifu：使用 LLM 和 TTS 实现的聊天机器人](https://github.com/Syan-Lin/CyberWaifu)

使用 LangChain 作为 LLM 主体框架，使用 go-cqhttp 进行 QQ 机器人部署，TTS 支持 vits、edge-tts，语言模型支持ChatGPT 和 Claude。

2、[FastGPT：基于 openai 搭建的知识库平台](https://github.com/c121914yu/FastGPT)

技术栈: NextJs + TS + ChakraUI + Mongo + Postgres，支持私有化部署，可以在线体验。

3、[jesth：更具可读性的数据序列化格式](https://github.com/pyrustic/jesth)（英文）

文档将这种新格式与 TOML、YAML 和 JSON 分别做了对比，并详细展示了在 Python 中的使用方法。

4、[trogon：为 CLI 程序生成友好的用户界面](https://github.com/Textualize/trogon)（英文）

命令行程序本就是无界面的，但是这对于用户来说不够友好。这个项目可以生成美观的界面，用于编辑和运行命令。

![友好的用户界面](./img/2023-05-27_cli.png)

5、[ipyflow：用于 Jupyter 笔记本的响应式 Python 内核](https://github.com/ipyflow/ipyflow)（英文）

可在交互式会话期间，跟踪符号和单元格之间的数据流关系，支持的功能：显示执行建议、支持响应式执行、语法拓展、集成了 ipywidgets，等等。

6、[solara：一个纯 python、React-风格的框架](https://github.com/widgetti/solara)（英文）

solara 可使用 Reacton（纯 Python 实现的 React）创建基于 ipywidget 的程序。可用在 Jupyter Notebook，也可以作为独立的 Web 程序在 FastAPI 等框架中使用。

7、[Python 3.12 的 beta 1 版本已发布](https://pythoninsider.blogspot.com/2023/05/python-3120-beta-1-released.html)（英文）

3.12 的最终版本计划在 10 月 2 日发布，目前发布了 beta 1 版本，意味着不会再加入新功能。总体而言，这个版本更为精简了（删除了很多函数、类和方法），性能方面也有很多优化。值得一提的是，这个版本虽然引入了 PEP-684（每个子解释器的独立 GIL），但需要等 3.13 版本实现 PEP-554（标准库中的多解释器）后，才真正的可用。

8、[对比 Python 与 Rust 的编程习惯用法](https://programming-idioms.org/cheatsheet/Python/Rust)（英文）

这是一个有意思的网站，可比较不同编程语言在 300 多项习惯用法上的区别，提升学习效率。我们这里比较了 Python 和 Rust，在网站首页可选的语言有 30 种。

![Python与Rust的惯用法对比](./img/2023-05-27_idioms.png)

### 🐢播客&视频

1、[哈佛大学的 Python 编程入门课程](https://www.edx.org/course/cs50s-introduction-to-programming-with-python)（英文）

哈佛大学计算机科学专业的入门课程，向初学者介绍计算机科学和编程基础，以及如何使用 Python 进行编程。目前已有 50 万人参与学习。

2、[推荐 10 个最好用的 Django 插件](https://pybit.es/articles/django-plugin-recommendations-by-antonio-mele-top-10-picks-for-web-development/)（英文）

这期视频中，《Django by Example》书籍的作者推荐了 10 个 Django 插件，例如 Django Debug Toolbar、Django REST Framework、Django Channels，等等。

### 🥂讨论&问题

1、[Windows 要支持 tar、7-zip、rar、gz 等格式啦？](https://tech.slashdot.org/story/23/05/23/1940217/28-years-later-windows-finally-supports-rar-files)（英文）

来自一则匿名爆料，Windows 要利用开源项目 libarchive 实现对 rar 等格式的支持了。这会是真的么？

2、[构建 API 的最佳语言——TS/JS vs. Python](https://www.reddit.com/r/Python/comments/13nfyir/best_language_for_building_apis_tsjs_vs_py/)（英文）

从可维护性、优雅性、灵活性和开发速度的角度来看，这两种语言的 API 开发体验哪种更好？

## 4 Python 2023 语言峰会 

[博客原文](https://pythoncat.top/posts/2023-05-31-weekly4) | 发布时间：2023-05-31

### 🦄文章&教程

1、[Three Talks on the C API](https://pyfound.blogspot.com/2023/05/the-python-language-summit-2023-three.html)

这是关于 C API 的三场演讲。首先，Mark Shannon 和 Guido van Rossum 提及当前 C API 对第三方扩展的支持不够，经常在升级版本时破坏它们的功能。会上的结论是收集 C API 的问题清单，再制定解决方案。

另一场演讲是关于 HPy，它是一个用于编写 Python 扩展模块的新的 API，旨在解决 CPython C API 的一些限制和问题。它的好处是编写的扩展模块可以在不同的 Python 实现中运行，例如 CPython 和 PyPy。但是，演讲者想要官方将它作为推荐方案的想法没有得到支持，一方面的原因是它还不够完善，更重要的原因则是 Guido 评论的自上而下的方法行不通。HPy 似乎是挺不错的克服 C API 问题的方案，但它要取代 C API 的地位，还为时尚早。

2、[Making the Global Interpreter Lock Optional](https://pyfound.blogspot.com/2023/05/the-python-language-summit-2023-making.html)

我们曾多次介绍过 nogil 项目，比如在周刊第二期就分享了一篇文章。在本次峰会上，nogil 的作者 Sam Gross 介绍了过去一年的进展，给出了 nogil 在性能上取得的令人满意的数据，还提出了更明确的路线图。大家最担心的依然是它提出编译成两个发行版、以及导致的调试困难等问题。（我们曾在 2 月份的[一篇文章](https://mp.weixin.qq.com/s/HHSjv0ZlAjq0ZvLHMI-W9g) 中讨论过）

3、[Towards Native Profiling for Python](https://pyfound.blogspot.com/2023/05/the-python-language-summit-2023-towards.html)

Joannah Nanjekye 的演讲介绍了 Scalene，这是一个基于采样的 Python 分析器，可以在报告中区分机器代码和 Python 代码。使用 C、C++ 或 Rust 编写的 Python 扩展会被编译为机器代码，因此很难用采样的方式分析。Scalene 解决了一些技术难题，是最受欢迎的 Python 分析工具之一。演讲者试探性提出将 Scalene 的成果集成到标准库 `cProfile` 中，但没有得到响应。最后，这个库还被拿来跟 Python 3.12 中引入的 `perf` 分析器作比对。

![Sample-based Profiling](./img/Nanjekye-slide-screenshot.png)

4、[What is the stdlib for?](https://pyfound.blogspot.com/2023/05/the-python-language-summit-2023-what-is.html) 

Brett Cannon 提出的问题实际是：标准库应该扮演什么样的角色？Python 在发展初期自诩“自带电池”，包含了很多标准库，但随着第三方库越来越丰富以及 PyPI 使得安装库非常便利，很多标准库就不再有价值了。与会者的共识是：标准库应该专注于帮助用户编写更好的 Python 代码。这意味正在进行的标准库“瘦身计划”不会停，同时，未来的新标准库会更加规范引入。

5、[Pattern Matching, \_\_match\_\_, and View Patterns](https://pyfound.blogspot.com/2023/05/the-python-language-summit-2023-pattern.html)

模式匹配语法是 3.10 版本的重大特性，但是 Sullivan 认为它的能力相当有限，因此提出了模式匹配的后续发展方向。与会者们普遍认同要增强模式匹配语法，然而，是否要引入一个新的魔术方法 \_\_match\_\_，或者采用别的方案，暂无定论。文中附有很多代码示例以及关于模式匹配的参考资料，对此话题感兴趣的同学可以去了解下。

6、[Python on Mobile: State of the Union](https://pyfound.blogspot.com/2023/05/the-python-language-summit-2023-python.html)

Russell Keith-Magee 介绍了 BeeWare，它的目标是在 Android 和 iOS 等移动平台上轻松运行 Python。项目已得到 Anaconda 的投资支持，演讲者的诉求是希望得到 CPython 的“Tier-3”支持。会上讨论了 CI 测试套对移动平台的支持、sys.platform 在移动平台应该得到什么值、以及如何在移动平台发布 CPython 二进制文件，等等。手机上的 Python，这值得期待！

7、[Burnout is Real](https://pyfound.blogspot.com/2023/05/the-python-language-summit-2023-burnout.html)

Guido 在峰会上聊了开源倦怠、解决倦怠的策略、以及如何避免倦怠等话题。很多时候，开源贡献者都是在用爱发电，然而大型开源项目还常常有复杂的场景、琐碎的讨论、多样的人际协作、时常冲突的观点或想法等，这些都容易让人疲倦、消磨人的热情。（PS.如果你关注技术新闻的话，会看到 Rust 社区最近闹得沸沸扬扬的核心开发者内讧事件。开源社区的发展也是一大难题，庆幸的是这届峰会反映出 Python 社区是在健康发展中）

![](./img/2023-05-31.png)

8、[Lightning Talks](https://pyfound.blogspot.com/2023/05/the-python-language-summit-2023.html)

介绍了三场简短的闪电演讲，主题有：让我们支持 LLVM-BOLT 作为官方功能、在 Python 中实现延迟导入的机制、让模块支持调用（已提出 PEP-713）。

以上就是今年峰会上讨论的重大议题，可以说都是非常有意义的话题。

有不少内容其实已经有了最新进展（毕竟活动已结束一个月），还有一些可能仍需较长时间才能尘埃落定（比如 nogil 和手机上的 Python）。

这里再补充两篇文章，有关于 Fast CPython 项目的进展：《[Faster CPython at PyCon, part one](https://lwn.net/Articles/930705)》、《[Faster CPython at PyCon, part two](https://lwn.net/Articles/931197/)》，Python 3.11 已经让大家看到了非常多的性能提升，未来版本更值得期待。

## 5 并发一百万个任务要用多少内存？ 

[博客原文](https://pythoncat.top/posts/2023-06-03-weekly5) | 发布时间：2023-06-03

### 🦄文章&教程

1、[并发一百万个任务要用多少内存？](https://pkolaczk.github.io/memory-consumption-of-async/)（英文）

文中测试了主流的编程语言（Rust、Go、Java、C#、Python、Node.js 和 Elixir），依次运行 1 个、1 万、10 万和 100 万个任务，统计了这些语言所消耗的内存。随着任务量增加，它们的排名出现了较大变化，让我感觉挺意外的。

![100万任务占用的内存](./img/2023-06-02-100K.png)

2、[使用这些方法让你的 Python 并发任务执行得更好](https://towardsdatascience.com/use-these-methods-to-make-your-python-concurrent-tasks-perform-better-b693b7a633e1) （英文）

使用 asyncio 有什么最佳实践呢？这篇文章介绍了 asyncio.gather、asyncio.as_completed 和 asyncio.wait API，还介绍了 Python 3.11 中引入的新 asyncio.TaskGroup 特性。（附一篇[不完整的译文](https://juejin.cn/post/7237424021768011834)）

3、原推荐文章为拼凑且非原创，已删

4、[Python 多线程编程的终极指南](https://programmingeeksclub.com/ultimate-python-multithreading-guide) （英文）

也是一篇长文，介绍了 Python 多线程编程的方方面面，真的是一份终极指南。

5、[编程语言是如何实现并发的之并发模型篇](https://www.bmpi.dev/dev/deep-in-program-language/how-to-implement-concurrency/concurrency-model/)

依然是长文，介绍了常见的并发模型及不同编程语言是如何实现的。它的姊妹篇是《[编程语言是如何实现并发的之操作系统篇](https://www.bmpi.dev/dev/deep-in-program-language/how-to-implement-concurrency/os-scheduling/)》，都是图文并茂，资料翔实。

![并发模型](./img/2023-06-02_concurrency.png)

6、[鹅厂程序员的 9 个生存法则](https://segmentfault.com/a/1190000043833549)

作者分享了自己工作多年对代码设计、架构设计和工作思维的经验，比如 DRY 原则、SOLID 原则、高可用设计、如何想尽一切办法“偷懒”，等等。（文中提到了面向对象编程的原则，这里顺便推荐另一位鹅厂程序员的《[Python工匠](https://github.com/piglei/one-python-craftsman)》系列的第 12-14 章）

7、[一览 Python 3.12！PEP 701 —— f-string 语法规范化](https://juejin.cn/post/7238274120881422392)

f-string 是 Python 最好用的特性之一，但它也有诸多限制。即将发布的 3.12 会对 f-string 作语法规范化，详情可查看 [PEP-701](https://peps.python.org/pep-0701/) 。这里分享的文章带大家直观地感受了这个改动在代码的词法解析（lexing）层面的不同。

8、[PyCharm：新用户界面的五大亮点](https://blog.jetbrains.com/pycharm/2023/05/five-things-to-love-about-the-new-ui/) （英文）

大家都用上 PyCharm 新的 UI 了么？这份官方教程介绍了新 UI 的使用方法及亮点。

9、[PEP-594 已被实现：Python 3.13 将移除 20 个标准库](https://discuss.python.org/t/pep-594-has-been-implemented-python-3-13-removes-20-stdlib-modules/27124) （英文）

Python 3.12 正式版本还要几个月才发布，这边 3.13 已经迫不及待地移除了 20 个标准库。值得一提的是，2to3 项目及 lib2to3 模块也将会被移除。

10、[Grasshopper：一个用于负载测试的开源 Python 库](https://innovation.alteryx.com/introducing-grasshopper-an-open-source-python-library-for-load-testing/) （英文）

Locust 是 Python 最主流的分布式负载测试库，而文章介绍的 [Grasshopper](https://github.com/alteryx/locust-grasshopper) 是新开源的基于 Locust 与 Pytest 的更全面的性能测试库。

![Grafana面板展示了Grasshopper和InfluxDB指标](./img/Screenshot-at-Apr-28-13-09-21.png)

11、[Python 装饰器：用包装巫术增强你的代码](https://hackthedeveloper.com/python-decorator/) （英文）

Python 装饰器是增强代码行为和灵活性的强大工具，文章内容从基础到高阶，是不错的学习材料。

12、三个练手项目的实战教程：

- [用 Python 开发 Telegram 机器人](https://swiftuser.hashnode.dev/how-to-telegram-bot-with-python) （英文）：开发 tg 机器人，教程使用 Tornado 作后端，项目部署在 Render 平台上
- [花一周末用 Python 实现 DNS](https://implement-dns.wizardzines.com/index.html) （英文）：教程指导实现一个 DNS 解析器，总代码仅约 200 行，但作者给出了很多学习材料和代码讲解，你能学到的绝对够多。另外，教程最后还有 7 个练习题，可以进一步开发 DNS 解析器的功能。（Julia Evans 是一个宝藏作者，[博客](https://jvns.ca/)、[网站](https://wizardzines.com) 、[pandas-cookbook](https://github.com/jvns/pandas-cookbook) ，等等，强烈推荐！！！）
- [用 Python 构建你自己的 Git](https://www.leshenko.net/p/ugit/) （英文）：这个项目我要给它满分！教程网站设计得独特而酷炫，从最小可行项目起步，逐渐添加代码，手把手教你实现 Git 的各种功能。每章都使用 Git 的差异比对方式，明确告诉你增删了哪些代码，良心满满，全网估计找不着第二家！

![构建自己的 Git](./img/2023-06-02_ugit.png)

### 🐿️项目&资源

1、[frogmouth：一个在终端中浏览 Markdown 的工具](https://github.com/Textualize/frogmouth) （英文）

frogmouth 可以打开本地或 URL 中的 md 文件，具有类似浏览器的导航条、历史记录、书签和目录。

2、[使用 Meta AI 的 SAM 进行图像分割的 Python GUI](https://github.com/dibrale/samist) （英文）

一个 Python 桌面程序，为 Meta 公司的 AI 模型 SAM 提供了图形界面，可以提取照片里面的物体。

3、[GirlfriendGPT：你的人工智能伴侣](https://github.com/EniasCailliau/GirlfriendGPT) （英文）

你有对象了么？这个入门项目使用 ChatGPT 构建一个 AI 伴侣， 拥有个性化的人格、声音以及自拍照！

4、[Python 进化之路.pptx](https://www.slideshare.net/Manjusaka1/python-pptx-258083055)

一份技术分享的 PPT 材料，介绍了 Python 3.7-3.11 在性能、类型体验及开发者体验方面的优化。

![Python解释器优化](./img/2023-06-02_python_road.png)

5、[soundstorm-pytorch：在 Pytorch 中实现 SoundStorm ](https://github.com/lucidrains/soundstorm-pytorch) （英文）

SoundStorm 是 Google Deepmind 新提出的一个高效的、非自回归的音频并行生成模型。soundstorm-pytorch 使用 Pytorch 实现了这个模型。

6、[asynq：Python 的异步编程库](https://github.com/quora/asynq) （英文）

 asynq 是 Quora 开发的异步编程库，专注于对外部服务的批处理请求。对于 memcache、redis 等存储服务，它发起一次请求批量获取多个 key，比发出多次请求每次获取一个 key 要快得多。

7、[Propan：功能强大且易用的 Python 异步 Web 框架](https://github.com/Lancetnik/Propan) （英文）

一个基于 pydantic、fastapi 和 pytest 的异步框架，简化了 MQ 的代码集成，并提供了一个有用的开发工具包。其特点是基于消息架构（Messaging Architecture）设计，所以它还是个声明式的 MQ 框架。

8、[talkGPT4All：基于 GPT4All 的一个语音聊天程序](https://vra.github.io/2023/05/27/talkgpt4all-2-0/)

它利用 OpenAI 的 Whisper 模型将用户输入的语音转换为文本，再调用 GPT4All 的语言模型得到回答文本，最后利用文本转语音（TTS）的程序将回答文本朗读出来。

9、[lightly：一个用于图像自监督学习的 Python 库](https://github.com/lightly-ai/lightly) （英文）

这是一个用于自我监督学习的计算机视觉框架，以类似 PyTorch 的风格编写，支持使用 PyTorch Lightning 进行分布式训练。

![相关概念的示意图](./img/lightly_overview.png)

### 🐢播客&视频

1、[硬地骇客：独立开发赚钱难？你需要正确的build策略](https://www.xiaoyuzhoufm.com/episode/647456af6752b5f9de6bd99c)

探讨了在海外独立开发者中最常用的 **build in public** 策略。我对这期节目很有共鸣，打算针对本周刊的一些数据、周刊的创作流程、个人知识输入及创作体系等话题，不久会做一些分享。

2、[代码之外：离开微软、人生在于体验？阅读的意义、主动和被动的人生](https://www.xiaoyuzhoufm.com/episode/646af4a66752b5f9dec561c6)

这是一档新上线的程序员闲聊播客节目，主题很随性，但常常有能打动人的片段。这里分享的是第一期，它目前已更新到第三期，第三期请的嘉宾是 Vue 的作者尤雨溪！

3、[Changelog #526：与你的朋友一起 Git](https://changelog.com/podcast/526) （英文）

这期播客聊了一些 Git 工具，如 Git-Heat-Map、Git-Sim、git-bug、GitUI，等等。因为有两个工具是用 Python 编写的，因此也聊了一些 Python 安装依赖包的话题。Brett Cannon 针对主播们的错误用法，写了一篇[回应博客](https://snarky.ca/in-response-to-the-changelog-526/) ，主要介绍了 pipx、.pyz 文件以及系统包管理器的正确使用。

4、[#418：如何在 Python 程序中加密保存](https://talkpython.fm/episodes/show/418/how-to-keep-a-secret-in-python-apps) （英文）

“Talk Python To Me”的这期播客探讨如何处理程序要用到的敏感信息，同时也聊到了日常个人密码的保存方案。我正巧本周还看到一篇《[2023-21: 我的 1Password 密钥管理实践](https://xuanwo.io/reports/2023-21/)》，它系统介绍了密码管理、SSH/Shell 集成和 CI/CD 应用等内容。

5、[吴恩达三门新的生成式 AI 课程](https://www.deeplearning.ai/short-courses/?continueFlag=40c2724537472cbb3553ce1582e0db80) （英文）

使用 OpenAI 的 ChatGPT API 构建系统、LangChain 用于开发 LLM 应用、Diffusion模型是如何工作的。

6、[MIT 的三门 Python 相关课程](https://twitter.com/python_spaces/status/1663976856578822144) （英文）

麻省理工学院的免费课程：Python 计算机科学和编程简介、经典机器学习、深度学习。

## 6 Python 3.12 有我贡献的代码！ 

[博客原文](https://pythoncat.top/posts/2023-06-10-weekly6) | 发布时间：2023-06-10

### 🦄文章&教程

1、[CPython 贡献日记：Python 3.12 有什么？](https://zhuanlan.zhihu.com/p/634654153) 

文章出自群友@孙孟越，介绍了 Python 3.12 中他深度参与的几个大更新，比如 PEP-701 定型 f-字符串的句法、PEP-688 给 Python Buffer Protocol 暴露 Python 接口、PEP-695 类型参数语法，等等。另外，他在前一篇《[CPython 贡献日记](https://zhuanlan.zhihu.com/p/623602662)》中介绍了给开源社区做贡献的相关知识，比如提 PR 的小技巧、提/解决 Issue 的小技巧，等等。（你也想给 Python 贡献代码么？请参考：[Python Developer’s Guide](https://devguide.python.org/)）

2、[有哪些值得关注的 AI 工具？我们整理了这 67 个](https://topbook.cc/overview?selectedArticle=1975)

文章介绍了目前流行的 67 个工具，包括大语言模型、搜索引擎、办公、内容生成、精神需求、提示词学习等方向，它还梳理了下面这张思维导图：

![67个AI工具的思维导图](./img/e758891909852b4088d3a6db47a6607ca.jpg)

3、[我买了本豆瓣 9.6 分的 Python 书，发现里面每 5 页一个错误？！](https://juejin.cn/post/7240248679515963451)

文章从一本 Python 入门书籍中找出了 30 个有代表性的错误，并给出了“离谱程度”评分。作者批判性阅读了那本书，同理，读者们也应该批判性阅读这篇文章，因为它说得也并不都对。（@TheFry 投稿）

4、[Sketch of a Post-ORM](https://borretti.me/article/sketch-post-orm) (英)

通常我们使用纯 SQL 或者 ORM 框架来操作数据库，作者比较了这两种方案，指出了它们的诸多缺陷，然后提出了一种新的技术设想。作者从 8 个方面介绍了自己的思路，包括迁移优先、声明式迁移、跨语言移植、更好的 SQL，等等。作者还演示了一个工作流以及 Python 代码示例。

5、[Python 中运行 Shell 命令的正确做法](https://martinheinz.dev/blog/98) (英)

作者先介绍了 Python 与操作系统交互的一些常用库，比如 pathlib、tempfile、shutil、os、subprocess 等等，最后再介绍了他最为推荐的 [sh](https://github.com/amoffat/sh) 库的相关用法。这个库的方法对熟悉 shell 命令的同学非常友好。

6、[如何使用 async 升级 Flask 程序](https://www.vidavolta.io/how-to-upgrade-your-flask-application-using-async/) (英)

文章使用 Locust 作负载测试，简单演示了将同步的 Flask 程序修改为异步后，性能数据上的变化。

![](./img/data-src-image-8d0d9165-c86c-4de9-8c32-6ff0a23793cb.png)

7、[提议给 Python 添加一个结构语法](https://snarky.ca/proposing-a-struct-syntax/) (英)

核心开发者 Brett Cannon 的博客介绍了他的思考，提议增加一个`struct` 关键字，用于更方便地创建数据类，类似于 C、Rust 与 Go 的结构语法。文中介绍了他的目标以及这个关键字的实现原理，目前在收集意见阶段，未来不排除会提成一个 PEP。

8、[类属性和实例属性是怎样的关系？](https://juejin.cn/post/7240380161555234876)

出自《从 1 到 ∞ 精通 Python》系列，已包含 17 篇文章。作者参考了《Python 源码剖析》的分析方法及结论，深度探析了 Python 解释器源码，讲解 Python 重要特性的实现原理。

9、[2023 年 39 个顶级 Python 框架](https://dev.to/lambdatest/39-top-python-frameworks-to-look-for-in-2023-3hdb) (英)

文章梳理介绍了 39 个用于开发及测试的 Python 框架，内容很长，介绍的范围很全面。

10、内容删除

11、[使用 Kivy 库进行 GUI 开发](https://www.pythonguis.com/tutorials/getting-started-kivy/) (英)

这是一篇入门教程。Kivy 是一个用于开发图形用户界面的库，支持桌面的跨平台开发，也支持为移动设备创建多点触控的程序。

12、[了解 CPU 有助于提升 Numba 和 NumPy 代码的速度](https://pythonspeed.com/articles/speeding-up-numba/)  (英)

当需要加快 NumPy 速度或减少其运行内存时，通常使用即时编译器 Numba。文章针对现代 CPU 的特点来优化 代码，将一个去除图像中的噪点程序的耗时从 48 ms 降到了 2 ms。

13、[当字节码咬人时：谁检查 Python 文件编译后的内容？](https://www.reversinglabs.com/blog/when-python-bytecode-bites-back-who-checks-the-contents-of-compiled-python-files) (英)

ReversingLabs 研究团队发现了一种针对 PyPI 的新型攻击，它使用编译后的 Python 代码来规避检测——可能是第一个利用 PYC 文件直接执行的攻击。

![从pyc文件中提取出的信息](./img/Who-checks-the-contents-of-compiled-python-files-Figure-9.png)

14、[GPT 是如何工作的：200 行 Python 代码实现一个极简 GPT](http://arthurchiao.art/blog/gpt-as-a-finite-state-markov-chain-zh/)

这是一篇译文，原文作者是 OpenAI 的创始成员 Andrej Karpathy。文章使用 PyTorch 实现了一个极简 GPT，让读者对其内部工作机制有个直观理解。

15、[600 行 Python 代码实现两个 Transformer（文本分类+文本生成）](http://arthurchiao.art/blog/transformers-from-scratch-zh/)

这也是一篇译文，原文作者是阿姆斯特丹自由大学的助理教授。原文最早写于 2019 年，那时大语言模型还没有如今火爆。在文章末尾，作者希望 transformer  扩展到其它领域，因为它有很强的通用性。


### 🐿️项目&资源

1、[neodb：标记你喜欢的东西](https://github.com/neodb-social/neodb)

NeoDB 是一个用 Django 写的开源项目，也是一个联邦宇宙书影音游戏标注平台，可简单理解成 Web3 的开源的无审查的豆瓣，但支持标记的内容比豆瓣多得多。（这个库是在@laike9m 的博客看到的。以及非常感谢他在 Twitter 上推荐了本周刊！！）

![](./img/2023-06-10_neodb.png)

2、[JupyterLab 4.0 已发布](https://blog.jupyter.org/jupyterlab-4-0-is-here-388d05e03442) (英)

JupyterLab 4.0 主要的新功能有：性能更快、升级的文本编辑器、新的扩展管理器、UI 改进，等等。

3、[pystack](https://github.com/bloomberg/pystack) (英)

pstack 是 Linux 系统上常用的命令行工具，用于显示一个进程的函数调用栈，可诊断进程卡死、死锁等问题，以及分析进程的性能瓶颈。pystack 是用 Python 写成的类 pstack 库。值得一提的是，它竟然还可以显示线程是否持有、是否在等待或正在释放 GIL。

4、[GPYTHON：你的专属 Python 学习助手](https://gpython.aibang.run/)

这是一个基于 ChatGPT 的 Python 在线学习平台，内置了 AI 助手以及在线代码运行模块，允许你随时修改示例代码，一键运行，一键查错。（@Stanaaa 投稿）

![](./img/2023-06-09_gpython.png)

5、[M3E 模型](https://huggingface.co/moka-ai/m3e-base) 

M3E 是一个中文开源的 Embedding 模型，使用千万级 (2200w+) 的中文句对数据集进行训练，在文本分类和文本检索的任务上都超越了 openai-ada-002 模型。（@王宇昕投稿）

6、[reactpy：Python 的 React](https://github.com/reactive-python/reactpy) (英)

ReactPy 是一个库，用于在 Python 中构建用户界面，且不使用 Javascript。它的接口类似于 ReactJS 中的组件，可供没有 Web 开发经验的人使用。

7、[domain-admin: 域名 SSL 证书监测平台](https://github.com/mouday/domain-admin)

基于 Python + Vue3.js 技术栈实现的域名和 SSL 证书监测平台，核心功能：到期自动邮件提醒。

![Domain-Admin结构图](./img/domain-admin-process.png)

8、[EasySpider：一个可视化爬虫软件](https://github.com/NaiboWang/EasySpider)

一个可视化爬虫软件，只需在网页上选择想爬的内容，并根据提示框操作即可完成爬虫设计和执行。也支持以命令行方式执行，可以方便地嵌入到其他系统中。这个项目源于原作者的浙江大学硕士论文，已获得国家发明专利，相关资料可在仓库查看。

9、[text-to-video-synthesis-colab：文本生成视频的模型](https://github.com/camenduru/text-to-video-synthesis-colab) (英)

一个开源的文本生成视频模型，整体模型参数约 17 亿，使用英文输入。放出来的演示视频非常惊艳。

![一些文生视频的效果](./img/2023-06-10_16-23-19.png)

10、[segment-geospatial：使用 SAM 分割地理空间数据](https://github.com/opengeos/segment-geospatial) (英)

SAM 即“分割任意物体模型”（Segment Anything Model），是计算机视觉领域中非常有用和先进的模型，用于需要精确识别和分割任意物体的应用场景。这个项目使用它来分割地理空间数据。

11、[traceback_with_variables：Python 回溯（错误消息）打印变量](https://github.com/andy-landy/traceback_with_variables) (英)

该项目可以在 Python 的回溯信息中添加变量。通过记录日志或打印彩色的变量上下文信息，方便调试异常的原因，并显示堆栈跟踪中每个帧的变量值。

![错误堆栈信息对比](./img/color_schemes.png)


### 🐢播客&视频

1、[当你用Python3.12的时候，或许就跑了我写的代码呢！](https://www.bilibili.com/video/BV1XX4y1y7s4)

视频来自 B 站@码农高天，他从 3 月份起，有 20 几个 pr 已合入 Python 3.12。这期视频详细介绍了他做出的几个贡献，主要有完善 pdb 文档、修复了几个 bug、引入 convenience variable 特性，等等。（作者在第一次 pr 被合入后，录了一期《[我给Python修了个bug！从今天起，也算是Python开发者了？](https://b23.tv/7zZFshm)》）

2、[PyCon US 2023 - YouTube](https://www.youtube.com/playlist?list=PL2Uw4_HvXqvY2zhJ9AMUa_Z6dtMGF3gtb) (英)

今年 PyCon US 活动的视频已经可以看了，共用 142 个视频！PyCon 是全球性的最大的 Python 开发者会议之一，由 PSF 主办，通常在 PyCon 活动期间会举行“Python 语言峰会”，今年的峰会议题详见《[Python潮流周刊#4：Python 2023 语言峰会](https://pythoncat.top/posts/2023-05-31-weekly4)》。

![PyCon US视频列表](./img/2023-06-10_pycon.png)

3、[PyCascades - 2023 视频](https://www.youtube.com/@PyCascades/videos) (英)

2023 年 PyCascades 活动上的视频在上个月发布了，有 20 几个视频。PyCascades 是一个专注于 Python 编程语言的会议，通常在北美地区举行，每年一次。它类似于 PyCon，但是由独立的组织者和志愿者自发组织，规模更小。

## 7 我讨厌用 asyncio 

[博客原文](https://pythoncat.top/posts/2023-06-17-weekly7) | 发布时间：2023-06-17

### 🦄文章&教程

1、[AsyncIO](https://charlesleifer.com/blog/asyncio) (英)

文章的作者讨厌 asyncio 库，认为使用 `async` 和 `await` 的设计十分糟糕，它与大多数库不兼容，也不满足“Python之禅”的一些标准。作者的推荐方案是 gevent，提及了它的几点好处。另外，作者还推荐了两篇相关的文章：Flask 作者 Armin Ronacher 的《[I don't understand Python's Asyncio](https://lucumr.pocoo.org/2016/10/30/i-dont-understand-asyncio)》，SQLAlchemy 作者 Mike Bayer 的《[Asynchronous Python and Databases](https://techspot.zzzeek.org/2015/02/15/asynchronous-python-and-databases/)》

2、[gevent 到底是什么？](https://eng.lyft.com/what-the-heck-is-gevent-4e87db98a8) (英)

gevent 是一个基于协程的协作式多任务 Python 框架，使用猴子补丁来协调所有代码。这篇文章是一个系列的第一篇，介绍了 gevent 的基本实现原理，第二篇是《[Gevent Correctness](https://eng.lyft.com/gevent-part-2-correctness-22e3b7998382)》，第三篇是《[Gevent Performance](https://eng.lyft.com/gevent-part-3-performance-e64303fa102b)》

3、[ReactPy 的入门教程](https://www.kdnuggets.com/2023/06/getting-started-reactpy.html) (英)

上期周刊推荐过的 ReactPy 最近很火，它支持用 Python 写 React 风格的前端应用。这里是一篇简单的入门教程。另外，建议感兴趣的同学去看[官方文档](https://reactpy.dev/docs/guides/getting-started/index.html)。

![reactpy 的 hello world 程序](./img/2023-06-16_reactpy.png)

4、[Python 业务框架循环依赖和全局上下文的一些思考](https://qin.news/python-circular-dependency-and-global-contexts)

如何简单而优雅地解决 Python 的循环依赖问题呢？作者考察了主流 API 框架（Django、Flask、FastAPI）的上下文管理方案，然后介绍了自己框架采用的方案：借鉴了 Ray 社区中对象所有权的概念，在一个协程上实现一个简易的所有权字典。

5、[Python 函数调用的实际依赖关系跟踪](https://amakelov.github.io/blog/deps) (英)

跟踪 Python 函数调用时访问的代码和数据是一种很有用的操作，比如绘制依赖图、调试和分析性能、缓存失效。这篇文章考察了一种可能的实现方式，包含了一个少于 100 行代码的最小可行实现。作者是 MIT 的计算机科学博士。

6、[Python 3.x从基础到实战 - typing类型提示](https://juejin.cn/post/7244033665209073725)

这是一篇入门教程，通过简短的示例，介绍了 Python Typing 模块的基础用法和进阶用法。

7、[wxPython 入门教程](https://www.pythonpapers.com/p/an-intro-to-wxpython) (英)

wxPython 是跨平台的图形用户界面框架，基于 wxWidgets 库开发，在 1998 年发布。它最新发展到了 4.x 版本，这篇文章基于最新的特性作了详细的入门介绍。

![wxPython 的 hello world 程序](./img/2023-06-15_wxpython.png)

8、[Python 装饰器的用法指导](https://juejin.cn/post/7241943960083546171)

一篇很认真的文章，介绍了装饰器的基本概念和进阶用法。在示例部分介绍了 Django 的几个很常用的装饰器（`@login_required`、`@permission_required`、`@csrf_exempt`、`@cache_page`）。

9、[在进程间共享 Numpy 数组的 7 种方式](https://superfastpython.com/numpy-share-array-processes) (英)

多进程编程时最麻烦的事情之一就是共享数据，这篇文章介绍了 7 种共享 Numpy 数组的方式：传递参数、使用全局变量、使用队列 Queue、使用管道 Pipe、使用基于 ctypes 的 RawArray、使用 Python 3.8 的 SharedMemory、使用多进程的管理器。这是一篇系统性的长文，里面还引用了作者的一些相关文章，十分推荐阅读。

10、[在 Python 中作时间序列分析的工具](https://www.timescale.com/blog/tools-for-working-with-time-series-analysis-in-python) (英)

时间序列数据（**Time-Series Data**）是指在不同时间点上收集的数据，这篇文章介绍了在 Python 中分析时间序列数据的工具，包括常用的 NumPy、pandas 和 Matplotlib，以及 Tsfresh、Sktime、AutoTS、Prophet、Timescale 等。

![](./img/2023-06-15_time-series.png)

11、[如何快速处理缺失的数据](https://neuronize.dev/learn-handling-missing-data-in-10-minutes) (英)

在数据分析和机器学习领域，需要尽量确保数据集的完整性和准确性，因此处理缺失值是必不可少的环节。文章先介绍了数据缺失的原因和模式（完全随机丢失 、随机丢失和不随机丢失），然后介绍了处理缺失值的常用方法：删除、填充、插补。

12、[Cython 与 CPython：对比性能差异](https://coderslegacy.com/cython-vs-cpython-comparing-speed) (英)

这篇文章用 10 个不同的基准作性能比较，涵盖了多种场景及边缘情况，包括斐波那契数列、斐波那契数列（迭代）、矩阵乘法、质数生成、字符串拼接、计算均值、计算均值（未优化）、算术运算、文件操作、线性搜索、冒泡排序。猜猜最后的结论是什么呢？

13、[使用 FastAPI 进行流式处理](https://www.vidavolta.io/streaming-with-fastapi) (英)

服务器推送事件 （**Server-Sent Events**） 是一种基于 HTTP 的单向通信协议，允许服务器向客户端实时推送数据。这篇文章解释了如何使用 FastAPI 实现流式处理 JSON 事件。文章出自“*FastAPI Pro 系列*”，另外两篇文章关于[如何使用动态配置](https://www.vidavolta.io/dynamically-configure-python-apps-fastapi)、[如何加密保护 API](https://www.vidavolta.io/fastapi-api-keys)。

![SSE 示意图](./img/2023-06-17_sse.png)

14、[20 道关于 FastAPI 中间件的面试题](https://techwasti.com/fastapi-interview-questions-on-middleware) (英)

中间件（**middleware**）是 FastAPI 中的一种机制，允许在 HTTP 请求和响应到达路由处理程序之前拦截和修改它们。文章包含 20 个与中间件、身份验证和授权相关的面试题。

15、[CPython 添加返回常量指令](https://github.com/python/cpython/issues/101632) (英)

上期周刊引发了“国内 Python 贡献者数量”的话题，@yihong0618 在推特上留言分享了 @penguin-wwy 给 CPython 提交的这个贡献。该作者发现 LOAD\_CONST + RETURN\_VALUE 高频出现在 pystats 文档中，因此提交了一个新的 **RETURN_CONST** 指令，此项贡献在 Python 3.12 基准测试中获得约 10% 的性能提升。

🎁**Python潮流周刊**🎁已免费发布了 7 期，扫描下方二维码，即可查看全部内容：

![](./img/python_weekly_banner.png)

### 🐿️项目&资源

1、[argcomplete：命令行自动补全库](https://github.com/kislyuk/argcomplete) (英)

在使用 Python 命令或者命令行工具时，一个痛点是没有补全。使用 argcomplete 后，按 tab 键就可以自动补全。它需要与 argparse 模块一起使用，目前支持 bash 和 zsh 两种 shell。

2、[Lawyer LLaMA：中文法律 LLaMA](https://github.com/AndrewZhe/lawyer-llama)

这是一个系统性学习了中国的法律知识体系的大语言模型，能够正确理解民法、刑法、行政法、诉讼法等常见领域的法律概念，可进行基础的法律咨询，涵盖婚姻、借贷、海商、刑事等。

3、[CPM-Bee：百亿参数的中英文双语基座大模型](https://github.com/OpenBMB/CPM-Bee)

这是一个完全开源、允许商用的百亿参数中英文基座模型，采用 Transformer 自回归架构，在超万亿（trillion）高质量语料上进行预训练。在中文的 Zero-CLUE 评测基准上，它大幅超越其他模型，位列中文大模型第一。

![](./img/2023-06-17-BMB.png)

4、[TigerBot：多语言多任务 LLM](https://github.com/TigerResearch/TigerBot)

也是国内团队开源的大语言模型，根据 OpenAI InstructGPT 论文在公开 NLP 数据集上的自动评测，TigerBot-7B 达到 OpenAI 同样大小模型的综合表现的 96%。

5、[BingAI-Client：突破限制的 New Bing](https://github.com/xbzstudio/BingAI-Client)

New Bing 集成了 ChatGPT，但是在国内使用的门槛有点高！这个项目的客户端基于 Angular，服务端基于 FastAPI 和 [EdgeGPT](https://github.com/acheong08/EdgeGPT)。在本地部署好后，运行服务端程序即可开始使用客户端。（另外推荐一个项目 [go-proxy-bingai](https://github.com/adams549659584/go-proxy-bingai)，是用 Vue3 和 Go 搭建的 New Bing 演示站点，国内可用，无需登录即可畅聊）

6、[tabby：可自托管的 AI 编码助手](https://github.com/TabbyML/tabby) (英)

这是 GitHub Copilot 的开源/本地替代品，无需 DBMS 或云服务，拥有 Web UI，支持消费级的 GPU。

7、[pyboke：极简博客生成器](https://github.com/ahui2016/pyboke)

一个功能极简、代码极简、自带四种主题、支持生成 RSS 的静态博客生成器。项目基于 Python 3.10，主要使用的库有 arrow、click、jinja2、mistune 等。

8、[gpt-engineer](https://github.com/AntonOsika/gpt-engineer) (英)

这是一个基于 ChatGPT4 的 AI 工程师，你只用告诉它需求，然后它会问几个问题，接着生成整个项目代码。提供出来的演示视频非常惊艳！

9、[audiocraft：音频处理和生成库](https://github.com/facebookresearch/audiocraft) (英)

这是 FaceBook 开源的一个 PyTorch 库，有最先进的 EnCodec 音频压缩器/分词器，内含文本到音乐模型 MusicGen，使用了 10K 高质量音乐曲目的内部数据集，以及 ShutterStock 和Pond5 的音乐数据。

10、[PythonGUI 教程网站](https://www.pythonguis.com) (英)

Python 中有很多开发 GUI 的库，除了前文提到的 wxPython，还有 Tkinter、PyQt、PySide、Kivy 等等。这个网站上提供了很多 GUI 相关的学习资料。

11、[CPython 实现原理](https://hai-shi.gitbook.io/cpython-internals)

这是一本用 GitBook 制作的在线电子书，翻译自微软独立研究员 Anthony Shaw 的《CPython Internals》。

![](./img/2023-06-16_cpython.png)

### 🐢播客&视频

1、[pybites：](https://pybit.es/articles/importance-of-refactoring)[定期重构的重要性](https://pybit.es/articles/importance-of-refactoring) (英)

这期播客聊了关于重构的相关话题。

2、[三个看似一样的列表，占用内存空间竟然不一样多？](https://b23.tv/cw3Ai8V)

有三个看起来完全一样的列表：[0]*3、[0,0,0]、[0 for _ in range(3)]，但是使用 sys.getsizeof() 计算的内存却完全不同。这是为什么呢？这期 B 站视频通过分析字节码和 CPython 解释器源码，非常硬核地分析出了根本原因，值得一看！

3、[asyncio的理解与入门，搞不明白协程？看这个视频就够了](https://b23.tv/2XeGXwI)

这里呼应一下本期标题及第一则内容。asyncio 依然是最主流的异步编程库，近几年也在逐渐发展成熟，很有必要深入学习。这是一则 B 站视频，适合用于入门与加深理解。

## 8 Python 3.13 计划将解释器提速 50%！ 

[博客原文](https://pythoncat.top/posts/2023-06-24-weekly) | 发布时间：2023-06-24

### 🦄文章&教程

1、[Python 3.13 版本的计划](https://github.com/faster-cpython/ideas/blob/main/3.13/README.md) (英)

Faster CPython 项目（即香农计划）有了关于 3.13 版本的最新计划，这次的性能目标是减少解释器 50% 的耗时。涵盖三项主要工作：第 2 层的优化器、启用子解释器（PEP-554）、内存管理。

2、[为什么 Numpy 并行性很重要？](https://superfastpython.com/why-numpy-parallelism/) (英)

Numpy 是作科学计算和数据分析的最重要的库之一，并行性是提升其性能的重要手段。文章介绍了 5 种可以实现 Numpy 并行性的场景和方法：加载/保存 Numpy 数组数据、高效地计算数学函数、高效地初始化数组、并行执行数组的元素级数学运算、在进程间高效共享 Numpy 数组数据。

3、[用少于 100 行的 Rust 使 Python 变快 100 倍](https://ohadravid.github.io/posts/2023-03-rusty-python/) (英)

文章针对一个有性能问题的 Python 库，使用 Rust 重写并作了三轮优化后，提升了性能 100 倍。文中使用了 py-spy 库绘制火焰图，分析出了代码的瓶颈点，并以此作为优化的依据，可以看到前后火焰图的差别很大。

![py-spy火焰图](./img/2023-06-23_rust.png)

4、 [将 Python 项目移植到 Rust](https://www.jelmer.uk/port-py-to-rust.html) (英)

文章指出“一步到位的移植”方式存在一些问题，从而提出“迭代式移植”的方法，并给出了一个代码示例。

5、 [设计 Pythonic 的库 API](https://benhoyt.com/writings/python-api-design/) (英)

如何设计出一个 Pythonic 的 API？在设计上有什么方法和基本原则呢？文章从代码结构、变量命名、错误处理、版本控制、类型注解等方面，给出了非常详细的介绍。文章较长，最后总结出 18 条 takeaways。

6、 [编译类型化的 Python](https://bernsteinbear.com/blog/typed-python/) (英)

Python 已支持类型提示，那能否编译 Python 代码为本地代码以提升性能呢？虽然类型提示可以提供一些性能优化，但由于 Python 的动态特性和灵活性，使得静态分析和编译非常困难。因此目前还没有一种方法可以将 Python 代码编译成本地代码以提高性能。 

7、 [pytest 的夹具很神奇！](https://www.revsys.com/tidbits/pytest-fixtures-are-magic/) (英)

夹具（fixture）是在测试前设置和准备必要数据的一种机制，可以将测试数据和测试代码分离。文章介绍了 pytest 中夹具的基本用法，以及与 Django 项目的结合使用。

8、 [探析 Python 字典的实现原理](https://just-taking-a-ride.com/inside_python_dict/chapter1.html) (英)

这是一个系列文章，支持用可视化的调试方式探析 Python字典的实现原理。这篇文章介绍了如何通过哈希表实现字典，以及如何解决哈希冲突。 

![在列表中搜索的可视化](./img/2023-06-24_dict.png)

9、 [Flask vs Django：选择完美的 Python Web 框架](https://djangocentral.com/flask-vs-django-selecting-the-perfect-python-web-framework/) (英)

Python 最主流的两个 Web 框架是 Flask 和 Django，文章深入比较了它们的主要功能、优势与缺点、流行的插件和使用场景等，让读者更方便做出自己的选择。

10、 [为什么不告诉人们“简单地”使用 pyenv、poetry、anaconda](https://www.bitecode.dev/p/why-not-tell-people-to-simply-use) (英)

文章的要点是：介绍一个基本的 Python 打包流程，尽可能减少依赖和要求，并解决大多数用户的打包问题。文中列出了一些常见的打包问题，并提供了一些解决方案，同时指出了一些常见的打包工具（如 homebrew、pyenv、anaconda、poetry）的缺点。 

11、 [PyScript 中的 Asyncio](https://jeff.glass/post/pyscript-asyncio/) (英)

文章介绍了在 PyScript/Pyodide 中使用 `async/await/asyncio` 来编写并发代码，还介绍了 Pyodide.Webloop 的实现，该实现允许 async/await 与浏览器事件循环一起使用。

12、 [线程的问题及其解决方案](https://glyph.twistedmatrix.com/2014/02/unyielding.html) (英)

[上期周刊](https://pythoncat.top/posts/2023-06-17-weekly7)第一则分享中的三篇文章偏向于支持隐式的 async，有读者建议再呈现一些支持显式 async 的观点。这篇文章的要点是：线程会使本地推理变得困难，而本地推理是软件开发中最重要的事情之一。因此，应该避免使用线程，而使用异步编程模型，如回调、promise、协程等。同时，文章还提到了使用隐式协程的风险，因为它们可能会导致与线程相同的问题。（@Plutonium 投稿）

### 🐿️项目&资源

1、 [PyQt-Fluent-Widgets：基于 PyQt5 的 Fluent Design 风格组件库](https://github.com/zhiyiYo/PyQt-Fluent-Widgets/blob/master/docs/README_zh.md)

目前开源且美观实用的 PyQt/PySide 组件库很少，所以作者照着 WinUI3 的设计稿写了这个 Fluent Design 风格的组件库，支持亮暗主题无缝切换和自定义主题色，支持 PyQt5/PyQt6/PySide2/PySide6 ，搭配 QtDesigner 可以快速设计出美观的界面。（来自@shokokawaii）

![](./img/Interface.jpg)

2、 [pyvibe：使用 Python 生成样式化的 HTML 页面](https://github.com/pycob/pyvibe) (英)

PyVibe是一个用于创建网页的 Python 库，让 Python 开发者快速构建前端页面，简化 UI 开发。PyVibe 返回一个 HTML 字符串，可用于静态页面、Flask 函数、Pyodide 动态客户端呈现。

![PyVibe生成标题及文本的示例](./img/social.png)

3、 [pynecone：纯 Python 的 Web 框架](https://github.com/pynecone-io/pynecone) (英)

Pynecone 发布于 2022 年 12 月，已获得 9K 星星，可谓十分火爆。它是一个用于构建和部署 Web 程序的全栈框架，提供了 50+ 内置组件，支持创建复杂的布局和使用 CSS 的全部功能来设置样式。

![Pynecone文档及演示项目](./img/2023-06-24_pynecone.png)

4、 [pytudes：短小精悍的 Python 编程练习内容](https://github.com/norvig/pytudes) (英)

这个项目包含了一些短小却很有挑战性的项目代码，既有“Advent of Code”历年的年度编程挑战活动的题目，也有“The Riddler”的系列数学谜题，还有文字谜题、概率问题等，甚至有使用 Python 解任何的数独题、实现一个 lisp 解释器，等等。

5、 [recognize-anything：Recognize Anything 模型和 Tag2Text 模型](https://github.com/xinyu1205/recognize-anything) (英)

Recognize Anything Model 是一种图像标记模型，可以高精度地识别任何常见类别；Tag2Text 是一种以标签为指导的视觉语言模型，可以支持字幕、检索和标签。这个项目是这两个模型的代码实现。

![对比不同模型的物体标注能力](./img/tagging_results.jpg)

6、 [ask-multiple-pdfs：支持与多个 PDF 聊天的 Langchain 程序](https://github.com/alejandro-ao/ask-multiple-pdfs) (英)

支持使用自然语言同时与多个 PDF 文件进行对话。项目使用了 streamlit，可在浏览器中显示用户界面。

![实现原理图](./img/PDF-LangChain.jpg)

7、 [DeepKE：用于知识图谱提取和及构建的开放工具包](https://github.com/zjunlp/DeepKE) (英)

DeepKE 是用于知识图谱构建的知识提取工具包，支持 cnSchema、低资源、文档级和多模态场景的实体、关系和属性提取。三个主要功能：命名实体识别、关系提取、属性提取。项目提供了详细的文档、教程和在线演示。

![模型的框架](./img/architectures.png)

8、 [awesome-DevOps：精选的 DevOps 平台、工具、实践和资源的列表](https://github.com/wmariuss/awesome-devops) (英)

一个“awesome”系列仓库，收录了关于 DevOps 的方方面面的内容，包含各种平台、自动化、CI/CD、代码管理、网络服务器、数据库、监控工具、网关、混沌工程，等等。

### 🥂讨论&问题

1、 [Hacker News：Our Plan for Python 3.13](https://news.ycombinator.com/item?id=36339777) (英)

一则热门讨论，话题关于 Python 3.13 版本的开发计划。不出意外，大部分的留言都围绕着 GIL，赞成与反对声皆有。

2、 [在你最喜欢的编程语言中，有哪些很优雅的代码库？](https://news.ycombinator.com/item?id=36370684) (英)

这也是一则 HN 上的帖子，既引起了关于编程语言本身的讨论，也涉及不同编程语言生态中的一些优秀的项目。有趣的是，有三则关于 Python 的留言都推荐了我们在上文中分享的`pytudes` 项目！

## 9 如何在本地部署开源大语言模型？ 

[博客原文](https://pythoncat.top/posts/2023-07-01-weekly) | 发布时间：2023-07-01

### 🦄文章&教程

1、 [本地部署开源大模型的完整教程：LangChain + Streamlit+ Llama](https://ai.plainenglish.io/%EF%B8%8F-langchain-streamlit-llama-bringing-conversational-ai-to-your-local-machine-a1736252b172) (英)

一篇步骤清晰的教程，它使用 LangChain 及 Facebook 开源的 LLaMA 大语言模型搭建了一个基于文档的问答助手，另外使用 Streamlit 构建出一个美观的用户界面。（附一篇中文的[翻译文](https://segmentfault.com/a/1190000043935266) ）

![](./img/2023-06-30_llm.png)

2、 [Python Asyncio 协程对象开销成本](http://so1n.me/2023/05/29/python_asyncio_lib_overhead/)

一个 Python Asyncio 协程会占用有多少内存呢？文章的测试结论是约 2Kb。另外，文中还测试了以下的问题：每秒可创建多少个裸协程？每秒可处理多少个协程？使用`uvloop` 后，创建及处理协程任务，能有多少提升？

3、 [如何使用 asyncio.Runner 执行多个协程](https://superfastpython.com/asyncio-runner/) (英)

asyncio.Runner 是 Python 3.11 中新增的功能，支持在同一事件循环中执行多个协程。文章主要内容：如何使用 asyncio.run() 运行多个协程，如何使用包装方法运行多个协程，以及如何使用 asyncio.Runner 类在同一个事件循环中以自适应甚至有条件的方式执行协程。

4、 [不使用锁的并发实现](https://hakibenita.com/django-concurrency) (英)

在并发编程中，通常需要使用锁，但是不应该滥用锁。这篇文章探讨了如何尽量不依赖锁来实现并发，演示的例子是生成短链接，主要的思想是“请求宽恕”而不是“提前检查”、使用 PostgreSQL 数据库提供的功能。

5、 [贡献 CPython 日记 (3) CPython 是如何运行的](https://zhuanlan.zhihu.com/p/639119164)

文章介绍了 CPython 是如何把 Python 代码跑起来的，主要过程：词法分析、语法分析、编译到字节码、执行字节码。

6、 [Python JIT 编译器 - 即时编译](https://coderslegacy.com/python-jit-compilers/) (英)

文章探讨了 JIT 编译的概念及其优点，并深入分析了主流的 Python JIT 编译器的优缺点（如 PyPy、Numba 和 Cython），介绍了在 Python 中使用 JIT 编译器的最佳实践和准则。

7、 [CPython、Pypy、MicroPython、Jython……都是些什么？](https://www.bitecode.dev/p/whats-the-deal-with-cpython-pypy) (英)

当我们说 Python 时，通常指的是官方实现的 CPython，但还有很多的“Python”，比如 Pypy、Jython、MicroPython、Brython、RustPython 等等，还有很多像是新“Python”的东西，比如 Nuitka、WinPython、Psyco、Pyjion 等等。文章解释了相关的概念和工具。

![](./img/2023-07-01_python.jpeg)

8、 [Python APScheduler：感受 AsyncIOScheduler 的强大](https://coderslegacy.com/python-apscheduler-asyncioscheduler/) (英)

APScheduler 是一个调度和自动化任务工具，它的 AsyncIOScheduler 支持调度异步函数和协程，文章介绍了它的功能、优点以及如何优化异步任务调度需求。

9、 [在生成代码时避免产生技术债务](https://sourcery.ai/blog/chatgpt-maintainable-code/) (英)

GPT 和其它大语言模型可以快速生成大量代码，但这也可能导致很多的混乱代码。文章探讨了如何改进这些工具生成的代码，并将其融入到项目中的几种方法，包括采用专家角色、提供示例、遵循最佳实践、遵循标准和明确指南以及代码放置的恰当位置等。

10、 [当 NumPy 太慢时](https://pythonspeed.com/articles/numpy-is-slow/) (英)

在不考虑并行处理的情况下，如何提升 Numpy 性能？NumPy 有三个固有瓶颈（急切执行、通用编译代码和向量化导致的高内存使用率）。针对这些瓶颈，文章介绍四种解决方案：手动优化代码、使用 JAX 作即时编译、使用 Numba 作即时编译，以及使用提前编译。

11、 [Numba 教程：使用 JIT 编译加速 Python 代码](https://coderslegacy.com/python-numba-tutorial/) (英)

Numba 是一个专用的即时编译器，通过将 Python 代码编译为高效的机器代码来消除解释执行的开销，从而提升性能。文章介绍了 Numba 的功能、内部原理、主要用法和常见问题。

12、 [自动化提升 Python 代码质量](https://blog.fidelramos.net/software/python-code-quality) (英)

如何使用较少的时间和精力来提升代码的质量？文章介绍了一些提升代码质量的工具（flake8、Black、isort、mypy、bandit等），以及使用 IDE、CI 和 pre-commit 等方式自动化调用这些工具。 

13、 [使用 PandasAI 增强数据分析](https://cognibits.hashnode.dev/enhancing-data-analysis-with-pandasai) (英)

PandasAI 是最近火爆的库，为 Pandas 集成了 AI 对话功能，可简化数据操作。文章介绍了 PandasAI 作复杂查询与图表可视化的方法，以及介绍了它提供的十几个方便好用的函数。

14、 [ 写单元测试的最佳实践](https://www.codium.ai/blog/best-practices-for-writing-unit-tests/) (英)

单元测试的好处无须赘述，但是写单测却是开发者最讨厌的事情之一。文章罗列了 10 条写单元测试的最佳实践，介绍了手工写单元测试的步骤，最后介绍了使用 Codium.AI 自动化编写测试的方法。

15、 [Netflix 如何安全地迁移到 GraphQL](https://netflixtechblog.com/migrating-netflix-to-graphql-safely-8e1e4d4f1e72) (英)

Netflix 官方的一篇博客，介绍了在将手机 APP 安全地从 Falcor 迁移到 GraphQL 的过程中，所采用的三种测试策略：AB 测试、Replay 测试和 Sticky Canaries。AB 测试用于评估新功能对客户的影响，Replay 测试用于验证迁移的正确性，Sticky Canaries 用于验证性能和业务指标。

🎁**Python潮流周刊**🎁已免费发布了 9 期，访问下方链接，即可查看全部内容：[https://pythoncat.top/tags/weekly](https://pythoncat.top/tags/weekly) 

### 🐿️项目&资源

1、 [PyGWalker：将 pandas 数据转换为 Tableau 样式的可视化界面](https://github.com/Kanaries/pygwalker) (中英)

一个在 Jupyter Notebook 环境中运行的可视化探索式分析工具，仅一条命令即可生成一个可交互的图形界面，以类似 Tableau/PowerBI 的方式，通过拖拽字段进行数据分析。（star 6.5K）

![](./img/pygwalker2.png)

2、 [jnumpy：快速用 Julia 编写 Python C 扩展](https://github.com/Suzhou-Tongyuan/jnumpy) (英)

用 Julia 为 Python 写高性能的 C 扩展，提速约 200x。（@xgdgsc 投稿）

3、 [jupyter-ai：JupyterLab 的生成式 AI 扩展](https://github.com/jupyterlab/jupyter-ai) (英)

JupyterLab 官方提供的生成式 AI 扩展，主要提供了：`%%ai` 指令、原生的聊天 UI 页面、支持大量平台的大语言模型（AI21、Anthropic、Cohere、Hugging Face、OpenAI、SageMaker 等）。

4、 [broadcast-service: 一个强大的 Python 发布订阅者框架](https://github.com/Undertone0809/broadcast-service)

一个发布订阅者框架，支持同步异步调度、定时任务、主题管理、发布订阅者回调等功能。（@Zeeland 投稿）

5、 [cushy-storage: 一个基于磁盘缓存的 ORM 框架](https://github.com/Undertone0809/cushy-storage)

一个基于磁盘缓存的 ORM 框架，可对基本数据类型及自定义的数据通过 ORM 进行增删改查，支持多种序列化操作和数据压缩方式。（@Zeeland 投稿）

6、 [giskard：专用于 ML 模型的测试框架](https://github.com/Giskard-AI/giskard) (英)

如何测试机器学习模型、要涵盖哪些问题、如何实施测试？这个框架可扫描数十种漏洞（性能偏差、数据泄漏、不鲁棒性、虚假关联、过度自信、信心不足、不道德问题等），并基于结果生成特定领域的测试套件。（star 1K）

![](./img/giskard.png)

7、 [DragGAN：基于点的交互式图像编辑](https://github.com/XingangPan/DragGAN) (英)

本周最火项目，可在图像上通过拖动点的方式，生成想要的新图像，非常惊艳！（star 28K）

8、 [plumbum: 永远不要再写 shell 脚本](https://github.com/tomerfiliba/plumbum) (英)

除了类似 shell 的语法和方便的快捷方式外，这个库还提供了本地和远程命令执行（通过 SSH）、本地和远程文件系统路径、简单的目录和环境操作、以及一个可编程的 CLI 工具包。（star 2.6K）

9、 [threestudio：用于生成 3D 内容的统一框架](https://github.com/threestudio-project/threestudio) (英)

支持用文本提示、单个图像和少量镜头图像创建 3D 内容。支持多种模型，如 ProlificDreamer、DreamFusion、Magic3D、Score Jacobian Chaining，等等。（star 1.8K）

10、 [rembg：一个删除图像背景的工具](https://github.com/danielgatis/rembg) (英)

支持删除图像的背景，支持多种使用方式（cli、库、docker）和多种强大的功能。（star 10.5K）

![](./img/2023-07-01_rembg.png)

## 10 Twitter 的强敌 Threads 是用 Python 开发的！ 

[博客原文](https://pythoncat.top/posts/2023-07-08-weekly) | 发布时间：2023-07-08

### 🦄文章&教程

1、[聊一聊 Python 和 Golang 的垃圾回收](https://www.yance.wiki/gc_go_py)

常见的垃圾回收算法有哪些，它们的优缺点是什么？Python 的垃圾回收机制由什么组成，如何解决内存泄漏问题？Golang 的垃圾回收机制又是怎样的，如何解决内存泄漏问题？

2、[像竞赛程序员一样调试](https://albexl.substack.com/p/a-tale-of-debugging-the-competitive) (英)

编程竞赛需要在限定时间内解决一系列难题，这篇文章介绍了在编程竞赛中作自动调试的方法。它的方法除了可以提升成绩，对于现实的软件开发也有所启示。 

3、[Python 3.12 预览版：支持 Linux 性能分析器](https://realpython.com/python312-perf-profiler/) (英)

Python 3.12 最终版将在今年 10 月发布，其中最大的变化之一是支持 Linux `perf` 分析器。这篇文章介绍了什么是 Linux perf 分析器、perf 能给 Python 带来什么好处、如何在 Python 3.12 中使用 perf、如何分析性能数据、性能数据可视化……

![桌面软件中显示的性能分析数据](./img/2023-07-08_perf.png)

4、[CPython 招聘一名全职工程师](https://lukasz.langa.pl/40b601fc-2b24-4629-91d9-3b32c58365c6/) (英)

Łukasz Langa 是 PSF 的首个全职开发者（由 Meta 赞助），近日发文表示要新招聘一名“副手”工程师（由彭博社赞助）！两周前，PSF 官网刚公布了[首个全职的安全开发工程师](https://pyfound.blogspot.com/2023/06/announcing-our-new-security-developer.html) （由 OpenSSF 赞助），现在又有了新的赞助，真的要感谢慷慨的赞助者们！

5、[PEP 563 和 PEP 649](https://lukasz.langa.pl/61df599c-d9d8-4938-868b-36b67fdb4448/) (英)

PEP-563 注解的延迟求值，PEP-649 使用描述符作注解的延迟求值。这篇 2021 年的文章出自 PEP-563 的作者 Łukasz Langa，介绍和对比了这两个 PEP。它们都是 Accepted 状态，然而原计划在 3.10 发布的 PEP-563 已被[宣告无限期搁置](https://docs.python.org/zh-cn/3/whatsnew/3.11.html#pep-563-may-not-be-the-future) ，所以它似乎需要更多的关注？（@Plutonium 投稿）

6、[Python 设计模式：简洁及可重用代码（观察者）](https://ritwikmath.hashnode.dev/python-design-patterns-cookbook-recipes-for-clean-and-reusable-code-observer) (英)

在构建复杂软件时通常会使用设计模式。文章介绍了观察者设计模式、其使用场景与 Python 代码示例，另外与事件驱动架构（EDA）作了几项对比。

7、[你并不需要写\_\_all\_\_](https://jamesturk.net/posts/you-dont-need-all/) (英)

文章介绍了 Python 中三种导入模块的方式和\_\_all\_\_的用法，重点介绍了一种替代\_\_all\_\_的方法，即在 \_\_init\_\_.py 文件中直接导入所需的名称。

8、[用 Python 实现一门简易的编程语言](https://blog.miguelgrinberg.com/post/building-a-toy-programming-language-in-python) (英)

如何用 Python 来实现一门编程语言呢？这是一个系列教程，第一篇中实现了一个非常基础的编程语言，可以执行 print 语句，第二篇则拓展成支持变量和数学表达式。涉及词法分析、语法分析、代码生成及执行等知识。

9、[使用 Python 的 collections.Counter 计算出现次数](https://www.pythonmorsels.com/using-counter/) (英)

Counter 是 Python 中最好用的数据结构之一。这篇文章介绍了一些很有用的操作：获取出现次数最多的 N 个内容、添加内容到 Counter、移除内容、删除负计数内容、Counter 作算术运算、Counter 传入生成器表达式。

10、[使用 Numba Vectorize 加速 Python 代码](https://coderslegacy.com/python-code-with-numba-vectorize/) (英)

Numba 是用于提升 Python 性能的常用手段，这篇文章介绍了它的重要功能 Vectorize（矢量化），包括它的内部原理，了解它如何充分利用单指令多数据（SIMD）操作的强大功能。文中展示了 5 个使用场景的代码示例。

11、[Paul Graham：如何做出伟大的工作？](https://emmmme.com/greatwork) (中译)

Paul Graham 是《黑客与画家》的作者，最近发布了文章《[How to Do Great Work ?](http://paulgraham.com/greatwork.html)》。一句话概括要点：做出伟大的工作需要好奇心、努力和适合自己的工作类型。文章较长，关键的几个问题：什么是做伟大工作的关键？如何找到适合自己的工作类型？如何保持好奇心？什么是伟大工作的标准？为什么要努力做伟大工作？

12、[Paul Graham：如何努力工作？](https://emmmme.com/workhard) (中译)

翻译自 Paul Graham 写于 2021 年的《[How to Work Hard ?](http://paulgraham.com/hwh.html)》，可与上一则内容关联阅读。

13、[Django 2023 年 6 月：技巧和讨论](https://www.pythonmorsels.com/django-june-2023/) (英)

这是一篇关于 Django 的聚合类月刊，分享了一些学习 Django 的技巧、资源、文章，等等。

### 🐿️项目&资源

1、[cinder：Meta 内部以性能为导向的 CPython 版本](https://github.com/facebookincubator/cinder) (英)

本周重大新闻：Meta 推出了 Twitter 的竞品 Threads，仅两天的注册量就已突破三千万。它的后端使用了 Cinder，这是基于 Python 3.10 构建的高性能版本，包含许多性能优化，包括字节码内联缓存、协程的预先求值、每个方法一次的 JIT，以及一种实验性的字节码编译器。（star 2.6K）

2、[vlite：用 NumPy 制作的简易矢量数据库](https://github.com/sdan/vlite) (英)

用不到 200 行代码编写的快速、轻量级和简易的矢量数据库。

![不同数据库的处理效果对比](./img/250959288-fc36481c-f1f6-4973-8461-6aef3a04486d.png)

3、[gpt-migrate：将代码仓从一种框架或语言迁移成其它](https://github.com/0xpayne/gpt-migrate) (英)

使用 GPT 将少量代码从一种编程语言转换成其它语言，这已非难事。但是，整个代码仓级别的语言/框架迁移，听起来就不是一件容易的事！这个项目需要使用 GPT-4，目前在 Python 和 Javascript 这种“简单”的语言上有不错的效果。（star 5.4K）

4、[FastDepends：从 FastAPI 中提取的依赖注入框架，异步和同步模式都支持](https://github.com/lancetnik/FastDepends) (英)

这是将 FastAPI 移除所有 HTTP 逻辑后改造成的依赖注入框架。

5、[Data-Copilot：通过自主工作流程桥接数十亿数据和人类](https://github.com/zwq2018/Data-Copilot)

这是一个基于 LLM 的系统，连接中国金融市场，目前可以访问中国的股票、基金、经济及金融数据、实时新闻。

![自主查询和预测数据](./img/demo1.png)

6、[awesome-read-the-docs：精选的项目文档列表](https://github.com/readthedocs-examples/awesome-read-the-docs) (英)

`Read the Docs` 是一个用于构建和发布文档的开源平台（你肯定见过它家的 Sphinx 或 MkDocs 生成的文档），这个仓库收录了一些开源项目的文档，可以学习它们是如何构建出酷炫效果的。

7、[DisCo：通过指示生成现实世界的人类舞蹈](https://github.com/Wangt-CN/DisCo) (英)

这是一个通用的人类舞蹈生成工具包，可以根据参考图片和姿势，生成人类舞蹈图片和视频。

![](./img/2023-07-08_disco.png)

8、[Mark Shannon 博士论文：为动态语言构建高性能虚拟机](https://theses.gla.ac.uk/2975/1/2011shannonphd.pdf) (英)

Mark Shannon 由于“[香农计划](https://pythoncat.top/posts/2021-05-16-Guido)”而被很多人所知。这里分享的是他 2011 年在格拉斯哥大学的博士论文（可下载的 PDF），描述了一种用于构建动态语言虚拟机的方法，并解释了如何通过围绕一个抽象机器来构建虚拟机工具包的设计。

9、[blind_watermark：图片加盲水印，提取水印无须原图](https://github.com/guofei9987/blind_watermark) 

盲水印（Blind Watermark）是一种数字水印技术，可以在不需要原图或文本的情况下，将水印嵌入到数据中。这个项目是基于频域的数字盲水印，在多种攻击方式下仍能有效提取。（star 3.6K）

10、[VisCPM：基于 CPM 基础模型的中英双语多模态大模型系列](https://github.com/OpenBMB/VisCPM)

这是一个开源的多模态大模型系列，支持中英双语的多模态对话能力（`VisCPM-Chat`模型）和文到图生成能力（`VisCPM-Paint`模型）。基于百亿参数量语言大模型 CPM-Bee（10B）训练（[周刊第 7 期](https://pythoncat.top/posts/2023-06-17-weekly7)曾介绍过），融合视觉编码器（Q-Former）和视觉解码器（Diffusion-UNet）以支持视觉信号的输入和输出。

![](./img/model_zh.png)

11、[polars-cookbook：Python polars 库的教程](https://github.com/escobar-west/polars-cookbook) (英)

polars 是用 Rust 写成的 Python 库，用于进行数据分析。这个仓库包含有 9 个章节的使用教程。

12、[ML 系统设计：200 个研究案例](https://www.evidentlyai.com/ml-system-design) (英)

像 Netflix、Airbnb 和 Doordash 这样的公司如何运用机器学习来改善其产品和流程？这个网站整理了 64 家公司的 200 个案例，可以了解到机器学习的现实用例，学习如何设计机器学习系统。

![200个案例的在线数据库](./img/2023-07-08_ML.png)

### 🥂讨论&问题

1、[Ask HN：关于技术史的好书？](https://news.ycombinator.com/item?id=36581241) (英)

Hacker News 上的问题，有哪些关于技术历史的好书推荐？

2、[Ask HN：最有价值的计算机科学书籍？](https://news.ycombinator.com/item?id=36560950) (英)

也是 HN 上的问题，有哪些关于编程语言、符号逻辑、算法、操作系统等 CS 书籍推荐？

## 11 如何使用 Golang 运行 Python 代码？ 

[博客原文](https://pythoncat.top/posts/2023-07-15-weekly) | 发布时间：2023-07-15

### 🦄文章&教程

1、[使用 Golang 和 Docker 运行 Python 代码](https://soulteary.com/2023/05/21/run-python-code-with-golang-and-docker.html)

如何使用 Golang 来运行 Python 代码呢？关于 Python 版本和硬件，有哪些使用限制呢？这篇文章使用 Docker 解决环境依赖问题，使用开源项目 **cpy3**，成功用 Golang 运行 Python 代码。它有一篇续文《[使用 Golang 和 Docker 实现 Python 计算服务](https://soulteary.com/2023/05/22/using-golang-and-docker-to-implement-python-computing-services.html)》，将普通的 Python 软件包封装为高性能的可通过 **gRPC** 方式调用的服务。

2、[答案在代码中：“实现需求”的双重含义](https://www.piglei.com/articles/the-answer-is-in-the-code-fulfill-requirements/)

很多程序员容易忽略一件事：那就是阅读代码的时间会远多于写下它们的时间！这意味着**代码的可读性**非常重要，因此当我们在“实现需求”时，除了要考虑用户的功能需求外，更应多加关注如何写出可读性高的代码。

3、[减轻 Python 包管理的痛苦](https://www.bitecode.dev/p/relieving-your-python-packaging-pain) (英)

@NoHeartPen 投稿：在看了第一期中[对 conda 的吐槽](https://www.v2ex.com/t/938669#reply88) 后，开始关注这个问题，但一直没有找到比较系统的总结，看了这篇文章后终于有了大致的思路（这篇文章不仅写了「怎么做」，还写了「为什么」，让我改掉了不建虚拟环境的陋习和放弃折腾 conda）。另外，附上翻译版 [如何减轻 Python 打包之痛](https://blog.csdn.net/csdnnews/article/details/131546123) 。

4、[CuPy：将 NumPy 数组调度到 GPU 上运行](https://www.cnblogs.com/traditional/p/17536459.html)

NumPy 的作者 Travis Oliphant 曾说，如果当时给 NumPy 添加了 GPU 的支持，就没有后来的 Tensorflow、Torch 等深度学习框架什么事了。[CuPy](https://github.com/cupy/cupy) 是一个兼容 Numpy 且支持 GPU 的库（star 7K），这篇文章介绍了它的安装及数组的基础知识。

5、[Python 源码剖析：深度探索 Cpython 对象](https://segmentfault.com/a/1190000044006618)

为什么说 Python 中一切皆对象？为什么 Python 用起来比其它静态类型语言慢很多？这篇文章从 CPython 的对象构造器入手，介绍了 CPython 底层数据结构、对象创建的过程、动态性的实现方式等内容。

6、[使用 Flask + Flask RESTful 快速搭建 API 服务](https://juejin.cn/post/7252976055093592120)

一篇长文，使用 Flask + Flask RESTful 搭建一个 API 应用，使用 **Flask-SQLAlchemy** 扩展实现 ORM 操作 MySQL 数据库，基于 JWT 验证实现注册、登录以及登出接口，解决跨域问题，并使用 Docker 部署该应用。

7、[详解 Django 请求与响应：深入理解 Web Http 交互的核心机制](https://segmentfault.com/a/1190000043988232)

探讨了 Django 中的请求与响应处理，包含基础知识、生命周期、HttpRequest 和 HttpResponse 对象的详细介绍。同时，讨论了 Django 的视图和请求、响应处理，以及安全性和异步处理的考虑。最后，对比了 Django 与 Flask、FastAPI 等框架在请求响应处理上的异同。

8、[将大型 Django 项目迁移到 Mypy 的失败之旅](https://dev.to/derlin/when-plans-go-astray-my-unsuccessful-journey-of-migrating-a-large-django-project-to-mypy-3l23) (英)

作者在给一个生产项目添加 Mypy 类型检查时遇到了诸多问题：很多库不提供 pyi 类型、TypedDict 使用受限、Optional 类型需要许多断言、混合类需要实现协议、Django 模型不支持泛型。简而言之，给历史项目加上类型检查是一件痛苦的事，最好是从一开始就考虑。

9、[如何在 Python 中使用 Notion API？](https://www.python-engineer.com/posts/notion-api-python/) (英)

Notion 是一款强大的知识管理软件，这篇教程教你如何用 Python 操作 Notion 的数据库：创建集成、在数据库中创建页面、查询数据库与页面、更新页面、删除页面。

10、[最简单的使用 Rust 加速 Python 的方法](https://pythonspeed.com/articles/easiest-rust-python/) (英)

如何将 Rust 代码打包为 Python 可使用的扩展？[maturin](https://www.maturin.rs/) 和 [setuptools-rust](https://setuptools-rust.readthedocs.io/) 是主流的两种方式。但是，在做原型设计时，打包与集成过程还是挺麻烦，这篇文章介绍了一个新的库 [rustimport](https://pypi.org/project/rustimport/) ，可以直接从 Python 中导入 Rust 代码！文章介绍了它的使用方法、Rust 初学者最常见的性能错误、以及使用 **rustimport** 时的一些陷阱。

11、[Python 是如何解析空格的？](https://jayconrod.com/posts/101/how-python-parses-white-space) (英)

Python 的换行与缩进是程序结构的基础部分。空格在 Python 的语法解析中起到什么作用，词法分析器如何处理换行和缩进？Python 的空格有哪些优点和缺点？Python 如何解析代码并生成抽象语法树？

12、[如何从 Python 字典中删除重复的值？](https://pythonguides.com/remove-duplicate-values-from-a-python-dictionary/) (英)

介绍了 7 种从 Python 字典中删除重复值的方法：使用 for 循环、使用字典解析式、使用 setdefault() 方法、使用 values() 和 set() 方法、使用 collections.defaultdict()、使用列表解析式、使用 dict.fromkeys() 和 values()。

13、[如何找出 Python 代码中的性能瓶颈？](https://realpython.com/python-profiling/) (英)

什么时候该给项目作性能优化？性能调优前该关注哪些内容，应该使用什么工具？这篇文章介绍了`time` 、`timeit` 、`cProfile` 、`Pyinstrument` 、`perf` 等工具以及一些性能优化的技巧。

14、[3 个很酷的 Python 库，节省你的时间和精力](https://samuel-vidovich.medium.com/3-cool-python-libraries-that-will-save-you-time-and-effort-27fcdc6762d5) (英)

介绍了 3 个非常好用的库：[JMESPath](https://github.com/jmespath/jmespath.py) 可以很方便查询 Json 中的元素（star 1.9k），[inflection](https://github.com/jpvanhal/inflection) 可以很方便处理字符串（比如批量将驼峰式变量名修改成蛇形命名），[more-itertools](https://github.com/more-itertools/more-itertools) 类似于标准库的`itertools` 提供了很多操作可迭代对象的方法（star 3.1k）。

15、[如何管理有近 3 万个文件的超大型 Python 代码仓？](https://blog.europython.eu/kraken-technologies-how-we-organize-our-very-large-pythonmonolith/) (英)

你见过接近 3 万个文件（不含测试）的 Python 单体代码仓么？全球有 400 开发者共同开发，如何避免混乱？作者介绍了分层管理代码仓的做法、使用的架构和工具（[import-linter](https://github.com/seddonym/import-linter)）、以及克服过的一些困难。

### 🐿️项目&资源

1、[threads-net：逆向工程 Threads 的 Python API](https://github.com/dmytrostriletskyi/threads-net) (英)

新上线的 Threads 依然是本周最火爆的科技话题之一。这个项目通过逆向工程获得了它的 API，可让你使用 Python 操作 Threads 的很多功能。

2、[engblogs：用 AI 为科技公司官博作摘要，并部署成网站](https://github.com/ishan0102/engblogs) (英)

这个项目用 RSS 抓取 AWS、Apple、DeepMind、Google、Meta、Stripe 等科技公司的博客，调用 gpt-3.5 生成摘要，将数据存储在 supabase 中，并在 Vercel 上托管了一个 Next.js [网站](https://www.engblogs.dev/)。

![项目的流程示意图](./img/engblogs.png)

3、[django-unicorn：Django 全栈的响应式组件框架](https://github.com/adamghill/django-unicorn) (英)

可以为 Djiango 模板添加现代响应式的组件功能，无需使用 Javascript 框架。支持表单验证、重定向、加载状态、部分更新、滚动触发、消息、Javascript 集成等等丰富的功能。

4、[imarkdown：轻量级的 Markdown 图片链接转换器](https://github.com/Undertone0809/imarkdown)

可以批量将图片的链接进行本地到图片服务器、图片服务器到本地、图片服务器到图片服务器的转换。（@Zeeland 投稿）

![imarkdown的执行过程图](./img/imarkdown.png)

5、[Pangu-Weather：盘古天气的官方实现](https://github.com/198808xc/Pangu-Weather) (英)

可以通过人工智能来提升天气预报的准确度啦？！Pangu-Weather 是一个快速而准确预报全球天气的 3D 高分辨率模型。这个仓库提供了伪代码、预训练模型、推理代码等资源。

6、[PULSE：中文医疗大语言模型](https://github.com/openmedlab/PULSE)

基于 4 百万个中文医学领域和通用领域的指令微调，支持医学领域的各种自然语言处理任务，包括健康教育、医师考试问题、报告解读、医疗记录结构化以及模拟诊断和治疗。基于这个大模型，已经有不少应用，比如与 X-ray 图像模型结合的应用 **XrayPULSE** ：

![诊断与咨询X光影像](./img/XrayPULSE.jpg)

7、[creosote：识别虚拟环境中未使用的依赖库](https://github.com/fredrikaverpil/creosote) (英)

可扫描虚拟环境中未使用的依赖库，支持 Poetry、Pipenv、PDM、 `requirements.txt` 文件以及 PEP-621 的 `pyproject.toml` 文件。

8、[MediaGPT：中文的自媒体大语言模型](https://github.com/IMOSR/MediaGPT)

一个面向自媒体创作、直播和运营等领域的大语言模型，能够理解抖音运营、短视频创作、巨量千川投放、直播运营等领域的核心概念和策略，支持内容创作、平台运营、广告投放等。

9、[MetaGPT：给定一行需求，返回 PRD、设计、任务、代码](https://github.com/geekan/MetaGPT) (英)

一个元编程框架，可以为 GPT 分配不同的角色（如产品经理/架构师/项目经理/工程师），共同协作完成复杂的软件开发任务。仅需一句话需求，就能输出用户故事/竞争分析/需求/数据结构/API/文档等。（star 3.7k）

![软件公司多角色示意图](./img/software_company_cd.jpeg)

10、[khoj：数字大脑的 AI 个人助理](https://github.com/khoj-ai/khoj) (英)

基于个人的 Markdown 笔记、PDF 文件、Github 代码仓和照片，打造支持搜索与聊天的 AI 助理，可通过浏览器、Emacs、Obsidian 和移动设备等多种界面进行交互。

![架构图](./img/khoj_architecture.png)

11、[aider：基于命令行的 AI 编码助手](https://github.com/paul-gauthier/aider) (英)

一个命令行聊天工具，可以让 GPT 创建新项目，或修改现有 git 代码仓中的代码。它可以轻松完成 git 提交、比较和撤消更改，无需人工复制/粘贴。（star 2.3k）

![给函数添加参数和类型注解](./img/2023-07-15_aider.png)

12、[visprog：可视化编程，无需训练的合成视觉推理](https://github.com/allenai/visprog) (英)

一篇 CVPR 2023 最佳论文的官方实现，可以实现：基于图片内容的自然语言问答与推理、图片内对象标注、自然语言图片编辑等功能。

![visprog可以做的事情](./img/teaser1.png)

### 🐢播客&视频

1、[Talk Python To Me Podcast #421 Python at Netflix](https://talkpython.fm/episodes/show/421/python-at-netflix) (英)

Python 在 Netflix 中有大量的使用场景，比如 CDN、需求预测和容灾、安全、机器学习等等。这期播客节目聊了 Netflix 在使用 Python 时的相关话题。另外，分享它官博上获得 8k 赞的一篇旧文《[Python at Netflix](https://netflixtechblog.com/python-at-netflix-bba45dae649e)》。

2、[Python Bytes #343 So Much Pydantic!](https://pythonbytes.fm/episodes/show/343/so-much-pydantic) (英)

这期播客聊了很多话题，其中关于 Pydantic 的有两则：V2 版本已发布、一个[awesome-pydantic](https://github.com/Kludex/awesome-pydantic) 清单，后者收录了很多使用 Pydantic 的开源项目。

### 🥂讨论&问题

1、[Pytorch有什么节省显存的小技巧？](https://www.zhihu.com/question/274635237)

知乎上的一个问题，前排有很多高赞的回答，八仙过海各显神通！

2、[如果 PEP-703 被采纳，Meta 将投入人力支持](https://discuss.python.org/t/a-fast-free-threading-python/27903/99) (英)

Python 社区今年最受瞩目的提案当属 PEP-703 了吧（我曾[在年初介绍过](https://pythoncat.top/posts/2023-02-20-GIL)）！Guido 上个月在论坛中说要是能得到 Meta 等科技公司的支持就太好了。好消息来了，上周 Meta 承诺可以提供人力支持。消息在 Twitter 和 Hacker News（[查看 HN 帖子](https://news.ycombinator.com/item?id=36643670)）等平台上，获得了激烈的讨论。

## 12 Python 中如何调试死锁问题？ 

[博客原文](https://pythoncat.top/posts/2023-07-22-weekly) | 发布时间：2023-07-22

### 🦄文章&教程

1、[使用 PyStack 调试 Python 中的崩溃和死锁](https://martinheinz.dev/blog/101) (英)

介绍了一款强大的工具 **PyStack**，可以解决一些难以调试的问题，如死锁、程序挂起、段错误、Python 和 C/C++ 混合应用调试等。它支持两种调试方法：附加到运行中的进程，或分析崩溃进程的核心转储文件。

2、[介绍一个 FastAPI 项目模板](https://bitestreams.com/blog/fastapi_template/) (英)

一个非常完备的 FastAPI 项目模板，带有 CI/CD、Docker、PostgreSQL、Makefile、单元/集成测试、linting及类型检查。

3、[Python FastAPI 微服务与 Polylith 架构](https://davidvujic.blogspot.com/2023/07/python-fastapi-microservices-with-polylith.html) (英)

**Polylith** 是一种软件架构框架，核心思想是将系统分解为一个个可测试的、可重用的独立单元。作者结合 FastAPI 与 Polylith 架构，开发了一个项目模板。

4、[Python日志模块：实战应用与最佳实践](https://juejin.cn/post/7257321872425058359)

详细解析了 **logging** 模块，从基本介绍到实际应用和最佳实践，介绍了如何高效地用它记录日志，以及如何避免常见的陷阱。

5、[测量 Python 和 Rust 异步 Web 服务的性能](https://codesolid.com/benchmarking-python-and-rust-async-web-server-performance/) (英)

文章使用 **JMeter** 分别测试了 Rust 的 **Axum** 框架以及 Python 的 **Blacksheep** 框架。猜猜最终的测试结论是什么呢？

6、[dinov2_retrieval：一个基于 DINOv2 的图片检索应用](http://vra.github.io/2023/07/14/dinov2-retrieval/)

Meta 发布了 **DINOv2** 视觉预训练模型，能够准确地理解图片中的语义信息。这篇文章用它开发了一个 Python工具，能够检索若干张图片在测试数据集中最相似的图。

![检索单车与三轮车](./img/2023-07-21_dinov2.png)

7、[隐藏在 Python 标准库中的 CLI 工具](https://til.simonwillison.net/python/stdlib-cli-tools) (英)

Python 标准库中有哪些实用的小工具，可以直接写 `python -m xxx` 调用？这篇文章使用 **ripgrep** 查找出几十个模块，并重点介绍了`http.server` 、`base64` 、`asyncio` 、`tokenize` 、`ast` 、`json.tool` 、`random` 等工具。

8、[如何在 Python 项目中使用 TailwindCSS ？](https://www.abdulmumin.com/how-to-use-tailwindcss-in-any-python-project) (英)

Tailwind 是近几年在前端很火的一个 CSS 框架，如何将它运用到 Python Web 项目中呢？文章主要介绍了`tailwindpie` 这个库，并演示如何在 Flask 项目中使用它，实现自动安装及配置 TailwindCSS。

9、[Python 元编程实用指南](https://dev.to/karishmashukla/a-practical-guide-to-metaprogramming-in-python-691) (英)

介绍 Python 中元编程的几种机制：装饰器、元类、函数及类装饰器、动态代码生成，以及常用于元编程的关键字与内置函数。

10、[CPython 是如何打印堆栈信息的？](https://blog.stealthrocket.tech/how-cpython-prints-stack-traces/) (英)

一篇硬核长文，介绍了 CPython 如何表示程序的调用栈以及如何将字节码地址解析为源代码行号。文章剖析了 CPython 的内部机制，提供了 CPython 性能分析和调试的有用信息。 

![一个hello world程序的分析](./img/2023-07-22-cpython.png)

11、[用于路径操作的 Pathlib](https://switowski.com/blog/pathlib/) (英)

Pathlib 是 Python 中作目录相关操作的库，而且应该是最好用的一个。文章详细介绍了它的常见用法，对比了其它常用工具，并且针对一些场景作了性能分析。

12、[Stack Overflow、Shopify 及 Levels.fyi 的软件架构](https://newsletter.techworld-with-milan.com/p/stack-overflow-architecture) (英)

文章分享了三家大型网站的软件架构。

13、[10 条编写干净 Python 代码的建议](https://dev.to/alexomeyer/10-must-know-patterns-for-writing-clean-code-with-python-56bf) (英)

代码的可读性与可维护性，再怎么强调也不为过！这篇文章介绍了一些基础的原则，但却非常体现程序员的编程素养。

14、[Meta 开发者工具：支撑大规模协作的编程体系](https://engineering.fb.com/2023/06/27/developer-tools/meta-developer-tools-open-source/) (英)

Meta 的几千名开发者使用了哪些支撑大规模协作的工具呢？文章介绍了几款开源工具（[Sapling](https://engineering.fb.com/2022/11/15/open-source/sapling-source-control-scalable/) 版本控制、 [Buck2](https://engineering.fb.com/2023/04/06/open-source/buck2-open-source-large-scale-build-system/) 构建系统、 [Infer](https://fbinfer.com/)/ [RacerD](https://engineering.fb.com/2017/10/19/android/open-sourcing-racerd-fast-static-race-detection-at-scale/)/[Jest](https://jestjs.io/) 测试与静态分析），另外 Meta 官博还有一篇介绍开发者工作流的文章 [Meta 开发者工作流：探索大规模编码工具](https://developers.facebook.com/blog/post/2022/11/15/meta-developers-workflow-exploring-tools-used-to-code/) 。

### 🐿️项目&资源

1、[GitHub 上有哪些值得推荐学习的 Python 项目？](https://www.reddit.com/r/Python/comments/111y9o2/python_projects_with_best_practices_on_github/) (英)

Github 上有哪些运用了最佳实践，并且有强大而良好架构的项目？这是 Reddit 上的帖子，可去看看大家推荐了什么。

2、[python-cheatsheet: Python 知识点速查表](https://github.com/gto76/python-cheatsheet) (英)

一份非常全面的 Python 知识手册，除了 Github 仓库，还有在线网站及 PDF 版本。（star 33K）

![速查表的内容目录](./img/2023-07-22_cheatsheet.png)

3、[pandora：潘多拉，一个让你呼吸顺畅的ChatGPT](https://github.com/pengzhile/pandora)

国人开源的项目，实现了网页版 ChatGPT 的主要操作，能解决国内访问 ChatGPT 的诸多痛点。（star 18.6K）

4、[py4web：数据库驱动的 Web 开发框架](https://github.com/web2py/py4web) (英)

这个框架可以快速开发由数据库驱动的 Web 应用，它基于流行的全栈框架 [web2py](https://github.com/web2py/web2py) ，但比后者快 10-20 倍。

![py4web的主面板](./img/dashboard_main.png)

5、[FastAPI-Vue-Admin：基于 FastAPI+Vue 的敏捷开发框架](https://www.oschina.net/p/fastapi-vue-admin)

基于 FastAPI、Vue2.x、ElementUI、MySQL 等框架精心打造的一款模块化、高性能、企业级的敏捷开发框架，实现了可插拔的组件式开发方式。国人作品（收费），有完善的中文支持。

![项目效果预览](./img/2023-07-22_fastapi-vue-admin.png)

6、[ChatALL：同时与ChatGPT、Bing Chat、Bard、Alpaca、Claude、讯飞星火、文心一言等聊天](https://github.com/sunner/ChatALL)

这个项目的中文名叫“**齐叨**”，可同时与多个 AI 对话，方便取得最佳答案。（star 8.2K）

![使用时的页面](./img/chatall.png)

7、[vectordb：一个 Python 向量数据库](https://github.com/jina-ai/vectordb) (英)

纯 Python 开发的向量数据库，支持 CURD 及强大的可扩展能力（分片与复制）。使用了  [DocArray](https://github.com/docarray/docarray) 充当驱动向量搜索逻辑的引擎，使用  [Jina](https://github.com/jina-ai/jina) 保证高效和可扩展的索引服务。

8、[python-sortedcontainers：有序容器类型（有序列表、有序字典和有序集合）](https://github.com/grantjenks/python-sortedcontainers) (英)

一个纯 Python 实现的有序容器库，提供了列表、集合与字典的有序版本，API 兼容，号称经常比 C 实现更快。用户指南中提供了几份性能对比报告，数据很可观。（star 3K）

![字典读取元素的性能比较](./img/2023-07-22_sorteddict.png)

9、[quart：一个支持异步的 Python Web 框架](https://github.com/pallets/quart) (英)

这是基于 Flask 框架而作的异步版实现，支持快速将 Flask 项目改造成支持异步。（star 2K）

10、[ShortGPT：自动生成短视频内容的 AI 框架](https://github.com/RayVentura/ShortGPT) (英)

一个强大的自动化内容生成框架，简化了视频创建、素材获取、字幕生成、画外音合成和编辑任务。（star 1.4K）

![工作原理图](./img/shortGPT.png)

### 🐢播客&视频

1、[捕蛇者说 Ep 41：和 Penguin 聊聊 CPython 优化和大厂编译器组的工作](https://pythonhunter.org/episodes/ep41)

这期播客的嘉宾曾出现在我们周刊的第 7 期，他给 [CPython 添加返回常量指令](https://github.com/python/cpython/issues/101632) ，节目聊了他给 CPython 做的这项工作以及在腾讯做编译器开发的情况。

2、[The Python Show 07 - 访谈 Robyn Web 框架的作者](https://www.pythonshow.com/p/07-the-robyn-python-web-framework#details) (英)

**Robyn** 是用 Rust 开发的轻量级、高性能 Python Web 框架。这期播客聊了关于 Robyn 的相关话题。

3、[2023 年 Python 网络大会的 80 个视频](https://www.youtube.com/playlist?list=PLt4L3V8wVnF4GJb8dekLGTNx44FNIFwdv) (英)

Python 网络大会（Python Web Conf）今年举办了第 5 届，上周发布了相关的视频材料，涵盖主题有人工智能/机器学习、大数据、CI/CD、Serverless、安全、容器等等。

![PWC2023的节目列表](./img/2023-07-22_webconf.png)

4、[关于 AI 内容：推荐 6 个 YouTube 频道](https://thecreatorsai.com/p/what-to-watch-about-ai-6-youtube) (英)

想要了解 AI？想观看关于 ChatGPT 的相关视频？想发现最新潮的 AI 工具？这里推荐了 6 个油管频道。

5、[除你武器 013｜我也不想工作啊，只是想找个岸上一上](https://www.xiaoyuzhoufm.com/episode/64b4f4c5d0844ea812ce31e9)

这是我本周听到最喜欢的一档播客！这期节目聊了就业与人生选择的相关话题。（如果你是高考毕业生，可去听第 11 期高考特辑 [成为状元 9 年后，我还在做高考的噩梦](https://www.xiaoyuzhoufm.com/episode/647c8bb653a5e5ea14dbffad)）

## 13 Jupyter Notebook 7 发布了，无 GIL 提案传来大好消息！ 

[博客原文](https://pythoncat.top/posts/2023-07-29-weekly) | 发布时间：2023-07-29

### 🦄文章&教程

1、[Jupyter Notebook 7 隆重发布](https://blog.jupyter.org/announcing-jupyter-notebook-7-8d6d66126dcf) (英)

Jupyter Notebook 大版本更新，亮点包括实时协作、交互式调试、目录、主题和深色模式、国际化、改进的可访问性、移动设备上的紧凑视图。

2、[Python 中的弱引用与基础类型支持情况探究](https://juejin.cn/post/7258881840823615544)

Python 的基础类型 Int、List、Dict、Tuple、Str 不支持弱引用，而 Object、Type、Set 等类型却支持弱引用，为什么会出现这种情况呢？文章给出了自己的分析。

3、[分布式锁的介绍与 Python 实现](http://so1n.me/2023/07/23/distributed_lock_lntroduction_and_lmplementation/)

什么情况下要使用分布式锁？如何用 py-redis 实现分布式锁，加锁与解锁的流程是怎样的？加锁的超时时间有什么注意点，如何实现 WatchDog 给锁自动续约？

4、[释放 PyScript 的力量：在 HTML 中运行 Python 代码](https://scofield.hashnode.dev/unlocking-the-power-of-pyscript-a-guide-to-running-python-code-in-your-html) (英)

一篇 PyScript 入门教程，介绍了安装、基础知识、配合 Flask 的使用以及高级功能。

5、[通过并发实现更快的文件 I/O](https://superfastpython.com/faster-file-io-with-concurrency/) (英)

什么是文件 I/O，为什么它会比主内存 I/O 慢很多？文件 I/O 的速度与哪些因素有关？有哪些提升文件 I/O 性能的方法？

6、[如何编写完美干净的 Python 代码？](https://dev.to/atkumar/how-to-write-impeccably-clean-code-that-will-save-your-sanity-4np9) (英)

文章介绍了一些最佳编程实践，涵盖代码结构、pre-commit、类型提示、文档字符串、lint、Pydantic、拼写检查、测试等方面。

7、[Python 日志记录：对比最流行的 6 个库](https://betterstack.com/community/guides/logging/best-python-logging-libraries/) (英)

文章详细对比了当前最为流行的 6 种日志框架：**logging、loguru、structlog、Eliot、logbook 与 picologging** 。最推荐的无疑是前两个，其它权当兴趣尝鲜吧。

8、[使用 cProfile 分析模块级代码](https://adamj.eu/tech/2023/07/23/python-profile-section-cprofile/) (英)

如何使用 **cProfile** 来对 Python 代码进行性能分析？文章简单介绍了它的用法，并给出了上下文管理器与装饰器两种高级用法。

9、[掌握 Python 函数式编程](https://www.codium.ai/blog/mastering-functional-programming-in-python/) (英)

文章介绍了函数式编程的优点、Python 对函数式编程的支持、最佳实践以及编写 Python 程序时要避免的错误。

10、[Python 3.12 预览版：更直观和一致的 f-string](https://realpython.com/python312-f-strings/) (英)

在 Python 3.12 之前，f-string 有什么限制？即将发布的 3.12 版本会带来哪些变化呢？新功能前瞻：嵌入表达式可以重用引号、f-string 中允许使用反斜杠、多行表达式中可写注释、任意级别的 f-string 嵌套、优化了 f-string 的错误提示……

11、[使用 AsyncMixin 创建可等待的构造函数](https://dev.to/akarshan/asynchronous-python-magic-how-to-create-awaitable-constructors-with-asyncmixin-18j5) (英)

介绍了如何使用名为 `AsyncMixin` 的 mixin 在 Python 中创建异步构造函数。

12、[在 Python 中查找并修复不安全的直接对象引用](https://snyk.io/blog/insecure-direct-object-references-python/) (英)

不安全的直接对象引用 (IDOR) 是一种安全漏洞，文章介绍了这种漏洞的危害，如何识别并修复 IDOR 漏洞。

13、[使用异步 Python 克服性能瓶颈：深入研究 CPU 密集型代码](https://medium.com/@DorIndivo/overcoming-performance-bottlenecks-with-async-python-a-deep-dive-into-cpu-bound-code-b604a400255a) (英)

作者介绍了如何识别和优化特征存储中 CPU 密集型代码，从而提升核心模型的性能。事件循环延迟是什么，如何监控异步代码消耗的时间？

14、[PEP-720 交叉编译 Python 包](https://peps.python.org/pep-0720/) (英)

交叉编译是指在一台计算机上编译适用于另一种体系结构的程序。这份 PEP 试图揭示交叉编译遇到的挑战，并以此进行改进。

15、[PEP-722 单文件脚本的依赖关系规范](https://pep-previews--3210.org.readthedocs.build/pep-0722/) (英)

在项目中记录和管理第三方库，这有很多解决方案。但是，如何给单文件管理三方库依赖呢？这份 PEP 提出了一种很简单的规范格式。

### 🐿️项目&资源

1、[Resume-Matcher：比较简历与职位描述，按照打分排名](https://github.com/srbhr/Resume-Matcher) (英)

基于 AI 的简历匹配器，根据 JD 的关键词给简历打分。使用 Qdrant（一种高效的向量相似度搜索工具）来衡量简历与 JD 的匹配程度。

2、[awesome-python-htmx：Python 中使用 htmx 作 Web 开发的精选内容](https://github.com/PyHAT-stack/awesome-python-htmx) (英)

PyHAT 旨在 Python 中推广 htmx+ASGI+TailwindCSS，这个项目列出了一些入门资源、教程、设计理论、周边生态等等。

3、[CodeGeeX2: 更强大的多语言代码生成模型](https://github.com/THUDM/CodeGeeX2)

基于 ChatGLM2-6B 基座语言模型，在 Python 上达到 35.9% 的 Pass@1 一次通过率，超越规模更大的 StarCoder-15B。CodeGeeX 插件支持 VS Code、 IntelliJ IDEA、PyCharm、GoLand、WebStorm、Android Studio 等IDE。（star 1K）

![AI编程助手](./img/codegeex_demo.png)

4、[Chinese-Llama-2-7b: 第一个能下载运行的中文 LLaMA2 模型](https://github.com/LinkSoul-AI/Chinese-Llama-2-7b)

开源可商用的**中文版 Llama2 模型及中英文 SFT 数据集**，兼容适配所有针对原版 *llama-2-chat* 模型的优化。（star 1K）

5、[docker-llama2-chat: LLaMA2 (official / 中文版 / INT4 / llama2.cpp)](https://github.com/soulteary/docker-llama2-chat)

中文开源项目，三步上手 LLaMA2，作者写了一系列教程博客。

6、[taipy：将数据和 AI 算法转变为完整的 Web 应用](https://github.com/Avaiga/taipy) (英)

一个全栈项目，快速将数据和 AI 构建出 Web 应用。

![前后端示意图](./img/2023-07-29_taipy.png)

7、[pyrasite：将代码注入正在运行的 Python 进程](https://github.com/lmacken/pyrasite) (英)

允许在运行中的 Python 进程里注入自定义代码，以实现动态调试、修改变量值、破解加密、分析运行时行为等功能。支持多种注入方式，包括注入到 Python 解释器、注入到指定函数、注入到特定线程等。（star 2.7K）

8、[python-manhole：调试运行中的 Python 程序](https://github.com/ionelmc/python-manhole) (英)

在运行中的 Python 进程里提供交互式的调试和监控功能，利用 Python 的"ptrace"机制，通过在目标进程中注入代码，可通过 SSH 或 telnet 等协议连接，实现远程交互。与 gevent 和 eventlet 兼容，有少许限制。

9、[vscode-python：使用 VScode 和 Docker 设置 Python 开发环境](https://github.com/RamiKrispin/vscode-python) (英)

一个非常完备的教程项目，指导在 Docker 上运行 Python、设置开发环境与容器扩展、测试与部署等。

![使用VScode和Docker的开发工作流](./img/docker-architecture.png)

10、[webdriver_manager：Python 的 Webdriver 管理器](https://github.com/SergeyPirogov/webdriver_manager) (英)

使用 **Selenium** 与 **Playwright** 等框架时，要管理各种浏览器驱动。这个项目简化了浏览器驱动的管理与使用方式。

11、[lets-plot：用于统计数据的开源绘图库](https://github.com/JetBrains/lets-plot) (英)

**JetBrains** 开源的一个绘图库，可创建美观、交互式的统计图表和数据可视化。为 Python 和 Kotlin 开发者提供类似 **ggplot2** 的绘图 API。（star 1.1K）

12、[pdfarranger：在图形界面合并或拆分 PDF 文档，支持旋转、裁剪和重排](https://github.com/pdfarranger/pdfarranger) (英)

一个小型 python-gtk 程序，通过直观的方式编辑 PDF 文档。它的后端基于 [pikepdf](https://github.com/pikepdf/pikepdf) ，这是一个用于读写 PDF 文件的库。（star 2.3K）

![pdfarranger的界面](./img/pdfarranger.png)

### 🥂讨论&问题

1、[关于 PEP-703 的指导委员会通知（使 CPython 的 GIL 成为可选）](https://discuss.python.org/t/a-steering-council-notice-about-pep-703-making-the-global-interpreter-lock-optional-in-cpython/30474?s=35) (英)

在第 11 期周刊中，我们分享过“如果 PEP-703 被采纳，Meta 将投入人力支持”，现在又有进展啦，指导委员会打算接受 PEP-703 了！这篇帖子列出几个基本原则与三个阶段的开发计划。向后兼容性是重中之重，这不会是 Python 4。

## 14 Lpython 高性能编译器、Python 与 JavaScript 实现互通 

[博客原文](https://pythoncat.top/posts/2023-08-05-weekly) | 发布时间：2023-08-05

### 🦄文章&教程

1、[LPython：新颖、高性能、适用于多平台的 Python 编译器](https://lpython.org/blog/2023/07/lpython-novel-fast-retargetable-python-compiler/) 

最新发布的一个Python 编译器（当前为 alpha 版本），目标是打造高性能的 Python。可以将带有类型提示的 Python 代码编译为优化的机器代码，支持提前编译（AOT）与即时编译（JIT），支持与 CPython 互操作，支持多种后端，例如 LLVM、C、C++、WASM、Julia 和 x86。

2、[Cython 3.0.0 的文档](https://cython.readthedocs.io/en/latest/src/changes.html) 

Cython 是一门专用于提升 Python 性能的编程语言，最近从 0.29.x 版本直接升到了 3.0.0 版本，带来了大量的问题修复以及新特性，这份 changelog 文档非常丰富。（附一篇[详解历时五年的 Cython3.0 都发生了哪些变化](https://mp.weixin.qq.com/s/CcC1QEojybyRpzUUiJxdAw) ，总结了这个版本的几项较大的变化点。）

3、[Python 中使用 Pandas 和 NumPy 计算变异系数](https://www.marsja.se/coefficient-of-variation-in-python-with-pandas-numpy/) 

变异系数（Coefficient of Variation，CoV）是一种统计量，用于评估数据集相对于其均值的相对变异性或离散程度。文章介绍了变异系数的公式、解释、意义和实际用途，以及如何用 Pandas 和 Numpy 来计算变异系数。

4、[Jupyter 中的生成式 AI](https://blog.jupyter.org/generative-ai-in-jupyter-3f7174824862) 

Jupyter Notebook 也支持 AI 功能了，目前免费提供。官博这篇教程指导了如何在聊天界面使用 Jupyter AI 完成各项任务。支持来自 AI21、Anthropic、AWS、Cohere、HuggingFace Hub 和 OpenAI 的大语言模型。

5、[Python 中的结构化模式匹配](https://www.tartley.com/posts/structured-pattern-matching-in-python/) 

Python 3.10 版本的模式匹配语法，你用过了么？这篇文章探究了这种语法的相关要素（基本结构、每种模式的演示），也思考了是否真必要用模式匹配语法替换`elif` 。

6、[使用 Rich 的 Inspect 查看 Python 对象属性](https://textual.textualize.io/blog/2023/07/27/using-rich-inspect-to-interrogate-python-objects/) 

Rich 是一个在终端使用富文本和美观样式的库（本期周刊的“项目&资源”中有介绍），这篇文章介绍了它的 inspect() 函数，可以查看 Python 对象的属性以及可用的 API。

![查看文件对象的属性与方法](./img/2023-08-05_rich_inspect.png)

7、[Python 包版本控制的怪癖](https://sethmlarson.dev/pep-440) 

一个冷门话题，讨论了 Python 包的版本号。我才知道 Python 包版本命名竟有 6 个组成部分！文章大部分内容是对 [PEP-440（版本标识和依赖规范）](https://peps.python.org/pep-0440/) 的介绍与解读，最后也介绍到了 Wheel 包的版本命名规则。

8、[文件 I/O 并发编程的模式](https://superfastpython.com/file-io-concurrent-patterns/) 

使用并发编程来提升文件 I/O 操作的性能，具体有哪些使用手段呢？文章介绍了四种模式（单线程、线程池/进程池、批处理任务、在进程池中使用线程池），并讨论了该如何选择更合适的模式。

9、[如何高效地阅读 Python 代码？](https://mostlypython.substack.com/p/reading-code?nthPub=581) 

对于所有程序员来说，阅读代码都是一项必备能力。但是，如何高效地阅读与理解别人的代码呢？这篇文章介绍了一些阅读策略与技巧，同时站在阅读者的视角，也有助于我们写出更具可读性、可理解性的代码。

10、[如何在 Python 中用 JPype 与 Pyjnius 调用 Java 代码？](https://www.askpython.com/python/examples/call-java-using-python) 

Java 和 Python 各有优点，如何能将它们结合起来呢？这篇文章介绍了如何用 **JPype** 和 **Pyjnius** 等方式来调用 Java，同时指出实现方案所面临的挑战和限制。

11、[如何在 Python 中调用 JavaScript 代码？](https://dev.to/willp/call-javascript-code-in-python-551a) 

文章介绍了 [PythonMonkey](https://github.com/Distributive-Network/PythonMonkey) 库的用法，实现在 Python 中加载与运行 JavaScript 代码，以及在 Python 中使用 WASM。（附作者的其它文章：[使用 WebAssembly 在 Python 中执行 Rust 代码](https://medium.com/@willkantorpringle/executing-rust-in-python-using-webassembly-d361eb5583da) 、[使用 WebAssembly 在 Python 中调用 C 函数](https://medium.com/@willkantorpringle/calling-c-function-from-python-using-webassembly-63a305248951)）

12、[使用 Textual 构建 ChatGPT TUI 应用程序](https://chaoticengineer.hashnode.dev/textual-and-chatgpt) 

本期周刊有好几则内容与 [Textual](https://github.com/Textualize/textual) 相关！与图形用户界面（GUI）相比，文本用户界面（TUI）响应更快、系统要求更低和更易自动化。这篇文章使用 Textual 构建了一个 ChatGPT 对话工具。

![在终端与ChatGPT对话](./img/2023-08-05_tui.png)

13、[Python 中的向量数据库入门](https://code.dblock.org/2023/06/16/getting-started-with-vector-dbs-in-python.html) 

如何在 Python 中使用当前热门的向量数据库呢？这篇文章介绍了使用 10 多种数据库来索引及搜索向量数据，包括 ClickHouse、OpenSearch、pgVector、Pinecone、Redis 等等。

14、[CPython 的编译过程是怎样的？](https://dev.to/cwprogram/a-tour-of-cpython-compilation-cd5) 

CPython 是 Python 官方的解释器实现，这篇长文介绍了它的编译过程，包括语法解析、抽象语法树、字节码、pyc 解析等内容。

15、[介绍新开源的 Python 调试器 pdbp (Pdb+)！](https://dev.to/mintzworld/the-new-pdbp-pdb-python-debugger-2blc) 

作者指出了 Python 内置的 **pdb** 与其它调试器（如 **ipdb、pdbpp**）的缺点，介绍了他开发的 pdbp 所作的修复和改进，以及简单的入门使用。这个库依赖项很少，功能强大，值得一试。

### 🐿️项目&资源

1、[PyFlo：一个很有趣的 Python 入门教学网站](https://pyflo.net/) 

这个网站非常惊艳，推荐大家去体验下！主页是一幅学习线路图，画了不同的学习分支和内容分类，还有几个编程项目挑战，点击每个节点则跳转到对应内容的页面。（借鉴此网站的创意，开发面向中文读者的教学网站，应该会挺有趣）

![路线图的一部分](./img/2023-08-05_pyflo.png)

2、[Pandas Tutor：可视化 Pandas 执行过程的网站](https://pandastutor.com/) 

你或许已知道 [Python Tutor](https://pythontutor.com/)，它是一个提供了在线交互式 Python 编程环境的教学工具。这里介绍的 Pandas Tutor 也是类似的网站，它允许在浏览器中编写 Pandas 代码，并可视化数据的转换过程。 （附一篇文章，两位作者介绍了他们将 [Pandas Tutor 移植到 Pyodide ](https://blog.pyodide.org/posts/pandastutor/) 的工作，以便大规模推广数据科学的教学）

![可视化数据的处理过程](./img/2023-08-04_pandastutor.png)

3、[ploomber-sql：使用 SQL 和 Jupyter 开发端到端的应用](https://ploomber-sql.readthedocs.io/en/latest/index.html) 

这是托管在 Read The Docs 上的一个教学课程，介绍了如何使用 SQL 和 Jupyter 作数据分析，包含操作数据库、高级查询技术、数据可视化（**seaborn、plotly、ggplot**）、项目打包部署与监控等章节。它出自于开源项目 [ploomber](https://github.com/ploomber/ploomber) （star 3.1K），后者是一个快速构建数据管道的项目。

4、[memray：Python 的内存分析器](https://github.com/bloomberg/memray) 

这是周刊[第 12 期](https://pythoncat.top/posts/2023-07-22-weekly)介绍过的 **pystack** 的姊妹项目，可以跟踪 Python 代码、C/C++ 扩展模块和 Python 解释器本身中的内存分配，支持本机模式与实时查看模式，可生成多种类型的报告。提供了 Pytest 插件 [pytest-memray](https://github.com/bloomberg/pytest-memray)，可以在运行测试套后查看内存报告。（star 11K）

5、[textual-paint：终端中的 MS Paint](https://github.com/1j01/textual-paint) 

**MS Paint** 是微软公司开发的一款简单的图像编辑软件。这个项目是 MS Paint 风格的 TUI 图像编辑器，支持在终端中打开与保存图像、MS Paint 中的所有工具、调色板、画笔预览等等功能。

6、[rich：在终端中提供富文本和美观的样式](https://github.com/Textualize/rich) 

Rich 让终端不再单调，可以绘制漂亮的表格、进度条、markdown、源代码语法高亮以及栈回溯信息等。（star 44.2K）下面这张效果图，囊括了它的主要特色：

![Rich的功能效果图](./img/2023-08-05-rich.png)

7、[json-lineage：支持解析大型 JSON 文件的工具](https://github.com/Salaah01/json-lineage) 

这是用 Rust 开发的 JSON 解析库，主要解决大文件无法加载到内存的痛点，通过将 JSON 转化成 JSONL 格式，解决内存消耗问题。测试表明，处理一个 500MB 文件，Python 标准库要用 2GB 内存，但这个库仅需 1.5MB，而且速度差异很小。

8、[PythonMonkey：嵌入到 Python VM 中的 JavaScript 引擎](https://github.com/Distributive-Network/PythonMonkey) 

前文已出现过 PythonMonkey，它将 Mozilla 的 SpiderMonkey JavaScript 引擎嵌入到 Python 虚拟机中，利用Python 引擎提供 JS 主机环境。这个项目的目标包括在 Python 中调用 JavaScript 库和在 JavaScript 中调用 Python 库，如果能有效打通这两种语言的生态，前途不可估量！

9、[cudf：GPU 数据帧库](https://github.com/rapidsai/cudf) 

cuDF 基于 **Apache Arrow** 列式内存格式构建，是一个 GPU DataFrame 库，用于加载、连接、聚合、过滤和以其它方式操作数据。提供了类似 pandas 的 API，无需了解 CUDA 编程的细节。（star 5.8K）

10、[distill-sd：更小更快的 Stable Diffusion](https://github.com/segmind/distill-sd) 

对 Stable Diffusion 作“知识蒸馏”后的小型化版本，可生成与 SD 质量相当的图像，同时速度更快、空间占用更少。

11、[HQTrack：高质量追踪视频中的任何事物](https://github.com/jiawen-zhu/HQTrack) 

一个对视频中对象作高性能跟踪和分割的框架，由视频多目标分割器（VMOS）和掩模优化器（MR）组成，可以同时跟踪多个目标物体并输出准确的物体掩模。

12、[awesome-mlops：很棒的 MLOps 工具精选列表](https://github.com/kelvins/awesome-mlops) 

一个 awesome 系列的 MLOps 精选列表，包含各种各样的项目/工具，以及文章、书籍、活动、播客和网站等等资源。

### 🐢播客&视频

1、[Talk Python To Me #425：终极的 Python 内存分析器 Memray](https://talkpython.fm/episodes/show/425/memray-the-endgame-python-memory-profiler) 

本期的“项目&资源”介绍了 Memray，这里的播客节目邀请了两位嘉宾深入聊了这个项目。

## 15 如何分析异步任务的性能？ 

[博客原文](https://pythoncat.top/posts/2023-08-12-weekly) | 发布时间：2023-08-12

### 🦄文章&教程

1、 [如何分析 FastAPI 异步请求的性能？](https://blog.balthazar-rouberol.com/how-to-profile-a-fastapi-asynchronous-request)

**cProfile** 这种基于函数调用的分析工具无法有效分析异步操作的执行时间，文章介绍了 [pyinstrument](https://github.com/joerick/pyinstrument) 这个分析库，结合 **FastAPI.middleware** 装饰器，并使用 [speedscope](https://github.com/jlfwong/speedscope) 来可视化 FastAPI 程序的耗时情况。

![FastAPI程序耗时分析](./img/2023-08-12_pyinstrument.png)

2、 [利用 FastAPI 的后台任务：增强性能和响应能力](https://noplacelikelocalhost.medium.com/leveraging-background-tasks-in-fastapi-enhancing-performance-and-responsiveness-6e4ad64c7d16)

介绍了 FastAPI 的 BackgroundTasks，可以创建后台任务，用于管理长时间运行的任务，而不阻塞主进程。

3、 [使用 Python 创建直方图](https://compucademy.net/creating-histograms-with-python/)

直方图又名“柱状图”，可直观查看数据的分布趋势、离散程度和异常值等信息。文中介绍了 Matplotlib、Plotly、Seaborn、Numpy 和 Pandas 等工具绘制直方图的方法，介绍各种直方图的样式和风格、处理异常值、分析时间序列数据等。

4、 [Mypy 1.5 发布了](https://mypy-lang.blogspot.com/2023/08/mypy-15-released.html)

Mypy 是 Python 的静态类型检查工具，1.5 版本主要功能有：不再支持 Python 3.7、更灵活的 TypedDict 创建和更新、可显示错误代码的文档链接、实验性改进了泛型函数的类型推断、对 Python 3.12 的部分支持，等等。

5、 [在 Linux 上运行 Python 的“Hello World”脚本时，会发生什么？](https://jvns.ca/blog/2023/08/03/behind--hello-world/)

在 py 文件中写上一句`print("hello world")`，然后在命令行执行这个文件，幕后都发生了什么呢？文章使用了 `readelf` 、`strace` 、`ldd` 、`debugfs` 、`/proc` 、`ltrace` 、`dd` 和 `stat` 等工具，详细解释了脚本被执行的过程。主要涉及操作系统相关的内容，而不是 CPython 解释器。（附：文章还引用了最近很火的 [Putting the "You" in CPU ](https://cpu.land/) ，介绍计算机是如何运行程序的，强烈推荐！）

6、 [通过对比 Python 来学习 PostScript](https://kenschutte.com/postscript-vs-python)

PostScript 是电子出版和桌面出版领域的页面描述语言，广泛用于打印机、出版和图形设备。文章将一段 PostScript 程序直译成 Python 代码，可以让你快速了解这门语言的语法。

7、 [Python 中不那么随意的性能优化](https://www.nathom.dev/blog/casual_performance_optimization_python/)

作者的一段代码，用 Rust 花了 950 毫秒，而 Python 却花 70 秒！这怎么能忍！将生成器写法改成 for 循环后，只是轻微提速，使用 Numpy 和多进程做了一些优化后，终于看到了比较可观的数据。不同代码方案的对比、Python 底层工作原理、内存使用效率问题，以及语言特性的差异。

8、 [在 Python 中创建上下文管理器](https://www.pythonmorsels.com/creating-a-context-manager/)

如何用 Python 创建自己的上下文管理器？上下文管理器是可以在 `with` 代码块中使用的对象，在进入和退出时做一些操作。文章介绍了上下文管理器的实现细节。

9、 [一个简单的模块，可以篡改 Python 解释器的数字](https://kenschutte.com/python-swap-ints)

一篇有意思的文章。导入一个模块后，可以将 8 和 9 互换，即`print(8)` 会打印出 9。文章展示了如何用 C 编写一个简单的模块，介绍了 CPython 中整数对象池的实现，并通过修改两个整数的引用，实现一个简单的篡改数字的效果。

10、 [为什么说 Python 很糟糕……](https://josvisser.substack.com/p/why-python-is-terrible)

一篇给 Python 泼冷水的文章，主要观点是认为 Python 不适合于开发大型应用。批评的点包括动态和鸭子类型、性能问题、代码维护和重构难等问题。

11、 [Python 中错误处理的最佳实践](https://pybit.es/articles/python-errors-should-not-pass-silently/)

Python 之禅说“错误不应该悄无声息地被忽略”，强调了应该直面错误和透明处理。文章指出了一些糟糕的错误处理写法，给出了尽早检查错误、快速失败处理等编程建议。

12、 [使用企业数据和 Python 构建 GPT 对话机器人](https://www.pythongasm.com/build-gpt-powered-chatbots-around-enterprise-data-with-python)

这篇教程介绍了搭建企业中 GPT 对话机器人的完整流程，包括数据索引、查询检索、集成 LLM、使用 FastAPI 开发接口、uvicorn 作部署。

13、 [Python 鸡尾酒：将上下文管理器和迭代器等量混合](https://www.bitecode.dev/p/python-cocktail-mix-a-context-manager)

**tenacity** 库提供了一种用迭代器和上下文管理器组合的写法，实现重试机制。这篇文章演示了如何用自定义的迭代器和上下文管理器，来实现同样的功能，可以让你更深入理解这两个好用的特性。

14、 [索引的力量：利用 Pandas 提高数据整理效率](https://stackabuse.com/the-power-of-indexing-boosting-data-wrangling-efficiency-with-pandas/)

Pandas 被广泛用于数据处理，文章介绍了如何高效利用索引技术，提升它整理数据的速度和效率。介绍了多种索引技术，例如基于整数的索引、布尔索引、设置新索引并重置旧索引、排序索引。

15、 [杀死 ProcessPoolExecutor](https://www.tinybird.co/blog-posts/killing-the-processpoolexecutor)

Python 不适合处理 CPU 密集型任务，文章中项目原本使用进程池来规避 GIL 问题，后使用线程、C++ 扩展和更精细调整的 GIL 控制，将内存使用量减少 50%，CPU 使用量减少约 20%，线程和进程减少约 70%，I/O 流量减少 100%。

### 🐿️项目&资源

1、 [pyinstrument：Python 的调用堆栈分析器](https://github.com/joerick/pyinstrument)

一个轻量级、无侵入的 Python 代码性能分析库，支持分析异步任务和事件循环代码，可生成多种格式的分析报告，包括文本、HTML 和火焰图。（star 5.5K）

2、 [viztracer：低开销的日志记录/调试/分析工具，可视化 Python 代码的执行](https://github.com/gaogaotiantian/viztracer)

国人开源的日志记录/调试/分析工具，支持线程、多进程、子进程和异步，支持火焰图、远程连接、虚拟调试等，有强大的前端，可流畅渲染 GB 级堆栈信息。（star 3.5K）

![可视化界面](./img/viztracer.png)

3、 [tenacity：Python 重试库](https://github.com/jd/tenacity)

可提供简单而灵活的方式来实现可靠的重试机制，支持指定重试次数、重试间隔时间、重试的回调函数、根据不同的错误条件进行重试等功能，减少手动处理错误和异常的麻烦。（star 5.1K）

4、 [litestar：轻量、灵活且可扩展的 ASGI API 框架](https://github.com/litestar-org/litestar)

一个高性能的 ASGI API 框架，其早期版本是基于 [Starlette](https://github.com/encode/starlette) 开发的，命名为 **Starlite**，但从 2.0 版本起已完全移除 Starlette 依赖，并改名为 litestar。核心特性：基于类的控制器、依赖注入、分层中间件、插件系统、OpenAPI 3.1、内置 Trio，等等。（star 2.5K）

5、 [Make-It-3D：利用单个图像创建高保真 3D 模型](https://github.com/junshutang/Make-It-3D)

从图片中分割物体，创建高保真的 3D 几何形状，可作 360° 旋转展示。（star 1.2K）

6、 [Color-diffusion：对黑白图像进行着色的扩散模型](https://github.com/ErwannMillon/Color-diffusion)

使用 diffusion  模型对黑白图像进行着色，使用 LAB 色彩空间实现，这是 RGB 色彩空间的 3 通道替代方案。

7、 [DevOpsGPT：AI 驱动的自动化软件开发系统](https://github.com/kuafuai/DevOpsGPT)

将 LLM 与 DevOps 工具相结合，将自然语言需求转换为可工作的软件。无需繁琐的需求文档编写与沟通，缩短开发与交付时间，加速软件部署和迭代。（star 1.2K）

![自动化需求开发的流程图](./img/intro-flow-en.png)

8、 [ILibCST：Python 的具体语法树解析器和序列化器库](https://github.com/Instagram/LibCST)

具体语法树（Concrete Syntax Tree）是在词法分析和语法分析阶段后生成的一种数据结构，可用于分析代码结构，执行语义分析、重构优化和代码生成等操作。（star 1.2K）

9、 [hypothesis：功能强大、灵活且易于使用的库，用于基于属性的测试](https://github.com/HypothesisWorks/hypothesis)

基于属性的测试（Property-based Testing）是一种软件测试方法，其中测试用例的生成和验证是基于定义的属性或规约。传统的单元测试要给定具体的测试用例，而基于属性的测试则是随机生成大量的测试数据。（star 6.8K）

### 🐢播客&视频

1、 [Python People 播客](https://pythonpeople.fm/)

这是一档新上线一个月的播客栏目，每周访谈 Python 社区里一位有突出贡献的大佬。目前已访谈的嘉宾有 Michael Kennedy（Talk Python to Me 和 Python Bytes 的主理人）、Paul Everitt（ JetBrains 和 PyCharm 的开发者倡导者）、Brett Cannon（Python 核心开发者）、Barry Warsaw（Python 核心开发者，非常早的成员）、Bob Belderbos（Pybites 的主理人）。

![](./img/2023-08-12_python_people.png)

2、 [Talk Python To Me #426：PyScript 的新增功能](https://talkpython.fm/episodes/show/426/whats-new-in-pyscript-august-2023)

Pyscript 使 Python 能够在浏览器中运行。这期播客聊了它的最新进展。

3、 [Stack Overflow Blog #597：了解 SRE](https://stackoverflow.blog/2023/08/08/understanding-sre-ep-597/)

网站可靠性工程（Site Reliability Engineering，SRE）是什么？它和 DevOps 有什么关系？如何平衡 SRE 的原则与组织结构的关系？生成式 AI 对 SRE 会带来什么影响？

4、 [Stack Overflow Blog #593：Python 团队如何调整语言以适应 AI 的未来](https://stackoverflow.blog/2023/07/25/how-the-python-team-is-adapting-the-language-for-an-ai-future-ep-593/)

播客嘉宾是 Python 核心开发者和指导委员会成员 Pablo Galindo Salgado，讨论了如何平衡语言设计中的一致性和新功能、为什么收集社区对新版本的反馈很重要，以及为何他要专注于让 Python 更快。

## 16 优雅重要么？如何写出 Pythonic 的代码？ 

[博客原文](https://pythoncat.top/posts/2023-08-19-weekly) | 发布时间：2023-08-19

### 🦄文章&教程

1、[写代码时，优雅有意义吗？](https://mathspp.com/blog/pydonts/does-elegance-matter)

作者强调使用 Python 的核心特性来编写惯用的、富有变现力的、优雅的代码很重要，提出优雅不是可有可无的奢侈品。

2、[Python Asyncio实践--高并发下如何防止缓存击穿](https://so1n.me/2023/08/14/python_asyncio_concunrrency_result_share/)

文章介绍了如何基于`Asyncio.Future`的特性编写一个语言级别的防缓存击穿的工具——`Share`，并介绍它的使用和高并发下的处理方法。

3、[高效定时任务处理：深入学习 Python 中 APScheduler 库的奥秘](https://juejin.cn/post/7266663176980185144)

APScheduler 是一个强大的定时任务处理库，这篇长文详细介绍了从入门到精通的相关知识，包括创建定时任务、定时任务触发器、任务存储、并发执行、阻塞和非阻塞调度器、错误处理、立即执行任务、调度器持久化、任务监听器和移除定时任务等。

4、[CPython 开发实战：魔改 lambda 函数](https://juejin.cn/post/7266037480750071848)

文章尝试将 Python 的 lambda 函数改成 Javascript 风格的箭头函数。在编译 CPython 时，通过修改 `.asdl` 文件，重新构造抽象语法树，修改语法分析文件，并利用 **pegen** 重新生成语法分析器。

5、[CPython 是如何实现引用计数的？](https://codeconfessions.substack.com/p/cpython-reference-counting-internals)

你是否对 CPython 的底层运行原理及其内部结构感到好奇？文章通过分析源码，介绍了 CPython 是如何实现引用计数和内存管理的，涉及引用计数的机制、关键数据结构的解释、字节码指令的执行、引用计数的局限性等。

6、[使用 Importlib 实现 Python 延迟加载](https://coderslegacy.com/python-lazy-loading-with-importlib/)

延迟加载指的是在使用时再导入模块，而不是在程序刚执行时就加载。它的好处：减少启动时间、降低内存消耗、提高性能、优化资源、运行时加载。文章介绍了`importlib` 实现延迟加载的用法。。

7、[使用 Python 和 Playwright 进行端到端测试](https://sixfeetup.com/blog/end-to-end-testing-python-playwright)

端到端测试（end-to-end）指的是对程序的整个使用流程从头到尾作测试，可能发现单元测试与集成测试都无法发现的问题。这是一篇详细的入门教程，介绍了 **Playwright** 的相关用法。

8、[nogil 项目和 Faster CPython 项目](https://lwn.net/Articles/939981/)

Python 官方虽已宣布会接受 **PEP-703**，但是最终版本或许要等到 5 年后的 3.17 版本。从 2021 年起，nogil 和 Faster CPython 项目持续吸引大家的关注，这篇文章梳理了它们两年来的发展情况、一些关键性问题的处理方案和重要进展、近期社区和大公司的回应等。（附：[Python 官方第一次针对 nogil 的研讨会](https://pythoncat.top/posts/2021-11-14-GIL)、[Faster CPython 项目的首次亮相](https://pythoncat.top/posts/2021-05-16-Guido)）

9、[简单介绍 Python 的永生对象](https://engineering.fb.com/2023/08/15/developer-tools/immortal-objects-for-python-instagram-meta/)

Instagram 向 Python 贡献了 3.12 版本中的 [PEP-683](https://peps.python.org/pep-0683/)（永生对象，使用固定的引用计数），它可以绕过引用计数检查，这是多核 Python 并行处理的重要基础。文章介绍了 Instagram 遇到的内存使用问题、为解决问题而引入永生对象、并最终贡献到 CPython 的故事。

![增加共享内存，减少私有内存和写时复制](./img/2023-08-19_immortal.png)

10、[为什么要避免在 Python 中用“import *”？](https://pybit.es/articles/why-you-should-avoid-import-in-python/)

Python 中一个文件是一个模块，拥有自己的命名空间。当使用“import *”时，这会导致“**命名空间污染**”！文章指出了遵循 PEP-8 风格的正确写法，同时建议应该用`__all__` 来定义模块中可被导出的变量名。

11、[让我们终结 Python 的依赖地狱](https://prefix.dev/blog/launching_pixi)

[pixi](https://github.com/prefix-dev/pixi) 是最新发布的用 Rust 编写的 Python 包管理器，这篇文章出自其官方博客，主要介绍为什么要开发这个项目、它提供了哪些功能、它的基本执行过程。项目当前基于 Conda 生态，暂不支持 PyPI。

12、[使用 Django Rest Framework 实现 JWT 身份验证](https://pythonguides.com/jwt-authentication-using-django-rest-framework/)

一篇非常详细的教程，介绍了 JWT 是什么以及它的工作原理，演示了如何用 DRF 实现 JWT 身份验证的全过程。

13、[增强 Django 程序：提升数据库查询的 7 个妙招](https://johnnymetz.com/posts/slow-django-database-queries/)

数据库查询是影响 Web 程序性能的主要因素之一，这篇文章介绍了 7 个提升性能的技巧：设置查询语句的超时时间、使用`assertNumQueries` 测试查询数、使用`nplusone` 捕获 N+1 查询、使用`django-zen-queries` 捕获 N+1 查询、避免对预取对象作新的查询、使用 `defer()` 防止获取大的未使用字段、避免在大字段上使用 `distinct()` 。

14、[可能让你大吃一惊的奇怪的 Python “特性”](https://martinheinz.dev/blog/103)

有时候我们会在编程语言中看到一些奇怪的现象，它们可能是一些非常冷门的“特性”，也可能会让人误以为是 bug 或者因理解错误而造成 bug。作者介绍了他的几个小发现。

15、[可汗学院如何将 Python 后端重写成 Go？](https://blog.quastor.org/p/khan-academy-rewrote-backend)

可汗学院使用 Python 做了 10 年的主力语言，然而在 2020 年前后彻底转向了 Go 阵营。这篇文章介绍了它为什么以及如何将 Python 2 后端整体重构成 Go 服务。文中引用了可汗学院总结性的一系列博客，可作延伸阅读。

16、[为什么静态语言会面临复杂性的挑战？](https://hirrolot.github.io/posts/why-static-languages-suffer-from-complexity.html#the-unfortunate-consequences-of-being-static)

这是一篇思考编程语言该如何设计的长文！作者指出现代编程语言存在“**静态-动态双形性**”问题，提出理想的编程语言应该同时具有静态和动态的特性。文章分析了 **Idris** 和 **Zig** 两种语言的做法，并指出其局限性，最后提出应该重新思考编程语言。

### 🐿️项目&资源

1、[pixi：Rust 开发的基于 Conda 的包管理器](https://github.com/prefix-dev/pixi)

一个基于 Conda 生态的包管理器，支持所有操作系统，支持多种语言的 Conda 包，拥有类似 Cargo 的命令行界面，完全用 Rust 编写。支持按照项目来安装包，也支持全局安装，此行为类似于 **pipx** 和 **condax**。

![pixi的使用演示](./img/pixi.png)

2、[briefcase：将 Python 项目转换为独立的应用](https://github.com/beeware/briefcase)

支持打包成 Mac、Windows、Linux、Android 和 iPhone 的应用，以及使用了 PyScript 作客户端的静态 Web 站点。（star 2K）

3、[facechain：可生成数字分身的深度学习工具链](https://github.com/modelscope/facechain)

上周的热门项目，仅需三张照片即可生成个人的数字分身。底层使用了 Stable Diffusion 的文生图功能，训练时可选择多种风格的 LoRA 模型，也支持添加个性化的 prompt，实现变装效果。（star 3.2K）

4、[modelscope：将 Model-as-a-Service 概念变为现实](https://github.com/modelscope/modelscope)

“模型即服务”（MaaS）汇集 AI 社区中最先进的机器学习模型，并简化在实际应用中使用 AI 模型的流程。它已有 700+ 模型，涵盖自然语言处理、计算机视觉、语音、多模态等。（star 3.6K）

5、[viberary：基于语义的书籍搜索引擎](https://github.com/veekaybee/viberary)

不是根据体裁和书名等常规条件，而是根据提示语来搜索相关的书籍。基于[双塔语义检索模型](https://blog.reachsumit.com/posts/2023/03/two-tower-model/) ，使用 DuckDB 在本地训练数据，使用 Redis Search 模块作检索，通过 Flask API 和 Bootstrap 前端展示结果。

![书籍搜索的处理流程](./img/tactical_app.png)

6、[polar：帮助开源维护者获得更好的资助](https://github.com/polarsource/polar)

它为开源维护者搭建一个平台，可便捷地设置、运营、推广面向支持者的增值及订阅服务，帮助开发者从开源项目中获取收入。这个项目已获得 180 万美元的种子轮投资。

7、[youre-the-os：一个游戏，让你扮演操作系统！](https://github.com/plbrault/youre-the-os)

一个很有意思的游戏！你需要扮演操作系统，管理进程、内存和 I/O 事件，不能让进程空闲太久，不然就 game over！项目依赖 Python 3.11 和 **pipenv**，也可以上这个网站[在线体验](https://plbrault.github.io/youre-the-os/) 。（star 1K）

![游戏过程的截图](./img/in_game_screenshot.png)

8、[learndb-py：通过从头实现数据库来学习](https://github.com/spandanb/learndb-py)

这个项目从头实现一个关系型数据库，借鉴了 **sqlite** 数据库。关键的特性：支持丰富的 sql、使用`lark` 构建自定义词法分析与解析器、支持用户和代理方式连接、实现 BTree 作数据存储。

9、[mpire：比标准库更快的多进程开发库](https://github.com/sybrenjansen/mpire)

比其它多进程库更快，且功能更多：结合了 `multiprocessing.Pool` 使用写时复制的共享对象的优点、有丰富的状态管理功能、使用 tqdm 实现进度条、支持在仪表板查看进度，等等。（star 1.5K）

10、[diaphora：二进制文件的差异比对工具](https://github.com/joxeankoret/diaphora)

如何比对一个软件在两个版本间的差异？比较二进制软件的差异时，涉及哪些匹配技术？这个项目号称是目前最强的软件差异比对工具！（star 3.1K）

![iOS 9.3.5 修复一个内核漏洞的截图](./img/diaphora.png)

11、[beartype：近实时的静态类型检查工具](https://github.com/beartype/beartype)

一个近实时（NRT）的纯 Python 运行时类型检查工具，将 Rust 和 C++ 的零成本对象带入动态类型的 Python 世界。它可有选择性地将 Python 的鸭子类型转换成静态类型，同时默认保留前者的优点。项目文档中称“你可以同时像鸭子一样嘎嘎叫，以及像熊一样咆哮”！（star 2K）

12、[cs_books：AzatAI 推荐的计算机科学书籍](https://github.com/AzatAI/cs_books)

这个仓库收录了 200 多本计算机科学类书籍，仅限教育用途！

### 🐢播客&视频

1、[超越 PEP-8 -- 漂亮易懂代码的最佳实践](https://www.youtube.com/watch?v=wf-BqAjZb8M)

这个视频出自 PyCon 2015，介绍如何写出优雅的 Python 代码。在油管上已有 8200+ 点赞。演讲者 Raymond Hettinger 参与贡献了大家熟知的很多 Python 特性，比如 enumerate() 函数、生成器表达式、OrderedDict()、条件表达式、set 对象等。

2、[只需 5 个步骤，将“勉强能用”的代码变成 Pythonic](https://www.youtube.com/watch?v=spi0N_PNznE)

写出能用的代码不应该成为最终目标，这只是一个开始！这个视频使用了\_\_getitem\_\_、\_\_len\_\_、\_\_enter\_\_ 和 \_\_exit\_\_ 等魔术方法，将难以维护的代码重构得 Pythonic。作者自称这是对上一则分享的 8 分钟浓缩版。

## 17 Excel 终于支持 Python 了、Meta 重磅开源新项目、Mojo 新得 1 亿美元融资 

[博客原文](https://pythoncat.top/posts/2023-08-26-weekly) | 发布时间：2023-08-26

### 🦄文章&教程

1、[Excel 终于支持 Python 了！](https://techcommunity.microsoft.com/t5/microsoft-365-blog/introducing-python-in-excel-the-best-of-both-worlds-for-data/ba-p/3905482)

本周的重磅新闻！微软将 Python 引入到 Excel 中，支持在 Excel 中使用 Python 强大的数据分析、统计建模以及数据可视化库（**pandas、statsmodels、Matplotlib 和 seaborn** 等）。Guido 发推表示他参与了这个项目。

2、[如何使用 FastAPI 与 aiohttp 进行 SSE 响应开发？](https://juejin.cn/post/7269969188391600128)

Server-Sent Events（服务器推送事件）可以让服务端一边生成内容，一边将数据返回给客户端。文章介绍了 FastAPI 如何使用 SSE 方式返回数据，并用 **requests 和 aiohttp** 来获取与展示接口数据。

3、[用 FastAPI 和 Hamilton 实现的 PDF 摘要工具](https://blog.dagworks.io/p/containerized-pdf-summarizer-with)

文章使用 FastAPI、Hamilton、Streamlit 和 ChatGPT 开发了一个 PDF 文件摘要工具，介绍了项目的设计思路、架构设计与编程实现，效果图如下：

![PDF摘要工具的效果图](./img/2023-08-26_pdf.png)

4、[放弃 Python 拥抱 Mojo？鹅厂工程师真实使用感受](https://juejin.cn/post/7270363281117102099)

Mojo 是 **LLVM** 作者发布的一门新语言，完全兼容 Python 的语法。这篇文章上手体验了 Mojo 编程，对比 Python 讨论了它的一些语法、特性以及当前存在的问题。

5、[Mojo 如何获得比 Python 快 35000 倍的加速？](https://www.modular.com/blog/how-mojo-gets-a-35-000x-speedup-over-python-part-1)

Mojo 在生成曼德博集合时比 Python 快 35000 倍，这篇文章介绍了为什么要选用曼德博算法作衡量，以及 Mojo 语言做了哪些优化来实现高性能？（附：Mojo 所属的公司 **Modular** 本周宣布获得 1 亿美元融资，总融资已达到 1.3 亿美元！！）

6、[APL 语言教会我的那些 Python 知识](https://mathspp.com/blog/what-learning-apl-taught-me-about-python)

APL 是在 1960 年代开发的一种高度符号化的编程语言，作者在学习这门语言后，反而加深了对 Python 编程的理解。作者受到触动的只是简单的一行代码，但它包含了内置函数、布尔值、数据驱动、列表推导式等 Python 优雅编程的要素。（附：[从这 27 门编程语言中，也可以加深对 Python 的理解](https://pythoncat.top/posts/2021-12-13-languages)）

7、[深度解析 Jupyter 的内核架构](https://www.romaglushko.com/blog/jupyter-kernel-architecture/)

Jupyter Notebooks 非常强大，它是如何做到的呢？这篇文章分析了 Jupyter 架构的内核以及一些有趣的实现细节，包括代码的执行工作流、代码解析执行、自动补全、代码检查、调试、虚拟输入、客户端和网关等。作者预告后续还会解析 **Jupyter Server、JupyterLab、JupyterHub、Jupyter Enterprise Gateway** 等项目。

![Jupyter的内核架构](./img/jupyter-kernel-overview.png)

8、[Fixit 2：Meta 的下一代自动修复 linter](https://engineering.fb.com/2023/08/07/developer-tools/fixit-2-linter-meta/)

Meta 开源的 linter 工具 [Fixit](https://github.com/Instagram/Fixit) 发布了2.0 版本，它支持自动修复问题，支持用户自定义 lint 规则。这篇文章介绍了 Meta 在使用 Flake8 时遇到的问题、为什么要开发 FIXit，以及为什么要重构出 Fixit 2 这个新版本？

9、[使用 Python 构建代码图像生成器](https://realpython.com/python-code-image-generator/)

一篇超级详细的全栈实战教程，涉及技术有 **Flask、Jinja、Playwright、Pygments 和 Javascript**，实现的是一个代码-图片生成器，也就是可以给代码片段添加样式并生成美观的图片。

10、[apipkg 教程：Python 中的增强延迟加载](https://coderslegacy.com/apipkg-tutorial-enhanced-lazy-loading-in-python/)

周刊第 16 期分享了一篇 importlib 实现延迟加载的文章，这篇文章中的 apipkg 也能实现同样的效果，但用法稍有不同，可以对照学习。

11、[当 asyncio、twisted、tornado 和 gevent 一起走进酒吧...](https://www.bitecode.dev/p/asyncio-twisted-tornado-gevent-walk)

当谈到 Python 并发时，就离不开标题的这些库。文章介绍和对比了这几个库，讨论了它们的设计与使用。那么，该使用哪个异步库呢？

12、[Python 标准化锁定文件的现状](https://snarky.ca/state-of-standardized-lock-files-for-python-august-2023/)

作者想给 Python 提供一种标准化的依赖包锁定文件，曾在 2021 年发起了 [PEP-665](https://peps.python.org/pep-0665/) ，但因为缺少对 sdist 的支持而被拒绝了。作者现在做了一些概念验证的事情，计划有 5 步，目前进展到第 3 步。（附：本月新发起的 [PEP-725 – 在 pyproject.toml 中指定外部依赖项](https://peps.python.org/pep-0725/)）

13、[Python：只需编写 SQL](https://joaodlf.com/python-just-write-sql)

作者看到 Go 编程时不喜欢用 ORM，因此也想尝试不用 ORM 而在 Python 中直接写 SQL。这种回归传统做法的主要问题是会混淆数据库操作与业务逻辑，但并不是不可行。

14、[Python 中如何比较不兼容的类型？](https://stackabuse.com/incompatible-type-comparisons-in-python/)

一篇很详细的基础教程，探讨了`TypeError` 的含义、出现的原因以及解决方法。文章非常之细致，介绍了 20 多种容易出错的场景，有些是初学者问题，但也有些是老手也易忽视的编程细节。

15、[使用 Python 开发一个文件比较工具](https://florian-dahlitz.de/articles/create-your-own-diff-tool-using-python)

有很多版本管理和差异比较工具，但是能否用 Python 开发一个简单的工具实现呢？文章使用 **difflib、argparse 和 HtmlDiff** 分别开发了命令行工具和 HTML 网页两个版本的文件比较工具。

16、[我最喜欢的素数生成函数](https://eli.thegreenplace.net/2023/my-favorite-prime-number-generator/)

埃拉托斯特尼筛法是一种生成素数的算法，作者提供了一个 Python 实现，但是代码的性能和内存占用是主要的问题，因此作者做了一些优化改进，最后给出了一个有详细注释的优化版本。

### 🐿️项目&资源

1、[codellama：Meta 最新开源的代码生成模型](https://github.com/facebookresearch/codellama)

本周最火的开源项目！**Code Llama** 基于 **Llama 2**，可免费商用，可预见不久的将来会出现大量的编程工具！目前支持的语言包括 Python、C++、Java、PHP、Typescript/Javascript、C# 和 Bash。值得一提的是，它包含一个“**Code Llama – Python**”专用版本，基于 100B  token 微调！（star 4K）

2、[seamless_communication：最先进的语音和文本翻译的基础模型](https://github.com/facebookresearch/seamless_communication)

**SeamlessM4T** 也是 Meta 开源的项目，旨在提供高质量的翻译，让不同语言的人通过语音和文本轻松交流。支持 101 种语言的语音输入、96 种语言的文本输入与输出、35 种语言的语音输出。（star 3.7K）

3、[Torchscale：(M)LLM 的基础架构](https://github.com/microsoft/torchscale)

微软开源的一个 PyTorch 库，可让开发者高效地扩展 **Transformers**，聚焦于提升建模的能力与通用性，同时提升训练的稳定性与效率。（star 2.4K）

4、[fastapi-best-practices：FastAPI 的最佳实践](https://github.com/zhanymkanov/fastapi-best-practices)

这个 Github 项目是一篇集合了 20 多项 FastAPI 最佳实践的长文，包括项目结构、数据校验、解耦与重用依赖、遵循 REST、文档、linter 等等话题。（star 4.5K）

5、[yappi：又一个 Python Profiler，支持多线程、asyncio 和 gevent](https://github.com/sumerc/yappi)

yappi 是 PyCharm 默认的性能分析器之一，它是用 C 编写的，支持多线程、asyncio 和 gevent，可以显示挂机时间与实际 CPU 时间。（star 1.2K）

6、[funNLP：几乎最全的中文 NLP 资源库](https://github.com/fighting41love/funNLP)

一个非常丰富的资料库，包含 NLP/人工智能的大量内容。（star 55.7K）

7、[prettymapp：在 Web 应用中创建精美的地图](https://github.com/chrieke/prettymapp)

这是一个 Web 应用和 Python 包，可从 **OpenStreetMap** 获取数据生成漂亮的地图作品。它基于另一个有 10K star 的项目 [prettymaps](https://github.com/marceloprates/prettymaps) ，主要简化了配置、降低代码复杂性、并使用 streamlit 开发了 Web 端应用。（star 1.7K）

![美观的地图](./img/2023-08-26-barcelona.png)

8、[pycparser：纯 Python 实现的完整 C99 解析器](https://github.com/eliben/pycparser)

一个用 Python 写的 C 语言解析器，可轻松集成到需要解析 C 源代码的程序中。它最主要的用途是在 **cffi** 库中，用于解析 C 函数和类型的声明。（star 3K）

9、[quivr：生成式 AI 打造你的第二大脑](https://github.com/StanGirard/quivr)

利用生成式 AI 来存储和检索非结构化的信息，可以理解成支持人工智能的  Obsidian。可以处理各种形式的文件如文本、图片、代码、音频和视频等，依赖于 ChatGPT、Docker、Supabase，只支持操作系统是 Ubuntu 22+。（star 21.7K）

10、[KeymouseGo: 类似按键精灵的鼠标键盘录制和自动化操作](https://github.com/taojy123/KeymouseGo)

一个中文项目。记录用户的鼠标键盘操作，通过触发按钮自动执行之前记录的操作，可设定执行的次数，可以理解为精简绿色版的**按键精灵**。支持 Windows、Linux 和 Mac 系统。（star 4.3K）

11、[ahkunwrapped：集成 AutoHotkey，用 Python 执行自动化](https://github.com/CodeOptimist/ahkunwrapped)

**AutoHotkey** 是一种自动化脚本语言和工具，用于在 Windows 上创建快捷键、宏和自动化任务，例如模拟按键和鼠标操作、窗口管理、剪贴板操作、自动化表单填写等。这个项目覆盖了 AutoHotkey API，使用 Python 来桥接，扩展 AutoHotkey 的能力。

12、[100+ AI/机器学习/深度学习/计算机视觉/NLP 项目与代码](https://github.com/ashishpatel26/500-AI-Machine-learning-Deep-learning-Computer-vision-NLP-Projects-with-code)

这个仓库收录了很多学习资源，其中很多也是一些聚合类的项目，也就是说实际包含的项目与资料有上万之多。（star 13.2K）

13、[trafilatura：一个采集 Web 文本的工具](https://github.com/adbar/trafilatura)

一个 Python 包和命令行工具，可以处理 Web 的文本信息，并转化成各种常用格式输出。包含爬虫功能、HTML 解析、网页内容萃取等等。（star 1.9K）

### 🐢播客&视频

1、[2023 年 PyCon 澳大利亚的 84 个视频](https://m.youtube.com/playlist?list=PLs4CJRBY5F1KwxIxbTmhN9jX4hBtE-OKJ) 

澳大利亚今年 PyCon 上的演讲视频。目前已发布 84 个视频。

![](./img/2023-08-25_pycon_au.png)

2、[2023 年 Pycon 以色列的 23 个视频](https://www.youtube.com/playlist?list=PLnOlTVPC-yFwhpiyjsC0V_98pqRbtwNgh)

以色列今年 PyCon 上的演讲视频。目前已发布 23 个视频。

![](./img/2023-08-25_pycon_israel.png)

3、[2023 年 SciPy Talk 的 44 个视频](https://www.youtube.com/playlist?list=PL1PbeFStIOoOd01KhBeba-byU5E5dJ716)

SciPy Talk 是科学计算领域的年度会议，通常涵盖数据分析、机器学习、人工智能、科学可视化等话题。目前已发布 44 个视频。

![](./img/2023-08-25_scipy2023.png)

### 🥂讨论&问题

1、[如果只懂 Python，如何构建 Web 程序的前端？](https://www.reddit.com/r/Python/comments/15z1amc/how_to_build_the_front_end_of_a_web_app_if_you/)

独自一人开发，想要快速实现全栈的 SaaS 应用，支持用户身份验证、订阅、付款等业务功能，前端该如何选择呢？Reddit 上的这个帖子，或许能给你提供一些思路/方法。

2、V2EX 上三则关于 Python 后端的热门讨论

近期在 Python 节点下最热闹的三篇帖子：[Python 后端该如何提升自己呢？](https://www.v2ex.com/t/962899) 、[深夜睡不着，思考为什么国内 Python Web 后端太少](https://www.v2ex.com/t/965956) 、[Python 做后端，相对于 Java 或者 go 来说，到底差在哪？](https://www.v2ex.com/t/966460) 从就业的角度来看，Python 后端在国内确实偏少，不仅后端，其它领域也有一种“热度退潮”的感觉（除了 AI 相关）。Python 潮流周刊的创刊想法之一就是去欧美盗火，为国内 Python 社区注入活力。愿论坛里将来能少一些沮丧性的、要抛弃 xx 另附高枝的情绪吧。

## 18 Flask、Streamlit、Polars 的学习教程 

[博客原文](https://pythoncat.top/posts/2023-09-02-weekly) | 发布时间：2023-09-02

### 🦄文章&教程

1、[一份深入探索 Flask 的指南](https://testdriven.io/guides/flask-deep-dive)

由系列文章组成的 Flask 学习指南，深入了解 Flask 的内部结构、核心特性和功能，涵盖主题有程序和请求上下文、Werkzeug、会话、安全（防CSRF）、测试、2.0 版本的异步等。

2、[使用 PyMuPDF 识别与提取表格](https://artifex.com/blog/table-recognition-extraction-from-pdfs-pymupdf-python)

识别和处理 PDF 文件中的表格是件困难的事，PyMuPDF 最新版本 1.23.0 提供了从 PDF 中提取表格的功能！可以将提取内容交给 pandas 处理，可以导出 Excel 和 CSV 格式的文件。

3、[深入介绍 Python 3.12 中的永生对象](https://codeconfessions.substack.com/p/understanding-immortal-objects-in)

周刊[第 16 期](https://pythoncat.top/posts/2023-08-19-weekly)分享了 Instagram 在 Python 3.12 引入永生对象的故事，而这里分享的文章深入剖析解释器源码，为我们回答了以下问题：为什么要引入永生对象？它对性能有什么影响？它是如何实现的（如 None 对象和小整数），如何做到兼容旧版本的接口的？

4、[Python 中下划线的十种用法](https://mathspp.com/blog/pydonts/usages-of-underscore)

你知道 Python 中的下划线有哪些用法么？这篇文章介绍了：REPL 中的用法、作变量名的前缀和后缀时的四种用法、作为赋值“接收器”的两种用法、新 match-case 语法中的用处、用作频繁调用的函数别名、大额数字中增加可读性。

5、[Python Asyncio 之网络编程方法详解](https://so1n.me/2023/08/29/python_asyncio_lib_network/)

Asyncio 不仅提供了简单的`Socket`接口，还基于它提供了`Protocol`&`Transport`接口以及更高级的`Stream`接口，大大的减轻了开发者进行网络编程的心理负担。文章主要介绍了这几个接口的简单使用以及对应的原理分析。

6、[给初学者的 Streamlit 学习指南](https://dev.to/codemaker2015/streamlit-cheatsheet-for-beginners-706)

Streamlit 是一个用于创建和部署 Web 程序的框架，广泛用于机器学习和数据科学领域。这篇教程介绍了它的安装以及常用组件的使用。

7、[如何在 FastAPI 应用中使用 Tailwind CSS 和 SQLAlchemy](https://ezzeddin.hashnode.dev/fastapi-tailwind-sqlalchemy)

FastAPI 是一个轻量级框架，通常需要集成其它组件搭配使用。这篇文章介绍了如何将 FastAPI 与 Jinja2 模板引擎、Tailwind CSS 以及 **SQLAlchemy** 结合，创建出一个好用的开发脚手架。

8、[Python 如何不作排序但保持数据有序](https://www.bitecode.dev/p/how-not-to-sort-in-python)

文章介绍了 Python 堆排序/优先队列、二分查找、有序容器的相关使用，它们有更好的时间复杂度或适用场景，是比暴力搜索和暴力排序更值得采用的解决方案。

9、[用 Django 发送带有验证链接的电子邮件](https://delighto.hashnode.dev/send-verification-email-django)

我们经常会在注册一些账号后收到一封验证邮件，只有在链接的有效期内点击它才能完成账号注册。这篇教程介绍了如何用 Django 来实现这个功能，这是一个简短而完整的练手项目。

10、[探索全球多样性：Pyetho — 用于了解国家及其语言的 Python 库](https://medium.com/@i18nsolutionspy/exploring-global-diversity-pyetho-python-library-for-language-and-country-insights-4a688958ea83)

文章介绍了[Pyetho](https://github.com/i18nsolutionspy/Pyetho) 这个库的基本使用，它主要包含了全球国家及其语言的相关信息，采用 ISO 标准。收录有 195 个国家，我查询了下，中国有 285 种语言。除了国家和语言基本信息外，其它功能包括：查询某种语言的使用人数、查询某种语言在哪些国家使用、查询某种语言的谱系家族、查询所有的语言家族，等等。

11、[Polars：快如闪电的 DataFrame 库](https://realpython.com/polars-python/)

Polars 是数据分析领域的新秀，底层是用 Rust 写的，拥有超高性能。这是一篇详细的教程，内容包括：它的 DataFrame、表达式和上下文、惰性 API（LazyFrame）、与外部数据源集成、与 Numpy 和 pandas 的集成，等等。

12、[深入学习数据结构与算法：C++、Swift、Python、Java、C#、JavaScript](https://dev.to/khaledhosseini/data-structures-and-algorithms-for-multi-language-programmers-c-swift-python-java-c-javascript-alp)

超长文预警！文章探索了不同编程语言中常见数据结构的实现，使用简洁的动画和图表直观介绍了相关的知识。主要涉及线性数据结构，如数组、动态数组、链表、循环链表、栈、队列、哈希表、集合，等等。数据结构当然离不开算法和时间复杂度，文中也有对应介绍。

### 🐿️项目&资源

1、[fastapi-users：开箱即用的 FastAPI 用户管理库](https://github.com/fastapi-users/fastapi-users)

为 FastAPI 添加用户注册与身份验证模块，主要特性有：可扩展的用户模型、注册/登录/重置密码/邮箱验证、OAuth2 登录流程、可定制的数据库后端、支持多种身份验证，等等。（star 3.3K）

2、[upiano：命令行里的钢琴](https://github.com/eliasdorneles/upiano)

在命令行里弹钢琴是种什么体验？！安装这个库后，你就可以用鼠标和键盘来弹钢琴了。

3、[hrequests：requests 库的替代品](https://github.com/daijro/hrequests)

一个比 requests 库更简单、可配置、功能丰富的库，使用 gevent 实现高性能并发，支持 HTTP/2，JSON 序列化比标准库快 10 倍，代码使用类型提示，100% 线程安全。

4、[wisdomInterrogatory：智海-录问法律大模型](https://github.com/zhihaiLLM/wisdomInterrogatory)

由浙江大学、阿里巴巴达摩院以及华院计算共同设计研发的法律大模型，以“普法共享和司法效能提升”为目标。模型基座是 Baichuan-7B，预训练的数据包括法律文书、司法案例以及法律问答数据，共 40 G。

![](./img/2023-09-02-wisdomInterrogatory.png)

5、[awesome-systematic-trading：一个精选的系统化交易列表](https://github.com/edarchimbaud/awesome-systematic-trading)

系统化交易/量化交易是依据规则和算法进行自动化交易的策略，这个仓库收录了一系列资源：库、软件、策略、书籍、博客、论文、视频，等等。（star 1.1K）

6、[Qwen-VL：阿里通义千问-VL 模型的官方库](https://github.com/QwenLM/Qwen-VL)

**Qwen-VL** 是阿里云研发的大规模视觉语言模型，可以以图像、文本、检测框作为输入，并以文本和检测框作为输出。支持多语言、多图交错对话。评测结果显示，Qwen-VL 在多个 VL 任务上相比目前 SOTA 的 Generalist Models 都有明显优势。

7、[h2ogpt：私人文档+图像的问答](https://github.com/h2oai/h2ogpt)

查询和总结你的文档，或者与本地私有的 GPT LLM 聊天。支持大部分文档，支持 LLaMa2、Falcon、Vicuna、AutoGPTQ、LORA 等，支持 Linux、Docker、MAC 和 Windows。（star 7.2K）

8、[refact：开源编码助手，支持自动补全、代码重构、代码分析](https://github.com/smallcloudai/refact)

Copilot 的开源替代方案，可自托管或使用云服务。支持 starcoder、starchat、llama2、wizardlm 等开源模型，支持代码补全、重构、解释、分析、优化与修复错误等功能。

9、[dify：创建自己的 AI 应用](https://github.com/langgenius/dify)

dify 是 Do It For You 的简写，是一个易用的 LLMOps 平台，支持快速创建出自己的 AI 应用。核心能力：通过 Langchain 支持主流的大语言模型（包括讯飞星火、文心一言、通义千问）、可视化编排 Prompt、支持添加数据集、支持插件、支持数据标注与改进。（star 8K）

10、[dara：轻松创建交互式 Web 应用程序](https://github.com/causalens/dara)

一个低代码开发框架，与 Plotly Dash、Streamlit 和 Shiny 相似，支持快速创建仪表板应用。后端使用 FastAPI，前端是一个基于 React  的 UI。

![dara创建应用示例](./img/2023-09-02_dara.png)

## 19 Mojo 终于提供下载了！ 

[博客原文](https://pythoncat.top/posts/2023-09-09-weekly) | 发布时间：2023-09-09

### 🦄文章&教程

1、[Mojo🔥 终于提供下载了！](https://www.modular.com/blog/mojo-its-finally-here)

Mojo 语言是今年发布的“高性能的 Pyhton++”，周刊第 17 期刚分享过它获得了 1 亿美元融资，这周它就发布了 Linux 版本的安装包。除了编译器功能，它还提供了一些 IDE 工具（终端 shell、VS Code 插件、Jupyter 内核），暂不支持调试，暂无 Mac 和 Windows 版本。

2、[我们能从 PEP-703 中学到什么？](https://www.cnblogs.com/apocelipes/p/17679741.html)

PEP-703 是 no-gil 项目的提案，我们曾多次介绍过。作者讨论了该 PEP 中的一些话题，例如尽量少依赖原子操作的引用计数、延迟的引用计数、gc 不再会分代、对象锁等，从中能看出 Python 社区在性能和兼容性上的权衡。

3、[用 500 行 Python 代码写一个 C 语言编译器](https://vgel.me/posts/c500/)

实现一个 C 语言编译器需要多少行 Python 代码？文章介绍了编译器的架构、代码解析与生成流程，尝试用 500 行代码实现了一个简易的 C 编译器。

4、[简单介绍如何用 Python 作协议缓冲区编程](https://www.blog.pythonlibrary.org/2023/08/30/an-intro-to-protocol-buffers-with-python)

协议缓冲区（**Protocol buffer**）是一种与语言无关的数据序列化格式，类似于 Python 的 pickle 格式。文章介绍了如何用 Python 创建与编译协议缓冲区文件，并与支持该协议的其它语言进行通信。

5、[用 Python 和 matplotlib 创建漂亮的极坐标直方图](https://dev.to/oscarleo/how-to-create-a-beautiful-polar-histogram-with-python-and-matplotlib-400l)

极坐标直方图（**Polar Histogram**）是一种用于可视化和分析数据分布的图表形式，它将数据划分为多个扇区，每个扇区的长度或面积表示该角度范围内数据的频率或数量。文章介绍了如何 Python 绘制极坐标直方图。

6、[布隆过滤器图解与 Python 实现](https://codeconfessions.substack.com/p/bloom-filters-and-beyond)

布隆过滤器（**Bloom Filter**）是一种数据结构，可用于快速判断一个元素是否存在于一个集合中，场景的使用场景：去重、缓存与快速查询、防止缓存穿透、过滤垃圾邮件等。文章介绍了它是什么、如何操作、Python 实现、如何调整布隆过滤器等。

7、[Python 中的堆数据结构：最小和最大堆实现](https://favtutor.com/blogs/heap-in-python)

堆（**Heap**）是一种重要的数据结构，常用于快速访问最值、堆排序、调度与分配任务、图算法、数据压缩与编码等。文章介绍了它的基本概念、如何用 Python 实现最大堆和最小堆、它们的区别。

8、[Python 容器化部署教程](https://developers.redhat.com/articles/2023/09/05/beginners-guide-python-containers)

容器是一种轻量级的虚拟化技术，可实现 Python 程序的高效打包与部署。Red Hat 的这篇教程介绍了如何用 **Podman** 来构建、运行和管理 Python 容器。

9、[2023 年 Python 包管理的实践指南](https://robamu.github.io/posts/packaging-python-in-2023/)

这篇文章梳理了当前 Python 包管理时比较适用的一些最佳实践，例如使用 pyproject.toml、使用 setuptools 作分发和构建工具、用 Sphinx + reStructuredText + sphinx-rtd-theme 编写文档、用 CHANGELOG 列出版本更改、使用 black 和 flake8 等。

10、[记一次 Python 应用内存泄漏问题定位](https://juejin.cn/post/7274626136328536116)

作者使用 Airflow 作为任务调度器，上线后每隔一段时间就出现 Scheduler 内存 OOM 问题，这篇文章详细记录了问题定位分析的过程。介绍了三个工具：**objgraph、pympler、tracemalloc**。

11、[介绍 flake8-logging](https://adamj.eu/tech/2023/09/07/introducing-flake8-logging/)

作者认为标准库`logging` 比较难用，加上在程序错误时经常会缺少必要的日志，因此开发了 flake8-logging 插件。它有 12 条规则，这篇文章介绍了 3 条：使用 logging.getLogger() 实例化记录器、在异常处理时使用 exception()、避免预先格式化日志信息。 

12、[Falcon 180B 正式在 Hugging Face Hub 上发布](https://segmentfault.com/a/1190000044189692)

Falcon 作为当前最大的开源大模型，有 180B 参数并且是在在 3.5 万亿 token 的 TII RefinedWeb 数据集上进行训练，是目前开源模型里最长的单波段预训练。文章介绍了它的优势以及入门使用。

### 🐿️项目&资源

1、[pkuseg-python：多领域中文分词工具，比 jieba 准确性更高](https://github.com/lancopku/PKUSeg-python)

不同于其它通用中文分词工具，它支持多领域分词、有更高的分词准确率、支持用户自训练模型、支持词性标注。准确性超过 **jieba、THULAC** 两个中文分词工具。（star 6.2K）

2、[pysentation：在 CLI 里显示演示文稿](https://github.com/mimseyedi/pysentation)

在命令行终端里制作和展示 presentation，支持标题、颜色、主题、放大、解释、快捷键等功能。

3、[compress：基于个人语料库的快捷输入工具](https://github.com/eschluntz/compress)

导入个人的语料库后，可以用缩写方式输入长串的内容。使用了 **Autokey** 来实现 Linux 的键盘快捷键。（star 1.3K）

4、[textbase：用于构建 AI 聊天机器人的简单框架](https://github.com/cofactoryai/textbase)

一个使用 NLP 和 ML 构建聊天机器人的框架，轻松开发和部署 Web 应用。计划集成短信、本地集成大语言模型（Claude、Llama）。（star 1.2K）

5、[reader：Python 开发的 feed 阅读器库](https://github.com/lemon24/reader)

功能丰富的 feed 阅读器，支持检索、存储和管理 Atom、RSS 和 JSON 源，支持标记文章为已读或重要、支持过滤 feed 和文章、支持全文搜索、支持统计用户活动、支持插件。

6、[Baichuan2：百川 53B 大模型在线对话平台](https://github.com/baichuan-inc/Baichuan2)

百川智能推出的新一代开源大语言模型，采用 2.6 万亿 Tokens 的高质量语料训练。在通用、法律、医疗、数学、代码和多语言翻译六个领域的中英文和多语言权威数据集上对模型进行了广泛测试。

7、[svcs：灵活的 Python 服务定位器](https://github.com/hynek/svcs/)

Python 的依赖注入容器，提供了一个注册类型/接口工厂的机制，通过自动清理和运行状况检查强制获取这些类型的实例。使用依赖注入和服务定位来实现控制反转，消除大量重复的样板代码。

8、[gpt_academic: 为 ChatGPT/GLM 提供实用化交互界面](https://github.com/binary-husky/gpt_academic)

GPT 学术优化，特别优化论文阅读/润色/写作体验，模块化设计，支持自定义快捷按钮&函数插件，支持 Python 和 C++ 等项目剖析&自译解功能，PDF/LaTex 论文翻译&总结功能，支持并行问询多种 LLM 模型，支持 chatglm2 等本地模型。兼容文心一言, moss, llama2, rwkv, claude2, 通义千问, 书生, 讯飞星火等。（star 41K）

## 20 三种基准测试的方法、为什么代码在函数中运行得更快？ 

[博客原文](https://pythoncat.top/posts/2023-09-16-weekly) | 发布时间：2023-09-16

### 🦄文章&教程

1、[三种对 Python 作基准测试的方法](https://superfastpython.com/benchmark-python-code/)

文章介绍了使用标准库对 Python 作基准测试的几种方法：time、timeit、cProfile 与 profile，详细介绍了几个工具的使用方法及测试数据的解读。

2、[舍弃 Poetry 和 PDM，切换成 Hatch](https://andrich.me/2023/08/switching-to-hatch/)

作者“移情别恋”了 Hatch，开始在项目中使用它。文章介绍了他喜欢 Hatch 的一些小亮点：环境隔离、命令脚本、可替代 **Tox**、可选的依赖项等。（附：[Python 任务自动化工具 tox 教程](https://pythoncat.top/posts/2020-01-06-tox)）

3、[TOML 文件格式有什么问题？](https://hitchdev.com/strictyaml/why-not/toml/)

TOML 是“改进的” INI 文件，是 Python 推荐的配置文件格式。文章提到，连 TOML 的作者也认为它是一种糟糕的格式！文章指出了它的问题：非常冗长、层次结构很难仅从语法推断、像 YAML 一样过于复杂、具有语法类型。

4、[用 Python 玩转遗传算法](https://joseprupi.github.io/misc/2023/08/19/playing_with_genetic_algorithms_in_python.html)

遗传算法（Genetic Algorithm）是一种受生物进化理论启发的优化算法，用于解决复杂的搜索和优化问题。文章用 Python 演示了这种算法的使用例子。

5、[现代 Python 的类型提示：Protocal 类](https://codebeez.nl/blogs/type-hinting-in-modern-python-the-protocol-class/)

Protocol 类是 Python 3.8 版本中引入的，用于指定一个类应该实现哪些方法，与 Java 的 Interface 相似。在保持 Python 动态类型用法的情况，使用 Protocal 可以获得部分静态类型检查的效果。

6、[tornado 的协程调度原理](https://dev.to/caipi/tornado-de-xie-cheng-diao-du-yuan-li-2h34)

Tornado 是一个高性能的 Web 框架，文章解读它的源码，主要想搞清楚：yield 暂存的状态到哪去了、重新恢复执行的“合适的时机”到底是什么、具体是怎么恢复执行的？

7、[可视化 CPython 发布过程](https://sethmlarson.dev/security-developer-in-residence-weekly-report-9)

文章基于 PEP-101 梳理了 CPython 的发布过程，绘制出了详细的流程图并给出关键步骤的解释。

![CPython构建与发布流程](./img/2023-09-16_cpython.png)

8、[如何用 PyObjC 与 Apple Vision 框架作文本识别](https://yasoob.me/posts/how-to-use-vision-framework-via-pyobjc/)

Apple 的 Vision 框架提供了一系列预训练的模型和 API，可快速在应用中添加图像分析和计算机视觉功能。PyObjC 可实现 Python 与 Objective-C 的交互。文章将它们结合，开发了一个文本处理项目。

9、[调试 Python 中正则表达式的灾难性回溯](https://krishnanchandra.com/posts/regex-catastrophic-backtracking/)

作者使用 py-spy 定位一个 CPU 100% 占用问题，找出了罪魁祸首的正则表达式，进而探讨灾难性回溯及其解决方法，并给出了优化性能的建议写法。

10、[使用 Django 和 HTMX 开发一个数据库搜索项目](https://www.photondesigner.com/articles/database-search-django-htmx)

一篇详细的 Django 项目教程，实现一个全栈的项目。文中有作者的教程视频。

11、[异步 SqlAlchemy 和多数据库管理](https://python-bloggers.com/2023/09/asynchronous-sqlalchemy-and-multiple-databases/)

利用 asyncio 和 SqlAlchemy 库，文章探讨了如何有效地连接和管理多个数据库，获得可扩展且具有弹性的架构。文章介绍了两种实现方法。

12、[Python Fire：自动生成命令行接口](https://juejin.cn/post/7278246015193464847)

Fire 是谷歌开源的一个用于生成 CLI 的库，Github 25K star。这篇文章介绍了它的一般命令、组合命令、链式命令、复杂命令等用法。

13、[我最爱的解 LeetCode 问题的 Python 技巧](https://www.jjinux.com/2022/08/python-my-favorite-python-tricks-for.html)

文章介绍了 Python 中的一些小技巧，从初级到高级，多数与数据结构相关，在解 LeetCode 问题时很有用。

14、[为什么 Python 代码在函数中运行得更快？](https://stackabuse.com/why-does-python-code-run-faster-in-a-function/)

Python 代码分别在函数和全局模块中运行，哪个更快呢？为什么是在函数中更快呢？Python 代码执行的工作原理是什么？如何测试与优化 Python 函数的性能？

### 🐿️项目&资源

1、[hatch：时髦的可扩展的 Python 项目管理库](https://github.com/pypa/hatch)

一个 Python 项目管理工具，有标准化构建系统、强大的环境管理、轻松发布到 PyPI、版本管理、响应式 CLI、比 pipenv 和 poetry 同类工具快约 2-3 倍。（star 4.4K）

2、[keep：开源的告警管理和自动化执行平台](https://github.com/keephq/keep)

可以将所有告警整合到一个管理平台中，并编排工作流以自动化执行端到端的流程。支持对接多种数据采集平台、数据库、办公软件等，可视化编排告警处理工作流。（star 2.2K）

3、[PyPI Data 网站：查看 PyPI 的各项数据](https://py-code.org/stats)

一个神奇的网站！包含 PyPI 的各类统计数据、曲线图和饼图，例如文件总数、总大小、一些功能特性的流行趋势等等。

![PyPI数据统计](./img/2023-09-15_pypi-data.png)

4、[strictyaml：类型安全的 YAML 解析和校验库](https://github.com/crdoconnor/strictyaml)

用于解析 YAML 的受限子集，拒绝解析丑陋的、难以阅读和不安全的 YAML 特性，有严格的标记验证和直接的类型转换，可替代 pyyaml、ruamel.yaml 和 poyo，有清晰可读的异常信息。（star 1.3K）

5、[facefusion：更先进的换脸工具](https://github.com/facefusion/facefusion)

最新开源的一个人像换脸库，star 涨得飞快！（star 6.9K）

6、[pyflyby：一套 Python 的生产力工具](https://github.com/deshaw/pyflyby)

包含一系列的小工具，功能包含用于命令行的 py、用于 IPython 的自动导入、添加缺失的 import、删除不用的 import、格式化 import、打印一组文件的 import、重命名导入，等等。

7、[instagraph：将文本内容或 URL 转换为可视化的知识图谱](https://github.com/yoheinakajima/instagraph)

可以提取复杂信息中的实体，生成它们的关系图谱。使用了 GPT-3.5，以及 Flask 来生成色彩友好的图例；响应式设计，可在任何设备上使用。

8、[textual-web：在浏览器中运行 TUI 和终端](https://github.com/Textualize/textual-web)

将 **Textual** 开发的 app 发布到网页上，也可以在浏览器中使用命令行终端。是个很有意思的项目。

9、[ziggy-pydust：用 Zig 语言构建 Python 扩展](https://github.com/fulcrum-so/ziggy-pydust)

一个开发框架，可打包用 Zig 编写的 Python 扩展模块，还包含一个 Pytest 插件可发现与运行 Zig 测试。集成了 Poetry，方便构建 wheel 和发布。支持缓冲区协议，可以实现零拷贝提升 Numpy 计算。

10、[MFTCoder：多任务微调代码大模型](https://github.com/codefuse-ai/MFTCoder)

一个开源的多任务代码大语言模型项目，包含代码大模型的模型、数据、训练等。在 HumanEval Benchmarks 的 Python Pass@1 取得了 **74.4%** 的开源 SOTA 成绩，超过 GPT-4。

## 21 如何提升及测量 Python 代码的性能？ 

[博客原文](https://pythoncat.top/posts/2023-09-23-weekly) | 发布时间：2023-09-23

### 🦄文章&教程

1、[在单核情况下加快 Python 代码速度](https://pythonspeed.com/articles/optimizing-dithering/)

文章使用弗洛伊德-斯坦伯格抖动算法为例，使用各种技巧来提升代码性能，实现将耗时从 2339 微秒逐步降低到 554 微秒。涉及的一些概念：指令级并行 （ILP）、分支预测、单指令多数据（SIMD）、内存层次结构等。

2、[使用 Radon 作 Python 的代码度量](https://www.blog.pythonlibrary.org/2023/09/20/learning-about-code-metrics-in-python-with-radon/)

一篇基础的入门教程，了解如何用 Radon 来衡量 Python 的代码复杂度，即计算圈复杂度等指标，介绍了相关命令的使用。

3、[Python（大部分）由语法糖组成](https://lwn.net/Articles/942767/)

Brett Cannon 写了一系列关于“语法糖”的博客，解析了 80 多个语法糖特性。文章基于他在 PyCon 的演讲及博客，介绍了其中的部分内容。

4、[迎接新的 SymPy](https://oscarbenjamin.github.io/blog/czi/post1.html)

SymPy 是一个用于符号计算（symbolic computation）的库，可以处理代数、微积分、离散数学等领域的问题。这是一个系列文章，介绍它将迎来的重大变化。文章描述了 SymPy 当前存在的速度问题、为加速它而作的工作、将来的提速计划。（附：[系列第二篇：SymPy 多项式计算](https://oscarbenjamin.github.io/blog/czi/post2.html)）

5、[使用 import-linter 让你的 Python 项目架构更整洁](https://www.piglei.com/articles/use-import-linter-to-lint-proj-arch/)

在依赖关系治理方面，[import-linter](https://github.com/seddonym/import-linter) 是一个非常有用的工具。它通过提供各种类型的“契约”，让我们得以将项目内隐式的复杂依赖关系，通过配置文件显式的表达出来。文章介绍了它的入门使用，以及 6 种修复依赖关系的技巧。

6、[CPython 如何用布隆过滤器作字符串处理？](https://codeconfessions.substack.com/p/cpython-bloom-filter-usage)

CPython 在处理字符串时使用了布隆过滤器，比如 splitlines()、strip() 两个函数，文章介绍了它们的实现原理。文章还介绍了典型布隆过滤器的实现原理，以及 CPython 中布隆过滤器的实现（不到 50 行 C 代码）。

7、[Python 中 UUID 的使用](https://medium.com/@m____b____/uuids-with-python-b133cead1b4c)

介绍了`uuid` 库的几个方法：uuid1() 利用系统 MAC 地址与时间戳生成 uuid；uuid4() 生成完全随机的 uuid；uuid3() 和 uuid5() 基于常量命名空间和变量名生成 uuid，前者使用 MD5 算法，后者使用 SHA-1 算法。

8、[为什么有这么多 Python Dataframe？](https://ponder.io/why-are-there-so-many-python-dataframes/)

为什么会有 Pandas、Polars、Dask 和 PySpark 等大量的 Dataframe 库？作者认为主要的原因是它的四种角色模型：电子表格、关系数据库、二维数组/矩阵、对象，以及由此衍生出的一系列问题。

9、[使用 Python 模拟“三门问题”](https://www.dataschool.io/python-probability-simulation/)

Monty Hall 问题也被称为三门问题，是一道挑战人们直觉的概率问题。文章使用 Python 来模拟这个问题，看看需要多久才能赢取奖品。

10、[6 件可以用 Functools 模块做的很酷的事](https://pybit.es/articles/6-cool-things-you-can-do-with-the-functools-module/)

文章介绍了 functools 标准库的 6 个使用场景：@cache 缓存、@total_ordering 让你少写双下方法、partial() 冻结函数、@singledispatch 泛型函数、@wraps 装饰器、reduce() 函数。

11、[深入理解 pytest.main()：Python 测试框架的核心功能解析](https://juejin.cn/post/7281491804736831542)

`pytest.main` 是 Pytest 框架中一个非常实用的函数，用于从命令行运行测试集或者以编程方式运行测试。文章探讨了它的用法和一些常见的应用场景。

12、[7 个极佳的 Python 身份验证库](https://python.plainenglish.io/7-best-python-authentication-libraries-you-should-use-in-your-next-project-c07b668d5348)

介绍了 7 个不错的身份验证库：**Authlib、Pyjwt、Flask-login、Django-allauth、ItsDangerous、Python Social Auth、Flask-security**。（附：[中文翻译](https://juejin.cn/post/7281150086351732751)）

### 🐿️项目&资源

1、[radon：Python 代码的各种指标](https://github.com/rubik/radon)

一个 Python 代码指标分析工具，可以计算圈复杂度、原始指标、Halstead 指标、可维护性指数，可用于 CI 集成，可与 Jupyter Notebook 一起使用。（star 1.5K）

2、[agents：自主语言代理的开源框架](https://github.com/aiwaves-cn/agents)

自主语言代理（Autonomous Language Agents）指的是能够独立执行自然语言处理任务的智能代理系统。这个库支持长期短期记忆、工具使用、Web 导航、多 agent 通信、人机交互和符号控制等功能。（star 2.6K）

![](./img/agents-cover.png)

3、[quasiqueue：一个多进程库](https://github.com/tedivm/quasiqueue)

一个用于 Python 多进程的库，便于管理长时间运行的多进程作业。可处理进程创建和清理、信号管理、跨进程通信以及其它在处理多进程时的麻烦事。

4、[pygraft：可配置的模式和知识图谱生成](https://github.com/nicolas-hbt/pygraft)

可根据用户指定的参数生成逼真的模式和知识图谱，通过使用 DL 推理器（HermiT）来确保逻辑一致性。

5、[toml-bench：在 Python 中该用哪个 toml 库？](https://github.com/pwwang/toml-bench)

这个仓库主要从多个维度比较了 **toml、tomli/tomli_w、tomlkit、pytomlpp、rtoml 和 qtoml** 这几个库，考察它们在处理数据时的行为表现以及性能。

6、[SyncDreamer：以单视角图像生成多视角一致的图像](https://github.com/liuyuan-pal/SyncDreamer)

提供一张图片，使用 Paint3D 分割前景对象，通过推理生成多个视角的图像。

7、[nanosam：使用 NVIDIA TensorRT 实时运行的 SAM 模型](https://github.com/NVIDIA-AI-IOT/nanosam)

Segment Anything（SAM）是在计算机视觉领域中对图像或视频中的任何对象进行分割的任务，以提取出具有语义或视觉特征的子区域或对象。

8、[logparser：用于日志解析的机器学习工具包](https://github.com/logpai/logparser)

国人开源作品。可自动从非结构化的日志信息中提取出结构化的关键信息。（star 1.2K）

9、[llama2.mojo：纯 Mojo 版本的 Llama 2](https://github.com/tairov/llama2.mojo)

作者将 Python 版本的 llama2.py 移植成 Mojo 版本，将性能提高了近 250 倍。（star 1.1K）

10、[bisheng：一个开放的 LLM DevOps 平台](https://github.com/dataelement/bisheng)

一款领先的开源大模型应用开发平台，中文“毕昇”，可以搭建各类丰富的大模型应用：分析报告生成、知识库问答、对话、要素提取等。

### 🐢播客&视频

1、[EuroPython 2023 的 146 个视频](https://www.youtube.com/playlist?list=PL8uoeex94UhFcwvAfWHybD7SfNgIUBRo-) 

今年 EuroPython 活动的演讲视频。

2、[Real Python 播客 #172：使用 Scalene 测量 Python 性能](https://realpython.com/podcasts/rpp/172/)

**Scalene** 是一款高性能的 CPU、GPU 和内存分析器，可以从单个函数或代码行级别分析代码，并比较在 Python 和 C 代码中花费的时间。播客嘉宾是马萨诸塞大学教授，他与学校实验室的学生开发了 Scalene。

## 22 Python 3.12.0 发布了！！ 

[博客原文](https://pythoncat.top/posts/2023-10-12-weekly) | 发布时间：2023-10-12

### 🦄文章&教程

1、[Python 3.12.0 版本发布了](https://www.python.org/downloads/release/python-3120/)

Python 最新大版本 3.12 发布了！包含许多新功能和优化，本期周刊有几篇文章涉及相关内容。（附：[Python 3.12 新功能的详细介绍](https://realpython.com/python312-new-features/)）

2、[Python 3.12 速览：子解释器](https://realpython.com/python312-subinterpreters/)

Python 子解释器是什么？3.12 版本的 PEP-684 做了什么？3.13 版本可能会出现什么变化？

3、[聊聊 Python 3.12 中 perf 的原生支持](https://www.manjusaka.blog/posts/2023/10/05/the-perf-feature-python-312/)

介绍了 Python 的栈帧基本知识、3.12 之前对于 trace 和 perf 的实现、以及 3.12 新引入的 Linux 原生 perf 的实现。

4、[Python 3.12 速览：静态类型的改进](https://realpython.com/python312-typing/)

3.12 版本带来了一些调整和改进：使用类型变量来注释泛型类和函数、类型变量的新语法、使用新的 @override 装饰器作模型继承、用类型化的字典更精确注解 \*\*kwargs。

5、[FastAPI 中的依赖注入：构建可维护的高性能 Web 应用](https://juejin.cn/post/7283461184514572349) 

依赖注入是一种强大的设计模式，FastAPI 中如何利用依赖注入来构建可维护的高性能 Web 应用？涉及内容：使用依赖注入管理配置、数据库访问和 ORM 的依赖注入、高级依赖注入技巧、测试依赖注入、性能优化和缓存的依赖注入、安全性和依赖注入等。

6、[深入理解 python 虚拟机：原来虚拟机是这么实现闭包的](https://juejin.cn/post/7286670786563244090)

文章介绍了闭包的使用例子和使用原理，主要从虚拟机层面讨论函数闭包是如何实现的？

7、[探索 Pexpect 库：深入理解 expect_list 方法](https://juejin.cn/post/7287418444647677986)

[pexpect](https://github.com/pexpect/pexpect) 可用于交互式应用的自动化，如 ssh、ftp、passwd、telnet 等，Github star 2.4K。文章介绍了它的 expect_list 方法的使用。

8、[介绍 textual-plotext，在终端里绘图](https://textual.textualize.io/blog/2023/10/04/announcing-textual-plotext/)

介绍了 textual-plotext 库的用法，它可以在终端里用 [Plotext](https://github.com/piccolomo/plotext) 绘图。

9、[Python Asyncio 系列文章 5 篇](https://bbc.github.io/cloudfit-public-docs/)

BBC R&D Cloudfit 团队的系列博客文章，Asyncio 系列已更新 5 篇，内容有基础概念及模式、异步上下文管理器和异步迭代器、库支持、混合异步和同步代码。

10、[使用 eBPF 分析 Python 和 Ruby](https://www.polarsignals.com/blog/posts/2023/10/04/profiling-python-and-ruby-with-ebpf)

使用 eBPF 从内存结构中读取抽象堆栈数据，实现堆栈跟踪及代码执行分析。

11、[Python 3.12: 不那么热门的改动](https://www.bitecode.dev/p/python-312-what-didnt-make-the-headlines)

文章介绍了 3.12 版本中不那么引入关注的改动：pathlib 库的改进、更好的调试体验、切片对象现在是可哈希的、意外出现的 math.sumprod()、新的命令行界面。

12、[从供应链安全角度看 Python 3.12.0](https://sethmlarson.dev/security-developer-in-residence-weekly-report-13)

Python 版本的发布流程是怎样的？版本构建的过程有哪些可改进的地方？文章另外介绍了用软件物料清单 （SBOM） 来跟踪软件分发的子组件以及它们在版本之间的变化。

### 🐿️项目&资源

1、[mwmbl：用 Python 实现的开源非营利搜索引擎](https://github.com/mwmbl/mwmbl)

一个非营利、无广告、免费的搜索引擎，专注于可用性和速度。目前仅是概念验证版本，索引的页面还比较少。（star 1K）

2、[dataherald：自然语言转 SQL 引擎](https://github.com/Dataherald/dataherald)

基于结构化数据进行企业级问答，允许设置一个 API，可用简单的英语回答问题。

3、[dspy：使用基础模型编程的框架](https://github.com/stanfordnlp/dspy)

一个使用语言模型 （LM） 和检索模型 （RM） 解决高级任务的框架。它统一了提示和微调 LM 的技术，以及推理、自我改进和使用检索和工具增强的方法。（star 3.5K）

4、[TTS：文本到语音转换的深度学习工具包](https://github.com/coqui-ai/TTS)

一个用高级文本生成语音的库，使用 1100 中语言的预训练模型，可用于训练新模型和微调任何语言的现有模型。（star 20.3K）

5、[rustworkx：用 Rust 实现的高性能 Python 图形库](https://github.com/Qiskit/rustworkx)

用 Rust 编写的通用 Python 图形库，拥有高性能和安全性。

6、[faststream：构建与事件流交互的异步服务](https://github.com/airtai/faststream)

一个用于构建与 Apache Kafka、RabbitMQ 和 NATS 等事件流交互的异步服务框架，简化了为消息队列编写生产者和使用者的过程。

7、[aiohttp：异步 HTTP 客户端/服务器框架](https://github.com/aio-libs/aiohttp)

流行的异步 HTTP 框架，主要特点：支持客户端和服务端的 HTTP 协议、开箱即用的 Websocket、支持中间件和可插拔路由。（star 14K）

8、[panther：高性能的 Python Web框架](https://github.com/AliRn76/Panther)

基于 Python 3.11 的 Web 框架，特点有面向文档的数据库 ODM、支持 Websocket、提供缓存 API、内置身份验证类、内置权限类、自定义中间件、可视化的 API 监控等。

9、[qiskit：用于量子计算机的开源 SDK](https://github.com/Qiskit/qiskit)

未来有可能人人都可以轻松使用量子计算机么？[Qiskit](https://qiskit.org/documentation/) 项目的目标是这样。这个库是 Qiskit 的核心组件，包含用于创建和使用量子电路、量子算子和基元函数的构建块。（star 3.9K）

10、[vizro：用于创建模块化数据可视化应用的工具包](https://github.com/mckinsey/vizro)

使用几行简单的配置就能创建复杂的仪表板，利用 Plotly 和 Dash 等库绘图。支持多种格式编写配置，包括 Pydantic 模型、JSON、YAML 或 Python 字典。（star 1.5K）

11、[numpy-ml：用 numpy 作机器学习](https://github.com/ddbourgin/numpy-ml)

这是一个由大量机器学习模型、算法和工具组成的集合，专门用 NumPy 和 Python 标准库编写。（star 14K）

12、[pdfplumber：PDF 解析库](https://github.com/jsvine/pdfplumber)

可解析 PDF 每个文本字符、矩形和线条的详细信息，支持提取表格和可视化调试。（star 4.6K）

### 🐢播客&视频

1、[Mojo 编程语言的新手入门教程](https://www.youtube.com/watch?v=5Sm9IVMet9c)

FreeCodeCamp 推出的一个 Mojo 入门学习视频，已接近 10 万播放量。

2、[Python 3.12: 你需要知道的新特性](https://www.youtube.com/watch?v=udHmeAmOlbI)

探讨 Python 3.12 中令人兴奋的新功能和改进，也讨论了即将发布的版本将删除的一些元素。

## 23 分享 35 个容易上手的 Python 小项目 

[博客原文](https://pythoncat.top/posts/2023-10-22-weekly) | 发布时间：2023-10-22

### 🦄文章&教程

1、[20 个令人兴奋的 Python 项目创意](https://dev.to/praise002/20-exciting-python-project-ideas-3la9)

经常看到有人问：有没有简单易上手的 Python 项目推荐？不妨看看这篇文章，它介绍了 20 个小项目的想法，另外原作者已经实现了很多项目，源码可从文中的[仓库地址](https://github.com/praise002/20-python-project)获取。

2、[Python 3.11 vs Python 3.12 之性能测试](https://en.lewoniewski.info/2023/python-3-11-vs-python-3-12-performance-testing/)

文章在配备 AMD 锐龙 7000 系列和第 13 代英特尔酷睿处理器的不同机器上共进行了 91 种基准测试，详细给出了各项数值。

3、[当我遇见了 Guido van Rossum](https://blog.adarshd.dev/posts/when-i-met-guido-van-rossum/)

作者在今年 Pycascades 上做了演讲“Python 中用元类作元编程”，并遇见 Guido，他们聊了一些 Python 使用中的话题以及如何成为 CPython 核心开发者。

4、[通过阅读代码学习：Python 标准库设计决策解释](https://death.andgravity.com/stdlib)

程序员提升能力的一个方法是大量阅读优秀的代码，Python 标准库就是很好的选择。但标准库茫茫之多，该选择哪些呢？文章作者推荐了这些：**statistics、pathlib、dataclasses、graphlib**。

5、[使用 Stripe、Vue.js 和 Flask 开发收款功能](https://testdriven.io/blog/accepting-payments-with-stripe-vuejs-and-flask/)

国人的付费意愿差，独立开发者选择出海掘金的话，大多会选择用 Stripe 账号。这篇教程使用 Stripe 实现网站的收款功能，前后端技术栈为 Vue 和 Flask。

6、[使用 Python 调用 Rust 的三种方法](https://blog.frankel.ch/rust-from-python/)

介绍了 Python 调用 Rust 的三种方法：HTTP、IPC（进程间通信） 和 FFI（外部函数接口）。

7、[如何开发 FastAPI 的中间件？](https://semaphoreci.com/blog/custom-middleware-fastapi)

FastAPI 内置了一些中间件，但你可能还需要量身定制自己的中间件。文章介绍了 FastAPI 中间件原理及内置的中间件，然后基于函数和基于类来实现自定义中间件，给出了最佳实践建议以及相应的测试用例。

8、[Django 项目实现无密码身份验证](https://www.honeybadger.io/blog/options-for-passwordless-authentication-in-django/)

文章介绍了三种无密码的身份验证方法：基于邮件的身份验证、使用 OAuth 进行身份验证和使用超链接进行身份验证；介绍了它们的优点、局限性以及使用的注意事项。

9、[在发布 Python 项目前，建议用上这 4 个工具](https://thetechbuffet.substack.com/p/improve-python-development-workflow)

有什么工具可以简化开发工作流程，遵循行业构建良好软件的最佳实践？文章分享了 4 种好用的工具：**Poetry、Pre-commit 钩子、Makefiles、python-dotenv**。

10、[我们必须聊聊 Flask](https://blog.miguelgrinberg.com/post/we-have-to-talk-about-flask)

Flask 最近发布了 3.0 版本，Werkzeug 也同时发了 3.0 版本，但它引入了不向后兼容的更改！作者吐槽 Flask 总是出现版本不兼容的问题，给出了不少例子和原因分析，希望 Flask 核心开发不要做无端的重构，要三思而行。（文章出自《Flask Web Development》一书的作者）

11、[基于 ProPainter 技术去除图片以及视频水印](https://juejin.cn/post/7288998044020326415)

介绍使用 ProPainter 框架来解决视频去水印问题，它引入了双域传播的新方法和一种高效的遮罩引导视频 Transformers，增强了视频修复的性能，同时保持了计算效率，成本更低。

12、[Google Sheets 也能用 Python 了](https://thenewstack.io/python-comes-to-google-sheets/)

微软在 8 月让 Excel 支持了 Python，现在一家名为 Neptyne 的公司推出了一款在 Google Sheets 中使用 Python 功能的产品。文章介绍了它的基本情况。

### 🐿️项目&资源

1、[一个 Python 知识问答网站](http://python.jpglomot.com/#/questions)

一个很简洁的网站，有近百道选择题，大多是 Python 基础语法相关的内容。来测一下你都学会了么？

2、[CardStock：跨平台的 GUI 构建工具](https://github.com/benjie-git/CardStock)

它提供了一个类似于绘图程序的编辑器，用于构建图形用户界面，支持文本、图形、图像、按钮、输入框和 Web 视图等元素；提供了一个代码编辑器，可添加事件驱动的 Python 代码。

3、[python-package-template：标准化的 Python package模板](https://github.com/Undertone0809/python-package-template)

它内置了单元测试、代码检查、格式化、包管理、pre-commit 配置、Github Actions 等众多方便的工具，可以很方便的管理 Python 项目。（投稿自@Undertone0809）

4、[pipeless：一个计算机视觉框架](https://github.com/pipeless-ai/pipeless)

轻松构建与部署可实时分析及操作视频流的应用，无需构建和维护多媒体 pipeline。支持插件，例如使用 Kafka 实时处理事件、使用 YOLOv8 模型等。

5、[RealtimeSTT：强大、高效、低延迟的语音转文本库](https://github.com/KoljaB/RealtimeSTT)

它具有高级语音活动检测、唤醒词激活和即时转录功能，使用的技术栈有：语音活动检测（**WebRTCVAD、SileroVAD**）、语音转文本（**Faster Whisper**）、唤醒词检测（**Porcupine**）。

6、[Chrome-GPT：可控制 Chrome 的 AutoGPT 代理](https://github.com/richardyc/Chrome-GPT)

它利用 Langchain 和 Selenium 使 AutoGPT 代理能够控制 Chrome 会话。支持以交互方式滚动、单击和输入网页上的文本，从而可以导航和操作 Web 内容。（star 1.4K）

7、[ZenNotes：Windows 记事本，支持翻译和TTS](https://github.com/rohankishore/ZenNotes)

一个简约的 Windows 记事本程序，支持翻译、TTS、Markdown，基于 [PyQt-Fluent-Widgets](https://github.com/zhiyiYo/PyQt-Fluent-Widgets) 开发而成。

8、[kr8s：用于 Kubernetes 的客户端库](https://github.com/kr8s-org/kr8s)

用于 k8s 的一个简单、可扩展的 Python 客户端库，如果你用过 **kubectl**，就会觉得它很熟悉。

9、[swirl-search：用 AI 同时搜索多个数据源](https://github.com/swirlai/swirl-search)

可搜索多个内容源并返回 AI 的排名结果，支持连接到数据库（SQL、NoSQL、Google BigQuery）、公共数据（谷歌、Arxiv）、企业数据源（Microsoft 365、Jira、Miro等）。

10、[sentry：面向开发者的错误跟踪和性能监控平台](https://github.com/getsentry/sentry)

一个强大的错误跟踪和性能监控平台，还支持定期任务监控、代码覆盖率、会话重播、告警、安全策略等功能，支持 100 多种平台和框架，支持 30+ 编程语言。（star 35.4K）

11、[15 个 Python 小项目](https://github.com/zhiwehu/100_plus_Python_Projects_Challenge)

这个仓库收录了一些 Python 小项目及其实现代码，跟本期周刊的第一则分享相似。（star 1K）

12、[ssh-audit：SSH 服务器和客户端安全审计](https://github.com/jtesta/ssh-audit)

用于审查 SSH 的配置，支持 SSH1 和 SSH2 协议，支持 Linux 和 Windows，可识别安全漏洞、不安全密钥、不安全算法等，并给出安全建议。另外它也有[在线版本](https://www.ssh-audit.com/) 。（star 2.6K）

### 🐢播客&视频

1、[哥本哈根 2023 Django Day 演讲视频](https://www.youtube.com/playlist?list=PLEpW1LzVyQWgtT_i_IlUmx2FSP2jHcroX)

Django Day 是一个专门围绕 Django 框架和 Django 社区的活动，目前视频列表中有 11 则视频。

2、[Talk Python To Me  #434：用 Python 构建移动 APP](https://talkpython.fm/episodes/show/434/building-mobile-apps-backed-with-python)

Python 能够用于开发移动端应用么？能不能用 Python 实现端到端的移动应用开发？这期播客邀请了几个移动端 APP 的开发者聊了相关话题。

## 24 no-GIL 提案正式被采纳了！ 

[博客原文](https://pythoncat.top/posts/2023-10-29-weekly) | 发布时间：2023-10-29

### 🦄文章&教程

1、[PEP-703 无 GIL CPython 的进展](https://lwn.net/Articles/947138/)

PEP-703 是 no-GIL 项目形成的提案，就在本周，Python 指导委员会宣布采纳了这个提案！这篇文章写于消息宣布的两周前，总结了过去一段时间里发生的技术思考和进展。（附：[PEP-703 的讨论](https://discuss.python.org/t/pep-703-making-the-global-interpreter-lock-optional/22606/123)）

2、[PEP-730 CPython 提供对 iOS 的官方支持](https://peps.python.org/pep-0730/)

这是一个新提案，建议 CPython 提供对 iOS 系统的 Tier 3 级支持。如果提案被采纳，则 Python 将会有更广泛的使用。 [BeeWare](https://beeware.org/) 和 [Kivy](https://kivy.org/) 是支持 iOS 的 Python APP 开发框架，说明了技术的可行性。

3、[Django 进阶：开发高级的功能](https://www.pythoncentral.io/the-next-step-in-django-development-advanced-features-to-consider/)

文章探讨在 Django 应用中集成一些高级的特性，例如：实现所见即所得编辑器、用户认证授权、实时通信功能、异步任务、集成 Elasticsearch 作全文搜索、自动化测试与持续集成。

4、[在 Python 中开发异步的任务队列](https://testdriven.io/blog/developing-an-asynchronous-task-queue-in-python/)

介绍了使用 multiprocessing.Pool、multiprocessing.Queue 和 Redis 实现简单的任务队列，实现基础的任务调度处理。 

5、[Flask、它的生态和向后兼容性](https://pgjones.dev/blog/flask-ecosystem-compatibility-2023/)

上期周刊分享了一则吐槽 Flask 向后兼容性不好的文章（见下），这篇是对它的回应，作者是 Flask 的维护者之一。

6、[继续关于 Flask 的讨论](https://blog.miguelgrinberg.com/post/some-more-to-talk-about-flask)

这是上周《[我们必须聊聊 Flask](https://blog.miguelgrinberg.com/post/we-have-to-talk-about-flask)》的后续，作者收到了一些正面和反面的回应，文章延续了之前的话题，并主要反驳了一些观点。

7、[介绍 rip - 快速而简约的 pip 实现](https://prefix.dev/blog/introducing_rip)

rip 是用 Rust 开发的 PyPI 包解析及安装库，即 Rust 版本 pip。它试图在 Conda 和 PyPI 间架起一座坚固的桥梁，文章介绍它为了克服这两者的主要区别（元数据提取、Wheel 文件元数据、依赖项规范）而做的一些工作。

8、[使用 Rust 将数据分析速度提高 180,000 倍](https://willcrichton.net/notes/k-corrset/)

如何使用 Rust 实现关键代码来提升 Python 程序的性能？文章从多个方面优化 k-CorrSet 问题的实现，得到了很高的速度提升。

9、[什么是 lambda 表达式？](https://www.pythonmorsels.com/lambda-expressions/)

什么是 lambda 表达式和 lambda 函数？lambda 函数与 Python 的其它函数有何不同？它有什么局限性、什么时候应该避免使用、通常使用在什么场景？

10、[手撸个视频翻译和配音工具玩玩 结果不太妙](https://juejin.cn/post/7293420609088798731)

视频翻译是对原始语言的视频处理后，显示为其它语言的字幕及配音。文章是一个低成本的尝试，技术栈：语音识别使用 openai-whisper 离线模型、文字翻译使用 Google 接口、文字合成语音使用 Microsoft Edge tts。

11、[掌握使用 FastAPI 进行集成测试](https://alex-jacobs.com/posts/fastapitests/)

集成测试是指将各个代码单元作为一个整体进行测试。文章介绍基于 FastAPI 的集成测试方法，包括如何模拟身份验证、如何模拟外部 API、如何模拟 MangoDB 相关操作、如何模拟 AWS S3。

12、[Python 代码转为 LATEX 公式工具](https://www.biaodianfu.com/latexify-python.html)

latexify_py 是一个 Google 开源的 Python 包，可以将 Python 源代码片段编译为相应的 LaTeX 表达式。文章介绍了它的使用方法，包括如何将 Python 函数转为公式、Latexify 参数设定、Latexify 生成伪代码。

### 🐿️项目&资源

1、[celery：分布式任务队列](https://github.com/celery/celery)

Python 中比较成熟的任务队列库，支持 RabbitMQ、Redis 等中间件，很容易与主流 Web 框架集成。（star 22.4K）

2、[rq：简单的任务队列](https://github.com/rq/rq)

RQ（Redis Queue）是基于 Redis 的任务作业库，使用门槛低，支持排队、定时、重试等功能。（star 9.2K）

3、[huey：轻量级的任务队列](https://github.com/coleifer/huey)

简单轻量级的任务队列库，支持 Redis、SQLite、文件系统和内存存储，支持多进程、多线程或 Greenlet 任务执行模型。（star 4.7K）

4、[rip：快速解决和安装 Python 包（Rust 版 pip）](https://github.com/prefix-dev/rip)

用 Rust 实现的 pip，支持下载、解析和安装 PyPI 包，支持 wheel （部分支持），计划将 sdist 文件。

5、[Selenium-python-helium：Web 自动化库，让 Selenium 更好用](https://github.com/mherrmann/selenium-python-helium)

Selenium 是 Web 自动化的最优库之一，Helium 是在其基础上的封装，使 Web 自动化更为方便。除了高级 API，它还简化了 Web 驱动管理、支持与嵌套的 iFrame 中元素交互、支持隐式等待、支持显式等待。（star 3.6K）

6、[rendercv：用 YAML/JSON 文件创建 PDF 格式的简历](https://github.com/sinaatalay/rendercv)

它支持解析 YAML 及 JSON 文件的简历，创建 latex 文件，然后渲染成 PDF 格式。目前仅有一款主题。

7、[latexify_py：用 Python 代码生成 LaTeX 表达式](https://github.com/google/latexify_py)

可以将 Python 源码或 AST 编译为 LaTex，使用 IPython 来漂亮地打印编译的函数。（star 6.5K）

8、[localpilot：Mac 上的 Github Copilot](https://github.com/danielgross/localpilot)

在 Macbook 本机上使用的编程助手，配置及使用非常简易。（star 2.6K）

9、[annoy：C++/Python 的近似最近邻搜索](https://github.com/spotify/annoy)

用于搜索空间中靠近给定查询点的点，与其它同类库的最大不同是可使用静态文件作为索引，可实现跨进程共享索引。被 Spotify 用作音乐推荐。（star 12.1K）

10、[voyager：用于 Python 和 Java 的近似邻搜索库](https://github.com/spotify/voyager)

可对内存中的向量集合执行快速的近似最近邻搜索。也是出自 Spotify，每天被查询数亿次，扛得住海量用户的请求。召回率比 annoy 高。

11、[Test-Agent：国内首个测试行业大模型工具](https://github.com/codefuse-ai/Test-Agent)

它旨在构建测试领域的“智能体”，融合大模型和质量领域工程化技术，促进质量技术代系升级。开源了测试领域模型 TestGPT-7B，该模型以 CodeLlama-7B 为基座。

12、[waymax：用于自动驾驶研究的基于 JAX 的模拟器](https://github.com/waymo-research/waymax)

Waymo 是 Google 旗下的自动驾驶公司，Waymax 是其开源的轻量级、多智能体、基于 JAX 的自动驾驶模拟器，可轻松分发和部署在 GPU 和 TPU 等硬件加速器上。

### 🐢播客&视频

1、[Python 的代码生成：拆解 Jinja](https://www.youtube.com/watch?v=jXlR0Icvvh8)

Jinja 的主要作者 Armin Ronacher 在 2012 年的演讲视频，介绍了 Jinja 编译器基础结构的设计，为什么这样设计，以及不同版本的迭代发展过程。（附：[演讲的 PPT](https://speakerdeck.com/mitsuhiko/code-generation-in-python-dismantling-jinja)）

2、[让我们聊一聊模板](https://www.youtube.com/watch?v=rHmljD-oZrY)

Armin Ronacher 在 2014 年的演讲视频，比较了 Jinja 和 Django 的模板，分析它们产生截然不同设计的历史原因。（附：[演讲的 PPT](https://speakerdeck.com/mitsuhiko/lets-talk-about-templates)）

3、[JupyterCon 2023 视频 86 个](https://www.youtube.com/playlist?list=PL_1BH3ug7n1Ih_Yy2TmM7MZ2zogSLZvzE)

JupyterCon 是一个专注于 Jupyter 应用和工具的年度活动，包括数据科学、机器学习、科学计算、数据可视化、教育和科学研究等领域。

## 25 性能最快的代码格式化工具 Ruff！ 

[博客原文](https://pythoncat.top/posts/2023-11-04-weekly) | 发布时间：2023-11-04

### 🦄文章&教程

1、[Ruff：一款极其快、兼容 Black 的 Python 格式化工具](https://astral.sh/blog/the-ruff-formatter)

我在今年 4 月份介绍过 [性能最快的代码分析工具](https://pythoncat.top/posts/2023-04-09-ruff) Ruff，当时发现它不局限于 Linter 的定位，还提供了部分 Formatter 的功能。现在，它发布了重大更新，正式成为性能最快的 Python 代码格式化工具，比 **Black** 快 30 倍以上，比 **YAPF** 快 100 倍！

![不用缓存，格式化约25万行代码的表现](./img/2023-11-04_ruff.png)

2、[你应该什么时候升级到 Python 3.12？](https://pythonspeed.com/articles/upgrade-python-3.12/)

Python 3.12 已经发布了，你是否迫切想要升级了呢？现在是最佳的升级到 3.12 的时候么？文章建议你等到 12 月，等发布 3.12.1 错误修复版本后，因为新版本存在这些问题：不兼容的软件包、缺少二进制包、每次大版本总有大量的问题要修复。

3、[Python 3.12：一个被人忽略的史诗级版本](https://www.manjusaka.blog/posts/2023/10/29/the-most-important-thing-in-python-3-12/)

作者认为 3.12 对于 Python 的意义，大于 3.5 的“async/await” 和 3.6 的 “Type Hint” 对于 Python 的意义！主要分析了三个方面提升：PEP-669 带来的可观测性、PEP-684 为 non-GIL 带来的性能提升、PEP-697 全新 C API 保证跨版本兼容性。

4、[不要再用 requirements.txt 了](https://quanttype.net/posts/2023-10-31-do-not-use-requirements.txt.html)

作者给了两个建议：不要使用 pip 和 `requirements.txt` 来管理 Python 依赖项，推荐使用 Poetry。pip 的主要问题是没有 lockfile 和手工管理虚拟环境麻烦。除了 Poetry，作者也提及了 Hatch 和 PDM。

5、[为什么 Django 后台管理系统那么“丑陋”？](https://www.coderedcorp.com/blog/why-is-the-django-admin-ugly/)

Django 提供了一个默认的后台管理系统，即 Django Admin，它的 UI 很多年没有变化，显得设计过时了。为什么 Django 维护者们不改善它呢？作者通过询问多位维护者，得出了它的历史及如此设计的原因，主要观点是 Django Admin 面向内部管理员，不应该暴露给终端用户。

![Django Admin管理页面](./img/2023-11-04_django_admin.png)

6、[我迁移弃用 setup.py 的糟糕体验](https://gregoryszorc.com/blog/2023/10/30/my-user-experience-porting-off-setup.py/)

PyOxidizer 作者的一篇长文，他在将 Python 3.12 用于另一个库时，CI 运行`python setup.py` 提示 setuptools 无法导入。作者在寻求解决方案时，发现 Python 的打包生态非常让人困惑，他经历了一系列复杂而耗时的过程。

7、[使用 Ptpython 提高你的编码效率](https://realpython.com/ptpython-shell/)

Ptpython 是一个功能丰富且对用户友好的 Python REPL，这是一篇非常详细的使用教程。重点介绍的功能包括历史记录、输入验证、自动补全、自动处理缩进、自定义交互式 shell、在脚本中嵌入 ptpython 等。

8、[100%的测试覆盖率是不够的：Python 中基于属性的测试](https://blog.robertroskam.com/p/100-test-coverage-is-not-enough)

测试覆盖率固然重要，但这项指标并不足以解决所有问题。文章通过示例揭示测试覆盖率的不足，简单介绍了如何用 Hypothesis  作基于属性的测试。

9、[从零开始编写一个 Python 异步 ASGI Web 框架](https://www.cnblogs.com/hanabi-cnblogs/p/17792740.html)

从零开始编写一个异步 ASGI Web 框架难么？需要了解哪些知识、实现哪些功能、思考哪些问题？这篇循序渐进的教程是很好的学习材料，让你了解 Web 框架设计、异步编程、功能封装与项目管理。

![一个请求的生命周期](./img/20231026181957.png)

10、[Python 如何在日志中隐藏明文密码？](https://www.cnblogs.com/frankming/p/17762591.html)

不在日志中打印明文密码是安全需求，但是有太多可能出现打印密码的情况，如何能高效地隐藏明文密码呢？文章介绍了基于 **logging** 模块的两种实现方案：自定义 filter 和自定义 formatter，使用特定规则过滤明文密码。

11、[从混沌到凝聚：构建你自己的 Monorepo](https://monadical.com/posts/from-chaos-to-cohesion.html)

monorepo 是将所有项目都放到一个代码仓管理，可能包含不同语言和框架。这意味着对它的依赖管理和 CI/CD 等都与普通代码仓不同。文章介绍如何使用 GitHub Actions 作为 CI/CD 工具构建简单的 Python monorepo。

12、[Python 是一种编译型语言](https://eddieantonio.ca/blog/2023/10/25/python-is-a-compiled-language/)

我们通常习惯将 Python 称为一种解释型语言，因为它在运行时逐行解释和执行代码。很多人还知道 Python 其实也有编译的过程，解释器会先编译再执行。然而作者不止步于此，他通过苏格拉底式对话和几轮实验，引导读者重新思考“解释”与“编译”：它们是错误的二分法、限制了编程语言的可能性。Python 既是解释型语言，也是编译型语言！

### 🐿️项目&资源

1、[ccxt：加密货币交易 API，支持 100 多个交易所](https://github.com/ccxt/ccxt)

用于加密货币交易的 JavaScript/Python/PHP/C# 库，支持许多比特币/以太币/山寨币交易市场和商家 API。（star 29.5K）

2、[uDjango：单文件的 Django 微型项目](https://github.com/pauloxnet/uDjango)

这个项目是 DjangoCon US 2023 的演示项目，使用单文件不到 10 行代码，演示一个最小的 Django 应用。

3、[esmerald：高度可扩展、高性能的 Web 框架](https://github.com/dymmond/esmerald)

基于 Starlette 和 Pydantic 之上构建的开箱即用的 Web 框架，用于构建现代可扩展的 API 应用，支持同步和异步，提供 DAO、ORM、ODM、依赖注入、权限管理等功能。

![](./img/2023-11-04_esmerald.png)

4、[Python-Type-Challenges：通过在线挑战来学习 Python 类型提示](https://github.com/laike9m/Python-Type-Challenges)

一个很有意思的项目，它包含从初级到高级的一系列挑战题目，让你在线练习 type hint 的使用。

5、[mify：微服务基础架构，代码生成工具](https://github.com/mify-io/mify)

可生成 OpenAPI http 服务端，内置 Prometheus 指标，提供结构化日志记录，支持多种语言代码生成。

6、[de4py：Python 逆向工程工具包](https://github.com/Fadi002/de4py)

一款高级的 Python 反混淆器，面向恶意软件分析师和逆向工程师，它拥有精美的 UI 和一些高级功能。

7、[public-apis：面向开发者的公共 API 列表](https://github.com/public-apis-dev/public-apis)

非常非常丰富的公共 API 清单，内容应有尽有。（star 2K）

8、[FunASR：端到端语音识别工具包](https://github.com/alibaba-damo-academy/FunASR)

阿里达摩院开源的语音识别工具包，功能包括语音识别（ASR）、语音端点检测（VAD）、标点恢复、语言模型、说话人验证、说话人分离和多人对话语音识别等。（star 1.2K）

9、[XHS_Downloader: 小红书图文/视频作品采集工具](https://github.com/JoeanAmier/XHS_Downloader)

支持采集和下载小红书图文/视频作品，支持批量下载，有作品文件完整性处理机制。

![](./img/2023-11-04-xhs.png)

10、[RSS-GPT：使用 ChatGPT 为你的 RSS 订阅源生成摘要](https://github.com/yinan-c/RSS-GPT)

使用 GitHub workflow 自动运行一个简单的 Python 脚本，调用 OpenAI API 为 RSS 订阅源生成摘要，然后将新生成的 RSS 订阅源推送到 GitHub Pages。配置简单快速，无需服务器。

11、[codespell：检查代码是否存在常见拼写错误](https://github.com/codespell-project/codespell)

用于检查源代码中拼写错误的单词，支持多种运行方式，可指定忽略单词和文件，可用于 pre-commit。（star 1.5K）

12、[codeshell：多语言代码大模型基座](https://github.com/WisdomShell/codeshell)

具有 70 亿参数，在五千亿 Tokens 进行了训练，上下文窗口长度为 8192。在权威的代码评估Benchmark 上，CodeShell 取得同等规模最好的性能。（star 1.2K）

## 26 requests3 的现状 

[博客原文](https://pythoncat.top/posts/2023-11-11-weekly) | 发布时间：2023-11-11

### 🦄文章&教程

1、[Kenneth Reitz：迟来的道歉，以及 requests 3 的进展](https://kennethreitz.org/essays/why-im-not-collaborating-with-kenneth-reitz)

2019 年时 requests 3 的筹款闹出了不小的风波，后来似乎没什么消息。现在作者发了一篇道歉文，看来项目是要重启了！文中列举了目前已经完成的一些事情，包括给所有公开接口加上了类型提示、重构所有命名空间和调整成兼容异步编程等。（附：筹款风波之《[Why I'm not collaborating with Kenneth Reitz](https://vorpus.org/blog/why-im-not-collaborating-with-kenneth-reitz/)》）

2、[grequests：异步的 HTTP 请求](https://coderslegacy.com/python-grequests-making-asynchronous-http-requests/)

`grequests` 构建在 `gevent` 库之上，可以并发多个请求，有效利用异步编程的强大功能。这篇基础教程介绍了它的基本使用方法，以及一个提升性能的建议。

3、[开发一个 Python 编译器和解释器](https://mathspp.com/blog/tag:bpci)

这是一系列博文，目前已更新 6 篇，目标是探索和研究实现 Python 等编程语言所需的概念和算法，将会涉及分词器、解析器、编译器和解释器。

4、[使用 Python+ChatGPT 开发一个书籍摘要 AI](https://levelup.gitconnected.com/build-an-ai-tool-to-summarize-books-instantly-828680c1ceb4)

一篇教程，用 Python、Langchain 和 OpenAI embedding 开发一个书籍摘要工具。另外，作者使用 Streamlit 发布了一个[在线体验网站](https://gptsummarizer.streamlit.app/)。

![AI作书籍摘要](./img/2023-11-10_book.png)

5、[数据库生成的列 ：Django & SQLite](https://www.paulox.net/2023/11/07/database-generated-columns-part-1-django-and-sqlite/)

`GeneratedField` 是正在开发的 Django 5.0 的新功能，利用数据库的能力自动计算数据列的值。作者是 Django 的贡献者，测试了在 SQLite 中使用这个新功能的各种场景。（附：这篇文章还介绍了一些 [Django 5.0 中的新东西](https://fly.io/django-beats/new-goodies-in-django-50/)）

6、[你能用 Python 的 bisect 模块做到这些事](https://martinheinz.dev/blog/106)

`bisect` 模块只有两个函数，但可以做很多事，文章介绍了：二分搜索、前缀搜索、在列表中查找连续的相等值、查找字典中最接近的键、自定义对象的排序、按照字典 key 搜索。

7、[为什么说在 Windows 上为 Python 3.12 构建的 SciPy 是一个小奇迹？](https://labs.quansight.org/blog/building-scipy-with-flang)

每当 Python 发布新版本时，三方库的维护者们也要紧锣密鼓开发兼容的对应版本，这不是轻松的事。作者介绍了他们遇到的严峻挑战，其实就是 Python 社区老大难的打包问题。好在维护者们已经找到了适用的解决方案。

8、[使用 AI 进行网页抓取实验（使用 GPT-4 解析 HTML）](https://serpapi.com/blog/web-scraping-and-parsing-experiment-with-ai-openai/)

OpenAI 发布了新的模型，它的能力到底如何呢？使用 GPT-4 作网页抓取，具有哪些优点和缺点呢？文章分别实验了抓取结构良好的网站、抓取 Google 自然搜索结果、抓取 Google SERP、以及抓取 Google MAPS 结果。

9、[Django vs Flask：哪个是最好的 Python Web 框架？](https://blog.jetbrains.com/pycharm/2023/11/django-vs-flask-which-is-the-best-python-web-framework/)

Python 圈最为流行的两大 Web 框架，到底应该如何取舍呢？这是一篇细致的长文，详细对比了它们在模板系统、URL 调度器、数据库支持、身份验证及授权、测试、软件架构、学习曲线等方面的差异。没有更好的，只有是否适合你的。

![Web框架的使用率占比](./img/web-frameworks.png)

10、[在 Mac 上安装 Python 的正确方法](https://marvelousmlops.substack.com/p/the-right-way-to-install-python-on)

如何在新的 M2 MacBook 上安装 Python 呢？这篇手把手的指导教程中，作者给出的建议是 **Pyenv + pyenv-virtualenv** 。

11、[用 Python 开发简单的 Android 数据分析应用](https://www.techbeamers.com/simple-android-data-analytics-app-in-python/)

这篇教程指导你开发一个 Android 数据分析应用，其作用是记录和显示你全天在屏幕上花费的时间。使用的 GUI 框架是`kivy` ，数据分析使用了`Pandas` 。

12、[改进 Numpy 的 Python API，为 2.0 版本准备](https://labs.quansight.org/blog/numpy-python-api-cleanup)

NEP-52 是 Numpy 的一则增强提案，旨在识别 Numpy 中过时、重复和弃用的 Python API，并作重构优化。这项工作是为了顺利迁移到 Numpy 2.0 而做的准备。作者介绍了他在其中遇到的挑战和取得的部分成就。

🎁**Python开发者调查**🎁官方第七次开发者调查，旨在了解 Python 开发社区的现状，鼓励你花费几分钟来填写：[填写地址](https://survey.alchemer.com/s3/7554174/python-developers-survey-2023)

### 🐿️项目&资源

1、[pyvideotrans：视频的语言翻译，并添加配音](https://github.com/jianchang512/pyvideotrans)

一个视频翻译工具，可将一种语言的视频翻译为另一种语言和配音的视频。（star 1.4K）

2、[pyink：Google 内部修改 Black 而成的代码格式化工具](https://github.com/google/pyink)

由 Black 派生而成，用于解决 Google 数千名工程师在 monorepo 上工作产生的问题。

3、[sqlmodel：Python 中的 SQL 数据库](https://github.com/tiangolo/sqlmodel)

由 FastAPI 作者开源的 SQL 数据库，结合了 SQLAlchemy 和 Pydantic，旨在实现简单性、兼容性和稳健性。（star 11.2K）

4、[wagtail：一个 Django 内容管理系统](https://github.com/wagtail/wagtail)

一个专注于用户体验的后台管理系统，上期分享了关于“[Django Admin 丑陋](https://www.coderedcorp.com/blog/why-is-the-django-admin-ugly/)”的文章，wagtail 是可提供给终端用户使用的最佳推荐。（star 16.2K）

![Wagtail美观的界面设计](./img/2023-11-09-wagtail.png)

5、[NBA-Machine-Learning-Sports-Betting：使用机器学习的 NBA 比赛预测](https://github.com/kyleskom/NBA-Machine-Learning-Sports-Betting)

一个机器学习 AI，用于预测 NBA 比赛胜负。包含 2007-08 赛季到本赛季的所有球队数据。

6、[Python_EBook_Free：Python 电子书和资源](https://github.com/FarhaKousar1601/Python_EBook_Free)

这个仓库归档了一些 Python 电子书和学习资源，都是 PDF 格式。

7、[pathway：高吞吐量和低延迟实时数据处理框架](https://github.com/pathwaycom/pathway)

一个数据处理框架，结合了 LLM 程序的批处理、流式处理和实时 API，可与各种数据源交互（如 Kafka、CSV 文件、SQL/noSQL 数据库和 REST API）。

8、[prefect：一个工作流编排工具，构建数据管道](https://github.com/PrefectHQ/prefect)

它是数据密集型工作流的编排器，可将 Python 函数转换为可观察和编排的工作单元。支持自动重试、分布式执行、调度、缓存等功能，拥有强大的仪表板进行监控。（star 13.2K）

![Prefect的仪表板](./img/cloud-dashboard.png)

9、[VideoCrafter：生成高质量视频模型](https://github.com/AILab-CVC/VideoCrafter)

一个支持高清晰度的视频生成和编辑工具，目前包括文字生成视频及图片生成视频两种模型。（star 3K）

10、[程序员值得看的 42 个学习资源](https://madza.hashnode.dev/42-developer-resources-to-kickstart-your-coding-journey)

这篇文章收集了一系列基础资源、课程和教程、编码游戏、书籍、播客、YouTube 频道、最佳实践等等。

11、[networkx：Python 的网络分析库](https://github.com/networkx/networkx)

用于创建、操作和研究复杂网络的结构、动力学和功能，适用于复杂网络的分析。（star 13.4K）

12、[PythonFrameworks：Python 的各种框架汇总](https://github.com/jgu-bytes/PythonFrameworks)

这个项目收录了 Python 中的各种框架，有 Web 框架、API 框架、CMS、ML&DL&AI、任务/消息队列、并行&分布式计算、工作流&管道、DevOps、爬虫、GUI&TUI，等等。提供有一个[在线网站](https://pythonframeworks.com/)。

![一部分Web框架](./img/2023-11-10_framework.png)

### 🐢播客&视频

1、[core.py：一档新的 Python 播客](https://podcasters.spotify.com/pod/show/corepy)

由 Python 核心开发者 Pablo Galindo 和 Łukasz Langa 主理的播客，已推出两期节目：[核心开发者 Sprint 及 Python 3.13.0 alpha 1](https://podcasters.spotify.com/pod/show/corepy/episodes/Episode-1---Core-Sprint-in-Brno--Python-3-13-0-alpha-1-e2apebk)、[PEP-703：移除 GIL](https://podcasters.spotify.com/pod/show/corepy/episodes/Episode-2---PEP-703-Removing-the-GIL-e2b8egi)

2、[为什么静态类型又流行起来了？ ](https://www.youtube.com/watch?v=Tml94je2edk)

上世纪 90 年代诞生的 Python、Ruby、PHP 和 JavaScript 这些动态编程语言都在拥抱静态类型（mypy、Sorbet、Hack 和 TypeScript），诞生不算久的 Go、Kotlin、Dart 和 Rust 等都是静态类型。为什么静态类型卷土重来？这对未来意味着什么？

3、《Boost your Git DX》作者的两期播客

[Adam Johnson](https://twitter.com/AdamChainz) 新书《提升你的 Git 开发者体验》上市后，分别参加了[Real Python Podcast #179](https://realpython.com/podcasts/rpp/179/) 和 [Pybites #139](https://pybit.es/articles/maximizing-your-dx-with-adam-johnson/) 两期播客节目。

## 27 应该如何处理程序的错误？ 

[博客原文](https://pythoncat.top/posts/2023-11-18-weekly) | 发布时间：2023-11-18

### 🦄文章&教程

1、[将 Python 错误作为值：比较 Go 和 Rust 的使用模式](https://www.inngest.com/blog/python-errors-as-values)

文章比较了两种处理错误的方法：抛出错误和将错误作为返回值，并参照 Go 和 Rust 的处理模式，介绍如何在 Python 中实现将错误作为值返回。（附1：[两种风格的错误处理](https://frostming.com/error-handling/) 分析了两种风格的优缺点及其适用场景；附2：周刊第一期的 [编程语言的四种错误处理方法](https://pythoncat.top/posts/2023-05-08-error) 从语法、代码可读性、演变过程、运行效率角度对比了不同方案）

2、[调试 Django 中的 CSRF 失败/403 禁止错误](https://www.better-simple.com/django/2023/11/04/debugging-csrf-error-in-production/)

部署 Django 程序时的一个常见错误是 `403 Forbidden` ，通常由 CSRF 错误导致，文章介绍了导致这种错误的 7 种原因，并解读 Django 源码，详细梳理了它们的校验逻辑。

3、[对 Python 环境和包管理工具的公正分析](https://alpopkes.com/posts/python/packaging_tools/)

Python 中的虚拟环境和包管理工具实在是太多了！但是应该如何选择最适合自己需求的工具呢？作者全面分析了 5 个类别的 10 多款工具，希望减少用户在抉择上的困惑。（附：作者针对此主题的两场演讲 [PyCon DE 2023](https://www.youtube.com/watch?v=MsJjzVIVs6M) 和 [EuroPython 2023](https://www.youtube.com/watch?v=3-drZY3u5vo)）

![Python环境和包管理工具的分类](./img/venn_diagram.png)

4、[让我们一起创建一个 Python 调试器](https://mostlynerdless.de/blog/2023/09/20/lets-create-a-python-debugger-together-part-1/)

你是否好奇一个代码调试器是如何工作的？当设置断点后，程序触发它时会发生什么？调试器是程序员日常必备工具之一，但极少有人知道它是如何实现的。这是一个系列教程，已更新 5 篇文章。值得一提的是，作者使用了最新的 Python 3.12  PEP-669 功能。

5、[揭开 Python 3.12 的面纱：Python 世界有哪些新东西？](https://blog.jetbrains.com/pycharm/2023/11/python-3-12/)

Python 3.12 已发布一个半月，你开始尝鲜了么？这篇内容全面的文章重点解读了新的几个 PEP，让你对这个版本有更清晰的认识。

6、[Python 的哈希表指南](https://stackabuse.com/hash-tables-in-python/)

Python 的字典是一种“哈希表”，提供了高效灵活的数据存储和检索方法。文章介绍了这种数据结构及其工作原理，探讨了如何用 Python 实现哈希表并解决哈希冲突。这是一个系列文章，作者还写了堆、队列、栈、数组等数据结构的指南。

7、[运行不可信的 Python 代码](https://healeycodes.com/running-untrusted-python-code)

作者想自己实现一个简化版的不太安全的沙盒，文章介绍了它的运作方式，以及一些关键性问题的解决方案，即独立的进程 + `seccomp` + `setrlimit` 。（附：[如何安全运行别人上传的Python代码？](https://www.kingname.info/2023/11/11/python-run-other-code/) 这篇文章的方案是使用 Docker 的 Python SDK 来构建镜像，在 Docker 中执行代码）

8、[了解 Linux cp 命令并用 Python 编程实现](https://muhammadraza.me/2023/linux-cp/) 

深入探讨了 Linux 中 `cp` 命令的工作原理，然后用 Python 实现了一个基础版本。从中可以看到高级编程语言提供的强大功能和简单性。

9、[初学者应该用 Django，而不是 Flask](https://www.bitecode.dev/p/beginners-should-use-django-not-flask)

作者认为 Flask 虽然简单易用，但它可能会让初学者忽视 Web 开发的复杂性。Django 功能全面、生态系统成熟，更适合新手学习与提升生产力。

10、[PEP-733：对 Python 公共 C API 的评估](https://peps.python.org/pep-0733/)

一则信息型的 PEP，用于分享 C API 的信息，包括定义 C API 的用途、利益相关者及其使用场景和要求、C API 的优势、C API 的 9 项薄弱的问题。

11、[让我们做一个类 JSON 语法的解析器](https://arunmani.in/articles/silly-json-parser/)

作者出于编程乐趣的目的，定义了一组类似 JSON 的语法规则，然后使用 Python 逐一实现不同内容的提取与解析，开发了一个解析器。

12、[一门编程语言应该有多大？](https://tratt.net/laurie/blog/2023/how_big_should_a_programming_language_be.html)

在作者眼中，Python 1.5 是他能完全理解的最后一个版本，而之后的版本则使得语言越来越大。语言设计时添加新功能，如何权衡取舍？作者建议学习 C 语言的例子，让语言处于“最小进化”模式。

🎁**PyCon China 2023**🎁今年国内 PyCon 将于 12 月在北京、上海、成都、杭州、重庆、深圳、广州联动举办。现在购票可享 7 折优惠：[详情介绍](https://mp.weixin.qq.com/s/lfrFoIiNuUYzgXPklQPLmg)

### 🐿️项目&资源

1、[CogVLM：多模态预训练模型](https://github.com/THUDM/CogVLM)

一个强大的开源可视化语言模型 （VLM），CogVLM-17B 有 100 亿个视觉参数和 70 亿个语言参数，具有高性能，在多项跨模态基准测试中排名领先。（star 2.1K）

![CogVLM在基准测试中的得分](./img/metrics-min.png)

2、[movis：用于生成与编辑视频的库](https://github.com/rezoo/movis)

让你通过 Python 代码生成各类视频，包括但不限于演示视频、动态图形、着色器艺术编码和游戏解说视频。支持视频编辑、音频剪辑、图层转换及添加特效等。

3、[mirror：基于摄像头内容，实时回答问题](https://github.com/cocktailpeanut/mirror)

这是一个 Web APP，可将摄像头视频流传给 AI，让它分析内容并实时回答你提出的问题。100% 本地和私有，Web UI 是用 [gradio](https://www.gradio.app/) 构建，多模态 AI 模型是 [Bakllava](https://huggingface.co/SkunkworksAI/BakLLaVA-1) 。

4、[vimGPT：使用 GPT-4V 和 Vimium 浏览网页](https://github.com/ishan0102/vimGPT)

**Vimium** 是一个 Chrome 插件，可让你仅用键盘浏览网页，借助它，可以不将浏览器 DOM 传给大模型，仅用 GPT-4V 的视觉功能来浏览网页。（star 1.8K）

![使用 GPT-4V 和 Vimium 浏览网页](./img/2023-11-18_vimGPT.png)

5、[twitter_user_tweet_crawler：无需调用 Twitter API，爬取用户推文](https://github.com/kaixinol/twitter_user_tweet_crawler)

使用 selenium 模拟浏览器操作，可抓取用户推文并保存静态资源到本地，无需调用 Twitter API。（投稿自@kaixinol）

6、[RSS-OPML-to-Markdown：将 OPML 文件转化为易读的 Markdown 格式](https://github.com/AboutRSS/RSS-OPML-to-Markdown)

经常有人分享自己 RSS 列表导出的 OPML 文件，但这难以阅读也不宜直接拿去导入自己的阅读器。这个项目将 RSS 源的概要和一些统计信息输出成 markdown 表格，方便你按需订阅。（投稿自@AboutRSS）

7、[MyHeyGen：视频翻译工具](https://github.com/AIFSH/MyHeyGen)

一个平民版视频翻译工具，音频翻译、翻译校正、视频唇纹合成全流程解决方案。

8、[awesome-python-repo-stats：统计“awesome-python”列表中项目的信息](https://github.com/emanuelef/awesome-python-repo-stats)

[awesome-python](https://github.com/vinta/awesome-python) 是一个拥有 187K star 超火爆的项目，收录了大量框架、库、软件和资源。这个项目是对它收录内容的统计分析，每日更新，可在线查看统计表。

9、[outlines：引导式文本生成](https://github.com/outlines-dev/outlines)

一个用于生成神经文本的库，可视为 transformers 库中 `generate` 方法的替代品。（star 3.3K）

10、[marimo：下一代 Python notebook](https://github.com/marimo-team/marimo)

全新的 notebook 项目，其每个 notebook 都可作为交互式 Web 程序共享，可浏览数据、运行实验、构建工具和部署应用。

![marimo使用演示](./img/2023-11-18_marimo.png)

11、[Finance：150+ 量化金融 Python 程序](https://github.com/shashankvemuri/Finance)

一个资源集合项目，帮助你收集、操纵和分析股市数据。（star 1.2K）

12、[tacticalrmm：一个远程监控和管理工具](https://github.com/amidaware/tacticalrmm)

一个远程监控和管理工具，使用 Django、Vue 和 Go 构建。类似 Teamviewer 的远程桌面控制、远程文件传输、远程执行命令和脚本、查看日志、告警管理、支持自动化。（star 2.3K）

### 🐢播客&视频

1、[CPython 的 JIT 编译器](https://www.youtube.com/watch?v=HxSHIpEQRjs)

Guido 本周在 X 上分享了这则视频，视频作者介绍了他们规划给 Python 3.13 开发一个 JIT 编译器！（附：[演讲视频的文稿](https://github.com/brandtbucher/brandtbucher/blob/master/2023/10/10/a_jit_compiler_for_cpython.pdf)）

2、[The Python Show 第 21 期：Sanic - 异步 Web 框架](https://www.blog.pythonlibrary.org/2023/11/10/episode-21-sanic-the-async-python-web-framework/)

Sanic 是支持异步编程的 Python Web 框架，能够快速构建和运行。这期播客的嘉宾是 Sanic 的维护者之一，话题包括 Web 框架对比、消息规范、[Mayim](https://github.com/ahopkins/mayim)（单向 ORM）。

本文首发于：[https://pythoncat.top/posts/2023-11-18-weekly](https://pythoncat.top/posts/2023-11-18-weekly)

## 28 两种线程池、四种优化程序的方法 

[博客原文](https://pythoncat.top/posts/2023-11-25-weekly) | 发布时间：2023-11-25

### 🦄文章&教程

1、[四种优化程序的方法](https://tratt.net/laurie/blog/2023/four_kinds_of_optimisation.html)

很值得推荐的文章。正文部分介绍了优化程序的四种方法：使用更好的算法、使用更好的数据结构、使用底层的编程语言、以及接受不太精确的解决方案。文章开头和结尾则提出了一些教训：我们对于性能优化问题容易过度乐观、我们可能只顾性能而牺牲了正确性、不该作过早和复杂的优化、优化的广度比优化的深度更重要。

2、[两种线程池，以及为什么需要这两种线程池？](https://pythonspeed.com/articles/two-thread-pools/)

由于 GIL 的限制，因此在 Python 中使用线程池需要注意业务是 CPU 密集型任务还是 IO 密集型任务，这将导致在线程数量和线程池目标上的不同选择。

3、[是时候改变了：datetime.utcnow() 现已被弃用](https://blog.miguelgrinberg.com/post/it-s-time-for-a-change-datetime-utcnow-is-now-deprecated)

Python 3.12 版本中`datetime.datetime` 的 `utcnow()` 与 `utcfromtimestamp()` 方法已被标注为“deprecated”，将在未来版本中删除。文章介绍了它们的缺陷，解释了为什么它们会被弃用。替代的方法分别是：`datetime.now()` 和 `datetime.fromtimestamp()` 。

4、[Python Web 应用的线上部署](https://www.biaodianfu.com/python-web-server-deployment.html)

介绍了如何使用 Nginx+Gunicorn+Supervisor、Nginx+uWSGI+Supervisor、Waitress、Meinheld 等不同方案部署 Flask 应用，分析了它们的优缺点。

5、[Python GIL 作出的不断变化的“保证”](https://stefan-marr.de/2023/11/python-global-interpreter-lock/)

介绍了 CPython 全局解释器锁的实现细节，介绍了从 Python 3.9 到目前 3.13 开发版之间的变化。其中有一项很大的差别，在 3.9 及早期版本，GIL 在执行很多字节码时会释放，而在 3.13 版本，只在少数字节码上检查是否释放 GIL。

6、[使用 pip-compile 和 pip-tools 作 Django 的依赖项管理](https://learndjango.com/tutorials/django-dependency-management-pip-compile-and-pip-t)

Python 的依赖管理有很多选择，文章介绍了 pip-compile 和 pip-tools 的组合方案。

7、[Python 程序的 bug 分类](https://threeofwands.com/the-types-of-errors-in-python-apps/)

作者将程序的 bug 分成四类：类型错误和 linting 错误、导入时异常、运行时异常、静默的错误。处理的策略是减少出现后面的错误类型，将其变为前面的错误处理。

8、[有多少 Python 核心开发者使用类型提示？](https://blog.orsinium.dev/posts/py/core-devs-typing/)

Python 的类型提示正在逐渐流行，但是，它在核心开发者群体中已经普及到什么程度了呢？作者经过分析，给出了这样的数据：所有核心开发者中，大约 53% 的人最近有开源项目，其中 39% 的人使用类型提示。近 3 年里加入团队的人中，有 76% 使用类型提示。

9、[记一次用 Python 的 ast 模块将 Flask 项目转为 Quart 的尝试](https://juejin.cn/post/7304706387645071395)

作者为了使用 OpenAI 返回的异步迭代器内容，将不支持异步的 Flask 项目重构成了支持异步的 Quart。但手动修改的工作量太大，因此他想到通过解析 ast 来修改，提升项目转换的效率。

10、[Python NumPy 库的可视化解释](https://solothought.com/tutorial/python-numpy/)

文章使用了大量直观的图形展示 Numpy 数据的分布以及数据变化过程，让你轻松掌握 Numpy 数据操作。

11、[用组合还是继承？我有不同看法](https://coady.github.io/posts/composition-vs-inheritance.html)

传统观点认为组合优于继承，但作者认为 Python 不能很好地支持，若教条式使用组合，只会引入问题，因此作者提供了一种简单实现的思路。

12、[选择正确的数据仪表板工具：Streamlit 和 Shiny 的独特优势](https://python-bloggers.com/2023/10/choosing-the-right-data-dashboard-tool-the-unique-strengths-of-streamlit-and-shiny/)

在数据驱动关键决策的时代，交互式仪表板已成为商业、科学研究等行业不可或缺的工具。Streamlit 和 Shiny（包括 RShiny 及 PyShiny）是功能强大的框架，文章介绍了它们各自的优势。

🎁**Python潮流周刊**🎁我会在 [电报频道](https://t.me/pythontrendingweekly) 分享很多不收录在周刊里的内容，目前已有 1200+ 同学关注，欢迎你的加入！

### 🐿️项目&资源

1、[screenshot-to-code：利用截图生成 HTML/Tailwind/JS 代码](https://github.com/abi/screenshot-to-code)

超级火爆的新项目，它使用 GPT-4 Vision 生成代码，使用 DALL-E 3 生成与截图相似的外观。甚至可以输入 URL 来实时克隆一个网站！（star 19.4K）

2、[sqlalchemy_data_model_visualizer：将SQLalchemy数据模型转换为漂亮的SVG图表](https://github.com/Dicklesworthstone/sqlalchemy_data_model_visualizer)

将 SQLAlchemy ORM 模型生成高质量的可视化效果，使用 Graphviz 将每个模型呈现为有向图，更容易理解数据库表之间的关系。

![数据库表的有向图](./img/2023-11-25_sql.png)

3、[aiconfig：配置驱动的 AI 应用开发框架](https://github.com/lastmile-ai/aiconfig)

它通过将提示、模型参数及模型密切相关的逻辑与应用代码分离，降低复杂度。SDK 是与模型无关的，可扩展到任何生成式 AI 模型。

4、[PyNest：基于 FastAPI 构建的框架，遵循 NestJS 的模块化架构](https://github.com/PythonNest/PyNest)

可以让你轻松构建可扩展且可维护的 API，支持依赖注入、类型注释、装饰器和代码生成。

5、[StyleTTS2：近乎人类水平的文本转语音库](https://github.com/yl4579/StyleTTS2)

它利用风格扩散和对抗训练与大型语音语言模型 （SLM） 来实现人类水平的 TTS 合成。（star 2.7K）

6、[pyjokes：程序员的一句话笑话（笑话即服务）](https://github.com/pyjokes/pyjokes)

安装后，只需从命令行调用 pyjoke 或将其添加到 .bashrc 文件中，每次打开终端时都会看到一个笑话。

7、[gTTS：用于与 Google 的文本转语音 API 交互](https://github.com/pndurette/gTTS)

用于调用 Google Translate 的文本转语音 API，提供可定制的语音特定的句子分词器，以及可定制的文本预处理器。（star 2K）

8、[chatfairy：极简的网页版聊天室，只依赖 Flask](https://github.com/yuxiaoy1/chatfairy)

极简的聊天室应用，前后端代码在仅 115 行的单文件中，使用 SSE 作后端消息推送，不依赖websocket，支持用户认证、多用户聊天、上下线通知、路由保护。（投稿自@yuxiaoy1）

![聊天效果演示](./img/2023-11-25_chatfairy.png)

9、[streamlit-shadcn-ui：在 streamlit 中使用 shadcn-ui 组件](https://github.com/ObservedObserver/streamlit-shadcn-ui)

Streamlit 的组件选择相对局限，且样式比较古老。这个项目将前端流行的 shadcn 组件库引入到 Streamlit 当中，UI 更为美观。

10、[video-subtitle-remover：用 AI 去除图片/视频的硬字幕/水印](https://github.com/YaoFANGUK/video-subtitle-remover)

可无损分辨率将视频中的硬字幕去除，生成去除字幕后的文件，利用 AI 填充原字幕区域；支持自定义字幕位置，支持全视频自动去除所有文本。

11、[flowty-realtime-lcm-canvas：使用 LCM 和 gradio 库的草图到图像演示](https://github.com/flowtyone/flowty-realtime-lcm-canvas)

将你的草稿图实时变成生动的图像，可更改 UI 中的模型 ID 来使用不同的模型。（star 1.5K）

12、[pyephem：科学级的天文学计算库](https://github.com/brandon-rhodes/pyephem)

可执行高精度天文学计算，用于查找行星、彗星或小行星的位置，确定特定星体的位置，计算月球各阶段的日期，天文坐标系转换，确定春分和冬至的日期，等等。

本文首发于：[https://pythoncat.top/posts/2023-11-25-weekly](https://pythoncat.top/posts/2023-11-25-weekly)

## 29 Rust 会比 Python 慢？！ 

[博客原文](https://pythoncat.top/posts/2023-12-02-weekly) | 发布时间：2023-12-02

### 🦄文章&教程

1、[Rust std fs 比 Python 慢！真的吗！？](https://mp.weixin.qq.com/s/m-IBomxu88DlNcEyOgyOew)

一篇长文，由一个诡异的问题开始：Rust 写的程序竟然比 Python 慢？！作者在定位根因的过程中，多次得到 Rust 方案比 Python 慢的结果，甚至 C 版本代码也比 Python 的慢！层层深入，用上各种定位手段，最后发现竟然是 AMD CPU 内核的问题！

2、[Python 中性能最快的时间戳函数是哪个？](https://www.dataroc.ca/blog/most-performant-timestamp-functions-python)

Python 中有哪些获取时间戳的函数？它们的性能表现如何？文章取了 7 种函数进行性能测算，发现 time.time() 是最快的。文章发布后引起了一些争议，于是作者写了第二篇，做了 Win10、WSL2 和 Ubuntu20 的对比，也增加了 Python 3.10 和 3.12 的对比。（附：[第二篇性能对比的文章](https://www.dataroc.ca/blog/most-performant-timestamp-functions-python-2)）

![调用50万次所需的时间](./img/2023-12-01_time.png)

3、[Python 是 Easy，Go 是 Simple，但 Simple != Easy](https://preslav.me/2023/11/27/python-is-easy-golang-is-simple-simple-is-not-easy/)

Python 简单易用门槛低，因为它把很多复杂的工作交给了解释器，这使得它适合用作原型设计，快速开发应用。Go 语言也简单，但相比 Python 的规则要多一些，性能也更高。作者的建议是同时发挥两者的优势。

4、[使用 Numba 提升 pandas.DataFrame.apply 的 C 级别性能](https://labs.quansight.org/blog/unlocking-c-level-performance-in-df-apply) 

在 Pandas 2.2.0 中，DataFrame.apply 可以指定一个新的 numba 引擎，实现并行化的操作。文章介绍了这个引擎的工作原理、它支持的应用场景及无法做到的事，同时给出了多项性能测试的数据。

5、[一份杂乱的 Flask 维护任务清单](https://davidism.com/maintainer-notes/)

作者是 Flask 的维护者之一，列出了一份任务清单，提供给 Flask 的贡献者们方便着手处理。我们多数人没有维护开源项目的经验，或许无法想象项目维护者们要做那一大堆与编码完全无关的事。（题外话：Flask 的 star 数在本周已落后于 FastAPI，失去了 Web 框架第二高 star 的位置）

6、[用子解释器运行 Python 并行程序](https://tonybaloney.github.io/posts/sub-interpreter-web-workers.html)

Python 3.12 开放了子解释器的一个 API，它有什么用呢？子解释器与多线程、多进程有什么区别，它们的性能差距有多少？将子解释器用于 Web 开发，会有什么效果？作者用开发中的 Python 3.13 做了一些实验，结果有惊喜也有程序异常。期待明年真正无-GIL 的 Python 吧！

![工作负载和执行时间的增长率](./img/2023-12-01_sub.png)

7、[新的开源库 VS. 旧的开源库 ](https://dev.to/taipy/new-open-source-vs-old-open-source-33k7)

文章选取了 10 组在 Python 社区很知名的库，同时给出它们相对应的替代库，这里最没争议的估计是 Ruff 替代 Pylint，其它则还有：Taipy/Streamlit、Polars/Pandas、Dask/PySpark、PyTorch/TensorFlow ……

8、[在 Pandas 的世界中使用 Polars](https://pythonspeed.com/articles/polars-pandas-interopability/)

Polars 是速度更快、内存效率更高、更易于使用的数据处理库，可作为 Pandas 的替换。但是替换后如何与第三方库更好地集成呢？文章介绍了几种处理方法，实现从 Pandas 到 Polars 的无缝切换。

9、[Python 的软关键字有哪些？](https://mathspp.com/blog/til/pythons-soft-keywords)

软关键字（soft keyword）指的是可以被重新赋值的关键字。作者想利用正则表达式从 Python 最新的语法文件中找出所有的软关键字。最后得知只需下面两行代码就能做到（以下是 Python 3.12 的结果，即现在有 4 个软关键字）：

>>> import keyword
>>> keyword.softkwlist
>>> ['_', 'case', 'match', 'type']

10、[用 Python 实现机器人爸爸](https://blog.untrod.com/2023/11/robot-dad.html)

为了应对小孩的提问，作者开发了一个“机器人爸爸”。用到了 Eleven Labs 作声音克隆，用 Picovoice 语音转文字提取唤醒词，最后调用 ChatGPT 接口获取答案。

11、[如何（以及如何不）设计 REST API](https://github.com/stickfigure/blog/wiki/How-to-(and-how-not-to)-design-REST-APIs)

文章列出了十多项 REST API 的最佳实践规则，解释了规则的含义及实现，另外，作者嘲笑了几家公司被广泛使用的 API，将它们作为规则的反例。

12、[如何调试 Asyncio 程序？](https://superfastpython.com/debug-asyncio/)

文章介绍了几种调试 Asyncio 代码的方法，包括启用它的调试日志、在调试模式下运行事件循环、自定义调试信息等。（附：文章的姊妹篇 [如何分析 Asyncio 程序？](https://superfastpython.com/profile-asyncio-programs/) 分析慢程序和高频函数）

### 🐿️项目&资源

1、[marker：高效将 PDF/EPUB/MOBI 转换为 Markdown](https://github.com/VikParuchuri/marker)

支持将多种文件格式转换为 markdown，可删除页眉/页脚，将方程式转换为 latex，格式化处理代码块和表格，另外也支持多种语言。（star 2.3K）（附：将整本 PDF 版《Think Python》[转换后的效果](https://github.com/VikParuchuri/marker/blob/master/data/examples/marker/thinkpython.md)）

![与Nougat在速度和准确性的对比](./img/2023-12-02_maker.png)

2、[awesome-django-performance：精选资源，用于分析和优化 Django 项目](https://github.com/st3v3nmw/awesome-django-performance)

这个项目整理了一些库、工具、文章和书籍，主要集中在 profile、数据库、缓存、序列化、任务处理和监测等方面。

3、[datamodel-code-generator：将 JSON/YAML 转换为 Pydantic 模型](https://github.com/koxudaxi/datamodel-code-generator)

一个数据模型代码生成器，支持多种输入类型（OpenAPI、JSON、YAML、CSV、Python 字典、GraphQL），输出 Pydantic、dataclass、TypeDict 等类型。（star 2K）

4、[fastapi-code-generator：用 openapi 文件创建 FastAPI 程序](https://github.com/koxudaxi/fastapi-code-generator)

它利用 datamodel-code-generator 生成 pydantic 模型，基于 OpenAPI 格式的接口文件，快速生成 FastAPI 项目。支持自定义模板，允许将自定义变量传给自定义模板。

5、[kanban-python：终端中的看板应用程序](https://github.com/Zaloog/kanban-python)

在命令行窗口中实现的看板应用工具，有漂亮的表格、配置与数据分离、可自动创建任务、可作任务跟踪。

![看板应用的示例](./img/2023-12-2-kanban.png)

6、[saq：简单的异步队列](https://github.com/tobymao/saq)

一个基于 Asyncio 和 Redis 之上的简单且高性能的任务队列框架。提供有一个简单的 UI，可查看任务队列、状态及执行详情等信息。

7、[pyqtgraph：用于科学/工程应用的数据可视化及 GUI 工具](https://github.com/pyqtgraph/pyqtgraph)

一个高性能的绘图工具库，利用 Numpy 作数值运算、用 Qt 的 GraphicsView 框架作 2D 显示和 OpenGL 作 3D 显示。（star 3.5K）

8、[toga：Python 原生、OS 原生的 GUI 工具包](https://github.com/beeware/toga)

一个用于创建跨平台桌面应用的 GUI 工具，支持 MacOS、Windows、Linux (GTK)、Android、iOS 和单页 Web 应用。（star 3.9K）

9、[autometrics-py：函数级的指标监测工具](https://github.com/autometrics-dev/autometrics-py)

它提供了一个装饰器，可检测函数的请求率、错误率和延迟等指标，方便你识别和调试程序的问题。支持用 Prometheus 查询与分析、开箱即用的 Grafana 仪表板、自定义告警、运行开销小。

![](./img/2023-12-02_autometrics.png)

10、[compiled：Python 标准库的编译后的变体](https://github.com/pycompiled/compiled)

Python 中有些标准库是用纯 Python 实现的，可能会成为性能瓶颈。这个项目将经过 mypyc 类型检查的标准库编译成 C 代码版本，比原始版本快 2-4 倍。目前已完成 tomllib 和 difflib，计划中还有 asyncio、urllib、zipfile、argparse 和 uuid。

11、[transpyler-gpt：GPT 驱动的 Python 转译器，让代码在旧版本上运行](https://github.com/frostming/transpyler-gpt)

它借助 GPT 将高版本 Python 代码转译成目标环境的 Python 版本代码，实现向下兼容执行。例如将 Python 3.10+ 的 match-case 代码转译成 if-else 代码，可在更低 Python 版本中执行。

12、[clone-voice: 一个带 web 界面的声音克隆工具](https://github.com/jianchang512/clone-voice)

支持中文、英文、日语、韩语 4 种语言，可在线从麦克风录制声音。支持文字转语音和语音变声。（star 1.3K）

![语音克隆演示](./img/2023-12-02_voice.png)

### 🐢播客&视频

1、[Talk Python To Me #439：Pixi 一个高性能的包管理器](https://talkpython.fm/episodes/show/439/pixi-a-fast-package-manager)

Pixi 是用 Rust 开发的基于 Conda 的包管理器。

2、[Mouse Vs Python #23：与 Charlie Marsh 聊 Ruff Formatter](https://www.blog.pythonlibrary.org/2023/11/27/episode-23-the-ruff-formatter-with-charlie-marsh/)

Ruff 是一个用 Rust 编写的 Python linter+formatter，而且两方面都是性能最快的。

### 🥂讨论&问题

1、[你用 Python 做过最酷的事情是什么？](https://www.reddit.com/r/Python/comments/17upt2f/whats_the_coolest_things_youve_done_with_python/)

Reddit 上的热门讨论帖，也有近 700 条评论，需要刷很久才能看完。。。

2、[鼓励使用命名参数的语法糖](https://discuss.python.org/t/syntactic-sugar-to-encourage-use-of-named-arguments/36217)

函数的命名参数提高了可读性，但也可能使代码重复和冗长。作者提出了一个简化变量写法的语法糖，得到了不少核心开发者的支持。

## 30 非洲 Python 社区给 PSF 的一封公开信 

[博客原文](https://pythoncat.top/posts/2023-12-09-weekly) | 发布时间：2023-12-09

### 🦄文章&教程

1、[Python 非洲：致 Python 软件基金会的一封公开信](https://pythonafrica.blogspot.com/2023/12/an-open-letter-to-python-software_5.html)

非洲十多个国家的 Python 社区组织者们联名给 PSF 的一封公开信。信件的起因是 PSF 给非洲首届 DjangoCon 的 9000 美元拨款延迟了，由此引出 PSF 内部存在的其它问题：人种歧视、对边缘群体缺乏关注、不遵守当地法律等。（题外话：PSF 在 2022 年给亚洲的拨款占比 1%，远低于给非洲的 16%……）

2、[Django 5.0 发布了！](https://docs.djangoproject.com/en/5.0/releases/5.0)

Django 5.0 在本周发布了，只支持 Python 3.10 及以上版本。主要新功能：新增`Field.db_default` 参数，可设置由数据库计算的默认值；`GeneratedField` 可以创建由数据库生成的列；引入了字段组和字段组模板，简化了表单字段相关元素的呈现。（附：一则介绍[Django 新特性的视频](https://www.youtube.com/watch?v=lPl5Q5gv9G8) ）

![定义数据库字段的默认值](./img/2023-12-08_django.png)

3、[56 行代码用 Python 实现一个 Flex/Lex](https://www.skywind.me/blog/archives/2761)

Lex/Flex 可用于生成词法分析器，用于处理源代码中的词法结构。作者通过改造 Python 官方文档中的一段程序，实现了一个通用的基于规则的词法分析器，可用于处理简单的词法分析需求。

4、[如何在 FastAPI 正确地使用依赖注入？](https://so1n.me/2023/12/07/how-to-use-dependency-injection-in-fastapi/)

文章指出了人们在 FastAPI 中使用依赖注入时的两种错误方式，介绍了如何在 FastAPI 中使用`python-dependency-injector` 实现依赖注入的方法。

5、[为什么不应该在 Python 中过度使用列表解析式？](https://www.kdnuggets.com/why-you-should-not-overuse-list-comprehensions-in-python)

适当使用列表解析式，可以让你的代码更简洁优雅，但是过度使用的话，将严重破坏代码的可读性。作者给出了三个例子，分别用列表解析式与常规方案实现，让读者感受到易理解的代码胜过花哨的炫技。

6、[非类型化的 Python：曾经的 Python](https://lucumr.pocoo.org/2023/12/1/the-python-that-was/)

Flask 的作者 Armin Ronacher 在最新文章中讨论了 Python 的类型话题。核心观点认为 Python 的内在哲学在于它的动态类型，这是它的优势，这与类型化是冲突的，类型化有其价值，但也会带来成本。作者怀念曾经的 Python。

7、[用 django-watson 给 Django 项目添加全文搜索](https://idiomaticprogrammers.com/post/django-watson-full-text-search-guide)

一篇非常详细的教程，使用 [django-watson](https://github.com/etianen/django-watson) 和 PostgreSQL 给 Django 项目添加全文搜索功能。这个库支持跨多个 model 进行搜索，支持按相关性排序。（star 1.2K）

8、[解析 Celery 的扇出模式](https://www.better-simple.com/django/2023/12/06/fanout-pattern-explained/)

Celery 的扇出模式（Fanout）是一种任务分发的模式，由一个任务触发多个并行执行的子任务。作者介绍了这种模式的实践运用，认为这是在任务签名中实现动态工作流的好方法。

9、[Python Asyncio 的 7 个替代库](https://superfastpython.com/asyncio-alternatives/)

Asyncio 是 Python 用作异步编程的标准库，但它不是你唯一的选择。文章介绍和对比了 7 个同类的库，有比 Asyncio 更早发布的 Tornado、Twisted 及 Gevent，也有更为年轻的 Curio、Trio、AnyIO 与 UVloop。

![异步编程库的star趋势](./img/Asyncio-Alternatives-Star-History.png)

10、[解密 CPython：当执行 a+b 时，背后发生了什么？](https://codeconfessions.substack.com/p/cpython-dynamic-dispatch-internals)

一篇深度剖析 CPython 解释器的动态分发机制的文章。动态分发（Dynamic Dispatch）指的是在程序运行时（而不是在编译时）确定调用哪个方法或函数的过程。a+b 看似简单，但是它们可能有多种类型组合，实际的计算过程可能完全不同。

11、[如何使用 Python 播放 GIF？](https://www.blog.pythonlibrary.org/2023/12/05/viewing-an-animated-gif-with-python/)

GIF 是一种图像格式，是无声的动画视频。有什么 Python 库可以通过代码来播放 GIF 动画么？文章分别介绍了 tkinter、PySimpleGUI 和 Jupyter Notebook 这三种方式。

12、[用 Python 开发一个微型的 REPL](https://bernsteinbear.com//blog/simple-python-repl/)

REPL（Read-Eval-Print Loop）是指编程语言的交互式环境。Python 标准库中有个`code` 模块，提供了实现 REPL 的功能，文章逐步提出需求，演示了如何用它开发一个简单的 REPL。

> 🎁**Python潮流周刊**🎁已顺利更新到第 30 期啦！我在几天前写了一篇《[聊聊技术周刊的变现](https://pythoncat.top/posts/2023-12-06-future)》分享了对未来发展的思考，近期也会对所有周刊再作一次总结，敬请期待！

### 🐿️项目&资源

1、[self-operating-computer：使多模态模型能够操作计算机](https://github.com/OthersideAI/self-operating-computer)

这是近期基于 GPT-4v 的最火项目之一。让大语言模型像人类一样查看屏幕内容，操作鼠标和键盘来实现特定的目标。当前的挑战是 GPT-4v 在鼠标点击位置方面的错误率很高。（star 5.1K）

2、[marko：具有高扩展性的 markdown 解析器](https://github.com/frostming/marko)

一个专注于扩展开发体验的 Markdown 解析器，遵循 CommonMark 规范 v0.30 规范。速度不是它的优势，但能方便观察 AST、实现自己的元素和渲染器。（投稿自@frostming）

3、[WeChatMsg：导出微信聊天记录成 HTML/Word/CSV文档](https://github.com/LC044/WeChatMsg)

本周火爆朋友圈的项目，作者是一名在校大学生。支持导出微信聊天记录，支持生成年度聊天报告。Slogan 不错：“我的数据我做主”。可以导出数据用于训练个人 AI！（star 12.5K）

![年度聊天报告的一页](./img/image-20230520235409112.png)

4、[PyWxDump：获取微信账号信息、导出聊天记录](https://github.com/xaoyaoo/PyWxDump)

这是上一个项目的依赖，可解密数据库，查看和导出聊天记录，支持微信多开场景获取多用户信息。（star 1.6K）（PS. 总感觉这两个项目会被某信针对，你觉得呢？）

5、[mlx：适用于 Apple 芯片的阵列框架](https://github.com/ml-explore/mlx)

Apple 推出的基于自家芯片的机器学习阵列框架，拥有跟 Numpy 相近的 Python API。（star 7.2K）

6、[DSAlgo：数据结构和算法的面试题集锦](https://github.com/SamirPaulb/DSAlgo)

一个精选仓库，收录了大量数据结构和算法题，使用 Python 解答。另外它还收录了不少大公司的面试题与计算机类学习笔记等资料。（star 1.7K）

7、[Python 在线编译器网站](https://pythononlinecompiler.com/)

一个网页在线版本的 Python 解释器，支持 Python 2.7、3.3-3.10 版本，预装了大部分的常用库，包括 Turtle、Tkinter、Pygame、Numpy、Matplotlib、Pandas、Scipy，等等。

![在线画个小闹钟](./img/2023-12-09_compiler.png)

8、[aio-libs：65 个基于 Asyncio 的库/项目](https://github.com/aio-libs)

它收录了 Python 社区中与异步 IO 相关的库，包括 aiohttp、aiopg、aiomysql、yarl、aiokafka 等等。

9、[kolo：查看 Django 应用的执行过程](https://github.com/kolofordjango/kolo)

一款 VSCode 插件，具有帧可视化、漂亮的火焰图、显示执行了 SQL 查询的代码行、支持直接跳转到异常位置等。

![kolo功能介绍图](./img/2023-12-09-kolo.png)

10、[dnsteal：DNS 渗透工具，通过 DNS 请求隐秘发送文件](https://github.com/m57/dnsteal)

一个只有 200 多行代码的小工具，伪造 DNS 服务器，隐秘截取请求中的文件。支持多文件、支持 Gzip 压缩、支持自定义子域信息等。（star 1.6K）

11、[github-trends：使用自定义卡片美化 GitHub 个人主页](https://github.com/avgupta456/github-trends)

可生成你在 Github 的贡献日历、代码行数分析、多种维度下的个人贡献统计图等，轻松将动态图标嵌入到你的个人资料页面中。（star 6.4K）

12、[Depix：还原打了马赛克的截图信息](https://github.com/spipm/Depix)

在截图上打了马赛克就安全了么？不！这个库能以较高的准确度还原图片中的纯文本信息。仓库中有技术原理解释，以及对使用缺陷的说明。（star 24.7K）

![恢复文本信息的示例](./img/Recovering_prototype_latest.png)

## 后记

Python 潮流周刊由 **Python猫** 出品，主理人是**豌豆花下猫**。

我们在很多平台上都有账号，以下是最主要的阵地，欢迎你前来互动~~

1、[公众号](./img/python_cat.jpg)：除更新周刊外，还发布其它原创作品，并转载一些优质文章。（可加好友，可加读者交流群）

2、[小报童](https://xiaobot.net/p/python_weekly)：本周刊最主要的付费订阅平台。

3、[博客](https://pythoncat.top)：我的独立博客，上面有历年原创/翻译的技术文章，以及从 2009 年以来的一些随笔。

4、[Twitter](https://twitter.com/chinesehuazhou)：发布一些即时内容，欢迎与我建立社交联系。我的关注列表里有大量 Python 相关的开发者与组织的账号。

5、[Telegram](https://t.me/pythontrendingweekly)：除了发布周刊的通知外，我将它视为一个“副刊”，补充发布更加丰富的资讯。

6、[Github](https://github.com/chinesehuazhou/python-weekly)：你可以获取本周刊的 Markdown 源文件，做任何想做的事！

**其它附录：**

1、[技术周刊的转变：如何平衡热爱与现实？](https://pythoncat.top/posts/2024-04-14-paid-column) 聊聊周刊为什么推出付费专栏，以及今后的发展计划

2、[周刊是聪明人筛选优质知识的聪明手段！](https://pythoncat.top/posts/2024-05-06-information-gap) 周刊希望能打破信息差，做你高质量的信息筛选器

3、[Python潮流周刊的数据统计看板](https://pythoncat.top/weekly_kanban) 包含柱状图、饼图和词云等维度的数据分析