---
title: 'Python 潮流周刊#46：如何用 Python 预测日食的时间和轨迹？'
pubDate: 2024-04-13
author: '豌豆花下猫'
---

你好，我是猫哥。这里每周分享优质的 Python、AI 及通用技术内容，大部分为英文。另有[电报频道](https://t.me/pythontrendingweekly)作为副刊，补充发布更加丰富的资讯，欢迎关注。

**特别提醒：** 本期周刊赠书 7 本《Python基础教程（第3版·修订版）》，详情见文末。

本周开始试运行订阅模式，如果你习惯微信端阅读，欢迎订阅我的付费专栏。前 100 名订阅者可享受 8 折优惠，请点击领取：[优惠券](https://xiaobot.net/coupon/325cca25-2188-4523-bd9e-b58543f1bfbd)

## 🦄文章&教程

1、[如何用 Python 预测日食的时间和轨迹？](https://erikbern.com/2024/04/07/predicting-solar-eclipses-with-python.html)

本周一（04.08）上演了今年唯一一次日全食，作者由此想到如何用编程方法预测日食发生的时间。文章分享了计算的技巧，绘制了本次日全食的轨迹，同时预测了 2020-2030 年间所有的日食。

![今年日全食的运动轨迹](https://img.pythoncat.top/2024-04-12_eclipses.png)

2、[我在开源软件上全职工作 503 天的经验分享](https://mathspp.com/blog/503-days-working-full-time-on-foss-lessons-learned)

作者全职加入 Textualize 公司，参与了流行的 Python 库 Rich 和 Textual 的开发，文章主要分享了四个方面的经验：靠网络形象获得工作机会、你的自我不应该妨碍你的工作、如何与用户及贡献者互动、如何在完全陌生的大型代码库上开发。

3、[修复 Python 代码坏味道的最佳实践](https://www.arjancodes.com/blog/best-practices-for-eliminating-python-code-smells/)

代码坏味道（Code Smells）本身不是错误，但是会影响代码质量和可维护性。文章介绍了5 类常见的代码坏味道，以及修复这些问题的最佳实践。

4、[如何用 Python 作质因式分解？](https://compucademy.net/prime-factorization-with-python/)

文章介绍了几种用 Python 作质因数分解的方法，从暴力解法到经典的埃拉托色尼筛法，重点介绍了后者的算法思路以及代码的优化方法。

5、[Supervisor-持久化进程部署方案](https://juejin.cn/post/7354406980784373798)

Supervisor 是一个 C/S 架构的进程监控与管理工具，文章介绍了其基本用法和部分高级特性，用于解决部署持久化进程的稳定性问题（可克服`nohup cmd &` 命令的弊端）。

6、[PEP-744 – 关于 JIT 编译](https://peps.python.org/pep-0744/)

JIT 编译器已经合入 CPython 3.13 主分支，这个最新发起的 PEP 旨在回答关于它的一些常见问题，主要目标是明确这个 JIT 应满足什么条件才能变为非实验性的特性。

7、[Zapier 如何能自动执行数十亿个任务？](https://newsletter.systemdesign.one/p/zapier-architecture)

Zapier 是流行的在线自动化平台，支持数千款 APP。文章介绍了 Zapier 采用的技术架构，包括用 Django 框架作后端，用 RabbitMQ 和 Celery 来创建分布式工作流引擎，用 Kafka 作分布式事件存储和流处理，等等。

8、[Meta 使用单体架构仅 5 个月就发布了 Threads](https://www.infoq.com/news/2024/04/meta-threads-instagram-5-months/)

去年的一大技术新闻是扎克伯格的 Meta 推出 Threads 与马斯克的 Twitter 竞争。Theads 的技术栈与 Instagram 几乎相同，大型单体架构，Django 框架改造的后端，数据存储在 TAO，用 ZippyDB 作缓存。

9、[Python 命名约定：最佳实践和示例](https://compucademy.net/python-naming-conventions/)

Python 以其可读性和简单性而闻名，它有一些关于命名的规范，有助于保持代码一致性和清晰度。文章通过示例介绍了 Python 正确的命名风格，并给出了反例。（附：Google 内部专注于代码质量的“Code Health”系列，[最新一篇](https://testing.googleblog.com/2024/03/whats-in-name.html)分享了几条命名原则，有 Python 之禅的味道）

10、[Great_Tables 的设计理念](https://posit-dev.github.io/great-tables/blog/design-philosophy)

文章回顾了表格的历史（从古代的方格到高度结构化的数据格式），提出表格在当今面临的问题，介绍了如何通过`Great Tables` 库创建更美观好用的表格。

![一张表格的组成部分](https://img.pythoncat.top/composition_of_a_table_in_GT.png)

11、[Python 为什么不能将列表作为字典的键？](https://blog.dailydoseofds.com/p/how-python-prevents-us-from-adding)

若将列表作为字典的键，会报错`TypeError` ，这是为什么呢？在这个过程中，Python 内部是如何执行的呢？文章解答了这个问题，原因跟`__hash__()` 魔术方法有关。

12、[使用树莓派+Python+Influxdb 开发温度监测器](https://nathanielkaiser.xyz/treehousetemps.html)

作者基于 Raspberry Pi 1b 和 DS18B20 温度探头开发了一个温度监测器，使用 Python 将温度数据传给 Influxdb，实现检测温度的变化。（根据文章开头描述，我推测作者现在应该只有11-12岁）

13、[如何用单行 Python 代码通过面试编码](https://ivaniscoding.github.io/posts/codeinterview/)

这篇文章建议在做面试编程时，将答案写成一行代码的形式，文中给出了一些例子如反转二叉树、计算二叉树深度、查找第一个回文等题目，使用各种花销的技巧将代码写成一行。但是，注意文章发布的日期，它只是一个愚人节玩笑，不要当真！

🎁**Python潮流周刊**🎁每 30 期为一季，第一季的精华内容已整理成一篇，方便你随时查看。在线访问地址：[Python 潮流周刊第一季精华合集（1~30）](https://pythoncat.top/posts/2023-12-11-weekly)

## 🐿️项目&资源

1、[open-interpreter：计算机上的自然语言界面](https://github.com/OpenInterpreter/open-interpreter)

它可让 LLM 在本地运行代码（Python、Javascript、Shell 等）。安装后运行 `$ interpreter` ，即可以通过终端中类似 ChatGPT 的界面与 Open Interpreter 聊天。（star 47.1K）

2、[narwhals：Polars、pandas、cuDF、Modin 的轻量级可扩展兼容层](https://github.com/MarcoGorelli/narwhals)

无缝支持 Polars、pandas、modin 和 cuDF，使用 Polars API 的子集，使用 Polars 的表达式，100% 分支覆盖率。

3、[mantis：可自动发现、侦察和扫描漏洞的安全框架](https://github.com/PhonePe/mantis)

一个自动扫描安全漏洞的命令行框架。输入顶级域名，它可发现相应的子域名和证书并进行侦察，然后对漏洞、机密、错误配置和网络钓鱼域名进行全面扫描。

4、[FreeAskInternet：免费私有且本地运行的搜索聚合器与答案生成](https://github.com/nashsu/FreeAskInternet)

用户提出一个问题，它将用多个引擎搜索，并将搜索结果组合给 LLM，根据搜索结果生成答案。不需要 GPU 或 OpenAI 或 Google API 密钥，即完全免费。使用免费的 ChatGPT3.5 / Qwen / Kimi / ZhipuAI（GLM） API，支持 ollama，支持 Docker 部署。（star 6.6K）

5、[PyCharm 博客总结的一系列 Django 学习资源](https://blog.jetbrains.com/pycharm/2024/04/django-learning-resources/)

PyCharm 是最专业的 Python IDE，其官方博客经常发布技术文章，在 YouTube 上也经常发布视频。这篇文章汇聚了一些跟 Django 相关的文章和视频的学习资源。

6、[great-tables：用 Python 生成信息丰富的精美表格 ](https://github.com/posit-dev/great-tables)

前文分享了这个库的设计理念。它依照表格各部分而定义了一系列组件，支持灵活调整表格布局。使用  Pandas 或 Polars 的 DataFrame 数据作输入。

7、[jiaTansSSHAgent：实现 XZ sshd 某些后门功能](https://github.com/blasty/JiaTansSSHAgent)

最近有一则爆炸性新闻是“XZ 的后门事件”。这个项目用 Python 实现了部分后门功能，你可以通过 SSH 客户端来探索它们。

8、[docx2python：提取 docx 的页眉、页脚、文本、脚注、尾注、属性和图像](https://github.com/ShayHill/docx2python)

它可以将 docx 文件的各项元素提取成 Python 对象，包括文本和图像，实现内容读取、插入、修改等功能。

9、[WechatMoments：微信朋友圈导出工具](https://github.com/tech-shrimp/WechatMoments)

一款运行在 Windows 上的，能备份导出朋友圈为 html 的工具，可下载图片/视频永久保存，支持根据联系人和朋友圈时间进行过滤导出。

10、[low_cost_robot：超低成本实现机械臂](https://github.com/AlexanderKoch-Koch/low_cost_robot)

组装和控制一条机械臂，需要多少成本？这个项目给出的方案成本约 250 美元，且支持增加一条机械臂，总计 430 美元。使用 Dynamixel XL430 和 Dynamixel XL330 伺服电机。（star 2K）

11、[drawpyo：用 Python 生成 Draw.io 图表](https://github.com/MerrimanInd/drawpyo)

Draw.io 是一个免费在线的图表工具，可创建流程图、组织结构图、UML 图、ER 图、网络图等。这个库支持创建、添加对象、设置样式等功能。

12、[drawdb：免费直观的在线数据库设计工具和 SQL 生成器](https://github.com/drawdb-io/drawdb)

浏览器中的数据库实体关系 （DBER） 编辑器，可构建图表、导出 sql 脚本、自定义编辑器等，无需创建帐户。（star 4.3K）

![](https://img.pythoncat.top/2024-04-13_drawdb.png)

## 🐢播客&视频

1、[使用 Django、Channels 和 HTMX  克隆一个流式 ChatGPT](https://www.youtube.com/watch?v=8JSiiPW4S0A)

这则视频使用 Django、websockets 和 HTMX 克隆出一个 ChatGPT。每个功能被分解为一次提交，视频解释了代码作用并演示了效果。

2、[2024 年学习数据科学的系列视频](https://www.youtube.com/playlist?list=PLTsu3dft3CWiow7L7WrCd27ohlra_5PGH)

这个系列视频有 23 期，主要面向初学者入门数据科学，涵盖 Python 编程基础、数据分析、数据可视化、大数据、机器学习等话题。

## 🐢赠书福利

不定期的福利活动，本期赠书 **7** 本《Python基础教程（第3版·修订版）》，开奖时间 **4 月 19 日** 。请给 **[Python猫](https://img.pythoncat.top/pythoncat.png)** 公众号发送数字“**8046**”，获取抽奖小程序码。

本书Python新手入门经典图书，涵盖了Python编程的方方面面。本书前半部分介绍了基础知识与概念：从安装Python、配置开发环境，到列表、元组、字符串、字典以及各种语句的基础知识，再到抽象、异常、方法、属性、迭代器等核心概念，Python与数据库、网络、C语言等工具结合使用，以及Python程序测试、打包、发布等知识。本书的后半部分，向读者详尽介绍了当下流行的多个Python项目的开发过程。

![](https://img.pythoncat.top/book-3145.jpg)

## 🐼欢迎订阅

本周刊已持续连载一年，更新内容接近 10 万字。我为此投入了大量的时间和精力，为了健康可持续性的发展，现在正考虑将周刊转为收费模式。周刊的发展离不开你们的资助，欢迎订阅我的小报童专栏。前 100 名订阅者可享受 8 折优惠，请点击领取：[优惠券](https://xiaobot.net/coupon/325cca25-2188-4523-bd9e-b58543f1bfbd)