---
title: 'Python 潮流周刊#45：越来越多的 AI 自动开发框架'
pubDate: 2024-04-06
author: '豌豆花下猫'
---

你好，我是猫哥。这里每周分享优质的 Python、AI 及通用技术内容，大部分为英文。本周刊开源，欢迎[投稿](https://github.com/chinesehuazhou/python-weekly)。另有[电报频道](https://t.me/pythontrendingweekly)作为副刊，补充发布更加丰富的资讯，欢迎关注。

**特别提醒：** 本期周刊赠书 5 本《Python语言及其应用（第2版）》，详情见文末。

## 🐱品牌合作

本周刊由公众号“**Python猫**”出品，这是一个以 Python 技术科普和分享为主的科技自媒体，全网订阅读者数 50000+，品牌合作请私信联系。

## 🦄文章&教程

1、[AutoDev：微软发布的自动化 AI 驱动开发框架](https://arxiv.org/html/2403.08299v1)

微软总部发布的研究论文，介绍了 AutoDev 框架，它使 AI 代理能够自主地编写代码、测试、构建和操作 Git 等，使用 Docker 确保开发环境的安全，并可通过配置来限制 AI 代理的权限和操作。在 HumanEval 数据集上取得了 91.5% 的代码生成准确率和 87.8% 的测试生成准确率。

![AutoDev框架概览](https://img.pythoncat.top/autodev.png)

2、[我坚持用 Django 而不是 FastAPI 的 10 个原因](https://www.david-dahan.com/blog/10-reasons-i-stick-to-django)

FastAPI 越来越流行，但是作者还坚持用 Django，文章简短介绍了 10 个原因。

3、[Django 与 ASGI 服务器](https://fly.io/django-beats/asgi-deployment-options-for-django)

ASGI 是异步服务器网关接口规范，允许异步服务器与 Web 应用框架进行通信。文章介绍了几种流行的 ASGI 服务器（Daphne、Uvicorn、Hypercorn 及 Granian），比较了它们的性能和特性，同时给出了如何选择合适的 ASGI 服务器的建议。

4、[JSON 中的数字到底是什么？](https://blog.trl.sn/blog/what-is-a-json-number/)

JSON 有两个主要的标准定义（Ecma-404 和 RFC-8259），然而现实的各种编程语言和 JSON 库在处理数字的精度和范围时，却存在诸多差异。文章对此作了一些对比和总结。

![不同语言对数字类型的表示](https://img.pythoncat.top/2024-04-06_json_number.png)

5、[CPython 源码解析：为什么 Python 列表相乘的结果那么奇怪？](https://codeconfessions.substack.com/p/why-do-python-lists-multiply-oddly)

Python 的列表支持乘法操作，如`[[]]*4` ，将得到`[[],[],[],[]]` ，但是，这个例子中复制出的 4 个列表只是对同一个对象的引用。文章深入解析 CPython 源码，介绍了列表对象的结构及其内部对象存储机制、星号运算符的实现原理、CPython 具体如何执行列表的乘法操作。

6、[Celery 源码分析系列](https://juejin.cn/column/7352789840351887369)

Celery 是 Python 中常用的分布式任务队列库，这个系列文章已更新 9 篇，深入介绍它的基础架构、Worker 启动、重要组件、生命周期、定时任务等等内容。

7、[我在 2024 年如何管理 Python](https://outlore.dev/blog/python-dev-2024/)

作者介绍了自己最新在用的技术栈：用`mise` 作 Python 版本和虚拟环境管理、`poetry` 或 `uv` 作依赖管理、 `ruff` 作格式化和 linting，以及 `pydantic` 作运行时检查。

8、[使用 Pyodide 和 WebAssembly 将 Python 引入 Cloudflare Workers](https://blog.cloudflare.com/python-workers)

本周意义重大的一则消息：**Cloudflare 支持用 Python 编写 Workers**！此举将扩展 Cloudflare 平台的功能，将推动无服务器计算及在浏览器中运行 Python 代码。该功能目前为公测阶段，期待后续的发展。

9、[学习使用和不使用 AI 编码](https://austinhenley.com/blog/learningwithai.html)

文章提出两个基本问题：AI 代码生成工具对编程入门的新手有什么影响？新手如何在入门编程时使用 AI 代码生成工具？文章介绍了两篇论文的研究结果。

10、[使用 Whisper、FFmpeg 和 Python 轻松转录视频并添加字幕](https://www.editframe.com/guides/easy-video-transcription-and-subtitling-with-whisper-ffmpeg-and-python)

这篇教程介绍了如何用 OpenAI 的 Whisper 模型转录视频，并使用强大的 FFmpeg 工具轻松添加字幕。

11、[如何用 GitHub Actions 自动执行数据爬取？](https://medium.com/data-analytics-at-nesta/how-to-use-github-actions-to-automate-data-scraping-299690cd8bdb)

文章介绍如何使用 GitHub Actions 的定时功能自动执行数据爬取任务，介绍了 GitHub Actions 的工作原理及几个使用限制。

12、[使用断点调试 Python 代码](https://www.mostlypython.com/using-breakpoints-to-explore-your-code/)

文章介绍如何使用断点来调试和观察代码的执行过程，主要介绍了`pdb` 模块的 breakpoint() 方法的使用。

13、[Python “真正的”匿名函数](https://lwn.net/Articles/964839/)

Python 支持使用`lambda` 表达式创建匿名函数，但只支持单个表达式。社区中总是有人提出要支持更灵活的匿名函数，今年又有了，文章介绍了提议者的观点以及相反的观点。（附：[Python 之父为什么嫌弃 lambda 匿名函数？](https://pythoncat.top/posts/2020-09-20-lambda)）

🎁**Python潮流周刊**🎁每 30 期为一季，第一季的精华内容已整理成一篇，方便你随时查看。在线访问地址：[Python 潮流周刊第一季精华合集（1~30）](https://pythoncat.top/posts/2023-12-11-weekly)

## 🐿️项目&资源

1、[OpenDevin：Devin 的开源实现](https://github.com/OpenDevin/OpenDevin)

开源的 AI 软件工程师，利用了 shell、代码编辑器和 Web 浏览器等工具，充分发挥 LLMs 在软件开发中的潜力。（star 18.4K）

2、[SWE-agent：可修复 Github 问题的 AI 软件工程师](https://github.com/princeton-nlp/SWE-agent)

普林斯顿大学推出的 AI 工程师，在 SWE-bench 测试中修复了 12.29% 问题，成绩接近 Devin。（star 6.6K）

![](https://img.pythoncat.top/SWE-agent.png)

3、[openui：描述你想要的 UI，它实时帮你生成](https://github.com/wandb/openui)

一个基于 LLM 生成前端 UI 界面的框架，并可将 HTML 转换为 React、Svelte、Web 组件等。（star 4K）

4、[ragflow：基于深度文档理解的开源 RAG 引擎](https://github.com/infiniflow/ragflow)

从复杂格式的非结构化数据中提取基于文档理解的深度知识，可视化的文本分块，自动化且轻松的 RAG 工作流。（star 2.4K）

5、[zibai：高性能的纯 Python WSGI 服务器](https://github.com/abersheeran/zibai)

中文名是“兹白”，出自山海经。相比于 gunicorn ，它的性能更好，并可在 Windows 上使用。相比于 waitress ，兹白在不使用 gevent 时单进程性能与它相当，在重载情况下比 waitress 更稳定。

6、[podgenai：GPT-4 制作有声读物/播客 mp3 生成器](https://github.com/impredicative/podgenai)

可使用 GPT-4 生成关于给定主题的大约一小时的单扬声器有声读物/播客 mp3 文件。

7、[qiling：真正可检测的二进制仿真框架](https://github.com/qilingframework/qiling)

纯 Python 实现的一个高级的二进制仿真框架，支持很多操作系统和硬件架构，支持多种文件格式，支持跨架构和平台调试，具有逆向调试功能。（star 4.8K）

8、[maxtext：谷歌推出的简单、高性能及可扩展的 JaxLLM](https://github.com/google/maxtext)

用纯 Python/Jax 编写，面向 Google Cloud TPU，可实现 55% 到 60% 的模型翻牌利用率。

9、[nava：在 Python 中播放声音](https://github.com/openscilab/nava)

一个无任何依赖且支持跨平台的库，用于播放声音。支持异步模式、循环模式，主要支持`.wav` 格式。

10、[MuseV：无限长度和高保真的虚拟人视频生成](https://github.com/TMElyralab/MuseV)

基于视觉条件并行去噪的无限长度和高保真虚拟人视频生成，受 Sora 启发而开源，可配合实时高质量的唇同步模型`MuseTalk` ，构建完整的虚拟人生成解决方案。

11、[restai：一个 AIaaS（AI 即服务）开源平台](https://github.com/apocas/restai)

建立在 LlamaIndex、Ollama 和 HF Pipelines 之上，创建 AI 代理并提供简单的 REST API 来调用。

## 🐢播客&视频

1、[使用 Nextjs、Tailwind 和 Django 克隆一个全栈的 Airbnb](https://www.youtube.com/playlist?list=PLpyspNLjzwBnP-906FBRP5qzB4YXjMvnT)

油管上的系列视频，介绍如何用流行的前后端技术栈克隆一个 Airbnb 网站，可作练手项目学习。

2、[Django Brew：一档新的 Python 播客](https://djangobrew.com/episodes/14650534-episode-1-fried-green-introverts)

一档聚焦于 Django 框架的播客，第一期节目分享了 DjangoCon 2023 上的一些会议演讲内容，以及其它有趣的东西。

## 🐢赠书福利

不定期的福利活动，本期赠书 **5** 本《Python语言及其应用（第2版）》，开奖时间 **4 月 12 日** 。请给 **[Python猫](https://img.pythoncat.top/pythoncat.png)** 公众号发送数字“**8045**”，获取抽奖小程序码。

全书分两部分，第一部分由浅入深地介绍 Python 的基础知识，第二部分介绍 Python 的应用，涉及领域包括 Web 应用、数据库、网络和机器学习。本书通俗易懂，阅读起来饶有乐趣，十分适合想快速获得 Python 应用经验的新手。

![](https://img.pythoncat.top/book-2741.jpg)

## 🐼欢迎订阅

- [微信公众号](https://img.pythoncat.top/python_cat.jpg)：除更新周刊外，还发布其它原创作品，并转载一些优质文章。（可加好友，可加读者交流群）
- [博客](https://pythoncat.top) 及 [RSS](https://pythoncat.top/rss.xml)：我的独立博客，上面有历年原创/翻译的技术文章，以及从 2009 年以来的一些随笔。
- [邮件](https://pythoncat.substack.com) 及 [RSS](https://pythoncat.substack.com/feed)：在 Substack 上开通的频道，满足你通过邮件阅读时事通讯的诉求。
- [Github](https://github.com/chinesehuazhou/python-weekly)：你可以获取本周刊的 Markdown 源文件，做任何想做的事！
- [Telegram](https://t.me/pythontrendingweekly)：除了发布周刊的通知外，我将它视为一个“副刊”，补充发布更加丰富的资讯。
- [Twitter](https://twitter.com/chinesehuazhou)：我的关注列表里有大量 Python 相关的开发者与组织的账号。