---
title: 'Python 潮流周刊#44：Mojo 本周开源了；AI 学会生成音乐了'
pubDate: 2024-03-30
author: '豌豆花下猫'
---

你好，我是猫哥。这里每周分享优质的 Python、AI 及通用技术内容，大部分为英文。本周刊开源，欢迎[投稿](https://github.com/chinesehuazhou/python-weekly)。另有[电报频道](https://t.me/pythontrendingweekly)作为副刊，补充发布更加丰富的资讯，欢迎关注。

**特别提醒：** 本期周刊赠书 5 本《明解Python算法与数据结构》，详情见文末。

## 🦄文章&教程

1、[蒙特利尔效应：为什么编程语言需要有风格沙皇](https://earthly.dev/blog/language-style-czar/)

讨论了编程语言在规模扩大时面临的风格多样性问题，提出了“语言风格沙皇”（Style Czar）的概念。作者提到 Scala 过于灵活、C++ 新旧标准共存、Python PEP-8 没有与时俱进，呼吁社区应该有人（例如语言创造者）引导社区发展出统一的风格标准。

2、[去中心化的边缘计算平台](https://fission.codes/blog/functions-everywhere-only-once/)

介绍了“Everywhere Computer”，旨在将计算任务分布到一个广泛的开放网络上，包括个人设备、局域网中的其他设备、云节点集群等。介绍了如何使用 Rust、JavaScript 和 Python 编写具体的函数，并将它们编译为 Wasm 组件。

3、[设计一个纯 Python Web 框架](https://reflex.dev/blog/2024-03-21-reflex-architecture/)

Reflex 是一个纯 Python 全栈 Web 框架（Github 15K star），其作者介绍了 Reflex 的架构，包括前后端的实现细节和工作原理。

![Reflex的工作原理图](https://img.pythoncat.top/reflex-architecture.png)

4、[修复 PyPy 增量 GC 中的 一个 bug](https://www.pypy.org/posts/2024/03/fixing-bug-incremental-gc.html)

作者用将近一年时间定位 PyPy 中一个奇怪且难以复现的 BUG，文章介绍了他采用的各种定位方法、这个 BUG 出现的原因、以及在调试时发现的其它问题。目前修复已合入 PyPy 主分支。

5、[复活 PyMiniRacer，Python 中的 V8](https://bpcreech.com/post/mini-racer/)

如何在 Python 项目中运行 JavaScript？PyMiniRacer 是一种方法，但旧项目年久失修，作者接手了它，做了很多的更新，文章介绍了新版本的变更项以及未来的计划。

6、[Python 与 Javascript 进行数据通信](https://juejin.cn/post/7351690896918003775)

文章介绍了如何实现两种语言的相互调用，实现数据跨语言项目的传递。Python 调用 JavaScript 用了 **pyjsparser** 和 **PyV8**，反向用了 **node-python**、WebSockets 和 HTTP 请求。

7、[更适合慢函数调用的 Python 缓存实现](https://docs.sweep.dev/blogs/file-cache)

介绍了一种使用文件而非内存的缓存方案，类似于`lru_cache` ，它提供了`file_cache` 装饰器，主要优点是能持久化缓存结果。文章详细介绍了实现的代码。

8、[使用 Collectfasta 加速 Django 的 collectstatic 命令](https://jasongi.com/2024/03/04/speed-up-djangos-collectstatic-command-with-collectfasta/)

介绍了一个可加速 Django 框架中 `collectstatic` 命令的执行速度的工具，包括如何安装和配置、如何将其集成到 Django 项目中以提高性能。还提供了一些性能提升的指标和最佳实践建议。

9、[用原生 Python 扩展和 Dispatch 实现分布式协程](https://stealthrocket.tech/blog/distributed-coroutines-in-python/)

分布式协程是可以挂起、序列化并在另一个进程中恢复的函数，与分布式调度器（如 Dispatch）结合使用，可简化软件的创建过程。Python 原生支持协程，但协程本身不能被序列化，文章介绍了如何解决这个问题，以及如何处理无法序列化的文件和网络句柄、如何处理大型对象以及如何处理全局对象和代码更新等问题。

10、[使用 Numba 加快代码速度的错误方法](https://pythonspeed.com/articles/slow-numba/)

如果基于 NumPy 的代码太慢，有时可用 Numba 来加速。但由于它的类型注解和编译选项，错误使用将导致性能变慢，文章分析了相关问题，并给出了优化的建议。

11、[关于优化 Django 系统检查框架](https://adamj.eu/tech/2024/03/23/django-optimizing-system-checks/)

Django 的 **system check framework** 是一种内置机制，可在运行 Django 命令时自动检查和报告潜在的配置及应用状态问题。作者通过性能分析和代码审查，发现并实现了多项优化措施，提升了示例约 50% 的运行速度。所做优化将在 Django 5.1 版本发布。

12、[大数定律，为什么去赌场是个坏主意](https://easylang.dev/apps/tutorial_mcarlo.html)

文章通过数据分析的方法（蒙特卡洛方法）模拟抛硬币、轮盘、大乐透等玩法，结果发现输的概率非常大，这告诉了我们一个道理就是……

🎁**Python潮流周刊**🎁每 30 期为一季，第一季的精华内容已整理成一篇，方便你随时查看。在线访问地址：[Python 潮流周刊第一季精华合集（1~30）](https://pythoncat.top/posts/2023-12-11-weekly)

## 🐿️项目&资源

1、[mojo：Mojo 编程语言开源了](https://github.com/modularml/mojo)

Mojo 是一种新的编程语言，试图将 Python 的语法及生态与系统编程及元编程相结合，弥补研究与生产之间的差距。（star 18.5K）

2、[Suno-API：基于 Python 和 FastAPI 的非官方 Suno API](https://github.com/SunoAI-API/Suno-API)

目前支持生成歌曲、歌词等。自带维护 token 与保活功能，无需担心 token 过期问题。（附：另一个[suno 逆向工程 API](https://github.com/yihong0618/SunoSongsCreator)）

3、[blacken-docs：对文档中的 Python 代码块上运行“black”](https://github.com/adamchainz/blacken-docs)

一个命令行工具，支持在 Markdown、reStructuredText 和 LaTex 文件中用`black` 格式化 Python 代码块。（投稿自@Chao）

4、[pathvalidate：用于规范化/验证字符串，例如文件名和文件路径](https://github.com/thombashi/pathvalidate)

一个用于处理文件名和文件路径字符串的实用工具，支持删除无效字符、替换平台保留字、删除不可打印字符、参数校验、多字节字符、支持多平台，等等。（投稿自@Chao）

5、[LunarLink: 基于HttpRunner + Django + Vue + Element UI 的接口自动化测试平台](https://github.com/tahitimoon/LunarLink)

除题目所述，它还用到以下技术栈：Nginx、RabbitMQ、Redis、MySQL 和 Docker 等，支持登录、项目管理、接口管理、用例管理、流量录制、配置管理、定时任务、报告管理等功能。

![](https://img.pythoncat.top/LunarLink.png)

6、[leaping：轻量级的 Python 测试调试器](https://github.com/leapingio/leaping)

一个简单、快速、轻量级的 Python 测试调试器，支持跟踪代码的执行，并允许用基于 LLM 自然语言的调试器追溯检查程序的状态。

7、[keepyourmouthshut：用 AI 能力录制播客](https://github.com/rajtilakjee/keepyourmouthshut)

以面向开发者的方式创建播客，不需要任何昂贵的设备。它从用户处获取输入，以此生成脚本和基于该脚本的音频文件。依赖`FFMPEG` 和 `llmOS` 。

8、[MoneyPrinterTurbo：利用AI大模型，一键生成高清短视频](https://github.com/harry0703/MoneyPrinterTurbo)

只需提供一个视频主题或关键词，就可全自动生成视频文案、视频素材、视频字幕、视频背景音乐，然后合成一个高清的短视频。支持 **OpenAI**、**moonshot**、**Azure**、**gpt4free**、**one-api**、**通义千问** 等多种模型。（star 5.5K）

9、[AIOS：LLM 代理操作系统](https://github.com/agiresearch/AIOS)

将大语言模型嵌入到操作系统中，使操作系统“有灵魂”。旨在优化资源分配，促进跨代理的上下文切换，实现代理的并发执行，为代理提供工具服务，维护代理的访问控制。

![AI操作系统的架构图](https://img.pythoncat.top/AIOS-Architecture.png)

10、[LaVague：使用大行动模型框架实现自动化](https://github.com/lavague-ai/LaVague)

提供了一个将自然语言查询转换为 Selenium 代码的引擎，使用户或其它 AI 能够轻松自动化、轻松描述 Web 工作流程并在浏览器上实现自动化。（star 3.5K）

11、[Gmeek：一个完全使用 Github 的博客框架](https://github.com/Meekdai/Gmeek)

超轻量级个人博客模板，完全基于`Github Pages` 、 `Github Issues` 和 `Github Actions`。不需本地部署，从搭建到写作，只需要 18 秒，2 步搭建好博客，第 3 步就是写作。

12、[posthog：提供开源产品分析、会话录制、功能标记和 A/B 测试](https://github.com/PostHog/posthog)

一个开源的产品分析工具，支持自托管。旨在为企业提供一个可控制、可定制且符合数据隐私要求的分析解决方案。有免费的 cloud 版本。（star 16.5K）

13、[devika：Cognition AI 的 Devin 的开源替代品](https://github.com/stitionai/devika)

最近大火的 Devin 的开源替代品，可理解高级人类指令并分解为步骤，研究相关信息，并编写代码以实现给定的目标。它利用大语言模型、规划和推理算法以及 Web 浏览能力来智能开发软件。（star 13K）

## 🐢赠书福利

不定期的福利活动，本期赠书 **5** 本《明解Python算法与数据结构》，开奖时间 **4 月 5 日** 。请给 **[Python猫](https://img.pythoncat.top/pythoncat.png)** 公众号发送数字“**8044**”，获取抽奖小程序码。

日本编程教育界泰斗，畅销书《明解C语言》作者倾力打造！136 段代码 + 213 幅图表，透彻讲解算法与数据结构基础知识，比课本更生动、更易懂！原版系列累计销量超 120 万册，荣获日本工学教育协会著作奖。

![](https://img.pythoncat.top/book-2860.jpg)

## 🐼欢迎订阅

- [微信公众号](https://img.pythoncat.top/python_cat.jpg)：除更新周刊外，还发布其它原创作品，并转载一些优质文章。（可加好友，可加读者交流群）
- [博客](https://pythoncat.top) 及 [RSS](https://pythoncat.top/rss.xml)：我的独立博客，上面有历年原创/翻译的技术文章，以及从 2009 年以来的一些随笔。
- [邮件](https://pythoncat.substack.com) 及 [RSS](https://pythoncat.substack.com/feed)：在 Substack 上开通的频道，满足你通过邮件阅读时事通讯的诉求。
- [Github](https://github.com/chinesehuazhou/python-weekly)：你可以获取本周刊的 Markdown 源文件，做任何想做的事！
- [Telegram](https://t.me/pythontrendingweekly)：除了发布周刊的通知外，我将它视为一个“副刊”，补充发布更加丰富的资讯。
- [Twitter](https://twitter.com/chinesehuazhou)：我的关注列表里有大量 Python 相关的开发者与组织的账号。