---
title: 'Python 潮流周刊#43：在开源与家庭之间，他选择了家庭'
description: '本期周刊分享了 12 篇文章，12 个开源项目，2 则音视频，赠书 5 本'
pubDate: 2024-03-23
author: '豌豆花下猫'
---

你好，我是猫哥。这里每周分享优质的 Python、AI 及通用技术内容，大部分为英文。本周刊开源，欢迎[投稿](https://github.com/chinesehuazhou/python-weekly)。另有[电报频道](https://t.me/pythontrendingweekly)作为副刊，补充发布更加丰富的资讯，欢迎关注。

**特别提醒：** 本期周刊赠书 5 本《Python数据结构与算法分析（第3版）》，详情见文末。

## 🦄文章&教程

1、[我的开源优先级转变了](https://gregoryszorc.com/blog/2024/03/17/my-shifting-open-source-priorities/)

作者开源了`PyOxidizer` 和`python-build-standalone` 等多个 Python 项目，但因为编程语言兴趣已转向 Rust，以及身份成为了丈夫&父亲，时间精力不足，因此选择回归家庭，要给这些开源项目寻求新的维护者了。

2、[如何远程唤醒家里的电脑？](https://bernsteinbear.com/blog/wakeonlan/)

家里的电脑处于休眠模式，如何从其它地方远程唤醒它？作者用树莓派单板计算机 + Python 开发的简单网页 + systemd 服务，通过给电脑的网络控制器发送数据包，实现了机器的远程唤醒。

3、[Python 程序的内存占用情况](https://codebeez.nl/blogs/the-memory-footprint-of-your-python-application/)

相比静态类型语言，Python 要消耗大量内存。文章探讨了 Python 的内存模型：对象是如何分配的、对象存储在什么地方、最终如何清理对象？介绍了如何使用简单的技巧，显著改善内存的使用。

4、[正则表达式字符“\$”并不意味着“字符串末尾”](https://sethmlarson.dev/regex-$-matches-end-of-string-or-newline)

正则表达式中“\$”符号会匹配到什么内容呢？Python `re.MULTILINE` 多行模式对字符串匹配的影响？是否不同的编程语言的表现都一样呢？什么时候应该用“\z”和“\Z”？ 

![不同编程语言匹配字符串末尾的情况](https://img.pythoncat.top/2024-03-22_re.png) 

5、[介绍 Python 中所有的双下方法](https://www.pythonmorsels.com/every-dunder-method/)

双下方法即以双下划线开头和结尾的特殊方法，例如`__init__()` ，Python 语言中共有 150 多个特殊的双下方法，文章对它们多了分类介绍，并梳理了明细清单。 

6、[Python 多语言支持实现国际化与本地化的最佳实践](https://juejin.cn/post/7348264185325568036)

Python 有丰富的库可支持国际化和本地化，文章介绍如何用`gettext` 库实现语言国际化以及如何管理本地化资源。

7、[在 Windows 上利用 Qwen 大模型搭建一个 ChatGPT 式的问答小助手](https://juejin.cn/post/7347670979634167823)

Qwen 是阿里推出的大语言模型，作者用 Win10 系统搭建了一个基于 Qwen 的 AI 问答助手。内容包括安装环境、下载模型、使用`transformers` 实现模型对话功能。 

8、[(如何(用Python)开发一个(Lisp)解释器)](https://www.norvig.com/lispy.html)

“如果你不知道编译器是如何工作的，那你就不知道计算机是如何工作的。“作者通过用 Python 开发一个 Lisp 解释器，详细介绍了 Scheme 的语法，深入探讨解释器/计算机的工作原理。

9、[使用 Python 解析 URL](https://tkte.ch/articles/2024/03/15/parsing-urls-in-python.html)

正确地解析 URL 要比想象得难，它自 1994 年提出以来已发生巨大变化。Python 标准库`urllib` 并不遵循任何 URL 规范，文章介绍了两个符合 WHATWG 规范的解析库`ada-python` 和`can_ada` ，后者比前者快 2 倍，前者比`urllib.parse` 快 2 倍。

10、[Python 鸭子类型：编写灵活且解耦的代码](https://realpython.com/duck-typing-python/)

鸭子类型的核心思想是“如果它走起来像鸭子，叫起来像鸭子，那么它就是鸭子”。由对象的行为决定类型，而非是一成不变。这篇长文对鸭子类型作了非常详细的介绍，它是什么、如何使用、有什么优缺点、使用哪些方案来弥补鸭子类型的缺点，等等。

11、[用 Python 实现最小可用的 PostgreSQL](https://ivdl.co.za/2024/03/02/pretending-to-be-postgresql-part-one-1/)

介绍了 PostgreSQL 服务端与客户端通信的流程，使用 Python 实现一个最小化的服务端。

12、[给框架开发者的建议](https://deven.codes/posts/building-for-builders/)

作者在去年开发了两个 Python 框架，文章分享了他在开发框架时学到的东西。部分建议有：定义你的反目标、了解已存在的东西、首先考虑你的界面、在没准备好时就使用、1 个样本是不够的、重视文档，等等。

🎁**Python潮流周刊**🎁每 30 期为一季，第一季的精华内容已整理成一篇，方便你随时查看。在线访问地址：[Python 潮流周刊第一季精华合集（1~30）](https://pythoncat.top/posts/2023-12-11-weekly)

## 🐿️项目&资源

1、[grok-1：马斯克开源的 Grok](https://github.com/xai-org/grok-1)

本周最最火爆的项目当属马斯克差点跳票的 Grok 大语言模型了，有非常惊人的 314B 参数，8 个专家的混合体，最长上下文 8192 token。（star 43K）

2、[DarkGPT：基于 GPT-4-200K，查询泄露的数据库](https://github.com/luijait/DarkGPT)

基于 GPT-4 的开源情报助手，从付费的 DeHashed 高效地搜集和分析信息，对网络安全和数据泄露调查有所帮助。

3、[structlog：简单、强大、快速的 Python 日志记录库](https://github.com/hynek/structlog)

一个 Python 日志库，强调结构化和类型安全的日志记录，兼容 `logging` 标准库，支持输出 JSON、logfmt 和漂亮的控制台日志。（star 3.1K）

4、[pydumpling: 针对 Python 的异常调试器](https://github.com/cocolato/pydumpling)

Python Debug 工具，与 Linux 中调试 core dump 文件一样，支持在异常发生时/程序任意位置保留当前调用栈帧，然后通过 pdb 进行调试。支持全局 hook，支持服务器远程调试。（投稿自@cocolato）

5、[can\_ada：快速且符合规范的 URL 解析库](https://github.com/tktech/can_ada)

符合 WHATWG 规范的 URL 解析器，也用在了 Node.js 等项目中。比标准库 urllib 快 4 倍。

6、[Mindgraph：使用 AI 生成和查询不断扩展的知识图谱](https://github.com/yoheinakajima/mindgraph)

一个验证概念的项目，可作为模板，用于构建和自定义自己的 CRM 解决方案，重点是易于集成和可扩展性。

![](https://img.pythoncat.top/2024-03-23_mindgraph.png) 

7、[speechbrain：基于 PyTorch 的语音工具包](https://github.com/speechbrain/speechbrain)

一个 PyTorch 工具包，专为快速简便地创建先进的语音和文本处理技术而设计，可加速对话式 AI （即语音助手、聊天机器人和大语言模型）开发。（star 7.7K）

8、[python-anyconfig：以通用 API 加载和转储各种格式的配置文件](https://github.com/ssato/python-anyconfig)

提供了非常简单和统一的 API 来处理各种格式的配置文件，支持格式有 JSON、ini、Pickle、XML、Java properties、YAML、TOML，等等。

9、[Llama-Chinese: Llama 中文社区，最好的中文 Llama 大模型](https://github.com/LlamaFamily/Llama-Chinese)

专注于 Llama 模型在中文方面的优化和上层建设的高级技术社区，定期组织线上活动、技术研讨和经验分享，促进成员间的创新交流。（star 9K）

10、[python-for-android：将 Python 程序变成 Android APK](https://github.com/kivy/python-for-android)

可将 Python 应用打包成在 Android 设备上运行的二进制文件（APK、AAB 和 AAR），支持多种 CPU 架构，支持大多数纯 Python 包和一些流行的依赖于 C 代码的包（如 numpy、sqlalchemy）。（star 8K）

11、[img2img-turbo：Stable Diffusion turbo 实现的 sketch2image、day2night 等](https://github.com/GaParmar/img2img-turbo)

基于素描快速生成图片、夜晚图片转换为白天（或相反）、晴天图片转换为雨天，等等。

12、[ludic：用纯 Python 构建动态 HTML 页面的轻量级框架](https://github.com/paveldedik/ludic)

使用类似于 React 的组件构建 HTML 页面，旨在与 htmx.org 一起使用，几乎不需写任何 JavaScript。后端基于 Starlette 框架。

## 🐢播客&视频

1、[带大家感受一下没有 GIL 的 CPython](https://www.bilibili.com/video/BV1im411R7UB)

CPython 主线分支已合入了可禁用 GIL 的开关，这则视频带大家体验一下没有 GIL 的 Python 会有什么样的表现。

2、[ruff、uv 和 Astral：Python 工具链，使用 Rust 提速](https://podcast.pythontest.com/episodes/ruff-astral-uv-charlie-marsh)

ruff 和 uv 出自同一个团队，给 Python 的基础工具链带来了非常有前景的影响。这期播客对话了 Charlie Marsh。（附：另一则相似话题的播客 [uv - Python 包的下一次演变？](https://talkpython.fm/episodes/show/453/uv-the-next-evolution-in-python-packages)）

## 🐢赠书福利

不定期的福利活动，本期赠书 **5** 本《Python数据结构与算法分析（第3版）》，开奖时间 **3 月 29 日** 。请给 **[Python猫](https://img.pythoncat.top/pythoncat.png)** 公众号发送数字“**8043**”，获取抽奖小程序码。

书是用 Python 描述数据结构与算法的开山之作，汇聚了作者多年的实战经验，透彻讲解在 Python 中通过一系列存储机制高效地实现各类算法。这本书让你深刻理解 Python 数据结构、递归、搜索、排序、树与图的应用，等等。

![](https://img.pythoncat.top/book-data-structure.jpg)

## 🐼欢迎订阅

- [微信公众号](https://img.pythoncat.top/python_cat.jpg)：除更新周刊外，还发布其它原创作品，并转载一些优质文章。（可加好友，可加读者交流群）
- [博客](https://pythoncat.top) 及 [RSS](https://pythoncat.top/rss.xml)：我的独立博客，上面有历年原创/翻译的技术文章，以及从 2009 年以来的一些随笔。
- [邮件](https://pythoncat.substack.com) 及 [RSS](https://pythoncat.substack.com/feed)：在 Substack 上开通的频道，满足你通过邮件阅读时事通讯的诉求。
- [Github](https://github.com/chinesehuazhou/python-weekly)：你可以获取本周刊的 Markdown 源文件，做任何想做的事！
- [Telegram](https://t.me/pythontrendingweekly)：除了发布周刊的通知外，我将它视为一个“副刊”，补充发布更加丰富的资讯。
- [Twitter](https://twitter.com/chinesehuazhou)：我的关注列表里有大量 Python 相关的开发者与组织的账号。