---
title: 'Python 潮流周刊#42：小公司用 Python 开发，能做到什么程度？'
pubDate: 2024-03-16
---

你好，我是猫哥。这里每周分享优质的 Python、AI 及通用技术内容，大部分为英文。本周刊开源，欢迎[投稿](https://github.com/chinesehuazhou/python-weekly)。另有[电报频道](https://t.me/pythontrendingweekly)作为副刊，补充发布更加丰富的资讯，欢迎关注。

**特别提醒：** 本期周刊赠书 6 本《[流畅的Python（第2版）](https://mp.weixin.qq.com/s/eGDOZYZzSpiWojWkN0mK2Q)》，详情见文末。

## 🦄文章&教程

1、[为什么我们公司还在用 Python 开发项目?](https://mp.weixin.qq.com/s/OU38bK4q-KNymXAtx8gZJA)

这篇文章让我有种“你不了解的行业内幕”的感觉。小公司还在坚持用 Python 2.7 + Django 1.8，竟支撑每年几个亿的交易额。作者还分享了几个项目，我的感受是：也许你不需要考虑太多“xx语言更好”，就选自己熟悉的，专注于业务实现就好。

2、[Python 字符串应该用双引号还是单引号？](https://mp.weixin.qq.com/s/9uIYtQEc-RuNhMY7Ck9IAA)

Python 字符串既允许双引号也允许单引号，甚至可以三引号。这很灵活，但是对于有强迫症的标准制定者来说，这也是引发冲突的矛盾点。这篇文章分享的故事很有意思，推荐一读！

3、[介绍 Python 上下文管理器及其语法糖](https://bjoernricks.github.io/posts/python/context-manager)

为什么需要用上下文管理器？它能解决哪些问题？文章还介绍了上下文管理器协议、`with` 语法糖、使用`contextlib` 实现上下文管理器、四个很实用的使用案例。

4、[Python deque 使用教程](https://mathspp.com/blog/python-deque-tutorial)

`deque` 是`collections` 模块下的一种双向队列数据结构，功能与`list` 很相似，适宜需要在两端快速添加或删除的场景。这篇教程介绍了它的基本用法与一些高级使用案例。

5、[Python 的泛型函数和泛型类](https://guicommits.com/python-generic-type-function-class/)

Python 在运行时才检查类型，而且强调的是对象的行为而非类型，因此不怎么提注重类型安全的“泛型”。但是，Python 也支持泛型，文章介绍了如何用`typing` 模块实现泛型函数和泛型类。

6、[Python Gevent 实践：常见的陷阱](https://upsun.com/blog/python-gevent-best-practices/)

`Gevent` 是基于  `greenlet` 这个轻量级的协程实现的高性能网络库。文章介绍了 Gevent 的常见陷阱以及解决方案。

7、[Python pickles 的安全问题](https://lwn.net/SubscriberLink/964392/498a12fe44f51139/)

`pickle` 是 Python 用作序列化的标准库，但它作反序列化时存在重大的安全风险！文章介绍了它的工作原理、安全风险的根源、机器学习领域合作设计了`safetensors` 格式作安全替代。

8、[构建开源去中心化的电子书搜索引擎](https://github.com/j2qk3b/ebook-demo/blob/main/tutorial.md)

这篇教程分别使用 JavaScript 和 Python 开发电子书搜索引擎，依赖`Glitter` （一个使用`Tendermint` 构建的去中心化数据库服务），使用 React 开发展示搜索结果的页面。

9、[Python import 跟 Java import 有什么区别？](https://juejin.cn/post/7345423755948572726)

很多编程语言都有`import` 关键字，其作用也类似，但是它们背后的运行机制会有哪些区别呢？文章分析了 Java 和 Python 中 import 的异同点，可加深你对这个话题的理解。

10、[PDM 的内部实现(1)](https://frostming.com/2024/pdm-lockfile/)

`pdm` 是 Python 中极好用的依赖管理工具，是国内开发者@frostming 的作品。作者计划写一系列关于它内部实现的文章，这是第一篇，介绍了 Lockfile 是什么、Lockfile 是如何生成的？

11、[Python 中有指针吗？](https://nedbatchelder.com/blog/202403/does_python_have_pointers.html)

Python 有指针么？答案取决于你如何理解“指针”。作者简短回答，却一针见血。Python 没有 C 语言经典的指针操作，但 Python 的每个变量都是一个指针，即一切都是隐含的指针。（附：[有个项目](https://github.com/ZeroIntensity/pointers.py) “将指针的地狱引入 Python”，跟下方的花括号版 Python 一样画蛇添足）

12、[当 Python 无法线程化时：深入了解 GIL 的影响](https://pythonspeed.com/articles/python-gil/)

无 GIL 特性终于在本周[合入 Python 的主分支了](https://github.com/python/cpython/pull/116338)！分享一篇深度介绍 GIL 的长文，理解 GIL 的工作原理、帮助预测并行性瓶颈的位置，文中使用了很多线程时序分析图，便于理解。

🎁**Python潮流周刊**🎁每 30 期为一季，第一季的精华内容已整理成一篇，方便你随时查看。在线访问地址：[Python 潮流周刊第一季精华合集（1~30）](https://pythoncat.top/posts/2023-12-11-weekly)

## 🐿️项目&资源

1、[flet：用 Python 开发实时的 Web、移动端和桌面程序](https://github.com/flet-dev/flet)

无需前端经验，快速构建跨平台的、支持多用户、实时的单页应用（SPA）；没有 SDK，基于 IDE或文本编辑器即可开发，前端使用 Flutter UI，后端目前支持 Python，计划支持 Go 和 C#。（star 8.7K）（投稿自@bear）

2、[ss-python：Python 项目模板，涵盖整个开发生命周期](https://github.com/serious-scaffold/ss-python)

一个包括各种集成、配置和模块的 Python 项目模板，特点有：使用`copier` 作项目设置与模板更新、使用`pdm` 管理依赖及虚拟环境、使用 dev container 作容器化、使用 mypy 和 ruff 等等常用技术栈。（投稿自@huxuan\_org）

3、[dukpy：用于 Python 简化版 JavaScript 解释器](https://github.com/amol-/dukpy)

构建在`duktape` 引擎上的 JS 解释器，用于在 Python 中执行 JS 代码。无其它外部依赖，内置了常用的转译器（TypeScript、JSX、LESS、CoffeeScript），还支持传参、运行多个脚本、全局解释器、使用`require` 加载模块、从 npmjs.org 安装软件包等功能。

```Python
>>> import dukpy
>>> dukpy.evaljs("var o = {'value': 5}; o['value'] += 3; o")
{'value': 8}
```

4、[PyKidos：一个 Python 编程练习网站](https://pykidos.github.io/)

在线的 Python 编程网站，很方便通过游戏方式教育小孩学习编程。

![](https://img.pythoncat.top/2024-03-15_pykidos.png)

5、[hatchet：分布式的容错的任务队列](https://github.com/hatchet-dev/hatchet)

取代难以管理的传统队列和发布/订阅系统，支持故障恢复，可解决并发、公平性和速率限制等问题。具有低延迟和高吞吐量，支持 FIFO、LIFO、循环队列和优先级队列等策略，可自定义重试策略，支持集成错误处理。（star 2.4K）

6、[full-stack-fastapi-template：全栈的现代 Web 项目模板](https://github.com/tiangolo/full-stack-fastapi-template)

使用 FastAPI、React、SQLModel、PostgreSQL、Docker、GitHub Actions、自动 HTTPS 等，支持 JWT 身份验证、基于邮件的密码恢复，使用 Traefik 作反向代理/负载均衡。（star 17.5K）

7、[bython：带花括号的 Python](https://github.com/mathialo/bython)

我认为 Python 用空格作缩进是最最迷人的设计！奈何有人更喜欢花括号。这个项目为 Python 加上了花括号，基本示例：

```python
def print_message(num_of_times) {
    for i in range(num_of_times) {
        print("Bython is awesome!");
    }
}

if __name__ == "__main__" {
    print_message(10);
}
```

8、[treq：构建在 Twisted 上的 HTTP 请求库](https://github.com/twisted/treq)

一个简单的、风格类似`requests` 的 HTTP 客户端，构建在 Twisted 之上。

9、[JavSP：汇总多站点数据的视频元数据刮削器](https://github.com/Yuukiy/JavSP)

自动抓取、汇总并按指定规则分类整理影片文件，创建供 Emby、Jellyfin、Kodi 等软件使用的元数据文件。（star 1.6K）

10、[botasaurus：强大的网络爬虫框架](https://github.com/omkarcloud/botasaurus)

可用简单的 HTTP 请求访问受 Cloudflare 保护的页面，是唯一为认证代理提供 SSL 支持的爬虫框架，仅一行代码即可集成任何 Chrome 插件，支持 sitemap、支持数据清理、支持缓存、提供了 Selenium 快捷方式，等等。

11、[pywebview：用 JavaScript、HTML 和 CSS 构建 GUI](https://github.com/r0x0r/pywebview)

一个围绕 WebView 组件的轻量级跨平台包装器，在 GUI 窗口中显示 HTML 内容。可与 Web 框架一起使用，也可单独打通 Python 与 DOM。最新发布的 5.0 版本，开始支持 Andriod。（star 4.2K）

12、[Paper-Piano：在白纸上弹钢琴](https://github.com/Mayuresh1611/Paper-Piano)

它可让你直接在白纸上练习弹钢琴！目前最多支持两个手指，主要为买不起钢琴的人提供练习。

![](https://img.pythoncat.top/2024-03-15_paper-piano.png)

## 🐢赠书福利

不定期的福利活动，本期赠书 **6** 本《[流畅的Python（第2版）](https://mp.weixin.qq.com/s/eGDOZYZzSpiWojWkN0mK2Q)》，开奖时间 **3 月 22 日** 。请给 **[Python猫](https://img.pythoncat.top/pythoncat.png)** 公众号发送数字“**8042**”，获取抽奖小程序码。

如果你想要更加熟练地掌握 Python，想要了解实用的编程技巧，想写出地道、优雅、高效的 Python 代码，想要掌握 Python 最新的语言特性，我强烈推荐这本书。

![](https://img.pythoncat.top/2023-04-23-fluent-python.png)

## 🐼欢迎订阅

- [微信公众号](https://img.pythoncat.top/python_cat.jpg)：除更新周刊外，还发布其它原创作品，并转载一些优质文章。（可加好友，可加读者交流群）
- [博客](https://pythoncat.top) 及 [RSS](https://pythoncat.top/rss.xml)：我的独立博客，上面有历年原创/翻译的技术文章，以及从 2009 年以来的一些随笔。
- [邮件](https://pythoncat.substack.com) 及 [RSS](https://pythoncat.substack.com/feed)：在 Substack 上开通的频道，满足你通过邮件阅读时事通讯的诉求。
- [Github](https://github.com/chinesehuazhou/python-weekly)：你可以获取本周刊的 Markdown 源文件，做任何想做的事！
- [Telegram](https://t.me/pythontrendingweekly)：除了发布周刊的通知外，我将它视为一个“副刊”，补充发布更加丰富的资讯。
- [Twitter](https://twitter.com/chinesehuazhou)：我的关注列表里有大量 Python 相关的开发者与组织的账号。