---
title: 'Python 潮流周刊#41：写代码很简单，但写好代码很难'
pubDate: 2024-03-09
author: '豌豆花下猫'
---

你好，我是猫哥。这里每周分享优质的 Python、AI 及通用技术内容，大部分为英文。本周刊开源，欢迎[投稿](https://github.com/chinesehuazhou/python-weekly)。另有[电报频道](https://t.me/pythontrendingweekly)作为副刊，补充发布更加丰富的资讯，欢迎关注。

## 🐱好书推荐

《Python工匠》专注于基础编程素养与 Python 高级技巧的结合，是一本适合许多人的 Python 编程进阶书。本期周刊将赠书 5 本，参与方式见文末。

## 🦄文章&教程

1、[使用 Python 从头开始实现 RSA](https://coderoasis.com/implementing-rsa-from-scratch-in-python/)

作者在一系列文章（4 篇）中使用 Python 实现 RSA 加密算法，介绍了这个算法的基本步骤和数学原理，使用 Python 实现并逐步优化，以及实现对它的安全攻击，最后探索 RSA 加密的未来方向。

2、[Python IAQ：不常见的问题](https://norvig.com/python-iaq.html)

一个问题很少被回答，要么是因为很少有人知道答案，要么是因为它涉及一个晦涩的微妙的点。文章里列出了很多问题和解读，因写于 20 年前，有些问题已经在后来的 Python 版本中解决了，还有些问题至今仍未过时（依旧冷门）。

3、[为什么我喜欢 Nox？](https://hynek.me/articles/why-i-like-nox/)

`tox` 和 `nox` 是两个类似的 Python 工具，主要用途之一是测试你的项目在不同 Python 版本中的运行情况。作者解释了为什么在某些情况下，他更喜欢用 nox 的原因。（附：我在 4 年前写过一篇 [tox 教程](https://pythoncat.top/posts/2020-01-06-tox) ，也翻译过 nox 的文档。时间过得真快....）

4、[我最喜欢的数据结构：trie](https://jamesg.blog/2024/01/16/trie/)

Trie（前缀树或字典树）是一种树形数据结构，常用于存储和检索字符串集合中的信息。文章介绍了这种数据结构，使用`pygtrie` 库演示基本操作。

5、[用 Python 处理 CSV 文件的速度能有多快？](https://datapythonista.me/blog/how-fast-can-we-process-a-csv-file)

Python 处理 CSV 文件有哪些可选方案？不同方案的执行速度、代码可读性、硬件的影响是怎样的？作者测试了 Pandas 使用不同引擎时的性能、使用 Numpy/DuckDB/DataFusion/Polars 等方案的实现比较。

6、[Django 项目的多语言支持](https://medium.com/@sakhawy/multilingual-support-in-django-5706e1e144a8)

如何给 Django 项目添加多语言支持？通过什么方式检测当前语言？如何翻译消息文件、翻译模板文件和翻译 JS 文件？翻译后的内容是如何响应给前端的？

7、[Python 升级手册：Lyft 如何大规模升级 1500+ 代码仓](https://eng.lyft.com/python-upgrade-playbook-1479145d52f4)

Lyft 将 150+ 团队 1500+ 代码仓从 Python 2 升级到 Python 3.10，总结出一份版本升级手册。

8、[将 Tailwind CSS 添加到 Django 的最简单方法](https://www.photondesigner.com/articles/tailwind-with-django)

Django 项目如何集成当下火热的 Tailwind CSS？这篇教程给出了实现指导，文中附有视频。

9、[初学者意想不到的 Python 陷阱](https://www.bitecode.dev/p/unexpected-python-traps-for-beginners)

文章列出了几个挺常见的 Python “陷阱”，新手们确实容易被绊倒。包括：不显眼的字符串连接、函数返回的 None、不可见的元组、可怕的`is` 、列表相乘。

10、[使用 Python 和 Grafana 更好地冷却我的 PC](https://calbryant.uk/blog/better-pc-cooling-with-python/#)

一篇关于 Python 在现实世界发挥作用的文章：作者用 Python 读取 CPU 和液冷器温度，控制风扇和泵速，通过 Grafana 监控性能，有效提高了 PC 冷却效率、减少了风扇噪声！

11、[使用搭载骁龙 8 Gen 3 的安卓手机运行 AI 大模型](https://soulteary.com/2024/02/29/run-large-ai-models-on-android-phones-with-snapdragon-8-gen-3.html)

文章介绍了在 Android 手机上简单运行 AI 大模型的方法，来体验英文语言模型（Llama2 7B、Mistral 7B、RedPajama 3B、Google Gemma 2B、Microsoft PHI 2B）；中文语言模型（面壁 MiniCPM、多模态模型）；Stable Diffusion。

12、[入行 14 年，我还是觉得编程很难](https://www.piglei.com/articles/programming-is-still-hard-after-14-years/)

《Python 工匠》作者@piglei 分享的自己关于编程的感触。去年已读过，现在读依然有收获。文章整理了 8 条编程经验，最核心的观点之一是“写好代码”，呼应了“Python工匠”系列文章的初心：像工匠打造完美的手工艺品一样编写优雅而高效的代码。

🎁**Python潮流周刊**🎁每 30 期为一季，第一季的精华内容已整理成一篇，方便你随时查看。在线访问地址：[Python 潮流周刊第一季精华合集（1~30）](https://pythoncat.top/posts/2023-12-11-weekly)

## 🐿️项目&资源

1、[umami-python：Python 开发的 Umami 分析客户端](https://github.com/mikeckennedy/umami-python)

很多个人网站（包括我的）不再使用 Google Analytics 作网站流量分析，而是使用开源的 umami。这个项目基于 `httpx` 和 `pydantic` 开发了客户端，实现登录与验证，可将自定义数据添加到 umami，可查看 umami 上的分析数据等。

2、[returns：让函数返回有意义、类型化且安全的内容](https://github.com/dry-python/returns)

它将函数式编程带入 Python 领域，提供很多原语来编写声明式业务逻辑，完全类型化，支持函数和协程且与框架无关。（star 3.2K）

3、[pyquest：一系列的 Python 编程教程](https://github.com/ivnvxd/pyquest)

这个项目收录了一系列的 Python 编程学习资料，涉及 Python 编程的方方面面，系统学习 Python。

4、[flect：用于构建全栈 Web 应用的 Python 框架](https://github.com/Chaoyingz/flect)

通过在后端使用与前端 React 组件属性相对应的 Pydantic 模型来构建用户界面，快速开发具有交互性和美观的用户界面。

5、[docker-android：Docker 里的 Android，支持 noVNC 和视频录制](https://github.com/budtmo/docker-android)

一个用于 Android 开发与测试的 docker 镜像，有不同设备的模拟器、支持 vnc 可查看容器内部、支持日志通过 Web UI 共享、能使用 adb 从外部控制、支持多种测试框架如 Appnium 和 Espresso 等。（star 7K）

6、[anthropic-sdk-python：调用 Claude 3 等大模型](https://github.com/anthropics/anthropic-sdk-python)

上周的 Claude 3 是热门话题，性能跑分全面超越 GPT-4！这个项目是官方发布的 Python 开发包，支持异步、流式响应、流媒体助手、查看使用量、以 Pydantic 模型返回、重试和超时处理等。

7、[PhotoMaker：制造逼真的人物照片](https://github.com/TencentARC/PhotoMaker)

在几秒钟内快速定制，无需额外的 LoRA 培训；确保令人印象深刻的 ID 保真度、提供多样性、高质量生成；可作为适配器与其他基础模型以及 LoRA 模块进行协作。（star 7.8K）

![](https://img.pythoncat.top/2024-03-09_photomaker.png)

8、[metube：自托管的 YouTube 下载器（youtube-dl/yt-dlp 的 Web UI）](https://github.com/alexta69/metube)

用于 youtube-dl 的 Web GUI（使用 yt-dlp 分支），支持播放列表。可从 YouTube 和其他数十个网站下载视频。（star 3.1K）

9、[cachetools：可扩展的内存化集合和装饰器](https://github.com/tkem/cachetools)

提供了各种内存中的集合和装饰器，包括 Python 标准库的 @lru_cache 函数装饰器的变体。（star 2K）

10、[speedtest-cli：使用 speedtest.net 测试网络带宽的命令行界面](https://github.com/sivel/speedtest-cli)

一个网络性能诊断工具，允许用户从终端或命令行环境中测量到特定服务器的下载和上传速度，以及网络延迟。支持跨平台，容易集成到脚本中作自动化测试。（star 13.2K）

11、[Open-Sora-Plan：旨在重现 Sora（Open AI T2V模型）](https://github.com/PKU-YuanGroup/Open-Sora-Plan)

Sora 是 OpenAI 推出的文本到视频模型，代表了视频生成技术的一个重大飞跃。该项目希望通过开源社区的力量复现 Sora，目前搭建了基础架构，但未能进行完整训练。（star 5.2K）

12、[minisora：旨在探索 Sora 的实施路径和未来发展方向](https://github.com/mini-sora/minisora)

同样试图复现 Sora，目标是 GPU 友好、提升训练和推理效率。定期举行圆桌讨论、共读论文，深入研究现有的视频生成技术。

## 🐢赠书福利

不定期的福利活动，本期赠书 **5** 本《Python工匠：案例、技巧与工程实践》，开奖时间 **3 月 15 日**。请给 **[Python猫](https://img.pythoncat.top/pythoncat.png)** 公众号发送数字“**8041**”，获取抽奖小程序码。

这本书从工程实践角度出发，通过剖析核心知识、展示典型案例与总结实用技巧，帮助大家系统进阶 Python，写好工程代码，做好实践项目。全书分为五大部分：变量与基础类型、语法结构、函数与装饰器、面向对象编程、总结与延伸，涵盖 Python 编程的方方面面。

![](https://img.pythoncat.top/one-python-craftsman.jpg)

## 🐼欢迎订阅

- [微信公众号](https://img.pythoncat.top/python_cat.jpg)：除更新周刊外，还发布其它原创作品，并转载一些优质文章。（可加好友，可加读者交流群）
- [博客](https://pythoncat.top) 及 [RSS](https://pythoncat.top/rss.xml)：我的独立博客，上面有历年原创/翻译的技术文章，以及从 2009 年以来的一些随笔。
- [邮件](https://pythoncat.substack.com) 及 [RSS](https://pythoncat.substack.com/feed)：在 Substack 上开通的频道，满足你通过邮件阅读时事通讯的诉求。
- [Github](https://github.com/chinesehuazhou/python-weekly)：你可以获取本周刊的 Markdown 源文件，做任何想做的事！
- [Telegram](https://t.me/pythontrendingweekly)：除了发布周刊的通知外，我将它视为一个“副刊”，补充发布更加丰富的资讯。
- [Twitter](https://twitter.com/chinesehuazhou)：我的关注列表里有大量 Python 相关的开发者与组织的账号。