---
title: 'Python 潮流周刊#40：白宫建议使用 Python 等内存安全的语言'
description: '本期周刊分享了 12 篇文章，11 个开源项目'
pubDate: 2024-03-02
author: '豌豆花下猫'
---

你好，我是猫哥。这里每周分享优质的 Python、AI 及通用技术内容，大部分为英文。本周刊开源，欢迎[投稿](https://github.com/chinesehuazhou/python-weekly)。另有[电报频道](https://t.me/pythontrendingweekly)作为副刊，补充发布更加丰富的资讯，欢迎关注。

## 🦄文章&教程

1、[白宫建议使用 Python 等内存安全语言](https://pyfound.blogspot.com/2024/02/white-house-recommends-.html)

最近，白宫发布了一份报告，建议使用内存安全的编程语言。去年 CISA、NSA 等机构联合发布的报告列出了内存安全的语言有 C#、Go、Java、**Python**、Rust 及 Swift。PSF 这篇文章介绍了 Python 在内存安全性方面所做的工作，包括封装底层代码、从 C 向 Rust 迁移、使用编译器选项强化 C 代码构建。

![CSI表中对Python的简短描述](https://img.pythoncat.top/2024-03-01_python.png)

2、[回顾 Requests 库的问题](https://blog.ian.stapletoncordas.co/2024/02/a-retrospective-on-requests)

文章作者是 Requests 的核心维护者之一，他列举了这个库做得糟糕的多个地方，也指出了很多想改进却没有做到的原因。文末的结语说：“the project feels dead”。这让人感觉很难受。本周刊[第26期](https://pythoncat.top/posts/2023-11-11-weekly) 分享过该库作者 KR 的道歉文，然而社区内几无波澜，后来看到 KR 失业，从推文感觉他精神状态很糟糕，更让人难受了。（投稿by@frostming90）

3、[Python 的 UV 工具确实相当不错](https://micro.webology.dev/2024/02/29/pythons-uv-tool.html)

上期周刊分享的可替换`pip`的`uv` 库，你用了么？感觉如何啊？文章作者给出了积极反馈，分享了自己一些配置文件的前后对比。

4、[Python 生成器未得到充分利用](https://www.slashtmp.io/posts/generators/)

Python 生成器的作用是能节省内存，这篇文章用很明白的例子对比了两种内存使用情况，让我们感受到生成器的好处，同时，文章也指出了需要避免的一些使用陷阱。

5、[使用 Python 作高级 Web 抓取：从任意网站抓取数据](https://jacobpadilla.com/articles/advanced-web-scraping-techniques)

文章讨论了从 Web 抓取内容的一些高级技术，话题包括如何更好处理 Cookie 及自定义请求头、什么是 TLS 指纹以及如何避免它、需要注意的常见 HTTP 请求头、在发出 HTTP 请求时如何集成指数回退重试，等等。

6、[Django REST 框架 + Vue 对比 Django + HTMX](https://testdriven.io/blog/drf-vue-vs-django-htmx/)

两种 Web 开发框架的组合：DRF + Vue 以及 Django + HTMX，它们分别是如何使用的，各自又有哪些优势和劣势呢？文章用这两个组合分别实现同样的功能，分析了两组技术栈的差异，罗列了一份比对清单，可方便我们更好地作技术选型。

7、[可组合数据系统之路：对过去 15 年和未来的思考](https://wesmckinney.com/blog/looking-back-15-years/)

文章出自`pandas` 库兼《Python数据分析》一书的作者 Wes McKinney，回顾了他从 2008 年以来在数据科学领域所做的事情和转变，同时分析和思考了模块化、互操作性和可组合性的未来趋势。

8、[用 Django 作 SQLite 基准测试](https://blog.pecar.me/django-sqlite-benchmark)

作者分别调整 SQLite 的一些主要配置项来作基准测试，另外也比较了 SQLite 和 PostgreSQL 的性能。简短结论：启用 WAL 模式、使用 IMMEDIATE 事务、`synchronous=NORMAL` 和内存映射 I/O 对吞吐量的影响很小。

![](https://img.pythoncat.top/sqlite-django-benchmark.png)

9、[Python 3.13 的 JIT 是如何实现的？](https://zhuanlan.zhihu.com/p/682997904)

文章介绍了 Python 最新正在开发中的 JIT 是如何实现的，并尝试安装了开发版本，然后与无 JIT 版本作性能比较。目前 JIT 版本的性能反而慢于普通版本，官方仍需继续努力优化。

10、[Python 网页抓取的终极指南](https://proxiesapi.com/articles/web-scraping-in-python-the-complete-guide)

一篇详细的爬虫教程，介绍了如何使用 BeautifulSoup、Scrapy 和 Selenium 等库实现网页抓取，如何克服复杂网页、限速、反爬、动态 javascript 等挑战。

11、[为简单架构作辩护](https://danluu.com/simple-architectures/)

Wave 是一家仅有 70 名工程师但估值 17 亿美元的公司，其产品只是一款标准的 CRUD 程序，是构建在 Postgres 之上的 Python 单体架构。文章解释了为什么要选择这样的架构，解释了这样选型的合理性，以及为了保持它而克服的相关难题和选用的技术方案。

12、[关于“调度”的内部原理](https://tontinton.com/posts/scheduling-internals/)

一篇非常深度的长文，深入探讨了“并发”，解释了单线程服务器如何通过异步 IO 和事件驱动编程来处理数以百万计的任务。讨论了实现并发的各种方法和工具，不同编程语言的实现。文中有不少动画，可方便读者理解。

🎁**Python潮流周刊**🎁每 30 期为一季，第一季的精华内容已整理成一篇，方便你随时查看。在线访问地址：[Python 潮流周刊第一季精华合集（1~30）](https://pythoncat.top/posts/2023-12-11-weekly)

## 🐿️项目&资源

1、[ingestr：用单个命令在任何数据库间无缝复制数据](https://github.com/bruin-data/ingestr)

这是一个 CLI 工具，使用简单的命令即可实现跨数据库的内容复制。支持增量加载：`append` 、 `merge` 和 `delete+insert` 模式。（star 1.3K）

2、[justpath：在 Windows 和 Linux 上检查和优化 PATH 环境变量](https://github.com/epogrebnyak/justpath)

一个用于管理操作系统 PATH 环境变量的命令行工具，典型功能包括：筛选目录、识别和清理无效配置、PATH 转储为 JSON、创建新的环境变量、统计数量。

3、[mountaineer：用于 Python 和 React 的自带电池的 Web 框架](https://github.com/piercefreeman/mountaineer)

全栈的 Web 开发框架，主要特点：全栈的类型提示、友好的服务通信及数据绑定、服务器端渲染、对网页作静态分析的增强校验、等等。

4、[generate：一个 API 访问国内外大模型平台](https://github.com/wangyuxinwhy/generate)

使用一个统一的 API 访问大模型，特点：统一的 API、支持多模态、支持 10+ 大模型平台、异步&流式和并发、自带电池、轻量化、高质量代码。（投稿by@wangyuxinwhy）

5、[StringZilla：将 C、C++、Python、Rust 和 Swift 的字符串速度提高 10 倍](https://github.com/ashvardanian/StringZilla)

“由于低效的字符串操作，世界每年至少浪费 1 亿美元”。这个项目可替换编程语言原生的字符串类型，提高性能。可加速精确和模糊字符串匹配、编辑距离计算、排序、延迟计算范围以避免内存分配，甚至随机字符串生成器。（star 1.4K）

6、[DrissionPage: 网页自动化工具，能控制浏览器，也能收发数据包](https://github.com/g1879/DrissionPage)

采用全自研内核，对比 Selenium 有以下优点：无 webdriver 特征、跨 iframe 查找元素、把 iframe  看作普通元素、可同时操作多个标签页、可直接读取浏览器缓存来保存图片、可对整个网页截图，等等。（star 4.1K）

7、[Daft：Rust 开发的面向云的分布式 Python DataFrame](https://github.com/Eventual-Inc/Daft)

用 Rust 开发的用于大规模数据处理的分布式查询引擎，熟悉的交互式 API、专注于查询优化、集成数据目录、丰富的多模态类型系统、专为云而构建。（star 1.4K）

8、[magika：使用深度学习来检测文件内容的类型](https://github.com/google/magika)

谷歌最新开源作品，使用 AI 来检测文件类型，具有 99% 的精确度。可作为 Python 命令行和 API 使用，支持超过 100 中文件类型，每个文件的推理时间约为 5 毫秒。（star 7K）

![magika与其它工具的得分对比图](https://img.pythoncat.top/google-magika.png)

9、[frappe：低代码 Web 框架，使用 Python 和 Javascript](https://github.com/frappe/frappe)

自带电池的全栈 Web 框架，低代码，服务器端使用 Python 和 MariaDB，特点：元数据优先、管理员界面、开箱即用的角色和权限、支持插件、支持任务调度、邮箱管理、多租户，等等。（star 6.3K）

10、[Umi-OCR: 开源、免费的离线 OCR 软件，支持截屏/批量导入图片](https://github.com/hiroi-sora/Umi-OCR)

解压即用，离线运行，无需网络；自带高效率的离线OCR引擎，内置多种语言识别库；支持命令行、HTTP接口等多种调用方式；截图OCR / 批量OCR / PDF识别 / 二维码。（star 19.4K）

11、[xonsh：Python 开发的跨平台的类 Unix 的 shell](https://github.com/xonsh/xonsh)

这个项目是 Python 3.6+ 的超集，带有 shell 原语。可以作为 shell 和 Python 单独使用，也可以在 Python 里写 shell，在 shell 里写 Python。（star 7.8K）

![](https://img.pythoncat.top/what_is_xonsh.png)

## 🐼欢迎订阅

- [微信公众号](https://img.pythoncat.top/python_cat.jpg)：除更新周刊外，还发布其它原创作品，并转载一些优质文章。（可加好友，可加读者交流群）
- [博客](https://pythoncat.top) 及 [RSS](https://pythoncat.top/rss.xml)：我的独立博客，上面有历年原创/翻译的技术文章，以及从 2009 年以来的一些随笔。
- [邮件](https://pythoncat.substack.com) 及 [RSS](https://pythoncat.substack.com/feed)：在 Substack 上开通的频道，满足你通过邮件阅读时事通讯的诉求。
- [Github](https://github.com/chinesehuazhou/python-weekly)：你可以获取本周刊的 Markdown 源文件，做任何想做的事！
- [Telegram](https://t.me/pythontrendingweekly)：除了发布周刊的通知外，我将它视为一个“副刊”，补充发布更加丰富的资讯。
- [Twitter](https://twitter.com/chinesehuazhou)：我的关注列表里有大量 Python 相关的开发者与组织的账号。