---
title: 'Python 潮流周刊#39：Rust 开发的性能超快的打包工具'
pubDate: 2024-02-24
author: '豌豆花下猫'
---

你好，我是猫哥。这里每周分享优质的 Python、AI 及通用技术内容，大部分为英文。本周刊开源，欢迎[投稿](https://github.com/chinesehuazhou/python-weekly)。另有[电报频道](https://t.me/pythontrendingweekly)作为副刊，补充发布更加丰富的资讯，欢迎关注。

## 🦄文章&教程

1、[uv：Rust 开发的 Python 打包工具](https://astral.sh/blog/uv)

`Ruff` 所属团队用 Rust 开发的一个利器：Python 的包解析与安装器`uv` ！它被设计为 `pip` 和 `pip-tools` 的直接替代品，不使用缓存时比它们快 8-10 倍。也可通过 `uv venv` 用作虚拟环境管理器，比 `python -m venv` 快 80 倍，比`virtualenv` 快 7 倍。（附：[一篇中文翻译](https://pythoncat.top/posts/2024-03-05-uv)）

![解析和安装Trio库的性能对比](https://img.pythoncat.top/2024-02-23_uv.png)

2、[Rye：愿景延续](https://lucumr.pocoo.org/2024/2/4/rye-a-vision/)

Rye 是 Flask 作者在去年 4 月发布的 Python 打包和项目管理工具，作者在文章中总结了它已实现的功能（下载 Python、管理虚拟环境、构建和发布包、linting 和格式化、依赖管理等） ，介绍了自己的设计想法。（附1：作者的 16 分钟教程视频 [Rye: a Hassle-Free Python Experience](https://www.youtube.com/watch?v=q99TYA7LnuA)）（附2：上一则分享的 uv 团队已接管了 Rye，将来会融合成一个。[Rye Grows With UV](https://lucumr.pocoo.org/2024/2/15/rye-grows-with-uv/)）

3、[为什么越来越多用 Rust 开发的库？](https://baincapitalventures.com/insight/why-more-python-developers-are-using-rust-for-building-libraries/)

Rust 正在逐步取代 C 语言成为 Python 的高性能后端支撑。文章介绍了 Rust 相比 C 的优势所在，介绍了用 Rust 开发的一些知名的 Python 库。

4、[80 行 Python 实现一个搜索引擎](https://www.alexmolas.com/2024/02/05/a-search-engine-in-80-lines.html)

这篇文章略微标题党了，但是文章介绍的内容很完整：基于 RSS 的异步爬虫、倒排索引、搜索排名、基于 FastAPI 的 Web 网页。可以学习搜索引擎的工作原理，学习从数据获取、数据解析、开放接口、到网页呈现的项目开发流程。

5、[如何计算 Python 中的 CPU 指令数？](https://blog.mattstuchlik.com/2024/02/08/counting-cpu-instructions-in-python.html)

你知道执行 Python 的 `print("Hello")` 大约需要多少个 CPU 指令么？答案是 17000。导入 `seaborn` 则需要大约 20 亿个。作者开发了 [Cirron](https://github.com/s7nfo/Cirron) 库以计算 CPU 指令数、分支未命中数及代码的时间损耗等指标。

6、[Python 复用装饰器代码](https://www.kawabangga.com/posts/5757)

有多个装饰器要加在不同的函数上，而且相同的装饰器可能有不同传参，如何复用这些装饰器？问题初看可能不好理解，文章中有直观示例和解决过程，可以加深你对装饰器的理解和掌握高阶运用。

7、[像专业人士一样处理 Asyncio 任务](https://jacobpadilla.com/articles/handling-asyncio-tasks)

如何理解 Asyncio 中的 Task 对象？Asyncio 协程的工作原理是什么？如何等待一个任务，又如何等待多个或一组任务？文章介绍了 Asyncio 的工作原理以及任务处理相关的函数用法。

8、[使用 textwrap 模块操作字符串](https://martinheinz.dev/blog/108)

文章介绍了 `textwrap` 库的几个主要功能，例如 shorten() 裁剪字符串长度、wrap() 将字符串等宽分割、dedent() 处理字符串缩进等。

9、[总结 Python 版本间的主要变更点](https://www.nicholashairs.com/posts/major-changes-between-python-versions/)

Python 的一些新特性是在什么版本引入的？作者为了方便，梳理了一些重要语法和标准库的变更记录，同时也指出了每个版本终止维护的时间（例如 Python 3.8 将在今年 10 月 EOL）。（附：这个[网站](https://endoflife.date/python)可以查看 Python 及很多项目的 EOL 时间）

10、[将 Postgres 作为队列使用](https://leontrolski.github.io/postgres-as-queue.html)

直接将数据库作为队列使用，性能会不会很受影响？作者测试的结果是影响很小。具体该如何实现将 Postgres 作为队列使用？如何处理锁和事务、任务重试、处理任务超时等问题？

11、[我在所有 Django 项目中都用的 20 个包](https://learndjango.com/tutorials/20-django-packages-i-use-every-project)

Django 框架适用于构建复杂的 Web 项目，作者介绍了自己常用的 20 软件包，在 Django 自身的核心功能之外，提供了更丰富的功能。

12、[Python 元类的真实案例](https://dev.to/anbagu/real-case-of-python-metaclass-application-2pj8)

Python 中的元类是什么？为什么要学习元类？这个高级特性并不常用，但值得学习了解。文章介绍了元类的工作原理，并用现实例子演示它的强大用途。

13、[一万亿行气象数据的编程挑战](https://blog.coiled.io/blog/1trc.html)

一个编程挑战项目：有 100,000 个文件，每个文件 1000 万行，计算每个气象站的最低、平均和最高温度。数据存储在 S3 上，总大小 2.5 TB。作者给出了自己的实现（运行 8.5 分钟），以及优化成本的方案。

🎁**Python潮流周刊**🎁每 30 期为一季，第一季的精华内容已整理成一篇，方便你随时查看。在线访问地址：[Python 潮流周刊第一季精华合集（1~30）](https://pythoncat.top/posts/2023-12-11-weekly)

## 🐿️项目&资源

1、[uv：性能极快的 Python 包安装和解析器](https://github.com/astral-sh/uv)

用 Rust 开发的速度极快的 Python 包安装器和解析器。Ruff 团队作品。可直接替换 `pip` 、 `pip-tools` 和 `virtualenv` 常用命令。（star 6.6K）

2、[sqlite-web：基于 Web 的 SQLite 数据库工具](https://github.com/coleifer/sqlite-web)

基于 Flask 开发的 Web 端 SQLite 管理工具，可视化管理数据库、数据表、数据项和索引等，支持 JSON 和 CSV 格式文件的导入导出。（star 2.6K）

3、[celery-exporter：导出 Celery 指标用于 Prometheus](https://github.com/danihodovic/celery-exporter)

实时获取 Celery 的任务状态、工作线程、活动任务数等监控指标，遵循 Prometheus 导出器最佳实践，并利用 Celery-mixin 提供了 Grafana 仪表板及 Prometheus 告警功能。

4、[pyupgrade：自动升级 Python 较新版本的语法 ](https://github.com/asottile/pyupgrade)

一个强力的工具和 pre-commit 钩子，可以自动删除冗余写法、用新语法重写过时的代码、用更优雅的写法重构代码，等等。项目文档中给出了很多例子，推荐阅读。（star 3.2K）

```python
# 两个重写成字典推导式的示例
-dict((a, b) for a, b in y)
+{a: b for a, b in y}
-dict([(a, b) for a, b in y])
+{a: b for a, b in y}
```

5、[ollama-python： Ollama Python 库](https://github.com/ollama/ollama-python)

支持 Python 3.8+，简单快速集成 Llama 2、Code Llama、mistral、gemma 等大语言模型，可自定义客户端，还可创建异步客户端。

6、[web2pdf：将网页转换为 PDF 的 CLI](https://github.com/dvcoolarun/web2pdf)

一个命令行工具，可将网页转换为格式精美的 pdf。支持批量转换、自定义样式、附加 CSS、复杂布局、页码、目录和分页符等功能。

7、[natural-sql：文本生成 SQL 的大语言模型](https://github.com/cfahlgren1/natural-sql)

NaturalSQL-7B 是拥有超高准确性的文本生成 SQL 大模型，在 SQL-Eval 基准测试中领先 GPT-3.5-turbo 和 claude-2，也领先于同数据规模的 sqlcoder-7b。

8、[rawdog：在 CLI 中自动生成并执行 Python 脚本](https://github.com/AbanteAI/rawdog)

Rawdog（具有确定性输出生成的递归增强）是 RAG（检索增强生成）的一种新颖替代方案，可以自己运行脚本并获取输出作为上下文，然后再次调用自己。演示视频的例子很惊艳。（star 1.6K）

9、[UFO：基于 UI 与 Windows 系统交互的 AI 代理](https://github.com/microsoft/UFO)

微软新推出的 AI 代理框架，可无缝跨多应用操作，完成用户的复杂任务。使用 GPT-Vision 的多模态功能来理解应用 UI，使用 Windows UI 自动化控件交互。（star 1.9K）

![基于不同素材自动编写并发送邮件](https://img.pythoncat.top/overview_n.png)

10、[toolong：查看、跟踪、合并和搜索日志文件（以及 JSONL）的终端应用](https://github.com/Textualize/toolong)

在命令行终端快速查看日志文件，支持实时尾随、语法高亮、快捷搜索、自动检测时间戳合并日志等功能，支持 JSONL 文件，可自动打开 .bz 和 .bz2 文件。（star 2K）

11、[Owl：在本地运行的个人可穿戴 AI](https://github.com/OwlAIProject/Owl)

在可穿戴设备上搭载 AI，倾听和观察你生活中发生的一切。支持 ESP 平台、Sony Spresense 或 Apple Watch 等硬件，支持本地和在线模型，多模态采集，说话人验证等。

12、[hyperdiv：用 Python 构建响应式 Web UI](https://github.com/hyperdiv/hyperdiv)

一个用 Python 快速开发响应式 UI 应用的框架，具有内置组件、简洁的即时模式语法和少量的工具样板。支持 Shoelace 组件，支持 Markdown，集成 Chart.js 图表，支持读写浏览器缓存，支持表单验证等。

13、[fabric：使用 AI 增强人类](https://github.com/danielmiessler/fabric)

这个项目旨在使每个人能将 AI 用于解决日常问题。它的方法是将问题拆解成很多独立组件，使用结构化的清晰提示让 AI 完成任务。（star 5.6K）

## 🐢播客&视频

1、[Meta 喜欢 Python](https://engineering.fb.com/2024/02/12/developer-tools/meta-loves-python/)

Meta 官方的一期播客节目，讨论了开发团队对最新 Python 版本的贡献，包括允许自定义 JIT（如 Cinder）的新钩子、永生对象、对类型系统的改进、更快的推导式等等。Meta 对 Python 社区的贡献确实很足哦~（附：[谷歌、微软、Meta？谁才是 Python 最大的金主？](https://pythoncat.top/posts/2022-11-21-sponsors)）

2、[Talk Python To Me #449：使用 FastUI 构建 UI](https://talkpython.fm/episodes/show/449/building-uis-in-python-with-fastui)

FastUI 是一个 Web 界面开发框架，可使用 React 构建响应式 Web 应用，而无需编写任何 JavaScript 或接触 npm。这期播客的嘉宾是该框架的作者。

## 🐼欢迎订阅

- [微信公众号](https://img.pythoncat.top/python_cat.jpg)：除更新周刊外，还发布其它原创作品，并转载一些优质文章。（可加好友，可加读者交流群）
- [博客](https://pythoncat.top) 及 [RSS](https://pythoncat.top/rss.xml)：我的独立博客，上面有历年原创/翻译的技术文章，以及从 2009 年以来的一些随笔。
- [邮件](https://pythoncat.substack.com) 及 [RSS](https://pythoncat.substack.com/feed)：在 Substack 上开通的频道，满足你通过邮件阅读时事通讯的诉求。
- [Github](https://github.com/chinesehuazhou/python-weekly)：你可以获取本周刊的 Markdown 源文件，做任何想做的事！
- [Telegram](https://t.me/pythontrendingweekly)：除了发布周刊的通知外，我将它视为一个“副刊”，补充发布更加丰富的资讯。
- [Twitter](https://twitter.com/chinesehuazhou)：我的关注列表里有大量 Python 相关的开发者与组织的账号。