---
title: 'Python 潮流周刊#37：Python “令人失望”的动态类型超能力'
description: '本期周刊分享了 12 篇文章，12 个开源项目'
pubDate: 2024-01-27
author: '豌豆花下猫'
---

你好，我是猫哥。这里每周分享优质的 Python、AI 及通用技术内容，大部分为英文。本周刊开源，欢迎[投稿](https://github.com/chinesehuazhou/python-weekly)。另有[电报频道](https://t.me/pythontrendingweekly)作为副刊，补充发布更加丰富的资讯，欢迎关注。

## 🐱产品推荐

本周刊由“**Python猫**”出品，这是一个以 Python 技术科普和分享为主的科技自媒体，欢迎关注同名公众号。品牌合作请私信联系。

## 🦄文章&教程

1、[Python 装饰器的 3 个真实案例](https://www.bitecode.dev/p/xmas-decorations-part-3)

这是作者装饰器系列文章的第三篇，从很多开源库的现实用法中提取出了三个通用型用法：拦截调用、作函数注册、丰富函数行为。

2、[这不是面试建议：Python 不用堆和树实现按优先级过期的 LRU 缓存](https://death.andgravity.com/lru-cache)

假如这是一家超级大公司的面试题，不使用堆和二叉搜索树，如何实现标题的算法？文章通过最小合理方案，一步步提出问题再优化代码，并比较各种方案的时间复杂度，可以学到很多东西。

3、[Python dict() 和 {} 的性能分析](https://madebyme.today/blog/python-dict-vs-curly-brackets/)

Python 创建字典的两种写法 dict() 与 {} 有什么区别？文章通过它们的字节码和 CPython 解释器源码进行了深度分析。单纯看性能，结论是：{} 要比 dict() 快。（附：Python 为什么系列曾写过 [Python 疑难问题：\[\] 与 list() 哪个快？为什么快？快多少呢？](https://pythoncat.top/posts/2020-10-14-list)

4、[增强 Markdown 语言以实现出色的 Python 图形界面](https://www.taipy.io/posts/augmenting-the-markdown-language-for-great-python-graphical-interfaces)

**Taipy** 团队开发了增强型 Markdown API，通过添加标签在内容中生成图形界面元素。

![图形界面的效果演示](https://img.pythoncat.top/taipy_markdown.gif)

5、[7 个 Python 内存优化技巧](https://medium.com/techtofreedom/7-python-memory-optimization-tricks-to-enhance-your-codes-efficiency-5ef65bf415e7)

介绍了 Python 中 7 个可以优化内存的技巧：在类定义中使用\_\_slots\_\_、使用生成器、使用`mmap` 作大文件处理、减少使用全局变量、利用逻辑运算符的短路求值、选择合适的数据类型、使用字符串驻留技术。

6、[Python 中的垃圾回收：你需要知道的事情](https://rushter.com/blog/python-garbage-collector/)

Python 垃圾回收是如何实现的？CPython 为什么使用引用计数？分代垃圾回收器可以解决什么问题？如何查看和调试引用周期？

7、[Postgres 与 DynamoDB：该选择哪个数据库？](https://testdriven.io/blog/postgres-vs-dynamodb/)

**Postgres** 和 **DynamoDB** 两种数据库分别是如何使用的？应该如何选择？文章比较了它们的 ORM、查询、性能、备份、迁移等方面，并根据不同场景给出了方案选型的建议。

8、[使用 Streamlit 在 Python 中创建仪表板](https://blog.streamlit.io/crafting-a-dashboard-app-in-python-using-streamlit/)

一篇详细的官方博客教程，使用 Pandas 作数据整理，用 Altair/Plotly 作数据可视化，用 Streamlit 作前端。

![](https://img.pythoncat.top/streamlit-dashboard-python.png)

9、[scrapscript.py 编程语言的实现过程](https://bernsteinbear.com/blog/scrapscript/)

`Scrapscript` 是一种小型、纯粹、函数型、内容可寻址、网络优先的编程语言，作者介绍了它的设计原则、特性、已实现和开发中的功能，以及使用 Python 实现的过程。

10、[Python Cryptography 已支持 X.509](https://blog.trailofbits.com/2024/01/25/we-build-x-509-chains-so-you-dont-have-to/)

X.509 是一种 PKI 标准，用于定义数字证书的格式和标准化证书的属性。**Cryptography** 的 42.0.0 版本提供了 X.509 相关 API，文章介绍了它的重要意义、解决的相关问题。

11、[我对动态类型感到失望](https://buttondown.email/hillelwayne/archive/i-am-disappointed-by-dynamic-typing/)

作者感到失望的原因不是动态类型相比静态类型有什么缺点，而是认为 Python 没有充分利用动态类型的优势。动态不是静态的对立面，动态是可在运行时变更类型。作者希望增强动态分析的能力，希望动态类型的“test amplification”更容易，而不是转向类型注释或静态类型。

12、[Python “令人失望”的超能力](https://lukeplant.me.uk/blog/posts/pythons-disappointing-superpowers/)

这篇文章是对上一则分享的回应，通过 Werkzeug、Pony、Django、fluent-compile、Pytest 等库使用到的神奇技术（猴子补丁和动态元编程），说明 Python 动态类型的超能力。Python 能做的事或许超出你想象。

🎁**Python潮流周刊**🎁每 30 期为一季，第一季的精华内容已整理成一篇，方便你随时查看。在线访问地址：[Python 潮流周刊第一季精华合集（1~30）](https://pythoncat.top/posts/2023-12-11-weekly)

## 🐿️项目&资源

1、[core：可用于生产的 AI 助手框架](https://github.com/cheshire-cat-ai/core)

一个基于任意大语言模型构建自定义 AI 的框架，使用 Docker 部署。API 优先，支持插件扩展，带管理面板，记忆对话和文档。（star 1.6K）

![AI框架的对话界面](https://img.pythoncat.top/2024-01-26_core.png)

2、[van-gonography：将任意类型的文件隐藏在一张图像中](https://github.com/JoshuaKasa/van-gonography)

支持将任意类型文件隐藏在一张图像中，不影响图像的视觉效果。支持图像解码、图像比较、CLI、UI、跨平台、加密与压缩等功能。

3、[mpmath：任意精度的浮点数运算](https://github.com/mpmath/mpmath)

支持高精度的实数和复数浮点数运算，提供了大量特殊的用于数学运算的函数。

4、[sqlite-worker：在多线程应用中轻松管理 SQLite](https://github.com/roshanlam/sqlite-worker)

为 SQLite 数据库操作提供线程安全的接口，基于队列的语句执行。

5、[granian：用于 Python 程序的 Rust HTTP server](https://github.com/emmett-framework/granian)

用 Rust 实现的单一 HTTP 实现，避免常见的 Gunicorn + uvicorn + http-tools 依赖组合。支持 ASGI/3、RSGI 和 WSGI 接口应用，支持 HTTP/1 和 HTTP/2 协议。（star 1.5K）

6、[fasthx：FastAPI + HTMX 开发框架](https://github.com/volfpeter/fasthx)

FastAPI + HTMX 的组合，主要特点：装饰器语法、支持任意模板引擎和服务器端渲染库、内置 Jinja2、同时支持 HTMX 请求和普通请求、支持同步和异步路由……

7、[ml-engineering：机器学习工程开源书籍](https://github.com/stas00/ml-engineering)

一本适合 LLM/VLM 训练工程师和操作员的技术手册，可帮助成功训练大型语言模型和多模态模型。（star 6.9K）

8、[sglang：专为大型语言模型设计的结构化生成语言](https://github.com/sgl-project/sglang)

通过同时设计前端语言和运行时系统，使交互 LLMs 更快、更可控。支持多个链式生成调用、高级提示技术、控制流、多模态、并行和外部交互，具有 RadixAttention 的高性能运行时。

9、[chatgpt_telegram_bot：ChatGPT Telegram 机器人，无限制用 GPT-4 ](https://github.com/father-bot/chatgpt_telegram_bot)

将 ChatGPT 部署成自己的 Telegram 机器人，支持 GPT-4、GPT-4 Turbo 和 DALLE 2，支持群聊，内置 15 种特殊对话模式，支持查看 OpenAI API 花费等功能。 （star 4.5K）

10、[HuixiangDou：基于 LLM 的领域知识助手](https://github.com/InternLM/HuixiangDou)

它的中文名是“茴香豆”，提出一套解答技术问题的算法 pipeline，部署成本低，支持群聊这类复杂场景，支持微信群、lark 群组、飞书群、钉钉机器人等 IM。

11、[ComfyUI-InstantID：ComfyUI 的 InstantID 的非官方实现](https://github.com/ZHO-ZHO-ZHO/ComfyUI-InstantID)

使用 ID Base 模型、InsightFace 模型、ID ControlNet 模型、Ipadapter_instantid 等模型，官方提供 8 种风格。

![美美的安妮海瑟薇](https://img.pythoncat.top/2024-01-27_ComfyUI-InstantID.png)

12、[ComfyUI-PhotoMaker-ZHO：ComfyUI 的 PhotoMaker 的非官方实现](https://github.com/ZHO-ZHO-ZHO/ComfyUI-PhotoMaker-ZHO)

支持 lora、支持多批次、支持通用的 styler，官方提供 10 种风格。

![](https://img.pythoncat.top/2024-01-27_ComfyUI-PhotoMaker.png)

## 🐼欢迎订阅

- [微信公众号](https://img.pythoncat.top/python_cat.jpg)：除更新周刊外，还发布其它原创作品，并转载一些优质文章。（可加好友，可加读者交流群）
- [博客](https://pythoncat.top) 及 [RSS](https://pythoncat.top/rss.xml)：我的独立博客，上面有历年原创/翻译的技术文章，以及从 2009 年以来的一些随笔。
- [邮件](https://pythoncat.substack.com) 及 [RSS](https://pythoncat.substack.com/feed)：在 Substack 上开通的频道，满足你通过邮件阅读时事通讯的诉求。
- [Github](https://github.com/chinesehuazhou/python-weekly)：你可以获取本周刊的 Markdown 源文件，做任何想做的事！
- [Telegram](https://t.me/pythontrendingweekly)：除了发布周刊的通知外，我将它视为一个“副刊”，补充发布更加丰富的资讯。
- [Twitter](https://twitter.com/chinesehuazhou)：我的关注列表里有大量 Python 相关的开发者与组织的账号。