---
title: 'Python 潮流周刊#35：Python JIT 编译器和 Numpy2 即将推出'
pubDate: 2024-01-13
author: '豌豆花下猫'
---

你好，我是猫哥。这里每周分享优质的 Python、AI 及通用技术内容，大部分为英文。本周刊开源，欢迎[投稿](https://github.com/chinesehuazhou/python-weekly)。另有[电报频道](https://t.me/pythontrendingweekly)作为副刊，补充发布更加丰富的资讯，欢迎关注。

## 🦄文章&教程

1、[Python 3.13 也有了 JIT 编译器](https://tonybaloney.github.io/posts/python-gets-a-jit.html)

JIT（Just in Time）是什么？它的工作原理是怎样的？Python + JIT 能带来什么好处？copy-and-patch JIT 是 2021 年提出的设计，专为动态语言运行时而设计的高速算法。Python 3.13 有望实现它！上期周刊的第一则分享是关于它，本期我们继续哈~

2、[NumPy 2 即将推出：防止破坏，更新你的代码](https://pythonspeed.com/articles/numpy-2/)

NumPy 2 是一个重要的大版本，预计于 2024 年 3-4 月发布。它是一个不向后兼容版本，为了确保我们的应用不被破坏，有必要提前做些准备。文章介绍了新版本的不兼容修改、如何确保在合适的时机再安装新版本、如何轻松升级你的代码。

3、[Python 反直觉地在科学计算中兴起](https://cerfacs.fr/coop/fortran-vs-python)

文章提出了一个疑问：在关注性能的科学计算领域，以前很流行 Fortran，为什么现在越来越多使用性能较慢的 Python？原因也许是人们高估了执行速度的重要性，编程的敏捷性和项目的可维护性更重要，而且替代方案的性能也不差。（附：[Fortran 社区的讨论](https://fortran-lang.discourse.group/t/the-counter-intuitive-rise-of-python-in-scientific-computing/469)）

4、[在 Pandas 中实现快速高效的不等价连接](https://samukweku.github.io/data-wrangling-blog/notebooks/Fast-and-Efficient-Inequality-Joins-in-Pandas.html)

Pandas 支持用 **merge** 和 **join** 函数实现等价连接，但是不等价连接怎么办呢？文章介绍了两种比常规笛卡尔连接更好的方案：使用`pyjanitor` 库的 conditional_join 函数，既节省内存又不损性能；使用`DuckDB` 的 SQL 查询 DataFrame，性能极高。

5、[Pandas Profiling：详细介绍它的使用](https://www.influxdata.com/blog/pandas-profiling-tutorial/)

`Pandas profiling` 是一个很流行的库（已改名`ydata-profiling`），仅需一行代码就能生成数据集的分析报告。这篇教程介绍了它的工作原理、如何导入和生成报告、分析和处理敏感数据、分析大数据、它的替代库及它的缺点等内容。

6、[深入了解 Python 的 functools.wraps 装饰器](https://jacobpadilla.com/articles/Functools-Deep-Dive)

Python 装饰器是我最爱的特性之一。在我们自定义装饰器时，需要考虑元数据的丢失问题，`functools.wraps` 很关键。文章介绍了它的用处、如何使用它，以及如何传递自定义参数。

7、[纯 Python 实现的 SIMD](https://www.da.vidbuchanan.co.uk/blog/python-swar.html)

作者分享了如何用纯 Python 实现 **Game of Life**（用`pysdl2` 作图形输出），以 180fps 的 4K 分辨率运行，比传统的实现加速了 ~3800 倍。

8、[保护 Flask 程序的最佳实践](https://escape.tech/blog/best-practices-protect-flask-applications/)

想要提升 Flask 项目的安全性，免受安全漏洞侵害，有哪些最佳的技术实践？文章基于 **OWASP Top 10** 最常见漏洞，介绍了`yaml.safe_load` 加载 JSON、`defusedxml` 解析 XML、`flask_wtf` 保护表单、 `secure_filename` 处理文件路径、防 XSS 和 CSRF 的一些方法、构建安全 API 的 9 个建议，等等内容。涉及 **Flask-SSLify、Flask-RESTful、Flask-HTTPAuth、Flask-JWT-Extended 和 Flask-Limiter** 等库。

9、[使用服务器发送事件 （SSE） 将实时更新推送到客户端](https://rednafi.com/python/server_sent_events/)

服务器发送事件 SSE 是 Web 服务器向网页发送实时信息的一种方式，无需页面重复请求。文章用完整的例子介绍了如何用 Python 实现它，最后也指出了它的两点局限性。

10、[开发用 AI 驱动的 TODO 应用](https://tolkunov.dev/posts/ai-powered-todo-app/)

在人工智能时代，TODO 应用会是什么样子的？作者用 Django + 简单的 HTML + Whisper + mixtral-8x7b-instruct + SQLite 实现了一个 TODO 项目，值得借鉴学习！

11、[PEP-736 调用时关键字参数的简写语法](https://peps.python.org/pep-0736/)

这个 PEP 提议引入一个语法糖 `f(x=)` ，作为命名参数和值的变量名相同时`f(x=x)` 的简写。它与 f-string 的 `f'{x=}'` 相似，在 Ruby、JavaScript 和 Rust 中能找到类似的简写。据统计，这种模式占关键字参数用法的 10-20%。

12、[如何用 Python 删除图像中的背景？](https://pythonguides.com/remove-background-from-image-in-python/)

这篇教程介绍了如何用`Tkinter` 和`rembg` 实现移除图像的背景，效果挺不错。

![移除图像中的背景](https://img.pythoncat.top/2024-01-13_tkinter.png)

🎁**Python潮流周刊**🎁每 30 期为一季，第一季的精华内容已整理成一篇，方便你随时查看。在线访问地址：[Python 潮流周刊第一季精华合集（1~30）](https://pythoncat.top/posts/2023-12-11-weekly)

## 🐿️项目&资源

1、[ydata-profiling：用于 Pandas 和 Spark DataFrame 的数据分析](https://github.com/ydataai/ydata-profiling)

与 Pandas 的`df.describe()` 函数一样，ydata-profiling 非常好用，只要一行代码，提供了对 DataFrame 的扩展分析，支持以 html 和 json 等格式输出分析报告。（star 11.7K）

2、[pdfsyntax：检查和修改 PDF 文件内部结构](https://github.com/desgeeko/pdfsyntax)

这是用纯 Python 实现的轻量级库，用于检查和修改 PDF 文件，支持 CLI 和 API 用法。

3、[harlequin：终端里的 SQL IDE](https://github.com/tconbeer/harlequin)

在命令行终端里可视化操作 SQL。（star 1.6K）

![harlequin操作数据库](https://img.pythoncat.top/harlequin.svg)

4、[litellm：使用 OpenAI 格式调用所有 LLM API](https://github.com/BerriAI/litellm)

用统一的方式调用 LLM，支持 Bedrock、Azure、OpenAI、Cohere、Anthropic、Ollama、Sagemaker、HuggingFace、Replicate 等 100+ LLMs。（star 4.4K）

5、[unstructured：用于 AI 模型的非结构化数据预处理工具](https://github.com/Unstructured-IO/unstructured)

对文档（如 PDF、HTML、WORD等）和图像等非结构化数据作预处理，提供分区、清洗、暂存、提取、分块和嵌入等方法。（star 4.2K）

6、[chatgpt-on-wechat: 基于大模型搭建的聊天机器人，支持微信、企业微信、公众号、飞书](https://github.com/zhayujie/chatgpt-on-wechat)

可选择 GPT3.5/GPT4.0/Claude/文心一言/讯飞星火/通义千问/Gemini/LinkAI，能处理文本、语音和图片，访问操作系统和互联网，支持基于自有知识库进行定制企业智能客服。（star 19.9K）

7、[whisperX：具有单词级时间戳的自动语音识别](https://github.com/m-bain/whisperX)

对语音识别模型 Whisper 的增强，拥有更准确的时间戳、多说话人检测，并通过增强语音活动检测来减少幻觉，速度更快，占用内存更少。（star 7.4K）

![](https://img.pythoncat.top/WhisperX-pipeline.png)

8、[42 道在线的 Python 编程练习题](https://inventwithpython.com/pythongently/)

一个编程练习网站，提供了 42 道 Python 小项目练习题，有解答思路分析和参考答案。

9、[mealie：自托管的食谱管理和膳食计划项目](https://github.com/mealie-recipes/mealie)

一个食谱管理项目，具有 RestAPI 后端和用 Vue 开发的反应式前端。支持 PC、平板和移动端，可使用 url 轻松添加食谱，支持用户管理和群组管理。（star 4.3K）

10、[guardrails：给大语言模型添加护栏](https://github.com/guardrails-ai/guardrails)

大语言模型没有按预期回应，有什么办法？这个库可以指定输出结构和类型，可验证和更正大模型的输出，提升内容质量。（star 2.7K）

11、[chainlit：在几分钟内构建 Python LLM 应用程序](https://github.com/Chainlit/chainlit)

快速构建类型 ChatGPT 的 Web 应用，集成了 Langchain、Autogen、OpenAI Assistant、Llama、Haystack，可自定义前端实现全部功能，包括监控和观测、身份校验机制、多用户、各种工具无缝集成等。（star 4.3K）

12、[functime：用 Polars 构建的时间序列机器学习](https://github.com/functime-org/functime)

可在大型数据集上进行生产就绪的全局预测和时间序列特征提取，支持时间序列预处理、交叉验证拆分器和预测指标（MASE、SMAPE 等）。

## 🥂讨论&问题

1、[为什么 Python 会有.venv 虚拟环境的概念？](https://www.v2ex.com/t/1007645)

Python 为什么需要用虚拟环境？为什么 Python 会用这种包管理机制？包管理软件需要解决什么样的问题？

2、[Java 如何调用含有第三方依赖的 Python 项目？](https://www.v2ex.com/t/1003544)

在不能调用 API 的情况下，如何让 Java 项目调用 Python 项目？JNI-CPython-Python 方案有什么问题？打包成 EXE 和 so 实现如何？

## 🐼欢迎订阅

- [微信公众号](https://img.pythoncat.top/python_cat.jpg)：除更新周刊外，还发布其它原创作品，并转载一些优质文章。（可加好友，可加读者交流群）
- [博客](https://pythoncat.top) 及 [RSS](https://pythoncat.top/rss.xml)：我的独立博客，上面有历年原创/翻译的技术文章，以及从 2009 年以来的一些随笔。
- [邮件](https://pythoncat.substack.com) 及 [RSS](https://pythoncat.substack.com/feed)：在 Substack 上开通的频道，满足你通过邮件阅读时事通讯的诉求。
- [Github](https://github.com/chinesehuazhou/python-weekly)：你可以获取本周刊的 Markdown 源文件，做任何想做的事！
- [Telegram](https://t.me/pythontrendingweekly)：除了发布周刊的通知外，我将它视为一个“副刊”，补充发布更加丰富的资讯。
- [Twitter](https://twitter.com/chinesehuazhou)：我的关注列表里有大量 Python 相关的开发者与组织的账号。