---
title: 'Python 潮流周刊#34：Python 3.13 的 JIT 方案又新又好！'
pubDate: 2024-01-06
author: '豌豆花下猫'
---

你好，我是猫哥。这里每周分享优质的 Python、AI 及通用技术内容，大部分为英文。本周刊开源，欢迎[投稿](https://github.com/chinesehuazhou/python-weekly)。另有[电报频道](https://t.me/pythontrendingweekly)作为副刊，补充发布更加丰富的资讯，欢迎关注。

## 🦄文章&教程

1、[简单聊聊 Python 3.13 的 JIT 方案](https://www.manjusaka.blog/posts/2024/01/03/a-simple-introduction-about-python-jit/)

Python 3.13 将引入一个 **copy-and-patch** JIT 编译器，它尽可能地利用了 LLVM 生态的东西，编译器用 clang，编译参数开 -o3 获取最大的性能，二进制工具用 llvm-objdump 和 llvm-readelf，方案可谓是又新又好。

2、[在 Python 中读取 Excel 的最快方法](https://hakibenita.com/fast-excel-python)

如何用 Python 读取 Excel 文件？文章从速度、类型、正确性三个维度，分别用 **Pandas、Tablib、Openpyxl、LibreOffice、DuckDB 和 Calamine** 读取 Excel，得出了性能上的排名。

![Python库读取Excel性能对比](https://img.pythoncat.top/2024-01-05_excel.png)

3、[Flask 教程：从头开始构建可扩展的 Web 项目](https://realpython.com/flask-project/)

Flask 是强大且灵活的 Web 框架，这篇入门教程介绍了如何设置 Flask 项目、开发入门级项目、使用蓝图添加多页面、使用 Jinja 模板、存储静态文件等内容。

4、[Python、C、汇编 - 提高 2500 倍余弦相似度运算](https://ashvardanian.com/posts/python-c-assembly-comparison/)

余弦相似度是机器学习和信息检索中广泛使用的指标，文章以它为例，介绍了一些底层优化方法，从纯 Python 版本开始，Numpy 导致性能变慢、Scipy 提升 2-5x、C 语言提升 200x、SIMD 内部函数提升 400x、结合 AVX-512 与 BMI2 后 747x、增加 AVX-512FP16 后升至 1260x、使用 AVX-512VNNI 提升 2521x。

5、[使用 AI 检测 AI 生成的照片](https://tolkunov.dev/posts/ai-or-not/)

**Stable Diffusion XL** 和 **Midjourney v6** 等最新的 AI 模型可以生成极其逼真的图像，人眼已经越来越难以分辨真假。作者训练了一个能够检测 AI 生成图像的分类器，可获得 99% 准确率的结果。

6、[Python 内置函数 max 有毛病](https://mathspp.com/blog/max-is-broken)

作者敏锐地发现 **sum、all、any 和 math.prod** 几个函数在入参为空列表时，都有恰当的默认值，然而 **max** 和 **min** 函数却会报错！作者认为它应该等于负无穷大，你们怎么看？

7、[App 自动化测试之 Appium 应用篇| Appium 常用 API 及操作](https://juejin.cn/post/7318952376593006633)

Appium 是常用的 Android UI 自动化测试工具，文章出自一个 Appium 自动化测试系列教程。

8、[使用 Django 构建一个实时消息应用](https://www.photondesigner.com/articles/instant-messenger)

如何给 Django 应用添加异步的实时事件？不使用 Redis，使用 Django 最新的异步特性。文章演示开发了一个极简的 Web 端即时通讯应用。

9、[了解 Python 中的数值数据类型](https://fullspeedpython.com/articles/understanding-numeric-data-types/)

Python 有哪些常用的数值数据类型？它们有哪些特点，CPython 内部是如何实现的？文章介绍了整数、浮点数和复数类型，以及 **math、decimal 和 fractions** 三个模块。（附：[PEP-3141--数字的类型层级](https://github.com/chinesehuazhou/peps-cn/blob/master/StandardsTrack/3141--%E6%95%B0%E5%AD%97%E7%9A%84%E7%B1%BB%E5%9E%8B%E5%B1%82%E7%BA%A7.md)）

10、[非阻塞的 Asyncio 日志记录](https://superfastpython.com/asyncio-log-blocking/)

如何在 asyncio 程序中实现非阻塞记录日志？文章介绍了如何用共享的 **Queue** 和 **QueueHandler** 来记录日志，并使用 **QueueListener** 来存储日志。

11、[Instagram 如何仅凭 3 名工程师实现用户规模 1400 万](https://read.engineerscodex.com/p/how-instagram-scaled-to-14-million)

Instagram 在 2010-2011 年从 0 到 1400 万用户，那时仅仅有 3 名工程师！他们用了什么技术栈，有什么成功经验可给我们借鉴的？文章介绍了它使用到的相关技术和实现方案。

![Instagram早期架构解析图](https://img.pythoncat.top/Architecture-Overview-of-Instagram.png)

12、[Google 设计的类 Python 编程语言 Starlark](https://github.com/bazelbuild/starlark/blob/master/design.md)

Google 设计出 Starlark 旨在取代 Python 作为构建描述语言，语法非常相似。这份文档说明了它的一些设计原则，以及跟 Python 语言的诸多差异，比如它的布尔值不是整数、字符串不可迭代、没有“is”运算符、for/if 语句不允许在函数外部使用，等等。

13、[数据工程的历史和现状](https://www.dedp.online/part-1/1-introduction/history-and-state-of-data-engineering.html)

文章出自正在连载的免费在线电子书《数据工程设计模式》（Data Engineering Design Patterns）。数据工程经历了 SQL、维度建模、商业智能和大数据、MapReduce 和 Hadoop、云革命等阶段。

🎁**Python潮流周刊**🎁每 30 期为一季，第一季的精华内容已整理成一篇，方便你随时查看。在线访问地址：[Python 潮流周刊第一季精华合集（1~30）](https://pythoncat.top/posts/2023-12-11-weekly)

## 🐿️项目&资源

1、[watchfiles：简单快速的文件监听和代码重新加载](https://github.com/samuelcolvin/watchfiles)

简单快速实现对文件的监听，使用 Rust 的`Notify` 库处理底层文件系统通知，支持同步和异步监听处理。（star 1.4K）

```python
from watchfiles import watch

for changes in watch('./path/to/dir'):
    print(changes)
```

2、[hy：嵌入在 Python 中的 Lisp 方言](https://github.com/hylang/hy)

hy 是 Python 的一种替代语法，与 Python 相比，它提供了各种额外的功能、泛化和语法简化。与其它 Lisp 相比，它提供了对 Python 内置和第三方库的直接访问。（star 4.7K）

3、[pyapp：Python 应用的运行时安装器](https://github.com/ofek/pyapp)

使用 Rust 开发的工具，可构建运行时自启动的 Python 应用程序，为每个平台构建独立的二进制包。

4、[yarl：一个 URL 解析工具](https://github.com/aio-libs/yarl)

提供了 URL 类，可便利解析和修改 URL，支持通过属性方式访问 url 的每个部分。（star 1K）

5、[apispec：可插拔的 API 规范生成器，支持 OpenAPI 规范](https://github.com/marshmallow-code/apispec)

自动生成 API 接口规范文档，支持 OpenAPI 规范（即 Swagger 规范），与框架无关，内置对`marshmallow` 的支持。（star 1.1K）

6、[marshmallow：支持复杂对象与简单数据类型相互转换](https://github.com/marshmallow-code/marshmallow)

简单的对象序列化库，与 ORM/ODM/框架无关，可用于验证输入数据、序列化与反序列化，提供有丰富的字段类型，支持多种数据格式。（star 6.8K）

7、[jake：在 GitHub 上轻松创建和部署自己的单链接网站](https://github.com/thevahidal/jake)

单链接网站（one-link website）适合用作个人主页，这个网站模板使用 Github Pages 部署，让你轻松省力地构建美观的个人主页。

8、[docflow：功能强大的文档管理 API，无缝上传、下载、组织、版本控制、共享](https://github.com/jiisanda/docflow)

简化文档类的处理操作，支持身份验证和授权、列表权限控制、文档的增删改查、文档预览、版本控制等。

9、[auto\_job\_\_find\_\_chatgpt\_\_rpa：基于 ChatGPT 的自动投简历助手](https://github.com/Frrrrrrrrank/auto_job__find__chatgpt__rpa)

国人作品。利用 ChatGPT 根据你的简历和某招聘网站的职位描述，自动匹配和生成求职信息，自动发送给招聘人员。求职寒冬季，祝你好运！

10、[oshit：放在命令行终端的 Hacker News](https://github.com/davep/oshit)

简化的 Hacker News 阅读客户端，没有登录、投票、发布等功能，支持查看用户和评论信息。

![命令行中的Hacker News阅读器](https://img.pythoncat.top/2024-01-06_hacker_news.png)

11、[mixtral-offloading：在 Colab 或个人电脑上运行 Mixtral-8x7B 模型](https://github.com/dvmazur/mixtral-offloading)

实现了对 Mixtral-8x7B 模型的高效推理，需要大约 16 GB 的 VRAM 和 11 GB 的 RAM。（star 1.4K）

12、[RecoverPy：以交互方式从终端查找和恢复已删除或覆盖的文件](https://github.com/PabloLec/RecoverPy)

文件的数据被覆盖或删除了，还能找回么？这是一个 Linux 上的文件&数据恢复工具，支持文本搜索，支持交互式操作。（star 1.1K）

13、[MobileVLM：美团开源的移动设备视觉语言助手](https://github.com/Meituan-AutoML/MobileVLM)

在移动设备上运行的多模态视觉语言模型 （MMVLM），有 1.4B 和 2.7B 参数规模，在高通骁龙 888 CPU 和 NVIDIA Jeston Orin GPU 上分别获得每秒 21.5 个 token 和 65.3 个 token 的优秀性能。

![MobileVLM的架构图](https://img.pythoncat.top/mobilevlm_arch.png)

## 🐢播客&视频

1、[ 捕蛇者说 Ep 44. 与 Tualatrix 聊聊独立开发使用的技术栈](https://www.xiaoyuzhoufm.com/episode/65945c8c1e736aa25c935885)

独立开发者怎么做技术选型？为什么图拉鼎会用 Python 作为自己项目的后端语言？（附：两年前的另一期播客 [ByteTalk 3. 跟图拉鼎聊聊独立开发者的那些事](https://www.xiaoyuzhoufm.com/episode/618c9897fad86a854205b2a0)）

2、[给 Pythonistas 的 Rust 编程入门教程](https://www.youtube.com/watch?v=MoqtsYLGCC4)

以面向 Python 开发者的视角来对比和学习 Rust 编程，介绍了主要特性的差异（比如 Python 的类和 Rust 的 struct）。

## 🐼欢迎订阅

- [微信公众号](https://img.pythoncat.top/python_cat.jpg)：除更新周刊外，还发布其它原创作品，并转载一些优质文章。（可加好友，可加读者交流群）
- [博客](https://pythoncat.top) 及 [RSS](https://pythoncat.top/rss.xml)：我的独立博客，上面有历年原创/翻译的技术文章，以及从 2009 年以来的一些随笔。
- [邮件](https://pythoncat.substack.com) 及 [RSS](https://pythoncat.substack.com/feed)：在 Substack 上开通的频道，满足你通过邮件阅读时事通讯的诉求。
- [Github](https://github.com/chinesehuazhou/python-weekly)：你可以获取本周刊的 Markdown 源文件，做任何想做的事！
- [Telegram](https://t.me/pythontrendingweekly)：除了发布周刊的通知外，我将它视为一个“副刊”，补充发布更加丰富的资讯。
- [Twitter](https://twitter.com/chinesehuazhou)：我的关注列表里有大量 Python 相关的开发者与组织的账号。