---
title: 'Python 潮流周刊#33：FastAPI 很好，Flask 也没死，它们都有未来'
pubDate: 2023-12-30
author: '豌豆花下猫'
---

你好，我是猫哥。这里每周分享优质的 Python、AI 及通用技术内容，大部分为英文。本周刊开源，欢迎[投稿](https://github.com/chinesehuazhou/python-weekly)。另有[电报频道](https://t.me/pythontrendingweekly)作为副刊，补充发布更加丰富的资讯。

## 🐱产品推荐

本周刊由“[Python猫](https://img.pythoncat.top/python_cat.jpg)”出品，这是一个以 Python 技术科普和分享为主的科技自媒体，欢迎关注同名公众号。品牌合作请私信联系。

## 🦄文章&教程

1、[Flask 已死，FastAPI 是未来](https://zhuanlan.zhihu.com/p/672806587)

一篇标题十分吸睛引战的文章。说实话因见过太多“xxx 已死”、“再见了 xxx”这种煽动情绪的标题，我已经习惯绕道不读。比较框架优缺点，这非常合理，但刻意往贬低一方的角度引，就显狭隘了。（附：一篇回应文 [Flask 已死，FastAPI 永生](https://greyli.com/flask-fastapi-2023/)、对回应文的回应文 [理性参与讨论《Flask 已死，FastAPI 永生》](https://zhuanlan.zhihu.com/p/673847164)）

2、[Python + Flask 打造属于自己的 RSS 安全信息流](https://xz.aliyun.com/t/12980)

如何用 Python 搭建属于自己的 RSS 信息流网站？文章介绍了一个完整的 Flask 项目，支持对接 RSS、解析文章、自动更新，最后部署上线并使用 Nginx 作反向代理。

3、[Microdot：又一个 Python Web 框架](https://blog.miguelgrinberg.com/post/microdot-yet-another-python-web-framework)

作者介绍了自己开源的一个语法类似于 Flask 的 Web 框架，完全支持 asyncio 异步，支持 Websocket、SSE、CORS、Jinja 和 uTemplate 模板等功能。非常小（核心框架代码 700 多行），可以跟 MicroPython 一起使用。

4、[周末 AI 项目：在 2004 年的诺基亚 9500 上运行 7B 大型语言模型](https://ai.plainenglish.io/a-weekend-ai-project-running-a-7b-large-language-model-on-a-nokia-9500-from-2004-04f77e123194)

在近 20 年前的早期智能手机上运行当下最火的大语言模型，这事感觉蛮有趣！作者使用大小为 4GB 的`Llama-2–7B-Chat-GPTQ` 模型，最先尝试用 Streamlit 创建应用，但发现它的浏览器不支持，最后用 Flask 开发一个简单的网页，实现与 LLM 的交互！

![诺基亚9500手机上的大语言模型](https://img.pythoncat.top/2023-12-30_nokia.png)

5、[Python Asyncio 之常见的三个坑](https://so1n.me/2023/12/28/python_asyncio_lib_how_to_use_it_correctly/)

Asyncio 出现晚，不像`go` 、`Dart` 、`js`一样隐式的运行事件循环，又使用了`async` 、`await`的语法，所以很容易用错。文章介绍了三个坑，以及正确的避坑方法。

6、[Bash、Lua、Python 和 Rust 的梦幻岛冒险](https://dev.to/proteusiq/to-code-and-beyond-a-neverland-adventure-in-bash-lua-python-and-rust-1jon)

原文很短，推荐阅读。文章是三段“冒险故事”，主旨是让我们看到 Bash、Lua、Python 和 Rust 在实现常规 for 循环及推导式和迭代器写法时的相似性与差异性。（附：作者的另一篇 [数据兔子洞：爱丽丝从 Pandas 到 DuckDB 仙境的冒险](https://dev.to/proteusiq/down-the-data-rabbit-hole-alices-adventure-from-pandas-to-duckdb-wonderland-25h0)）

7、[YAML、Python 和 Holy Graal](https://yamlscript.org/posts/advent-2023/dec-21/)

[YAMLScript](https://yamlscript.org/) 是一种函数式编程语言，其语法使用 YAML 编码。它提供了 Python 的`yamlscript` 库，可与`PyYAML` 一样操作 YAML 文件，支持最新的 YAML 1.2 规范，还可使用 YAMLScript 函数来生成或操作数据。

8、[“Python -m”：最酷的 Python 标记，真的值得更多关注](https://www.blog.dailydoseofds.com/p/python-m-the-coolest-python-flag)

Python 有不少命令行标记，文章主要介绍了“-m”标记的用法。我非常认可原文标题中用“Coolest”形容这个标记。早在 2019 年，我写过一篇更为详尽的文章《[Python 中 -m 的典型用法、原理解析与发展演变](https://pythoncat.top/posts/2019-11-10-m)》，若你没读过，我诚心推荐！

9、[Python CI 的初学者指南](https://switowski.com/blog/ci-101/)

持续集成（简称 CI）是将开发者的代码合并到主存储库中的过程，它涉及的环节不少：提交前测试、代码格式化、静态分析、解决冲突等。很多任务需要用自动化方式，文章详细介绍了 CI 入门、CI 平台选择、CI 任务实践、CI 任务扩展等话题。

10、[Python Type Hints 简明教程（基于 Python 3.12）](https://zhuanlan.zhihu.com/p/464979921)

一篇很详细的 Type Hints 教程，大部分内容是对《流畅的 Python 第二版》与官方文档的总结，后续基于 Python 3.12 重新编排并新增了一些内容。（投稿自@[JayYoung2021](https://github.com/JayYoung2021)）

11、[Pyinstaller EXE 被检测为病毒？解决方案和替代方案](https://coderslegacy.com/pyinstaller-exe-detected-as-virus-solutions/)

Pyinstaller 可以将 Python 脚本转换为 Windows 可执行文件。为什么实际没问题的代码，却可能被检测为病毒呢？如何避免被防病毒软件误伤呢？文章介绍的解决方案有：避免单文件模式、自行构建 Pyinstaller 的引导加载程序、使用代码签名证书、使用 Nuitka/Inno Setup 等替代工具。

12、[Fontimize 简介|精确字体子集，仅使用你网站的字符](https://daveon.design/introducing-fontimize-subset-fonts-to-exactly-and-only-your-websites-used-characters.html)

"字体子集"指的是一个字体文件的部分，它有助于优化性能，减少下载时间。作者介绍了自己开源的用于生成字体子集的 Python 库`fontimize ` ，可以减少字体文件约 95% 的大小。

13、[GH-113464：copy-and-patch 的 JIT 编译器](https://github.com/python/cpython/pull/113465)

周刊第 27 期分享过 Python 3.13 正在开发一个 JIT 编译器的消息，现在 @brandtbucher 已经提交了 PR 啦（恰在圣诞节前）！commit 信息像是一首诗，蛮有意思。

14、[消失的隐喻：Zip 和 Paste](https://www.jefftk.com/p/losing-metaphors-zip-and-paste)

Python 中用`zip` 将两个列表合并，就像一个拉链， Unix 中的`paste` 命令可执行相同操作，它的比喻是粘贴：将一列放到另一列旁边。`paste` 可追溯到 1978 年，`zip` 则追溯到 1988 年，但现在这两个词通常被视作其它含义：`paste` 总是用于“复制和粘贴”，`zip` 是压缩文件格式。

15、[40 亿个 IF 语句](https://andreasjhkarlsson.github.io//jekyll/update/2023/12/27/4-billion-if-statements.html)

作者做了一个看似很无聊的尝试，成功将 40 亿个 if 语句写入到 40GB 文件中，可以快速判断任意 32 位数字是偶数还是奇数。这当然是没有现实用处的，但阅读文章你会了解做成这件事并不简单：如何高效写出这么多 if 语句？如何控制文件大小避免编译错误？如何加载和执行才能提升性能？

🎁**Python潮流周刊**🎁每 30 期为一季，第一季的精华内容已整理成一篇，方便你随时查看。在线访问地址：[Python 潮流周刊第一季精华合集（1~30）](https://pythoncat.top/posts/2023-12-11-weekly)

## 🐿️项目&资源

1、[nicegui：使用 Python 开发 Web 用户界面](https://github.com/zauberzeug/nicegui)

一个基于 Python 的 UI 框架，可以创建按钮、对话框、Markdown、3D 场景、绘图等前端标准元素，内置定时器定时刷新数据，支持 Tailwind CSS 自动补全，支持在 Jupyter Notebook 运行。（star 6.2K）

2、[csvkit：用于转换和处理 CSV 的命令行工具](https://github.com/wireservice/csvkit)

一套用于转换和处理 CSV 的命令行工具，一行命令实现一种常见功能，包括 Excel 转 CSV、JSON 转 CSV、CSV 转 JSON、打印列名、查找匹配单元格的行、生成统计信息、使用 SQL 方式查询表数据、导入和查询数据库数据。（star 5.7K）

```python
# 从 PostgreSQL 中提取数据到 CSV 文件
sql2csv --db postgresql:///database --query "select * from data" > new.csv
```

3、[evue：基于 html/css 的高性能 GUI 框架](https://github.com/scriptiot/evue)

基于 Flutter/LVGL 开发，支持多种操作系统，支持深色/浅色主题，支持响应式。采用编译时代码生成技术，性能卓越；原生支持 MVVM, 数据驱动 UI。

![evue拖拽生成计算器](https://img.pythoncat.top/2023-12-29-evue.png)

4、[JARVIS：自己的个人语音助手](https://github.com/AlexandreSajus/JARVIS)

开发个人语音助手，将你的语音转成文本给 GPT-3 以生成响应，使用 ElevenLabs 将大模型的响应转为语音，使用 Pygame 播放，使用 Taipy 呈现在网页上。

5、[Gooey：只需一行即可将几乎任何 Python 命令行程序转换为完整的 GUI 程序](https://github.com/chriskiehl/Gooey)

你敢相信么，只需加上这个库的一行装饰器代码，就能将 CLI 程序转换成用户友好的 GUI 程序？这个项目已存在多年，star 数很多。（star 20K）

6、[mod：Mojo 的包管理器工具](https://github.com/better-mojo/mod)

Mojo 还没有官方的包管理工具，因此作者用 Python 开发了一个。主要借鉴 Rust `cargo` 和 Python `poetry` ，规划提供的能力是：mod = cargo + rustup + poetry + pyenv。

7、[canopy：由 Pinecone 提供支持的 RAG 框架和上下文引擎](https://github.com/pinecone-io/canopy)

建立在 Pinecone 矢量数据库之上的 RAG 框架，只需简单的命令即可与文档数据聊天。包含文本数据分块与嵌入、聊天记录管理、查询优化、上下文检索（包括提示工程）和增强生成等功能。

![canopy的流程示意图](https://img.pythoncat.top/canopy.png)

8、[toogether-backend：Django REST 社交约会 APP 项目](https://github.com/damianstone/toogether-backend)

手机端社交约会 APP 项目，这是后端程序。使用 Django 框架，使用 Gdal、Geos 和 Postgis 进行地理定位。支持推荐匹配、聊天、群聊等功能。

9、[DouyinLiveRecorder: 可循环值守和多人录制的直播录制软件](https://github.com/ihmily/DouyinLiveRecorder)

支持抖音、Tiktok、快手、虎牙、斗鱼、B站、小红书等平台直播录制，抓取多平台直播源地址，抖音无水印解析，快手无水印解析。基于 FFmpeg 实现，支持自定义配置录制以及直播状态推送。

10、[StreamDiffusion：用于实时交互式生成的管道级解决方案](https://github.com/cumulo-autumn/StreamDiffusion)

使用创新的方案，为当前基于扩散的图像生成技术引入了显著的性能增强。（star 6.4K）

![实时生成海浪演示](https://img.pythoncat.top/demo_02.gif)

11、[sqlglot：SQL 解析器和转译器](https://github.com/tobymao/sqlglot)

一个无依赖的 SQL 解析器、转译器、优化器和引擎。可用于格式化 SQL 或在 20 种不同的方言之间进行翻译，例如 DuckDB、Presto / Trino、Spark / Databricks、Snowflake 和 BigQuery。（star 4.4K）

12、[texify：输出 LaTeX 和 Markdown 的数学 OCR 模型](https://github.com/VikParuchuri/texify)

将包含数学公式的图像或 pdf 转换为 Markdown 和 LaTeX 格式，可以在 CPU、GPU 或 MPS 上运行。与同类的 **Pix2tex** 和 **nougat** 项目不同，它支持更多样化的 Web 场景。

13、[talebook：一个简单的在线版个人书库](https://github.com/talebook/talebook)

一个基于 Calibre 的个人图书管理系统，支持在线阅读。后端采用 Tornado 框架，前端采用 Vue.js 和 Readium.js。界面美观，支持多用户、在线阅读、批量导入、邮件推送、书籍信息自动更新、私人模式等功能。（star 2K）

![talebook界面](https://img.pythoncat.top/talebook.png)

## 🐢播客&视频

1、[为什么 Python, Go, Rust, Kotlin 没有三元运算符？](https://www.bilibili.com/video/BV1v64y1J7hS)

这是 UP 主@今天晚放学 基于我的文章制作的视频，算得上是一份 2024 年元旦贺礼了！相信很多读者已经看过[文章版](https://pythoncat.top/posts/2023-04-03-condition)（毕竟上期周刊我还心血来潮分享过），但我还是推荐你再看看这则视频版。另外，作者的“编程美学”系列视频，做的真不错。

## 🐼欢迎订阅

- [微信公众号](https://img.pythoncat.top/python_cat.jpg)：除更新周刊外，还发布其它原创作品，并转载一些优质文章。（可加好友，可加读者交流群）
- [博客](https://pythoncat.top) 及 [RSS](https://pythoncat.top/rss.xml)：我的独立博客，上面有历年原创/翻译的技术文章，以及从 2009 年以来的一些随笔。
- [邮件](https://pythoncat.substack.com) 及 [RSS](https://pythoncat.substack.com/feed)：在 Substack 上开通的频道，满足你通过邮件阅读时事通讯的诉求。
- [Github](https://github.com/chinesehuazhou/python-weekly)：你可以获取本周刊的 Markdown 源文件，做任何想做的事！
- [Telegram](https://t.me/pythontrendingweekly)：除了发布周刊的通知外，我将它视为一个“副刊”，补充发布更加丰富的资讯。
- [Twitter](https://twitter.com/chinesehuazhou)：我的关注列表里有大量 Python 相关的开发者与组织的账号。