---
title: 'Python 潮流周刊#32：打造个人的新闻聚合阅读器'
pubDate: 2023-12-23
author: '豌豆花下猫'
---

你好，我是猫哥。这里每周分享优质的 Python、AI 及通用技术内容，大部分为英文。本周刊开源，欢迎[投稿](https://github.com/chinesehuazhou/python-weekly)。另有[电报频道](https://t.me/pythontrendingweekly)作为副刊，补充发布更加丰富的资讯。

## 🐱产品推荐

本周刊由“**Python猫**”出品，这是一个以 Python 技术科普和分享为主的科技自媒体，欢迎关注同名公众号。品牌合作请私信联系。

## 🦄文章&教程

1、[在并行程序中实际最多能用多少个 CPU？](https://pythonspeed.com/articles/cpu-thread-pool-size/)

在 CPU 密集型任务中，通常要根据 CPU 核心数来设置线程/进程池的大小。但如何确定实际用多少个 CPU 最合适呢？物理 CPU 和逻辑 CPU 是什么？如何测试设置多少 CPU 数比较合适？

2、[你的 Python 包都装到哪了？](https://frostming.com/2019/03-13/where-do-your-packages-go/)

Python 新手经常会遇到包相关的问题，主要原因之一是不清楚 Python 是如何找包的。文章介绍了 Python 查找包的顺序、它是如何安装包的、虚拟环境的作用、脚本运行方式对搜索路径的影响等。

3、[移除 CPython 中的私有 C API 函数](https://vstinner.github.io/remove-c-api-funcs-313.html)

Victor Stinner 是很活跃的核心开发者，他在 Python 3.13 alpha 1 中删除了 300 多个私有 C API 函数，收到了一些负面反馈，在 alpha 2 版本中又恢复了 50 个函数。文章记录他所做的事情，以及社区中大家的反馈。

4、[Python 小陷阱：复制列表时的问题](https://andrewwegner.com/python-gotcha-list-copy.html)

如何给 list 这种可变对象创建副本？对于一维列表，文章介绍了三种方法；但是对于二维列表，就涉及浅拷贝与深拷贝问题，需要使用 **copy.deepcopy()** 。（附注：作者的“**Python Gotcha** ”系列短文，介绍了 Python 的一些使用注意事项。）

5、[取消 Asyncio 任务的最佳实践](https://superfastpython.com/asyncio-task-cancellation-best-practices/)

Asyncio 任务有手工取消和自动取消，文章介绍了 6 项最佳实践，给出了相应的示例。

6、[Python 项目中的配置：没有魔法，只是必要的实践](https://robertrode.com/2023/10/02/configuration-in-python-applications-no-magic-just-necessary-practice.html)

我们通常将可变或敏感的参数放到配置文件中，可以使用哪些方式呢？有 ini、json、toml、yaml 等文件，也有环境变量等方式。在什么时候做配置的初始化呢？测试时如何修改配置呢？文章分享了一些使用技巧。

7、[优化 Python 的 Flask、Django 和 FastAPI 程序](https://tonybaloney.github.io/posts/fine-tuning-wsgi-and-asgi-applications.html)

文章介绍了一些配置 Web 服务器的最佳实践（涉及 **Gunicorn、Uvicorn 和 Hypercorn**）。针对 ASGI 和 WSGI 两类标准接口的差异，如何设置 worker 数和线程数，如何使用 Locust 等工具来作测试，不同 Web 开发框架该用什么方案？

8、[为什么 Python、Go 和 Rust 都不支持三元运算符？](https://pythoncat.top/posts/2023-04-03-condition)

Python 不支持三元运算符，但它有一个很特殊的**条件选择语法** ，为什么会这样设计呢？文章梳理了 Python 波折的语法设计故事，同时介绍了 Go 和 Rust 不谋而合的做法，让人思考什么才是编程语言中更好的语法设计？

9、[Python 中的“key”参数的关键](https://www.thepythoncodingstack.com/p/the-key-to-the-key-parameter-in-python)

你也许在 sorted() 和 list.sort() 函数中看到过“key”参数，除此之外，还有很多函数带有这个参数，比如 max() 和 min()，文章介绍了相关函数中对这个参数的用法

10、[从 Python 数据类中消除状态突变方法](https://rednafi.com/python/dataclasses_and_methods/)

Python 中可以使用`@dataclass` 装饰器来定义数据类，它会自动添加 `__init__`、`__repr__`、`__eq__` 等魔术方法，减少代码量。作者建议定义不可变的数据类，不用将它像普通类一样作变更属性的操作，如果在普通类中要用`__repr__` 等方法，建议是手写实现。

🎁**Python潮流周刊**🎁每 30 期为一季，第一季的精华内容已整理成一篇，方便你随时查看。在线访问地址：[Python 潮流周刊第一季精华合集（1~30）](https://pythoncat.top/posts/2023-12-11-weekly)

## 🐿️项目&资源

1、[feedi：打造个人的新闻聚合阅读器](https://github.com/facundoolano/feedi)

想不想拥有个人定制化的内容阅读器？它支持解析 RSS 源、拉取 Mastodon 消息、阅读标记、本地文章阅读和预览、支持发送到 Kindle。（附：作者为什么以及如何开发这个项目 [Reclaiming the Web with a Personal Reader](https://olano.dev/2023-12-12-reclaiming-the-web-with-a-personal-reader/)）

![feedi的界面效果](https://img.pythoncat.top/feedi.png)

2、[generative-ai-python：用 Google AI SDK，开发 Gemini 和 PaLM 应用](https://github.com/google/generative-ai-python)

Google 推出的生成式 AI 开发工具，可快速基于 Gemini 和 PaLM 大模型开发 AI 应用。支持文本生成、多轮对话、嵌入等。

3、[python-guide-for-javascript-engineers：开源电子书《JavaScript工程师的Python指南》](https://github.com/luckrnx09/python-guide-for-javascript-engineers)

一本基于 [abook](https://github.com/luckrnx09/abook) 编写的开源电子书，涵盖了从 Python 环境安装到项目开发的方方面面。通过大量案例对比 JavaScript 和 Python 语言的异同，帮助 JavaScript 工程师快速掌握 Python 语言。（投稿自@[luckrnx09](https://github.com/luckrnx09)）

4、[sqlmap：SQL 注入和渗透测试工具](https://github.com/sqlmapproject/sqlmap)

可自动检测和利用 SQL 注入缺陷而入侵数据库。具有强大的检测引擎、数据库指纹识别、从数据库查询数据、访问底层文件系统、在操作系统上执行命令等。（star 29.4K）

5、[TikTokDownloader: TikTok 和抖音数据采集工具](https://github.com/JoeanAmier/TikTokDownloader)

基于 Requests 模块实现的数据采集工具，功能非常齐全！支持命令行模式、Web UI 模式和接口调用模式。（star 1.5K）（附：第 25 期分享过作者的小红书采集工具 **XHS_Downloader**）

6、[Osprey：通过视觉指导微调实现对像素的理解](https://github.com/CircleRadon/Osprey)

这是一个靠演示效果把我惊艳到的项目！直接看下方的演示图吧：

![视觉理解清明上河图中的内容](https://img.pythoncat.top/Osprey.gif)



7、[django-cast：基于 Django 和 Wagtail 的博客/播客项目](https://github.com/ephes/django-cast)

使用  Django 快速搭建个人博客和播客网站，Wagtail 作为 CMS 可方便管理文章和播客节目。支持播放播客和视频，支持评论和垃圾邮件过滤，可自定义网站主题。

8、[Qexo：快速、强大且漂亮的 Hexo 编辑器](https://github.com/Qexo/Qexo)

Hexo 博客后台管理，自定义图床上传图片、在线页面管理、开放 API、一键更新、快速接入友情链接。（star 1.2K）

9、[project-based-learning：精选的基于项目的教程列表](https://github.com/practical-tutorials/project-based-learning)

星星数超多的资源收集类项目，分不同编程语言和技术领域，收集了很多实战项目类的教程。（star 142K）

10、[Amphion：用于音频、音乐和语音生成的工具包](https://github.com/open-mmlab/Amphion)

它的目标是提供一个平台来研究将任意输入转换为音频。已支持 TTS 文本转语音、SVC 歌声转换、TTA 文本到音频，支持广泛使用的神经声码器。（star 2.2K）

## 🐢播客&视频

1、[PyConChina 2023 的演讲视频](https://space.bilibili.com/474764697/video)

今年 PyConChina 活动的一部分视频已发布了，可在 B 站上观看。

![PyConChina 2023 的视频列表](https://img.pythoncat.top/2023-12-23_pyconchina.png)

2、[Episode #184：PyCoder's Weekly 的 2023 年总结](https://realpython.com/podcasts/rpp/184/)

PyCoder's Weekly 是我长期在看的周刊，这期播客聊了它的一些总结性话题，比如点击量前 5 的链接、今年一些重要的新闻、今年的重要主题和趋势、有意思的项目，等等。

3、[Requests vs Httpx vs Aiohttp 该选哪一个呢？](https://www.youtube.com/watch?v=OPyoXx0yA0I) 

视频比较了使用 requests、httpx 和 aiohttp 的情况，讨论了异步请求的使用等话题。

## 🐼欢迎订阅

- [微信公众号](https://img.pythoncat.top/python_cat.jpg)：除更新周刊外，还发布其它原创作品，并转载一些优质文章。（可加好友，可加读者交流群）
- [博客](https://pythoncat.top) 及 [RSS](https://pythoncat.top/rss.xml)：我的独立博客，上面有历年原创/翻译的技术文章，以及从 2009 年以来的一些随笔。
- [邮件](https://pythoncat.substack.com) 及 [RSS](https://pythoncat.substack.com/feed)：在 Substack 上开通的频道，满足你通过邮件阅读时事通讯的诉求。
- [Github](https://github.com/chinesehuazhou/python-weekly)：你可以获取本周刊的 Markdown 源文件，做任何想做的事！
- [Telegram](https://t.me/pythontrendingweekly)：除了发布周刊的通知外，我将它视为一个“副刊”，补充发布更加丰富的资讯。
- [Twitter](https://twitter.com/chinesehuazhou)：我的关注列表里有大量 Python 相关的开发者与组织的账号。