---
title: 'Python 潮流周刊#31：继 iOS 后，新 PEP 提议官方添加 Android 为支持平台'
pubDate: 2023-12-16
author: '豌豆花下猫'
---

你好，我是猫哥。这里每周分享优质的 Python、AI 及通用技术内容，大部分为英文。本周刊开源，欢迎[投稿](https://github.com/chinesehuazhou/python-weekly)。另有[电报频道](https://t.me/pythontrendingweekly)作为副刊，补充发布更加丰富的资讯。

## 🐱产品推荐

本周刊由“**Python猫**”出品，这是一个以 Python 技术科普和分享为主的科技自媒体，欢迎关注同名公众号。品牌合作请私信联系。

## 🦄文章&教程

1、[PEP-738：将 Android 添加为第 3 层支持的平台](https://pep-previews--3586.org.readthedocs.build/pep-0738/#)

周刊第 24 期分享过 [PEP-730 CPython 提供对 iOS 的官方支持](https://peps.python.org/pep-0730/) ，这个 PEP-738 则是将目标转到了 Android 系统。目前两个 PEP 都是草案状态，但 Android 使用的是 Linux 内核，也许这个 PEP 被采纳的可能性会更大些吧？（附：今年 Python 语言峰会上的 [Python on Mobile: State of the Union](https://pyfound.blogspot.com/2023/05/the-python-language-summit-2023-python.html)）

2、[深度解析 Marker：AI 驱动的 PDF 布局检测引擎的源码解读](https://journal.hexmos.com/marker-pdf-document-ai/)

第 29 期分享的 PDF 转 Markdown 工具 **Marker** 短短两周时间已经逼近 5K star了。这篇文章解读了它的工作原理，介绍了它的 6 个阶段及所依赖到的工具（PyMuPDF、OCRMyPDF、Tesseract 等等）。

![Marker的工作原理](https://img.pythoncat.top/2023-12-15-marker.png)

3、[现实世界的 match/case](https://nedbatchelder.com/blog/202312/realworld_matchcase.html)

Python 3.10 引入了 **match-case** 模式匹配语法，你们在项目中用过了么？这篇文章介绍了一种使用场景，是处理 Github 机器人返回的复杂 JSON 数据，相比传统的写法，它使得代码变得简单了。

4、[pytest 守护进程：提升 10 倍本地测试迭代速度](https://discord.com/blog/pytest-daemon-10x-local-test-iteration-speed)

Discord 的官方博客文章，分享了他们将某个测试从 20 秒提升到 2 秒的故事！做法是使用“**pytest 守护进程**”和热加载，确保在需要测试时马上有进程可用，省去了即时准备工作的耗时。文章还提到了一个实现同样功能的开源项目 [pytest-hot-reloading](https://github.com/JamesHutchison/pytest-hot-reloading/) 。

5、[使用 Python 88 行代码写一个简易的 Android AI 程序](https://vra.github.io/2023/10/14/android-ai-app-in-88-lines-of-python-code/)

开发一个在手机上 SDXL **text-to-image** 的 Demo，这听起来就不是一件简单的事情，但这篇文章介绍说只用 88 行 Python 代码就能实现？！用的技术是 **Beeware** 和 **LeptonAI**，前者在我们周刊中出现过多次（例如上文中的两个 PEP 都与它有很深的联系），后者是知名 AI 专家 @贾扬清 的创业项目。

6、[在 Python 中不需要这些无谓的操作](https://www.bitecode.dev/p/you-dont-need-this-in-python)

作者指出了一些常见的 Python 多余/错误用法，包括`# -*- coding: utf-8 -*-` 、`range(len(xx))` 、追踪循环的位置、用 index() 判断是否包含、单独的 getter 和 setter。其中第一个关于编码的确实很常见，它也让我想起另一个经常被无意识使用的`if __name__ == '__main__'` 。（附：[为什么我不推荐写所谓的 main 函数？](https://pythoncat.top/posts/2020-06-03-main)）

7、[为什么要用“if TYPE_CHECKING”？](https://vickiboykis.com/2023/12/11/why-if-type_checking/)

`if TYPE_CHECKING` 的作用是为了实现条件式导入模块，基本示例如下：

```Python
from typing import TYPE_CHECKING

if TYPE_CHECKING:
    from collections.abc import Sequence

def func(value: Sequence[int]) -> None:
    pass
```

在什么情况下要这样用呢？文章介绍了这种模式的必要性，简单结论：在 mypy 强制执行的类型检查和运行时的类型检查之间作出权衡，特别是在有大量循环依赖的情况下。

8、[对比 SQLALchemy 与 Django ORM](https://st4lk.github.io/en/blog/2023/12/09/sqlalchemy-vs-django-orm/)

它们都是关系型数据库的对象关系映射（ORM）框架，作者基于从 **Django ORM** 切换到 **SQLAlchemy** 的视角，介绍了两者的一些差异和正确用法，避免在使用时犯错。

9、[Python \_\_init\_\_.py 的最佳实践](https://coderslegacy.com/python-init-py-best-practices/)

`__init__.py` 是 Python 中特有的一个文件，为什么会需要用到这样的文件呢？它的作用是什么？如何自定义这个文件，又有哪些使用技巧和最佳实践呢？推荐阅读这篇很详细的教程。

10、[Mojo：来自一位 Python 研究员的观点](https://augierpi.gricad-pages.univ-grenoble-alpes.fr/mojo-the-point-of-view-of-a-researcher-using-python.html)

一篇系统分析 Mojo 的文章，作者想研究的问题是：Mojo 是什么，未来会如何发展？Mojo 对通用科学计算（即不仅是 AI）有用么？它什么时候才真正可用，目前还缺少什么？作者不认可流传的“**Mojo==Python++** ”说法，而是把它视为一门新颖的静态语言来研究。

11、[Python 中的简单 HTTP 状态码](https://www.b-list.org/weblog/2023/dec/04/python-http-status-codes/)

不要在代码中直接用数字表示 HTTP 请求的状态码，这属于“魔术数字”，并不规范。Django、Starlette 和 Litestar 等框架都提供有枚举值，但更推荐的是使用标准库的`http.HTTPStatus` ，另外从 Python 3.12 开始，还可以用`HTTPStatus.is_success` 表示 2xx 状态码。（附：本文出自作者日更的“降临节日历”系列文章，多是些编程小技巧，[去博客阅读](https://www.b-list.org/weblog/)）

12、[CPython 开发实战：实现 None 感知运算符 ?. 和 ??](https://juejin.cn/post/7310101543776829440)

[PEP-505 None 感知运算符](https://peps.python.org/pep-0505/) 是一份被推迟的提案，它的用途是简化判空时的条件处理。文章介绍了 PEP 里的三种 None 感知运算符，并做了一个简单版实现。文末还提及了不支持这份提案的两个评论，我想附和一句：还是不要加了，继续 Deferred 吧！

13、[代码的运行多于被阅读](https://olano.dev/2023-11-30-code-is-run-more-than-read/)

“**Code is read more than written**”是编程的基本常识之一，提醒着程序员要关注代码的可读性和可维护性。作者将它提炼为“maintainer > author”，但是，编码只是达成目标的手段，它为用户提供服务，因此是“user > dev”，而且最终目的是为业务创造价值，因此初步推出“biz > user > ops > dev”。这个结论对么？作者逐一考虑/权衡各项因素的重要性，又列出了多组关系，最终简明的结论是：user > ops > dev，biz > ops > dev，biz ≹ user。

🎁**Python潮流周刊**🎁每 30 期为一季，第一季的精华内容已整理成一篇 6.2 万字的长文，方便你随时查看和下载。在线访问地址：[Python 潮流周刊第一季精华合集（1~30）](https://pythoncat.top/posts/2023-12-11-weekly)

## 🐿️项目&资源

1、[magic-animate：使用扩散模型的时间一致的人像动画](https://github.com/magic-research/magic-animate)

由新加坡国立大学和字节跳动联合推出，利用一张人像和动作图生成人物的运动视频。（star 7.8K）

2、[phpy：连通 Python 和 PHP 的生态系统](https://github.com/swoole/phpy)

让你在 PHP 中使用 Python 的函数和类库，或者在 Python 中使用 PHP 的包。实现原理是在进程内同时创建了 `ZendVM` 和 `CPython VM`，直接在进程堆栈空间内使用 `C` 函数互相调用。目前不支持 Python 多线程和异步 IO 特性。 

3、[insanely-fast-whisper：快到极致的 Whisper](https://github.com/Vaibhavs10/insanely-fast-whisper)

基于 OpenAI 的 Whisper Large v3 的音频转录工具，转录 150 分钟的音频仅需 98 秒。（star 4.2K）（附：另一个 [faster-whisper：使用 CTranslate2 作更快的 Whisper 转录](https://github.com/SYSTRAN/faster-whisper) ，star 6.2K）

4、[coffee：使用 AI 将 UI 的构建和迭代速度提高 10 倍](https://github.com/Coframe/coffee)

非常有创意的项目。在前端项目中引入它的组件，用自然语言描述你想实现的效果，它就会辅助生成实现代码。

![演示视频中的用法截图](https://img.pythoncat.top/2023-12-16_coffee.png)

5、[FastUI：更快构建更好的 UI](https://github.com/pydantic/FastUI)

Pydantic 推出的 Web 界面开发框架，可使用 React 构建响应式 Web 应用程序，而无需编写一行 JavaScript。（star 2.7K）

6、[mistral-src：Mistral AI 7B v0.1 模型的参考实现](https://github.com/mistralai/mistral-src)

Mistral AI 7B 的表现极为亮眼，在评分上接近了 Llama 70B 版本。这个项目是官方开源，用于快速部署和使用这个模型。（star 5.4K）

7、[netchecks：查验网络运行条件的工具](https://github.com/hardbyte/netchecks)

用于测试网络条件是否符合预期，支持验证 DNS 和 HTTP 连接，可配置断言条件，支持自定义验证内容。

8、[Pearl：Meta 推出的强化学习 AI 代理库](https://github.com/facebookresearch/Pearl)

由 Meta 的应用强化学习团队开源，采用模块化设计，为生产环境提供了一系列独特的功能，包括动态行为空间、离线学习、智能神经探索、安全决策制定、历史总结和数据增强。（star 1.4K）

![Pearl的设计图](https://img.pythoncat.top/agent_interface.png)

9、[gpt-fast：简单高效的 PyTorch 原生 Transformer 文本生成](https://github.com/pytorch-labs/gpt-fast)

一个 PyTorch 的展示项目，用不到 1000 行 Python 代码，实现简单高效的文本生成。（star 4.1K）

10、[The-Grand-Complete-Data-Science-Materials：数据科学的视频和材料](https://github.com/krishnaik06/The-Grand-Complete-Data-Science-Materials)

一个资源收集型仓库，包含数据分析、数据科学、机器学习、生成式 AI 等专题的大量视频列表。（star 4.2K）

11、[awesome-LLMs-In-China：中国的大模型](https://github.com/wgwang/awesome-LLMs-In-China)

中国大模型列表大全，全面收集有明确来源的大模型情况，包括机构、来源信息和分类等，目前列表中有 189 个国内大模型。（star 2.6K）

12、[msgspec：高性能的序列化和校验库](https://github.com/jcrist/msgspec)

支持对 JSON、MessagePack、YAML 和 TOML 等格式的序列化与校验，拥有超高性能。（star 1.5K）

![msgspec、pydantic、cattrs、mashumaro的性能对比](https://img.pythoncat.top/bench-validation.svg)

🎁**Python潮流周刊**🎁已开源在 Github 上，目前获得 940 star，如果周刊对你有帮助，可以给颗 star 支持下么？（有没有可能在 2023 年的最后两周突破 1K star 呢？）

## 🐢播客&视频

1、[PSF 官宣一档播客节目：Python 的隐藏人物](https://pyfound.blogspot.com/2023/12/announcing-hidden-figures-of-python-pypodcats.html)

“Hidden Figures of Python”播客的目标是展示 Python 社区中少数群体的声音。第一期节目是四名女性主播介绍播客的起源和对 Top Python 播客中女性嘉宾稀少的现象分析。

2、[Talk Python To Me #442 使用 msgspec 作超高速的消息解析](https://talkpython.fm/episodes/show/442/ultra-high-speed-message-parsing-with-msgspec)

这期播客的嘉宾是上文 msgspec 的作者 Jim Crist-Harif。

3、[DjangoCon US 2023 的视频列表，60 个视频](https://www.youtube.com/playlist?list=PL2NFhrDSOxgX41jqYSi0HmO9Wsf6WDSmf)

DjangoCon US 是一个专注于 Django Web 框架的年度性大会，今年的视频已发布。

![DjangoCon US的视频列表](https://img.pythoncat.top/2023-12-16_djangocon.png)

## 🐼欢迎订阅

- [微信公众号](https://img.pythoncat.top/python_cat.jpg)：除更新周刊外，还发布其它原创作品，并转载一些优质文章。（可加好友，可加读者交流群）
- [博客](https://pythoncat.top) 及 [RSS](https://pythoncat.top/rss.xml)：我的独立博客，上面有历年原创/翻译的技术文章，以及从 2009 年以来的一些随笔。
- [邮件](https://pythoncat.substack.com) 及 [RSS](https://pythoncat.substack.com/feed)：在 Substack 上开通的频道，满足你通过邮件阅读时事通讯的诉求。
- [Github](https://github.com/chinesehuazhou/python-weekly)：你可以获取本周刊的 Markdown 源文件，做任何想做的事！
- [Telegram](https://t.me/pythontrendingweekly)：除了发布周刊的通知外，我将它视为一个“副刊”，补充发布更加丰富的资讯。
- [Twitter](https://twitter.com/chinesehuazhou)：我的关注列表里有大量 Python 相关的开发者与组织的账号。