---
title: 'Python 潮流周刊#29：Rust 会比 Python 慢？！'
pubDate: 2023-12-02
author: '豌豆花下猫'
---

你好，我是猫哥。这里每周分享优质的 Python、AI 及通用技术内容，大部分为英文。本周刊开源，欢迎[投稿](https://github.com/chinesehuazhou/python-weekly)。另有[电报频道](https://t.me/pythontrendingweekly)作为副刊，补充发布更加丰富的资讯。

## 🐱产品推荐

[FlowUs 息流](https://flowus.cn/login?code=MX4369)是新一代知识管理与协作平台，支持云文档、多维表、文件夹、团队空间，提供 100+ 模板，可用于管理笔记、安排计划、文档协作、制作个人主页等。猫哥邀请你一起使用 FlowUs 提升个人生产力：https://flowus.cn/login?code=MX4369

![](https://img.pythoncat.top/flowus_pythoncat.png)

## 🦄文章&教程

1、[Rust std fs 比 Python 慢！真的吗！？](https://mp.weixin.qq.com/s/m-IBomxu88DlNcEyOgyOew)

一篇长文，由一个诡异的问题开始：Rust 写的程序竟然比 Python 慢？！作者在定位根因的过程中，多次得到 Rust 方案比 Python 慢的结果，甚至 C 版本代码也比 Python 的慢！层层深入，用上各种定位手段，最后发现竟然是 AMD CPU 内核的问题！

2、[Python 中性能最快的时间戳函数是哪个？](https://www.dataroc.ca/blog/most-performant-timestamp-functions-python)

Python 中有哪些获取时间戳的函数？它们的性能表现如何？文章取了 7 种函数进行性能测算，发现 time.time() 是最快的。文章发布后引起了一些争议，于是作者写了第二篇，做了 Win10、WSL2 和 Ubuntu20 的对比，也增加了 Python 3.10 和 3.12 的对比。（附：[第二篇性能对比的文章](https://www.dataroc.ca/blog/most-performant-timestamp-functions-python-2)）

![调用50万次所需的时间](https://img.pythoncat.top/2023-12-01_time.png)

3、[Python 是 Easy，Go 是 Simple，但 Simple != Easy](https://preslav.me/2023/11/27/python-is-easy-golang-is-simple-simple-is-not-easy/)

Python 简单易用门槛低，因为它把很多复杂的工作交给了解释器，这使得它适合用作原型设计，快速开发应用。Go 语言也简单，但相比 Python 的规则要多一些，性能也更高。作者的建议是同时发挥两者的优势。

4、[使用 Numba 提升 pandas.DataFrame.apply 的 C 级别性能](https://labs.quansight.org/blog/unlocking-c-level-performance-in-df-apply) 

在 Pandas 2.2.0 中，DataFrame.apply 可以指定一个新的 numba 引擎，实现并行化的操作。文章介绍了这个引擎的工作原理、它支持的应用场景及无法做到的事，同时给出了多项性能测试的数据。

5、[一份杂乱的 Flask 维护任务清单](https://davidism.com/maintainer-notes/)

作者是 Flask 的维护者之一，列出了一份任务清单，提供给 Flask 的贡献者们方便着手处理。我们多数人没有维护开源项目的经验，或许无法想象项目维护者们要做那一大堆与编码完全无关的事。（题外话：Flask 的 star 数在本周已落后于 FastAPI，失去了 Web 框架第二高 star 的位置）

6、[用子解释器运行 Python 并行程序](https://tonybaloney.github.io/posts/sub-interpreter-web-workers.html)

Python 3.12 开放了子解释器的一个 API，它有什么用呢？子解释器与多线程、多进程有什么区别，它们的性能差距有多少？将子解释器用于 Web 开发，会有什么效果？作者用开发中的 Python 3.13 做了一些实验，结果有惊喜也有程序异常。期待明年真正无-GIL 的 Python 吧！

![工作负载和执行时间的增长率](https://img.pythoncat.top/2023-12-01_sub.png)

7、[新的开源库 VS. 旧的开源库 ](https://dev.to/taipy/new-open-source-vs-old-open-source-33k7)

文章选取了 10 组在 Python 社区很知名的库，同时给出它们相对应的替代库，这里最没争议的估计是 Ruff 替代 Pylint，其它则还有：Taipy/Streamlit、Polars/Pandas、Dask/PySpark、PyTorch/TensorFlow ……

8、[在 Pandas 的世界中使用 Polars](https://pythonspeed.com/articles/polars-pandas-interopability/)

Polars 是速度更快、内存效率更高、更易于使用的数据处理库，可作为 Pandas 的替换。但是替换后如何与第三方库更好地集成呢？文章介绍了几种处理方法，实现从 Pandas 到 Polars 的无缝切换。

9、[Python 的软关键字有哪些？](https://mathspp.com/blog/til/pythons-soft-keywords)

软关键字（soft keyword）指的是可以被重新赋值的关键字。作者想利用正则表达式从 Python 最新的语法文件中找出所有的软关键字。最后得知只需下面两行代码就能做到（以下是 Python 3.12 的结果，即现在有 4 个软关键字）：

```python
>>> import keyword
>>> keyword.softkwlist
['_', 'case', 'match', 'type']
```

10、[用 Python 实现机器人爸爸](https://blog.untrod.com/2023/11/robot-dad.html)

为了应对小孩的提问，作者开发了一个“机器人爸爸”。用到了 Eleven Labs 作声音克隆，用 Picovoice 语音转文字提取唤醒词，最后调用 ChatGPT 接口获取答案。

11、[如何（以及如何不）设计 REST API](https://github.com/stickfigure/blog/wiki/How-to-(and-how-not-to)-design-REST-APIs)

文章列出了十多项 REST API 的最佳实践规则，解释了规则的含义及实现，另外，作者嘲笑了几家公司被广泛使用的 API，将它们作为规则的反例。

12、[如何调试 Asyncio 程序？](https://superfastpython.com/debug-asyncio/)

文章介绍了几种调试 Asyncio 代码的方法，包括启用它的调试日志、在调试模式下运行事件循环、自定义调试信息等。（附：文章的姊妹篇 [如何分析 Asyncio 程序？](https://superfastpython.com/profile-asyncio-programs/) 分析慢程序和高频函数）

## 🐿️项目&资源

1、[marker：高效将 PDF/EPUB/MOBI 转换为 Markdown](https://github.com/VikParuchuri/marker)

支持将多种文件格式转换为 markdown，可删除页眉/页脚，将方程式转换为 latex，格式化处理代码块和表格，另外也支持多种语言。（star 2.3K）（附：将整本 PDF 版《Think Python》[转换后的效果](https://github.com/VikParuchuri/marker/blob/master/data/examples/marker/thinkpython.md)）

![与Nougat在速度和准确性的对比](https://img.pythoncat.top/2023-12-02_maker.png)

2、[awesome-django-performance：精选资源，用于分析和优化 Django 项目](https://github.com/st3v3nmw/awesome-django-performance)

这个项目整理了一些库、工具、文章和书籍，主要集中在 profile、数据库、缓存、序列化、任务处理和监测等方面。

3、[datamodel-code-generator：将 JSON/YAML 转换为 Pydantic 模型](https://github.com/koxudaxi/datamodel-code-generator)

一个数据模型代码生成器，支持多种输入类型（OpenAPI、JSON、YAML、CSV、Python 字典、GraphQL），输出 Pydantic、dataclass、TypeDict 等类型。（star 2K）

4、[fastapi-code-generator：用 openapi 文件创建 FastAPI 程序](https://github.com/koxudaxi/fastapi-code-generator)

它利用 datamodel-code-generator 生成 pydantic 模型，基于 OpenAPI 格式的接口文件，快速生成 FastAPI 项目。支持自定义模板，允许将自定义变量传给自定义模板。

5、[kanban-python：终端中的看板应用程序](https://github.com/Zaloog/kanban-python)

在命令行窗口中实现的看板应用工具，有漂亮的表格、配置与数据分离、可自动创建任务、可作任务跟踪。

![看板应用的示例](https://img.pythoncat.top/2023-12-2-kanban.png)

6、[saq：简单的异步队列](https://github.com/tobymao/saq)

一个基于 Asyncio 和 Redis 之上的简单且高性能的任务队列框架。提供有一个简单的 UI，可查看任务队列、状态及执行详情等信息。

7、[pyqtgraph：用于科学/工程应用的数据可视化及 GUI 工具](https://github.com/pyqtgraph/pyqtgraph)

一个高性能的绘图工具库，利用 Numpy 作数值运算、用 Qt 的 GraphicsView 框架作 2D 显示和 OpenGL 作 3D 显示。（star 3.5K）

8、[toga：Python 原生、OS 原生的 GUI 工具包](https://github.com/beeware/toga)

一个用于创建跨平台桌面应用的 GUI 工具，支持 MacOS、Windows、Linux (GTK)、Android、iOS 和单页 Web 应用。（star 3.9K）

9、[autometrics-py：函数级的指标监测工具](https://github.com/autometrics-dev/autometrics-py)

它提供了一个装饰器，可检测函数的请求率、错误率和延迟等指标，方便你识别和调试程序的问题。支持用 Prometheus 查询与分析、开箱即用的 Grafana 仪表板、自定义告警、运行开销小。

![](https://img.pythoncat.top/2023-12-02_autometrics.png)

10、[compiled：Python 标准库的编译后的变体](https://github.com/pycompiled/compiled)

Python 中有些标准库是用纯 Python 实现的，可能会成为性能瓶颈。这个项目将经过 mypyc 类型检查的标准库编译成 C 代码版本，比原始版本快 2-4 倍。目前已完成 tomllib 和 difflib，计划中还有 asyncio、urllib、zipfile、argparse 和 uuid。

11、[transpyler-gpt：GPT 驱动的 Python 转译器，让代码在旧版本上运行](https://github.com/frostming/transpyler-gpt)

它借助 GPT 将高版本 Python 代码转译成目标环境的 Python 版本代码，实现向下兼容执行。例如将 Python 3.10+ 的 match-case 代码转译成 if-else 代码，可在更低 Python 版本中执行。

12、[clone-voice: 一个带 web 界面的声音克隆工具](https://github.com/jianchang512/clone-voice)

支持中文、英文、日语、韩语 4 种语言，可在线从麦克风录制声音。支持文字转语音和语音变声。（star 1.3K）

![语音克隆演示](https://img.pythoncat.top/2023-12-02_voice.png)

## 🐢播客&视频

1、[Talk Python To Me #439：Pixi 一个高性能的包管理器](https://talkpython.fm/episodes/show/439/pixi-a-fast-package-manager)

Pixi 是用 Rust 开发的基于 Conda 的包管理器。

2、[Mouse Vs Python #23：与 Charlie Marsh 聊 Ruff Formatter](https://www.blog.pythonlibrary.org/2023/11/27/episode-23-the-ruff-formatter-with-charlie-marsh/)

Ruff 是一个用 Rust 编写的 Python linter+formatter，而且两方面都是性能最快的。

## 🥂讨论&问题

1、[你用 Python 做过最酷的事情是什么？](https://www.reddit.com/r/Python/comments/17upt2f/whats_the_coolest_things_youve_done_with_python/)

Reddit 上的热门讨论帖，也有近 700 条评论，需要刷很久才能看完。。。

2、[鼓励使用命名参数的语法糖](https://discuss.python.org/t/syntactic-sugar-to-encourage-use-of-named-arguments/36217)

函数的命名参数提高了可读性，但也可能使代码重复和冗长。作者提出了一个简化变量写法的语法糖，得到了不少核心开发者的支持。

## 🐼欢迎订阅

- [微信公众号](https://img.pythoncat.top/python_cat.jpg)：除更新周刊外，还发布其它原创作品，并转载一些优质文章。（可加好友，可加读者交流群）
- [博客](https://pythoncat.top) 及 [RSS](https://pythoncat.top/rss.xml)：我的独立博客，上面有历年原创/翻译的技术文章，以及从 2009 年以来的一些随笔。
- [Github](https://github.com/chinesehuazhou/python-weekly)：你可以获取本周刊的 Markdown 源文件，做任何想做的事！
- [邮件](https://pythoncat.substack.com)：在 Substack 上开通的频道，满足你通过邮件阅读时事通讯的诉求。
- [Telegram](https://t.me/pythontrendingweekly)：除了发布周刊的通知外，我将它视为一个“副刊”，补充发布更加丰富的资讯。
- [Twitter](https://twitter.com/chinesehuazhou)：我的关注列表里有大量 Python 相关的开发者与组织的账号。