---
title: 'Python 潮流周刊#28：两种线程池、四种优化程序的方法'
pubDate: 2023-11-25
author: '豌豆花下猫'
---

你好，我是猫哥。这里每周分享优质的 Python、AI 及通用技术内容，大部分为英文。本周刊开源，欢迎[投稿](https://github.com/chinesehuazhou/python-weekly)。另有[电报频道](https://t.me/pythontrendingweekly)作为副刊，补充发布更加丰富的资讯。

## 🐱产品推荐

**Walles.AI** 是一款适用于所有网站的浏览器插件，支持 GPT4 问答、ChatPDF、网页内容解释及翻译、生成高质量文章、与 Notion 等工具协同、在线摘要 Youtube 视频等。立即前往官网，免费使用（请在 PC 端访问）：[安装地址](https://walles.ai?invite_code=CGZP5W)

![](https://img.pythoncat.top/2023-11-08_ai.png)

## 🦄文章&教程

1、[四种优化程序的方法](https://tratt.net/laurie/blog/2023/four_kinds_of_optimisation.html)

很值得推荐的文章。正文部分介绍了优化程序的四种方法：使用更好的算法、使用更好的数据结构、使用底层的编程语言、以及接受不太精确的解决方案。文章开头和结尾则提出了一些教训：我们对于性能优化问题容易过度乐观、我们可能只顾性能而牺牲了正确性、不该作过早和复杂的优化、优化的广度比优化的深度更重要。

2、[两种线程池，以及为什么需要这两种线程池？](https://pythonspeed.com/articles/two-thread-pools/)

由于 GIL 的限制，因此在 Python 中使用线程池需要注意业务是 CPU 密集型任务还是 IO 密集型任务，这将导致在线程数量和线程池目标上的不同选择。

3、[是时候改变了：datetime.utcnow() 现已被弃用](https://blog.miguelgrinberg.com/post/it-s-time-for-a-change-datetime-utcnow-is-now-deprecated)

Python 3.12 版本中`datetime.datetime` 的 `utcnow()` 与 `utcfromtimestamp()` 方法已被标注为“deprecated”，将在未来版本中删除。文章介绍了它们的缺陷，解释了为什么它们会被弃用。替代的方法分别是：`datetime.now()` 和 `datetime.fromtimestamp()` 。

4、[Python Web 应用的线上部署](https://www.biaodianfu.com/python-web-server-deployment.html)

介绍了如何使用 Nginx+Gunicorn+Supervisor、Nginx+uWSGI+Supervisor、Waitress、Meinheld 等不同方案部署 Flask 应用，分析了它们的优缺点。

5、[Python GIL 作出的不断变化的“保证”](https://stefan-marr.de/2023/11/python-global-interpreter-lock/)

介绍了 CPython 全局解释器锁的实现细节，介绍了从 Python 3.9 到目前 3.13 开发版之间的变化。其中有一项很大的差别，在 3.9 及早期版本，GIL 在执行很多字节码时会释放，而在 3.13 版本，只在少数字节码上检查是否释放 GIL。

6、[使用 pip-compile 和 pip-tools 作 Django 的依赖项管理](https://learndjango.com/tutorials/django-dependency-management-pip-compile-and-pip-t)

Python 的依赖管理有很多选择，文章介绍了 pip-compile 和 pip-tools 的组合方案。

7、[Python 程序的 bug 分类](https://threeofwands.com/the-types-of-errors-in-python-apps/)

作者将程序的 bug 分成四类：类型错误和 linting 错误、导入时异常、运行时异常、静默的错误。处理的策略是减少出现后面的错误类型，将其变为前面的错误处理。

8、[有多少 Python 核心开发者使用类型提示？](https://blog.orsinium.dev/posts/py/core-devs-typing/)

Python 的类型提示正在逐渐流行，但是，它在核心开发者群体中已经普及到什么程度了呢？作者经过分析，给出了这样的数据：所有核心开发者中，大约 53% 的人最近有开源项目，其中 39% 的人使用类型提示。近 3 年里加入团队的人中，有 76% 使用类型提示。

9、[记一次用 Python 的 ast 模块将 Flask 项目转为 Quart 的尝试](https://juejin.cn/post/7304706387645071395)

作者为了使用 OpenAI 返回的异步迭代器内容，将不支持异步的 Flask 项目重构成了支持异步的 Quart。但手动修改的工作量太大，因此他想到通过解析 ast 来修改，提升项目转换的效率。

10、[Python NumPy 库的可视化解释](https://solothought.com/tutorial/python-numpy/)

文章使用了大量直观的图形展示 Numpy 数据的分布以及数据变化过程，让你轻松掌握 Numpy 数据操作。

11、[用组合还是继承？我有不同看法](https://coady.github.io/posts/composition-vs-inheritance.html)

传统观点认为组合优于继承，但作者认为 Python 不能很好地支持，若教条式使用组合，只会引入问题，因此作者提供了一种简单实现的思路。

12、[选择正确的数据仪表板工具：Streamlit 和 Shiny 的独特优势](https://python-bloggers.com/2023/10/choosing-the-right-data-dashboard-tool-the-unique-strengths-of-streamlit-and-shiny/)

在数据驱动关键决策的时代，交互式仪表板已成为商业、科学研究等行业不可或缺的工具。Streamlit 和 Shiny（包括 RShiny 及 PyShiny）是功能强大的框架，文章介绍了它们各自的优势。

🎁**Python潮流周刊**🎁我会在 [电报频道](https://t.me/pythontrendingweekly) 分享很多不收录在周刊里的内容，目前已有 1200+ 同学关注，欢迎你的加入！

## 🐿️项目&资源

1、[screenshot-to-code：利用截图生成 HTML/Tailwind/JS 代码](https://github.com/abi/screenshot-to-code)

超级火爆的新项目，它使用 GPT-4 Vision 生成代码，使用 DALL-E 3 生成与截图相似的外观。甚至可以输入 URL 来实时克隆一个网站！（star 19.4K）

2、[sqlalchemy_data_model_visualizer：将SQLalchemy数据模型转换为漂亮的SVG图表](https://github.com/Dicklesworthstone/sqlalchemy_data_model_visualizer)

将 SQLAlchemy ORM 模型生成高质量的可视化效果，使用 Graphviz 将每个模型呈现为有向图，更容易理解数据库表之间的关系。

![数据库表的有向图](https://img.pythoncat.top/2023-11-25_sql.png)

3、[aiconfig：配置驱动的 AI 应用开发框架](https://github.com/lastmile-ai/aiconfig)

它通过将提示、模型参数及模型密切相关的逻辑与应用代码分离，降低复杂度。SDK 是与模型无关的，可扩展到任何生成式 AI 模型。

4、[PyNest：基于 FastAPI 构建的框架，遵循 NestJS 的模块化架构](https://github.com/PythonNest/PyNest)

可以让你轻松构建可扩展且可维护的 API，支持依赖注入、类型注释、装饰器和代码生成。

5、[StyleTTS2：近乎人类水平的文本转语音库](https://github.com/yl4579/StyleTTS2)

它利用风格扩散和对抗训练与大型语音语言模型 （SLM） 来实现人类水平的 TTS 合成。（star 2.7K）

6、[pyjokes：程序员的一句话笑话（笑话即服务）](https://github.com/pyjokes/pyjokes)

安装后，只需从命令行调用 pyjoke 或将其添加到 .bashrc 文件中，每次打开终端时都会看到一个笑话。

7、[gTTS：用于与 Google 的文本转语音 API 交互](https://github.com/pndurette/gTTS)

用于调用 Google Translate 的文本转语音 API，提供可定制的语音特定的句子分词器，以及可定制的文本预处理器。（star 2K）

8、[chatfairy：极简的网页版聊天室，只依赖 Flask](https://github.com/yuxiaoy1/chatfairy)

极简的聊天室应用，前后端代码在仅 115 行的单文件中，使用 SSE 作后端消息推送，不依赖websocket，支持用户认证、多用户聊天、上下线通知、路由保护。（投稿自@yuxiaoy1）

![聊天效果演示](https://img.pythoncat.top/2023-11-25_chatfairy.png)

9、[streamlit-shadcn-ui：在 streamlit 中使用 shadcn-ui 组件](https://github.com/ObservedObserver/streamlit-shadcn-ui)

Streamlit 的组件选择相对局限，且样式比较古老。这个项目将前端流行的 shadcn 组件库引入到 Streamlit 当中，UI 更为美观。

10、[video-subtitle-remover：用 AI 去除图片/视频的硬字幕/水印](https://github.com/YaoFANGUK/video-subtitle-remover)

可无损分辨率将视频中的硬字幕去除，生成去除字幕后的文件，利用 AI 填充原字幕区域；支持自定义字幕位置，支持全视频自动去除所有文本。

11、[flowty-realtime-lcm-canvas：使用 LCM 和 gradio 库的草图到图像演示](https://github.com/flowtyone/flowty-realtime-lcm-canvas)

将你的草稿图实时变成生动的图像，可更改 UI 中的模型 ID 来使用不同的模型。（star 1.5K）

12、[pyephem：科学级的天文学计算库](https://github.com/brandon-rhodes/pyephem)

可执行高精度天文学计算，用于查找行星、彗星或小行星的位置，确定特定星体的位置，计算月球各阶段的日期，天文坐标系转换，确定春分和冬至的日期，等等。

本文首发于：[https://pythoncat.top/posts/2023-11-25-weekly](https://pythoncat.top/posts/2023-11-25-weekly)

## 🐼欢迎订阅

- [微信公众号](https://img.pythoncat.top/python_cat.jpg)：除更新周刊外，还发布其它原创作品，并转载一些优质文章。（可加好友，可加读者交流群）
- [博客](https://pythoncat.top) 及 [RSS](https://pythoncat.top/rss.xml)：我的独立博客，上面有历年原创/翻译的技术文章，以及从 2009 年以来的一些随笔。
- [Github](https://github.com/chinesehuazhou/python-weekly)：你可以获取本周刊的 Markdown 源文件，做任何想做的事！
- [邮件](https://pythoncat.substack.com)：在 Substack 上开通的频道，满足你通过邮件阅读时事通讯的诉求。
- [Telegram](https://t.me/pythontrendingweekly)：除了发布周刊的通知外，我将它视为一个“副刊”，补充发布更加丰富的资讯。
- [Twitter](https://twitter.com/chinesehuazhou)：我的关注列表里有大量 Python 相关的开发者与组织的账号。