---
title: 'Python 潮流周刊#27：应该如何处理程序的错误？'
pubDate: 2023-11-18
author: '豌豆花下猫'
---

你好，我是猫哥。这里每周分享优质的 Python、AI 及通用技术内容，大部分为英文。本周刊开源，欢迎[投稿](https://github.com/chinesehuazhou/python-weekly)。另有[电报频道](https://t.me/pythontrendingweekly)作为副刊，补充发布更加丰富的资讯。

## 🐱产品推荐

**Walles.AI** 是一款适用于所有网站的浏览器插件，支持 GPT4 问答、ChatPDF、网页内容解释及翻译、生成高质量文章、与 Notion 等工具协同、在线摘要 Youtube 视频等。前往官网体验：[安装地址](https://walles.ai?invite_code=CGZP5W)

## 🦄文章&教程

1、[将 Python 错误作为值：比较 Go 和 Rust 的使用模式](https://www.inngest.com/blog/python-errors-as-values)

文章比较了两种处理错误的方法：抛出错误和将错误作为返回值，并参照 Go 和 Rust 的处理模式，介绍如何在 Python 中实现将错误作为值返回。（附1：[两种风格的错误处理](https://frostming.com/error-handling/) 分析了两种风格的优缺点及其适用场景；附2：周刊第一期的 [编程语言的四种错误处理方法](https://pythoncat.top/posts/2023-05-08-error) 从语法、代码可读性、演变过程、运行效率角度对比了不同方案）

2、[调试 Django 中的 CSRF 失败/403 禁止错误](https://www.better-simple.com/django/2023/11/04/debugging-csrf-error-in-production/)

部署 Django 程序时的一个常见错误是 `403 Forbidden` ，通常由 CSRF 错误导致，文章介绍了导致这种错误的 7 种原因，并解读 Django 源码，详细梳理了它们的校验逻辑。

3、[对 Python 环境和包管理工具的公正分析](https://alpopkes.com/posts/python/packaging_tools/)

Python 中的虚拟环境和包管理工具实在是太多了！但是应该如何选择最适合自己需求的工具呢？作者全面分析了 5 个类别的 10 多款工具，希望减少用户在抉择上的困惑。（附：作者针对此主题的两场演讲 [PyCon DE 2023](https://www.youtube.com/watch?v=MsJjzVIVs6M) 和 [EuroPython 2023](https://www.youtube.com/watch?v=3-drZY3u5vo)）

![Python环境和包管理工具的分类](https://img.pythoncat.top/venn_diagram.png)

4、[让我们一起创建一个 Python 调试器](https://mostlynerdless.de/blog/2023/09/20/lets-create-a-python-debugger-together-part-1/)

你是否好奇一个代码调试器是如何工作的？当设置断点后，程序触发它时会发生什么？调试器是程序员日常必备工具之一，但极少有人知道它是如何实现的。这是一个系列教程，已更新 5 篇文章。值得一提的是，作者使用了最新的 Python 3.12  PEP-669 功能。

5、[揭开 Python 3.12 的面纱：Python 世界有哪些新东西？](https://blog.jetbrains.com/pycharm/2023/11/python-3-12/)

Python 3.12 已发布一个半月，你开始尝鲜了么？这篇内容全面的文章重点解读了新的几个 PEP，让你对这个版本有更清晰的认识。

6、[Python 的哈希表指南](https://stackabuse.com/hash-tables-in-python/)

Python 的字典是一种“哈希表”，提供了高效灵活的数据存储和检索方法。文章介绍了这种数据结构及其工作原理，探讨了如何用 Python 实现哈希表并解决哈希冲突。这是一个系列文章，作者还写了堆、队列、栈、数组等数据结构的指南。

7、[运行不可信的 Python 代码](https://healeycodes.com/running-untrusted-python-code)

作者想自己实现一个简化版的不太安全的沙盒，文章介绍了它的运作方式，以及一些关键性问题的解决方案，即独立的进程 + `seccomp` + `setrlimit` 。（附：[如何安全运行别人上传的Python代码？](https://www.kingname.info/2023/11/11/python-run-other-code/) 这篇文章的方案是使用 Docker 的 Python SDK 来构建镜像，在 Docker 中执行代码）

8、[了解 Linux cp 命令并用 Python 编程实现](https://muhammadraza.me/2023/linux-cp/) 

深入探讨了 Linux 中 `cp` 命令的工作原理，然后用 Python 实现了一个基础版本。从中可以看到高级编程语言提供的强大功能和简单性。

9、[初学者应该用 Django，而不是 Flask](https://www.bitecode.dev/p/beginners-should-use-django-not-flask)

作者认为 Flask 虽然简单易用，但它可能会让初学者忽视 Web 开发的复杂性。Django 功能全面、生态系统成熟，更适合新手学习与提升生产力。

10、[PEP-733：对 Python 公共 C API 的评估](https://peps.python.org/pep-0733/)

一则信息型的 PEP，用于分享 C API 的信息，包括定义 C API 的用途、利益相关者及其使用场景和要求、C API 的优势、C API 的 9 项薄弱的问题。

11、[让我们做一个类 JSON 语法的解析器](https://arunmani.in/articles/silly-json-parser/)

作者出于编程乐趣的目的，定义了一组类似 JSON 的语法规则，然后使用 Python 逐一实现不同内容的提取与解析，开发了一个解析器。

12、[一门编程语言应该有多大？](https://tratt.net/laurie/blog/2023/how_big_should_a_programming_language_be.html)

在作者眼中，Python 1.5 是他能完全理解的最后一个版本，而之后的版本则使得语言越来越大。语言设计时添加新功能，如何权衡取舍？作者建议学习 C 语言的例子，让语言处于“最小进化”模式。

🎁**PyCon China 2023**🎁今年国内 PyCon 将于 12 月在北京、上海、成都、杭州、重庆、深圳、广州联动举办。现在购票可享 7 折优惠：[详情介绍](https://mp.weixin.qq.com/s/lfrFoIiNuUYzgXPklQPLmg)

## 🐿️项目&资源

1、[CogVLM：多模态预训练模型](https://github.com/THUDM/CogVLM)

一个强大的开源可视化语言模型 （VLM），CogVLM-17B 有 100 亿个视觉参数和 70 亿个语言参数，具有高性能，在多项跨模态基准测试中排名领先。（star 2.1K）

![CogVLM在基准测试中的得分](https://img.pythoncat.top/metrics-min.png)

2、[movis：用于生成与编辑视频的库](https://github.com/rezoo/movis)

让你通过 Python 代码生成各类视频，包括但不限于演示视频、动态图形、着色器艺术编码和游戏解说视频。支持视频编辑、音频剪辑、图层转换及添加特效等。

3、[mirror：基于摄像头内容，实时回答问题](https://github.com/cocktailpeanut/mirror)

这是一个 Web APP，可将摄像头视频流传给 AI，让它分析内容并实时回答你提出的问题。100% 本地和私有，Web UI 是用 [gradio](https://www.gradio.app/) 构建，多模态 AI 模型是 [Bakllava](https://huggingface.co/SkunkworksAI/BakLLaVA-1) 。

4、[vimGPT：使用 GPT-4V 和 Vimium 浏览网页](https://github.com/ishan0102/vimGPT)

**Vimium** 是一个 Chrome 插件，可让你仅用键盘浏览网页，借助它，可以不将浏览器 DOM 传给大模型，仅用 GPT-4V 的视觉功能来浏览网页。（star 1.8K）

![使用 GPT-4V 和 Vimium 浏览网页](https://img.pythoncat.top/2023-11-18_vimGPT.png)

5、[twitter_user_tweet_crawler：无需调用 Twitter API，爬取用户推文](https://github.com/kaixinol/twitter_user_tweet_crawler)

使用 selenium 模拟浏览器操作，可抓取用户推文并保存静态资源到本地，无需调用 Twitter API。（投稿自@kaixinol）

6、[RSS-OPML-to-Markdown：将 OPML 文件转化为易读的 Markdown 格式](https://github.com/AboutRSS/RSS-OPML-to-Markdown)

经常有人分享自己 RSS 列表导出的 OPML 文件，但这难以阅读也不宜直接拿去导入自己的阅读器。这个项目将 RSS 源的概要和一些统计信息输出成 markdown 表格，方便你按需订阅。（投稿自@AboutRSS）

7、[MyHeyGen：视频翻译工具](https://github.com/AIFSH/MyHeyGen)

一个平民版视频翻译工具，音频翻译、翻译校正、视频唇纹合成全流程解决方案。

8、[awesome-python-repo-stats：统计“awesome-python”列表中项目的信息](https://github.com/emanuelef/awesome-python-repo-stats)

[awesome-python](https://github.com/vinta/awesome-python) 是一个拥有 187K star 超火爆的项目，收录了大量框架、库、软件和资源。这个项目是对它收录内容的统计分析，每日更新，可在线查看统计表。

9、[outlines：引导式文本生成](https://github.com/outlines-dev/outlines)

一个用于生成神经文本的库，可视为 transformers 库中 `generate` 方法的替代品。（star 3.3K）

10、[marimo：下一代 Python notebook](https://github.com/marimo-team/marimo)

全新的 notebook 项目，其每个 notebook 都可作为交互式 Web 程序共享，可浏览数据、运行实验、构建工具和部署应用。

![marimo使用演示](https://img.pythoncat.top/2023-11-18_marimo.png)

11、[Finance：150+ 量化金融 Python 程序](https://github.com/shashankvemuri/Finance)

一个资源集合项目，帮助你收集、操纵和分析股市数据。（star 1.2K）

12、[tacticalrmm：一个远程监控和管理工具](https://github.com/amidaware/tacticalrmm)

一个远程监控和管理工具，使用 Django、Vue 和 Go 构建。类似 Teamviewer 的远程桌面控制、远程文件传输、远程执行命令和脚本、查看日志、告警管理、支持自动化。（star 2.3K）

## 🐢播客&视频

1、[CPython 的 JIT 编译器](https://www.youtube.com/watch?v=HxSHIpEQRjs)

Guido 本周在 X 上分享了这则视频，视频作者介绍了他们规划给 Python 3.13 开发一个 JIT 编译器！（附：[演讲视频的文稿](https://github.com/brandtbucher/brandtbucher/blob/master/2023/10/10/a_jit_compiler_for_cpython.pdf)）

2、[The Python Show 第 21 期：Sanic - 异步 Web 框架](https://www.blog.pythonlibrary.org/2023/11/10/episode-21-sanic-the-async-python-web-framework/)

Sanic 是支持异步编程的 Python Web 框架，能够快速构建和运行。这期播客的嘉宾是 Sanic 的维护者之一，话题包括 Web 框架对比、消息规范、[Mayim](https://github.com/ahopkins/mayim)（单向 ORM）。

本文首发于：[https://pythoncat.top/posts/2023-11-18-weekly](https://pythoncat.top/posts/2023-11-18-weekly)

## 🐼欢迎订阅

- [微信公众号](https://img.pythoncat.top/python_cat.jpg)：除更新周刊外，还发布其它原创作品，并转载一些优质文章。（可加好友，可加读者交流群）
- [博客](https://pythoncat.top) 及 [RSS](https://pythoncat.top/rss.xml)：我的独立博客，上面有历年原创/翻译的技术文章，以及从 2009 年以来的一些随笔。
- [Github](https://github.com/chinesehuazhou/python-weekly)：你可以获取本周刊的 Markdown 源文件，做任何想做的事！
- [邮件](https://pythoncat.substack.com)：在 Substack 上开通的频道，满足你通过邮件阅读时事通讯的诉求。
- [Telegram](https://t.me/pythontrendingweekly)：除了发布周刊的通知外，我将它视为一个“副刊”，补充发布更加丰富的资讯。
- [Twitter](https://twitter.com/chinesehuazhou)：我的关注列表里有大量 Python 相关的开发者与组织的账号。
